#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*PresensService test client*

:details: PresensService:
    This is a Presens MCR Service

:file:    PresensService_testclient.py
:authors: Lukas Bromig

:date: (creation)          2021-05-17T10:13:21.675531
:date: (last modification) 2021-05-17T10:13:21.675531

.. note:: Code generated by sila2codegenerator 0.3.6

_______________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

# import general packages
import logging
import argparse
import time
import datetime

# import meta packages
from typing import Union, Optional

# import SiLA client module
from PresensService_client import PresensServiceClient


def parse_command_line():
    """
    Just looking for command line arguments
    """
    parser = argparse.ArgumentParser(
        description="A SiLA2 test client for: PresensService")

    # connection parameters
    parser.add_argument('-i', '--server-ip-address', action='store', default='127.0.0.1',
                        help='SiLA server IP address')
    parser.add_argument('--server-hostname', action='store', default='localhost',
                        help='SiLA server hostname')
    parser.add_argument('-p', '--server-port', action='store', default=50002,
                        help='SiLA server port')

    # encryption
    parser.add_argument('-X', '--encryption', action='store', default='sila2_server',
                        help='The name of the private key and certificate file (without extension).')
    parser.add_argument('--encryption-key', action='store', default=None,
                        help='The name of the encryption key (*with* extension). Can be used if key and certificate '
                             'vary or non-standard file extensions are used.')
    parser.add_argument('--encryption-cert', action='store', default=None,
                        help='The name of the encryption certificate (*with* extension). Can be used if key and '
                             'certificate vary or non-standard file extensions are used.')

    parser.add_argument('-v', '--version', action='version',
                        version='%(prog)s ' + __version__)

    return parser.parse_args()


if __name__ == '__main__':
    # or use logging.INFO (=20) or logging.ERROR (=30) for less output
    logging.basicConfig(
        format='%(levelname)-8s| %(module)s.%(funcName)s: %(message)s', level=logging.DEBUG)

    parsed_args = parse_command_line()

    # start the client
    sila_client = PresensServiceClient(server_ip=parsed_args.server_ip_address,
                                        server_port=int(parsed_args.server_port))
    sila_client.run()

    # Log connection info
    logging.info(
        (
            f'Connected to SiLA Server {sila_client.server_display_name} running in version {sila_client.server_version}.' '\n'
            f'Service description: {sila_client.server_description}'
        )
    )

    # TODO:
    #   Uncomment the calls you would like to test and remove type hints (given only for orientation) or
    #   write your further function calls here to run the client as a standalone application.

    # ------------- command calls -------------------

    # ----- DeviceService 
    # results = sila_client.deviceService_client.GetLog(EmptyParameter: bytes = b'')
    # print("GetLog res: ", results)
    
    # results = sila_client.deviceService_client.GetReport(EmptyParameter: bytes = b'')
    # print("GetReport res: ", results)
    
    # results = sila_client.deviceService_client.GetTComp(EmptyParameter: bytes = b'')
    # print("GetTComp res: ", results)
    
    # results = sila_client.deviceService_client.SetTComp(SetTComp: float = [1.0])
    # print("SetTComp res: ", results)
    
    # results = sila_client.deviceService_client.GetDynAveraging(EmptyParameter: bytes = b'')
    # print("GetDynAveraging res: ", results)
    
    # results = sila_client.deviceService_client.SetDynAveraging(SetDynAverage: float = [1.0])
    # print("SetDynAveraging res: ", results)
    
    # results = sila_client.deviceService_client.SwitchOffDevice(EmptyParameter: bytes = b'')
    # print("SwitchOffDevice res: ", results)
    
    # ----- CalibrationService 
    # results = sila_client.calibrationService_client.GetO2CalLow(EmptyParameter: bytes = b'')
    # print("GetO2CalLow res: ", results)
    
    # results = sila_client.calibrationService_client.SetO2CalLow(SetO2CalLow: float = [1.0])
    # print("SetO2CalLow res: ", results)
    
    # results = sila_client.calibrationService_client.GetO2CalHigh(EmptyParameter: bytes = b'')
    # print("GetO2CalHigh res: ", results)
    
    # results = sila_client.calibrationService_client.SetO2CalHigh(SetO2CalHigh: float = [1.0])
    # print("SetO2CalHigh res: ", results)
    
    # results = sila_client.calibrationService_client.GetO2CalTemp(EmptyParameter: bytes = b'')
    # print("GetO2CalTemp res: ", results)
    
    # results = sila_client.calibrationService_client.SetO2CalTemp(SetO2CalTemp: float = [1.0])
    # print("SetO2CalTemp res: ", results)
    
    # results = sila_client.calibrationService_client.GetPHImax(EmptyParameter: bytes = b'')
    # print("GetPHImax res: ", results)
    
    results = sila_client.calibrationService_client.SetPHImax([1.0, 2.3, 4, 5, 6, 5])
    #print("SetPHImax res: ", results)
    
    # results = sila_client.calibrationService_client.GetPHImin(EmptyParameter: bytes = b'')
    # print("GetPHImin res: ", results)
    
    results = sila_client.calibrationService_client.SetPHImin([1.0, 2.3, 4, 5, 6, 5])
    print("SetPHImin res: ", results)
    
    # results = sila_client.calibrationService_client.GetPHpH0(EmptyParameter: bytes = b'')
    # print("GetPHpH0 res: ", results)
    
    # results = sila_client.calibrationService_client.SetPHpH0(SetPHpH0: float = [1.0])
    # print("SetPHpH0 res: ", results)
    
    # results = sila_client.calibrationService_client.GetPHdpH(EmptyParameter: bytes = b'')
    # print("GetPHdpH res: ", results)
    
    # results = sila_client.calibrationService_client.SetPHdpH(SetPHdpH: float = [1.0])
    # print("SetPHdpH res: ", results)
    
    # results = sila_client.calibrationService_client.GetPHCalTemp(EmptyParameter: bytes = b'')
    # print("GetPHCalTemp res: ", results)
    
    # results = sila_client.calibrationService_client.SetPHCalTemp(SetPHCalTemp: float = [1.0])
    # print("SetPHCalTemp res: ", results)
    
    # ----- SensorProvider 
    # results = sila_client.sensorProvider_client.GetSingleO2(Channel: int = 1)
    # print("GetSingleO2 res: ", results)
    
    # results = sila_client.sensorProvider_client.GetSinglePH(Channel: int = 1)
    # print("GetSinglePH res: ", results)
    
    # results = sila_client.sensorProvider_client.GetAllO2(EmptyParameter: bytes = b'')
    # print("GetAllO2 res: ", results)
    
    # results = sila_client.sensorProvider_client.GetAllPH(EmptyParameter: bytes = b'')
    # print("GetAllPH res: ", results)
    

    # ------------- property calls -------------------

    # ----- DeviceService 
    # results = sila_client.deviceService_client.Subscribe_CurrentStatus()
    # print("CurrentStatus res: ", results)
    
    # ----- CalibrationService 
    # ----- SensorProvider 
    # results = sila_client.sensorProvider_client.Get_TotalChannels()
    # print("TotalChannels res: ", results)
    
    # results = sila_client.sensorProvider_client.Get_TotalBars()
    # print("TotalBars res: ", results)
    
    # results = sila_client.sensorProvider_client.Get_BarSensors()
    # print("BarSensors res: ", results)
    
    
