#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*PresensService client*

:details: PresensService:
    This is a Presens MCR Service

:file:    SensorProvider_client.py
:authors: Lukas Bromig

:date: (creation)          2021-05-17T10:13:20.898237
:date: (last modification) 2021-05-17T10:13:20.898237

.. note:: Code generated by sila2codegenerator 0.3.6

_______________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

# import general packages
import logging
import argparse
import grpc
import time
import datetime

# import meta packages
from typing import Union, Optional

# import SiLA2 library modules
from sila2lib.framework import SiLAFramework_pb2 as silaFW_pb2
from sila2lib.sila_client import SiLA2Client
from sila2lib.framework.std_features import SiLAService_pb2 as SiLAService_feature_pb2
from sila2lib.error_handling import client_err
#   Usually not needed, but - feel free to modify
# from sila2lib.framework.std_features import SimulationController_pb2 as SimController_feature_pb2

# import feature gRPC modules
# Import gRPC libraries of features
from sila2lib_implementations.Presens.PresensService.DeviceService.gRPC import DeviceService_pb2
from sila2lib_implementations.Presens.PresensService.DeviceService.gRPC import DeviceService_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Presens.PresensService.DeviceService.DeviceService_default_arguments import default_dict as DeviceService_default_dict
from sila2lib_implementations.Presens.PresensService.CalibrationService.gRPC import CalibrationService_pb2
from sila2lib_implementations.Presens.PresensService.CalibrationService.gRPC import CalibrationService_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Presens.PresensService.CalibrationService.CalibrationService_default_arguments import default_dict as CalibrationService_default_dict
from sila2lib_implementations.Presens.PresensService.SensorProvider.gRPC import SensorProvider_pb2
from sila2lib_implementations.Presens.PresensService.SensorProvider.gRPC import SensorProvider_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Presens.PresensService.SensorProvider.SensorProvider_default_arguments import default_dict as SensorProvider_default_dict


# noinspection PyPep8Naming, PyUnusedLocal
class SensorProviderClient:
    """
        This is a Presens MCR Service

    .. note:: For an example on how to construct the parameter or read the response(s) for command calls and properties,
              compare the default dictionary that is stored in the directory of the corresponding feature.
    """
    # The following variables will be filled when run() is executed
    #: Storage for the connected servers version
    server_version: str = ''
    #: Storage for the display name of the connected server
    server_display_name: str = ''
    #: Storage for the description of the connected server
    server_description: str = ''

    def __init__(self,
                 channel = None):
        """Class initialiser"""

        # Create stub objects used to communicate with the server
        self.SensorProvider_stub = \
            SensorProvider_pb2_grpc.SensorProviderStub(channel)

        # initialise class variables for server information storage
        self.server_version = ''
        self.server_display_name = ''
        self.server_description = ''

    def GetSingleO2(self, Channel: int = 1): # -> (SensorProvider):
        """
        Wrapper to call the unobservable command GetSingleO2 on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling GetSingleO2:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = SensorProvider_pb2.GetSingleO2_Parameters(
                                    Channel=silaFW_pb2.Integer(value=Channel)
                )
    
            response = self.SensorProvider_stub.GetSingleO2(parameter, metadata)
            logging.debug(f"GetSingleO2 response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def GetSinglePH(self, Channel: int = 1): # -> (SensorProvider):
        """
        Wrapper to call the unobservable command GetSinglePH on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling GetSinglePH:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = SensorProvider_pb2.GetSinglePH_Parameters(
                                    Channel=silaFW_pb2.Integer(value=Channel)
                )
    
            response = self.SensorProvider_stub.GetSinglePH(parameter, metadata)
            logging.debug(f"GetSinglePH response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def GetAllO2(self, EmptyParameter: bytes = b''): # -> (SensorProvider):
        """
        Wrapper to call the unobservable command GetAllO2 on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling GetAllO2:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = SensorProvider_pb2.GetAllO2_Parameters(
                                    
                )
    
            response = self.SensorProvider_stub.GetAllO2(parameter, metadata)
            logging.debug(f"GetAllO2 response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def GetAllPH(self, EmptyParameter: bytes = b''): # -> (SensorProvider):
        """
        Wrapper to call the unobservable command GetAllPH on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling GetAllPH:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = SensorProvider_pb2.GetAllPH_Parameters(
                                    
                )
    
            response = self.SensorProvider_stub.GetAllPH(parameter, metadata)
            logging.debug(f"GetAllPH response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    # Properties

    def Get_TotalChannels(self) -> SensorProvider_pb2.Get_TotalChannels_Responses:
        """Wrapper to get property TotalChannels from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property TotalChannels:")
        try:
            response = self.SensorProvider_stub.Get_TotalChannels(
                SensorProvider_pb2.Get_TotalChannels_Parameters()
            )
            logging.debug(
                'Get_TotalChannels response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def Get_TotalBars(self) -> SensorProvider_pb2.Get_TotalBars_Responses:
        """Wrapper to get property TotalBars from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property TotalBars:")
        try:
            response = self.SensorProvider_stub.Get_TotalBars(
                SensorProvider_pb2.Get_TotalBars_Parameters()
            )
            logging.debug(
                'Get_TotalBars response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def Get_BarSensors(self) -> SensorProvider_pb2.Get_BarSensors_Responses:
        """Wrapper to get property BarSensors from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property BarSensors:")
        try:
            response = self.SensorProvider_stub.Get_BarSensors(
                SensorProvider_pb2.Get_BarSensors_Parameters()
            )
            logging.debug(
                'Get_BarSensors response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    

    @staticmethod
    def grpc_error_handling(error_object: grpc.Call) -> None:
        """Handles exceptions of type grpc.RpcError"""
        # pass to the default error handling
        grpc_error = client_err.grpc_error_handling(error_object=error_object)

        logging.error(grpc_error.error_type)
        if hasattr(grpc_error.message, "parameter"):
            logging.error(grpc_error.message.parameter)
        logging.error(grpc_error.message.message)
        

