"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Device Controller*

:details: DeviceController:
    Allows full control of the stirrer speed and power. Starts and stops the stirrer of the bioREACTOR48.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 14.02.2020

:file:    DeviceController_real.py
:authors: Lukas Bromig

:date: (creation)          2020-02-17T16:11:25.109298
:date: (last modification) 2020-02-17T16:11:25.109298

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import time         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import DeviceController_pb2 as DeviceController_pb2
# from .gRPC import DeviceController_pb2_grpc as DeviceController_pb2_grpc

# import default arguments
from .DeviceController_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class DeviceControllerReal:
    """
    Implementation of the *Device Controller* in *Real* mode
        This is a Presens MCR Service
    """

    def __init__(self, ser, properties):
        """Class initializer"""
        self.ser = ser
        self.TotalChannels = properties.TotalChannels
        self.TotalBars = properties.TotalBars
        self.BarSensors = properties.BarSensors
        logging.debug('Started server in mode: {mode}'.format(mode='Real'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def GetReport(self, request, context: grpc.ServicerContext) \
            -> DeviceController_pb2.GetReport_Responses:
        """
        Executes the unobservable command "Get Report"
            Get a full device report.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentReport (Current Report): The current report response.
        """
    
        # initialise the return value
        return_value = None

        repo_command = 'repo\r'
        j: int = 0
        try:
            report = ''
            for j in range(0, self.TotalBars, 1):
                self.ser[j].write(str.encode(repo_command))
                tmp = str(bytes.decode(self.ser[j].readline().rstrip()))
                report = report + tmp + ';'
            par_dict = {'CurrentReport': silaFW_pb2.String(value=report)}
            time.sleep(0.2)
            return_value = DeviceController_pb2.GetReport_Responses(**par_dict)
            logging.debug('Executed command GetReport in mode: {mode} with response: {response}'
                          .format(mode='Real', response=report))
        except ConnectionError:
            logging.exception('Communication failed executing the command: {command} with bar: {Bar}'
                              .format(command=repo_command, Bar=j))
            time.sleep(0.2)

        # fallback to default
        if return_value is None:
            return_value = DeviceController_pb2.GetReport_Responses(
                **default_dict['GetReport_Responses']
            )
    
        return return_value

    def GetTComp(self, request, context: grpc.ServicerContext) \
            -> DeviceController_pb2.GetTComp_Responses:
        """
        Executes the unobservable command "Get Temperature Compensation"
            Get the temperature compensation value.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTComp (Current Temperature Compensation): The current temperature compensation value.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Real for command GetTComp here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = DeviceController_pb2.GetTComp_Responses(
                **default_dict['GetTComp_Responses']
            )
    
        return return_value

    def SetTComp(self, request, context: grpc.ServicerContext) \
            -> DeviceController_pb2.SetTComp_Responses:
        """
        Executes the unobservable command "Set Temperature Compensation"
            Set the temperature compensation value. Values must be between 0-60 degrees Celsius. Default = 20.
    
        :param request: gRPC request containing the parameters passed:
            request.SetTComp (SetTComp):
            The temperature compensation value to be set.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTComp (Current Temperature Compensation): The current temperature compensation value.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Real for command SetTComp here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = DeviceController_pb2.SetTComp_Responses(
                **default_dict['SetTComp_Responses']
            )
    
        return return_value

    def GetDynAveraging(self, request, context: grpc.ServicerContext) \
            -> DeviceController_pb2.GetDynAveraging_Responses:
        """
        Executes the unobservable command "Get Dynamic Averaging"
            Get the dynamic averaging value.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDynAverage (Current Dynamic Average): The current dynamic averaging value.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Real for command GetDynAveraging here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = DeviceController_pb2.GetDynAveraging_Responses(
                **default_dict['GetDynAveraging_Responses']
            )
    
        return return_value

    def SetDynAveraging(self, request, context: grpc.ServicerContext) \
            -> DeviceController_pb2.SetDynAveraging_Responses:
        """
        Executes the unobservable command "Set Dynamic Averaging"
            Set the dynamic averaging value.
    
        :param request: gRPC request containing the parameters passed:
            request.SetDynAverage (Set Dynamic Average):
            The dynamic averaging value to be set. Must be between 0-9. Default = 4.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDynAverage (Current Dynamic Average): The current dynamic average value.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Real for command SetDynAveraging here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = DeviceController_pb2.SetDynAveraging_Responses(
                **default_dict['SetDynAveraging_Responses']
            )
    
        return return_value

    def SwitchOffDevice(self, request, context: grpc.ServicerContext) \
            -> DeviceController_pb2.SwitchOffDevice_Responses:
        """
        Executes the unobservable command "Switch Off Device"
            Switch off the device to save power.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentStatus (Current Status): The current stop status response.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Real for command SwitchOffDevice here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = DeviceController_pb2.SwitchOffDevice_Responses(
                **default_dict['SwitchOffDevice_Responses']
            )
    
        return return_value
