"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Device Controller*

:details: DeviceController:
    Allows full control of the stirrer speed and power. Starts and stops the stirrer of the bioREACTOR48.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 14.02.2020
           
:file:    DeviceController_servicer.py
:authors: Lukas Bromig

:date: (creation)          2020-02-17T16:11:25.102766
:date: (last modification) 2020-02-17T16:11:25.102766

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import DeviceController_pb2 as DeviceController_pb2
from .gRPC import DeviceController_pb2_grpc as DeviceController_pb2_grpc

# import simulation and real implementation
from .DeviceController_simulation import DeviceControllerSimulation
from .DeviceController_real import DeviceControllerReal


class DeviceController(DeviceController_pb2_grpc.DeviceControllerServicer):
    """
    This is a Presens MCR Service
    """
    implementation: Union[DeviceControllerSimulation, DeviceControllerReal]
    simulation_mode: bool

    def __init__(self, ser, properties, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.properties = properties
        self.lock =properties.lock
        self.ser = ser
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(DeviceControllerSimulation(self.properties))
        else:
            self._inject_implementation(DeviceControllerReal(self.ser, self.properties))

    def _inject_implementation(self,
                               implementation: Union[DeviceControllerSimulation,
                                                     DeviceControllerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the PresensServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(DeviceControllerSimulation(self.properties))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(DeviceControllerReal(self.ser, self.properties))

    def GetReport(self, request, context: grpc.ServicerContext) \
            -> DeviceController_pb2.GetReport_Responses:
        """
        Executes the unobservable command "Get Report"
            Get a full device report.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentReport (Current Report): The current report response.
        """
    
        logging.debug(
            "GetReport called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            self.lock.acquire()
            return self.implementation.GetReport(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def GetTComp(self, request, context: grpc.ServicerContext) \
            -> DeviceController_pb2.GetTComp_Responses:
        """
        Executes the unobservable command "Get Temperature Compensation"
            Get the temperature compensation value.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTComp (Current Temperature Compensation): The current temperature compensation value.
        """
    
        logging.debug(
            "GetTComp called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            self.lock.acquire()
            return self.implementation.GetTComp(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def SetTComp(self, request, context: grpc.ServicerContext) \
            -> DeviceController_pb2.SetTComp_Responses:
        """
        Executes the unobservable command "Set Temperature Compensation"
            Set the temperature compensation value. Values must be between 0-60 degrees Celsius. Default = 20.
    
        :param request: gRPC request containing the parameters passed:
            request.SetTComp (SetTComp):
            The temperature compensation value to be set.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTComp (Current Temperature Compensation): The current temperature compensation value.
        """
    
        logging.debug(
            "SetTComp called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            self.lock.acquire()
            return self.implementation.SetTComp(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def GetDynAveraging(self, request, context: grpc.ServicerContext) \
            -> DeviceController_pb2.GetDynAveraging_Responses:
        """
        Executes the unobservable command "Get Dynamic Averaging"
            Get the dynamic averaging value.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDynAverage (Current Dynamic Average): The current dynamic averaging value.
        """
    
        logging.debug(
            "GetDynAveraging called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            self.lock.acquire()
            return self.implementation.GetDynAveraging(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def SetDynAveraging(self, request, context: grpc.ServicerContext) \
            -> DeviceController_pb2.SetDynAveraging_Responses:
        """
        Executes the unobservable command "Set Dynamic Averaging"
            Set the dynamic averaging value.
    
        :param request: gRPC request containing the parameters passed:
            request.SetDynAverage (Set Dynamic Average):
            The dynamic averaging value to be set. Must be between 0-9. Default = 4.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDynAverage (Current Dynamic Average): The current dynamic average value.
        """
    
        logging.debug(
            "SetDynAveraging called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            self.lock.acquire()
            return self.implementation.SetDynAveraging(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def SwitchOffDevice(self, request, context: grpc.ServicerContext) \
            -> DeviceController_pb2.SwitchOffDevice_Responses:
        """
        Executes the unobservable command "Switch Off Device"
            Switch off the device to save power.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentStatus (Current Status): The current stop status response.
        """
    
        logging.debug(
            "SwitchOffDevice called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            self.lock.acquire()
            return self.implementation.SwitchOffDevice(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()
    
