#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*PresensService client*

:details: PresensService:
    This is a Presens MCR Service

:file:    PresensService_client.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:35.520001
:date: (last modification) 2020-04-16T10:19:35.520001

.. note:: Code generated by sila2codegenerator 0.2.0

_______________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

# import general packages
import logging
import argparse
import grpc
import time

# import meta packages
from typing import Union, Optional

# import SiLA2 library modules
from sila2lib.framework import SiLAFramework_pb2 as silaFW_pb2
from sila2lib.sila_client import SiLA2Client
from sila2lib.framework.std_features import SiLAService_pb2 as SiLAService_feature_pb2
from sila2lib.error_handling import client_err
#   Usually not needed, but - feel free to modify
# from sila2lib.framework.std_features import SimulationController_pb2 as SimController_feature_pb2

# import feature gRPC modules
# Import gRPC libraries of features
from sila2lib_implementations.Presens.PresensService.DeviceServicer.gRPC import DeviceServicer_pb2
from sila2lib_implementations.Presens.PresensService.DeviceServicer.gRPC import DeviceServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Presens.PresensService.DeviceServicer.DeviceServicer_default_arguments \
    import default_dict as DeviceServicer_default_dict
from sila2lib_implementations.Presens.PresensService.CalibrationServicer.gRPC import CalibrationServicer_pb2
from sila2lib_implementations.Presens.PresensService.CalibrationServicer.gRPC import CalibrationServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Presens.PresensService.CalibrationServicer.CalibrationServicer_default_arguments \
    import default_dict as CalibrationServicer_default_dict
from sila2lib_implementations.Presens.PresensService.SensorProvider.gRPC import SensorProvider_pb2
from sila2lib_implementations.Presens.PresensService.SensorProvider.gRPC import SensorProvider_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Presens.PresensService.SensorProvider.SensorProvider_default_arguments \
    import default_dict as SensorProvider_default_dict


# noinspection PyPep8Naming, PyUnusedLocal
class PresensServiceClient(SiLA2Client):
    """
        This is a Presens MCR Service

    .. note:: For an example on how to construct the parameter or read the response(s) for command calls and properties,
              compare the default dictionary that is stored in the directory of the corresponding feature.
    """
    # The following variables will be filled when run() is executed
    #: Storage for the connected servers version
    server_version: str = ''
    #: Storage for the display name of the connected server
    server_display_name: str = ''
    #: Storage for the description of the connected server
    server_description: str = ''

    def __init__(self,
                 name: str = "PresensServiceClient", description: str = "This is a Presens MCR Service",
                 server_name: Optional[str] = None,
                 client_uuid: Optional[str] = None,
                 version: str = __version__,
                 vendor_url: str = "",
                 server_hostname: str = "localhost", server_ip: str = "127.0.0.1", server_port: int = 50001,
                 cert_file: Optional[str] = None):
        """Class initialiser"""
        super().__init__(
            name=name, description=description,
            server_name=server_name,
            client_uuid=client_uuid,
            version=version,
            vendor_url=vendor_url,
            server_hostname=server_hostname, server_ip=server_ip, server_port=server_port,
            cert_file=cert_file
        )

        logging.info(
            "Starting SiLA2 service client for service PresensService with service name: {server_name}".format(
                server_name=name
            )
        )

        # Create stub objects used to communicate with the server
        self.DeviceServicer_stub = \
            DeviceServicer_pb2_grpc.DeviceServicerStub(self.channel)
        self.CalibrationServicer_stub = \
            CalibrationServicer_pb2_grpc.CalibrationServicerStub(self.channel)
        self.SensorProvider_stub = \
            SensorProvider_pb2_grpc.SensorProviderStub(self.channel)

        # initialise class variables for server information storage
        self.server_version = ''
        self.server_display_name = ''
        self.server_description = ''

        # Pull device properties
        self.TotalChannels = self.SensorProvider_stub.Get_TotalChannels(
            SensorProvider_pb2.Get_TotalChannels_Parameters()
        ).TotalChannels.value
        self.TotalBars = self.SensorProvider_stub.Get_TotalBars(
            SensorProvider_pb2.Get_TotalBars_Parameters()
        ).TotalBars.value
        self.BarSensors = self.SensorProvider_stub.Get_BarSensors(
            SensorProvider_pb2.Get_BarSensors_Parameters()
        ).BarSensors.value

    def Get_ImplementedFeatures(self):
        """Get a list of all implemented features."""
        # type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Retrieving the list of implemented features of the server:")
        try:
            response = self.SiLAService_stub.Get_ImplementedFeatures(
                SiLAService_feature_pb2.Get_ImplementedFeatures_Parameters()
            )
            for feature_id in response.ImplementedFeatures:
                logging.debug("Implemented feature: {feature_id}".format(
                    feature_id=feature_id.value)
                    )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

        return response.ImplementedFeatures

    def Get_FeatureDefinition(self, feature_identifier: str) -> Union[str, None]:
        """
        Returns the FDL/XML feature definition of the given feature.

        :param feature_identifier: The name of the feature for which the definition should be returned.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Requesting feature definitions of feature {feature_identifier}:".format(
            feature_identifier=feature_identifier)
        )
        try:
            response = self.SiLAService_stub.GetFeatureDefinition(
                SiLAService_feature_pb2.GetFeatureDefinition_Parameters(
                    QualifiedFeatureIdentifier=silaFW_pb2.String(value=feature_identifier)
                    )
                )
            logging.debug("Response of GetFeatureDefinition for {feature_identifier} feature: {response}".format(
                response=response,
                feature_identifier=feature_identifier)
            )
            return response
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

    def run(self) -> bool:
        """
        Starts the actual client and retrieves the meta-information from the server.

        :returns: True or False whether the connection to the server is established.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        try:
            # Retrieve the basic server information and store it in internal class variables
            #   Display name
            response = self.SiLAService_stub.Get_ServerName(SiLAService_feature_pb2.Get_ServerName_Parameters())
            self.server_display_name = response.ServerName.value
            logging.debug("Display name: {name}".format(name=response.ServerName.value))
            # Server description
            response = self.SiLAService_stub.Get_ServerDescription(
                SiLAService_feature_pb2.Get_ServerDescription_Parameters()
            )
            self.server_description = response.ServerDescription.value
            logging.debug("Description: {description}".format(description=response.ServerDescription.value))
            # Server version
            response = self.SiLAService_stub.Get_ServerVersion(SiLAService_feature_pb2.Get_ServerVersion_Parameters())
            self.server_version = response.ServerVersion.value
            logging.debug("Version: {version}".format(version=response.ServerVersion.value))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return False

        return True

    def stop(self, force: bool = False) -> bool:
        """
        Stop SiLA client routine

        :param force: If set True, the client is supposed to disconnect and stop immediately. Otherwise it can first try
                      to finish what it is doing.

        :returns: Whether the client could be stopped successfully or not.
        """
        # TODO: Implement all routines that have to be executed when the client is stopped.
        #   Feel free to use the "force" parameter to abort any running processes. Or crash your machine. Your call!
        return True

    def DeviceServicer_GetLog(self,
                              parameter: DeviceServicer_pb2.GetLog_Parameters = None) \
            -> silaFW_pb2.CommandConfirmation:
        """
        Wrapper to call the observable command GetLog on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A command confirmation object with the following information:
            commandExecutionUUID: A command id with which this observable command can be referenced in future calls
            lifetimeOfExecution (optional): The (maximum) lifetime of this command call.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetLog:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.GetLog_Parameters(
                    **DeviceServicer_default_dict['GetLog_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetLog(parameter)
    
            logging.debug('GetLog response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetLog_Info(self,
                                   uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) \
            -> silaFW_pb2.ExecutionInfo:
        """
        Wrapper to get an intermediate response for the observable command GetLog on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the status information that has been defined for this command. The following fields
                  are defined:
                    * *commandStatus*: Status of the command (enumeration)
                    * *progressInfo*: Information on the progress of the command (0 to 1)
                    * *estimatedRemainingTime*: Estimate of the remaining time required to run the command
                    * *updatedLifetimeOfExecution*: An update on the execution lifetime
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        logging.debug(
            "Requesting status information for command GetLog (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
        try:
            response = self.DeviceServicer_stub.GetLog_Info(uuid)
            logging.debug('GetLog status information: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetLog_Result(self,
                                     uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) \
            -> DeviceServicer_pb2.GetLog_Responses:
        """
        Wrapper to get an intermediate response for the observable command GetLog on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the result response that has been defined for this command.
    
        .. note:: Whether the result is available or not can and should be evaluated by calling the
                  :meth:`GetLog_Info` method of this call.
        """
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        logging.debug(
            "Requesting status information for command GetLog (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
    
        try:
            response = self.DeviceServicer_stub.GetLog_Result(uuid)
            logging.debug('GetLog result response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetReport(self,
                                 parameter: DeviceServicer_pb2.GetReport_Parameters = None) \
            -> DeviceServicer_pb2.GetReport_Responses:
        """
        Wrapper to call the unobservable command GetReport on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetReport:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.GetReport_Parameters(
                    **DeviceServicer_default_dict['GetReport_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetReport(parameter)
    
            logging.debug('GetReport response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetTComp(self,
                                parameter: DeviceServicer_pb2.GetTComp_Parameters = None) \
            -> DeviceServicer_pb2.GetTComp_Responses:
        """
        Wrapper to call the unobservable command GetTComp on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetTComp:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.GetTComp_Parameters(
                    **DeviceServicer_default_dict['GetTComp_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetTComp(parameter)
    
            logging.debug('GetTComp response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_SetTComp(self, SetTComp_List) \
            -> DeviceServicer_pb2.SetTComp_Responses:
        """
        Wrapper to call the unobservable command SetTComp on the server.
    
        :param SetTComp_List: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Calling SetTComp:")
        # input list:
        # SetTComp = [20,20,20,20,20,20,20,20,20,20,20,20,
        # 20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
        # 20,20,20,20,20,20,20,20,20,20,20,20] (48x20 or other)
        par_dict: dict = {}
        if len(SetTComp_List) != self.TotalChannels:
            logging.error('Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                          '{RequiredLength}'.format(CurrentLength=len(SetTComp_List),
                                                    RequiredLength=self.TotalChannels))
        else:
            par_dict = {
                'SetTComp': []
            }
            for i, SetTComp in enumerate(SetTComp_List):
                par_dict['SetTComp'].append(silaFW_pb2.Real(value=SetTComp))
        try:
            parameter = DeviceServicer_pb2.SetTComp_Parameters(**par_dict)
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.SetTComp_Parameters(
                    **DeviceServicer_default_dict['SetTComp_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetTComp(parameter)
    
            logging.debug('SetTComp response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetDynAveraging(self,
                                       parameter: DeviceServicer_pb2.GetDynAveraging_Parameters = None) \
            -> DeviceServicer_pb2.GetDynAveraging_Responses:
        """
        Wrapper to call the unobservable command GetDynAveraging on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetDynAveraging:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.GetDynAveraging_Parameters(
                    **DeviceServicer_default_dict['GetDynAveraging_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetDynAveraging(parameter)
    
            logging.debug('GetDynAveraging response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_SetDynAveraging(self, SetDynAveraging_List) \
            -> DeviceServicer_pb2.SetDynAveraging_Responses:
        """
        Wrapper to call the unobservable command SetDynAveraging on the server.
    
        :param SetDynAveraging_List: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDynAveraging:")
        # input list:
        # SetDynAveraging_List = [4,4,4,4,4,4] A setting between 0-9 for each in self.TotalBars
        par_dict: dict = {}
        if len(SetDynAveraging_List) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                '{RequiredLength}'.format(CurrentLength=len(SetDynAveraging_List), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetDynAverage': []
            }

            for i, SetDynAverage in enumerate(SetDynAveraging_List):
                par_dict['SetDynAverage'].append(silaFW_pb2.Real(value=SetDynAverage))
            
        try:
            parameter = DeviceServicer_pb2.SetDynAveraging_Parameters(**par_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetDynAveraging_Parameters(
                    **DeviceServicer_default_dict['SetDynAveraging_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetDynAveraging(parameter)
    
            logging.debug('SetDynAveraging response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_SwitchOffDevice(self,
                                       parameter: DeviceServicer_pb2.SwitchOffDevice_Parameters = None) \
            -> DeviceServicer_pb2.SwitchOffDevice_Responses:
        """
        Wrapper to call the unobservable command SwitchOffDevice on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SwitchOffDevice:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.SwitchOffDevice_Parameters(
                    **DeviceServicer_default_dict['SwitchOffDevice_Parameters']
                )
    
            response = self.DeviceServicer_stub.SwitchOffDevice(parameter)
    
            logging.debug('SwitchOffDevice response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def CalibrationServicer_GetO2CalLow(self,
                                        parameter: CalibrationServicer_pb2.GetO2CalLow_Parameters = None) \
            -> CalibrationServicer_pb2.GetO2CalLow_Responses:
        """
        Wrapper to call the unobservable command GetO2CalLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetO2CalLow:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetO2CalLow_Parameters(
                    **CalibrationServicer_default_dict['GetO2CalLow_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetO2CalLow(parameter)
    
            logging.debug('GetO2CalLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def CalibrationServicer_SetO2CalLow(self, SetO2CalLow_List) \
            -> CalibrationServicer_pb2.SetO2CalLow_Responses:
        """
        Wrapper to call the unobservable command SetO2CalLow on the server.
    
        :param SetO2CalLow_List: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
        response = None
        logging.debug("Calling SetO2CalLow:")
        # Input list:
        # SetO2CalLow_List = [57,57,57,57,57,57] A setting between 0-90 for each in self.TotalBars
        par_dict: dict = {}
        if len(SetO2CalLow_List) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                '{RequiredLength}'.format(CurrentLength=len(SetO2CalLow_List), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetO2CalLow': []
            }
            for i, SetO2CalLow in enumerate(SetO2CalLow_List):
                par_dict['SetO2CalLow'].append(silaFW_pb2.Real(value=SetO2CalLow))

            try:
                parameter = CalibrationServicer_pb2.SetO2CalLow_Parameters(**par_dict)
                if parameter is None:
                    parameter = CalibrationServicer_pb2.SetO2CalLow_Parameters(
                        **CalibrationServicer_default_dict['SetO2CalLow_Parameters']
                    )

                response = self.CalibrationServicer_stub.SetO2CalLow(parameter)

                logging.debug('SetO2CalLow response: {response}'.format(response=response))
            except grpc.RpcError as grpc_err:
                self.grpc_error_handling(grpc_err)
                return None
    
        return response
    
    def CalibrationServicer_GetO2CalHigh(self,
                                         parameter: CalibrationServicer_pb2.GetO2CalHigh_Parameters = None) \
            -> CalibrationServicer_pb2.GetO2CalHigh_Responses:
        """
        Wrapper to call the unobservable command GetO2CalHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetO2CalHigh:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetO2CalHigh_Parameters(
                    **CalibrationServicer_default_dict['GetO2CalHigh_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetO2CalHigh(parameter)
    
            logging.debug('GetO2CalHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def CalibrationServicer_SetO2CalHigh(self, SetO2CalHigh_List) \
            -> CalibrationServicer_pb2.SetO2CalHigh_Responses:
        """
        Wrapper to call the unobservable command SetO2CalHigh on the server.
    
        :param SetO2CalHigh_List: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
        response = None
        logging.debug("Calling SetO2CalHigh:")
        # Input list:
        # SetO2CalLow_List = [27,27,27,27,27,27] A setting between 0-90 for each in self.TotalBars
        par_dict: dict = {}
        if len(SetO2CalHigh_List) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                '{RequiredLength}'.format(CurrentLength=len(SetO2CalHigh_List), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetO2CalHigh': []
            }
            for i, SetO2CalHigh in enumerate(SetO2CalHigh_List):
                par_dict['SetO2CalHigh'].append(silaFW_pb2.Real(value=SetO2CalHigh))

            try:
                parameter = CalibrationServicer_pb2.SetO2CalHigh_Parameters(**par_dict)
                if parameter is None:
                    parameter = CalibrationServicer_pb2.SetO2CalHigh_Parameters(
                        **CalibrationServicer_default_dict['SetO2CalHigh_Parameters']
                    )

                response = self.CalibrationServicer_stub.SetO2CalHigh(parameter)

                logging.debug('SetO2CalHigh response: {response}'.format(response=response))
            except grpc.RpcError as grpc_err:
                self.grpc_error_handling(grpc_err)
                return None
    
        return response
    
    def CalibrationServicer_GetO2CalTemp(self,
                                         parameter: CalibrationServicer_pb2.GetO2CalTemp_Parameters = None) \
            -> CalibrationServicer_pb2.GetO2CalTemp_Responses:
        """
        Wrapper to call the unobservable command GetO2CalTemp on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetO2CalTemp:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetO2CalTemp_Parameters(
                    **CalibrationServicer_default_dict['GetO2CalTemp_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetO2CalTemp(parameter)
    
            logging.debug('GetO2CalTemp response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def CalibrationServicer_SetO2CalTemp(self, SetO2CalTemp_List) \
            -> CalibrationServicer_pb2.SetO2CalTemp_Responses:
        """
        Wrapper to call the unobservable command SetO2CalTemp on the server.
    
        :param SetO2CalTemp_List: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
        response = None
        logging.debug("Calling SetO2CalTemp:")
        # Input list:
        # SetO2CalTemp_List = [20,20,20,20,20,20] A setting between -10-60 for each in self.TotalBars
        par_dict: dict = {}
        if len(SetO2CalTemp_List) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                '{RequiredLength}'.format(CurrentLength=len(SetO2CalTemp_List), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetO2CalTemp': []
            }
            for i, SetO2CalTemp in enumerate(SetO2CalTemp_List):
                par_dict['SetO2CalTemp'].append(silaFW_pb2.Real(value=SetO2CalTemp))
            try:
                parameter = CalibrationServicer_pb2.SetO2CalTemp_Parameters(**par_dict)
                if parameter is None:
                    parameter = CalibrationServicer_pb2.SetO2CalTemp_Parameters(
                        **CalibrationServicer_default_dict['SetO2CalTemp_Parameters']
                    )

                response = self.CalibrationServicer_stub.SetO2CalTemp(parameter)

                logging.debug('SetO2CalTemp response: {response}'.format(response=response))
            except grpc.RpcError as grpc_err:
                self.grpc_error_handling(grpc_err)
                return None
    
        return response
    
    def CalibrationServicer_GetPHlmax(self,
                                      parameter: CalibrationServicer_pb2.GetPHlmax_Parameters = None) \
            -> CalibrationServicer_pb2.GetPHlmax_Responses:
        """
        Wrapper to call the unobservable command GetPHlmax on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPHlmax:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetPHlmax_Parameters(
                    **CalibrationServicer_default_dict['GetPHlmax_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetPHlmax(parameter)
    
            logging.debug('GetPHlmax response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def CalibrationServicer_SetPHlmax(self, SetPHlmax_List) \
            -> CalibrationServicer_pb2.SetPHlmax_Responses:
        """
        Wrapper to call the unobservable command SetPHlmax on the server.
    
        :param SetPHlmax_List: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
        response = None
        logging.debug("Calling SetPHlmax:")
        # Input list:
        # SetPHlmax_List = [0,0,0,0,0,0] A setting between 0-90 for each in self.TotalBars
        par_dict: dict = {}
        if len(SetPHlmax_List) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                '{RequiredLength}'.format(CurrentLength=len(SetPHlmax_List), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetPHlmax': []
            }
            for i, SetPHlmax in enumerate(SetPHlmax_List):
                par_dict['SetPHlmax'].append(silaFW_pb2.Real(value=SetPHlmax))
            try:
                parameter = CalibrationServicer_pb2.SetPHlmax_Parameters(**par_dict)
                if parameter is None:
                    parameter = CalibrationServicer_pb2.SetPHlmax_Parameters(
                        **CalibrationServicer_default_dict['SetPHlmax_Parameters']
                    )

                response = self.CalibrationServicer_stub.SetPHlmax(parameter)

                logging.debug('SetPHlmax response: {response}'.format(response=response))
            except grpc.RpcError as grpc_err:
                self.grpc_error_handling(grpc_err)
                return None
    
        return response
    
    def CalibrationServicer_GetPHlmin(self,
                                      parameter: CalibrationServicer_pb2.GetPHlmin_Parameters = None) \
            -> CalibrationServicer_pb2.GetPHlmin_Responses:
        """
        Wrapper to call the unobservable command GetPHlmin on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPHlmin:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetPHlmin_Parameters(
                    **CalibrationServicer_default_dict['GetPHlmin_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetPHlmin(parameter)
    
            logging.debug('GetPHlmin response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def CalibrationServicer_SetPHlmin(self, SetPHlmin_List) \
            -> CalibrationServicer_pb2.SetPHlmin_Responses:
        """
        Wrapper to call the unobservable command SetPHlmin on the server.
    
        :param SetPHlmin_List: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
        response = None
        logging.debug("Calling SetPHlmin:")
        # Input list:
        # SetPHlmin_List = [0,0,0,0,0,0] A setting between 0-90 for each in self.TotalBars
        par_dict: dict = {}
        if len(SetPHlmin_List) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required:'
                '{RequiredLength}'.format(CurrentLength=len(SetPHlmin_List), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetPHlmin': []
            }
            for i, SetPHlmin in enumerate(SetPHlmin_List):
                par_dict['SetPHlmin'].append(silaFW_pb2.Real(value=SetPHlmin))

            try:
                parameter = CalibrationServicer_pb2.SetPHlmin_Parameters(**par_dict)
                if parameter is None:
                    parameter = CalibrationServicer_pb2.SetPHlmin_Parameters(
                        **CalibrationServicer_default_dict['SetPHlmin_Parameters']
                    )

                response = self.CalibrationServicer_stub.SetPHlmin(parameter)

                logging.debug('SetPHlmin response: {response}'.format(response=response))
            except grpc.RpcError as grpc_err:
                self.grpc_error_handling(grpc_err)
                return None
    
        return response
    
    def CalibrationServicer_GetPHpH0(self,
                                     parameter: CalibrationServicer_pb2.GetPHpH0_Parameters = None) \
            -> CalibrationServicer_pb2.GetPHpH0_Responses:
        """
        Wrapper to call the unobservable command GetPHpH0 on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPHpH0:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetPHpH0_Parameters(
                    **CalibrationServicer_default_dict['GetPHpH0_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetPHpH0(parameter)
    
            logging.debug('GetPHpH0 response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def CalibrationServicer_SetPHpH0(self, SetPHpH0_List) \
            -> CalibrationServicer_pb2.SetPHpH0_Responses:
        """
        Wrapper to call the unobservable command SetPHpH0 on the server.
    
        :param SetPHpH0_List: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
        response = None
        logging.debug("Calling SetPHpH0:")
        # Input list:
        # SetPHpH0_List = [0,0,0,0,0,0] A setting between 0-50 for each in self.TotalBars
        par_dict: dict = {}
        if len(SetPHpH0_List) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                '{RequiredLength}'.format(CurrentLength=len(SetPHpH0_List), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetPHpH0': []
            }
            for i, SetPHpH0 in enumerate(SetPHpH0_List):
                par_dict['SetPHpH0'].append(silaFW_pb2.Real(value=SetPHpH0))

            try:
                parameter = CalibrationServicer_pb2.SetPHpH0_Parameters(**par_dict)
                if parameter is None:
                    parameter = CalibrationServicer_pb2.SetPHpH0_Parameters(
                        **CalibrationServicer_default_dict['SetPHpH0_Parameters']
                    )

                response = self.CalibrationServicer_stub.SetPHpH0(parameter)

                logging.debug('SetPHpH0 response: {response}'.format(response=response))
            except grpc.RpcError as grpc_err:
                self.grpc_error_handling(grpc_err)
                return None
    
        return response
    
    def CalibrationServicer_GetPHdpH(self,
                                     parameter: CalibrationServicer_pb2.GetPHdpH_Parameters = None) \
            -> CalibrationServicer_pb2.GetPHdpH_Responses:
        """
        Wrapper to call the unobservable command GetPHdpH on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPHdpH:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetPHdpH_Parameters(
                    **CalibrationServicer_default_dict['GetPHdpH_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetPHdpH(parameter)
    
            logging.debug('GetPHdpH response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def CalibrationServicer_SetPHdpH(self, SetPHdpH_List) \
            -> CalibrationServicer_pb2.SetPHdpH_Responses:
        """
        Wrapper to call the unobservable command SetPHdpH on the server.
    
        :param SetPHdpH_List: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
        response = None
        logging.debug("Calling SetPHdpH:")
        # Input list:
        # SetPHdpH_List = [0,0,0,0,0,0] A setting between 0-50 for each in self.TotalBars
        par_dict: dict = {}
        if len(SetPHdpH_List) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                '{RequiredLength}'.format(CurrentLength=len(SetPHdpH_List), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetPHdpH': []
            }
            for i, SetPHdpH in enumerate(SetPHdpH_List):
                par_dict['SetPHdpH'].append(silaFW_pb2.Real(value=SetPHdpH))

            try:
                parameter = CalibrationServicer_pb2.SetPHdpH_Parameters(**par_dict)
                if parameter is None:
                    parameter = CalibrationServicer_pb2.SetPHdpH_Parameters(
                        **CalibrationServicer_default_dict['SetPHdpH_Parameters']
                    )

                response = self.CalibrationServicer_stub.SetPHdpH(parameter)

                logging.debug('SetPHdpH response: {response}'.format(response=response))
            except grpc.RpcError as grpc_err:
                self.grpc_error_handling(grpc_err)
                return None
    
        return response
    
    def CalibrationServicer_GetPHCalTemp(self,
                                         parameter: CalibrationServicer_pb2.GetPHCalTemp_Parameters = None) \
            -> CalibrationServicer_pb2.GetPHCalTemp_Responses:
        """
        Wrapper to call the unobservable command GetPHCalTemp on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPHCalTemp:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetPHCalTemp_Parameters(
                    **CalibrationServicer_default_dict['GetPHCalTemp_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetPHCalTemp(parameter)
    
            logging.debug('GetPHCalTemp response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def CalibrationServicer_SetPHCalTemp(self, SetPHCalTemp_List) \
            -> CalibrationServicer_pb2.SetPHCalTemp_Responses:
        """
        Wrapper to call the unobservable command SetPHCalTemp on the server.
    
        :param SetPHCalTemp_List: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
        response = None
        logging.debug("Calling SetPHCalTemp:")
        # Input list:
        # SetPHCalTemp_List = [20,20,20,20,20,20] A setting between -10-60 for each in self.TotalBars

        if len(SetPHCalTemp_List) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                '{RequiredLength}'.format(CurrentLength=len(SetPHCalTemp_List), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetPHCalTemp': []
            }
            for i, SetPHCalTemp in enumerate(SetPHCalTemp_List):
                par_dict['SetPHCalTemp'].append(silaFW_pb2.Real(value=SetPHCalTemp))

            try:
                parameter = CalibrationServicer_pb2.SetPHCalTemp_Parameters(**par_dict)
                if parameter is None:
                    parameter = CalibrationServicer_pb2.SetPHCalTemp_Parameters(
                        **CalibrationServicer_default_dict['SetPHCalTemp_Parameters']
                    )

                response = self.CalibrationServicer_stub.SetPHCalTemp(parameter)

                logging.debug('SetPHCalTemp response: {response}'.format(response=response))
            except grpc.RpcError as grpc_err:
                self.grpc_error_handling(grpc_err)
                return None
    
        return response
    
    def SensorProvider_GetSingleO2(self, Channel) \
            -> SensorProvider_pb2.GetSingleO2_Responses:
        """
        Wrapper to call the unobservable command GetSingleO2 on the server.
    
        :param Channel: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSingleO2:")
        par_dict = {
            'Channel': silaFW_pb2.Integer(value=Channel)
        }
        try:
            parameter = SensorProvider_pb2.GetSingleO2_Parameters(**par_dict)
            if parameter is None:
                parameter = SensorProvider_pb2.GetSingleO2_Parameters(
                    **SensorProvider_default_dict['GetSingleO2_Parameters']
                )
    
            response = self.SensorProvider_stub.GetSingleO2(parameter)
    
            logging.debug('GetSingleO2 response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SensorProvider_GetSinglePH(self, Channel) \
            -> SensorProvider_pb2.GetSinglePH_Responses:
        """
        Wrapper to call the unobservable command GetSinglePH on the server.
    
        :param Channel: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSinglePH:")
        par_dict = {
            'Channel': silaFW_pb2.Integer(value=Channel)
        }
        try:
            parameter = SensorProvider_pb2.GetSinglePH_Parameters(**par_dict)
            if parameter is None:
                parameter = SensorProvider_pb2.GetSinglePH_Parameters(
                    **SensorProvider_default_dict['GetSinglePH_Parameters']
                )
    
            response = self.SensorProvider_stub.GetSinglePH(parameter)
    
            logging.debug('GetSinglePH response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SensorProvider_GetAllO2(self,
                                parameter: SensorProvider_pb2.GetAllO2_Parameters = None) \
            -> SensorProvider_pb2.GetAllO2_Responses:
        """
        Wrapper to call the unobservable command GetAllO2 on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAllO2:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = SensorProvider_pb2.GetAllO2_Parameters(
                    **SensorProvider_default_dict['GetAllO2_Parameters']
                )
    
            response = self.SensorProvider_stub.GetAllO2(parameter)
    
            logging.debug('GetAllO2 response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SensorProvider_GetAllPH(self,
                                parameter: SensorProvider_pb2.GetAllPH_Parameters = None) \
            -> SensorProvider_pb2.GetAllPH_Responses:
        """
        Wrapper to call the unobservable command GetAllPH on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAllPH:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = SensorProvider_pb2.GetAllPH_Parameters(
                    **SensorProvider_default_dict['GetAllPH_Parameters']
                )
    
            response = self.SensorProvider_stub.GetAllPH(parameter)
    
            logging.debug('GetAllPH response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def Subscribe_DeviceServicer_CurrentStatus(self) \
            -> DeviceServicer_pb2.Subscribe_CurrentStatus_Responses:
        """Wrapper to get property CurrentStatus from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading observable property CurrentStatus:")
        try:
            response = self.DeviceServicer_stub.Subscribe_CurrentStatus(
                DeviceServicer_pb2.Subscribe_CurrentStatus_Parameters()
            )
            logging.debug(
                'Subscribe_CurrentStatus response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def Get_SensorProvider_TotalChannels(self) \
            -> SensorProvider_pb2.Get_TotalChannels_Responses:
        """Wrapper to get property TotalChannels from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property TotalChannels:")
        try:
            response = self.SensorProvider_stub.Get_TotalChannels(
                SensorProvider_pb2.Get_TotalChannels_Parameters()
            )
            logging.debug(
                'Get_TotalChannels response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def Get_SensorProvider_TotalBars(self) \
            -> SensorProvider_pb2.Get_TotalBars_Responses:
        """Wrapper to get property TotalBars from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property TotalBars:")
        try:
            response = self.SensorProvider_stub.Get_TotalBars(
                SensorProvider_pb2.Get_TotalBars_Parameters()
            )
            logging.debug(
                'Get_TotalBars response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def Get_SensorProvider_BarSensors(self) \
            -> SensorProvider_pb2.Get_BarSensors_Responses:
        """Wrapper to get property BarSensors from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property BarSensors:")
        try:
            response = self.SensorProvider_stub.Get_BarSensors(
                SensorProvider_pb2.Get_BarSensors_Parameters()
            )
            logging.debug(
                'Get_BarSensors response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    @staticmethod
    def grpc_error_handling(error_object: grpc.Call) -> None:
        """Handles exceptions of type grpc.RpcError"""
        # pass to the default error handling
        grpc_error = client_err.grpc_error_handling(error_object=error_object)

        # Access more details using the return value fields
        # grpc_error.message
        # grpc_error.error_type


def parse_command_line():
    """
    Just looking for command line arguments
    """
    parser = argparse.ArgumentParser(description="A SiLA2 client: PresensService")
    parser.add_argument('-v', '--version', action='version', version='%(prog)s ' + __version__)

    return parser.parse_args()


if __name__ == '__main__':
    # or use logging.INFO (=20) or logging.ERROR (=30) for less output
    logging.basicConfig(format='%(levelname)-8s| %(module)s.%(funcName)s: %(message)s', level=logging.DEBUG)

    parsed_args = parse_command_line()

    # start the server
    sila_client = PresensServiceClient(server_ip='127.0.0.1', server_port=50003)
    sila_client.run()

    # Log connection info
    logging.info(
        (
            'Connected to SiLA Server {display_name} running in version {version}.' '\n'
            'Service description: {service_description}'
        ).format(
            display_name=sila_client.server_display_name,
            version=sila_client.server_version,
            service_description=sila_client.server_description
        )
    )

    # TODO:
    #   Write your further function calls here to run the client as a standalone application.
