#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*PresensService*

:details: PresensService:
    This is a Presens MCR Service
           
:file:    PresensService_server.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:35.497112
:date: (last modification) 2020-04-16T10:19:35.497112

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

import os
import logging
import argparse

# Import the main SiLA library
from sila2lib.sila_server import SiLA2Server

# Import gRPC libraries of features
from sila2lib_implementations.Presens.PresensService.DeviceServicer.gRPC import DeviceServicer_pb2
from sila2lib_implementations.Presens.PresensService.DeviceServicer.gRPC import DeviceServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Presens.PresensService.DeviceServicer.DeviceServicer_default_arguments \
    import default_dict as DeviceServicer_default_dict
from sila2lib_implementations.Presens.PresensService.CalibrationServicer.gRPC import CalibrationServicer_pb2
from sila2lib_implementations.Presens.PresensService.CalibrationServicer.gRPC import CalibrationServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Presens.PresensService.CalibrationServicer.CalibrationServicer_default_arguments \
    import default_dict as CalibrationServicer_default_dict
from sila2lib_implementations.Presens.PresensService.SensorProvider.gRPC import SensorProvider_pb2
from sila2lib_implementations.Presens.PresensService.SensorProvider.gRPC import SensorProvider_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Presens.PresensService.SensorProvider.SensorProvider_default_arguments import default_dict as SensorProvider_default_dict

# Import the servicer modules for each feature
from sila2lib_implementations.Presens.PresensService.DeviceServicer.DeviceServicer_servicer import DeviceServicer
from sila2lib_implementations.Presens.PresensService.CalibrationServicer.CalibrationServicer_servicer \
    import CalibrationServicer
from sila2lib_implementations.Presens.PresensService.SensorProvider.SensorProvider_servicer import SensorProvider

# import custom implementation libraries
import time
import serial
import serial.tools.list_ports
import multiprocessing
from sila2lib_implementations.Presens.PresensService.SerialDetector import serial_ports


class Properties:
    TotalChannels = 48
    TotalBars = 6
    BarSensors = 8
    lock = multiprocessing.Lock()


class PresensServiceServer(SiLA2Server):
    """
    This is a Presens MCR Service
    """

    serial_ports = ['COM11', 'COM8', 'COM7', 'COM9', 'COM5', 'COM6', 'COM3']

    def __init__(self, cmd_args, ip: str = '127.0.0.1', port: int = 50001, simulation_mode: bool = False):
        """Class initializer"""
        super().__init__(
            name=cmd_args.server_name,
            description=cmd_args.description,
            server_type=cmd_args.server_type,
            server_uuid=None,
            version=__version__,
            vendor_url="",
            ip=ip, port=port,
            key_file=cmd_args.encryption_key, cert_file=cmd_args.encryption_cert
        )

        logging.info(
            "Starting SiLA2 server with server name: {server_name}".format(
                server_name=cmd_args.server_name
            )
        )

        # Define some server properties
        self.properties = Properties
        self.simulation_mode = simulation_mode

        if not simulation_mode:
            ports_required = ['COM12', 'COM13', 'COM14', 'COM15', 'COM7', 'COM8']
            # Opening a serial port for data communication automatically. ONLY use if no other COM ports exist!
            available_ports = serial_ports()

            ports = []
            ports_not_required = []
            self.ser = []
            for i in range(0, len(available_ports), 1):
                if available_ports[i] in ports_required:
                    ports.append(available_ports[i])
                else:
                    ports_not_required.append(available_ports[i])
            unavailable_ports = list(set(ports_required) - set(ports))
            if unavailable_ports is not []:
                logging.info(
                    "The following COM/USB ports are not available: {ports}".format(ports=unavailable_ports))
            if ports == []:
                logging.info(
                    "No available COM/USB port to establish connection: {ports}".format(ports=ports))
            else:
                ports = ports_required
                for i in range(0, len(unavailable_ports), 1):
                    ports.remove(unavailable_ports[i])
                print(ports)
                self.ser = list()
                for i in range(0, len(ports), 1):
                    print("Connecting to port: {port} as channel_{ID}".format(port=ports[i], ID=i))
                    vars()['channel%s' % i] = serial.Serial(port=ports[i], baudrate=115200,
                                                            parity=serial.PARITY_NONE,
                                                            stopbits=serial.STOPBITS_ONE, bytesize=serial.EIGHTBITS,
                                                            timeout=0.1)
                    self.ser.append(vars()['channel%s' % i])
                time.sleep(2)  # Upon startup, the sensor bars must not be addressed for 1,5 seconds.
                logging.info("Connection established on ports: {ports}".format(ports=self.ser))
                # disable echoing for each port to make sure that everything works fine if it was activated before
                for i in self.ser:
                    disable_echo = 'echo0000\r'
                    i.write(str.encode(disable_echo, 'ascii'))
                    response  =str(bytes.decode(i.readline().rstrip(), 'ascii'))
                    logging.info(f'Echoing deactivated with response {response}')
        else:
            self.ser = []


        # registering features
        #  Register DeviceServicer
        self.DeviceServicer_servicer = DeviceServicer(ser=self.ser, properties=self.properties,
                                                      simulation_mode=self.simulation_mode)
        DeviceServicer_pb2_grpc.add_DeviceServicerServicer_to_server(
            self.DeviceServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='DeviceServicer',
                         servicer=self.DeviceServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register CalibrationServicer
        self.CalibrationServicer_servicer = CalibrationServicer(ser=self.ser, properties=self.properties,
                                                                simulation_mode=self.simulation_mode)
        CalibrationServicer_pb2_grpc.add_CalibrationServicerServicer_to_server(
            self.CalibrationServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='CalibrationServicer',
                         servicer=self.CalibrationServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register SensorProvider
        self.SensorProvider_servicer = SensorProvider(ser=self.ser, properties=self.properties,
                                                      simulation_mode=self.simulation_mode)
        SensorProvider_pb2_grpc.add_SensorProviderServicer_to_server(
            self.SensorProvider_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='SensorProvider',
                         servicer=self.SensorProvider_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )

        self.simulation_mode = simulation_mode
        # starting and running the gRPC/SiLA2 server
        self.run()


def parse_command_line():
    """
    Just looking for commandline arguments
    """
    parser = argparse.ArgumentParser(description="A SiLA2 service: PresensService")

    # Simple arguments for the server identification
    parser.add_argument('-s', '--server-name', action='store',
                        default="PresensService", help='start SiLA server with [server-name]')
    parser.add_argument('-t', '--server-type', action='store',
                        default="Unknown Type", help='start SiLA server with [server-type]')
    parser.add_argument('-d', '--description', action='store',
                        default="This is a Presens MCR Service", help='SiLA server description')

    # Encryption
    parser.add_argument('-X', '--encryption', action='store', default=None,
                        help='The name of the private key and certificate file (without extension).')
    parser.add_argument('--encryption-key', action='store', default=None,
                        help='The name of the encryption key (*with* extension). Can be used if key and certificate '
                             'vary or non-standard file extensions are used.')
    parser.add_argument('--encryption-cert', action='store', default=None,
                        help='The name of the encryption certificate (*with* extension). Can be used if key and '
                             'certificate vary or non-standard file extensions are used.')

    parser.add_argument('-v', '--version', action='version', version='%(prog)s ' + __version__)

    parsed_args = parser.parse_args()

    # validate/update some settings
    #   encryption
    if parsed_args.encryption is not None:
        # only overwrite the separate keys if not given manually
        if parsed_args.encryption_key is None:
            parsed_args.encryption_key = parsed_args.encryption + '.key'
        if parsed_args.encryption_cert is None:
            parsed_args.encryption_cert = parsed_args.encryption + '.cert'

    return parsed_args
    
        
if __name__ == '__main__':
    # or use logging.ERROR for less output
    logging.basicConfig(format  = '%(asctime)s - %(name)s - %(levelname)s- %(module)s - linenumber: %(lineno)d - %(message)s', level=logging.DEBUG)
    args = parse_command_line()

    # generate SiLA2Server
    sila_server = PresensServiceServer(cmd_args=args, ip='127.0.0.1', port=50002, simulation_mode=True)
