"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Calibration Servicer*

:details: CalibrationServicer:
    Set and retrieve the control parameter values for calibration of the Reglo DC (digital control) pump.
    Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 15.03.2021.
           
:file:    CalibrationServicer_servicer.py
:authors: Lukas Bromig

:date: (creation)          2021-03-16T12:40:00.195668
:date: (last modification) 2021-03-16T12:40:00.195668

.. note:: Code generated by sila2codegenerator 0.3.3-dev

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import CalibrationServicer_pb2 as CalibrationServicer_pb2
from .gRPC import CalibrationServicer_pb2_grpc as CalibrationServicer_pb2_grpc

# import simulation and real implementation
from .CalibrationServicer_simulation import CalibrationServicerSimulation
from .CalibrationServicer_real import CalibrationServicerReal


class CalibrationServicer(CalibrationServicer_pb2_grpc.CalibrationServicerServicer):
    """
    This is a RegloDC Service
    """
    implementation: Union[CalibrationServicerSimulation, CalibrationServicerReal]
    simulation_mode: bool

    def __init__(self, properties, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """

        self.simulation_mode = simulation_mode
        self.properties = properties

        if simulation_mode:
            self._inject_implementation(CalibrationServicerSimulation(properties=self.properties))
        else:
            self._inject_implementation(CalibrationServicerReal(properties=self.properties))

    def _inject_implementation(self,
                               implementation: Union[CalibrationServicerSimulation,
                                                     CalibrationServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the RegloDCServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(CalibrationServicerSimulation(properties=self.properties))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(CalibrationServicerReal(properties=self.properties))

    def StartCalibrationTime(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.StartCalibrationTime_Responses:
        """
        Executes the unobservable command "Start Calibration Time"
            Start calibration using the time defined by "Calibration Time".
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CalibrationResult (Calibration Result): Calibration result
        """
    
        logging.debug(
            "StartCalibrationTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.StartCalibrationTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def StartCalibrationVolume(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.StartCalibrationVolume_Responses:
        """
        Executes the unobservable command "Start Calibration Volume"
            Start calibration using the volume defined by "Calibration Volume".
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CalibrationResult (Calibration Result): Calibration result
        """
    
        logging.debug(
            "StartCalibrationVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.StartCalibrationVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetDefaultFlowRate(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetDefaultFlowRate_Responses:
        """
        Executes the unobservable command "Get Default Flow Rate"
            Get the default flow rate [mL/min] of the programmed pump-head and tubing at max. speed (160/100 rpm).
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.DefaultFlowRate (Default Flow Rate): Current default flow rate of the pump-head and tubing in mL/min.
        """
    
        logging.debug(
            "GetDefaultFlowRate called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetDefaultFlowRate(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetCalibratedFlowRate(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetCalibratedFlowRate_Responses:
        """
        Executes the unobservable command "Get Calibrated Flow Rate"
            Get the calibrated flow rate in mL/min (at max. speed = 160/100 rpm).
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CalibratedFlowRate (Calibrated Flow Rate): The calibrated flow rate in mL/min (at max speed = 160/100 rpm).
        """
    
        logging.debug(
            "GetCalibratedFlowRate called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetCalibratedFlowRate(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetCalibratedFlowRate(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetCalibratedFlowRate_Responses:
        """
        Executes the unobservable command "Set Calibrated Flow Rate"
            Set the calibrated flow rate in mL/min (at max. speed = 160/100 rpm). The position of the decimal point depends on the programmed pump head and tubing.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CalibratedFlowRate (Calibrated Flow Rate): The new calibrated flow rate in mL/min (at max speed = 160/100 rpm).
        """
    
        logging.debug(
            "SetCalibratedFlowRate called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetCalibratedFlowRate(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetCalibrationTargetVolume(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetCalibrationTargetVolume_Responses:
        """
        Executes the unobservable command "Set Target Volume Value"
            Set target volume to pump for calibrating in mL.
    
        :param request: gRPC request containing the parameters passed:
            request.TargetVolume (Target Volume):
            Set target volume to pump for calibrating in mL.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.TargetVolumeSet (Target Volume Set): Target Volume succeeded to Set.
        """
    
        logging.debug(
            "SetCalibrationTargetVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetCalibrationTargetVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetCalibrationTargetTime(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetCalibrationTargetTime_Responses:
        """
        Executes the unobservable command "Set Target Time Value"
            Set target time to pump for calibrating in s.
    
        :param request: gRPC request containing the parameters passed:
            request.TargetTime (Target Time):
            Set target time to pump for calibrating in s.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.TargetTimeSet (Target Time Set): Target time successfully set.
        """
    
        logging.debug(
            "SetCalibrationTargetTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetCalibrationTargetTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetActualVolume(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetActualVolume_Responses:
        """
        Executes the unobservable command "Set Actual Volume Value"
            Set the actual volume measured during calibration in mL.
    
        :param request: gRPC request containing the parameters passed:
            request.ActualVolume (Actual Volume):
            The actual volume measured during calibration in mL.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActualVolumeSet (Actual Volume Set): Actual Volume succeeded to Set.
        """
    
        logging.debug(
            "SetActualVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetActualVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetTargetVolume(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetTargetVolume_Responses:
        """
        Executes the unobservable command "Get Target Volume"
            Get target volume to pump for calibrating in mL.
    
        :param request: gRPC request containing the parameters passed:
            request.TargetVolume (Target Volume):
            Get target volume of pump for calibrating in mL.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTargetVolume (Current Target Volume): Current target volume to pump for calibrating in mL.
        """
    
        logging.debug(
            "GetTargetVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetTargetVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetActualTime(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetActualTime_Responses:
        """
        Executes the unobservable command "Set Actual Time Value"
            Set the actual time measured during calibration in s.
    
        :param request: gRPC request containing the parameters passed:
            request.ActualTime (Actual Time):
            The actual time measured during calibration in s.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActualTimeSet (Actual Time Set): Actual time successfully set.
        """
    
        logging.debug(
            "SetActualTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetActualTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetTargetTime(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetTargetTime_Responses:
        """
        Executes the unobservable command "Get Target Time"
            Get target time to pump for calibrating in s.
    
        :param request: gRPC request containing the parameters passed:
            request.TargetTime (Target Time):
            Get target time of pump for calibrating in s.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTargetTime (Current Target Time): Current target time to pump for calibrating in s.
        """
    
        logging.debug(
            "GetTargetTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetTargetTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDirectionCalibration(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetDirectionCalibration_Responses:
        """
        Executes the unobservable command "Set Direction Flow for Calibration"
            Set direction flow for calibration J or K using DIRECTION format.
    
        :param request: gRPC request containing the parameters passed:
            request.Direction (Direction):
            Set direction flow for calibration J or K using DIRECTION format.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetDirectionCalibrationSet (Set Direction for Calibration Set): Direction flow for Calibration succeeded to Set.
        """
    
        logging.debug(
            "SetDirectionCalibration called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDirectionCalibration(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetDirectionCalibration(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetDirectionCalibration_Responses:
        """
        Executes the unobservable command "Get Direction Flow for Calibration"
            Get direction flow for calibration (J or K).
    
        :param request: gRPC request containing the parameters passed:
            request.Direction (Direction):
            Get direction flow for calibration (J or K).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDirectionCalibration (Current Direction for Calibration): Current Direction flow for Calibration.
        """
    
        logging.debug(
            "GetDirectionCalibration called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetDirectionCalibration(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetLastCalibrationTime(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetLastCalibrationTime_Responses:
        """
        Executes the unobservable command "Get Last Calibration Time"
            Get the time of the last calibration.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.LastCalibrationTime (Last Calibration Time): Last Calibration Time.
        """
    
        logging.debug(
            "GetLastCalibrationTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetLastCalibrationTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
