"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Calibration Servicer*

:details: CalibrationServicer:
    Set and retrieve the control parameter values for calibration of the Reglo DC (digital control) pump.
    Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 15.03.2021.

:file:    CalibrationServicer_simulation.py
:authors: Lukas Bromig

:date: (creation)          2021-03-16T12:40:00.222841
:date: (last modification) 2021-03-16T12:40:00.222841

.. note:: Code generated by sila2codegenerator 0.3.3-dev

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only
import inspect      # used for status determination

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import CalibrationServicer_pb2 as CalibrationServicer_pb2
# from .gRPC import CalibrationServicer_pb2_grpc as CalibrationServicer_pb2_grpc

# import default arguments
from .CalibrationServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class CalibrationServicerSimulation:
    """
    Implementation of the *Calibration Servicer* in *Simulation* mode
        This is a RegloDC Service
    """

    def __init__(self, properties):
        """Class initialiser"""

        self.properties = properties
        logging.debug('Started server in mode: {mode}'.format(mode='Simulation'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    @staticmethod
    def _get_function_name():
        return inspect.stack()[1][3]

    def StartCalibrationTime(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.StartCalibrationTime_Responses:
        """
        Executes the unobservable command "Start Calibration Time"
            Start calibration using the time defined by "Calibration Time".
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CalibrationResult (Calibration Result): Calibration result
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command StartCalibrationTime here and write the resulting response
        #   in return_value
        #   This function is not an actual functionality of the device and must be implemented using some kind of local
        #   .csv file

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.StartCalibrationTime_Responses(
                **default_dict['StartCalibrationTime_Responses']
            )
    
        # update the server status
        self.properties.status = f'{self._get_function_name()}'
    
        return return_value

    def StartCalibrationVolume(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.StartCalibrationVolume_Responses:
        """
        Executes the unobservable command "Start Calibration Volume"
            Start calibration using the volume defined by "Calibration Volume".
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CalibrationResult (Calibration Result): Calibration result
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command StartCalibrationVolume here and write the resulting response
        #   in return_value
        #   This function is not an actual functionality of the device and must be implemented using some kind of local
        #   .csv file
    
        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.StartCalibrationVolume_Responses(
                **default_dict['StartCalibrationVolume_Responses']
            )
    
        # update the server status
        self.properties.status = f'{self._get_function_name()}'
    
        return return_value

    def GetDefaultFlowRate(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetDefaultFlowRate_Responses:
        """
        Executes the unobservable command "Get Default Flow Rate"
            Get the default flow rate [mL/min] of the programmed pump-head and tubing at max. speed (160/100 rpm).
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.DefaultFlowRate (Default Flow Rate): Current default flow rate of the pump-head and tubing in mL/min.
        """
    
        # initialise the return value
        return_value = None
        read = None
        self.properties.status = f'{self._get_function_name()}'
        logging.debug(f'New status is: {self.properties.status}')

        command = f'{self.properties.pump_address_sim}?\r\n'
        try:
            read = '60.0 ml/min'
            if 'ml' in read:
                read = read.split('ml')[0]
            elif 'RSV' in read:
                read = read.split('RSV')[0]
            par_dict = {
                'DefaultFlowRate': silaFW_pb2.Real(value=float(read)),
            }
            return_value = CalibrationServicer_pb2.GetDefaultFlowRate_Responses(**par_dict)
            logging.debug(
                'Executed command GetDefaultFlowRate in mode: {mode} with response: {response}'
                    .format(mode='Simulation', response=read))
        except (ValueError, IndexError):
            logging.exception('Parsing of the following command response failed: {command}, {response}'
                              .format(command=command, response=read))

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.GetDefaultFlowRate_Responses(
                **default_dict['GetDefaultFlowRate_Responses']
            )
    
        # update the server status
        self.properties.status = f'{self._get_function_name()}'
    
        return return_value

    def GetCalibratedFlowRate(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetCalibratedFlowRate_Responses:
        """
        Executes the unobservable command "Get Calibrated Flow Rate"
            Get the calibrated flow rate in mL/min (at max. speed = 160/100 rpm).
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CalibratedFlowRate (Calibrated Flow Rate): The calibrated flow rate in mL/min (at max speed = 160/100 rpm).
        """

        # initialise the return value
        return_value = None
        read = None
        self.properties.status = f'{self._get_function_name()}'
        logging.debug(f'New status is: {self.properties.status}')

        command = f'{self.properties.pump_address_sim}!\r\n'
        try:
            read = '250.3 ml/min'
            if 'ml' in read:
                read = read.split('ml')[0]
            elif 'RSV' in read:
                read = read.split('RSV')[0]
            par_dict = {
                'CalibratedFlowRate': silaFW_pb2.Real(value=float(read)),
            }
            return_value = CalibrationServicer_pb2.GetCalibratedFlowRate_Responses(**par_dict)
            logging.debug(
                'Executed command GetCalibratedFlowRate in mode: {mode} with response: {response}'
                    .format(mode='Simulation', response=read))
        except (ValueError, IndexError):
            logging.exception('Parsing of the following command response failed: {command}, {response}'
                              .format(command=command, response=read))
    
        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.GetCalibratedFlowRate_Responses(
                **default_dict['GetCalibratedFlowRate_Responses']
            )
    
        # update the server status
        self.properties.status = f'{self._get_function_name()}'
    
        return return_value

    def SetCalibratedFlowRate(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetCalibratedFlowRate_Responses:
        """
        Executes the unobservable command "Set Calibrated Flow Rate"
            Set the calibrated flow rate in mL/min (at max. speed = 160/100 rpm). The position of the decimal point depends on the programmed pump head and tubing.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CalibratedFlowRate (Calibrated Flow Rate): The new calibrated flow rate in mL/min (at max speed = 160/100 rpm).
        """
    
        # initialise the return value
        return_value = None
        read = None
        self.properties.status = f'{self._get_function_name()}'
        logging.debug(f'New status is: {self.properties.status}')
        user_input = str(request.CurrentRollerBackSteps.value)
        user_input = user_input.zfill(4)  # If to short, pad to length 4
        user_input = user_input[:4]  # If to long, strictly limit to 4 digits

        command = f'{self.properties.pump_address_sim}!{user_input}\r\n'
        try:
            read = '*'
            if read == '*':
                read = user_input
            else:
                read = 999.9
            par_dict = {
                'CalibratedFlowRate': silaFW_pb2.Real(value=float(read)),
            }
            return_value = CalibrationServicer_pb2.GetCalibratedFlowRate_Responses(**par_dict)
            logging.debug(
                'Executed command GetCalibratedFlowRate in mode: {mode} with response: {response}'
                    .format(mode='Simulation', response=read))
        except (ValueError, IndexError):
            logging.exception('Parsing of the following command response failed: {command}, {response}'
                              .format(command=command, response=read))
    
        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.SetCalibratedFlowRate_Responses(
                **default_dict['SetCalibratedFlowRate_Responses']
            )
    
        # update the server status
        self.properties.status = f'{self._get_function_name()}'
    
        return return_value

    def SetCalibrationTargetVolume(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetCalibrationTargetVolume_Responses:
        """
        Executes the unobservable command "Set Target Volume Value"
            Set target volume to pump for calibrating in mL.
    
        :param request: gRPC request containing the parameters passed:
            request.TargetVolume (Target Volume):
            Set target volume to pump for calibrating in mL.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.TargetVolumeSet (Target Volume Set): Target Volume succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetCalibrationTargetVolume here and write the resulting response
        #   in return_value
        #   This function is not an actual functionality of the device and must be implemented using some kind of local
        #   .csv file

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.SetCalibrationTargetVolume_Responses(
                **default_dict['SetCalibrationTargetVolume_Responses']
            )
    
        # update the server status
        self.properties.status = f'{self._get_function_name()}'
    
        return return_value

    def SetCalibrationTargetTime(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetCalibrationTargetTime_Responses:
        """
        Executes the unobservable command "Set Target Time Value"
            Set target time to pump for calibrating in s.
    
        :param request: gRPC request containing the parameters passed:
            request.TargetTime (Target Time):
            Set target time to pump for calibrating in s.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.TargetTimeSet (Target Time Set): Target time successfully set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetCalibrationTargetTime here and write the resulting response
        #   in return_value
        #   This function is not an actual functionality of the device and must be implemented using some kind of local
        #   .csv file

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.SetCalibrationTargetTime_Responses(
                **default_dict['SetCalibrationTargetTime_Responses']
            )
    
        # update the server status
        self.properties.status = f'{self._get_function_name()}'
    
        return return_value

    def SetActualVolume(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetActualVolume_Responses:
        """
        Executes the unobservable command "Set Actual Volume Value"
            Set the actual volume measured during calibration in mL.
    
        :param request: gRPC request containing the parameters passed:
            request.ActualVolume (Actual Volume):
            The actual volume measured during calibration in mL.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActualVolumeSet (Actual Volume Set): Actual Volume succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetActualVolume here and write the resulting response
        #   in return_value
        #   This function is not an actual functionality of the device and must be implemented using some kind of local
        #   .csv file

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.SetActualVolume_Responses(
                **default_dict['SetActualVolume_Responses']
            )
    
        # update the server status
        self.properties.status = f'{self._get_function_name()}'
    
        return return_value

    def GetTargetVolume(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetTargetVolume_Responses:
        """
        Executes the unobservable command "Get Target Volume"
            Get target volume to pump for calibrating in mL.
    
        :param request: gRPC request containing the parameters passed:
            request.TargetVolume (Target Volume):
            Get target volume of pump for calibrating in mL.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTargetVolume (Current Target Volume): Current target volume to pump for calibrating in mL.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetTargetVolume here and write the resulting response
        #   in return_value
        #   This function is not an actual functionality of the device and must be implemented using some kind of local
        #   .csv file

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.GetTargetVolume_Responses(
                **default_dict['GetTargetVolume_Responses']
            )
    
        # update the server status
        self.properties.status = f'{self._get_function_name()}'
    
        return return_value

    def SetActualTime(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetActualTime_Responses:
        """
        Executes the unobservable command "Set Actual Time Value"
            Set the actual time measured during calibration in s.
    
        :param request: gRPC request containing the parameters passed:
            request.ActualTime (Actual Time):
            The actual time measured during calibration in s.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActualTimeSet (Actual Time Set): Actual time successfully set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetActualTime here and write the resulting response
        #   in return_value
        #   This function is not an actual functionality of the device and must be implemented using some kind of local
        #   .csv file

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.SetActualTime_Responses(
                **default_dict['SetActualTime_Responses']
            )
    
        # update the server status
        self.properties.status = f'{self._get_function_name()}'
    
        return return_value

    def GetTargetTime(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetTargetTime_Responses:
        """
        Executes the unobservable command "Get Target Time"
            Get target time to pump for calibrating in s.
    
        :param request: gRPC request containing the parameters passed:
            request.TargetTime (Target Time):
            Get target time of pump for calibrating in s.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTargetTime (Current Target Time): Current target time to pump for calibrating in s.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetTargetTime here and write the resulting response
        #   in return_value
        #   This function is not an actual functionality of the device and must be implemented using some kind of local
        #   .csv file

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.GetTargetTime_Responses(
                **default_dict['GetTargetTime_Responses']
            )
    
        # update the server status
        self.properties.status = f'{self._get_function_name()}'
    
        return return_value

    def SetDirectionCalibration(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetDirectionCalibration_Responses:
        """
        Executes the unobservable command "Set Direction Flow for Calibration"
            Set direction flow for calibration J or K using DIRECTION format.
    
        :param request: gRPC request containing the parameters passed:
            request.Direction (Direction):
            Set direction flow for calibration J or K using DIRECTION format.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetDirectionCalibrationSet (Set Direction for Calibration Set): Direction flow for Calibration succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetDirectionCalibration here and write the resulting response
        #   in return_value
        #   This function is not an actual functionality of the device and must be implemented using some kind of local
        #   .csv file

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.SetDirectionCalibration_Responses(
                **default_dict['SetDirectionCalibration_Responses']
            )
    
        # update the server status
        self.properties.status = f'{self._get_function_name()}'
    
        return return_value

    def GetDirectionCalibration(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetDirectionCalibration_Responses:
        """
        Executes the unobservable command "Get Direction Flow for Calibration"
            Get direction flow for calibration (J or K).
    
        :param request: gRPC request containing the parameters passed:
            request.Direction (Direction):
            Get direction flow for calibration (J or K).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDirectionCalibration (Current Direction for Calibration): Current Direction flow for Calibration.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetDirectionCalibration here and write the resulting response
        #   in return_value
        #   This function is not an actual functionality of the device and must be implemented using some kind of local
        #   .csv file

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.GetDirectionCalibration_Responses(
                **default_dict['GetDirectionCalibration_Responses']
            )
    
        # update the server status
        self.properties.status = f'{self._get_function_name()}'
    
        return return_value

    def GetLastCalibrationTime(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetLastCalibrationTime_Responses:
        """
        Executes the unobservable command "Get Last Calibration Time"
            Get the time of the last calibration.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.LastCalibrationTime (Last Calibration Time): Last Calibration Time.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetLastCalibrationTime here and write the resulting response
        #   in return_value
        #   This function is not an actual functionality of the device and must be implemented using some kind of local
        #   .csv file

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.GetLastCalibrationTime_Responses(
                **default_dict['GetLastCalibrationTime_Responses']
            )
    
        # update the server status
        self.properties.status = f'{self._get_function_name()}'
    
        return return_value
