"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Device Servicer*

:details: DeviceServicer:
    General device software and hardware information can be retrieved and changed within this function (Reglo DC
    (digital control) pump).
    Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 15.03.2021
           
:file:    DeviceServicer_servicer.py
:authors: Lukas Bromig

:date: (creation)          2021-03-16T12:40:00.256923
:date: (last modification) 2021-03-16T12:40:00.256923

.. note:: Code generated by sila2codegenerator 0.3.3-dev

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import DeviceServicer_pb2 as DeviceServicer_pb2
from .gRPC import DeviceServicer_pb2_grpc as DeviceServicer_pb2_grpc

# import simulation and real implementation
from .DeviceServicer_simulation import DeviceServicerSimulation
from .DeviceServicer_real import DeviceServicerReal


class DeviceServicer(DeviceServicer_pb2_grpc.DeviceServicerServicer):
    """
    This is a RegloDC Service
    """
    implementation: Union[DeviceServicerSimulation, DeviceServicerReal]
    simulation_mode: bool

    def __init__(self, properties, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.properties = properties
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(DeviceServicerSimulation(properties=self.properties))
        else:
            self._inject_implementation(DeviceServicerReal(properties=self.properties))

    def _inject_implementation(self,
                               implementation: Union[DeviceServicerSimulation,
                                                     DeviceServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the RegloDCServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(DeviceServicerSimulation(properties=self.properties))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(DeviceServicerReal(properties=self.properties))

    def GetLog(self, request, context: grpc.ServicerContext) \
            -> silaFW_pb2.CommandConfirmation:
        """
        Executes the observable command "Get Log"
            Get the current status of the device from the state machine of the SiLA server.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A command confirmation object with the following information:
            commandId: A command id with which this observable command can be referenced in future calls
            lifetimeOfExecution: The (maximum) lifetime of this command call.
        """
    
        logging.debug(
            "GetLog called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.GetLog(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetLog_Info(self, request, context: grpc.ServicerContext) \
            -> silaFW_pb2.ExecutionInfo:
        """
        Returns execution information regarding the command call :meth:`~.GetLog`.
    
        :param request: A request object with the following properties
            CommandExecutionUUID: The UUID of the command executed.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: An ExecutionInfo response stream for the command with the following fields:
            commandStatus: Status of the command (enumeration)
            progressInfo: Information on the progress of the command (0 to 1)
            estimatedRemainingTime: Estimate of the remaining time required to run the command
            updatedLifetimeOfExecution: An update on the execution lifetime
        """
    
        logging.debug(
            "GetLog_Info called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.GetLog_Info(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetLog_Result(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetLog_Responses:
        """
        Returns the final result of the command call :meth:`~.GetLog`.
    
        :param request: A request object with the following properties
            CommandExecutionUUID: The UUID of the command executed.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentLogLevel (Current Log Level): The current log level of the latest logs , retrieved from the SiLA server log file.
            request.CurrentLogTimestamp (Current Log Timestamp): The current log timestamp of the latest logs , retrieved from the SiLA server log file.
            request.CurrentLogMessage (Current Log Level): The current log level of the latest logs , retrieved from the SiLA server log file.
        """
    
        logging.debug(
            "GetLog_Result called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.GetLog_Result(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    
    def SetPumpAddress(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetPumpAddress_Responses:
        """
        Executes the unobservable command "Set Pump Address"
            Set the address of the pump (1-8).
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpAddressSet (Pump Address Set): Pump Address succeeded to Set.
        """
    
        logging.debug(
            "SetPumpAddress called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetPumpAddress(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetPumpStatus(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetPumpStatus_Responses:
        """
        Executes the unobservable command "Get Pump Status"
            Get pump status. +=running, -=stopped/standby.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPumpStatus (Current Pump Status): Current pump status. +=running, -=stopped/standby.
        """
    
        logging.debug(
            "GetPumpStatus called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPumpStatus(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetVersionType(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetVersionType_Responses:
        """
        Executes the unobservable command "Get Version Type"
            Get pump information. Response is string of model description (variable length), software version (3 digits) and pump head model type code (3 digits).
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersionType (Current Version Type): Current pump information. Response is string of model description (variable length), software version (3 digits) and pump head model type code (3 digits).
        """
    
        logging.debug(
            "GetVersionType called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetVersionType(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetVersionSoftware(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetVersionSoftware_Responses:
        """
        Executes the unobservable command "Current Version Software"
            Get pump software version. Response is string.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersionSoftware (Current Version Software): Current pump software version. Response is string.
        """
    
        logging.debug(
            "GetVersionSoftware called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetVersionSoftware(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetPumpID(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetPumpID_Responses:
        """
        Executes the unobservable command "Get Pump ID"
            Get pump head identification number.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ID (Identification Number): Pump head identification number query response.
        """
    
        logging.debug(
            "GetPumpID called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPumpID(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetPumpID(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetPumpID_Responses:
        """
        Executes the unobservable command "Set Pump ID"
            Set pump head identification number.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpID (Pump ID): The new pump head identification number
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ID (Identification Number): Pump head identification number query response.
        """
    
        logging.debug(
            "SetPumpID called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetPumpID(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def ResetToDefault(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.ResetToDefault_Responses:
        """
        Executes the unobservable command "Reset To Default"
            Resets all user configurable data to default values.
    
        :param request: gRPC request containing the parameters passed:
            request.Reset (Reset):
            Resets all user configurable data to default values.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ResetStatus (Reset Status): Reset of pump succeeded.
        """
    
        logging.debug(
            "ResetToDefault called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.ResetToDefault(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetTotalVolume(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetTotalVolume_Responses:
        """
        Executes the unobservable command "Get Total Volume"
            Get total volume pumped since last reset, in muL, mL, or L.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.TotalVolume (Total Volume): The total volume pumped since last reset, in muL, mL, or L
        """
    
        logging.debug(
            "GetTotalVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetTotalVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def ResetTotalVolume(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.ResetTotalVolume_Responses:
        """
        Executes the unobservable command "Reset Total Volume"
            Reset the total dispensed volume since the last reset.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ResetResponse (ResetResponse): Successfully reset the total dispensed volume.
        """
    
        logging.debug(
            "ResetTotalVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.ResetTotalVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def UnlockControlPanel(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.UnlockControlPanel_Responses:
        """
        Executes the unobservable command "Unlock Control Panel"
            Switch control panel to manual operation.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControlPanelUnlocked (Control Panel Unlocked): Control panel switched to manual operation.
        """
    
        logging.debug(
            "UnlockControlPanel called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.UnlockControlPanel(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def LockControlPanel(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.LockControlPanel_Responses:
        """
        Executes the unobservable command "Lock Control Panel"
            Set control panel to inactive (Input via control keys is not possible).
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControlPanelLocked (Control Panel Locked): The control panel has been locked.
        """
    
        logging.debug(
            "LockControlPanel called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.LockControlPanel(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDisplayNumbers(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetDisplayNumbers_Responses:
        """
        Executes the unobservable command "Set Display Numbers"
            Write numbers to the pump to display while under external control - float of length 5 including +/- and decimal points.
    
        :param request: gRPC request containing the parameters passed:
            request.DisplayNumbers (Display Numbers):
            Write numbers to the pump to display while under external control - float of length 5 including +/- and decimal points.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.DisplayNumbersSet (Display Numbers Set): Display Numbers succeeded to Set.
        """
    
        logging.debug(
            "SetDisplayNumbers called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDisplayNumbers(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDisplayLetters(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetDisplayLetters_Responses:
        """
        Executes the unobservable command "Set Display Letters"
            Write letters to the pump to display while under external control - string of length 4.
    
        :param request: gRPC request containing the parameters passed:
            request.DisplayLetters (Display Letters):
            Write letters to the pump to display while under external control - string of length 4.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.DisplayLettersSet (Display Letters Set): Display Letters succeeded to Set.
        """
    
        logging.debug(
            "SetDisplayLetters called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDisplayLetters(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetCommunicationPort(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetCommunicationPort_Responses:
        """
        Executes the unobservable command "Set Pump ID"
            Set pump head identification number.
    
        :param request: gRPC request containing the parameters passed:
            request.PortName (Port Name): The name of the serial port.
            request.BaudRate (Baud Rate): The baud rate of the serial port connection.
            request.Parity (Parity):  Enable parity checking. Possible values: NONE, EVEN, ODD, MARK, SPACE. Default is NONE
            request.StopBits (Stop Bits):  Number of stop bits. Possible values: ONE, ONE_POINT_FIVE, TWO. Default is ONE
            request.Timeout (Timeout): Set a read timeout value. Default is 1.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetCommunicationPortStatus (Set Communication Port Status): The status of the set command.
        """
    
        logging.debug(
            "SetCommunicationPort called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetCommunicationPort(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def ConnectDevice(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.ConnectDevice_Responses:
        """
        Executes the unobservable command "Connect Device"
            Sets up a serial connection with the device using the specified connection details.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ConnectionStatus (ConnectionStatus): The connection status. If connection was unsuccessful, the error will be returned.
        """
    
        logging.debug(
            "ConnectDevice called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.ConnectDevice(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def ResetOverload(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.ResetOverload_Responses:
        """
        Executes the unobservable command "Reset Overload"
            Reset the device command input buffer overload.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ResetOverloadStatus (Reset Overload Status): The reset overload status. If reset was unsuccessful, the error will be returned.
        """
    
        logging.debug(
            "ResetOverload called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.ResetOverload(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    def Subscribe_CurrentStatus(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.Subscribe_CurrentStatus_Responses:
        """
        Requests the observable property Current Status
            Get the current status of the device from the internal state machine of the SiLA server.
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response stream with the following fields:
            request.CurrentStatus (Current Status): Get the current status of the device from the internal state machine of the SiLA server.
        """
    
        logging.debug(
            "Property CurrentStatus requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.Subscribe_CurrentStatus(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    
    def Get_PortName(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.Get_PortName_Responses:
        """
        Requests the unobservable property Port Name
            The name of the serial port. 
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.PortName (Port Name): The name of the serial port.
        """
    
        logging.debug(
            "Property PortName requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.Get_PortName(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def Get_BaudRate(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.Get_BaudRate_Responses:
        """
        Requests the unobservable property Baud Rate
            The baud rate of the serial port connection. 
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.BaudRate (Baud Rate): The baud rate of the serial port connection.
        """
    
        logging.debug(
            "Property BaudRate requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.Get_BaudRate(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def Get_Parity(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.Get_Parity_Responses:
        """
        Requests the unobservable property Parity
            Enable parity checking. Possible values: NONE, EVEN, ODD, MARK, SPACE. Default is NONE
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.Parity (Parity):  Enable parity checking. Possible values: NONE, EVEN, ODD, MARK, SPACE. Default is NONE
        """
    
        logging.debug(
            "Property Parity requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.Get_Parity(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def Get_StopBits(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.Get_StopBits_Responses:
        """
        Requests the unobservable property Stop Bits
            Number of stop bits. Possible values: ONE, ONE_POINT_FIVE, TWO. Default is ONE
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.StopBits (Stop Bits):  Number of stop bits. Possible values: ONE, ONE_POINT_FIVE, TWO. Default is ONE
        """
    
        logging.debug(
            "Property StopBits requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.Get_StopBits(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def Get_Timeout(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.Get_Timeout_Responses:
        """
        Requests the unobservable property Timeout
            Set a read timeout value. Default is 1.
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.Timeout (Timeout): Set a read timeout value. Default is 1.
        """
    
        logging.debug(
            "Property Timeout requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.Get_Timeout(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
