"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Drive Control Servicer*

:details: DriveControlServicer:
    Set and retrieve information regarding the pump drive of the Reglo DC (digital control) pump..
    Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 15.03.2021.
           
:file:    DriveControlServicer_servicer.py
:authors: Lukas Bromig

:date: (creation)          2021-03-16T12:40:00.395759
:date: (last modification) 2021-03-16T12:40:00.395759

.. note:: Code generated by sila2codegenerator 0.3.3-dev

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import DriveControlServicer_pb2 as DriveControlServicer_pb2
from .gRPC import DriveControlServicer_pb2_grpc as DriveControlServicer_pb2_grpc

# import simulation and real implementation
from .DriveControlServicer_simulation import DriveControlServicerSimulation
from .DriveControlServicer_real import DriveControlServicerReal


class DriveControlServicer(DriveControlServicer_pb2_grpc.DriveControlServicerServicer):
    """
    This is a RegloDC Service
    """
    implementation: Union[DriveControlServicerSimulation, DriveControlServicerReal]
    simulation_mode: bool

    def __init__(self, properties, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.properties = properties
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(DriveControlServicerSimulation(properties=self.properties))
        else:
            self._inject_implementation(DriveControlServicerReal(properties=self.properties))

    def _inject_implementation(self,
                               implementation: Union[DriveControlServicerSimulation,
                                                     DriveControlServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the RegloDCServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(DriveControlServicerSimulation(properties=self.properties))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(DriveControlServicerReal(properties=self.properties))

    def StartPump(self, request, context: grpc.ServicerContext) \
            -> DriveControlServicer_pb2.StartPump_Responses:
        """
        Executes the unobservable command "Start Pump"
            Starts the pump out of stand-by mode.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.StartStatus (Start Status): Start of pump succeeded.
        """
    
        logging.debug(
            "StartPump called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.StartPump(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def StopPump(self, request, context: grpc.ServicerContext) \
            -> DriveControlServicer_pb2.StopPump_Responses:
        """
        Executes the unobservable command "Stop Pump"
            Stops the all channels of the pump.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.StopStatus (Stop Status): Shut-down of pump succeeded.
        """
    
        logging.debug(
            "StopPump called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.StopPump(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetPumpDirection(self, request, context: grpc.ServicerContext) \
            -> DriveControlServicer_pb2.GetPumpDirection_Responses:
        """
        Executes the unobservable command "Get Pump Direction"
            Get pump direction.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpDirection (Pump Direction): Pump direction query. J = clockwise/ K = counter-clockwise.
        """
    
        logging.debug(
            "GetPumpDirection called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPumpDirection(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDirectionClockwise(self, request, context: grpc.ServicerContext) \
            -> DriveControlServicer_pb2.SetDirectionClockwise_Responses:
        """
        Executes the unobservable command "Set Direction to clockwise"
            Set the rotation direction of the pump to clockwise
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetDirectionClockwiseSet (Set Direction Clockwise Set): Set direction to clockwise succeeded to set.
        """
    
        logging.debug(
            "SetDirectionClockwise called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDirectionClockwise(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDirectionCounterClockwise(self, request, context: grpc.ServicerContext) \
            -> DriveControlServicer_pb2.SetDirectionCounterClockwise_Responses:
        """
        Executes the unobservable command "Set Direction to Counter-Clockwise"
            Set the rotation direction of the pump to counter-clockwise
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetDirectionCounterClockwiseSet (Set Direction to Counter-Clockwise Set): Set direction to counter-clockwise succeeded to set.
        """
    
        logging.debug(
            "SetDirectionCounterClockwise called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDirectionCounterClockwise(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
