"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Parameter Control Servicer*

:details: ParameterControlServicer:
    Set and retrieve information regarding the parameter settings of the Reglo DC (digital control) pump.
    Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 15.03.2021.
           
:file:    ParameterControlServicer_servicer.py
:authors: Lukas Bromig

:date: (creation)          2021-03-16T12:40:00.424959
:date: (last modification) 2021-03-16T12:40:00.424959

.. note:: Code generated by sila2codegenerator 0.3.3-dev

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import ParameterControlServicer_pb2 as ParameterControlServicer_pb2
from .gRPC import ParameterControlServicer_pb2_grpc as ParameterControlServicer_pb2_grpc

# import simulation and real implementation
from .ParameterControlServicer_simulation import ParameterControlServicerSimulation
from .ParameterControlServicer_real import ParameterControlServicerReal


class ParameterControlServicer(ParameterControlServicer_pb2_grpc.ParameterControlServicerServicer):
    """
    This is a RegloDC Service
    """
    implementation: Union[ParameterControlServicerSimulation, ParameterControlServicerReal]
    simulation_mode: bool

    def __init__(self, properties, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.properties = properties
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(ParameterControlServicerSimulation(properties=self.properties))
        else:
            self._inject_implementation(ParameterControlServicerReal(properties=self.properties))

    def _inject_implementation(self,
                               implementation: Union[ParameterControlServicerSimulation,
                                                     ParameterControlServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the RegloDCServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(ParameterControlServicerSimulation(properties=self.properties))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(ParameterControlServicerReal(properties=self.properties))

    def SetRPMMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetRPMMode_Responses:
        """
        Executes the unobservable command "Set RPM Mode"
            Set the pump mode to RPM mode (MODE PUMP% rpm).
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): RPM pump mode successfully set.
        """
    
        logging.debug(
            "SetRPMMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetRPMMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetFlowRateMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetFlowRateMode_Responses:
        """
        Executes the unobservable command "Set Flow Rate Mode"
            Set the pump mode to Flow Rate mode (MODE PUMP% Flow rate).
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Flow rate pump mode successfully set.
        """
    
        logging.debug(
            "SetFlowRateMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetFlowRateMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDispenseVolumeMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetDispenseVolumeMode_Responses:
        """
        Executes the unobservable command "Set Dispense Volume Mode"
            Set the pump mode to dispense volume mode (MODE DISP Volume).
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Dispense volume pump mode successfully set.
        """
    
        logging.debug(
            "SetDispenseVolumeMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDispenseVolumeMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDispenseTimeMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetDispenseTimeMode_Responses:
        """
        Executes the unobservable command "Set Dispense Time Mode"
            Set the pump mode to dispense time mode (MODE DISP Time).
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Dispense time pump mode successfully set.
        """
    
        logging.debug(
            "SetDispenseTimeMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDispenseTimeMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetPauseTimeMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetPauseTimeMode_Responses:
        """
        Executes the unobservable command "Set Pause Time Mode"
            Set the current pump mode to pause-time mode (MODE PAUSE Time).
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Pause time pump mode successfully set.
        """
    
        logging.debug(
            "SetPauseTimeMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetPauseTimeMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDispenseTimePauseTimeMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetDispenseTimePauseTimeMode_Responses:
        """
        Executes the unobservable command "Set Time Mode"
            Set the pump mode to dispense time/ pause time mode (DISP Time + PAUSE Time).
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Dispense time/ pause time pump mode successfully set.
        """
    
        logging.debug(
            "SetDispenseTimePauseTimeMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDispenseTimePauseTimeMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDispenseVolumePauseTimeMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetDispenseVolumePauseTimeMode_Responses:
        """
        Executes the unobservable command "Set Dispense Volume Pause Time Mode"
            Set the pump mode to dispense volume/ pause time mode (DISP Volume + PAUSE Time).
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Dispense volume/ pause time pump mode successfully set.
        """
    
        logging.debug(
            "SetDispenseVolumePauseTimeMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDispenseVolumePauseTimeMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetDispenseVolume(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetDispenseVolume_Responses:
        """
        Executes the unobservable command "Get Dispense Volume"
            Get the current setting for the dispensing volume in mL/min.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.DispenseVolume (Dispense Volume): Current setting for the dispensing volume in mL/min.
        """
    
        logging.debug(
            "GetDispenseVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetDispenseVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDispenseVolume(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetDispenseVolume_Responses:
        """
        Executes the unobservable command "Set Dispense Volume"
            Set the dispensing volume in mL.
    
        :param request: gRPC request containing the parameters passed:
            request.Volume (Volume):
            The volume to be set in mL.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.VolumeSet (Volume Set): Volume successfully set
        """
    
        logging.debug(
            "SetDispenseVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDispenseVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDispenseVolumeModeVolume(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetDispenseVolumeModeVolume_Responses:
        """
        Executes the unobservable command "Set Dispense Volume Mode Volume"
            Set the dispensing volume for the mode DISP Volume in mL (The entered dispensing volume is rounded down to complete roller steps).
    
        :param request: gRPC request containing the parameters passed:
            request.Volume (Volume):
            The dispensing volume  to be set in mL for mode DISP Volume.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.VolumeSet (Volume Set): Volume successfully set
        """
    
        logging.debug(
            "SetDispenseVolumeModeVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDispenseVolumeModeVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetFlowRate(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetFlowRate_Responses:
        """
        Executes the unobservable command "Get Flow Rate"
            Get current flow rate (mL/min).
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFlowRate (Current Flow Rate): Current flow rate of the pump.
        """
    
        logging.debug(
            "GetFlowRate called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetFlowRate(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetFlowRate(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetFlowRate_Responses:
        """
        Executes the unobservable command "Set Flow Rate"
            Set current flow rate (mL/min).
    
        :param request: gRPC request containing the parameters passed:
            request.FlowRate (Flow Rate):
            Set flow rate in mL/min.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetFlowRateSet (Set Flow Rate): Flow rate in mL/min successfully set
        """
    
        logging.debug(
            "SetFlowRate called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetFlowRate(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetRPM(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetRPM_Responses:
        """
        Executes the unobservable command "Get RPM"
            Get current rpm.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentRPM (Current RPM): Current rpm of the pump.
        """
    
        logging.debug(
            "GetRPM called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetRPM(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetRPM(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetRPM_Responses:
        """
        Executes the unobservable command "Set RPM"
            Set pump speed in rpm (100 - 10000 (4 channel type); 160 - 16000 (2 channel type)).
    
        :param request: gRPC request containing the parameters passed:
            request.RPM (RPM):
            Set pump speed in rpm (0.1 - 1000 (4 channel type); 0.16 - 1600 (2 channel type)).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetRPMSet (Set RPM): RPM successfully set
        """
    
        logging.debug(
            "SetRPM called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetRPM(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetPauseTime(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetPauseTime_Responses:
        """
        Executes the unobservable command "Get Pause Time"
            Get pause time in s.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPauseTime (Current Pause Pause Time): Current pause time in s.
        """
    
        logging.debug(
            "GetPauseTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPauseTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetPauseTime(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetPauseTime_Responses:
        """
        Executes the unobservable command "Set Pause Time"
            Set pause time in s, min, and h.
    
        :param request: gRPC request containing the parameters passed:
            request.PauseTimeS (Pause Time S):
            Set pumping pause time in s. (0 - 999.9).
            request.PauseTimeMin (Pause Time Min):
            Set pumping pause time in min. (0 - 899).
            request.PauseTimeH (Pause Time H):
            Set pumping pause time in H. (0 - 999).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetPauseTimeSet (Set Pause Time): Pumping pause time successfully set.
        """
    
        logging.debug(
            "SetPauseTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetPauseTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetDispenseCycles(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetDispenseCycles_Responses:
        """
        Executes the unobservable command "Get Dispense Cycle"
            Get number of dispense cycles.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.DispenseCycles (Dispense Cycles): Number of dispense cycles.
        """
    
        logging.debug(
            "GetDispenseCycles called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetDispenseCycles(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDispenseCycles(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetDispenseCycles_Responses:
        """
        Executes the unobservable command "Set Dispense Cycles"
            Set number of dispensing cycles (integer).
    
        :param request: gRPC request containing the parameters passed:
            request.DispenseCycles (Dispense Cycles):
            The number of dispense cycles to be set.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetDispenseCycleSet (Set Dispense Cycle): Number of dispense cycles successfully set.
        """
    
        logging.debug(
            "SetDispenseCycles called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDispenseCycles(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetDispenseTime(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetDispenseTime_Responses:
        """
        Executes the unobservable command "Get Dispense Time"
            Get the time to dispense in s.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDispenseTime (CurrentDispenseTime): CurrentDispenseTime in s.
        """
    
        logging.debug(
            "GetDispenseTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetDispenseTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDispenseTime(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetDispenseTime_Responses:
        """
        Executes the unobservable command "Set Dispense Time"
            Set the time to dispense in s, min, and h.
    
        :param request: gRPC request containing the parameters passed:
            request.CurrentDispenseTimeS (Current Dispense Time S): Current dispense time in s (0 - 999).
            request.CurrentDispenseTimeMin (Current Dispense Time Min): Current dispense time in min (0 - 899).
            request.CurrentDispenseTimeH (Current Dispense Time H): Current dispense time in h (0 - 999).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetDispenseTimeSet (Set Dispense Time S): The dispense time in s was set.
        """
    
        logging.debug(
            "SetDispenseTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDispenseTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetRollerSteps(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetRollerSteps_Responses:
        """
        Executes the unobservable command "Get Roller Steps"
            Get roller steps for mode DISP Volume.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentRollerSteps (Current Roller Steps): Current roller steps for mode DISP Volume.
        """
    
        logging.debug(
            "GetRollerSteps called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetRollerSteps(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetRollerSteps(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetRollerSteps_Responses:
        """
        Executes the unobservable command "Set Roller Steps"
            Set the roller steps for mode DISP Volume.
    
        :param request: gRPC request containing the parameters passed:
            request.CurrentRollerSteps (Current Roller Steps): Current roller steps for mode DISP Volume.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetRollerStepsSet (Set Current Roller Steps Set): The set roller steps for mode DISP Volume.
        """
    
        logging.debug(
            "SetRollerSteps called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetRollerSteps(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetRollerStepVolume(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetRollerStepVolume_Responses:
        """
        Executes the unobservable command "Get Roller Step Volume"
            Get roller step volume in nano-liters (nL).
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentRollerStepVolume (Current Roller Step Volume): Current roller step volume in nano-liters (nL).
        """
    
        logging.debug(
            "GetRollerStepVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetRollerStepVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetRollerStepVolume(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetRollerStepVolume_Responses:
        """
        Executes the unobservable command "Set Roller Step Volume"
            Set the roller step volume in nano-liters (nL).
    
        :param request: gRPC request containing the parameters passed:
            request.CurrentRollerStepVolume (Current Roller Step Volume): Current roller step volume in nano-liters (nL).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetRollerStepVolumeSet (Set Current Roller Step Volume Set): The set roller step volume in nano-liters (nL).
        """
    
        logging.debug(
            "SetRollerStepVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetRollerStepVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def ResetRollerStepVolume(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.ResetRollerStepVolume_Responses:
        """
        Executes the unobservable command "Reset Roller Step Volume"
            Reset the roller step volume back to default.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ResetRollerStepVolumeSet (Reset Current Roller Step Volume Set): The roller step volume is set to default.
        """
    
        logging.debug(
            "ResetRollerStepVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.ResetRollerStepVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetRollerBackSteps(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetRollerBackSteps_Responses:
        """
        Executes the unobservable command "Get Roller Back Steps"
            Get roller back-steps (0 - 100).
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentRollerBackSteps (Current Roller Back Step): Current roller back-steps (0 - 100).
        """
    
        logging.debug(
            "GetRollerBackSteps called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetRollerBackSteps(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetRollerBackSteps(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetRollerBackSteps_Responses:
        """
        Executes the unobservable command "Set Roller Back Steps"
            Set the roller back-steps (1 - 100).
    
        :param request: gRPC request containing the parameters passed:
            request.CurrentRollerBackSteps (Current Roller Back Step): Current roller back-steps (0 - 100).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetRollerBackStepsSet (Set Current Roller Back Steps Set): The set roller back-steps (0 - 100).
        """
    
        logging.debug(
            "SetRollerBackSteps called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetRollerBackSteps(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SaveApplicationParameters(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SaveApplicationParameters_Responses:
        """
        Executes the unobservable command "Save Application Parameters"
            Save changes made to the application parameters in this feature.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SaveResponse (Save Response): The response of this command
        """
    
        logging.debug(
            "SaveApplicationParameters called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SaveApplicationParameters(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetTubingDiameter(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetTubingDiameter_Responses:
        """
        Executes the unobservable command "Get Tubing Diameter"
            Get the inside diameter of the tubing in mm.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTubingDiameter (Current Tubing Diameter): Current the inside diameter of the tubing in mm.
        """
    
        logging.debug(
            "GetTubingDiameter called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetTubingDiameter(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetTubingDiameter(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetTubingDiameter_Responses:
        """
        Executes the unobservable command "Set Tubing Inside Diameter Value"
            Set the inside diameter of the tubing in mm.
    
        :param request: gRPC request containing the parameters passed:
            request.TubingDiameter (Tubing Diameter):
            The inside diameter of the tubing in mm. (must be one of following list:
            [0.13,0.19,0.25,0.38,0.44,0.51,0.57,0.64,0.76,0.89,0.95,1.02,1.09,1.14,1.22,1.3,1.42,1.52,1.65,1.75,1.85,2.06,2.29,2.54,2.79,3.17])
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.TubingDiameterSet (Tubing Diameter Set): Tubing Diameter succeeded to Set.
        """
    
        logging.debug(
            "SetTubingDiameter called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetTubingDiameter(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
