#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*RegloDCService client*

:details: RegloDCService:
    This is a RegloDC Service

:file:    RegloDCService_client.py
:authors: Lukas Bromig

:date: (creation)          2021-03-16T12:40:00.627294
:date: (last modification) 2021-03-16T12:40:00.627294

.. note:: Code generated by sila2codegenerator 0.3.3-dev

_______________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

# import general packages
import logging
import argparse
import grpc
import time

# import meta packages
from typing import Union, Optional

# import SiLA2 library modules
from sila2lib.framework import SiLAFramework_pb2 as silaFW_pb2
from sila2lib.sila_client import SiLA2Client
from sila2lib.framework.std_features import SiLAService_pb2 as SiLAService_feature_pb2
from sila2lib.error_handling import client_err
#   Usually not needed, but - feel free to modify
# from sila2lib.framework.std_features import SimulationController_pb2 as SimController_feature_pb2

# import feature gRPC modules
# Import gRPC libraries of features
from CalibrationServicer.gRPC import CalibrationServicer_pb2
from CalibrationServicer.gRPC import CalibrationServicer_pb2_grpc
# import default arguments for this feature
from CalibrationServicer.CalibrationServicer_default_arguments import default_dict as CalibrationServicer_default_dict
from DeviceServicer.gRPC import DeviceServicer_pb2
from DeviceServicer.gRPC import DeviceServicer_pb2_grpc
# import default arguments for this feature
from DeviceServicer.DeviceServicer_default_arguments import default_dict as DeviceServicer_default_dict
from DriveControlServicer.gRPC import DriveControlServicer_pb2
from DriveControlServicer.gRPC import DriveControlServicer_pb2_grpc
# import default arguments for this feature
from DriveControlServicer.DriveControlServicer_default_arguments import default_dict as DriveControlServicer_default_dict
from ParameterControlServicer.gRPC import ParameterControlServicer_pb2
from ParameterControlServicer.gRPC import ParameterControlServicer_pb2_grpc
# import default arguments for this feature
from ParameterControlServicer.ParameterControlServicer_default_arguments import default_dict as ParameterControlServicer_default_dict


# noinspection PyPep8Naming, PyUnusedLocal
class RegloDCServiceClient(SiLA2Client):
    """
        This is a RegloDC Service

    .. note:: For an example on how to construct the parameter or read the response(s) for command calls and properties,
              compare the default dictionary that is stored in the directory of the corresponding feature.
    """
    # The following variables will be filled when run() is executed
    #: Storage for the connected servers version
    server_version: str = ''
    #: Storage for the display name of the connected server
    server_display_name: str = ''
    #: Storage for the description of the connected server
    server_description: str = ''

    def __init__(self,
                 name: str = "RegloDCServiceClient", description: str = "This is a RegloDC Service",
                 server_name: Optional[str] = None,
                 client_uuid: Optional[str] = None,
                 version: str = __version__,
                 vendor_url: str = "",
                 server_hostname: str = "localhost", server_ip: str = "127.0.0.1", server_port: int = 50015,
                 cert_file: Optional[str] = None):
        """Class initialiser"""
        super().__init__(
            name=name, description=description,
            server_name=server_name,
            client_uuid=client_uuid,
            version=version,
            vendor_url=vendor_url,
            server_hostname=server_hostname, server_ip=server_ip, server_port=server_port,
            cert_file=cert_file
        )

        logging.info(
            "Starting SiLA2 service client for service RegloDCService with service name: {server_name}".format(
                server_name=name
            )
        )

        # Create stub objects used to communicate with the server
        self.CalibrationServicer_stub = \
            CalibrationServicer_pb2_grpc.CalibrationServicerStub(self.channel)
        self.DeviceServicer_stub = \
            DeviceServicer_pb2_grpc.DeviceServicerStub(self.channel)
        self.DriveControlServicer_stub = \
            DriveControlServicer_pb2_grpc.DriveControlServicerStub(self.channel)
        self.ParameterControlServicer_stub = \
            ParameterControlServicer_pb2_grpc.ParameterControlServicerStub(self.channel)

        # initialise class variables for server information storage
        self.server_version = ''
        self.server_display_name = ''
        self.server_description = ''

    def Get_ImplementedFeatures(self):
        """Get a list of all implemented features."""
        # type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Retrieving the list of implemented features of the server:")
        try:
            response = self.SiLAService_stub.Get_ImplementedFeatures(
                SiLAService_feature_pb2.Get_ImplementedFeatures_Parameters()
            )
            for feature_id in response.ImplementedFeatures:
                logging.debug("Implemented feature: {feature_id}".format(
                    feature_id=feature_id.value)
                    )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

        return response.ImplementedFeatures

    def Get_FeatureDefinition(self, feature_identifier: str) -> Union[str, None]:
        """
        Returns the FDL/XML feature definition of the given feature.

        :param feature_identifier: The name of the feature for which the definition should be returned.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Requesting feature definitions of feature {feature_identifier}:".format(
            feature_identifier=feature_identifier)
        )
        try:
            response = self.SiLAService_stub.GetFeatureDefinition(
                SiLAService_feature_pb2.GetFeatureDefinition_Parameters(
                    QualifiedFeatureIdentifier=silaFW_pb2.String(value=feature_identifier)
                    )
                )
            logging.debug("Response of GetFeatureDefinition for {feature_identifier} feature: {response}".format(
                response=response,
                feature_identifier=feature_identifier)
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

    def run(self) -> bool:
        """
        Starts the actual client and retrieves the meta-information from the server.

        :returns: True or False whether the connection to the server is established.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        try:
            # Retrieve the basic server information and store it in internal class variables
            #   Display name
            response = self.SiLAService_stub.Get_ServerName(SiLAService_feature_pb2.Get_ServerName_Parameters())
            self.server_display_name = response.ServerName.value
            logging.debug("Display name: {name}".format(name=response.ServerName.value))
            # Server description
            response = self.SiLAService_stub.Get_ServerDescription(
                SiLAService_feature_pb2.Get_ServerDescription_Parameters()
            )
            self.server_description = response.ServerDescription.value
            logging.debug("Description: {description}".format(description=response.ServerDescription.value))
            # Server version
            response = self.SiLAService_stub.Get_ServerVersion(SiLAService_feature_pb2.Get_ServerVersion_Parameters())
            self.server_version = response.ServerVersion.value
            logging.debug("Version: {version}".format(version=response.ServerVersion.value))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return False

        return True

    def stop(self, force: bool = False) -> bool:
        """
        Stop SiLA client routine

        :param force: If set True, the client is supposed to disconnect and stop immediately. Otherwise it can first try
                      to finish what it is doing.

        :returns: Whether the client could be stopped successfully or not.
        """
        # TODO: Implement all routines that have to be executed when the client is stopped.
        #   Feel free to use the "force" parameter to abort any running processes. Or crash your machine. Your call!
        return True

    def StartCalibrationTime(self,
                      parameter: CalibrationServicer_pb2.StartCalibrationTime_Parameters = None) \
            -> CalibrationServicer_pb2.StartCalibrationTime_Responses:
        """
        Wrapper to call the unobservable command StartCalibrationTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling StartCalibrationTime:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.StartCalibrationTime_Parameters(
                    **CalibrationServicer_default_dict['StartCalibrationTime_Parameters']
                )
    
            response = self.CalibrationServicer_stub.StartCalibrationTime(parameter)
    
            logging.debug('StartCalibrationTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def StartCalibrationVolume(self,
                      parameter: CalibrationServicer_pb2.StartCalibrationVolume_Parameters = None) \
            -> CalibrationServicer_pb2.StartCalibrationVolume_Responses:
        """
        Wrapper to call the unobservable command StartCalibrationVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling StartCalibrationVolume:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.StartCalibrationVolume_Parameters(
                    **CalibrationServicer_default_dict['StartCalibrationVolume_Parameters']
                )
    
            response = self.CalibrationServicer_stub.StartCalibrationVolume(parameter)
    
            logging.debug('StartCalibrationVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetDefaultFlowRate(self,
                      parameter: CalibrationServicer_pb2.GetDefaultFlowRate_Parameters = None) \
            -> CalibrationServicer_pb2.GetDefaultFlowRate_Responses:
        """
        Wrapper to call the unobservable command GetDefaultFlowRate on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetDefaultFlowRate:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetDefaultFlowRate_Parameters(
                    **CalibrationServicer_default_dict['GetDefaultFlowRate_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetDefaultFlowRate(parameter)
    
            logging.debug('GetDefaultFlowRate response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetCalibratedFlowRate(self,
                      parameter: CalibrationServicer_pb2.GetCalibratedFlowRate_Parameters = None) \
            -> CalibrationServicer_pb2.GetCalibratedFlowRate_Responses:
        """
        Wrapper to call the unobservable command GetCalibratedFlowRate on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCalibratedFlowRate:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetCalibratedFlowRate_Parameters(
                    **CalibrationServicer_default_dict['GetCalibratedFlowRate_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetCalibratedFlowRate(parameter)
    
            logging.debug('GetCalibratedFlowRate response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetCalibratedFlowRate(self,
                      parameter: CalibrationServicer_pb2.SetCalibratedFlowRate_Parameters = None) \
            -> CalibrationServicer_pb2.SetCalibratedFlowRate_Responses:
        """
        Wrapper to call the unobservable command SetCalibratedFlowRate on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCalibratedFlowRate:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.SetCalibratedFlowRate_Parameters(
                    **CalibrationServicer_default_dict['SetCalibratedFlowRate_Parameters']
                )
    
            response = self.CalibrationServicer_stub.SetCalibratedFlowRate(parameter)
    
            logging.debug('SetCalibratedFlowRate response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetCalibrationTargetVolume(self,
                      parameter: CalibrationServicer_pb2.SetCalibrationTargetVolume_Parameters = None) \
            -> CalibrationServicer_pb2.SetCalibrationTargetVolume_Responses:
        """
        Wrapper to call the unobservable command SetCalibrationTargetVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCalibrationTargetVolume:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.SetCalibrationTargetVolume_Parameters(
                    **CalibrationServicer_default_dict['SetCalibrationTargetVolume_Parameters']
                )
    
            response = self.CalibrationServicer_stub.SetCalibrationTargetVolume(parameter)
    
            logging.debug('SetCalibrationTargetVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetCalibrationTargetTime(self,
                      parameter: CalibrationServicer_pb2.SetCalibrationTargetTime_Parameters = None) \
            -> CalibrationServicer_pb2.SetCalibrationTargetTime_Responses:
        """
        Wrapper to call the unobservable command SetCalibrationTargetTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCalibrationTargetTime:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.SetCalibrationTargetTime_Parameters(
                    **CalibrationServicer_default_dict['SetCalibrationTargetTime_Parameters']
                )
    
            response = self.CalibrationServicer_stub.SetCalibrationTargetTime(parameter)
    
            logging.debug('SetCalibrationTargetTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetActualVolume(self,
                      parameter: CalibrationServicer_pb2.SetActualVolume_Parameters = None) \
            -> CalibrationServicer_pb2.SetActualVolume_Responses:
        """
        Wrapper to call the unobservable command SetActualVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActualVolume:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.SetActualVolume_Parameters(
                    **CalibrationServicer_default_dict['SetActualVolume_Parameters']
                )
    
            response = self.CalibrationServicer_stub.SetActualVolume(parameter)
    
            logging.debug('SetActualVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetTargetVolume(self,
                      parameter: CalibrationServicer_pb2.GetTargetVolume_Parameters = None) \
            -> CalibrationServicer_pb2.GetTargetVolume_Responses:
        """
        Wrapper to call the unobservable command GetTargetVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetTargetVolume:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetTargetVolume_Parameters(
                    **CalibrationServicer_default_dict['GetTargetVolume_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetTargetVolume(parameter)
    
            logging.debug('GetTargetVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetActualTime(self,
                      parameter: CalibrationServicer_pb2.SetActualTime_Parameters = None) \
            -> CalibrationServicer_pb2.SetActualTime_Responses:
        """
        Wrapper to call the unobservable command SetActualTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActualTime:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.SetActualTime_Parameters(
                    **CalibrationServicer_default_dict['SetActualTime_Parameters']
                )
    
            response = self.CalibrationServicer_stub.SetActualTime(parameter)
    
            logging.debug('SetActualTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetTargetTime(self,
                      parameter: CalibrationServicer_pb2.GetTargetTime_Parameters = None) \
            -> CalibrationServicer_pb2.GetTargetTime_Responses:
        """
        Wrapper to call the unobservable command GetTargetTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetTargetTime:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetTargetTime_Parameters(
                    **CalibrationServicer_default_dict['GetTargetTime_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetTargetTime(parameter)
    
            logging.debug('GetTargetTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetDirectionCalibration(self,
                      parameter: CalibrationServicer_pb2.SetDirectionCalibration_Parameters = None) \
            -> CalibrationServicer_pb2.SetDirectionCalibration_Responses:
        """
        Wrapper to call the unobservable command SetDirectionCalibration on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDirectionCalibration:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.SetDirectionCalibration_Parameters(
                    **CalibrationServicer_default_dict['SetDirectionCalibration_Parameters']
                )
    
            response = self.CalibrationServicer_stub.SetDirectionCalibration(parameter)
    
            logging.debug('SetDirectionCalibration response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetDirectionCalibration(self,
                      parameter: CalibrationServicer_pb2.GetDirectionCalibration_Parameters = None) \
            -> CalibrationServicer_pb2.GetDirectionCalibration_Responses:
        """
        Wrapper to call the unobservable command GetDirectionCalibration on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetDirectionCalibration:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetDirectionCalibration_Parameters(
                    **CalibrationServicer_default_dict['GetDirectionCalibration_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetDirectionCalibration(parameter)
    
            logging.debug('GetDirectionCalibration response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetLastCalibrationTime(self,
                      parameter: CalibrationServicer_pb2.GetLastCalibrationTime_Parameters = None) \
            -> CalibrationServicer_pb2.GetLastCalibrationTime_Responses:
        """
        Wrapper to call the unobservable command GetLastCalibrationTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetLastCalibrationTime:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetLastCalibrationTime_Parameters(
                    **CalibrationServicer_default_dict['GetLastCalibrationTime_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetLastCalibrationTime(parameter)
    
            logging.debug('GetLastCalibrationTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetLog(self,
                      parameter: DeviceServicer_pb2.GetLog_Parameters = None) \
            -> silaFW_pb2.CommandConfirmation:
        """
        Wrapper to call the observable command GetLog on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A command confirmation object with the following information:
            commandExecutionUUID: A command id with which this observable command can be referenced in future calls
            lifetimeOfExecution (optional): The (maximum) lifetime of this command call.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetLog:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.GetLog_Parameters(
                    **DeviceServicer_default_dict['GetLog_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetLog(parameter)
    
            logging.debug('GetLog response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetLog_Info(self,
                           uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) \
            -> silaFW_pb2.ExecutionInfo:
        """
        Wrapper to get an intermediate response for the observable command GetLog on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the status information that has been defined for this command. The following fields
                  are defined:
                    * *commandStatus*: Status of the command (enumeration)
                    * *progressInfo*: Information on the progress of the command (0 to 1)
                    * *estimatedRemainingTime*: Estimate of the remaining time required to run the command
                    * *updatedLifetimeOfExecution*: An update on the execution lifetime
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        logging.debug(
            "Requesting status information for command GetLog (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
        try:
            response = self.DeviceServicer_stub.GetLog_Info(uuid)
            logging.debug('GetLog status information: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetLog_Result(self,
                             uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) \
            -> DeviceServicer_pb2.GetLog_Responses:
        """
        Wrapper to get an intermediate response for the observable command GetLog on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the result response that has been defined for this command.
    
        .. note:: Whether the result is available or not can and should be evaluated by calling the
                  :meth:`GetLog_Info` method of this call.
        """
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        logging.debug(
            "Requesting status information for command GetLog (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
    
        try:
            response = self.DeviceServicer_stub.GetLog_Result(uuid)
            logging.debug('GetLog result response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetPumpAddress(self,
                      parameter: DeviceServicer_pb2.SetPumpAddress_Parameters = None) \
            -> DeviceServicer_pb2.SetPumpAddress_Responses:
        """
        Wrapper to call the unobservable command SetPumpAddress on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetPumpAddress:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.SetPumpAddress_Parameters(
                    **DeviceServicer_default_dict['SetPumpAddress_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetPumpAddress(parameter)
    
            logging.debug('SetPumpAddress response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetPumpStatus(self,
                      parameter: DeviceServicer_pb2.GetPumpStatus_Parameters = None) \
            -> DeviceServicer_pb2.GetPumpStatus_Responses:
        """
        Wrapper to call the unobservable command GetPumpStatus on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPumpStatus:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.GetPumpStatus_Parameters(
                    **DeviceServicer_default_dict['GetPumpStatus_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetPumpStatus(parameter)
    
            logging.debug('GetPumpStatus response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetVersionType(self,
                      parameter: DeviceServicer_pb2.GetVersionType_Parameters = None) \
            -> DeviceServicer_pb2.GetVersionType_Responses:
        """
        Wrapper to call the unobservable command GetVersionType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersionType:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.GetVersionType_Parameters(
                    **DeviceServicer_default_dict['GetVersionType_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetVersionType(parameter)
    
            logging.debug('GetVersionType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetVersionSoftware(self,
                      parameter: DeviceServicer_pb2.GetVersionSoftware_Parameters = None) \
            -> DeviceServicer_pb2.GetVersionSoftware_Responses:
        """
        Wrapper to call the unobservable command GetVersionSoftware on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersionSoftware:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.GetVersionSoftware_Parameters(
                    **DeviceServicer_default_dict['GetVersionSoftware_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetVersionSoftware(parameter)
    
            logging.debug('GetVersionSoftware response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetPumpID(self,
                      parameter: DeviceServicer_pb2.GetPumpID_Parameters = None) \
            -> DeviceServicer_pb2.GetPumpID_Responses:
        """
        Wrapper to call the unobservable command GetPumpID on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPumpID:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.GetPumpID_Parameters(
                    **DeviceServicer_default_dict['GetPumpID_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetPumpID(parameter)
    
            logging.debug('GetPumpID response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetPumpID(self,
                      parameter: DeviceServicer_pb2.SetPumpID_Parameters = None) \
            -> DeviceServicer_pb2.SetPumpID_Responses:
        """
        Wrapper to call the unobservable command SetPumpID on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetPumpID:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.SetPumpID_Parameters(
                    **DeviceServicer_default_dict['SetPumpID_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetPumpID(parameter)
    
            logging.debug('SetPumpID response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ResetToDefault(self,
                      parameter: DeviceServicer_pb2.ResetToDefault_Parameters = None) \
            -> DeviceServicer_pb2.ResetToDefault_Responses:
        """
        Wrapper to call the unobservable command ResetToDefault on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling ResetToDefault:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.ResetToDefault_Parameters(
                    **DeviceServicer_default_dict['ResetToDefault_Parameters']
                )
    
            response = self.DeviceServicer_stub.ResetToDefault(parameter)
    
            logging.debug('ResetToDefault response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetTotalVolume(self,
                      parameter: DeviceServicer_pb2.GetTotalVolume_Parameters = None) \
            -> DeviceServicer_pb2.GetTotalVolume_Responses:
        """
        Wrapper to call the unobservable command GetTotalVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetTotalVolume:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.GetTotalVolume_Parameters(
                    **DeviceServicer_default_dict['GetTotalVolume_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetTotalVolume(parameter)
    
            logging.debug('GetTotalVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ResetTotalVolume(self,
                      parameter: DeviceServicer_pb2.ResetTotalVolume_Parameters = None) \
            -> DeviceServicer_pb2.ResetTotalVolume_Responses:
        """
        Wrapper to call the unobservable command ResetTotalVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling ResetTotalVolume:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.ResetTotalVolume_Parameters(
                    **DeviceServicer_default_dict['ResetTotalVolume_Parameters']
                )
    
            response = self.DeviceServicer_stub.ResetTotalVolume(parameter)
    
            logging.debug('ResetTotalVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def UnlockControlPanel(self,
                      parameter: DeviceServicer_pb2.UnlockControlPanel_Parameters = None) \
            -> DeviceServicer_pb2.UnlockControlPanel_Responses:
        """
        Wrapper to call the unobservable command UnlockControlPanel on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling UnlockControlPanel:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.UnlockControlPanel_Parameters(
                    **DeviceServicer_default_dict['UnlockControlPanel_Parameters']
                )
    
            response = self.DeviceServicer_stub.UnlockControlPanel(parameter)
    
            logging.debug('UnlockControlPanel response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LockControlPanel(self,
                      parameter: DeviceServicer_pb2.LockControlPanel_Parameters = None) \
            -> DeviceServicer_pb2.LockControlPanel_Responses:
        """
        Wrapper to call the unobservable command LockControlPanel on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling LockControlPanel:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.LockControlPanel_Parameters(
                    **DeviceServicer_default_dict['LockControlPanel_Parameters']
                )
    
            response = self.DeviceServicer_stub.LockControlPanel(parameter)
    
            logging.debug('LockControlPanel response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetDisplayNumbers(self,
                      parameter: DeviceServicer_pb2.SetDisplayNumbers_Parameters = None) \
            -> DeviceServicer_pb2.SetDisplayNumbers_Responses:
        """
        Wrapper to call the unobservable command SetDisplayNumbers on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDisplayNumbers:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.SetDisplayNumbers_Parameters(
                    **DeviceServicer_default_dict['SetDisplayNumbers_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetDisplayNumbers(parameter)
    
            logging.debug('SetDisplayNumbers response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetDisplayLetters(self,
                      parameter: DeviceServicer_pb2.SetDisplayLetters_Parameters = None) \
            -> DeviceServicer_pb2.SetDisplayLetters_Responses:
        """
        Wrapper to call the unobservable command SetDisplayLetters on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDisplayLetters:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.SetDisplayLetters_Parameters(
                    **DeviceServicer_default_dict['SetDisplayLetters_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetDisplayLetters(parameter)
    
            logging.debug('SetDisplayLetters response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetCommunicationPort(self,
                      parameter: DeviceServicer_pb2.SetCommunicationPort_Parameters = None) \
            -> DeviceServicer_pb2.SetCommunicationPort_Responses:
        """
        Wrapper to call the unobservable command SetCommunicationPort on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCommunicationPort:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.SetCommunicationPort_Parameters(
                    **DeviceServicer_default_dict['SetCommunicationPort_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetCommunicationPort(parameter)
    
            logging.debug('SetCommunicationPort response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ConnectDevice(self,
                      parameter: DeviceServicer_pb2.ConnectDevice_Parameters = None) \
            -> DeviceServicer_pb2.ConnectDevice_Responses:
        """
        Wrapper to call the unobservable command ConnectDevice on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling ConnectDevice:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.ConnectDevice_Parameters(
                    **DeviceServicer_default_dict['ConnectDevice_Parameters']
                )
    
            response = self.DeviceServicer_stub.ConnectDevice(parameter)
    
            logging.debug('ConnectDevice response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ResetOverload(self,
                      parameter: DeviceServicer_pb2.ResetOverload_Parameters = None) \
            -> DeviceServicer_pb2.ResetOverload_Responses:
        """
        Wrapper to call the unobservable command ResetOverload on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling ResetOverload:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.ResetOverload_Parameters(
                    **DeviceServicer_default_dict['ResetOverload_Parameters']
                )
    
            response = self.DeviceServicer_stub.ResetOverload(parameter)
    
            logging.debug('ResetOverload response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def StartPump(self,
                      parameter: DriveControlServicer_pb2.StartPump_Parameters = None) \
            -> DriveControlServicer_pb2.StartPump_Responses:
        """
        Wrapper to call the unobservable command StartPump on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling StartPump:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DriveControlServicer_pb2.StartPump_Parameters(
                    **DriveControlServicer_default_dict['StartPump_Parameters']
                )
    
            response = self.DriveControlServicer_stub.StartPump(parameter)
    
            logging.debug('StartPump response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def StopPump(self,
                      parameter: DriveControlServicer_pb2.StopPump_Parameters = None) \
            -> DriveControlServicer_pb2.StopPump_Responses:
        """
        Wrapper to call the unobservable command StopPump on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling StopPump:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DriveControlServicer_pb2.StopPump_Parameters(
                    **DriveControlServicer_default_dict['StopPump_Parameters']
                )
    
            response = self.DriveControlServicer_stub.StopPump(parameter)
    
            logging.debug('StopPump response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetPumpDirection(self,
                      parameter: DriveControlServicer_pb2.GetPumpDirection_Parameters = None) \
            -> DriveControlServicer_pb2.GetPumpDirection_Responses:
        """
        Wrapper to call the unobservable command GetPumpDirection on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPumpDirection:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DriveControlServicer_pb2.GetPumpDirection_Parameters(
                    **DriveControlServicer_default_dict['GetPumpDirection_Parameters']
                )
    
            response = self.DriveControlServicer_stub.GetPumpDirection(parameter)
    
            logging.debug('GetPumpDirection response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetDirectionClockwise(self,
                      parameter: DriveControlServicer_pb2.SetDirectionClockwise_Parameters = None) \
            -> DriveControlServicer_pb2.SetDirectionClockwise_Responses:
        """
        Wrapper to call the unobservable command SetDirectionClockwise on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDirectionClockwise:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DriveControlServicer_pb2.SetDirectionClockwise_Parameters(
                    **DriveControlServicer_default_dict['SetDirectionClockwise_Parameters']
                )
    
            response = self.DriveControlServicer_stub.SetDirectionClockwise(parameter)
    
            logging.debug('SetDirectionClockwise response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetDirectionCounterClockwise(self,
                      parameter: DriveControlServicer_pb2.SetDirectionCounterClockwise_Parameters = None) \
            -> DriveControlServicer_pb2.SetDirectionCounterClockwise_Responses:
        """
        Wrapper to call the unobservable command SetDirectionCounterClockwise on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDirectionCounterClockwise:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DriveControlServicer_pb2.SetDirectionCounterClockwise_Parameters(
                    **DriveControlServicer_default_dict['SetDirectionCounterClockwise_Parameters']
                )
    
            response = self.DriveControlServicer_stub.SetDirectionCounterClockwise(parameter)
    
            logging.debug('SetDirectionCounterClockwise response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetRPMMode(self,
                      parameter: ParameterControlServicer_pb2.SetRPMMode_Parameters = None) \
            -> ParameterControlServicer_pb2.SetRPMMode_Responses:
        """
        Wrapper to call the unobservable command SetRPMMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetRPMMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetRPMMode_Parameters(
                    **ParameterControlServicer_default_dict['SetRPMMode_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetRPMMode(parameter)
    
            logging.debug('SetRPMMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetFlowRateMode(self,
                      parameter: ParameterControlServicer_pb2.SetFlowRateMode_Parameters = None) \
            -> ParameterControlServicer_pb2.SetFlowRateMode_Responses:
        """
        Wrapper to call the unobservable command SetFlowRateMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFlowRateMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetFlowRateMode_Parameters(
                    **ParameterControlServicer_default_dict['SetFlowRateMode_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetFlowRateMode(parameter)
    
            logging.debug('SetFlowRateMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetDispenseVolumeMode(self,
                      parameter: ParameterControlServicer_pb2.SetDispenseVolumeMode_Parameters = None) \
            -> ParameterControlServicer_pb2.SetDispenseVolumeMode_Responses:
        """
        Wrapper to call the unobservable command SetDispenseVolumeMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDispenseVolumeMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetDispenseVolumeMode_Parameters(
                    **ParameterControlServicer_default_dict['SetDispenseVolumeMode_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetDispenseVolumeMode(parameter)
    
            logging.debug('SetDispenseVolumeMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetDispenseTimeMode(self,
                      parameter: ParameterControlServicer_pb2.SetDispenseTimeMode_Parameters = None) \
            -> ParameterControlServicer_pb2.SetDispenseTimeMode_Responses:
        """
        Wrapper to call the unobservable command SetDispenseTimeMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDispenseTimeMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetDispenseTimeMode_Parameters(
                    **ParameterControlServicer_default_dict['SetDispenseTimeMode_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetDispenseTimeMode(parameter)
    
            logging.debug('SetDispenseTimeMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetPauseTimeMode(self,
                      parameter: ParameterControlServicer_pb2.SetPauseTimeMode_Parameters = None) \
            -> ParameterControlServicer_pb2.SetPauseTimeMode_Responses:
        """
        Wrapper to call the unobservable command SetPauseTimeMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetPauseTimeMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetPauseTimeMode_Parameters(
                    **ParameterControlServicer_default_dict['SetPauseTimeMode_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetPauseTimeMode(parameter)
    
            logging.debug('SetPauseTimeMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetDispenseTimePauseTimeMode(self,
                      parameter: ParameterControlServicer_pb2.SetDispenseTimePauseTimeMode_Parameters = None) \
            -> ParameterControlServicer_pb2.SetDispenseTimePauseTimeMode_Responses:
        """
        Wrapper to call the unobservable command SetDispenseTimePauseTimeMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDispenseTimePauseTimeMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetDispenseTimePauseTimeMode_Parameters(
                    **ParameterControlServicer_default_dict['SetDispenseTimePauseTimeMode_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetDispenseTimePauseTimeMode(parameter)
    
            logging.debug('SetDispenseTimePauseTimeMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetDispenseVolumePauseTimeMode(self,
                      parameter: ParameterControlServicer_pb2.SetDispenseVolumePauseTimeMode_Parameters = None) \
            -> ParameterControlServicer_pb2.SetDispenseVolumePauseTimeMode_Responses:
        """
        Wrapper to call the unobservable command SetDispenseVolumePauseTimeMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDispenseVolumePauseTimeMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetDispenseVolumePauseTimeMode_Parameters(
                    **ParameterControlServicer_default_dict['SetDispenseVolumePauseTimeMode_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetDispenseVolumePauseTimeMode(parameter)
    
            logging.debug('SetDispenseVolumePauseTimeMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetDispenseVolume(self,
                      parameter: ParameterControlServicer_pb2.GetDispenseVolume_Parameters = None) \
            -> ParameterControlServicer_pb2.GetDispenseVolume_Responses:
        """
        Wrapper to call the unobservable command GetDispenseVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetDispenseVolume:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetDispenseVolume_Parameters(
                    **ParameterControlServicer_default_dict['GetDispenseVolume_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetDispenseVolume(parameter)
    
            logging.debug('GetDispenseVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetDispenseVolume(self,
                      parameter: ParameterControlServicer_pb2.SetDispenseVolume_Parameters = None) \
            -> ParameterControlServicer_pb2.SetDispenseVolume_Responses:
        """
        Wrapper to call the unobservable command SetDispenseVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDispenseVolume:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetDispenseVolume_Parameters(
                    **ParameterControlServicer_default_dict['SetDispenseVolume_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetDispenseVolume(parameter)
    
            logging.debug('SetDispenseVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetDispenseVolumeModeVolume(self,
                      parameter: ParameterControlServicer_pb2.SetDispenseVolumeModeVolume_Parameters = None) \
            -> ParameterControlServicer_pb2.SetDispenseVolumeModeVolume_Responses:
        """
        Wrapper to call the unobservable command SetDispenseVolumeModeVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDispenseVolumeModeVolume:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetDispenseVolumeModeVolume_Parameters(
                    **ParameterControlServicer_default_dict['SetDispenseVolumeModeVolume_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetDispenseVolumeModeVolume(parameter)
    
            logging.debug('SetDispenseVolumeModeVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetFlowRate(self,
                      parameter: ParameterControlServicer_pb2.GetFlowRate_Parameters = None) \
            -> ParameterControlServicer_pb2.GetFlowRate_Responses:
        """
        Wrapper to call the unobservable command GetFlowRate on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFlowRate:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetFlowRate_Parameters(
                    **ParameterControlServicer_default_dict['GetFlowRate_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetFlowRate(parameter)
    
            logging.debug('GetFlowRate response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetFlowRate(self,
                      parameter: ParameterControlServicer_pb2.SetFlowRate_Parameters = None) \
            -> ParameterControlServicer_pb2.SetFlowRate_Responses:
        """
        Wrapper to call the unobservable command SetFlowRate on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFlowRate:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetFlowRate_Parameters(
                    **ParameterControlServicer_default_dict['SetFlowRate_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetFlowRate(parameter)
    
            logging.debug('SetFlowRate response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetRPM(self,
                      parameter: ParameterControlServicer_pb2.GetRPM_Parameters = None) \
            -> ParameterControlServicer_pb2.GetRPM_Responses:
        """
        Wrapper to call the unobservable command GetRPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetRPM:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetRPM_Parameters(
                    **ParameterControlServicer_default_dict['GetRPM_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetRPM(parameter)
    
            logging.debug('GetRPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetRPM(self,
                      parameter: ParameterControlServicer_pb2.SetRPM_Parameters = None) \
            -> ParameterControlServicer_pb2.SetRPM_Responses:
        """
        Wrapper to call the unobservable command SetRPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetRPM:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetRPM_Parameters(
                    **ParameterControlServicer_default_dict['SetRPM_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetRPM(parameter)
    
            logging.debug('SetRPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetPauseTime(self,
                      parameter: ParameterControlServicer_pb2.GetPauseTime_Parameters = None) \
            -> ParameterControlServicer_pb2.GetPauseTime_Responses:
        """
        Wrapper to call the unobservable command GetPauseTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPauseTime:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetPauseTime_Parameters(
                    **ParameterControlServicer_default_dict['GetPauseTime_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetPauseTime(parameter)
    
            logging.debug('GetPauseTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetPauseTime(self,
                      parameter: ParameterControlServicer_pb2.SetPauseTime_Parameters = None) \
            -> ParameterControlServicer_pb2.SetPauseTime_Responses:
        """
        Wrapper to call the unobservable command SetPauseTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetPauseTime:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetPauseTime_Parameters(
                    **ParameterControlServicer_default_dict['SetPauseTime_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetPauseTime(parameter)
    
            logging.debug('SetPauseTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetDispenseCycles(self,
                      parameter: ParameterControlServicer_pb2.GetDispenseCycles_Parameters = None) \
            -> ParameterControlServicer_pb2.GetDispenseCycles_Responses:
        """
        Wrapper to call the unobservable command GetDispenseCycles on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetDispenseCycles:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetDispenseCycles_Parameters(
                    **ParameterControlServicer_default_dict['GetDispenseCycles_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetDispenseCycles(parameter)
    
            logging.debug('GetDispenseCycles response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetDispenseCycles(self,
                      parameter: ParameterControlServicer_pb2.SetDispenseCycles_Parameters = None) \
            -> ParameterControlServicer_pb2.SetDispenseCycles_Responses:
        """
        Wrapper to call the unobservable command SetDispenseCycles on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDispenseCycles:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetDispenseCycles_Parameters(
                    **ParameterControlServicer_default_dict['SetDispenseCycles_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetDispenseCycles(parameter)
    
            logging.debug('SetDispenseCycles response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetDispenseTime(self,
                      parameter: ParameterControlServicer_pb2.GetDispenseTime_Parameters = None) \
            -> ParameterControlServicer_pb2.GetDispenseTime_Responses:
        """
        Wrapper to call the unobservable command GetDispenseTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetDispenseTime:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetDispenseTime_Parameters(
                    **ParameterControlServicer_default_dict['GetDispenseTime_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetDispenseTime(parameter)
    
            logging.debug('GetDispenseTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetDispenseTime(self,
                      parameter: ParameterControlServicer_pb2.SetDispenseTime_Parameters = None) \
            -> ParameterControlServicer_pb2.SetDispenseTime_Responses:
        """
        Wrapper to call the unobservable command SetDispenseTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDispenseTime:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetDispenseTime_Parameters(
                    **ParameterControlServicer_default_dict['SetDispenseTime_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetDispenseTime(parameter)
    
            logging.debug('SetDispenseTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetRollerSteps(self,
                      parameter: ParameterControlServicer_pb2.GetRollerSteps_Parameters = None) \
            -> ParameterControlServicer_pb2.GetRollerSteps_Responses:
        """
        Wrapper to call the unobservable command GetRollerSteps on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetRollerSteps:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetRollerSteps_Parameters(
                    **ParameterControlServicer_default_dict['GetRollerSteps_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetRollerSteps(parameter)
    
            logging.debug('GetRollerSteps response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetRollerSteps(self,
                      parameter: ParameterControlServicer_pb2.SetRollerSteps_Parameters = None) \
            -> ParameterControlServicer_pb2.SetRollerSteps_Responses:
        """
        Wrapper to call the unobservable command SetRollerSteps on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetRollerSteps:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetRollerSteps_Parameters(
                    **ParameterControlServicer_default_dict['SetRollerSteps_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetRollerSteps(parameter)
    
            logging.debug('SetRollerSteps response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetRollerStepVolume(self,
                      parameter: ParameterControlServicer_pb2.GetRollerStepVolume_Parameters = None) \
            -> ParameterControlServicer_pb2.GetRollerStepVolume_Responses:
        """
        Wrapper to call the unobservable command GetRollerStepVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetRollerStepVolume:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetRollerStepVolume_Parameters(
                    **ParameterControlServicer_default_dict['GetRollerStepVolume_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetRollerStepVolume(parameter)
    
            logging.debug('GetRollerStepVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetRollerStepVolume(self,
                      parameter: ParameterControlServicer_pb2.SetRollerStepVolume_Parameters = None) \
            -> ParameterControlServicer_pb2.SetRollerStepVolume_Responses:
        """
        Wrapper to call the unobservable command SetRollerStepVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetRollerStepVolume:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetRollerStepVolume_Parameters(
                    **ParameterControlServicer_default_dict['SetRollerStepVolume_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetRollerStepVolume(parameter)
    
            logging.debug('SetRollerStepVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ResetRollerStepVolume(self,
                      parameter: ParameterControlServicer_pb2.ResetRollerStepVolume_Parameters = None) \
            -> ParameterControlServicer_pb2.ResetRollerStepVolume_Responses:
        """
        Wrapper to call the unobservable command ResetRollerStepVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling ResetRollerStepVolume:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.ResetRollerStepVolume_Parameters(
                    **ParameterControlServicer_default_dict['ResetRollerStepVolume_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.ResetRollerStepVolume(parameter)
    
            logging.debug('ResetRollerStepVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetRollerBackSteps(self,
                      parameter: ParameterControlServicer_pb2.GetRollerBackSteps_Parameters = None) \
            -> ParameterControlServicer_pb2.GetRollerBackSteps_Responses:
        """
        Wrapper to call the unobservable command GetRollerBackSteps on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetRollerBackSteps:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetRollerBackSteps_Parameters(
                    **ParameterControlServicer_default_dict['GetRollerBackSteps_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetRollerBackSteps(parameter)
    
            logging.debug('GetRollerBackSteps response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetRollerBackSteps(self,
                      parameter: ParameterControlServicer_pb2.SetRollerBackSteps_Parameters = None) \
            -> ParameterControlServicer_pb2.SetRollerBackSteps_Responses:
        """
        Wrapper to call the unobservable command SetRollerBackSteps on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetRollerBackSteps:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetRollerBackSteps_Parameters(
                    **ParameterControlServicer_default_dict['SetRollerBackSteps_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetRollerBackSteps(parameter)
    
            logging.debug('SetRollerBackSteps response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SaveApplicationParameters(self,
                      parameter: ParameterControlServicer_pb2.SaveApplicationParameters_Parameters = None) \
            -> ParameterControlServicer_pb2.SaveApplicationParameters_Responses:
        """
        Wrapper to call the unobservable command SaveApplicationParameters on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SaveApplicationParameters:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SaveApplicationParameters_Parameters(
                    **ParameterControlServicer_default_dict['SaveApplicationParameters_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SaveApplicationParameters(parameter)
    
            logging.debug('SaveApplicationParameters response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetTubingDiameter(self,
                      parameter: ParameterControlServicer_pb2.GetTubingDiameter_Parameters = None) \
            -> ParameterControlServicer_pb2.GetTubingDiameter_Responses:
        """
        Wrapper to call the unobservable command GetTubingDiameter on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetTubingDiameter:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetTubingDiameter_Parameters(
                    **ParameterControlServicer_default_dict['GetTubingDiameter_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetTubingDiameter(parameter)
    
            logging.debug('GetTubingDiameter response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetTubingDiameter(self,
                      parameter: ParameterControlServicer_pb2.SetTubingDiameter_Parameters = None) \
            -> ParameterControlServicer_pb2.SetTubingDiameter_Responses:
        """
        Wrapper to call the unobservable command SetTubingDiameter on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetTubingDiameter:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetTubingDiameter_Parameters(
                    **ParameterControlServicer_default_dict['SetTubingDiameter_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetTubingDiameter(parameter)
    
            logging.debug('SetTubingDiameter response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    

    def Subscribe_CurrentStatus(self) \
            -> DeviceServicer_pb2.Subscribe_CurrentStatus_Responses:
        """Wrapper to get property CurrentStatus from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading observable property CurrentStatus:")
        try:
            response = self.DeviceServicer_stub.Subscribe_CurrentStatus(
                DeviceServicer_pb2.Subscribe_CurrentStatus_Parameters()
            )
            logging.debug(
                'Subscribe_CurrentStatus response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    def Get_PortName(self) \
            -> DeviceServicer_pb2.Get_PortName_Responses:
        """Wrapper to get property PortName from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property PortName:")
        try:
            response = self.DeviceServicer_stub.Get_PortName(
                DeviceServicer_pb2.Get_PortName_Parameters()
            )
            logging.debug(
                'Get_PortName response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    def Get_BaudRate(self) \
            -> DeviceServicer_pb2.Get_BaudRate_Responses:
        """Wrapper to get property BaudRate from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property BaudRate:")
        try:
            response = self.DeviceServicer_stub.Get_BaudRate(
                DeviceServicer_pb2.Get_BaudRate_Parameters()
            )
            logging.debug(
                'Get_BaudRate response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    def Get_Parity(self) \
            -> DeviceServicer_pb2.Get_Parity_Responses:
        """Wrapper to get property Parity from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property Parity:")
        try:
            response = self.DeviceServicer_stub.Get_Parity(
                DeviceServicer_pb2.Get_Parity_Parameters()
            )
            logging.debug(
                'Get_Parity response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    def Get_StopBits(self) \
            -> DeviceServicer_pb2.Get_StopBits_Responses:
        """Wrapper to get property StopBits from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property StopBits:")
        try:
            response = self.DeviceServicer_stub.Get_StopBits(
                DeviceServicer_pb2.Get_StopBits_Parameters()
            )
            logging.debug(
                'Get_StopBits response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    def Get_Timeout(self) \
            -> DeviceServicer_pb2.Get_Timeout_Responses:
        """Wrapper to get property Timeout from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property Timeout:")
        try:
            response = self.DeviceServicer_stub.Get_Timeout(
                DeviceServicer_pb2.Get_Timeout_Parameters()
            )
            logging.debug(
                'Get_Timeout response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    

    @staticmethod
    def grpc_error_handling(error_object: grpc.Call) -> None:
        """Handles exceptions of type grpc.RpcError"""
        # pass to the default error handling
        grpc_error =  client_err.grpc_error_handling(error_object=error_object)

        # Access more details using the return value fields
        # grpc_error.message
        # grpc_error.error_type


def parse_command_line():
    """
    Just looking for command line arguments
    """
    parser = argparse.ArgumentParser(description="A SiLA2 client: RegloDCService")
    parser.add_argument('-v', '--version', action='version', version='%(prog)s ' + __version__)

    return parser.parse_args()


if __name__ == '__main__':
    # or use logging.INFO (=20) or logging.ERROR (=30) for less output
    logging.basicConfig(format='%(levelname)-8s| %(module)s.%(funcName)s: %(message)s', level=logging.DEBUG)

    parsed_args = parse_command_line()

    # start the server
    sila_client = RegloDCServiceClient(server_ip='127.0.0.1', server_port=50015)
    sila_client.run()

    # Log connection info
    logging.info(
        (
            'Connected to SiLA Server {display_name} running in version {version}.' '\n'
            'Service description: {service_description}'
        ).format(
            display_name=sila_client.server_display_name,
            version=sila_client.server_version,
            service_description=sila_client.server_description
        )
    )

    # TODO:
    #   Write your further function calls here to run the client as a standalone application.
