#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*RegloDCService*

:details: RegloDCService:
    This is a RegloDC Service
           
:file:    RegloDCService_server.py
:authors: Lukas Bromig

:date: (creation)          2021-03-16T12:40:00.548914
:date: (last modification) 2021-03-16T12:40:00.548914

.. note:: Code generated by sila2codegenerator 0.3.3-dev

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"
import os
import logging
import argparse
import sys

# Import the main SiLA library
from sila2lib.sila_server import SiLA2Server

# Import gRPC libraries of features
from sila2lib_implementations.RegloDC.RegloDCService.CalibrationServicer.gRPC import CalibrationServicer_pb2
from sila2lib_implementations.RegloDC.RegloDCService.CalibrationServicer.gRPC import CalibrationServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.RegloDC.RegloDCService.CalibrationServicer.CalibrationServicer_default_arguments import default_dict as CalibrationServicer_default_dict
from sila2lib_implementations.RegloDC.RegloDCService.DeviceServicer.gRPC import DeviceServicer_pb2
from sila2lib_implementations.RegloDC.RegloDCService.DeviceServicer.gRPC import DeviceServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.RegloDC.RegloDCService.DeviceServicer.DeviceServicer_default_arguments import default_dict as DeviceServicer_default_dict
from sila2lib_implementations.RegloDC.RegloDCService.DriveControlServicer.gRPC import DriveControlServicer_pb2
from sila2lib_implementations.RegloDC.RegloDCService.DriveControlServicer.gRPC import DriveControlServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.RegloDC.RegloDCService.DriveControlServicer.DriveControlServicer_default_arguments import default_dict as DriveControlServicer_default_dict
from sila2lib_implementations.RegloDC.RegloDCService.ParameterControlServicer.gRPC import ParameterControlServicer_pb2
from sila2lib_implementations.RegloDC.RegloDCService.ParameterControlServicer.gRPC import ParameterControlServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.RegloDC.RegloDCService.ParameterControlServicer.ParameterControlServicer_default_arguments import default_dict as ParameterControlServicer_default_dict

# Import the servicer modules for each feature
from sila2lib_implementations.RegloDC.RegloDCService.CalibrationServicer.CalibrationServicer_servicer import CalibrationServicer
from sila2lib_implementations.RegloDC.RegloDCService.DeviceServicer.DeviceServicer_servicer import DeviceServicer
from sila2lib_implementations.RegloDC.RegloDCService.DriveControlServicer.DriveControlServicer_servicer import DriveControlServicer
from sila2lib_implementations.RegloDC.RegloDCService.ParameterControlServicer.ParameterControlServicer_servicer import ParameterControlServicer

# import custom implementation libraries
import serial
import serial.tools.list_ports
import multiprocessing
from contextlib import contextmanager # used for locking
from sila2lib_implementations.RegloDC.RegloDCService.SerialDetector import serial_ports


class Properties:
    ser = None
    port_name = ''
    baud_rate: int = 9600
    parity: str = serial.PARITY_NONE
    stop_bits: str = serial.STOPBITS_ONE
    byte_size: str = serial.EIGHTBITS
    timeout: float = 0.2

    pump_address = 1

    port_name_sim = ''
    baud_rate_sim: int = 9600
    parity_sim: str = serial.PARITY_NONE
    stop_bits_sim: str = serial.STOPBITS_ONE
    byte_size_sim: str = serial.EIGHTBITS
    timeout_sim: float = 0.2

    pump_address_sim = 1

    lock = multiprocessing.Lock()

    status = 'Idle'

    def __init__(self, port_name):
        self.port_name: str = port_name  # .upper()

    def initial_connection(self):
        """
        Establishes a connection with the hardware device on startup, if server is running in real-mode.
        :return:
        """
        try:
            ports = []
            available_ports = serial_ports()
            ports_not_required = []
            for i in range(0, len(available_ports), 1):
                if available_ports[i] in [self.port_name]:
                    ports.append(available_ports[i])
                else:
                    ports_not_required.append(available_ports[i])
            unavailable_ports = list(set(available_ports) - set(ports))
            if unavailable_ports is not []:
                logging.warning(
                    "The following other COM/USB port/s are available: {ports}".format(ports=unavailable_ports))
            if ports == []:
                logging.critical(
                    "No available COM/USB port/s to establish connection to: {ports}".format(ports=ports))
                self.connect()
                raise ConnectionError
            else:
                self.connect()
        except Exception as e:
            logging.exception(e)
            sys.exit(1)

    def connect(self):
        """
        Establish connection with the hardware device using the serial communication port with pySerial.
        """
        try:
            self.ser = serial.Serial(port=self.port_name,
                                     baudrate=self.baud_rate,
                                     parity=self.parity,
                                     stopbits=self.stop_bits,
                                     bytesize=self.byte_size,
                                     timeout=self.timeout)
            logging.info(
                "Connection established on port: {ports}".format(ports=self.port_name))
            return 'Connection successful'
        except (serial.SerialException, serial.SerialTimeoutException, AttributeError, ConnectionError, PermissionError)\
                as exception:
            logging.exception(
                "Connection could not be established on port: {ports}".format(ports=self.port_name))
            return f'Connection unsuccessful: {type(exception).__name__} '

    @contextmanager
    def acquire_timeout_lock(self, timeout: float = 0.2):
        result = self.lock.acquire(timeout=timeout)
        yield result
        if result:
            self.lock.release()


class RegloDCServiceServer(SiLA2Server):
    """
    This is a RegloDC Service
    """

    def __init__(self, cmd_args, server_ip: str = "127.0.0.1", server_port: int = 50015,
                 simulation_mode: bool = True, com_port: str = None):
        """Class initializer"""
        super().__init__(
            name=cmd_args.server_name, description=cmd_args.description,
            server_type=cmd_args.server_type, server_uuid=None,
            version=__version__,
            vendor_url="",
            ip=server_ip, port=server_port,
            key_file=cmd_args.encryption_key, cert_file=cmd_args.encryption_cert,
            simulation_mode=simulation_mode, server_hostname=f'{cmd_args.server_name}.sila',
            server_path=os.path.dirname(os.path.realpath(__file__))
        )
        print(cmd_args.server_name)
        self.logger.info(
            "Starting SiLA2 server with server name: {server_name}".format(
                server_name=cmd_args.server_name
            )
        )
        # Define some server properties
        self.properties = Properties(com_port)
        self.simulation_mode = simulation_mode

        if not simulation_mode:
            self.properties.initial_connection()
        else:
            self.ser = None

        # registering features
        #  Register CalibrationServicer
        self.CalibrationServicer_servicer = CalibrationServicer(properties=self.properties,
                                                                simulation_mode=self.simulation_mode)
        CalibrationServicer_pb2_grpc.add_CalibrationServicerServicer_to_server(
            self.CalibrationServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='CalibrationServicer',
                         servicer=self.CalibrationServicer_servicer,
                         data_path=os.path.join(os.path.dirname(__file__), 'meta'))
        
        #  Register DeviceServicer
        self.DeviceServicer_servicer = DeviceServicer(properties=self.properties,
                                                      simulation_mode=self.simulation_mode)
        DeviceServicer_pb2_grpc.add_DeviceServicerServicer_to_server(
            self.DeviceServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='DeviceServicer',
                         servicer=self.DeviceServicer_servicer,
                         data_path=os.path.join(os.path.dirname(__file__), 'meta'))
        
        #  Register DriveControlServicer
        self.DriveControlServicer_servicer = DriveControlServicer(properties=self.properties,
                                                                  simulation_mode=self.simulation_mode)
        DriveControlServicer_pb2_grpc.add_DriveControlServicerServicer_to_server(
            self.DriveControlServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='DriveControlServicer',
                         servicer=self.DriveControlServicer_servicer,
                         data_path=os.path.join(os.path.dirname(__file__), 'meta'))
        
        #  Register ParameterControlServicer
        self.ParameterControlServicer_servicer = ParameterControlServicer(properties=self.properties,
                                                                          simulation_mode=self.simulation_mode)
        ParameterControlServicer_pb2_grpc.add_ParameterControlServicerServicer_to_server(
            self.ParameterControlServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='ParameterControlServicer',
                         servicer=self.ParameterControlServicer_servicer,
                         data_path=os.path.join(os.path.dirname(__file__), 'meta'))

        self.simulation_mode = simulation_mode

        # starting and running the gRPC/SiLA2 server
        self.run()


def parse_command_line():
    """
    Just looking for commandline arguments
    """
    parser = argparse.ArgumentParser(description="A SiLA2 service: RegloDCService")

    # Simple arguments for the server identification
    parser.add_argument('-s', '--server-name', action='store',
                        default="RegloDCService", help='start SiLA server with [server-name]')
    parser.add_argument('-t', '--server-type', action='store',
                        default="Unknown Type", help='start SiLA server with [server-type]')
    parser.add_argument('-d', '--description', action='store',
                        default="This is a RegloDC Service", help='SiLA server description')

    # Encryption
    parser.add_argument('-X', '--encryption', action='store', default=None,
                        help='The name of the private key and certificate file (without extension).')
    parser.add_argument('--encryption-key', action='store', default=None,
                        help='The name of the encryption key (*with* extension). Can be used if key and certificate '
                             'vary or non-standard file extensions are used.')
    parser.add_argument('--encryption-cert', action='store', default=None,
                        help='The name of the encryption certificate (*with* extension). Can be used if key and '
                             'certificate vary or non-standard file extensions are used.')

    parser.add_argument('-v', '--version', action='version', version='%(prog)s ' + __version__)

    parsed_args = parser.parse_args()

    # validate/update some settings
    #   encryption
    if parsed_args.encryption is not None:
        # only overwrite the separate keys if not given manually
        if parsed_args.encryption_key is None:
            parsed_args.encryption_key = parsed_args.encryption + '.key'
        if parsed_args.encryption_cert is None:
            parsed_args.encryption_cert = parsed_args.encryption + '.cert'

    return parsed_args
    
        
if __name__ == '__main__':
    args = parse_command_line()

    # generate SiLA2Server
    sila_server = RegloDCServiceServer(cmd_args=args, server_ip='10.152.248.1', server_port=50016, simulation_mode=True,
                                       com_port='Com1')
