"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Calibration Servicer*

:details: CalibrationServicer:
    Set and retrieve the control parameter values for calibration of the Reglo ICC pump.
    By Valeryia Sidarava, Institute of Biochemical Engineering, Technical University of Munich, 31.07.2019,
    Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 15.04.2020.
           
:file:    CalibrationServicer_servicer.py
:authors: Valeryia Sidarava & Lukas Bromig

:date: (creation)          2020-04-16T10:19:57.961808
:date: (last modification) 2020-04-16T10:19:57.961808

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import CalibrationServicer_pb2 as CalibrationServicer_pb2
from .gRPC import CalibrationServicer_pb2_grpc as CalibrationServicer_pb2_grpc

# import simulation and real implementation
from .CalibrationServicer_simulation import CalibrationServicerSimulation
from .CalibrationServicer_real import CalibrationServicerReal


class CalibrationServicer(CalibrationServicer_pb2_grpc.CalibrationServicerServicer):
    """
    This is a RegloICC Service
    """
    implementation: Union[CalibrationServicerSimulation, CalibrationServicerReal]
    simulation_mode: bool

    def __init__(self, ser, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.ser = ser
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(CalibrationServicerSimulation())
        else:
            self._inject_implementation(CalibrationServicerReal(ser=self.ser))

    def _inject_implementation(self,
                               implementation: Union[CalibrationServicerSimulation,
                                                     CalibrationServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the RegloICCServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(CalibrationServicerSimulation())

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(CalibrationServicerReal(ser=self.ser))

    def StartCalibration(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.StartCalibration_Responses:
        """
        Executes the unobservable command "Start Calibration on a Channel"
            Starts calibration on a channel.
    
        :param request: gRPC request containing the parameters passed:
            request.Calibrate (Calibrate):
            Starts calibration on a channel.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.StartCalibrationStatus (Start Calibration Status): Calibration succeeded to start.
        """
    
        logging.debug(
            "StartCalibration called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.StartCalibration(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def CancelCalibration(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.CancelCalibration_Responses:
        """
        Executes the unobservable command "Cancel Calibration on a Channel"
            Cancels calibration on a channel.
    
        :param request: gRPC request containing the parameters passed:
            request.Calibrate (Calibrate):
            Cancels calibration on a channel.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CancelCalibrationStatus (Cancel Calibration Status): Calibration succeeded to cancel.
        """
    
        logging.debug(
            "CancelCalibration called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.CancelCalibration(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetTargetVolume(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetTargetVolume_Responses:
        """
        Executes the unobservable command "Set Target Volume Value"
            Set target volume to pump for calibrating in mL.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.TargetVolume (Target Volume):
            Set target volume to pump for calibrating in mL.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.TargetVolumeSet (Target Volume Set): Target Volume succeeded to Set.
        """
    
        logging.debug(
            "SetTargetVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetTargetVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetActualVolume(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetActualVolume_Responses:
        """
        Executes the unobservable command "Set Actual Volume Value"
            Set the actual volume measured during calibration in mL.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.ActualVolume (Actual Volume):
            The actual volume measured during calibration in mL.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActualVolumeSet (Actual Volume Set): Actual Volume succeeded to Set.
        """
    
        logging.debug(
            "SetActualVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetActualVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetTargetVolume(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetTargetVolume_Responses:
        """
        Executes the unobservable command "Get Target Volume"
            Get target volume to pump for calibrating in mL.
    
        :param request: gRPC request containing the parameters passed:
            request.TargetVolume (Target Volume):
            Get target volume of pump for calibrating in mL.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTargetVolume (Current Target Volume): Current target volume to pump for calibrating in mL.
        """
    
        logging.debug(
            "GetTargetVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetTargetVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDirectionCalibration(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetDirectionCalibration_Responses:
        """
        Executes the unobservable command "Set Direction Flow for Calibration"
            Set direction flow for calibration J or K using DIRECTION format.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.Direction (Direction):
            Set direction flow for calibration J or K using DIRECTION format.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetDirectionCalibrationSet (Set Direction for Calibration Set): Direction flow for Calibration succeeded to Set.
        """
    
        logging.debug(
            "SetDirectionCalibration called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDirectionCalibration(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetDirectionCalibration(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetDirectionCalibration_Responses:
        """
        Executes the unobservable command "Get Direction Flow for Calibration"
            Get direction flow for calibration (J or K).
    
        :param request: gRPC request containing the parameters passed:
            request.Direction (Direction):
            Get direction flow for calibration (J or K).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDirectionCalibration (Current Direction for Calibration): Current Direction flow for Calibration.
        """
    
        logging.debug(
            "GetDirectionCalibration called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetDirectionCalibration(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetCalibrationTime(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetCalibrationTime_Responses:
        """
        Executes the unobservable command "Set Calibration Time"
            Set the current calibration time using Time Type 2 format.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.Time (Time):
            Set the current calibration time using Time Type 2 format.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetCalibrationTimeSet (Set Calibration Time Set): Calibration Time succeeded to Set.
        """
    
        logging.debug(
            "SetCalibrationTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetCalibrationTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetCalibrationTime(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetCalibrationTime_Responses:
        """
        Executes the unobservable command "Get Calibration Time"
            Get the current calibration time.
    
        :param request: gRPC request containing the parameters passed:
            request.Time (Time):
            Get the current calibration time.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCalibrationTime (Current Calibration Time): Current Calibration Time.
        """
    
        logging.debug(
            "GetCalibrationTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetCalibrationTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetRunTimeCalibration(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetRunTimeCalibration_Responses:
        """
        Executes the unobservable command "Get Run Time since last Calibration"
            Get channel run time since last calibration.
    
        :param request: gRPC request containing the parameters passed:
            request.Time (Time):
            Get channel run time since last calibration.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentRunTimeCalibration (Current Run Time since Calibration): Channel run time since last calibration..
        """
    
        logging.debug(
            "GetRunTimeCalibration called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetRunTimeCalibration(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
