"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Calibration Servicer*

:details: CalibrationServicer:
    Set and retrieve the control parameter values for calibration of the Reglo ICC pump.
    By Valeryia Sidarava, Institute of Biochemical Engineering, Technical University of Munich, 31.07.2019,
    Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 15.04.2020.

:file:    CalibrationServicer_simulation.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:57.972397
:date: (last modification) 2020-04-16T10:19:57.972397

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import CalibrationServicer_pb2 as CalibrationServicer_pb2
# from .gRPC import CalibrationServicer_pb2_grpc as CalibrationServicer_pb2_grpc

# import default arguments
from .CalibrationServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class CalibrationServicerSimulation:
    """
    Implementation of the *Calibration Servicer* in *Simulation* mode
        This is a RegloICC Service
    """

    def __init__(self):
        """Class initialiser"""

        logging.debug('Started server in mode: {mode}'.format(mode='Simulation'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def StartCalibration(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.StartCalibration_Responses:
        """
        Executes the unobservable command "Start Calibration on a Channel"
            Starts calibration on a channel.
    
        :param request: gRPC request containing the parameters passed:
            request.Calibrate (Calibrate):
            Starts calibration on a channel.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.StartCalibrationStatus (Start Calibration Status): Calibration succeeded to start.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command StartCalibration here and write the resulting response
        #   in return_value
        return_value = CalibrationServicer_pb2.StartCalibration_Responses(
            StartCalibrationStatus=silaFW_pb2.String(value='StartCalibration_test'))

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.StartCalibration_Responses(
                **default_dict['StartCalibration_Responses']
            )
    
        return return_value
    
    
    def CancelCalibration(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.CancelCalibration_Responses:
        """
        Executes the unobservable command "Cancel Calibration on a Channel"
            Cancels calibration on a channel.
    
        :param request: gRPC request containing the parameters passed:
            request.Calibrate (Calibrate):
            Cancels calibration on a channel.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CancelCalibrationStatus (Cancel Calibration Status): Calibration succeeded to cancel.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command CancelCalibration here and write the resulting response
        #   in return_value
        return_value = CalibrationServicer_pb2.CancelCalibration_Responses(
            CancelCalibrationStatus=silaFW_pb2.String(value='CancelCalibration_test'))

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.CancelCalibration_Responses(
                **default_dict['CancelCalibration_Responses']
            )
    
        return return_value
    
    
    def SetTargetVolume(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetTargetVolume_Responses:
        """
        Executes the unobservable command "Set Target Volume Value"
            Set target volume to pump for calibrating in mL.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.TargetVolume (Target Volume):
            Set target volume to pump for calibrating in mL.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.TargetVolumeSet (Target Volume Set): Target Volume succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetTargetVolume here and write the resulting response
        #   in return_value
        return_value = CalibrationServicer_pb2.SetTargetVolume_Responses(TargetVolumeSet=silaFW_pb2.String(
            value='SetTargetVolume_test'))

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.SetTargetVolume_Responses(
                **default_dict['SetTargetVolume_Responses']
            )
    
        return return_value
    
    
    def SetActualVolume(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetActualVolume_Responses:
        """
        Executes the unobservable command "Set Actual Volume Value"
            Set the actual volume measured during calibration in mL.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.ActualVolume (Actual Volume):
            The actual volume measured during calibration in mL.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActualVolumeSet (Actual Volume Set): Actual Volume succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetActualVolume here and write the resulting response
        #   in return_value
        return_value = CalibrationServicer_pb2.SetActualVolume_Responses(ActualVolumeSet=silaFW_pb2.String(
            value='SetActualVolume_test'))

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.SetActualVolume_Responses(
                **default_dict['SetActualVolume_Responses']
            )
    
        return return_value
    
    
    def GetTargetVolume(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetTargetVolume_Responses:
        """
        Executes the unobservable command "Get Target Volume"
            Get target volume to pump for calibrating in mL.
    
        :param request: gRPC request containing the parameters passed:
            request.TargetVolume (Target Volume):
            Get target volume of pump for calibrating in mL.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTargetVolume (Current Target Volume): Current target volume to pump for calibrating in mL.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetTargetVolume here and write the resulting response
        #   in return_value
        return_value = CalibrationServicer_pb2.GetTargetVolume_Responses(
            CurrentTargetVolume=silaFW_pb2.Real(value=99.99))

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.GetTargetVolume_Responses(
                **default_dict['GetTargetVolume_Responses']
            )
    
        return return_value
    
    
    def SetDirectionCalibration(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetDirectionCalibration_Responses:
        """
        Executes the unobservable command "Set Direction Flow for Calibration"
            Set direction flow for calibration J or K using DIRECTION format.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.Direction (Direction):
            Set direction flow for calibration J or K using DIRECTION format.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetDirectionCalibrationSet (Set Direction for Calibration Set): Direction flow for Calibration succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetDirectionCalibration here and write the resulting response
        #   in return_value
        return_value = CalibrationServicer_pb2.SetDirectionCalibration_Responses(
            SetDirectionCalibrationSet=silaFW_pb2.String(value='SetDirectionCalibration_test'))

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.SetDirectionCalibration_Responses(
                **default_dict['SetDirectionCalibration_Responses']
            )
    
        return return_value
    
    
    def GetDirectionCalibration(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetDirectionCalibration_Responses:
        """
        Executes the unobservable command "Get Direction Flow for Calibration"
            Get direction flow for calibration (J or K).
    
        :param request: gRPC request containing the parameters passed:
            request.Direction (Direction):
            Get direction flow for calibration (J or K).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDirectionCalibration (Current Direction for Calibration): Current Direction flow for Calibration.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetDirectionCalibration here and write the resulting response
        #   in return_value
        return_value = CalibrationServicer_pb2.GetDirectionCalibration_Responses(
            CurrentDirectionCalibration=silaFW_pb2.String(value='GetDirectionCalibration_test'))

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.GetDirectionCalibration_Responses(
                **default_dict['GetDirectionCalibration_Responses']
            )
    
        return return_value
    
    
    def SetCalibrationTime(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.SetCalibrationTime_Responses:
        """
        Executes the unobservable command "Set Calibration Time"
            Set the current calibration time using Time Type 2 format.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.Time (Time):
            Set the current calibration time using Time Type 2 format.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetCalibrationTimeSet (Set Calibration Time Set): Calibration Time succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetCalibrationTime here and write the resulting response
        #   in return_value
        return_value = CalibrationServicer_pb2.SetCalibrationTime_Responses(
            SetCalibrationTimeSet=silaFW_pb2.String(value='SetCalibrationTime_test'))

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.SetCalibrationTime_Responses(
                **default_dict['SetCalibrationTime_Responses']
            )
    
        return return_value
    
    
    def GetCalibrationTime(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetCalibrationTime_Responses:
        """
        Executes the unobservable command "Get Calibration Time"
            Get the current calibration time.
    
        :param request: gRPC request containing the parameters passed:
            request.Time (Time):
            Get the current calibration time.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCalibrationTime (Current Calibration Time): Current Calibration Time.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetCalibrationTime here and write the resulting response
        #   in return_value
        return_value = CalibrationServicer_pb2.GetCalibrationTime_Responses(
            CurrentCalibrationTime=silaFW_pb2.Integer(value=99999))

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.GetCalibrationTime_Responses(
                **default_dict['GetCalibrationTime_Responses']
            )
    
        return return_value
    
    
    def GetRunTimeCalibration(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.GetRunTimeCalibration_Responses:
        """
        Executes the unobservable command "Get Run Time since last Calibration"
            Get channel run time since last calibration.
    
        :param request: gRPC request containing the parameters passed:
            request.Time (Time):
            Get channel run time since last calibration.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentRunTimeCalibration (Current Run Time since Calibration): Channel run time since last calibration..
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetRunTimeCalibration here and write the resulting response
        #   in return_value
        return_value = CalibrationServicer_pb2.GetRunTimeCalibration_Responses(
            CurrentRunTimeCalibration=silaFW_pb2.Integer(value=9999))

        # fallback to default
        if return_value is None:
            return_value = CalibrationServicer_pb2.GetRunTimeCalibration_Responses(
                **default_dict['GetRunTimeCalibration_Responses']
            )
    
        return return_value
