"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Configuration Servicer*

:details: ConfigurationServicer:
    Set and retrieve the control parameter values for the configuration of the Reglo ICC pump.
    By Valeryia Sidarava, Institute of Biochemical Engineering, Technical University of Munich, 31.07.2019,
    Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 15.04.2020.
           
:file:    ConfigurationServicer_servicer.py
:authors: Valeryia Sidarava & Lukas Bromig

:date: (creation)          2020-04-16T10:19:58.087112
:date: (last modification) 2020-04-16T10:19:58.087112

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import ConfigurationServicer_pb2 as ConfigurationServicer_pb2
from .gRPC import ConfigurationServicer_pb2_grpc as ConfigurationServicer_pb2_grpc

# import simulation and real implementation
from .ConfigurationServicer_simulation import ConfigurationServicerSimulation
from .ConfigurationServicer_real import ConfigurationServicerReal


class ConfigurationServicer(ConfigurationServicer_pb2_grpc.ConfigurationServicerServicer):
    """
    This is a RegloICC Service
    """
    implementation: Union[ConfigurationServicerSimulation, ConfigurationServicerReal]
    simulation_mode: bool

    def __init__(self, ser, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.ser = ser
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(ConfigurationServicerSimulation())
        else:
            self._inject_implementation(ConfigurationServicerReal(ser=self.ser))

    def _inject_implementation(self,
                               implementation: Union[ConfigurationServicerSimulation,
                                                     ConfigurationServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the RegloICCServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(ConfigurationServicerSimulation())

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(ConfigurationServicerReal(ser=self.ser))

    def SetTubingDiameter(self, request, context: grpc.ServicerContext) \
            -> ConfigurationServicer_pb2.SetTubingDiameter_Responses:
        """
        Executes the unobservable command "Set Tubing Inside Diameter Value"
            Set the inside diameter of the tubing in mm.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.TubingDiameter (Tubing Diameter):
            The inside diameter of the tubing in mm. (must be one of following list:
            [0.13,0.19,0.25,0.38,0.44,0.51,0.57,0.64,0.76,0.89,0.95,1.02,1.09,1.14,1.22,1.3,1.42,1.52,1.65,1.75,1.85,2.06,2.29,2.54,2.79,3.17])
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.TubingDiameterSet (Tubing Diameter Set): Tubing Diameter succeeded to Set.
        """
    
        logging.debug(
            "SetTubingDiameter called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetTubingDiameter(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def ResetToDefault(self, request, context: grpc.ServicerContext) \
            -> ConfigurationServicer_pb2.ResetToDefault_Responses:
        """
        Executes the unobservable command "Reset To Default"
            Resets all user configurable data to default values.
    
        :param request: gRPC request containing the parameters passed:
            request.Reset (Reset):
            Resets all user configurable data to default values.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ResetStatus (Reset Status): Reset of pump succeeded.
        """
    
        logging.debug(
            "ResetToDefault called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.ResetToDefault(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetTubingDiameter(self, request, context: grpc.ServicerContext) \
            -> ConfigurationServicer_pb2.GetTubingDiameter_Responses:
        """
        Executes the unobservable command "Get Tubing Diameter"
            Get the inside diameter of the tubing in mm.
    
        :param request: gRPC request containing the parameters passed:
            request.CurrentTubingDiameter (Current Tubing Diameter):
            The inside diameter of the tubing in mm.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTubingDiameter (Current Tubing Diameter): Current the inside diameter of the tubing in mm.
        """
    
        logging.debug(
            "GetTubingDiameter called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetTubingDiameter(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetBacksteps(self, request, context: grpc.ServicerContext) \
            -> ConfigurationServicer_pb2.SetBacksteps_Responses:
        """
        Executes the unobservable command "Set Backsteps setting"
            Set the current backsteps setting using Discrete Type 2.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.BackstepsSetting (Backsteps Setting):
            Set the current backsteps setting using Discrete Type 2.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.BackstepsSettingSet (Backsteps Setting Set): Backsteps Setting succeeded to Set.
        """
    
        logging.debug(
            "SetBacksteps called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetBacksteps(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetBacksteps(self, request, context: grpc.ServicerContext) \
            -> ConfigurationServicer_pb2.GetBacksteps_Responses:
        """
        Executes the unobservable command "Get Backsteps setting"
            Get the current backsteps setting.
    
        :param request: gRPC request containing the parameters passed:
            request.BackstepsSetting (Backsteps Setting):
            Get the current backsteps setting.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentBackstepsSetting (Current Backsteps Setting): Current Backsteps Setting.
        """
    
        logging.debug(
            "GetBacksteps called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetBacksteps(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
