"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Device Servicer*

:details: DeviceServicer:
    General device software and hardware information can be retrieved and changed within this function.
    By Valeryia Sidarava, Institute of Biochemical Engineering, Technical University of Munich, 31.07.2019 and
    Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 15.04.2020
           
:file:    DeviceServicer_servicer.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:58.142932
:date: (last modification) 2020-04-16T10:19:58.142932

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import DeviceServicer_pb2 as DeviceServicer_pb2
from .gRPC import DeviceServicer_pb2_grpc as DeviceServicer_pb2_grpc

# import simulation and real implementation
from .DeviceServicer_simulation import DeviceServicerSimulation
from .DeviceServicer_real import DeviceServicerReal


class DeviceServicer(DeviceServicer_pb2_grpc.DeviceServicerServicer):
    """
    This is a RegloICC Service
    """
    implementation: Union[DeviceServicerSimulation, DeviceServicerReal]
    simulation_mode: bool

    def __init__(self, ser, simulation_mode: bool = False):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.ser = ser
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(DeviceServicerSimulation())
        else:
            self._inject_implementation(DeviceServicerReal(ser = self.ser))

    def _inject_implementation(self,
                               implementation: Union[DeviceServicerSimulation,
                                                     DeviceServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the RegloICCServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(DeviceServicerSimulation())

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(DeviceServicerReal(ser = self.ser))

    def GetLog(self, request, context: grpc.ServicerContext) \
            -> silaFW_pb2.CommandConfirmation:
        """
        Executes the observable command "Get Log"
            Get the current status of the device from the state machine of the SiLA server.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A command confirmation object with the following information:
            commandId: A command id with which this observable command can be referenced in future calls
            lifetimeOfExecution: The (maximum) lifetime of this command call.
        """
    
        logging.debug(
            "GetLog called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.GetLog(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetLog_Info(self, request, context: grpc.ServicerContext) \
            -> silaFW_pb2.ExecutionInfo:
        """
        Returns execution information regarding the command call :meth:`~.GetLog`.
    
        :param request: A request object with the following properties
            CommandExecutionUUID: The UUID of the command executed.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: An ExecutionInfo response stream for the command with the following fields:
            commandStatus: Status of the command (enumeration)
            progressInfo: Information on the progress of the command (0 to 1)
            estimatedRemainingTime: Estimate of the remaining time required to run the command
            updatedLifetimeOfExecution: An update on the execution lifetime
        """
    
        logging.debug(
            "GetLog_Info called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.GetLog_Info(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetLog_Result(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetLog_Responses:
        """
        Returns the final result of the command call :meth:`~.GetLog`.
    
        :param request: A request object with the following properties
            CommandExecutionUUID: The UUID of the command executed.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentLogLevel (Current Log Level): The current log level of the latest logs , retrieved from the SiLA server log file.
            request.CurrentLogTimestamp (Current Log Timestamp): The current log timestamp of the latest logs , retrieved from the SiLA server log file.
            request.CurrentLogMessage (Current Log Level): The current log level of the latest logs , retrieved from the SiLA server log file.
        """
    
        logging.debug(
            "GetLog_Result called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.GetLog_Result(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    
    def SetPumpAddress(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetPumpAddress_Responses:
        """
        Executes the unobservable command "Set Pump Address"
            Set the address of the pump (1-8).
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpAddressSet (Pump Address Set): Pump Address succeeded to Set.
        """
    
        logging.debug(
            "SetPumpAddress called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetPumpAddress(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetLanguage(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetLanguage_Responses:
        """
        Executes the unobservable command "Set Language"
            Set the language of the pump.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the pump, on which the command will be executed
            request.Language (Language):
            The language of the pump. 0=English / 1=French / 2=Spanish / 3=German.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.LanguageSet (Language Set): Language of the pump succeeded to Set.
        """
    
        logging.debug(
            "SetLanguage called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetLanguage(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetLanguage(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetLanguage_Responses:
        """
        Executes the unobservable command "Get Language"
            Get The language of the pump. 0=English / 1=French / 2=Spanish / 3=German.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentLanguage (Current Language): Current language of the pump. 0=English / 1=French / 2=Spanish / 3=German.
        """
    
        logging.debug(
            "GetLanguage called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetLanguage(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetPumpStatus(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetPumpStatus_Responses:
        """
        Executes the unobservable command "Get Pump Status"
            Get pump status. +=running, -=stopped/standby.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPumpStatus (Current Pump Status): Current pump status. +=running, -=stopped/standby.
        """
    
        logging.debug(
            "GetPumpStatus called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPumpStatus(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetVersionType(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetVersionType_Responses:
        """
        Executes the unobservable command "Get Version Type"
            Get pump information. Response is string of model description (variable length), software version (3 digits) and pump head model type code (3 digits).
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersionType (Current Version Type): Current pump information. Response is string of model description (variable length), software version (3 digits) and pump head model type code (3 digits).
        """
    
        logging.debug(
            "GetVersionType called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetVersionType(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def CurrentVersionSoftware(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.CurrentVersionSoftware_Responses:
        """
        Executes the unobservable command "Current Version Software"
            Get pump software version. Response is string.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersionSoftware (Current Version Software): Current pump software version. Response is string.
        """
    
        logging.debug(
            "CurrentVersionSoftware called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.CurrentVersionSoftware(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSerialNumber(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetSerialNumber_Responses:
        """
        Executes the unobservable command "Get Serial Number"
            Get pump serial number.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SerialNumber (Serial Number): Pump serial number query.
        """
    
        logging.debug(
            "GetSerialNumber called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSerialNumber(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetChannelAddressing(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetChannelAddressing_Responses:
        """
        Executes the unobservable command "Set Channel Addressing"
            Set whether (1) or not (0) channel addressing is enabled.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the pump, on which the command will be executed
            request.ChannelAddressing (Channel Addressing):
            Set whether (1) or not (0) channel addressing is enabled.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ChannelAddressingSet (Channel Addressing Set): Channel Addressing of the pump succeeded to Set.
        """
    
        logging.debug(
            "SetChannelAddressing called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetChannelAddressing(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetChannelAddressing(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetChannelAddressing_Responses:
        """
        Executes the unobservable command "Get Channel Addressing"
            Get information whether (1) or not (0) channel addressing is enabled.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ChannelAddressing (Channel Addressing): Information whether or not channel addressing is enabled String of form XXXXXXX; 0=disabled,1=enabled.
        """
    
        logging.debug(
            "GetChannelAddressing called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetChannelAddressing(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetEventMessages(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetEventMessages_Responses:
        """
        Executes the unobservable command "Set Event Messages"
            Set whether (1) or not (0) event messages are enabled.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the pump, on which the command will be executed
            request.EventMessages (Event Messages):
            Set whether (1) or not (0) event messages are enabled.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.EventMessagesSet (Event Messages Set): Event Messages of the pump succeeded to Set.
        """
    
        logging.debug(
            "SetEventMessages called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetEventMessages(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetEventMessages(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetEventMessages_Responses:
        """
        Executes the unobservable command "Get Event Messages"
            Get information whether (1) or not (0) event messages are enabled.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.EventMessages (Event Messages): information whether or not event messages are enabled; 0=disabled,1=enabled.
        """
    
        logging.debug(
            "GetEventMessages called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetEventMessages(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSerialProtocol(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetSerialProtocol_Responses:
        """
        Executes the unobservable command "Get Serial Protocol"
            Get an integer representing the version of the serial protocol.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SerialProtocol (Serial Protocol): Integer representing the version of the serial protocol.
        """
    
        logging.debug(
            "GetSerialProtocol called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSerialProtocol(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetPumpName(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetPumpName_Responses:
        """
        Executes the unobservable command "Set Pump Name"
            Set pump name for display under remote control string.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the address, on which the command will be executed
            request.PumpName (Pump Name):
            Set pump name for display under remote control string.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpNameSet (Pump Name Set): Pump Name succeeded to Set.
        """
    
        logging.debug(
            "SetPumpName called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetPumpName(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetChannelNumber(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetChannelNumber_Responses:
        """
        Executes the unobservable command "Get ChannelNumber"
            Get number of pump channels.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ChannelNumber (Channel Number): Number of pump channels
        """
    
        logging.debug(
            "GetChannelNumber called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetChannelNumber(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetChannelNumber(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetChannelNumber_Responses:
        """
        Executes the unobservable command "Set Channel Number"
            Set number of pump channels.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the pump, on which the command will be executed
            request.ChannelNumber (Channel Number):
            Set number of pump channels.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ChannelNumberSet (Channel Number Set): Channel Number succeeded to Set.
        """
    
        logging.debug(
            "SetChannelNumber called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetChannelNumber(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetRevolutions(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetRevolutions_Responses:
        """
        Executes the unobservable command "Get Revolutions"
            Get total number of revolutions.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Revolutions (Revolutions): Get total number of revolutions
        """
    
        logging.debug(
            "GetRevolutions called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetRevolutions(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetChannelTotalVolume(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetChannelTotalVolume_Responses:
        """
        Executes the unobservable command "Get Channel Total Volume"
            Get channel total volume pumped since last reset, mL.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ChannelTotalVolume (Channel Total Volume): Channel total volume pumped since last reset, mL
        """
    
        logging.debug(
            "GetChannelTotalVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetChannelTotalVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetTotalTime(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetTotalTime_Responses:
        """
        Executes the unobservable command "Get Total Time"
            Get total time pumped for a channel since last reset, mL.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.TotalTime (Total Time): Get total time pumped for a channel since last reset, mL.
        """
    
        logging.debug(
            "GetTotalTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetTotalTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetHeadModel(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetHeadModel_Responses:
        """
        Executes the unobservable command "Get Head Model"
            Get pump head model type code indicating the ID number of the pump head. The first two digits encode the number of channels on the head, and the second 2 digits represent the number of rollers.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.HeadModel (Head Model): Get pump head model type code indicating the ID number of the pump head. The first two digits encode the number of channels on the head, and the second 2 digits represent the number of rollers.
        """
    
        logging.debug(
            "GetHeadModel called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetHeadModel(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetHeadModel(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetHeadModel_Responses:
        """
        Executes the unobservable command "Set Head Model"
            Set pump head model type code up to 4 digits indicating the ID number of the pump head. The first two digits encode the number of channels on the head, and the second 2 digits represent the number of rollers
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the pump, on which the command will be executed
            request.HeadModel (Head Model):
            Set pump head model type code indicating the ID number of the pump head. The first two digits encode the number of channels on the head, and the second 2 digits represent the number of rollers
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.HeadModelSet (Head Model Set): Head Model succeeded to Set.
        """
    
        logging.debug(
            "SetHeadModel called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetHeadModel(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetUserInterface(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetUserInterface_Responses:
        """
        Executes the unobservable command "Set User Interface"
            Set control from the pump user interface
    
        :param request: gRPC request containing the parameters passed:
            request.UserInterface (User Interface):
            Set control from the pump user interface. Variable - pump address
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.UserInterfaceSet (User Interface Set): User Interface succeeded to Set.
        """
    
        logging.debug(
            "SetUserInterface called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetUserInterface(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDisableInterface(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetDisableInterface_Responses:
        """
        Executes the unobservable command "Set Disable Interface"
            Disable pump user interface
    
        :param request: gRPC request containing the parameters passed:
            request.DisableInterface (Disable Interface):
            Disable pump user interface. Variable - pump address
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.DisableInterfaceSet (Disable Interface Set): Disable Interface succeeded to Set.
        """
    
        logging.debug(
            "SetDisableInterface called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDisableInterface(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDisplayNumbers(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetDisplayNumbers_Responses:
        """
        Executes the unobservable command "Set Display Numbers"
            Write numbers to the pump to display while under external control - string (less than 17 characters)
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the pump, on which the command will be executed
            request.DisplayNumbers (Display Numbers):
            Write numbers to the pump to display while under external control - string (less than 17 characters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.DisplayNumbersSet (Display Numbers Set): Display Numbers succeeded to Set.
        """
    
        logging.debug(
            "SetDisplayNumbers called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDisplayNumbers(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDisplayLetters(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetDisplayLetters_Responses:
        """
        Executes the unobservable command "Set Display Letters"
            Write letters to the pump to display while under external control - string (less than 17 characters)
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the pump, on which the command will be executed
            request.DisplayLetters (Display Letters):
            Write letters to the pump to display while under external control - string (less than 17 characters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.DisplayLettersSet (Display Letters Set): Display Letters succeeded to Set.
        """
    
        logging.debug(
            "SetDisplayLetters called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDisplayLetters(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetTimeSetting(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetTimeSetting_Responses:
        """
        Executes the unobservable command "Get Time Setting"
            Get current setting for pump time in 1/10 seconds.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.TimeSetting (Time Setting): Get current setting for pump time in 1/10 seconds.
        """
    
        logging.debug(
            "GetTimeSetting called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetTimeSetting(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetTimeSetting(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetTimeSetting_Responses:
        """
        Executes the unobservable command "Set Time Setting"
            Set current setting for pump time in 1/10 seconds.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.TimeSetting (Time Setting):
            Set current setting for pump time in 1/10 seconds.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.TimeSettingSet (Time Setting Set): Time Setting succeeded to Set.
        """
    
        logging.debug(
            "SetTimeSetting called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetTimeSetting(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetRunTimeM(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetRunTimeM_Responses:
        """
        Executes the unobservable command "Set Run Time in Minutes"
            Set current run time setting for dispensing in minutes (0-999)
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.RunTimeM (Run Time in Minutes):
            Set current run time setting for dispensing in minutes (0-999)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RunTimeMSet (Run Time in Minutes Set): Run Time succeeded to Set.
        """
    
        logging.debug(
            "SetRunTimeM called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetRunTimeM(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetRunTimeH(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetRunTimeH_Responses:
        """
        Executes the unobservable command "Set Run Time in Hours"
            Set current run time setting for dispensing in hours (0-999)
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.RunTimeM (Run Time in hours):
            Set current run time setting for dispensing in hours (0-999)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RunTimeHSet (Run Time in Hours Set): Run Time succeeded to Set.
        """
    
        logging.debug(
            "SetRunTimeH called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetRunTimeH(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetRollerStepsLow(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetRollerStepsLow_Responses:
        """
        Executes the unobservable command "Get Roller Steps low order"
            Get current setting for volume to pump in low order roller steps. The total number of roller steps
            which are dispensed during an operation is computed as [ u*65536 + U].
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RollerStepsLow (Roller Steps low order): Get current setting for volume to pump in low order roller steps. The total number of roller steps
            which are dispensed during an operation is computed as [ u*65536 + U].
        """
    
        logging.debug(
            "GetRollerStepsLow called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetRollerStepsLow(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetRollerStepsLow(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetRollerStepsLow_Responses:
        """
        Executes the unobservable command "Set Roller Steps low order"
            Set current setting for volume to pump in roller steps (0 - 65536).
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.RollerStepsLow (Roller Steps low order):
            Set current setting for volume to pump in roller steps (0 - 65536).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RollerStepsLowSet (Roller Steps low order Set): Roller Steps low order succeeded to Set.
        """
    
        logging.debug(
            "SetRollerStepsLow called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetRollerStepsLow(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetRollerStepsHigh(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetRollerStepsHigh_Responses:
        """
        Executes the unobservable command "Get Roller Steps high order "
            Get current setting for volume to pump in high order roller steps. The total number of roller steps
            which are dispensed during an operation is computed as [ u*65536 + U].
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RollerStepsHigh (Roller Steps high order): Get current setting for volume to pump in high order roller steps. The total number of roller steps
            which are dispensed during an operation is computed as [ u*65536 + U].
        """
    
        logging.debug(
            "GetRollerStepsHigh called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetRollerStepsHigh(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetRollerStepsHigh(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetRollerStepsHigh_Responses:
        """
        Executes the unobservable command "Set Roller Steps High order"
            Set current setting for volume to pump in roller steps (greater than 65536).
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.RollerSteps (Roller Steps in hours):
            Set current setting for volume to pump in roller steps (0 - 65536).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RollerStepsHighSet (Roller Steps High order Set): Roller Steps High order succeeded to Set.
        """
    
        logging.debug(
            "SetRollerStepsHigh called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetRollerStepsHigh(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetRSV(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetRSV_Responses:
        """
        Executes the unobservable command "Get Roller Step Volume "
            Get the pump's current setting for roller step volume (RSV) based on the current calibration,
            tubing diameter and roller count in nL. If no calibration has been performed, the default volume is returned
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RSV (Roller Steps high order): Get the pump's current setting for roller step volume (RSV) based on the current calibration,
            tubing diameter and roller count in nL. If no calibration has been performed, the default volume is returned.
        """
    
        logging.debug(
            "GetRSV called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetRSV(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetRSV(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetRSV_Responses:
        """
        Executes the unobservable command "Set Roller Step Volume"
            Set the calibrated roller step volume (RSV) in nL to use for this pump/channel.
            The value is used as calibration value and is overwritten by subsequent calibrations and reset by changing tubing diameter.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
            request.RSV (Roller Step Volume):
            Set the calibrated roller step volume (RSV) in nL to use for this pump/channel.
            The value is used as calibration value and is overwritten by subsequent calibrations and reset by changing tubing diameter.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RSVSet (Roller Step Volume Set): Roller Step Volume succeeded to Set.
        """
    
        logging.debug(
            "SetRSV called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetRSV(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetRSVReset(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetRSVReset_Responses:
        """
        Executes the unobservable command "Set Roller Step Volume Reset"
            Reset the pump to discard calibration data, use default roller step volume
    
        :param request: gRPC request containing the parameters passed:
            request.RSVReset (Roller Step Volume Reset):
            Reset the pump to discard calibration data, use default roller step volume
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RSVResetSet (Roller Step Volume Reset Set): Roller Step Volume Reset succeeded.
        """
    
        logging.debug(
            "SetRSVReset called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetRSVReset(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def ResetRSVTable(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.ResetRSVTable_Responses:
        """
        Executes the unobservable command "Reset Roller Step Volume Table"
            Reset roller step value table to default
    
        :param request: gRPC request containing the parameters passed:
            request.RSVTableReset (Roller Step Volume Table Reset):
            Reset roller step value table to default
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ResetRSVTableSet (Reset Roller Step Volume Table Set): Reset Roller Step Volume Table succeeded.
        """
    
        logging.debug(
            "ResetRSVTable called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.ResetRSVTable(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetNonFactoryRSV(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetNonFactoryRSV_Responses:
        """
        Executes the unobservable command "Set Non-Factory Roller Step Volume"
            Change factory roller step volume for a particular roller count and tubing size using roller count (6,8,12);
            index of the tubing diameter; RSV
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.RollerCount (Roller Count):
            Gets roller count of the channel
            request.TubingID (Tubing ID):
            Index of tubing diameter, see manual p.16 of 36)
            request.NonFactoryRSV (Non-Factory Roller Step Volume): Roller step volume in nL
            Change factory roller step volume for a particular roller count and tubing size using roller count (6,8,12);
            index of the tubing diameter; RSVReset roller step value table to default
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetNonFactoryRSVSet (Set Non-Factory Roller Step Volume Set): Non-Factory Roller Step Volume succeeded.
        """
    
        logging.debug(
            "SetNonFactoryRSV called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetNonFactoryRSV(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetPauseTime(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetPauseTime_Responses:
        """
        Executes the unobservable command "Get Pause Time "
            Get current setting for pause time in 1/10 seconds
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PauseTime (Pause Time): Get current setting for pause time in 1/10 seconds
        """
    
        logging.debug(
            "GetPauseTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPauseTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetPauseTime(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetPauseTime_Responses:
        """
        Executes the unobservable command "Set Pause Time"
            Set current setting for pause time in 1/10 seconds
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.PauseTime (Pause Time):
            Set current setting for pause time in 1/10 seconds
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PauseTimeSet (Pause Time Set): Pause Time succeeded to Set.
        """
    
        logging.debug(
            "SetPauseTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetPauseTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetPauseTimeM(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetPauseTimeM_Responses:
        """
        Executes the unobservable command "Set Pause Time in Minutes"
            Set current setting for pause time in minutes (0-999)
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.PauseTimeM (Pause Time in Minutes):
            Set current setting for pause time in minutes (0-999)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PauseTimeMSet (Pause Time in Minutes Set): Pause Time succeeded to Set.
        """
    
        logging.debug(
            "SetPauseTimeM called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetPauseTimeM(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetPauseTimeH(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetPauseTimeH_Responses:
        """
        Executes the unobservable command "Set Pause Time in Hours"
            Set current setting for pause time in hours (0-999)
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.PauseTimeM (Pause Time in hours):
            Set current setting for pause time in hours (0-999)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PauseTimeHSet (Pause Time in Hours Set): Pause Time succeeded to Set.
        """
    
        logging.debug(
            "SetPauseTimeH called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetPauseTimeH(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetTotalVolume(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetTotalVolume_Responses:
        """
        Executes the unobservable command "Get Total Volume"
            Get total volume dispensed since the last reset in uL, mL or L.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTotalVolume (Current Total Volume): Get total volume dispensed since the last reset in uL, mL or L.
        """
    
        logging.debug(
            "GetTotalVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetTotalVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SaveSettings(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SaveSettings_Responses:
        """
        Executes the unobservable command "Save Settings"
            Saves the current pump settings values to memory.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpAddress (Pump Address): Pump Address
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Save (Save): Saves the current pump settings values to memory.
        """
    
        logging.debug(
            "SaveSettings called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SaveSettings(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SaveSetRoller(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SaveSetRoller_Responses:
        """
        Executes the unobservable command "Save Set Roller Step"
            Saves set roller step settings.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpAddress (Pump Address): Pump Address
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Save (Save): Saves set roller step settings.
        """
    
        logging.debug(
            "SaveSetRoller called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SaveSetRoller(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetFootSwitchStatus(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetFootSwitchStatus_Responses:
        """
        Executes the unobservable command "Get Foot Switch Status"
            Get the current status of the foot switch:   - open  /  + grounded.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpAddress (Pump Address): Pump Address
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FootSwitchStatus (Foot Switch Status): Get the current status of the foot switch:   - open  /  + grounded..
        """
    
        logging.debug(
            "GetFootSwitchStatus called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetFootSwitchStatus(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetRollersNumber(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetRollersNumber_Responses:
        """
        Executes the unobservable command "Set Rollers Number"
            Set number of rollers for channel
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.RollersNumber (Rollers Number):
            Set number of rollers for channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RollersNumber (Rollers Number Set): Rollers Number succeeded to Set.
        """
    
        logging.debug(
            "SetRollersNumber called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetRollersNumber(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetRollersNumber(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetRollersNumber_Responses:
        """
        Executes the unobservable command "Get Rollers Number"
            Get number of rollers for channel
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RollersNumber (Rollers Number): Get number of rollers for channel.
        """
    
        logging.debug(
            "GetRollersNumber called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetRollersNumber(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetPumpSerialNumber(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetPumpSerialNumber_Responses:
        """
        Executes the unobservable command "Set Pump Serial Number"
            Set pump serial number string.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the pump, on which the command will be executed
            request.PumpSerialNumber (Pump Serial Number):
            Set pump serial number string.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpSerialNumberSet (Pump Serial Number Set): Pump Serial Number succeeded to Set.
        """
    
        logging.debug(
            "SetPumpSerialNumber called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetPumpSerialNumber(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    def Subscribe_CurrentStatus(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.Subscribe_CurrentStatus_Responses:
        """
        Requests the observable property Current Status
            Get the current status of the device from the internal state machine of the SiLA server.
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response stream with the following fields:
            request.CurrentStatus (Current Status): Get the current status of the device from the internal state machine of the SiLA server.
        """
    
        logging.debug(
            "Property CurrentStatus requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.Subscribe_CurrentStatus(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
