"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Device Servicer*

:details: DeviceServicer:
    General device software and hardware information can be retrieved and changed within this function.
    By Valeryia Sidarava, Institute of Biochemical Engineering, Technical University of Munich, 31.07.2019 and
    Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 15.04.2020

:file:    DeviceServicer_simulation.py
:authors: Valeryia Sidarava & Lukas Bromig

:date: (creation)          2020-04-16T10:19:58.186851
:date: (last modification) 2020-04-16T10:19:58.186851

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import DeviceServicer_pb2 as DeviceServicer_pb2
# from .gRPC import DeviceServicer_pb2_grpc as DeviceServicer_pb2_grpc

# import default arguments
from .DeviceServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class DeviceServicerSimulation:
    """
    Implementation of the *Device Servicer* in *Simulation* mode
        This is a RegloICC Service
    """

    def __init__(self):
        """Class initialiser"""
        self.status = "Test-status. Not implemented yet!"
        logging.debug('Started server in mode: {mode}'.format(mode='Simulation'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def GetLog(self, request, context: grpc.ServicerContext) \
            -> silaFW_pb2.CommandConfirmation:
        """
        Executes the observable command "Get Log"
            Get the current status of the device from the state machine of the SiLA server.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A command confirmation object with the following information:
            commandId: A command id with which this observable command can be referenced in future calls
            lifetimeOfExecution: The (maximum) lifetime of this command call.
        """
    
        # initialise default values
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        lifetime_of_execution: silaFW_pb2.Duration = None
    
        # TODO:
        #   Execute the actual command
        #   Optional: Generate a lifetime_of_execution
    
        # respond with UUID and lifetime of execution
        command_uuid = silaFW_pb2.CommandExecutionUUID(value=str(uuid.uuid4()))
        if lifetime_of_execution is not None:
            return silaFW_pb2.CommandConfirmation(
                commandExecutionUUID=command_uuid,
                lifetimeOfExecution=lifetime_of_execution
            )
        else:
            return silaFW_pb2.CommandConfirmation(
                commandExecutionUUID=command_uuid
            )
    
    def GetLog_Info(self, request, context: grpc.ServicerContext) \
            -> silaFW_pb2.ExecutionInfo:
        """
        Returns execution information regarding the command call :meth:`~.GetLog`.
    
        :param request: A request object with the following properties
            commandId: The UUID of the command executed.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: An ExecutionInfo response stream for the command with the following fields:
            commandStatus: Status of the command (enumeration)
            progressInfo: Information on the progress of the command (0 to 1)
            estimatedRemainingTime: Estimate of the remaining time required to run the command
            updatedLifetimeOfExecution: An update on the execution lifetime
        """
        # Get the UUID of the command
        command_uuid = request.value
    
        # Get the current state
        execution_info = self._get_command_state(command_uuid=command_uuid)
    
        # construct the initial return dictionary in case while is not executed
        return_values = {'commandStatus': execution_info.commandStatus}
        if execution_info.HasField('progressInfo'):
            return_values['progressInfo'] = execution_info.progressInfo
        if execution_info.HasField('estimatedRemainingTime'):
            return_values['estimatedRemainingTime'] = execution_info.estimatedRemainingTime
        if execution_info.HasField('updatedLifetimeOfExecution'):
            return_values['updatedLifetimeOfExecution'] = execution_info.updatedLifetimeOfExecution
    
        # we loop only as long as the command is running
        while execution_info.commandStatus == silaFW_pb2.ExecutionInfo.CommandStatus.waiting \
                or execution_info.commandStatus == silaFW_pb2.ExecutionInfo.CommandStatus.running:
            # TODO:
            #   Evaluate the command status --> command_status. Options:
            #       command_stats = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
            #       command_stats = silaFW_pb2.ExecutionInfo.CommandStatus.running
            #       command_stats = silaFW_pb2.ExecutionInfo.CommandStatus.finishedSuccessfully
            #       command_stats = silaFW_pb2.ExecutionInfo.CommandStatus.finishedWithError
            #   Optional:
            #       * Determine the progress (progressInfo)
            #       * Determine the estimated remaining time
            #       * Update the Lifetime of execution
    
            # Update all values
            execution_info = self._get_command_state(command_uuid=command_uuid)
    
            # construct the return dictionary
            return_values = {'commandStatus': execution_info.commandStatus}
            if execution_info.HasField('progressInfo'):
                return_values['progressInfo'] = execution_info.progressInfo
            if execution_info.HasField('estimatedRemainingTime'):
                return_values['estimatedRemainingTime'] = execution_info.estimatedRemainingTime
            if execution_info.HasField('updatedLifetimeOfExecution'):
                return_values['updatedLifetimeOfExecution'] = execution_info.updatedLifetimeOfExecution
    
            yield silaFW_pb2.ExecutionInfo(**return_values)
    
            # we add a small delay to give the client a chance to keep up.
            time.sleep(0.5)
        else:
            # one last time yield the status
            yield silaFW_pb2.ExecutionInfo(**return_values)
    
    def GetLog_Result(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetLog_Responses:
        """
        Returns the final result of the command call :meth:`~.GetLog`.
    
        :param request: A request object with the following properties
            CommandExecutionUUID: The UUID of the command executed.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentLogLevel (Current Log Level): The current log level of the latest logs , retrieved from the SiLA server log file.
            request.CurrentLogTimestamp (Current Log Timestamp): The current log timestamp of the latest logs , retrieved from the SiLA server log file.
            request.CurrentLogMessage (Current Log Level): The current log level of the latest logs , retrieved from the SiLA server log file.
        """
    
        # initialise the return value
        return_value: DeviceServicer_pb2.GetLog_Responses = None
    
        # Get the UUID of the command
        command_uuid = request.value
    
        # TODO:
        #   Add implementation of Simulation for command GetLog here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetLog_Responses(
            CurrentLogLevel=silaFW_pb2.String(value='CurrentVersionSoftware_test'),
            CurrentLogTimestamp=silaFW_pb2.Timestamp(
            second=0, minute=0, hour=0, day=0, month=0, year=0,
            timezone=silaFW_pb2.Timezone(hours=00, minutes=00)))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetLog_Responses(
                **default_dict['GetLog_Responses']
            )
    
        return return_value
    
    
    def SetPumpAddress(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetPumpAddress_Responses:
        """
        Executes the unobservable command "Set Pump Address"
            Set the address of the pump (1-8).
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpAddressSet (Pump Address Set): Pump Address succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetPumpAddress here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetPumpAddress_Responses(PumpAddressSet=silaFW_pb2.String(
            value='SetPumpAddress_test'))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetPumpAddress_Responses(
                **default_dict['SetPumpAddress_Responses']
            )
    
        return return_value
    
    
    def SetLanguage(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetLanguage_Responses:
        """
        Executes the unobservable command "Set Language"
            Set the language of the pump.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the pump, on which the command will be executed
            request.Language (Language):
            The language of the pump. 0=English / 1=French / 2=Spanish / 3=German.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.LanguageSet (Language Set): Language of the pump succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetLanguage here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetLanguage_Responses(LanguageSet=silaFW_pb2.String(
            value='SetLanguage_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetLanguage_Responses(
                **default_dict['SetLanguage_Responses']
            )
    
        return return_value
    
    
    def GetLanguage(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetLanguage_Responses:
        """
        Executes the unobservable command "Get Language"
            Get The language of the pump. 0=English / 1=French / 2=Spanish / 3=German.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentLanguage (Current Language): Current language of the pump. 0=English / 1=French / 2=Spanish / 3=German.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetLanguage here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetLanguage_Responses(CurrentLanguage=silaFW_pb2.Integer(
            value=999))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetLanguage_Responses(
                **default_dict['GetLanguage_Responses']
            )
    
        return return_value
    
    
    def GetPumpStatus(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetPumpStatus_Responses:
        """
        Executes the unobservable command "Get Pump Status"
            Get pump status. +=running, -=stopped/standby.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPumpStatus (Current Pump Status): Current pump status. +=running, -=stopped/standby.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetPumpStatus here and write the resulting response
        #   in return_value
        
        return_value = DeviceServicer_pb2.GetPumpStatus_Responses(CurrentPumpStatus=silaFW_pb2.String(
            value='GetPumpStatus_test'))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetPumpStatus_Responses(
                **default_dict['GetPumpStatus_Responses']
            )
    
        return return_value
    
    
    def GetVersionType(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetVersionType_Responses:
        """
        Executes the unobservable command "Get Version Type"
            Get pump information. Response is string of model description (variable length), software version (3 digits) and pump head model type code (3 digits).
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersionType (Current Version Type): Current pump information. Response is string of model description (variable length), software version (3 digits) and pump head model type code (3 digits).
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetVersionType here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetVersionType_Responses(CurrentVersionType=silaFW_pb2.String(
            value='GetVersionType_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetVersionType_Responses(
                **default_dict['GetVersionType_Responses']
            )
    
        return return_value
    
    
    def CurrentVersionSoftware(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.CurrentVersionSoftware_Responses:
        """
        Executes the unobservable command "Current Version Software"
            Get pump software version. Response is string.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersionSoftware (Current Version Software): Current pump software version. Response is string.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command CurrentVersionSoftware here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.CurrentVersionSoftware_Responses(
            CurrentVersionSoftware=silaFW_pb2.String(value='CurrentVersionSoftware_test'))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.CurrentVersionSoftware_Responses(
                **default_dict['CurrentVersionSoftware_Responses']
            )
    
        return return_value
    
    
    def GetSerialNumber(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetSerialNumber_Responses:
        """
        Executes the unobservable command "Get Serial Number"
            Get pump serial number.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SerialNumber (Serial Number): Pump serial number query.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetSerialNumber here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetSerialNumber_Responses(SerialNumber=silaFW_pb2.String(
            value='GetSerialNumber_test'))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetSerialNumber_Responses(
                **default_dict['GetSerialNumber_Responses']
            )
    
        return return_value
    
    
    def SetChannelAddressing(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetChannelAddressing_Responses:
        """
        Executes the unobservable command "Set Channel Addressing"
            Set whether (1) or not (0) channel addressing is enabled.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the pump, on which the command will be executed
            request.ChannelAddressing (Channel Addressing):
            Set whether (1) or not (0) channel addressing is enabled.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ChannelAddressingSet (Channel Addressing Set): Channel Addressing of the pump succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetChannelAddressing here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetChannelAddressing_Responses(
            ChannelAddressingSet=silaFW_pb2.String(value='SetChannelAddressing_test'))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetChannelAddressing_Responses(
                **default_dict['SetChannelAddressing_Responses']
            )
    
        return return_value
    
    
    def GetChannelAddressing(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetChannelAddressing_Responses:
        """
        Executes the unobservable command "Get Channel Addressing"
            Get information whether (1) or not (0) channel addressing is enabled.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ChannelAddressing (Channel Addressing): Information whether or not channel addressing is enabled String of form XXXXXXX; 0=disabled,1=enabled.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetChannelAddressing here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetChannelAddressing_Responses(
            ChannelAddressing=silaFW_pb2.Boolean(value=True))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetChannelAddressing_Responses(
                **default_dict['GetChannelAddressing_Responses']
            )
    
        return return_value
    
    
    def SetEventMessages(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetEventMessages_Responses:
        """
        Executes the unobservable command "Set Event Messages"
            Set whether (1) or not (0) event messages are enabled.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the pump, on which the command will be executed
            request.EventMessages (Event Messages):
            Set whether (1) or not (0) event messages are enabled.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.EventMessagesSet (Event Messages Set): Event Messages of the pump succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetEventMessages here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetEventMessages_Responses(EventMessagesSet=silaFW_pb2.String(
            value='SetEventMessages_test'))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetEventMessages_Responses(
                **default_dict['SetEventMessages_Responses']
            )
    
        return return_value
    
    
    def GetEventMessages(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetEventMessages_Responses:
        """
        Executes the unobservable command "Get Event Messages"
            Get information whether (1) or not (0) event messages are enabled.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.EventMessages (Event Messages): information whether or not event messages are enabled; 0=disabled,1=enabled.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetEventMessages here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetEventMessages_Responses(EventMessages=silaFW_pb2.Boolean(value=True))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetEventMessages_Responses(
                **default_dict['GetEventMessages_Responses']
            )
    
        return return_value
    
    
    def GetSerialProtocol(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetSerialProtocol_Responses:
        """
        Executes the unobservable command "Get Serial Protocol"
            Get an integer representing the version of the serial protocol.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SerialProtocol (Serial Protocol): Integer representing the version of the serial protocol.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetSerialProtocol here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetSerialProtocol_Responses(SerialProtocol=silaFW_pb2.Integer(
            value=9999))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetSerialProtocol_Responses(
                **default_dict['GetSerialProtocol_Responses']
            )
    
        return return_value
    
    
    def SetPumpName(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetPumpName_Responses:
        """
        Executes the unobservable command "Set Pump Name"
            Set pump name for display under remote control string.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the address, on which the command will be executed
            request.PumpName (Pump Name):
            Set pump name for display under remote control string.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpNameSet (Pump Name Set): Pump Name succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetPumpName here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetPumpName_Responses(PumpNameSet=silaFW_pb2.String(value='SetPumpName_test'))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetPumpName_Responses(
                **default_dict['SetPumpName_Responses']
            )
    
        return return_value
    
    
    def GetChannelNumber(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetChannelNumber_Responses:
        """
        Executes the unobservable command "Get ChannelNumber"
            Get number of pump channels.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ChannelNumber (Channel Number): Number of pump channels
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetChannelNumber here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetChannelNumber_Responses(ChannelNumber=silaFW_pb2.Integer(value=9))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetChannelNumber_Responses(
                **default_dict['GetChannelNumber_Responses']
            )
    
        return return_value
    
    
    def SetChannelNumber(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetChannelNumber_Responses:
        """
        Executes the unobservable command "Set Channel Number"
            Set number of pump channels.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the pump, on which the command will be executed
            request.ChannelNumber (Channel Number):
            Set number of pump channels.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ChannelNumberSet (Channel Number Set): Channel Number succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetChannelNumber here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetChannelNumber_Responses(ChannelNumberSet=silaFW_pb2.String(
            value='SetChannelNumber_test'))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetChannelNumber_Responses(
                **default_dict['SetChannelNumber_Responses']
            )
    
        return return_value
    
    
    def GetRevolutions(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetRevolutions_Responses:
        """
        Executes the unobservable command "Get Revolutions"
            Get total number of revolutions.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Revolutions (Revolutions): Get total number of revolutions
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetRevolutions here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetRevolutions_Responses(Revolutions=silaFW_pb2.Integer(
            value=999))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetRevolutions_Responses(
                **default_dict['GetRevolutions_Responses']
            )
    
        return return_value
    
    
    def GetChannelTotalVolume(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetChannelTotalVolume_Responses:
        """
        Executes the unobservable command "Get Channel Total Volume"
            Get channel total volume pumped since last reset, mL.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ChannelTotalVolume (Channel Total Volume): Channel total volume pumped since last reset, mL
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetChannelTotalVolume here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetChannelTotalVolume_Responses(
            ChannelTotalVolume=silaFW_pb2.Real(value=999.99))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetChannelTotalVolume_Responses(
                **default_dict['GetChannelTotalVolume_Responses']
            )
    
        return return_value
    
    
    def GetTotalTime(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetTotalTime_Responses:
        """
        Executes the unobservable command "Get Total Time"
            Get total time pumped for a channel since last reset, mL.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.TotalTime (Total Time): Get total time pumped for a channel since last reset, mL.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetTotalTime here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetTotalTime_Responses(TotalTime=silaFW_pb2.Integer(
            value=999))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetTotalTime_Responses(
                **default_dict['GetTotalTime_Responses']
            )
    
        return return_value
    
    
    def GetHeadModel(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetHeadModel_Responses:
        """
        Executes the unobservable command "Get Head Model"
            Get pump head model type code indicating the ID number of the pump head. The first two digits encode the number of channels on the head, and the second 2 digits represent the number of rollers.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Set the address of the pump (1-8).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.HeadModel (Head Model): Get pump head model type code indicating the ID number of the pump head. The first two digits encode the number of channels on the head, and the second 2 digits represent the number of rollers.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetHeadModel here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetHeadModel_Responses(HeadModel=silaFW_pb2.String(
            value='GetHeadModel_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetHeadModel_Responses(
                **default_dict['GetHeadModel_Responses']
            )
    
        return return_value
    
    
    def SetHeadModel(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetHeadModel_Responses:
        """
        Executes the unobservable command "Set Head Model"
            Set pump head model type code up to 4 digits indicating the ID number of the pump head. The first two digits encode the number of channels on the head, and the second 2 digits represent the number of rollers
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the pump, on which the command will be executed
            request.HeadModel (Head Model):
            Set pump head model type code indicating the ID number of the pump head. The first two digits encode the number of channels on the head, and the second 2 digits represent the number of rollers
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.HeadModelSet (Head Model Set): Head Model succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetHeadModel here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetHeadModel_Responses(HeadModelSet=silaFW_pb2.String(
            value='SetHeadModel_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetHeadModel_Responses(
                **default_dict['SetHeadModel_Responses']
            )
    
        return return_value
    
    
    def SetUserInterface(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetUserInterface_Responses:
        """
        Executes the unobservable command "Set User Interface"
            Set control from the pump user interface
    
        :param request: gRPC request containing the parameters passed:
            request.UserInterface (User Interface):
            Set control from the pump user interface. Variable - pump address
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.UserInterfaceSet (User Interface Set): User Interface succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetUserInterface here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetUserInterface_Responses(UserInterfaceSet=silaFW_pb2.String(
            value='SetUserInterface_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetUserInterface_Responses(
                **default_dict['SetUserInterface_Responses']
            )
    
        return return_value
    
    
    def SetDisableInterface(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetDisableInterface_Responses:
        """
        Executes the unobservable command "Set Disable Interface"
            Disable pump user interface
    
        :param request: gRPC request containing the parameters passed:
            request.DisableInterface (Disable Interface):
            Disable pump user interface. Variable - pump address
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.DisableInterfaceSet (Disable Interface Set): Disable Interface succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetDisableInterface here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetDisableInterface_Responses(DisableInterfaceSet=silaFW_pb2.String(
            value='SetDisableInterface_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetDisableInterface_Responses(
                **default_dict['SetDisableInterface_Responses']
            )
    
        return return_value
    
    
    def SetDisplayNumbers(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetDisplayNumbers_Responses:
        """
        Executes the unobservable command "Set Display Numbers"
            Write numbers to the pump to display while under external control - string (less than 17 characters)
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the pump, on which the command will be executed
            request.DisplayNumbers (Display Numbers):
            Write numbers to the pump to display while under external control - string (less than 17 characters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.DisplayNumbersSet (Display Numbers Set): Display Numbers succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetDisplayNumbers here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetDisplayNumbers_Responses(DisplayNumbersSet=silaFW_pb2.String(
            value='SetDisplayNumbers_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetDisplayNumbers_Responses(
                **default_dict['SetDisplayNumbers_Responses']
            )
    
        return return_value
    
    
    def SetDisplayLetters(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetDisplayLetters_Responses:
        """
        Executes the unobservable command "Set Display Letters"
            Write letters to the pump to display while under external control - string (less than 17 characters)
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the pump, on which the command will be executed
            request.DisplayLetters (Display Letters):
            Write letters to the pump to display while under external control - string (less than 17 characters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.DisplayLettersSet (Display Letters Set): Display Letters succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetDisplayLetters here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetDisplayLetters_Responses(DisplayLettersSet=silaFW_pb2.String(
            value='SetDisplayLetters_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetDisplayLetters_Responses(
                **default_dict['SetDisplayLetters_Responses']
            )
    
        return return_value
    
    
    def GetTimeSetting(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetTimeSetting_Responses:
        """
        Executes the unobservable command "Get Time Setting"
            Get current setting for pump time in 1/10 seconds.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.TimeSetting (Time Setting): Get current setting for pump time in 1/10 seconds.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetTimeSetting here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetTimeSetting_Responses(TimeSetting=silaFW_pb2.Real(value=99.99))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetTimeSetting_Responses(
                **default_dict['GetTimeSetting_Responses']
            )
    
        return return_value
    
    
    def SetTimeSetting(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetTimeSetting_Responses:
        """
        Executes the unobservable command "Set Time Setting"
            Set current setting for pump time in 1/10 seconds.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.TimeSetting (Time Setting):
            Set current setting for pump time in 1/10 seconds.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.TimeSettingSet (Time Setting Set): Time Setting succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetTimeSetting here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetTimeSetting_Responses(TimeSettingSet=silaFW_pb2.String(
            value='SetTimeSetting_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetTimeSetting_Responses(
                **default_dict['SetTimeSetting_Responses']
            )
    
        return return_value
    
    
    def SetRunTimeM(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetRunTimeM_Responses:
        """
        Executes the unobservable command "Set Run Time in Minutes"
            Set current run time setting for dispensing in minutes (0-999)
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.RunTimeM (Run Time in Minutes):
            Set current run time setting for dispensing in minutes (0-999)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RunTimeMSet (Run Time in Minutes Set): Run Time succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetRunTimeM here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetRunTimeM_Responses(RunTimeMSet=silaFW_pb2.String(
            value='SetRunTimeM_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetRunTimeM_Responses(
                **default_dict['SetRunTimeM_Responses']
            )
    
        return return_value
    
    
    def SetRunTimeH(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetRunTimeH_Responses:
        """
        Executes the unobservable command "Set Run Time in Hours"
            Set current run time setting for dispensing in hours (0-999)
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.RunTimeM (Run Time in hours):
            Set current run time setting for dispensing in hours (0-999)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RunTimeHSet (Run Time in Hours Set): Run Time succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetRunTimeH here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetRunTimeH_Responses(RunTimeHSet=silaFW_pb2.String(
            value='SetRunTimeH_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetRunTimeH_Responses(
                **default_dict['SetRunTimeH_Responses']
            )
    
        return return_value
    
    
    def GetRollerStepsLow(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetRollerStepsLow_Responses:
        """
        Executes the unobservable command "Get Roller Steps low order"
            Get current setting for volume to pump in low order roller steps. The total number of roller steps
            which are dispensed during an operation is computed as [ u*65536 + U].
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RollerStepsLow (Roller Steps low order): Get current setting for volume to pump in low order roller steps. The total number of roller steps
            which are dispensed during an operation is computed as [ u*65536 + U].
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetRollerStepsLow here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetRollerStepsLow_Responses(RollerStepsLow=silaFW_pb2.Integer(value=999))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetRollerStepsLow_Responses(
                **default_dict['GetRollerStepsLow_Responses']
            )
    
        return return_value
    
    
    def SetRollerStepsLow(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetRollerStepsLow_Responses:
        """
        Executes the unobservable command "Set Roller Steps low order"
            Set current setting for volume to pump in roller steps (0 - 65536).
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.RollerStepsLow (Roller Steps low order):
            Set current setting for volume to pump in roller steps (0 - 65536).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RollerStepsLowSet (Roller Steps low order Set): Roller Steps low order succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetRollerStepsLow here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetRollerStepsLow_Responses(RollerStepsLowSet=silaFW_pb2.String(
            value='SetRollerStepsLow'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetRollerStepsLow_Responses(
                **default_dict['SetRollerStepsLow_Responses']
            )
    
        return return_value
    
    
    def GetRollerStepsHigh(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetRollerStepsHigh_Responses:
        """
        Executes the unobservable command "Get Roller Steps high order "
            Get current setting for volume to pump in high order roller steps. The total number of roller steps
            which are dispensed during an operation is computed as [ u*65536 + U].
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RollerStepsHigh (Roller Steps high order): Get current setting for volume to pump in high order roller steps. The total number of roller steps
            which are dispensed during an operation is computed as [ u*65536 + U].
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetRollerStepsHigh here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetRollerStepsHigh_Responses(RollerStepsLowSet=silaFW_pb2.Integer(value=999))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetRollerStepsHigh_Responses(
                **default_dict['GetRollerStepsHigh_Responses']
            )
    
        return return_value
    
    
    def SetRollerStepsHigh(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetRollerStepsHigh_Responses:
        """
        Executes the unobservable command "Set Roller Steps High order"
            Set current setting for volume to pump in roller steps (greater than 65536).
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.RollerSteps (Roller Steps in hours):
            Set current setting for volume to pump in roller steps (0 - 65536).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RollerStepsHighSet (Roller Steps High order Set): Roller Steps High order succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetRollerStepsHigh here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetRollerStepsHigh_Responses(RollerStepsHighSet=silaFW_pb2.String(
            value='SetRollerStepsHigh_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetRollerStepsHigh_Responses(
                **default_dict['SetRollerStepsHigh_Responses']
            )
    
        return return_value
    
    
    def GetRSV(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetRSV_Responses:
        """
        Executes the unobservable command "Get Roller Step Volume "
            Get the pump's current setting for roller step volume (RSV) based on the current calibration,
            tubing diameter and roller count in nL. If no calibration has been performed, the default volume is returned
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RSV (Roller Steps high order): Get the pump's current setting for roller step volume (RSV) based on the current calibration,
            tubing diameter and roller count in nL. If no calibration has been performed, the default volume is returned.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetRSV here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetRSV_Responses(RSV=silaFW_pb2.Real(value=999.999))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetRSV_Responses(
                **default_dict['GetRSV_Responses']
            )
    
        return return_value
    
    
    def SetRSV(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetRSV_Responses:
        """
        Executes the unobservable command "Set Roller Step Volume"
            Set the calibrated roller step volume (RSV) in nL to use for this pump/channel.
            The value is used as calibration value and is overwritten by subsequent calibrations and reset by changing tubing diameter.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
            request.RSV (Roller Step Volume):
            Set the calibrated roller step volume (RSV) in nL to use for this pump/channel.
            The value is used as calibration value and is overwritten by subsequent calibrations and reset by changing tubing diameter.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RSVSet (Roller Step Volume Set): Roller Step Volume succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetRSV here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetRSV_Responses(RSVSet=silaFW_pb2.String(value='SetRSV'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetRSV_Responses(
                **default_dict['SetRSV_Responses']
            )
    
        return return_value
    
    
    def SetRSVReset(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetRSVReset_Responses:
        """
        Executes the unobservable command "Set Roller Step Volume Reset"
            Reset the pump to discard calibration data, use default roller step volume
    
        :param request: gRPC request containing the parameters passed:
            request.RSVReset (Roller Step Volume Reset):
            Reset the pump to discard calibration data, use default roller step volume
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RSVResetSet (Roller Step Volume Reset Set): Roller Step Volume Reset succeeded.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetRSVReset here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetRSVReset_Responses(RSVResetSet=silaFW_pb2.String(
            value='SetRSVReset_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetRSVReset_Responses(
                **default_dict['SetRSVReset_Responses']
            )
    
        return return_value
    
    
    def ResetRSVTable(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.ResetRSVTable_Responses:
        """
        Executes the unobservable command "Reset Roller Step Volume Table"
            Reset roller step value table to default
    
        :param request: gRPC request containing the parameters passed:
            request.RSVTableReset (Roller Step Volume Table Reset):
            Reset roller step value table to default
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ResetRSVTableSet (Reset Roller Step Volume Table Set): Reset Roller Step Volume Table succeeded.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command ResetRSVTable here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.ResetRSVTable_Responses(ResetRSVTableSet=silaFW_pb2.String(
            value='ResetRSVTable_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.ResetRSVTable_Responses(
                **default_dict['ResetRSVTable_Responses']
            )
    
        return return_value
    
    
    def SetNonFactoryRSV(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetNonFactoryRSV_Responses:
        """
        Executes the unobservable command "Set Non-Factory Roller Step Volume"
            Change factory roller step volume for a particular roller count and tubing size using roller count (6,8,12);
            index of the tubing diameter; RSV
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.RollerCount (Roller Count):
            Gets roller count of the channel
            request.TubingID (Tubing ID):
            Index of tubing diameter, see manual p.16 of 36)
            request.NonFactoryRSV (Non-Factory Roller Step Volume): Roller step volume in nL
            Change factory roller step volume for a particular roller count and tubing size using roller count (6,8,12);
            index of the tubing diameter; RSVReset roller step value table to default
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetNonFactoryRSVSet (Set Non-Factory Roller Step Volume Set): Non-Factory Roller Step Volume succeeded.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetNonFactoryRSV here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetNonFactoryRSV_Responses(SetNonFactoryRSVSet=silaFW_pb2.String(
            value='SetNonFactoryRSV'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetNonFactoryRSV_Responses(
                **default_dict['SetNonFactoryRSV_Responses']
            )
    
        return return_value
    
    
    def GetPauseTime(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetPauseTime_Responses:
        """
        Executes the unobservable command "Get Pause Time "
            Get current setting for pause time in 1/10 seconds
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PauseTime (Pause Time): Get current setting for pause time in 1/10 seconds
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetPauseTime here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetPauseTime_Responses(PauseTime=silaFW_pb2.Real(value=99.99))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetPauseTime_Responses(
                **default_dict['GetPauseTime_Responses']
            )
    
        return return_value
    
    
    def SetPauseTime(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetPauseTime_Responses:
        """
        Executes the unobservable command "Set Pause Time"
            Set current setting for pause time in 1/10 seconds
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.PauseTime (Pause Time):
            Set current setting for pause time in 1/10 seconds
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PauseTimeSet (Pause Time Set): Pause Time succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetPauseTime here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetPauseTime_Responses(PauseTimeSet=silaFW_pb2.String(
            value='SetPauseTime_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetPauseTime_Responses(
                **default_dict['SetPauseTime_Responses']
            )
    
        return return_value
    
    
    def SetPauseTimeM(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetPauseTimeM_Responses:
        """
        Executes the unobservable command "Set Pause Time in Minutes"
            Set current setting for pause time in minutes (0-999)
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.PauseTimeM (Pause Time in Minutes):
            Set current setting for pause time in minutes (0-999)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PauseTimeMSet (Pause Time in Minutes Set): Pause Time succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetPauseTimeM here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetPauseTimeM_Responses(PauseTimeMSet=silaFW_pb2.String(
            value='SetPauseTimeM_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetPauseTimeM_Responses(
                **default_dict['SetPauseTimeM_Responses']
            )
    
        return return_value
    
    
    def SetPauseTimeH(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetPauseTimeH_Responses:
        """
        Executes the unobservable command "Set Pause Time in Hours"
            Set current setting for pause time in hours (0-999)
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.PauseTimeM (Pause Time in hours):
            Set current setting for pause time in hours (0-999)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PauseTimeHSet (Pause Time in Hours Set): Pause Time succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetPauseTimeH here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetPauseTimeH_Responses(PauseTimeHSet=silaFW_pb2.String(
            value='SetPauseTimeH_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetPauseTimeH_Responses(
                **default_dict['SetPauseTimeH_Responses']
            )
    
        return return_value
    
    
    def GetTotalVolume(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetTotalVolume_Responses:
        """
        Executes the unobservable command "Get Total Volume"
            Get total volume dispensed since the last reset in uL, mL or L.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTotalVolume (Current Total Volume): Get total volume dispensed since the last reset in uL, mL or L.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetTotalVolume here and write the resulting response
        #   in return_value
        eturn_value = DeviceServicer_pb2.GetTotalVolume_Responses(CurrentTotalVolume=silaFW_pb2.Real(value=999))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetTotalVolume_Responses(
                **default_dict['GetTotalVolume_Responses']
            )
    
        return return_value
    
    
    def SaveSettings(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SaveSettings_Responses:
        """
        Executes the unobservable command "Save Settings"
            Saves the current pump settings values to memory.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpAddress (Pump Address): Pump Address
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Save (Save): Saves the current pump settings values to memory.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SaveSettings here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SaveSettings_Responses(Save=silaFW_pb2.String(
            value='SaveSettings_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SaveSettings_Responses(
                **default_dict['SaveSettings_Responses']
            )
    
        return return_value
    
    
    def SaveSetRoller(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SaveSetRoller_Responses:
        """
        Executes the unobservable command "Save Set Roller Step"
            Saves set roller step settings.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpAddress (Pump Address): Pump Address
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Save (Save): Saves set roller step settings.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SaveSetRoller here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SaveSetRoller_Responses(Save=silaFW_pb2.String(
            value='SaveSetRoller_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SaveSetRoller_Responses(
                **default_dict['SaveSetRoller_Responses']
            )
    
        return return_value
    
    
    def GetFootSwitchStatus(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetFootSwitchStatus_Responses:
        """
        Executes the unobservable command "Get Foot Switch Status"
            Get the current status of the foot switch:   - open  /  + grounded.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpAddress (Pump Address): Pump Address
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FootSwitchStatus (Foot Switch Status): Get the current status of the foot switch:   - open  /  + grounded..
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetFootSwitchStatus here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetFootSwitchStatus_Responses(FootSwitchStatus=silaFW_pb2.String(
            value='GetFootSwitchStatus_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetFootSwitchStatus_Responses(
                **default_dict['GetFootSwitchStatus_Responses']
            )
    
        return return_value
    
    
    def SetRollersNumber(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetRollersNumber_Responses:
        """
        Executes the unobservable command "Set Rollers Number"
            Set number of rollers for channel
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.RollersNumber (Rollers Number):
            Set number of rollers for channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RollersNumber (Rollers Number Set): Rollers Number succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetRollersNumber here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetRollersNumber_Responses(RollersNumber=silaFW_pb2.String(
            value='SetRollersNumber_test'))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetRollersNumber_Responses(
                **default_dict['SetRollersNumber_Responses']
            )
    
        return return_value
    
    
    def GetRollersNumber(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetRollersNumber_Responses:
        """
        Executes the unobservable command "Get Rollers Number"
            Get number of rollers for channel
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel): Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RollersNumber (Rollers Number): Get number of rollers for channel.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetRollersNumber here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.GetRollersNumber_Responses(RollersNumber=silaFW_pb2.Integer(value=9))
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetRollersNumber_Responses(
                **default_dict['GetRollersNumber_Responses']
            )
    
        return return_value
    
    
    def SetPumpSerialNumber(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetPumpSerialNumber_Responses:
        """
        Executes the unobservable command "Set Pump Serial Number"
            Set pump serial number string.
    
        :param request: gRPC request containing the parameters passed:
            request.Address (Address):
            Gets the pump, on which the command will be executed
            request.PumpSerialNumber (Pump Serial Number):
            Set pump serial number string.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpSerialNumberSet (Pump Serial Number Set): Pump Serial Number succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetPumpSerialNumber here and write the resulting response
        #   in return_value
        return_value = DeviceServicer_pb2.SetPumpSerialNumber_Responses(
            PumpSerialNumberSet=silaFW_pb2.String(value='SetPumpSerialNumber_test'))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetPumpSerialNumber_Responses(
                **default_dict['SetPumpSerialNumber_Responses']
            )
    
        return return_value
    

    def Subscribe_CurrentStatus(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.Subscribe_CurrentStatus_Responses:
        """
        Requests the observable property Current Status
            Get the current status of the device from the internal state machine of the SiLA server.
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.CurrentStatus (Current Status): Get the current status of the device from the internal state machine of the SiLA server.
        """
    
        # initialise the return value
        return_value: DeviceServicer_pb2.Subscribe_CurrentStatus_Responses = None
    
        # we could use a timeout here if we wanted
        while True:
            par_dict = {
                'CurrentStatus': silaFW_pb2.String(value=self.status)
            }
            return_value = DeviceServicer_pb2.Subscribe_CurrentStatus_Responses(**par_dict)
            # TODO:
            #   Add implementation of Simulation for property CurrentStatus here and write the resulting
            #   response in return_value
    
            # create the default value
            if return_value is None:
                return_value = DeviceServicer_pb2.Subscribe_CurrentStatus_Responses(
                    **default_dict['Subscribe_CurrentStatus_Responses']
                )
    
    
            yield return_value
    
