# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
import grpc

from . import DeviceServicer_pb2 as DeviceServicer__pb2
import sila2lib.framework.SiLAFramework_pb2 as SiLAFramework__pb2


class DeviceServicerStub(object):
  """Feature: Device Servicer

  General device software and hardware information can be retrieved and changed within this function.
  By Valeryia Sidarava, Institute of Biochemical Engineering, Technical University of Munich, 31.07.2019 and
  Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 15.04.2020

  """

  def __init__(self, channel):
    """Constructor.

    Args:
      channel: A grpc.Channel.
    """
    self.GetLog = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetLog',
        request_serializer=DeviceServicer__pb2.GetLog_Parameters.SerializeToString,
        response_deserializer=SiLAFramework__pb2.CommandConfirmation.FromString,
        )
    self.GetLog_Info = channel.unary_stream(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetLog_Info',
        request_serializer=SiLAFramework__pb2.CommandExecutionUUID.SerializeToString,
        response_deserializer=SiLAFramework__pb2.ExecutionInfo.FromString,
        )
    self.GetLog_Result = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetLog_Result',
        request_serializer=SiLAFramework__pb2.CommandExecutionUUID.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetLog_Responses.FromString,
        )
    self.SetPumpAddress = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetPumpAddress',
        request_serializer=DeviceServicer__pb2.SetPumpAddress_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetPumpAddress_Responses.FromString,
        )
    self.SetLanguage = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetLanguage',
        request_serializer=DeviceServicer__pb2.SetLanguage_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetLanguage_Responses.FromString,
        )
    self.GetLanguage = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetLanguage',
        request_serializer=DeviceServicer__pb2.GetLanguage_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetLanguage_Responses.FromString,
        )
    self.GetPumpStatus = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetPumpStatus',
        request_serializer=DeviceServicer__pb2.GetPumpStatus_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetPumpStatus_Responses.FromString,
        )
    self.GetVersionType = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetVersionType',
        request_serializer=DeviceServicer__pb2.GetVersionType_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetVersionType_Responses.FromString,
        )
    self.CurrentVersionSoftware = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/CurrentVersionSoftware',
        request_serializer=DeviceServicer__pb2.CurrentVersionSoftware_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.CurrentVersionSoftware_Responses.FromString,
        )
    self.GetSerialNumber = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetSerialNumber',
        request_serializer=DeviceServicer__pb2.GetSerialNumber_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetSerialNumber_Responses.FromString,
        )
    self.SetChannelAddressing = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetChannelAddressing',
        request_serializer=DeviceServicer__pb2.SetChannelAddressing_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetChannelAddressing_Responses.FromString,
        )
    self.GetChannelAddressing = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetChannelAddressing',
        request_serializer=DeviceServicer__pb2.GetChannelAddressing_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetChannelAddressing_Responses.FromString,
        )
    self.SetEventMessages = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetEventMessages',
        request_serializer=DeviceServicer__pb2.SetEventMessages_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetEventMessages_Responses.FromString,
        )
    self.GetEventMessages = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetEventMessages',
        request_serializer=DeviceServicer__pb2.GetEventMessages_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetEventMessages_Responses.FromString,
        )
    self.GetSerialProtocol = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetSerialProtocol',
        request_serializer=DeviceServicer__pb2.GetSerialProtocol_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetSerialProtocol_Responses.FromString,
        )
    self.SetPumpName = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetPumpName',
        request_serializer=DeviceServicer__pb2.SetPumpName_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetPumpName_Responses.FromString,
        )
    self.GetChannelNumber = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetChannelNumber',
        request_serializer=DeviceServicer__pb2.GetChannelNumber_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetChannelNumber_Responses.FromString,
        )
    self.SetChannelNumber = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetChannelNumber',
        request_serializer=DeviceServicer__pb2.SetChannelNumber_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetChannelNumber_Responses.FromString,
        )
    self.GetRevolutions = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetRevolutions',
        request_serializer=DeviceServicer__pb2.GetRevolutions_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetRevolutions_Responses.FromString,
        )
    self.GetChannelTotalVolume = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetChannelTotalVolume',
        request_serializer=DeviceServicer__pb2.GetChannelTotalVolume_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetChannelTotalVolume_Responses.FromString,
        )
    self.GetTotalTime = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetTotalTime',
        request_serializer=DeviceServicer__pb2.GetTotalTime_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetTotalTime_Responses.FromString,
        )
    self.GetHeadModel = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetHeadModel',
        request_serializer=DeviceServicer__pb2.GetHeadModel_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetHeadModel_Responses.FromString,
        )
    self.SetHeadModel = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetHeadModel',
        request_serializer=DeviceServicer__pb2.SetHeadModel_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetHeadModel_Responses.FromString,
        )
    self.SetUserInterface = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetUserInterface',
        request_serializer=DeviceServicer__pb2.SetUserInterface_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetUserInterface_Responses.FromString,
        )
    self.SetDisableInterface = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetDisableInterface',
        request_serializer=DeviceServicer__pb2.SetDisableInterface_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetDisableInterface_Responses.FromString,
        )
    self.SetDisplayNumbers = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetDisplayNumbers',
        request_serializer=DeviceServicer__pb2.SetDisplayNumbers_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetDisplayNumbers_Responses.FromString,
        )
    self.SetDisplayLetters = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetDisplayLetters',
        request_serializer=DeviceServicer__pb2.SetDisplayLetters_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetDisplayLetters_Responses.FromString,
        )
    self.GetTimeSetting = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetTimeSetting',
        request_serializer=DeviceServicer__pb2.GetTimeSetting_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetTimeSetting_Responses.FromString,
        )
    self.SetTimeSetting = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetTimeSetting',
        request_serializer=DeviceServicer__pb2.SetTimeSetting_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetTimeSetting_Responses.FromString,
        )
    self.SetRunTimeM = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetRunTimeM',
        request_serializer=DeviceServicer__pb2.SetRunTimeM_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetRunTimeM_Responses.FromString,
        )
    self.SetRunTimeH = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetRunTimeH',
        request_serializer=DeviceServicer__pb2.SetRunTimeH_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetRunTimeH_Responses.FromString,
        )
    self.GetRollerStepsLow = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetRollerStepsLow',
        request_serializer=DeviceServicer__pb2.GetRollerStepsLow_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetRollerStepsLow_Responses.FromString,
        )
    self.SetRollerStepsLow = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetRollerStepsLow',
        request_serializer=DeviceServicer__pb2.SetRollerStepsLow_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetRollerStepsLow_Responses.FromString,
        )
    self.GetRollerStepsHigh = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetRollerStepsHigh',
        request_serializer=DeviceServicer__pb2.GetRollerStepsHigh_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetRollerStepsHigh_Responses.FromString,
        )
    self.SetRollerStepsHigh = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetRollerStepsHigh',
        request_serializer=DeviceServicer__pb2.SetRollerStepsHigh_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetRollerStepsHigh_Responses.FromString,
        )
    self.GetRSV = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetRSV',
        request_serializer=DeviceServicer__pb2.GetRSV_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetRSV_Responses.FromString,
        )
    self.SetRSV = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetRSV',
        request_serializer=DeviceServicer__pb2.SetRSV_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetRSV_Responses.FromString,
        )
    self.SetRSVReset = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetRSVReset',
        request_serializer=DeviceServicer__pb2.SetRSVReset_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetRSVReset_Responses.FromString,
        )
    self.ResetRSVTable = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/ResetRSVTable',
        request_serializer=DeviceServicer__pb2.ResetRSVTable_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.ResetRSVTable_Responses.FromString,
        )
    self.SetNonFactoryRSV = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetNonFactoryRSV',
        request_serializer=DeviceServicer__pb2.SetNonFactoryRSV_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetNonFactoryRSV_Responses.FromString,
        )
    self.GetPauseTime = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetPauseTime',
        request_serializer=DeviceServicer__pb2.GetPauseTime_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetPauseTime_Responses.FromString,
        )
    self.SetPauseTime = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetPauseTime',
        request_serializer=DeviceServicer__pb2.SetPauseTime_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetPauseTime_Responses.FromString,
        )
    self.SetPauseTimeM = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetPauseTimeM',
        request_serializer=DeviceServicer__pb2.SetPauseTimeM_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetPauseTimeM_Responses.FromString,
        )
    self.SetPauseTimeH = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetPauseTimeH',
        request_serializer=DeviceServicer__pb2.SetPauseTimeH_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetPauseTimeH_Responses.FromString,
        )
    self.GetTotalVolume = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetTotalVolume',
        request_serializer=DeviceServicer__pb2.GetTotalVolume_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetTotalVolume_Responses.FromString,
        )
    self.SaveSettings = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SaveSettings',
        request_serializer=DeviceServicer__pb2.SaveSettings_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SaveSettings_Responses.FromString,
        )
    self.SaveSetRoller = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SaveSetRoller',
        request_serializer=DeviceServicer__pb2.SaveSetRoller_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SaveSetRoller_Responses.FromString,
        )
    self.GetFootSwitchStatus = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetFootSwitchStatus',
        request_serializer=DeviceServicer__pb2.GetFootSwitchStatus_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetFootSwitchStatus_Responses.FromString,
        )
    self.SetRollersNumber = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetRollersNumber',
        request_serializer=DeviceServicer__pb2.SetRollersNumber_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetRollersNumber_Responses.FromString,
        )
    self.GetRollersNumber = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/GetRollersNumber',
        request_serializer=DeviceServicer__pb2.GetRollersNumber_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetRollersNumber_Responses.FromString,
        )
    self.SetPumpSerialNumber = channel.unary_unary(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/SetPumpSerialNumber',
        request_serializer=DeviceServicer__pb2.SetPumpSerialNumber_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.SetPumpSerialNumber_Responses.FromString,
        )
    self.Subscribe_CurrentStatus = channel.unary_stream(
        '/sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer/Subscribe_CurrentStatus',
        request_serializer=DeviceServicer__pb2.Subscribe_CurrentStatus_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.Subscribe_CurrentStatus_Responses.FromString,
        )


class DeviceServicerServicer(object):
  """Feature: Device Servicer

  General device software and hardware information can be retrieved and changed within this function.
  By Valeryia Sidarava, Institute of Biochemical Engineering, Technical University of Munich, 31.07.2019 and
  Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 15.04.2020

  """

  def GetLog(self, request, context):
    """Get Log
    Get the current status of the device from the state machine of the SiLA server.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetLog_Info(self, request, context):
    # missing associated documentation comment in .proto file
    pass
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetLog_Result(self, request, context):
    # missing associated documentation comment in .proto file
    pass
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetPumpAddress(self, request, context):
    """Set Pump Address

    Set the address of the pump (1-8).

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetLanguage(self, request, context):
    """Set Language

    Set the language of the pump.

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetLanguage(self, request, context):
    """Get Language
    Get The language of the pump. 0=English / 1=French / 2=Spanish / 3=German.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetPumpStatus(self, request, context):
    """Get Pump Status
    Get pump status. +=running, -=stopped/standby.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetVersionType(self, request, context):
    """Get Version Type
    Get pump information. Response is string of model description (variable length), software version (3 digits) and pump
    head model type code (3 digits).
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def CurrentVersionSoftware(self, request, context):
    """Current Version Software
    Get pump software version. Response is string.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetSerialNumber(self, request, context):
    """Get Serial Number
    Get pump serial number.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetChannelAddressing(self, request, context):
    """Set Channel Addressing

    Set whether (1) or not (0) channel addressing is enabled.

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetChannelAddressing(self, request, context):
    """Get Channel Addressing
    Get information whether (1) or not (0) channel addressing is enabled.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetEventMessages(self, request, context):
    """Set Event Messages

    Set whether (1) or not (0) event messages are enabled.

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetEventMessages(self, request, context):
    """Get Event Messages
    Get information whether (1) or not (0) event messages are enabled.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetSerialProtocol(self, request, context):
    """Get Serial Protocol
    Get an integer representing the version of the serial protocol.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetPumpName(self, request, context):
    """Set Pump Name

    Set pump name for display under remote control string.

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetChannelNumber(self, request, context):
    """Get ChannelNumber
    Get number of pump channels.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetChannelNumber(self, request, context):
    """Set Channel Number

    Set number of pump channels.

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetRevolutions(self, request, context):
    """Get Revolutions
    Get total number of revolutions.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetChannelTotalVolume(self, request, context):
    """Get Channel Total Volume
    Get channel total volume pumped since last reset, mL.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetTotalTime(self, request, context):
    """Get Total Time
    Get total time pumped for a channel since last reset, mL.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetHeadModel(self, request, context):
    """Get Head Model
    Get pump head model type code indicating the ID number of the pump head. The first two digits encode the number of
    channels on the head, and the second 2 digits represent the number of rollers.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetHeadModel(self, request, context):
    """Set Head Model

    Set pump head model type code up to 4 digits indicating the ID number of the pump head. The first two digits
    encode the number of channels on the head, and the second 2 digits represent the number of rollers

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetUserInterface(self, request, context):
    """Set User Interface

    Set control from the pump user interface

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetDisableInterface(self, request, context):
    """Set Disable Interface

    Disable pump user interface

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetDisplayNumbers(self, request, context):
    """Set Display Numbers

    Write numbers to the pump to display while under external control - string (less than 17 characters)

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetDisplayLetters(self, request, context):
    """Set Display Letters

    Write letters to the pump to display while under external control - string (less than 17 characters)

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetTimeSetting(self, request, context):
    """Get Time Setting
    Get current setting for pump time in 1/10 seconds.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetTimeSetting(self, request, context):
    """Set Time Setting

    Set current setting for pump time in 1/10 seconds.

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetRunTimeM(self, request, context):
    """Set Run Time in Minutes

    Set current run time setting for dispensing in minutes (0-999)

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetRunTimeH(self, request, context):
    """Set Run Time in Hours

    Set current run time setting for dispensing in hours (0-999)

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetRollerStepsLow(self, request, context):
    """Get Roller Steps low order
    Get current setting for volume to pump in low order roller steps. The total number of roller steps
    which are dispensed during an operation is computed as [ u*65536 + U].
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetRollerStepsLow(self, request, context):
    """Set Roller Steps low order

    Set current setting for volume to pump in roller steps (0 - 65536).

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetRollerStepsHigh(self, request, context):
    """Get Roller Steps high order 
    Get current setting for volume to pump in high order roller steps. The total number of roller steps
    which are dispensed during an operation is computed as [ u*65536 + U].
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetRollerStepsHigh(self, request, context):
    """Set Roller Steps High order

    Set current setting for volume to pump in roller steps (greater than 65536).

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetRSV(self, request, context):
    """Get Roller Step Volume 
    Get the pump's current setting for roller step volume (RSV) based on the current calibration,
    tubing diameter and roller count in nL. If no calibration has been performed, the default volume is returned
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetRSV(self, request, context):
    """Set Roller Step Volume

    Set the calibrated roller step volume (RSV) in nL to use for this pump/channel.
    The value is used as calibration value and is overwritten by subsequent calibrations and reset by changing tubing
    diameter.

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetRSVReset(self, request, context):
    """Set Roller Step Volume Reset

    Reset the pump to discard calibration data, use default roller step volume

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def ResetRSVTable(self, request, context):
    """Reset Roller Step Volume Table

    Reset roller step value table to default

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetNonFactoryRSV(self, request, context):
    """Set Non-Factory Roller Step Volume

    Change factory roller step volume for a particular roller count and tubing size using roller count (6,8,12);
    index of the tubing diameter; RSV

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetPauseTime(self, request, context):
    """Get Pause Time 
    Get current setting for pause time in 1/10 seconds
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetPauseTime(self, request, context):
    """Set Pause Time

    Set current setting for pause time in 1/10 seconds

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetPauseTimeM(self, request, context):
    """Set Pause Time in Minutes

    Set current setting for pause time in minutes (0-999)

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetPauseTimeH(self, request, context):
    """Set Pause Time in Hours

    Set current setting for pause time in hours (0-999)

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetTotalVolume(self, request, context):
    """Get Total Volume
    Get total volume dispensed since the last reset in uL, mL or L.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SaveSettings(self, request, context):
    """Save Settings
    Saves the current pump settings values to memory.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SaveSetRoller(self, request, context):
    """Save Set Roller Step
    Saves set roller step settings.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetFootSwitchStatus(self, request, context):
    """Get Foot Switch Status
    Get the current status of the foot switch:   - open  /  + grounded.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetRollersNumber(self, request, context):
    """Set Rollers Number

    Set number of rollers for channel

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetRollersNumber(self, request, context):
    """Get Rollers Number
    Get number of rollers for channel
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def SetPumpSerialNumber(self, request, context):
    """Set Pump Serial Number

    Set pump serial number string.

    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def Subscribe_CurrentStatus(self, request, context):
    """Current Status
    Get the current status of the device from the internal state machine of the SiLA server.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')


def add_DeviceServicerServicer_to_server(servicer, server):
  rpc_method_handlers = {
      'GetLog': grpc.unary_unary_rpc_method_handler(
          servicer.GetLog,
          request_deserializer=DeviceServicer__pb2.GetLog_Parameters.FromString,
          response_serializer=SiLAFramework__pb2.CommandConfirmation.SerializeToString,
      ),
      'GetLog_Info': grpc.unary_stream_rpc_method_handler(
          servicer.GetLog_Info,
          request_deserializer=SiLAFramework__pb2.CommandExecutionUUID.FromString,
          response_serializer=SiLAFramework__pb2.ExecutionInfo.SerializeToString,
      ),
      'GetLog_Result': grpc.unary_unary_rpc_method_handler(
          servicer.GetLog_Result,
          request_deserializer=SiLAFramework__pb2.CommandExecutionUUID.FromString,
          response_serializer=DeviceServicer__pb2.GetLog_Responses.SerializeToString,
      ),
      'SetPumpAddress': grpc.unary_unary_rpc_method_handler(
          servicer.SetPumpAddress,
          request_deserializer=DeviceServicer__pb2.SetPumpAddress_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetPumpAddress_Responses.SerializeToString,
      ),
      'SetLanguage': grpc.unary_unary_rpc_method_handler(
          servicer.SetLanguage,
          request_deserializer=DeviceServicer__pb2.SetLanguage_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetLanguage_Responses.SerializeToString,
      ),
      'GetLanguage': grpc.unary_unary_rpc_method_handler(
          servicer.GetLanguage,
          request_deserializer=DeviceServicer__pb2.GetLanguage_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetLanguage_Responses.SerializeToString,
      ),
      'GetPumpStatus': grpc.unary_unary_rpc_method_handler(
          servicer.GetPumpStatus,
          request_deserializer=DeviceServicer__pb2.GetPumpStatus_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetPumpStatus_Responses.SerializeToString,
      ),
      'GetVersionType': grpc.unary_unary_rpc_method_handler(
          servicer.GetVersionType,
          request_deserializer=DeviceServicer__pb2.GetVersionType_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetVersionType_Responses.SerializeToString,
      ),
      'CurrentVersionSoftware': grpc.unary_unary_rpc_method_handler(
          servicer.CurrentVersionSoftware,
          request_deserializer=DeviceServicer__pb2.CurrentVersionSoftware_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.CurrentVersionSoftware_Responses.SerializeToString,
      ),
      'GetSerialNumber': grpc.unary_unary_rpc_method_handler(
          servicer.GetSerialNumber,
          request_deserializer=DeviceServicer__pb2.GetSerialNumber_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetSerialNumber_Responses.SerializeToString,
      ),
      'SetChannelAddressing': grpc.unary_unary_rpc_method_handler(
          servicer.SetChannelAddressing,
          request_deserializer=DeviceServicer__pb2.SetChannelAddressing_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetChannelAddressing_Responses.SerializeToString,
      ),
      'GetChannelAddressing': grpc.unary_unary_rpc_method_handler(
          servicer.GetChannelAddressing,
          request_deserializer=DeviceServicer__pb2.GetChannelAddressing_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetChannelAddressing_Responses.SerializeToString,
      ),
      'SetEventMessages': grpc.unary_unary_rpc_method_handler(
          servicer.SetEventMessages,
          request_deserializer=DeviceServicer__pb2.SetEventMessages_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetEventMessages_Responses.SerializeToString,
      ),
      'GetEventMessages': grpc.unary_unary_rpc_method_handler(
          servicer.GetEventMessages,
          request_deserializer=DeviceServicer__pb2.GetEventMessages_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetEventMessages_Responses.SerializeToString,
      ),
      'GetSerialProtocol': grpc.unary_unary_rpc_method_handler(
          servicer.GetSerialProtocol,
          request_deserializer=DeviceServicer__pb2.GetSerialProtocol_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetSerialProtocol_Responses.SerializeToString,
      ),
      'SetPumpName': grpc.unary_unary_rpc_method_handler(
          servicer.SetPumpName,
          request_deserializer=DeviceServicer__pb2.SetPumpName_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetPumpName_Responses.SerializeToString,
      ),
      'GetChannelNumber': grpc.unary_unary_rpc_method_handler(
          servicer.GetChannelNumber,
          request_deserializer=DeviceServicer__pb2.GetChannelNumber_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetChannelNumber_Responses.SerializeToString,
      ),
      'SetChannelNumber': grpc.unary_unary_rpc_method_handler(
          servicer.SetChannelNumber,
          request_deserializer=DeviceServicer__pb2.SetChannelNumber_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetChannelNumber_Responses.SerializeToString,
      ),
      'GetRevolutions': grpc.unary_unary_rpc_method_handler(
          servicer.GetRevolutions,
          request_deserializer=DeviceServicer__pb2.GetRevolutions_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetRevolutions_Responses.SerializeToString,
      ),
      'GetChannelTotalVolume': grpc.unary_unary_rpc_method_handler(
          servicer.GetChannelTotalVolume,
          request_deserializer=DeviceServicer__pb2.GetChannelTotalVolume_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetChannelTotalVolume_Responses.SerializeToString,
      ),
      'GetTotalTime': grpc.unary_unary_rpc_method_handler(
          servicer.GetTotalTime,
          request_deserializer=DeviceServicer__pb2.GetTotalTime_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetTotalTime_Responses.SerializeToString,
      ),
      'GetHeadModel': grpc.unary_unary_rpc_method_handler(
          servicer.GetHeadModel,
          request_deserializer=DeviceServicer__pb2.GetHeadModel_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetHeadModel_Responses.SerializeToString,
      ),
      'SetHeadModel': grpc.unary_unary_rpc_method_handler(
          servicer.SetHeadModel,
          request_deserializer=DeviceServicer__pb2.SetHeadModel_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetHeadModel_Responses.SerializeToString,
      ),
      'SetUserInterface': grpc.unary_unary_rpc_method_handler(
          servicer.SetUserInterface,
          request_deserializer=DeviceServicer__pb2.SetUserInterface_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetUserInterface_Responses.SerializeToString,
      ),
      'SetDisableInterface': grpc.unary_unary_rpc_method_handler(
          servicer.SetDisableInterface,
          request_deserializer=DeviceServicer__pb2.SetDisableInterface_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetDisableInterface_Responses.SerializeToString,
      ),
      'SetDisplayNumbers': grpc.unary_unary_rpc_method_handler(
          servicer.SetDisplayNumbers,
          request_deserializer=DeviceServicer__pb2.SetDisplayNumbers_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetDisplayNumbers_Responses.SerializeToString,
      ),
      'SetDisplayLetters': grpc.unary_unary_rpc_method_handler(
          servicer.SetDisplayLetters,
          request_deserializer=DeviceServicer__pb2.SetDisplayLetters_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetDisplayLetters_Responses.SerializeToString,
      ),
      'GetTimeSetting': grpc.unary_unary_rpc_method_handler(
          servicer.GetTimeSetting,
          request_deserializer=DeviceServicer__pb2.GetTimeSetting_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetTimeSetting_Responses.SerializeToString,
      ),
      'SetTimeSetting': grpc.unary_unary_rpc_method_handler(
          servicer.SetTimeSetting,
          request_deserializer=DeviceServicer__pb2.SetTimeSetting_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetTimeSetting_Responses.SerializeToString,
      ),
      'SetRunTimeM': grpc.unary_unary_rpc_method_handler(
          servicer.SetRunTimeM,
          request_deserializer=DeviceServicer__pb2.SetRunTimeM_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetRunTimeM_Responses.SerializeToString,
      ),
      'SetRunTimeH': grpc.unary_unary_rpc_method_handler(
          servicer.SetRunTimeH,
          request_deserializer=DeviceServicer__pb2.SetRunTimeH_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetRunTimeH_Responses.SerializeToString,
      ),
      'GetRollerStepsLow': grpc.unary_unary_rpc_method_handler(
          servicer.GetRollerStepsLow,
          request_deserializer=DeviceServicer__pb2.GetRollerStepsLow_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetRollerStepsLow_Responses.SerializeToString,
      ),
      'SetRollerStepsLow': grpc.unary_unary_rpc_method_handler(
          servicer.SetRollerStepsLow,
          request_deserializer=DeviceServicer__pb2.SetRollerStepsLow_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetRollerStepsLow_Responses.SerializeToString,
      ),
      'GetRollerStepsHigh': grpc.unary_unary_rpc_method_handler(
          servicer.GetRollerStepsHigh,
          request_deserializer=DeviceServicer__pb2.GetRollerStepsHigh_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetRollerStepsHigh_Responses.SerializeToString,
      ),
      'SetRollerStepsHigh': grpc.unary_unary_rpc_method_handler(
          servicer.SetRollerStepsHigh,
          request_deserializer=DeviceServicer__pb2.SetRollerStepsHigh_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetRollerStepsHigh_Responses.SerializeToString,
      ),
      'GetRSV': grpc.unary_unary_rpc_method_handler(
          servicer.GetRSV,
          request_deserializer=DeviceServicer__pb2.GetRSV_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetRSV_Responses.SerializeToString,
      ),
      'SetRSV': grpc.unary_unary_rpc_method_handler(
          servicer.SetRSV,
          request_deserializer=DeviceServicer__pb2.SetRSV_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetRSV_Responses.SerializeToString,
      ),
      'SetRSVReset': grpc.unary_unary_rpc_method_handler(
          servicer.SetRSVReset,
          request_deserializer=DeviceServicer__pb2.SetRSVReset_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetRSVReset_Responses.SerializeToString,
      ),
      'ResetRSVTable': grpc.unary_unary_rpc_method_handler(
          servicer.ResetRSVTable,
          request_deserializer=DeviceServicer__pb2.ResetRSVTable_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.ResetRSVTable_Responses.SerializeToString,
      ),
      'SetNonFactoryRSV': grpc.unary_unary_rpc_method_handler(
          servicer.SetNonFactoryRSV,
          request_deserializer=DeviceServicer__pb2.SetNonFactoryRSV_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetNonFactoryRSV_Responses.SerializeToString,
      ),
      'GetPauseTime': grpc.unary_unary_rpc_method_handler(
          servicer.GetPauseTime,
          request_deserializer=DeviceServicer__pb2.GetPauseTime_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetPauseTime_Responses.SerializeToString,
      ),
      'SetPauseTime': grpc.unary_unary_rpc_method_handler(
          servicer.SetPauseTime,
          request_deserializer=DeviceServicer__pb2.SetPauseTime_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetPauseTime_Responses.SerializeToString,
      ),
      'SetPauseTimeM': grpc.unary_unary_rpc_method_handler(
          servicer.SetPauseTimeM,
          request_deserializer=DeviceServicer__pb2.SetPauseTimeM_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetPauseTimeM_Responses.SerializeToString,
      ),
      'SetPauseTimeH': grpc.unary_unary_rpc_method_handler(
          servicer.SetPauseTimeH,
          request_deserializer=DeviceServicer__pb2.SetPauseTimeH_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetPauseTimeH_Responses.SerializeToString,
      ),
      'GetTotalVolume': grpc.unary_unary_rpc_method_handler(
          servicer.GetTotalVolume,
          request_deserializer=DeviceServicer__pb2.GetTotalVolume_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetTotalVolume_Responses.SerializeToString,
      ),
      'SaveSettings': grpc.unary_unary_rpc_method_handler(
          servicer.SaveSettings,
          request_deserializer=DeviceServicer__pb2.SaveSettings_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SaveSettings_Responses.SerializeToString,
      ),
      'SaveSetRoller': grpc.unary_unary_rpc_method_handler(
          servicer.SaveSetRoller,
          request_deserializer=DeviceServicer__pb2.SaveSetRoller_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SaveSetRoller_Responses.SerializeToString,
      ),
      'GetFootSwitchStatus': grpc.unary_unary_rpc_method_handler(
          servicer.GetFootSwitchStatus,
          request_deserializer=DeviceServicer__pb2.GetFootSwitchStatus_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetFootSwitchStatus_Responses.SerializeToString,
      ),
      'SetRollersNumber': grpc.unary_unary_rpc_method_handler(
          servicer.SetRollersNumber,
          request_deserializer=DeviceServicer__pb2.SetRollersNumber_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetRollersNumber_Responses.SerializeToString,
      ),
      'GetRollersNumber': grpc.unary_unary_rpc_method_handler(
          servicer.GetRollersNumber,
          request_deserializer=DeviceServicer__pb2.GetRollersNumber_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetRollersNumber_Responses.SerializeToString,
      ),
      'SetPumpSerialNumber': grpc.unary_unary_rpc_method_handler(
          servicer.SetPumpSerialNumber,
          request_deserializer=DeviceServicer__pb2.SetPumpSerialNumber_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.SetPumpSerialNumber_Responses.SerializeToString,
      ),
      'Subscribe_CurrentStatus': grpc.unary_stream_rpc_method_handler(
          servicer.Subscribe_CurrentStatus,
          request_deserializer=DeviceServicer__pb2.Subscribe_CurrentStatus_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.Subscribe_CurrentStatus_Responses.SerializeToString,
      ),
  }
  generic_handler = grpc.method_handlers_generic_handler(
      'sila2.org.silastandard.examples.deviceservicer.v1.DeviceServicer', rpc_method_handlers)
  server.add_generic_rpc_handlers((generic_handler,))
