"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Drive Control Servicer*

:details: DriveControlServicer:
    Set and retrieve information regarding the pump drive.
    By Valeryia Sidarava, Institute of Biochemical Engineering, Technical University of Munich, 31.07.2019,
    Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 15.04.2020.

:file:    DriveControlServicer_real.py
:authors: Valeryia Sidarava & Lukas Bromig

:date: (creation)          2020-04-16T10:19:58.249963
:date: (last modification) 2020-04-16T10:19:58.249963

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import DriveControlServicer_pb2 as DriveControlServicer_pb2
# from .gRPC import DriveControlServicer_pb2_grpc as DriveControlServicer_pb2_grpc

# import default arguments
from .DriveControlServicer_default_arguments import default_dict

# open serial connection via usb adapter
import serial
import serial.tools.list_ports
# Not available on BeagleBone/Debian
ports = list(serial.tools.list_ports.comports(include_links=True))

# noinspection PyPep8Naming,PyUnusedLocal
class DriveControlServicerReal:
    """
    Implementation of the *Drive Control Servicer* in *Real* mode
        This is a RegloICC Service
    """

    def __init__(self, ser):
        """Class initialiser"""
        
        self.ser = ser
        logging.debug('Started server in mode: {mode}'.format(mode='Real'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def StartPump(self, request, context: grpc.ServicerContext) \
            -> DriveControlServicer_pb2.StartPump_Responses:
        """
        Executes the unobservable command "Start Pump"
            Starts the pump out of stand-by mode.
    
        :param request: gRPC request containing the parameters passed:
            request.Start (Start):
            Real number 1-4 that defines channel to start
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.StartStatus (Start Status): Start of pump succeeded.
        """
    
        # initialise the return value
        return_value = None

        value = request.Start.value
        command = '%sH\r\n' % value
        command_as_bytes = str.encode(command)
        try:
            self.ser.write(command_as_bytes)
            read = self.ser.readline().rstrip()
            read = bytes.decode(read)
            read = str(read)
        except:
            print("Error writing Start command")
        return_value = DriveControlServicer_pb2.StartPump_Responses(StartStatus=silaFW_pb2.String(value=read))

        logging.debug("Starting channel %s" % value)

        # fallback to default
        if return_value is None:
            return_value = DriveControlServicer_pb2.StartPump_Responses(
                **default_dict['StartPump_Responses']
            )
    
        return return_value
    
    
    def Stop(self, request, context: grpc.ServicerContext) \
            -> DriveControlServicer_pb2.Stop_Responses:
        """
        Executes the unobservable command "Stop"
            Stops the pump.
    
        :param request: gRPC request containing the parameters passed:
            request.Stop (Stop):
            Real number 1-4 (1-8) that defines channel (pump) to stop
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.StopStatus (Stop Status): Shut-down of pump succeeded.
        """
    
        # initialise the return value
        return_value = None

        value = request.Stop.value
        command = '%sI\r\n' % value
        command_as_bytes = str.encode(command)
        try:
            self.ser.write(command_as_bytes)
            read = self.ser.readline().rstrip()
            read = bytes.decode(read)
            read = str(read)
        except:
            print("Error writing Stop command")
        return_value = DriveControlServicer_pb2.Stop_Responses(StopStatus=silaFW_pb2.String(value=read))

        logging.debug("Stopping channel %s" % value)

        # fallback to default
        if return_value is None:
            return_value = DriveControlServicer_pb2.Stop_Responses(
                **default_dict['Stop_Responses']
            )
    
        return return_value
    
    
    def GetPumpDirection(self, request, context: grpc.ServicerContext) \
            -> DriveControlServicer_pb2.GetPumpDirection_Responses:
        """
        Executes the unobservable command "Get Pump Direction"
            Get pump direction.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpDirection (Pump Direction): Pump direction query. J = clockwise/ K = counter-clockwise.
        """
    
        # initialise the return value
        return_value = None

        value = request.Channel.value
        command = '%sxD\r\n' % value
        command_as_bytes = str.encode(command)
        try:
            self.ser.write(command_as_bytes)
            read = self.ser.readline().rstrip()
            read = bytes.decode(read)
            read = str(read)
            if read is None:
                read = 'Error'
                logging.error("Error retrieving channel/pump rotation direction. NONE")
        except:
            read = 'Error'
            logging.error("Error retrieving chanel/pump rotation direction")

        return_value = DriveControlServicer_pb2.GetPumpDirection_Responses(PumpDirection=silaFW_pb2.String(value=read))

        logging.debug("Channel/pump %s rotation direction is : %s" % (value, read))

        # fallback to default
        if return_value is None:
            return_value = DriveControlServicer_pb2.GetPumpDirection_Responses(
                **default_dict['GetPumpDirection_Responses']
            )
    
        return return_value
    
    
    def SetDirectionClockwise(self, request, context: grpc.ServicerContext) \
            -> DriveControlServicer_pb2.SetDirectionClockwise_Responses:
        """
        Executes the unobservable command "Set Direction to clockwise"
            Set the rotation direction of the pump to clockwise
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetDirectionSet (Set Direction Set): Set Direction succeeded to Set.
        """
    
        # initialise the return value
        return_value = None

        value = request.Channel.value
        command = '%sJ\r\n' % value
        command_as_bytes = str.encode(command)
        try:
            self.ser.write(command_as_bytes)
            read = self.ser.readline().rstrip()
            read = bytes.decode(read)
            read = str(read)
        except:
            read = "Error setting rotation direction clockwise"

        return_value = DriveControlServicer_pb2.SetDirectionClockwise_Responses(SetDirectionSet=silaFW_pb2.String(value=read))

        logging.debug("Setting of clockwise rotation direction of channel %s: %s" % (value, read))
        # fallback to default
        if return_value is None:
            return_value = DriveControlServicer_pb2.SetDirectionClockwise_Responses(
                **default_dict['SetDirectionClockwise_Responses']
            )
    
        return return_value
    
    
    def SetDirectionCounterClockwise(self, request, context: grpc.ServicerContext) \
            -> DriveControlServicer_pb2.SetDirectionCounterClockwise_Responses:
        """
        Executes the unobservable command "Set Direction to counter-clockwise"
            Set the rotation direction of the pump to counter-clockwise
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetDirectionSet (Set Direction Set): Set Direction succeeded to Set.
        """
    
        # initialise the return value
        return_value = None

        value = request.Channel.value
        command = '%sK\r\n' % value
        command_as_bytes = str.encode(command)
        try:
            self.ser.write(command_as_bytes)
            read = self.ser.readline().rstrip()
            read = bytes.decode(read)
            read = str(read)
        except:
            read = "Error setting rotation direction clockwise"

        return_value = DriveControlServicer_pb2.SetDirectionCounterClockwise_Responses(SetDirectionSet=silaFW_pb2.String(value=read))

        logging.debug("Setting of counter-clockwise rotation direction of channel %s: %s" % (value, read))

        # fallback to default
        if return_value is None:
            return_value = DriveControlServicer_pb2.SetDirectionCounterClockwise_Responses(
                **default_dict['SetDirectionCounterClockwise_Responses']
            )
    
        return return_value
    
    def GetCauseResponse(self, request, context: grpc.ServicerContext) \
            -> DriveControlServicer_pb2.GetCauseResponse_Responses:
        """
        Executes the unobservable command "Get Cause Response"
            Get cause of "-" cannot run response = Parameter 1 :
            C=Cycle count of 0 / R=Max flow rate exceeded or flow rate is set to 0 / V=Max volume exceeded;
            Limiting value that was exceeded = Parameter 2:
            C=Value is undefined / R=Max flow (mL/min) / V=Max volume (mL)   .
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Cause (Cause): Cause displayed.
        """
    
        # initialise the return value
        return_value = None

        value = request.Channel.value
        command = '%sxe\r\n' % value
        command_as_bytes = str.encode(command)
        try:
            self.ser.write(command_as_bytes)
            read = self.ser.readline().rstrip()
            read = bytes.decode(read)

            if read is None:
                read = 999
                logging.error("Error retrieving cause of negative response. NONE")
            else:
                read = int(read)
        except:
            read = 999
            logging.error("Error retrieving cause of negative response")

        return_value = DriveControlServicer_pb2.GetCauseResponse_Responses(Cause=silaFW_pb2.String(value=read))

        # fallback to default
        if return_value is None:
            return_value = DriveControlServicer_pb2.GetCauseResponse_Responses(
                **default_dict['GetCauseResponse_Responses']
            )
        logging.debug("Cause of negative response on channel %s: %s" % (value, read))
        return return_value
