"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Drive Control Servicer*

:details: DriveControlServicer:
    Set and retrieve information regarding the pump drive.
    By Valeryia Sidarava, Institute of Biochemical Engineering, Technical University of Munich, 31.07.2019,
    Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 15.04.2020.
           
:file:    DriveControlServicer_servicer.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:58.238756
:date: (last modification) 2020-04-16T10:19:58.238756

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import DriveControlServicer_pb2 as DriveControlServicer_pb2
from .gRPC import DriveControlServicer_pb2_grpc as DriveControlServicer_pb2_grpc

# import simulation and real implementation
from .DriveControlServicer_simulation import DriveControlServicerSimulation
from .DriveControlServicer_real import DriveControlServicerReal


class DriveControlServicer(DriveControlServicer_pb2_grpc.DriveControlServicerServicer):
    """
    This is a RegloICC Service
    """
    implementation: Union[DriveControlServicerSimulation, DriveControlServicerReal]
    simulation_mode: bool

    def __init__(self, ser, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.ser = ser
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(DriveControlServicerSimulation())
        else:
            self._inject_implementation(DriveControlServicerReal(ser = self.ser))

    def _inject_implementation(self,
                               implementation: Union[DriveControlServicerSimulation,
                                                     DriveControlServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the RegloICCServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(DriveControlServicerSimulation())

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(DriveControlServicerReal(ser = self.ser))

    def StartPump(self, request, context: grpc.ServicerContext) \
            -> DriveControlServicer_pb2.StartPump_Responses:
        """
        Executes the unobservable command "Start Pump"
            Starts the pump out of stand-by mode.
    
        :param request: gRPC request containing the parameters passed:
            request.Start (Start):
            Real number 1-4 that defines channel to start
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.StartStatus (Start Status): Start of pump succeeded.
        """
    
        logging.debug(
            "StartPump called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.StartPump(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def Stop(self, request, context: grpc.ServicerContext) \
            -> DriveControlServicer_pb2.Stop_Responses:
        """
        Executes the unobservable command "Stop"
            Stops the pump.
    
        :param request: gRPC request containing the parameters passed:
            request.Stop (Stop):
            Real number 1-4 (1-8) that defines channel (pump) to stop
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.StopStatus (Stop Status): Shut-down of pump succeeded.
        """
    
        logging.debug(
            "Stop called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.Stop(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetPumpDirection(self, request, context: grpc.ServicerContext) \
            -> DriveControlServicer_pb2.GetPumpDirection_Responses:
        """
        Executes the unobservable command "Get Pump Direction"
            Get pump direction.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpDirection (Pump Direction): Pump direction query. J = clockwise/ K = counter-clockwise.
        """
    
        logging.debug(
            "GetPumpDirection called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPumpDirection(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDirectionClockwise(self, request, context: grpc.ServicerContext) \
            -> DriveControlServicer_pb2.SetDirectionClockwise_Responses:
        """
        Executes the unobservable command "Set Direction to clockwise"
            Set the rotation direction of the pump to clockwise
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetDirectionSet (Set Direction Set): Set Direction succeeded to Set.
        """
    
        logging.debug(
            "SetDirectionClockwise called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDirectionClockwise(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDirectionCounterClockwise(self, request, context: grpc.ServicerContext) \
            -> DriveControlServicer_pb2.SetDirectionCounterClockwise_Responses:
        """
        Executes the unobservable command "Set Direction to counter-clockwise"
            Set the rotation direction of the pump to counter-clockwise
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetDirectionSet (Set Direction Set): Set Direction succeeded to Set.
        """
    
        logging.debug(
            "SetDirectionCounterClockwise called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDirectionCounterClockwise(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetCauseResponse(self, request, context: grpc.ServicerContext) \
            -> DriveControlServicer_pb2.GetCauseResponse_Responses:
        """
        Executes the unobservable command "Get Cause Response"
            Get cause of "-" cannot run response = Parameter 1 :
            C=Cycle count of 0 / R=Max flow rate exceeded or flow rate is set to 0 / V=Max volume exceeded;
            Limiting value that was exceeded = Parameter 2:
            C=Value is undefined / R=Max flow (mL/min) / V=Max volume (mL)   .
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Cause (Cause): Cause displayed.
        """
    
        logging.debug(
            "GetCauseResponse called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetCauseResponse(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
