"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Parameter Control Servicer*

:details: ParameterControlServicer:
    Set and retrieve information regarding the parameter settings of the Reglo ICC pump.
    By Valeryia Sidarava, Institute of Biochemical Engineering, Technical University of Munich, 31.07.2019,
    Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 15.04.2020.
           
:file:    ParameterControlServicer_servicer.py
:authors: Valeryia Sidarava & Lukas Bromig

:date: (creation)          2020-04-16T10:19:58.272934
:date: (last modification) 2020-04-16T10:19:58.272934

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import ParameterControlServicer_pb2 as ParameterControlServicer_pb2
from .gRPC import ParameterControlServicer_pb2_grpc as ParameterControlServicer_pb2_grpc

# import simulation and real implementation
from .ParameterControlServicer_simulation import ParameterControlServicerSimulation
from .ParameterControlServicer_real import ParameterControlServicerReal


class ParameterControlServicer(ParameterControlServicer_pb2_grpc.ParameterControlServicerServicer):
    """
    This is a RegloICC Service
    """
    implementation: Union[ParameterControlServicerSimulation, ParameterControlServicerReal]
    simulation_mode: bool

    def __init__(self,ser, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.ser = ser
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(ParameterControlServicerSimulation())
        else:
            self._inject_implementation(ParameterControlServicerReal(ser=self.ser))

    def _inject_implementation(self,
                               implementation: Union[ParameterControlServicerSimulation,
                                                     ParameterControlServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the RegloICCServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(ParameterControlServicerSimulation())

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(ParameterControlServicerReal(ser=self.ser))

    def SetFlowRate(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetFlowRate_Responses:
        """
        Executes the unobservable command "Set Flow Rate value "
            Set the desired flow rate of the pump, mL/min
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.SetFlowRate (Set FlowRate):
            Set the desired RPM flow rate in volume/time mode, mL/min
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetFlowRateSet (Set Flow Rate Set): Set Flow Rate succeeded to Set.
        """
    
        logging.debug(
            "SetFlowRate called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetFlowRate(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetRPMMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetRPMMode_Responses:
        """
        Executes the unobservable command "Set RPM Mode"
            Set the current channel/pump mode to RPM mode.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpMode (Pump Mode):
            Current channel or pump mode: L=RPM / M=Flow Rate / O=Volume (at Rate) / G=Volume (over Time) / Q=Volume+Pause / N=Time / P=Time+Pause
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Pump mode succeeded to Set.
        """
    
        logging.debug(
            "SetRPMMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetRPMMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetFlowRateMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetFlowRateMode_Responses:
        """
        Executes the unobservable command "Set Flow Rate Mode"
            Set the current channel/pump mode to Flow Rate mode.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpMode (Pump Mode):
            Current channel or pump mode: L=RPM / M=Flow Rate / O=Volume (at Rate) / G=Volume (over Time) / Q=Volume+Pause / N=Time / P=Time+Pause
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Pump mode succeeded to Set.
        """
    
        logging.debug(
            "SetFlowRateMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetFlowRateMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetVolumeRateMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetVolumeRateMode_Responses:
        """
        Executes the unobservable command "Set Volume Rate Mode"
            Set the current channel/pump mode to Volume (at Rate) mode.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpMode (Pump Mode):
            Current channel or pump mode: L=RPM / M=Flow Rate / O=Volume (at Rate) / G=Volume (over Time) / Q=Volume+Pause / N=Time / P=Time+Pause
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Pump mode succeeded to Set.
        """
    
        logging.debug(
            "SetVolumeRateMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetVolumeRateMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetVolumeTimeMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetVolumeTimeMode_Responses:
        """
        Executes the unobservable command "Set Volume Time Mode"
            Set the current channel/pump mode to Volume (over Time) mode.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpMode (Pump Mode):
            Current channel or pump mode: L=RPM / M=Flow Rate / O=Volume (at Rate) / G=Volume (over Time) / Q=Volume+Pause / N=Time / P=Time+Pause
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Pump mode succeeded to Set.
        """
    
        logging.debug(
            "SetVolumeTimeMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetVolumeTimeMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetVolumePauseMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetVolumePauseMode_Responses:
        """
        Executes the unobservable command "Set Volume Pause Mode"
            Set the current channel/pump mode to Volume+Pause mode.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpMode (Pump Mode):
            Current channel or pump mode: L=RPM / M=Flow Rate / O=Volume (at Rate) / G=Volume (over Time) / Q=Volume+Pause / N=Time / P=Time+Pause
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Pump mode succeeded to Set.
        """
    
        logging.debug(
            "SetVolumePauseMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetVolumePauseMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetTimeMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetTimeMode_Responses:
        """
        Executes the unobservable command "Set Time Mode"
            Set the current channel/pump mode to Time mode.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpMode (Pump Mode):
            Current channel or pump mode: L=RPM / M=Flow Rate / O=Volume (at Rate) / G=Volume (over Time) / Q=Volume+Pause / N=Time / P=Time+Pause
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Pump mode succeeded to Set.
        """
    
        logging.debug(
            "SetTimeMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetTimeMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetTimePauseMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetTimePauseMode_Responses:
        """
        Executes the unobservable command "Set Time Pause Mode"
            Set the current channel/pump mode to Time+Pause mode.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpMode (Pump Mode):
            Current channel or pump mode: L=RPM / M=Flow Rate / O=Volume (at Rate) / G=Volume (over Time) / Q=Volume+Pause / N=Time / P=Time+Pause
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Pump mode succeeded to Set.
        """
    
        logging.debug(
            "SetTimePauseMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetTimePauseMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetVolume(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetVolume_Responses:
        """
        Executes the unobservable command "Set Volume"
            Set the current setting for volume in mL. Volume Type 2.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.Volume (Volume):
            Set the current setting for volume in mL. Volume Type 2.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.VolumeSet (Volume Set): Volume succeeded to Set
        """
    
        logging.debug(
            "SetVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetFlowRate(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetFlowRate_Responses:
        """
        Executes the unobservable command "Get Flow Rate"
            Get current flow rate (mL/min).
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFlowRate (Current Flow Rate): Current flow rate of the channel.
        """
    
        logging.debug(
            "GetFlowRate called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetFlowRate(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetMode_Responses:
        """
        Executes the unobservable command "Get Mode"
            Get the current channel or pump mode
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPumpMode (Current Pump Mode): Current channel or pump mode is retrieved.
        """
    
        logging.debug(
            "GetMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetVolume(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetVolume_Responses:
        """
        Executes the unobservable command "Get Volume"
            Get the current setting for volume in mL/min.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVolume (Current Volume): Current setting for volume in mL/min.
        """
    
        logging.debug(
            "GetVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetMaximumFlowRate(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetMaximumFlowRate_Responses:
        """
        Executes the unobservable command "Get Maximum Flow Rate"
            Get maximum flow rate achievable with current settings, mL/min.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.MaximumFlowRate (Maximum Flow Rate): Maximum Flow Rate achievable with current settings, mL/min.
        """
    
        logging.debug(
            "GetMaximumFlowRate called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetMaximumFlowRate(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetMaximumFlowRateWithCalibration(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetMaximumFlowRateWithCalibration_Responses:
        """
        Executes the unobservable command "Get Maximum Flow Rate using Calibration"
            Get maximum flow rate achievable with current settings using calibration, mL/min.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.MaximumFlowRateWithCalibration (Maximum Flow Rate using Calibration): Maximum Flow Rate achievable with current settings using calibration, mL/min.
        """
    
        logging.debug(
            "GetMaximumFlowRateWithCalibration called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetMaximumFlowRateWithCalibration(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSpeedSettingRPM(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetSpeedSettingRPM_Responses:
        """
        Executes the unobservable command "Get Speed Setting in RPM"
            Get the current speed setting in RPM.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSpeedSetting (Current Speed Setting): The current speed setting in RPM.
        """
    
        logging.debug(
            "GetSpeedSettingRPM called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSpeedSettingRPM(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetSpeedSettingRPM(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetSpeedSettingRPM_Responses:
        """
        Executes the unobservable command "Set Speed Setting in RPM"
            Set speed setting in RPM (RPM Mode flow rate setting (0.01 RPM) Discrete Type 3).
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.Speed (Speed):
            Speed setting in RPM (RPM Mode flow rate setting (0.01 RPM) Discrete Type 3)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSpeedSetting (Current Speed Setting): RPM Mode flow rate setting.
        """
    
        logging.debug(
            "SetSpeedSettingRPM called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetSpeedSettingRPM(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetCurrentRunTime(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetCurrentRunTime_Responses:
        """
        Executes the unobservable command "Set Current Run Time"
            Set current pump run time using Time Type 2 format (0 to 999h or 0 to 3596400s).
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.RunTime (Run Time):
            Set current pump run time using Time Type 2 format (0 to 999h or 0 to 3596400s).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetCurrentRunTimeSet (Set Current Run Time): Current Run Time succeeded to set.
        """
    
        logging.debug(
            "SetCurrentRunTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetCurrentRunTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetCurrentRunTime(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetCurrentRunTime_Responses:
        """
        Executes the unobservable command "Get Current Run Time"
            Get current pump run time using Time Type 2 format.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.GetCurrentRunTime (Get Current Run Time): Current Run Time of the pump.
        """
    
        logging.debug(
            "GetCurrentRunTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetCurrentRunTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetPumpingPauseTime(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetPumpingPauseTime_Responses:
        """
        Executes the unobservable command "Set Pumping Pause Time"
            Set pumping pause time using Time Type 2 format (0 to 999h or 0 to 3596400s).
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.PumpingPauseTime (Pumping Pause Time):
            Set pumping pause time using Time Type 2 format (0 to 999h or 0 to 3596400s).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetPumpingPauseTimeSet (Set Pumping Pause Time Time): Pumping pause time succeeded to set.
        """
    
        logging.debug(
            "SetPumpingPauseTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetPumpingPauseTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetPumpingPauseTime(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetPumpingPauseTime_Responses:
        """
        Executes the unobservable command "Get Pumping Pause Time"
            Get pumping pause time.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPumpingPauseTime (Current Pumping Pause Time): Current Pumping Pause Time.
        """
    
        logging.debug(
            "GetPumpingPauseTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPumpingPauseTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetCycleCount(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetCycleCount_Responses:
        """
        Executes the unobservable command "Get Cycle Count"
            Get pump cycle count.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCycleCount (Current Cycle Count): Current Cycle Count.
        """
    
        logging.debug(
            "GetCycleCount called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetCycleCount(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetCycleCount(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetCycleCount_Responses:
        """
        Executes the unobservable command "Set Cycle Count"
            Set pump cycle count (Discrete Type 2).
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.CycleCount (Cycle Count):
            Set pump cycle count
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetCycleCountSet (Set Cycle Count): Cycle Count succeeded to set.
        """
    
        logging.debug(
            "SetCycleCount called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetCycleCount(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetDispenseTimeMlMin(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetDispenseTimeMlMin_Responses:
        """
        Executes the unobservable command "Get Dispense Time at mL/min"
            Get time to dispense at a given volume at a given mL/min flow rate.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.Volume (Volume):
            Gets the volume, which must be dispensed
            request.FlowRate (FlowRate):
            Gets the flow rate, with which the volume must be dispensed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDispenseTime (CurrentDispenseTime): CurrentDispenseTime at a given volume at a given mL/min flow rate.
        """
    
        logging.debug(
            "GetDispenseTimeMlMin called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetDispenseTimeMlMin(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetDispenseTimeRPM(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetDispenseTimeRPM_Responses:
        """
        Executes the unobservable command "Get Dispense Time at RPM"
            Get time to dispense at a given volume at a given RPM.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Channel
            request.Volume (Volume):
            Gets the volume, which must be dispensed
            request.FlowRate (FlowRate):
            Gets the flow rate, with which the volume must be dispensed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDispenseTime (CurrentDispenseTime): CurrentDispenseTime at a given volume at a given RPM.
        """
    
        logging.debug(
            "GetDispenseTimeRPM called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetDispenseTimeRPM(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetFlowRateAtModes(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetFlowRateAtModes_Responses:
        """
        Executes the unobservable command "Get Flow Rate when mode is not RPM or Flow Rate"
            Get flow rate from RPM (S) or flow rate (f) when mode is not RPM or Flow Rate.: 0=RPM, 1=Flow Rate
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFlowRate (Current Flow Rate): CurrentDispenseTime at a given volume at a given RPM. : 0=RPM, 1=Flow Rate
        """
    
        logging.debug(
            "GetFlowRateAtModes called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetFlowRateAtModes(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetFlowRateAtModes(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetFlowRateAtModes_Responses:
        """
        Executes the unobservable command "Set Flow Rate when mode is not RPM or Flow Rate"
            Set RPM flow rate not in RPM or Flow Rate mode. (Discrete Type 3)
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.FlowRate (Flow Rate):
            Set RPM flow rate not in RPM or Flow Rate mode.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetFlowRateSet (Set Flow Rate): RPM flow rate not in RPM or Flow Rate mode succeeded to set
        """
    
        logging.debug(
            "SetFlowRateAtModes called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetFlowRateAtModes(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
