"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Parameter Control Servicer*

:details: ParameterControlServicer:
    Set and retrieve information regarding the parameter settings of the Reglo ICC pump.
    By Valeryia Sidarava, Institute of Biochemical Engineering, Technical University of Munich, 31.07.2019,
    Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 15.04.2020.

:file:    ParameterControlServicer_simulation.py
:authors: Valeryia Sidarava & Lukas Bromig

:date: (creation)          2020-04-16T10:19:58.296886
:date: (last modification) 2020-04-16T10:19:58.296886

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import ParameterControlServicer_pb2 as ParameterControlServicer_pb2
# from .gRPC import ParameterControlServicer_pb2_grpc as ParameterControlServicer_pb2_grpc

# import default arguments
from .ParameterControlServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class ParameterControlServicerSimulation:
    """
    Implementation of the *Parameter Control Servicer* in *Simulation* mode
        This is a RegloICC Service
    """

    def __init__(self):
        """Class initialiser"""

        logging.debug('Started server in mode: {mode}'.format(mode='Simulation'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def SetFlowRate(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetFlowRate_Responses:
        """
        Executes the unobservable command "Set Flow Rate value "
            Set the desired flow rate of the pump, mL/min
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.SetFlowRate (Set FlowRate):
            Set the desired RPM flow rate in volume/time mode, mL/min
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetFlowRateSet (Set Flow Rate Set): Set Flow Rate succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetFlowRate here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.SetFlowRate_Responses(
                **default_dict['SetFlowRate_Responses']
            )
    
        return return_value
    
    
    def SetRPMMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetRPMMode_Responses:
        """
        Executes the unobservable command "Set RPM Mode"
            Set the current channel/pump mode to RPM mode.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpMode (Pump Mode):
            Current channel or pump mode: L=RPM / M=Flow Rate / O=Volume (at Rate) / G=Volume (over Time) / Q=Volume+Pause / N=Time / P=Time+Pause
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Pump mode succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetRPMMode here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.SetRPMMode_Responses(
                **default_dict['SetRPMMode_Responses']
            )
    
        return return_value
    
    
    def SetFlowRateMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetFlowRateMode_Responses:
        """
        Executes the unobservable command "Set Flow Rate Mode"
            Set the current channel/pump mode to Flow Rate mode.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpMode (Pump Mode):
            Current channel or pump mode: L=RPM / M=Flow Rate / O=Volume (at Rate) / G=Volume (over Time) / Q=Volume+Pause / N=Time / P=Time+Pause
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Pump mode succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetFlowRateMode here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.SetFlowRateMode_Responses(
                **default_dict['SetFlowRateMode_Responses']
            )
    
        return return_value
    
    
    def SetVolumeRateMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetVolumeRateMode_Responses:
        """
        Executes the unobservable command "Set Volume Rate Mode"
            Set the current channel/pump mode to Volume (at Rate) mode.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpMode (Pump Mode):
            Current channel or pump mode: L=RPM / M=Flow Rate / O=Volume (at Rate) / G=Volume (over Time) / Q=Volume+Pause / N=Time / P=Time+Pause
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Pump mode succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetVolumeRateMode here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.SetVolumeRateMode_Responses(
                **default_dict['SetVolumeRateMode_Responses']
            )
    
        return return_value
    
    
    def SetVolumeTimeMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetVolumeTimeMode_Responses:
        """
        Executes the unobservable command "Set Volume Time Mode"
            Set the current channel/pump mode to Volume (over Time) mode.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpMode (Pump Mode):
            Current channel or pump mode: L=RPM / M=Flow Rate / O=Volume (at Rate) / G=Volume (over Time) / Q=Volume+Pause / N=Time / P=Time+Pause
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Pump mode succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetVolumeTimeMode here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.SetVolumeTimeMode_Responses(
                **default_dict['SetVolumeTimeMode_Responses']
            )
    
        return return_value
    
    
    def SetVolumePauseMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetVolumePauseMode_Responses:
        """
        Executes the unobservable command "Set Volume Pause Mode"
            Set the current channel/pump mode to Volume+Pause mode.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpMode (Pump Mode):
            Current channel or pump mode: L=RPM / M=Flow Rate / O=Volume (at Rate) / G=Volume (over Time) / Q=Volume+Pause / N=Time / P=Time+Pause
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Pump mode succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetVolumePauseMode here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.SetVolumePauseMode_Responses(
                **default_dict['SetVolumePauseMode_Responses']
            )
    
        return return_value
    
    
    def SetTimeMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetTimeMode_Responses:
        """
        Executes the unobservable command "Set Time Mode"
            Set the current channel/pump mode to Time mode.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpMode (Pump Mode):
            Current channel or pump mode: L=RPM / M=Flow Rate / O=Volume (at Rate) / G=Volume (over Time) / Q=Volume+Pause / N=Time / P=Time+Pause
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Pump mode succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetTimeMode here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.SetTimeMode_Responses(
                **default_dict['SetTimeMode_Responses']
            )
    
        return return_value
    
    
    def SetTimePauseMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetTimePauseMode_Responses:
        """
        Executes the unobservable command "Set Time Pause Mode"
            Set the current channel/pump mode to Time+Pause mode.
    
        :param request: gRPC request containing the parameters passed:
            request.PumpMode (Pump Mode):
            Current channel or pump mode: L=RPM / M=Flow Rate / O=Volume (at Rate) / G=Volume (over Time) / Q=Volume+Pause / N=Time / P=Time+Pause
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.PumpModeSet (Pump Mode Set): Pump mode succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetTimePauseMode here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.SetTimePauseMode_Responses(
                **default_dict['SetTimePauseMode_Responses']
            )
    
        return return_value
    
    
    def SetVolume(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetVolume_Responses:
        """
        Executes the unobservable command "Set Volume"
            Set the current setting for volume in mL. Volume Type 2.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.Volume (Volume):
            Set the current setting for volume in mL. Volume Type 2.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.VolumeSet (Volume Set): Volume succeeded to Set
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetVolume here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.SetVolume_Responses(
                **default_dict['SetVolume_Responses']
            )
    
        return return_value
    
    
    def GetFlowRate(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetFlowRate_Responses:
        """
        Executes the unobservable command "Get Flow Rate"
            Get current flow rate (mL/min).
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFlowRate (Current Flow Rate): Current flow rate of the channel.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetFlowRate here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.GetFlowRate_Responses(
                **default_dict['GetFlowRate_Responses']
            )
    
        return return_value
    
    
    def GetMode(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetMode_Responses:
        """
        Executes the unobservable command "Get Mode"
            Get the current channel or pump mode
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPumpMode (Current Pump Mode): Current channel or pump mode is retrieved.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetMode here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.GetMode_Responses(
                **default_dict['GetMode_Responses']
            )
    
        return return_value
    
    
    def GetVolume(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetVolume_Responses:
        """
        Executes the unobservable command "Get Volume"
            Get the current setting for volume in mL/min.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVolume (Current Volume): Current setting for volume in mL/min.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetVolume here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.GetVolume_Responses(
                **default_dict['GetVolume_Responses']
            )
    
        return return_value
    
    
    def GetMaximumFlowRate(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetMaximumFlowRate_Responses:
        """
        Executes the unobservable command "Get Maximum Flow Rate"
            Get maximum flow rate achievable with current settings, mL/min.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.MaximumFlowRate (Maximum Flow Rate): Maximum Flow Rate achievable with current settings, mL/min.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetMaximumFlowRate here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.GetMaximumFlowRate_Responses(
                **default_dict['GetMaximumFlowRate_Responses']
            )
    
        return return_value
    
    
    def GetMaximumFlowRateWithCalibration(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetMaximumFlowRateWithCalibration_Responses:
        """
        Executes the unobservable command "Get Maximum Flow Rate using Calibration"
            Get maximum flow rate achievable with current settings using calibration, mL/min.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.MaximumFlowRateWithCalibration (Maximum Flow Rate using Calibration): Maximum Flow Rate achievable with current settings using calibration, mL/min.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetMaximumFlowRateWithCalibration here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.GetMaximumFlowRateWithCalibration_Responses(
                **default_dict['GetMaximumFlowRateWithCalibration_Responses']
            )
    
        return return_value
    
    
    def GetSpeedSettingRPM(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetSpeedSettingRPM_Responses:
        """
        Executes the unobservable command "Get Speed Setting in RPM"
            Get the current speed setting in RPM.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSpeedSetting (Current Speed Setting): The current speed setting in RPM.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetSpeedSettingRPM here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.GetSpeedSettingRPM_Responses(
                **default_dict['GetSpeedSettingRPM_Responses']
            )
    
        return return_value
    
    
    def SetSpeedSettingRPM(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetSpeedSettingRPM_Responses:
        """
        Executes the unobservable command "Set Speed Setting in RPM"
            Set speed setting in RPM (RPM Mode flow rate setting (0.01 RPM) Discrete Type 3).
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.Speed (Speed):
            Speed setting in RPM (RPM Mode flow rate setting (0.01 RPM) Discrete Type 3)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSpeedSetting (Current Speed Setting): RPM Mode flow rate setting.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetSpeedSettingRPM here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.SetSpeedSettingRPM_Responses(
                **default_dict['SetSpeedSettingRPM_Responses']
            )
    
        return return_value
    
    
    def SetCurrentRunTime(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetCurrentRunTime_Responses:
        """
        Executes the unobservable command "Set Current Run Time"
            Set current pump run time using Time Type 2 format (0 to 999h or 0 to 3596400s).
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.RunTime (Run Time):
            Set current pump run time using Time Type 2 format (0 to 999h or 0 to 3596400s).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetCurrentRunTimeSet (Set Current Run Time): Current Run Time succeeded to set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetCurrentRunTime here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.SetCurrentRunTime_Responses(
                **default_dict['SetCurrentRunTime_Responses']
            )
    
        return return_value
    
    
    def GetCurrentRunTime(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetCurrentRunTime_Responses:
        """
        Executes the unobservable command "Get Current Run Time"
            Get current pump run time using Time Type 2 format.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.GetCurrentRunTime (Get Current Run Time): Current Run Time of the pump.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetCurrentRunTime here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.GetCurrentRunTime_Responses(
                **default_dict['GetCurrentRunTime_Responses']
            )
    
        return return_value
    
    
    def SetPumpingPauseTime(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetPumpingPauseTime_Responses:
        """
        Executes the unobservable command "Set Pumping Pause Time"
            Set pumping pause time using Time Type 2 format (0 to 999h or 0 to 3596400s).
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.PumpingPauseTime (Pumping Pause Time):
            Set pumping pause time using Time Type 2 format (0 to 999h or 0 to 3596400s).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetPumpingPauseTimeSet (Set Pumping Pause Time Time): Pumping pause time succeeded to set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetPumpingPauseTime here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.SetPumpingPauseTime_Responses(
                **default_dict['SetPumpingPauseTime_Responses']
            )
    
        return return_value
    
    
    def GetPumpingPauseTime(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetPumpingPauseTime_Responses:
        """
        Executes the unobservable command "Get Pumping Pause Time"
            Get pumping pause time.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPumpingPauseTime (Current Pumping Pause Time): Current Pumping Pause Time.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetPumpingPauseTime here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.GetPumpingPauseTime_Responses(
                **default_dict['GetPumpingPauseTime_Responses']
            )
    
        return return_value
    
    
    def GetCycleCount(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetCycleCount_Responses:
        """
        Executes the unobservable command "Get Cycle Count"
            Get pump cycle count.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCycleCount (Current Cycle Count): Current Cycle Count.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetCycleCount here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.GetCycleCount_Responses(
                **default_dict['GetCycleCount_Responses']
            )
    
        return return_value
    
    
    def SetCycleCount(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetCycleCount_Responses:
        """
        Executes the unobservable command "Set Cycle Count"
            Set pump cycle count (Discrete Type 2).
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.CycleCount (Cycle Count):
            Set pump cycle count
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetCycleCountSet (Set Cycle Count): Cycle Count succeeded to set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetCycleCount here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.SetCycleCount_Responses(
                **default_dict['SetCycleCount_Responses']
            )
    
        return return_value
    
    
    def GetDispenseTimeMlMin(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetDispenseTimeMlMin_Responses:
        """
        Executes the unobservable command "Get Dispense Time at mL/min"
            Get time to dispense at a given volume at a given mL/min flow rate.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.Volume (Volume):
            Gets the volume, which must be dispensed
            request.FlowRate (FlowRate):
            Gets the flow rate, with which the volume must be dispensed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDispenseTime (CurrentDispenseTime): CurrentDispenseTime at a given volume at a given mL/min flow rate.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetDispenseTimeMlMin here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.GetDispenseTimeMlMin_Responses(
                **default_dict['GetDispenseTimeMlMin_Responses']
            )
    
        return return_value
    
    
    def GetDispenseTimeRPM(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetDispenseTimeRPM_Responses:
        """
        Executes the unobservable command "Get Dispense Time at RPM"
            Get time to dispense at a given volume at a given RPM.
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Channel
            request.Volume (Volume):
            Gets the volume, which must be dispensed
            request.FlowRate (FlowRate):
            Gets the flow rate, with which the volume must be dispensed
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDispenseTime (CurrentDispenseTime): CurrentDispenseTime at a given volume at a given RPM.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetDispenseTimeRPM here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.GetDispenseTimeRPM_Responses(
                **default_dict['GetDispenseTimeRPM_Responses']
            )
    
        return return_value
    
    
    def GetFlowRateAtModes(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.GetFlowRateAtModes_Responses:
        """
        Executes the unobservable command "Get Flow Rate when mode is not RPM or Flow Rate"
            Get flow rate from RPM (S) or flow rate (f) when mode is not RPM or Flow Rate.: 0=RPM, 1=Flow Rate
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Channel
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFlowRate (Current Flow Rate): CurrentDispenseTime at a given volume at a given RPM. : 0=RPM, 1=Flow Rate
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetFlowRateAtModes here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.GetFlowRateAtModes_Responses(
                **default_dict['GetFlowRateAtModes_Responses']
            )
    
        return return_value
    
    
    def SetFlowRateAtModes(self, request, context: grpc.ServicerContext) \
            -> ParameterControlServicer_pb2.SetFlowRateAtModes_Responses:
        """
        Executes the unobservable command "Set Flow Rate when mode is not RPM or Flow Rate"
            Set RPM flow rate not in RPM or Flow Rate mode. (Discrete Type 3)
    
        :param request: gRPC request containing the parameters passed:
            request.Channel (Channel):
            Gets the channel, on which the command will be executed
            request.FlowRate (Flow Rate):
            Set RPM flow rate not in RPM or Flow Rate mode.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetFlowRateSet (Set Flow Rate): RPM flow rate not in RPM or Flow Rate mode succeeded to set
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetFlowRateAtModes here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ParameterControlServicer_pb2.SetFlowRateAtModes_Responses(
                **default_dict['SetFlowRateAtModes_Responses']
            )
    
        return return_value
    

    
