#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*RegloICCService client*

:details: RegloICCService:
    This is a RegloICC Service

:file:    RegloICCService_client.py
:authors: Valeryia Sidarava & Lukas Bromig

:date: (creation)          2020-04-16T10:19:58.414441
:date: (last modification) 2020-04-16T10:19:58.414441

.. note:: Code generated by sila2codegenerator 0.2.0

_______________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

# import general packages
import logging
import argparse
import grpc
import time

# import meta packages
from typing import Union, Optional

# import SiLA2 library modules
from sila2lib.framework import SiLAFramework_pb2 as silaFW_pb2
from sila2lib.sila_client import SiLA2Client
from sila2lib.framework.std_features import SiLAService_pb2 as SiLAService_feature_pb2
from sila2lib.error_handling import client_err
#   Usually not needed, but - feel free to modify
# from sila2lib.framework.std_features import SimulationController_pb2 as SimController_feature_pb2

# import feature gRPC modules
# Import gRPC libraries of features
from .CalibrationServicer.gRPC import CalibrationServicer_pb2
from .CalibrationServicer.gRPC import CalibrationServicer_pb2_grpc
# import default arguments for this feature
from .CalibrationServicer.CalibrationServicer_default_arguments import default_dict as CalibrationServicer_default_dict
from .ConfigurationServicer.gRPC import ConfigurationServicer_pb2
from .ConfigurationServicer.gRPC import ConfigurationServicer_pb2_grpc
# import default arguments for this feature
from .ConfigurationServicer.ConfigurationServicer_default_arguments import default_dict as ConfigurationServicer_default_dict
from .DeviceServicer.gRPC import DeviceServicer_pb2
from .DeviceServicer.gRPC import DeviceServicer_pb2_grpc
# import default arguments for this feature
from .DeviceServicer.DeviceServicer_default_arguments import default_dict as DeviceServicer_default_dict
from .DriveControlServicer.gRPC import DriveControlServicer_pb2
from .DriveControlServicer.gRPC import DriveControlServicer_pb2_grpc
# import default arguments for this feature
from .DriveControlServicer.DriveControlServicer_default_arguments import default_dict as DriveControlServicer_default_dict
from .ParameterControlServicer.gRPC import ParameterControlServicer_pb2
from .ParameterControlServicer.gRPC import ParameterControlServicer_pb2_grpc
# import default arguments for this feature
from .ParameterControlServicer.ParameterControlServicer_default_arguments import default_dict as ParameterControlServicer_default_dict


# noinspection PyPep8Naming, PyUnusedLocal
class RegloICCServiceClient(SiLA2Client):
    """
        This is a RegloICC Service

    .. note:: For an example on how to construct the parameter or read the response(s) for command calls and properties,
              compare the default dictionary that is stored in the directory of the corresponding feature.
    """
    # The following variables will be filled when run() is executed
    #: Storage for the connected servers version
    server_version: str = ''
    #: Storage for the display name of the connected server
    server_display_name: str = ''
    #: Storage for the description of the connected server
    server_description: str = ''

    def __init__(
            self,
            name="PumpServiceClient", description: str = "This is a RegloICC Service",
            server_name: Optional[str] = None,
            client_uuid: Optional[str] = None,
            version: str = __version__,
            vendor_url: str = "Lukas.bromig@tum.de, valeryia.sidarava@tum.de",
            server_hostname: str = "localhost", server_ip: str = "127.0.0.1", server_port: int = 50001,
            cert_file: Optional[str] = None):
        """Class initializer"""
        super().__init__(
            name=name, description=description,
            server_name=server_name,
            client_uuid=client_uuid,
            version=version,
            vendor_url=vendor_url,
            server_hostname=server_hostname, server_ip=server_ip, server_port=server_port,
            cert_file=cert_file
        )

        logging.info(
            "Starting SiLA2 service client for service RegloICCService with service name: {server_name}".format(
                server_name=name
            )
        )

        # Create stub objects used to communicate with the server
        self.CalibrationServicer_stub = \
            CalibrationServicer_pb2_grpc.CalibrationServicerStub(self.channel)
        self.ConfigurationServicer_stub = \
            ConfigurationServicer_pb2_grpc.ConfigurationServicerStub(self.channel)
        self.DeviceServicer_stub = \
            DeviceServicer_pb2_grpc.DeviceServicerStub(self.channel)
        self.DriveControlServicer_stub = \
            DriveControlServicer_pb2_grpc.DriveControlServicerStub(self.channel)
        self.ParameterControlServicer_stub = \
            ParameterControlServicer_pb2_grpc.ParameterControlServicerStub(self.channel)

        # initialise class variables for server information storage
        self.server_version = ''
        self.server_display_name = ''
        self.server_description = ''

    def Get_ImplementedFeatures(self):
        """Get a list of all implemented features."""
        # type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Retrieving the list of implemented features of the server:")
        try:
            response = self.SiLAService_stub.Get_ImplementedFeatures(
                SiLAService_feature_pb2.Get_ImplementedFeatures_Parameters()
            )
            for feature_id in response.ImplementedFeatures:
                logging.debug("Implemented feature: {feature_id}".format(
                    # feature_id=feature_id.FeatureIdentifier.value)
                    feature_id=feature_id.value)
                    )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

        return response.ImplementedFeatures

    def Get_FeatureDefinition(self, feature_identifier: str) -> Union[str, None]:
        """
        Returns the FDL/XML feature definition of the given feature.

        :param feature_identifier: The name of the feature for which the definition should be returned.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Requesting feature definitions of feature {feature_identifier}:".format(
            feature_identifier=feature_identifier)
        )
        try:
            response = self.SiLAService_stub.GetFeatureDefinition(
                SiLAService_feature_pb2.GetFeatureDefinition_Parameters(
                    QualifiedFeatureIdentifier=SiLAService_feature_pb2.DataType_FeatureIdentifier(
                        FeatureIdentifier=silaFW_pb2.String(value=feature_identifier)
                    )
                )
            )
            logging.debug("Response of GetFeatureDefinition for {feature_identifier} feature: {response}".format(
                response=response,
                feature_identifier=feature_identifier)
            )
            return response
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

    def run(self) -> bool:
        """
        Starts the actual client and retrieves the meta-information from the server.

        :returns: True or False whether the connection to the server is established.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        try:
            # Retrieve the basic server information and store it in internal class variables
            #   Display name
            response = self.SiLAService_stub.Get_ServerName(SiLAService_feature_pb2.Get_ServerName_Parameters())
            self.server_display_name = response.ServerName.value
            logging.debug("Display name: {name}".format(name=response.ServerName.value))
            # Server description
            response = self.SiLAService_stub.Get_ServerDescription(
                SiLAService_feature_pb2.Get_ServerDescription_Parameters()
            )
            self.server_description = response.ServerDescription.value
            logging.debug("Description: {description}".format(description=response.ServerDescription.value))
            # Server version
            response = self.SiLAService_stub.Get_ServerVersion(SiLAService_feature_pb2.Get_ServerVersion_Parameters())
            self.server_version = response.ServerVersion.value
            logging.debug("Version: {version}".format(version=response.ServerVersion.value))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return False

        return True

    def stop(self, force: bool = False) -> bool:
        """
        Stop SiLA client routine

        :param force: If set True, the client is supposed to disconnect and stop immediately. Otherwise it can first try
                      to finish what it is doing.

        :returns: Whether the client could be stopped successfully or not.
        """
        # TODO: Implement all routines that have to be executed when the client is stopped.
        #   Feel free to use the "force" parameter to abort any running processes. Or crash your machine. Your call!
        return True

    def CalibrationServicer_StartCalibration(self, channel) \
            -> CalibrationServicer_pb2.StartCalibration_Responses:
        """
        Wrapper to call the unobservable command StartCalibration on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling StartCalibration:")

        default_dict = {
            'Calibrate': silaFW_pb2.String(value=channel)}
        try:
            parameter = CalibrationServicer_pb2.StartCalibration_Parameters(**default_dict)
            if parameter is None:
                parameter = CalibrationServicer_pb2.StartCalibration_Parameters(
                    **CalibrationServicer_default_dict['StartCalibration_Parameters']
                )
    
            response = self.CalibrationServicer_stub.StartCalibration(parameter)
    
            logging.debug('StartCalibration response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def CalibrationServicer_CancelCalibration(self, channel) \
            -> CalibrationServicer_pb2.CancelCalibration_Responses:
        """
        Wrapper to call the unobservable command CancelCalibration on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling CancelCalibration:")

        default_dict = {
            'Calibrate': silaFW_pb2.String(value=channel)}
        try:
            parameter = CalibrationServicer_pb2.CancelCalibration_Parameters(**default_dict)
            if parameter is None:
                parameter = CalibrationServicer_pb2.CancelCalibration_Parameters(
                    **CalibrationServicer_default_dict['CancelCalibration_Parameters']
                )
    
            response = self.CalibrationServicer_stub.CancelCalibration(parameter)
    
            logging.debug('CancelCalibration response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def CalibrationServicer_SetTargetVolume(self, channel, volume) \
            -> CalibrationServicer_pb2.SetTargetVolume_Responses:
        """
        Wrapper to call the unobservable command SetTargetVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetTargetVolume:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel),
            'TargetVolume': silaFW_pb2.Real(value=volume)}
        try:
            parameter = CalibrationServicer_pb2.SetTargetVolume_Parameters(**default_dict)
            if parameter is None:
                parameter = CalibrationServicer_pb2.SetTargetVolume_Parameters(
                    **CalibrationServicer_default_dict['SetTargetVolume_Parameters']
                )
    
            response = self.CalibrationServicer_stub.SetTargetVolume(parameter)
    
            logging.debug('SetTargetVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def CalibrationServicer_SetActualVolume(self, channel, volume) \
            -> CalibrationServicer_pb2.SetActualVolume_Responses:
        """
        Wrapper to call the unobservable command SetActualVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActualVolume:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel),
            'ActualVolume': silaFW_pb2.Real(value=volume)
        }
        try:
            parameter = CalibrationServicer_pb2.SetActualVolume_Parameters(**default_dict)
            if parameter is None:
                parameter = CalibrationServicer_pb2.SetActualVolume_Parameters(
                    **CalibrationServicer_default_dict['SetActualVolume_Parameters']
                )
    
            response = self.CalibrationServicer_stub.SetActualVolume(parameter)
    
            logging.debug('SetActualVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def CalibrationServicer_GetTargetVolume(self, input) \
            -> CalibrationServicer_pb2.GetTargetVolume_Responses:
        """
        Wrapper to call the unobservable command GetTargetVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetTargetVolume:")

        default_dict = {
            'TargetVolume': silaFW_pb2.Real(value=input)}
        try:
            parameter = CalibrationServicer_pb2.GetTargetVolume_Parameters(**default_dict)
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetTargetVolume_Parameters(
                    **CalibrationServicer_default_dict['GetTargetVolume_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetTargetVolume(parameter)
    
            logging.debug('GetTargetVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def CalibrationServicer_SetDirectionCalibration(self, channel, direction) \
            -> CalibrationServicer_pb2.SetDirectionCalibration_Responses:
        """
        Wrapper to call the unobservable command SetDirectionCalibration on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDirectionCalibration:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel),
            'Direction': silaFW_pb2.String(value=direction)
        }
        try:
            parameter = CalibrationServicer_pb2.SetDirectionCalibration_Parameters(**default_dict)
            if parameter is None:
                parameter = CalibrationServicer_pb2.SetDirectionCalibration_Parameters(
                    **CalibrationServicer_default_dict['SetDirectionCalibration_Parameters']
                )
    
            response = self.CalibrationServicer_stub.SetDirectionCalibration(parameter)
    
            logging.debug('SetDirectionCalibration response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def CalibrationServicer_GetDirectionCalibration(self,channel) \
            -> CalibrationServicer_pb2.GetDirectionCalibration_Responses:
        """
        Wrapper to call the unobservable command GetDirectionCalibration on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetDirectionCalibration:")

        default_dict = {
            'Direction': silaFW_pb2.String(value=str(channel))}
        try:
            parameter = CalibrationServicer_pb2.GetDirectionCalibration_Parameters(**default_dict)
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetDirectionCalibration_Parameters(
                    **CalibrationServicer_default_dict['GetDirectionCalibration_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetDirectionCalibration(parameter)
    
            logging.debug('GetDirectionCalibration response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def CalibrationServicer_SetCalibrationTime(self, channel, time) \
            -> CalibrationServicer_pb2.SetCalibrationTime_Responses:
        """
        Wrapper to call the unobservable command SetCalibrationTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCalibrationTime:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel),
            'Time': silaFW_pb2.Integer(value=time)
        }
        try:
            parameter = CalibrationServicer_pb2.SetCalibrationTime_Parameters(**default_dict)
            if parameter is None:
                parameter = CalibrationServicer_pb2.SetCalibrationTime_Parameters(
                    **CalibrationServicer_default_dict['SetCalibrationTime_Parameters']
                )
    
            response = self.CalibrationServicer_stub.SetCalibrationTime(parameter)
    
            logging.debug('SetCalibrationTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def CalibrationServicer_GetCalibrationTime(self, channel) \
            -> CalibrationServicer_pb2.GetCalibrationTime_Responses:
        """
        Wrapper to call the unobservable command GetCalibrationTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCalibrationTime:")

        default_dict = {
            'Time': silaFW_pb2.Integer(value=int(channel))}
        try:
            parameter = CalibrationServicer_pb2.GetCalibrationTime_Parameters(**default_dict)
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetCalibrationTime_Parameters(
                    **CalibrationServicer_default_dict['GetCalibrationTime_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetCalibrationTime(parameter)
    
            logging.debug('GetCalibrationTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def CalibrationServicer_GetRunTimeCalibration(self,channel) \
            -> CalibrationServicer_pb2.GetRunTimeCalibration_Responses:
        """
        Wrapper to call the unobservable command GetRunTimeCalibration on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetRunTimeCalibration:")

        default_dict = {
            'Time': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = CalibrationServicer_pb2.GetRunTimeCalibration_Parameters(**default_dict)
            if parameter is None:
                parameter = CalibrationServicer_pb2.GetRunTimeCalibration_Parameters(
                    **CalibrationServicer_default_dict['GetRunTimeCalibration_Parameters']
                )
    
            response = self.CalibrationServicer_stub.GetRunTimeCalibration(parameter)
    
            logging.debug('GetRunTimeCalibration response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ConfigurationServicer_SetTubingDiameter(self,channel, diameter) \
            -> ConfigurationServicer_pb2.SetTubingDiameter_Responses:
        """
        Wrapper to call the unobservable command SetTubingDiameter on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetTubingDiameter:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel),
            'TubingDiameter': silaFW_pb2.Real(value=diameter)
                    }
        try:
            parameter = ConfigurationServicer_pb2.SetTubingDiameter_Parameters(**default_dict)
            if parameter is None:
                parameter = ConfigurationServicer_pb2.SetTubingDiameter_Parameters(
                    **ConfigurationServicer_default_dict['SetTubingDiameter_Parameters']
                )
    
            response = self.ConfigurationServicer_stub.SetTubingDiameter(parameter)
    
            logging.debug('SetTubingDiameter response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ConfigurationServicer_ResetToDefault(self, channel) \
            -> ConfigurationServicer_pb2.ResetToDefault_Responses:
        """
        Wrapper to call the unobservable command ResetToDefault on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling ResetToDefault:")

        default_dict = {
            'Reset': silaFW_pb2.String(value=channel)}
        try:
            parameter = ConfigurationServicer_pb2.ResetToDefault_Parameters(**default_dict)
            if parameter is None:
                parameter = ConfigurationServicer_pb2.ResetToDefault_Parameters(
                    **ConfigurationServicer_default_dict['ResetToDefault_Parameters']
                )
    
            response = self.ConfigurationServicer_stub.ResetToDefault(parameter)
    
            logging.debug('ResetToDefault response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ConfigurationServicer_GetTubingDiameter(self, input) \
            -> ConfigurationServicer_pb2.GetTubingDiameter_Responses:
        """
        Wrapper to call the unobservable command GetTubingDiameter on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetTubingDiameter:")

        default_dict = {
            'CurrentTubingDiameter': silaFW_pb2.Real(value=input)}
        try:
            parameter = ConfigurationServicer_pb2.GetTubingDiameter_Parameters(**default_dict)
            if parameter is None:
                parameter = ConfigurationServicer_pb2.GetTubingDiameter_Parameters(
                    **ConfigurationServicer_default_dict['GetTubingDiameter_Parameters']
                )
    
            response = self.ConfigurationServicer_stub.GetTubingDiameter(parameter)
    
            logging.debug('GetTubingDiameter response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ConfigurationServicer_SetBacksteps(self, channel, steps) \
            -> ConfigurationServicer_pb2.SetBacksteps_Responses:
        """
        Wrapper to call the unobservable command SetBacksteps on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetBacksteps:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel),
            'BackstepsSetting': silaFW_pb2.String(value=steps)
                                }
        try:
            parameter = ConfigurationServicer_pb2.SetBacksteps_Parameters(**default_dict)
            if parameter is None:
                parameter = ConfigurationServicer_pb2.SetBacksteps_Parameters(
                    **ConfigurationServicer_default_dict['SetBacksteps_Parameters']
                )
    
            response = self.ConfigurationServicer_stub.SetBacksteps(parameter)
    
            logging.debug('SetBacksteps response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ConfigurationServicer_GetBacksteps(self, channel) \
            -> ConfigurationServicer_pb2.GetBacksteps_Responses:
        """
        Wrapper to call the unobservable command GetBacksteps on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetBacksteps:")

        default_dict = {
            'BackstepsSetting': silaFW_pb2.String(value=str(channel))}

        try:
            parameter = ConfigurationServicer_pb2.GetBacksteps_Parameters(**default_dict)
            if parameter is None:
                parameter = ConfigurationServicer_pb2.GetBacksteps_Parameters(
                    **ConfigurationServicer_default_dict['GetBacksteps_Parameters']
                )
    
            response = self.ConfigurationServicer_stub.GetBacksteps(parameter)
    
            logging.debug('GetBacksteps response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetLog(self,
                      parameter: DeviceServicer_pb2.GetLog_Parameters = None) \
            -> silaFW_pb2.CommandConfirmation:
        """
        Wrapper to call the observable command GetLog on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A command confirmation object with the following information:
            commandExecutionUUID: A command id with which this observable command can be referenced in future calls
            lifetimeOfExecution (optional): The (maximum) lifetime of this command call.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetLog:")

        default_dict = {}

        try:
            parameter = ConfigurationServicer_pb2.GetBacksteps_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetLog_Parameters(
                    **DeviceServicer_default_dict['GetLog_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetLog(parameter)
    
            logging.debug('GetLog response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetLog_Info(self,
                           uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) \
            -> silaFW_pb2.ExecutionInfo:
        """
        Wrapper to get an intermediate response for the observable command GetLog on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the status information that has been defined for this command. The following fields
                  are defined:
                    * *commandStatus*: Status of the command (enumeration)
                    * *progressInfo*: Information on the progress of the command (0 to 1)
                    * *estimatedRemainingTime*: Estimate of the remaining time required to run the command
                    * *updatedLifetimeOfExecution*: An update on the execution lifetime
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        logging.debug(
            "Requesting status information for command GetLog (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
        try:
            response = self.DeviceServicer_stub.GetLog_Info(uuid)
            logging.debug('GetLog status information: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetLog_Result(self,
                             uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) \
            -> DeviceServicer_pb2.GetLog_Responses:
        """
        Wrapper to get an intermediate response for the observable command GetLog on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the result response that has been defined for this command.
    
        .. note:: Whether the result is available or not can and should be evaluated by calling the
                  :meth:`GetLog_Info` method of this call.
        """
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        logging.debug(
            "Requesting status information for command GetLog (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
    
        try:
            response = self.DeviceServicer_stub.GetLog_Result(uuid)
            logging.debug('GetLog result response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_SetPumpAddress(self, address) \
            -> DeviceServicer_pb2.SetPumpAddress_Responses:
        """
        Wrapper to call the unobservable command SetPumpAddress on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetPumpAddress:")

        default_dict = {
            'Address': silaFW_pb2.Integer(value=address) }
        try:
            parameter = DeviceServicer_pb2.SetPumpAddress_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetPumpAddress_Parameters(
                    **DeviceServicer_default_dict['SetPumpAddress_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetPumpAddress(parameter)
    
            logging.debug('SetPumpAddress response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetLanguage(self, address, language) \
            -> DeviceServicer_pb2.SetLanguage_Responses:
        """
        Wrapper to call the unobservable command SetLanguage on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetLanguage:")

        default_dict = {
            'Address': silaFW_pb2.Integer(value=address),
            'Language': silaFW_pb2.Integer(value=language)
                        }
        try:
            parameter = DeviceServicer_pb2.SetLanguage_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetLanguage_Parameters(
                    **DeviceServicer_default_dict['SetLanguage_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetLanguage(parameter)
    
            logging.debug('SetLanguage response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetLanguage(self, address) \
            -> DeviceServicer_pb2.GetLanguage_Responses:
        """
        Wrapper to call the unobservable command GetLanguage on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetLanguage:")

        default_dict = {
            'Address': silaFW_pb2.Integer(value=address)}
        try:
            parameter = DeviceServicer_pb2.GetLanguage_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetLanguage_Parameters(
                    **DeviceServicer_default_dict['GetLanguage_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetLanguage(parameter)
    
            logging.debug('GetLanguage response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetPumpStatus(self, address) \
            -> DeviceServicer_pb2.GetPumpStatus_Responses:
        """
        Wrapper to call the unobservable command GetPumpStatus on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPumpStatus:")

        default_dict = {
            'Address': silaFW_pb2.Integer(value=address)}
        try:
            parameter = DeviceServicer_pb2.GetPumpStatus_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetPumpStatus_Parameters(
                    **DeviceServicer_default_dict['GetPumpStatus_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetPumpStatus(parameter)
    
            logging.debug('GetPumpStatus response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetVersionType(self, address) \
            -> DeviceServicer_pb2.GetVersionType_Responses:
        """
        Wrapper to call the unobservable command GetVersionType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersionType:")

        default_dict = {
            'Address': silaFW_pb2.Integer(value=address)}
        try:
            parameter = DeviceServicer_pb2.GetVersionType_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetVersionType_Parameters(
                    **DeviceServicer_default_dict['GetVersionType_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetVersionType(parameter)
    
            logging.debug('GetVersionType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_CurrentVersionSoftware(self, address) \
            -> DeviceServicer_pb2.CurrentVersionSoftware_Responses:
        """
        Wrapper to call the unobservable command CurrentVersionSoftware on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling CurrentVersionSoftware:")

        default_dict = {
            'Address': silaFW_pb2.Integer(value=address)}
        try:
            parameter = DeviceServicer_pb2.CurrentVersionSoftware_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.CurrentVersionSoftware_Parameters(
                    **DeviceServicer_default_dict['CurrentVersionSoftware_Parameters']
                )
    
            response = self.DeviceServicer_stub.CurrentVersionSoftware(parameter)
    
            logging.debug('CurrentVersionSoftware response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetSerialNumber(self, address) \
            -> DeviceServicer_pb2.GetSerialNumber_Responses:
        """
        Wrapper to call the unobservable command GetSerialNumber on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSerialNumber:")

        default_dict = {
            'Address': silaFW_pb2.Integer(value=address)}
        try:
            parameter = DeviceServicer_pb2.GetSerialNumber_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetSerialNumber_Parameters(
                    **DeviceServicer_default_dict['GetSerialNumber_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetSerialNumber(parameter)
    
            logging.debug('GetSerialNumber response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetChannelAddressing(self,address, value) \
            -> DeviceServicer_pb2.SetChannelAddressing_Responses:
        """
        Wrapper to call the unobservable command SetChannelAddressing on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetChannelAddressing:")

        def_dict= {
            'Address': silaFW_pb2.Integer(value=address),
            'ChannelAddressing': silaFW_pb2.Boolean(value=value)
            }

        try:
            parameter = DeviceServicer_pb2.SetChannelAddressing_Parameters(**def_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetChannelAddressing_Parameters(
                    **DeviceServicer_default_dict['SetChannelAddressing_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetChannelAddressing(parameter)
    
            logging.debug('SetChannelAddressing response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetChannelAddressing(self, address) \
            -> DeviceServicer_pb2.GetChannelAddressing_Responses:
        """
        Wrapper to call the unobservable command GetChannelAddressing on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetChannelAddressing:")

        default_dict = {
            'Address': silaFW_pb2.Integer(value=address)}
        try:
            parameter = DeviceServicer_pb2.GetChannelAddressing_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetChannelAddressing_Parameters(
                    **DeviceServicer_default_dict['GetChannelAddressing_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetChannelAddressing(parameter)
    
            logging.debug('GetChannelAddressing response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetEventMessages(self, address, value) \
            -> DeviceServicer_pb2.SetEventMessages_Responses:
        """
        Wrapper to call the unobservable command SetEventMessages on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetEventMessages:")

        default_dict= {
            'Address': silaFW_pb2.Integer(value=address),
            'EventMessages': silaFW_pb2.Boolean(value=value)
                        }
        try:
            parameter = DeviceServicer_pb2.SetEventMessages_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetEventMessages_Parameters(
                    **DeviceServicer_default_dict['SetEventMessages_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetEventMessages(parameter)
    
            logging.debug('SetEventMessages response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetEventMessages(self, address) \
            -> DeviceServicer_pb2.GetEventMessages_Responses:
        """
        Wrapper to call the unobservable command GetEventMessages on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetEventMessages:")

        default_dict = {
            'Address': silaFW_pb2.Integer(value=address)}
        try:
            parameter = DeviceServicer_pb2.GetEventMessages_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetEventMessages_Parameters(
                    **DeviceServicer_default_dict['GetEventMessages_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetEventMessages(parameter)
    
            logging.debug('GetEventMessages response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetSerialProtocol(self, address) \
            -> DeviceServicer_pb2.GetSerialProtocol_Responses:
        """
        Wrapper to call the unobservable command GetSerialProtocol on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSerialProtocol:")

        default_dict = {
            'Address': silaFW_pb2.Integer(value=address)}
        try:
            parameter = DeviceServicer_pb2.GetSerialProtocol_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetSerialProtocol_Parameters(
                    **DeviceServicer_default_dict['GetSerialProtocol_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetSerialProtocol(parameter)
    
            logging.debug('GetSerialProtocol response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetPumpName(self, address, name) \
            -> DeviceServicer_pb2.SetPumpName_Responses:
        """
        Wrapper to call the unobservable command SetPumpName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetPumpName:")

        default_dict = {
            'Address': silaFW_pb2.Integer(value=address),
            'PumpName': silaFW_pb2.String(value=name)
        }
        try:
            parameter = DeviceServicer_pb2.SetPumpName_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetPumpName_Parameters(
                    **DeviceServicer_default_dict['SetPumpName_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetPumpName(parameter)
    
            logging.debug('SetPumpName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetChannelNumber(self, address) \
            -> DeviceServicer_pb2.GetChannelNumber_Responses:
        """
        Wrapper to call the unobservable command GetChannelNumber on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetChannelNumber:")

        default_dict = {
            'Address': silaFW_pb2.Integer(value=address)}
        try:
            parameter = DeviceServicer_pb2.GetChannelNumber_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetChannelNumber_Parameters(
                    **DeviceServicer_default_dict['GetChannelNumber_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetChannelNumber(parameter)
    
            logging.debug('GetChannelNumber response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetChannelNumber(self, address, value) \
            -> DeviceServicer_pb2.SetChannelNumber_Responses:
        """
        Wrapper to call the unobservable command SetChannelNumber on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetChannelNumber:")

        default_dict = {
            'Address': silaFW_pb2.Integer(value=address),
            'ChannelNumber': silaFW_pb2.Integer(value=value)
        }
        try:
            parameter = DeviceServicer_pb2.SetChannelNumber_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetChannelNumber_Parameters(
                    **DeviceServicer_default_dict['SetChannelNumber_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetChannelNumber(parameter)
    
            logging.debug('SetChannelNumber response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetRevolutions(self,channel) \
            -> DeviceServicer_pb2.GetRevolutions_Responses:
        """
        Wrapper to call the unobservable command GetRevolutions on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetRevolutions:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = DeviceServicer_pb2.GetRevolutions_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetRevolutions_Parameters(
                    **DeviceServicer_default_dict['GetRevolutions_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetRevolutions(parameter)
    
            logging.debug('GetRevolutions response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetChannelTotalVolume(self, input) \
            -> DeviceServicer_pb2.GetChannelTotalVolume_Responses:
        """
        Wrapper to call the unobservable command GetChannelTotalVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetChannelTotalVolume:")

        default_dict = {
            'Channel': silaFW_pb2.Real(value=input)}
        try:
            parameter = DeviceServicer_pb2.GetChannelTotalVolume_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetChannelTotalVolume_Parameters(
                    **DeviceServicer_default_dict['GetChannelTotalVolume_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetChannelTotalVolume(parameter)
    
            logging.debug('GetChannelTotalVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetTotalTime(self, channel) \
            -> DeviceServicer_pb2.GetTotalTime_Responses:
        """
        Wrapper to call the unobservable command GetTotalTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetTotalTime:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = DeviceServicer_pb2.GetTotalTime_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetTotalTime_Parameters(
                    **DeviceServicer_default_dict['GetTotalTime_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetTotalTime(parameter)
    
            logging.debug('GetTotalTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetHeadModel(self, address) \
            -> DeviceServicer_pb2.GetHeadModel_Responses:
        """
        Wrapper to call the unobservable command GetHeadModel on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetHeadModel:")

        default_dict = {
            'Address': silaFW_pb2.Integer(value=address)}
        try:
            parameter = DeviceServicer_pb2.GetHeadModel_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetHeadModel_Parameters(
                    **DeviceServicer_default_dict['GetHeadModel_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetHeadModel(parameter)
    
            logging.debug('GetHeadModel response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetHeadModel(self, address, value) \
            -> DeviceServicer_pb2.SetHeadModel_Responses:
        """
        Wrapper to call the unobservable command SetHeadModel on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetHeadModel:")

        default_dict = {
            'Address': silaFW_pb2.Integer(value=address),
            'HeadModel': silaFW_pb2.String(value=value)
                        }
        try:
            parameter = DeviceServicer_pb2.SetHeadModel_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetHeadModel_Parameters(
                    **DeviceServicer_default_dict['SetHeadModel_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetHeadModel(parameter)
    
            logging.debug('SetHeadModel response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetUserInterface(self, address) \
            -> DeviceServicer_pb2.SetUserInterface_Responses:
        """
        Wrapper to call the unobservable command SetUserInterface on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetUserInterface:")

        default_dict= {
            'UserInterface': silaFW_pb2.String(value=address)}

        try:
            parameter = DeviceServicer_pb2.SetUserInterface_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetUserInterface_Parameters(
                    **DeviceServicer_default_dict['SetUserInterface_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetUserInterface(parameter)
    
            logging.debug('SetUserInterface response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetDisableInterface(self,address) \
            -> DeviceServicer_pb2.SetDisableInterface_Responses:
        """
        Wrapper to call the unobservable command SetDisableInterface on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDisableInterface:")

        default_dict = {
            'DisableInterface': silaFW_pb2.String(value=address)}
        try:
            parameter = DeviceServicer_pb2.SetDisableInterface_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetDisableInterface_Parameters(
                    **DeviceServicer_default_dict['SetDisableInterface_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetDisableInterface(parameter)
    
            logging.debug('SetDisableInterface response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetDisplayNumbers(self,address, value) \
            -> DeviceServicer_pb2.SetDisplayNumbers_Responses:
        """
        Wrapper to call the unobservable command SetDisplayNumbers on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDisplayNumbers:")

        default_dict= {
            'Address': silaFW_pb2.String(value=address),
            'DisplayNumbers': silaFW_pb2.String(value=value)  }
        try:
            parameter = DeviceServicer_pb2.SetDisplayNumbers_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetDisplayNumbers_Parameters(
                    **DeviceServicer_default_dict['SetDisplayNumbers_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetDisplayNumbers(parameter)
    
            logging.debug('SetDisplayNumbers response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetDisplayLetters(self, address, value) \
            -> DeviceServicer_pb2.SetDisplayLetters_Responses:
        """
        Wrapper to call the unobservable command SetDisplayLetters on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDisplayLetters:")

        default_dict = {
            'Address': silaFW_pb2.String(value=address),
            'DisplayLetters': silaFW_pb2.String(value=value)    }
        try:
            parameter = DeviceServicer_pb2.SetDisplayLetters_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetDisplayLetters_Parameters(
                    **DeviceServicer_default_dict['SetDisplayLetters_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetDisplayLetters(parameter)
    
            logging.debug('SetDisplayLetters response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetTimeSetting(self, channel) \
            -> DeviceServicer_pb2.GetTimeSetting_Responses:
        """
        Wrapper to call the unobservable command GetTimeSetting on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetTimeSetting:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = DeviceServicer_pb2.GetTimeSetting_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetTimeSetting_Parameters(
                    **DeviceServicer_default_dict['GetTimeSetting_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetTimeSetting(parameter)
    
            logging.debug('GetTimeSetting response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetTimeSetting(self, channel, value) \
            -> DeviceServicer_pb2.SetTimeSetting_Responses:
        """
        Wrapper to call the unobservable command SetTimeSetting on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetTimeSetting:")

        default_dict = {
            'Channel': silaFW_pb2.String(value=channel),
            'TimeSetting': silaFW_pb2.String(value=value)
                        }
        try:
            parameter = DeviceServicer_pb2.SetTimeSetting_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetTimeSetting_Parameters(
                    **DeviceServicer_default_dict['SetTimeSetting_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetTimeSetting(parameter)
    
            logging.debug('SetTimeSetting response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetRunTimeM(self, channel, value) \
            -> DeviceServicer_pb2.SetRunTimeM_Responses:
        """
        Wrapper to call the unobservable command SetRunTimeM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetRunTimeM:")

        default_dict = {
            'Channel': silaFW_pb2.String(value=channel),
            'RunTimeM': silaFW_pb2.String(value=value)
        }
        try:
            parameter = DeviceServicer_pb2.SetRunTimeM_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetRunTimeM_Parameters(
                    **DeviceServicer_default_dict['SetRunTimeM_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetRunTimeM(parameter)
    
            logging.debug('SetRunTimeM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetRunTimeH(self,channel, value) \
            -> DeviceServicer_pb2.SetRunTimeH_Responses:
        """
        Wrapper to call the unobservable command SetRunTimeH on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetRunTimeH:")

        default_dict = {
            'Channel': silaFW_pb2.String(value=channel),
            'RunTimeM': silaFW_pb2.String(value=value)
        }
        try:
            parameter = DeviceServicer_pb2.SetRunTimeH_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetRunTimeH_Parameters(
                    **DeviceServicer_default_dict['SetRunTimeH_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetRunTimeH(parameter)
    
            logging.debug('SetRunTimeH response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetRollerStepsLow(self,channel) \
            -> DeviceServicer_pb2.GetRollerStepsLow_Responses:
        """
        Wrapper to call the unobservable command GetRollerStepsLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetRollerStepsLow:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = DeviceServicer_pb2.GetRollerStepsLow_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetRollerStepsLow_Parameters(
                    **DeviceServicer_default_dict['GetRollerStepsLow_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetRollerStepsLow(parameter)
    
            logging.debug('GetRollerStepsLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetRollerStepsLow(self,channel, value) \
            -> DeviceServicer_pb2.SetRollerStepsLow_Responses:
        """
        Wrapper to call the unobservable command SetRollerStepsLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetRollerStepsLow:")

        default_dict= {
            'Channel': silaFW_pb2.String(value=channel),
            'RollerStepsLow': silaFW_pb2.String(value=value)
                        }
        try:
            parameter = DeviceServicer_pb2.SetRollerStepsLow_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetRollerStepsLow_Parameters(
                    **DeviceServicer_default_dict['SetRollerStepsLow_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetRollerStepsLow(parameter)
    
            logging.debug('SetRollerStepsLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetRollerStepsHigh(self,channel) \
            -> DeviceServicer_pb2.GetRollerStepsHigh_Responses:
        """
        Wrapper to call the unobservable command GetRollerStepsHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetRollerStepsHigh:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = DeviceServicer_pb2.GetRollerStepsHigh_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetRollerStepsHigh_Parameters(
                    **DeviceServicer_default_dict['GetRollerStepsHigh_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetRollerStepsHigh(parameter)
    
            logging.debug('GetRollerStepsHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetRollerStepsHigh(self,channel, value) \
            -> DeviceServicer_pb2.SetRollerStepsHigh_Responses:
        """
        Wrapper to call the unobservable command SetRollerStepsHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetRollerStepsHigh:")

        default_dict= {
            'Channel': silaFW_pb2.String(value=channel),
            'RollerSteps': silaFW_pb2.String(value=value)
                        }
        try:
            parameter = DeviceServicer_pb2.SetRollerStepsHigh_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetRollerStepsHigh_Parameters(
                    **DeviceServicer_default_dict['SetRollerStepsHigh_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetRollerStepsHigh(parameter)
    
            logging.debug('SetRollerStepsHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetRSV(self,channel) \
            -> DeviceServicer_pb2.GetRSV_Responses:
        """
        Wrapper to call the unobservable command GetRSV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetRSV:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = DeviceServicer_pb2.GetRSV_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetRSV_Parameters(
                    **DeviceServicer_default_dict['GetRSV_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetRSV(parameter)
    
            logging.debug('GetRSV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetRSV(self, channel, value) \
            -> DeviceServicer_pb2.SetRSV_Responses:
        """
        Wrapper to call the unobservable command SetRSV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetRSV:")

        default_dict = {
            'Channel': silaFW_pb2.String(value=channel),
            'RSV': silaFW_pb2.String(value=value)
                        }
        try:
            parameter = DeviceServicer_pb2.SetRSV_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetRSV_Parameters(
                    **DeviceServicer_default_dict['SetRSV_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetRSV(parameter)
    
            logging.debug('SetRSV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetRSVReset(self, address) \
            -> DeviceServicer_pb2.SetRSVReset_Responses:
        """
        Wrapper to call the unobservable command SetRSVReset on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetRSVReset:")

        default_dict = {
            'RSVReset': silaFW_pb2.String(value=address)    }
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.SetRSVReset_Parameters(
                    **DeviceServicer_default_dict['SetRSVReset_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetRSVReset(parameter)
    
            logging.debug('SetRSVReset response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_ResetRSVTable(self,address) \
            -> DeviceServicer_pb2.ResetRSVTable_Responses:
        """
        Wrapper to call the unobservable command ResetRSVTable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling ResetRSVTable:")

        default_dict = {
            'RSVTableReset': silaFW_pb2.String(value=address)    }
        try:
            parameter = DeviceServicer_pb2.ResetRSVTable_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.ResetRSVTable_Parameters(
                    **DeviceServicer_default_dict['ResetRSVTable_Parameters']
                )
    
            response = self.DeviceServicer_stub.ResetRSVTable(parameter)
    
            logging.debug('ResetRSVTable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetNonFactoryRSV(self, address,rollers,tubing, volume) \
            -> DeviceServicer_pb2.SetNonFactoryRSV_Responses:
        """
        Wrapper to call the unobservable command SetNonFactoryRSV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetNonFactoryRSV:")

        default_dict = {
            'Channel': silaFW_pb2.String(value=address),
            'RollerCount': silaFW_pb2.String(value=rollers),
            'TubingID': silaFW_pb2.String(value=tubing),
            'NonFactoryRSV': silaFW_pb2.String(value=volume)
        }
        try:
            parameter = DeviceServicer_pb2.SetNonFactoryRSV_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetNonFactoryRSV_Parameters(
                    **DeviceServicer_default_dict['SetNonFactoryRSV_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetNonFactoryRSV(parameter)
    
            logging.debug('SetNonFactoryRSV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetPauseTime(self, channel) \
            -> DeviceServicer_pb2.GetPauseTime_Responses:
        """
        Wrapper to call the unobservable command GetPauseTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPauseTime:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)
        }
        try:
            parameter = DeviceServicer_pb2.GetPauseTime_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetPauseTime_Parameters(
                    **DeviceServicer_default_dict['GetPauseTime_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetPauseTime(parameter)
    
            logging.debug('GetPauseTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetPauseTime(self, channel, value) \
            -> DeviceServicer_pb2.SetPauseTime_Responses:
        """
        Wrapper to call the unobservable command SetPauseTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetPauseTime:")

        default_dict = {
            'Channel': silaFW_pb2.String(value=channel),
            'PauseTime': silaFW_pb2.String(value=value)
        }
        try:
            parameter = DeviceServicer_pb2.SetPauseTime_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetPauseTime_Parameters(
                    **DeviceServicer_default_dict['SetPauseTime_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetPauseTime(parameter)
    
            logging.debug('SetPauseTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetPauseTimeM(self, channel, value) \
            -> DeviceServicer_pb2.SetPauseTimeM_Responses:
        """
        Wrapper to call the unobservable command SetPauseTimeM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetPauseTimeM:")

        default_dict = {
            'Channel': silaFW_pb2.String(value=channel),
            'PauseTimeM': silaFW_pb2.String(value=value)
        }
        try:
            parameter = DeviceServicer_pb2.SetPauseTimeM_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetPauseTimeM_Parameters(
                    **DeviceServicer_default_dict['SetPauseTimeM_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetPauseTimeM(parameter)
    
            logging.debug('SetPauseTimeM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetPauseTimeH(self, channel, value) \
            -> DeviceServicer_pb2.SetPauseTimeH_Responses:
        """
        Wrapper to call the unobservable command SetPauseTimeH on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetPauseTimeH:")

        default_dict = {
            'Channel': silaFW_pb2.String(value=channel),
            'PauseTimeM': silaFW_pb2.String(value=value)
        }
        try:
            parameter = DeviceServicer_pb2.SetPauseTimeH_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetPauseTimeH_Parameters(
                    **DeviceServicer_default_dict['SetPauseTimeH_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetPauseTimeH(parameter)
    
            logging.debug('SetPauseTimeH response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetTotalVolume(self, channel) \
            -> DeviceServicer_pb2.GetTotalVolume_Responses:
        """
        Wrapper to call the unobservable command GetTotalVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetTotalVolume:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = DeviceServicer_pb2.GetTotalVolume_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetTotalVolume_Parameters(
                    **DeviceServicer_default_dict['GetTotalVolume_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetTotalVolume(parameter)
    
            logging.debug('GetTotalVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SaveSettings(self,address) \
            -> DeviceServicer_pb2.SaveSettings_Responses:
        """
        Wrapper to call the unobservable command SaveSettings on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SaveSettings:")

        default_dict = {
            'PumpAddress': silaFW_pb2.String(value=address)}
        try:
            parameter = DeviceServicer_pb2.SaveSettings_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SaveSettings_Parameters(
                    **DeviceServicer_default_dict['SaveSettings_Parameters']
                )
    
            response = self.DeviceServicer_stub.SaveSettings(parameter)
    
            logging.debug('SaveSettings response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SaveSetRoller(self,address) \
            -> DeviceServicer_pb2.SaveSetRoller_Responses:
        """
        Wrapper to call the unobservable command SaveSetRoller on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SaveSetRoller:")

        default_dict = {
            'PumpAddress': silaFW_pb2.String(value=address)
        }
        try:
            parameter = DeviceServicer_pb2.SaveSetRoller_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SaveSetRoller_Parameters(
                    **DeviceServicer_default_dict['SaveSetRoller_Parameters']
                )
    
            response = self.DeviceServicer_stub.SaveSetRoller(parameter)
    
            logging.debug('SaveSetRoller response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetFootSwitchStatus(self,address) \
            -> DeviceServicer_pb2.GetFootSwitchStatus_Responses:
        """
        Wrapper to call the unobservable command GetFootSwitchStatus on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFootSwitchStatus:")

        default_dict= {
            'PumpAddress': silaFW_pb2.Integer(value=address)}
        try:
            parameter = DeviceServicer_pb2.GetFootSwitchStatus_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetFootSwitchStatus_Parameters(
                    **DeviceServicer_default_dict['GetFootSwitchStatus_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetFootSwitchStatus(parameter)
    
            logging.debug('GetFootSwitchStatus response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetRollersNumber(self, channel, value) \
            -> DeviceServicer_pb2.SetRollersNumber_Responses:
        """
        Wrapper to call the unobservable command SetRollersNumber on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetRollersNumber:")

        default_dict= {
            'Channel': silaFW_pb2.String(value=channel),
            'RollersNumber': silaFW_pb2.String(value=value)
        }
        try:
            parameter = DeviceServicer_pb2.SetRollersNumber_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetRollersNumber_Parameters(
                    **DeviceServicer_default_dict['SetRollersNumber_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetRollersNumber(parameter)
    
            logging.debug('SetRollersNumber response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_GetRollersNumber(self,channel) \
            -> DeviceServicer_pb2.GetRollersNumber_Responses:
        """
        Wrapper to call the unobservable command GetRollersNumber on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetRollersNumber:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = DeviceServicer_pb2.GetRollersNumber_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.GetRollersNumber_Parameters(
                    **DeviceServicer_default_dict['GetRollersNumber_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetRollersNumber(parameter)
    
            logging.debug('GetRollersNumber response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DeviceServicer_SetPumpSerialNumber(self, address, value) \
            -> DeviceServicer_pb2.SetPumpSerialNumber_Responses:
        """
        Wrapper to call the unobservable command SetPumpSerialNumber on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetPumpSerialNumber:")

        default_dict= {
            'Address': silaFW_pb2.String(value=address),
            'PumpSerialNumber': silaFW_pb2.String(value=value)
        }
        try:
            parameter = DeviceServicer_pb2.SetPumpSerialNumber_Parameters(**default_dict)
            if parameter is None:
                parameter = DeviceServicer_pb2.SetPumpSerialNumber_Parameters(
                    **DeviceServicer_default_dict['SetPumpSerialNumber_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetPumpSerialNumber(parameter)
    
            logging.debug('SetPumpSerialNumber response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DriveControlServicer_Start(self, channel) \
            -> DriveControlServicer_pb2.StartPump_Responses:
        """
        Wrapper to call the unobservable command StartPump on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling StartPump:")

        def_dict = {
            'Start': silaFW_pb2.Integer(value=channel)
            }

        try:
            parameter = DriveControlServicer_pb2.StartPump_Parameters(**def_dict)
            if parameter is None:
                parameter = DriveControlServicer_pb2.StartPump_Parameters(
                    **DriveControlServicer_default_dict['StartPump_Parameters']
                )
    
            response = self.DriveControlServicer_stub.StartPump(parameter)
    
            logging.debug('StartPump response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DriveControlServicer_Stop(self, channel) \
            -> DriveControlServicer_pb2.Stop_Responses:
        """
        Wrapper to call the unobservable command Stop on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling Stop:")

        def_dict = {
            'Stop': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = DriveControlServicer_pb2.Stop_Parameters(**def_dict)
            if parameter is None:
                parameter = DriveControlServicer_pb2.Stop_Parameters(
                    **DriveControlServicer_default_dict['Stop_Parameters']
                )
    
            response = self.DriveControlServicer_stub.Stop(parameter)
    
            logging.debug('Stop response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DriveControlServicer_GetPumpDirection(self,channel) \
            -> DriveControlServicer_pb2.GetPumpDirection_Responses:
        """
        Wrapper to call the unobservable command GetPumpDirection on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPumpDirection:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = DriveControlServicer_pb2.GetPumpDirection_Parameters(**default_dict)
            if parameter is None:
                parameter = DriveControlServicer_pb2.GetPumpDirection_Parameters(
                    **DriveControlServicer_default_dict['GetPumpDirection_Parameters']
                )
    
            response = self.DriveControlServicer_stub.GetPumpDirection(parameter)
    
            logging.debug('GetPumpDirection response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DriveControlServicer_SetDirectionClockwise(self, channel) \
            -> DriveControlServicer_pb2.SetDirectionClockwise_Responses:
        """
        Wrapper to call the unobservable command SetDirectionClockwise on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDirectionClockwise:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)
        }
        try:
            parameter = DriveControlServicer_pb2.SetDirectionClockwise_Parameters(**default_dict)
            if parameter is None:
                parameter = DriveControlServicer_pb2.SetDirectionClockwise_Parameters(
                    **DriveControlServicer_default_dict['SetDirectionClockwise_Parameters']
                )
    
            response = self.DriveControlServicer_stub.SetDirectionClockwise(parameter)
    
            logging.debug('SetDirectionClockwise response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DriveControlServicer_SetDirectionCounterClockwise(self,channel) \
            -> DriveControlServicer_pb2.SetDirectionCounterClockwise_Responses:
        """
        Wrapper to call the unobservable command SetDirectionCounterClockwise on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDirectionCounterClockwise:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = DriveControlServicer_pb2.SetDirectionCounterClockwise_Parameters(**default_dict)
            if parameter is None:
                parameter = DriveControlServicer_pb2.SetDirectionCounterClockwise_Parameters(
                    **DriveControlServicer_default_dict['SetDirectionCounterClockwise_Parameters']
                )
    
            response = self.DriveControlServicer_stub.SetDirectionCounterClockwise(parameter)
    
            logging.debug('SetDirectionCounterClockwise response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DriveControlServicer_GetCauseResponse(self, channel) \
            -> DriveControlServicer_pb2.GetCauseResponse_Responses:
        """
        Wrapper to call the unobservable command GetCauseResponse on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCauseResponse:")

        default_dict = {'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = DriveControlServicer_pb2.GetCauseResponse_Parameters(**default_dict)
            if parameter is None:
                parameter = DriveControlServicer_pb2.GetCauseResponse_Parameters(
                    **DriveControlServicer_default_dict['GetCauseResponse_Parameters']
                )
    
            response = self.DriveControlServicer_stub.GetCauseResponse(parameter)
    
            logging.debug('GetCauseResponse response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
        #->ParameterControlServicer

    def ParameterControlServicer_SetFlowRate(self, channel, flowrate) \
            -> ParameterControlServicer_pb2.SetFlowRate_Responses:
        """
        Wrapper to call the unobservable command SetFlowRate on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFlowRate:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel),
            'SetFlowRate': silaFW_pb2.Real(value=flowrate)
                        }
        try:
            parameter = ParameterControlServicer_pb2.SetFlowRate_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetFlowRate_Parameters(
                    **ParameterControlServicer_default_dict['SetFlowRate_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetFlowRate(parameter)
    
            logging.debug('SetFlowRate response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_SetRPMMode(self, channel) \
            -> ParameterControlServicer_pb2.SetRPMMode_Responses:
        """
        Wrapper to call the unobservable command SetRPMMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetRPMMode:")

        default_dict = {
            'PumpMode': silaFW_pb2.String(value=channel)}
        try:
            parameter = ParameterControlServicer_pb2.SetRPMMode_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetRPMMode_Parameters(
                    **ParameterControlServicer_default_dict['SetRPMMode_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetRPMMode(parameter)
    
            logging.debug('SetRPMMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_SetFlowRateMode(self, channel) \
            -> ParameterControlServicer_pb2.SetFlowRateMode_Responses:
        """
        Wrapper to call the unobservable command SetFlowRateMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFlowRateMode:")

        default_dict = {
            'PumpMode': silaFW_pb2.String(value=channel)}
        try:
            parameter = ParameterControlServicer_pb2.SetFlowRateMode_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetFlowRateMode_Parameters(
                    **ParameterControlServicer_default_dict['SetFlowRateMode_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetFlowRateMode(parameter)
    
            logging.debug('SetFlowRateMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_SetVolumeRateMode(self, channel) \
            -> ParameterControlServicer_pb2.SetVolumeRateMode_Responses:
        """
        Wrapper to call the unobservable command SetVolumeRateMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetVolumeRateMode:")

        default_dict = {
            'PumpMode': silaFW_pb2.String(value=str(channel))}
        try:
            parameter = ParameterControlServicer_pb2.SetVolumeRateMode_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetVolumeRateMode_Parameters(
                    **ParameterControlServicer_default_dict['SetVolumeRateMode_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetVolumeRateMode(parameter)
    
            logging.debug('SetVolumeRateMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_SetVolumeTimeMode(self, channel) \
            -> ParameterControlServicer_pb2.SetVolumeTimeMode_Responses:
        """
        Wrapper to call the unobservable command SetVolumeTimeMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetVolumeTimeMode:")

        default_dict = {
            'PumpMode': silaFW_pb2.String(value=channel)}
        try:
            parameter = ParameterControlServicer_pb2.SetVolumeTimeMode_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetVolumeTimeMode_Parameters(
                    **ParameterControlServicer_default_dict['SetVolumeTimeMode_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetVolumeTimeMode(parameter)
    
            logging.debug('SetVolumeTimeMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_SetVolumePauseMode(self, channel) \
            -> ParameterControlServicer_pb2.SetVolumePauseMode_Responses:
        """
        Wrapper to call the unobservable command SetVolumePauseMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetVolumePauseMode:")

        default_dict = {
            'PumpMode': silaFW_pb2.String(value=channel)}
        try:
            parameter = ParameterControlServicer_pb2.SetVolumePauseMode_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetVolumePauseMode_Parameters(
                    **ParameterControlServicer_default_dict['SetVolumePauseMode_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetVolumePauseMode(parameter)
    
            logging.debug('SetVolumePauseMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_SetTimeMode(self, channel) \
            -> ParameterControlServicer_pb2.SetTimeMode_Responses:
        """
        Wrapper to call the unobservable command SetTimeMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetTimeMode:")

        default_dict = {
            'PumpMode': silaFW_pb2.String(value=channel)}
        try:
            parameter = ParameterControlServicer_pb2.SetTimeMode_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetTimeMode_Parameters(
                    **ParameterControlServicer_default_dict['SetTimeMode_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetTimeMode(parameter)
    
            logging.debug('SetTimeMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_SetTimePauseMode(self, channel) \
            -> ParameterControlServicer_pb2.SetTimePauseMode_Responses:
        """
        Wrapper to call the unobservable command SetTimePauseMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetTimePauseMode:")

        default_dict = {
            'PumpMode': silaFW_pb2.String(value=channel)}
        try:
            parameter = ParameterControlServicer_pb2.SetTimePauseMode_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetTimePauseMode_Parameters(
                    **ParameterControlServicer_default_dict['SetTimePauseMode_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetTimePauseMode(parameter)
    
            logging.debug('SetTimePauseMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_SetVolume(self, channel, volume) \
            -> ParameterControlServicer_pb2.SetVolume_Responses:
        """
        Wrapper to call the unobservable command SetVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetVolume:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel),
            'Volume': silaFW_pb2.Real(value=volume)
                                                }
        try:
            parameter = ParameterControlServicer_pb2.SetVolume_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetVolume_Parameters(
                    **ParameterControlServicer_default_dict['SetVolume_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetVolume(parameter)
    
            logging.debug('SetVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_GetFlowRate(self, channel) \
            -> ParameterControlServicer_pb2.GetFlowRate_Responses:
        """
        Wrapper to call the unobservable command GetFlowRate on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFlowRate:")

        default_dict = {'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = ParameterControlServicer_pb2.GetFlowRate_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetFlowRate_Parameters(
                    **ParameterControlServicer_default_dict['GetFlowRate_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetFlowRate(parameter)
    
            logging.debug('GetFlowRate response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_GetMode(self,channel) \
            -> ParameterControlServicer_pb2.GetMode_Responses:
        """
        Wrapper to call the unobservable command GetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetMode:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = ParameterControlServicer_pb2.GetMode_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetMode_Parameters(
                    **ParameterControlServicer_default_dict['GetMode_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetMode(parameter)
    
            logging.debug('GetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_GetVolume(self,channel) \
            -> ParameterControlServicer_pb2.GetVolume_Responses:
        """
        Wrapper to call the unobservable command GetVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVolume:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = ParameterControlServicer_pb2.GetVolume_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetVolume_Parameters(
                    **ParameterControlServicer_default_dict['GetVolume_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetVolume(parameter)
    
            logging.debug('GetVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_GetMaximumFlowRate(self,channel) \
            -> ParameterControlServicer_pb2.GetMaximumFlowRate_Responses:
        """
        Wrapper to call the unobservable command GetMaximumFlowRate on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetMaximumFlowRate:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = ParameterControlServicer_pb2.GetMaximumFlowRate_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetMaximumFlowRate_Parameters(
                    **ParameterControlServicer_default_dict['GetMaximumFlowRate_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetMaximumFlowRate(parameter)
    
            logging.debug('GetMaximumFlowRate response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_GetMaximumFlowRateWithCalibration(self,channel) \
            -> ParameterControlServicer_pb2.GetMaximumFlowRateWithCalibration_Responses:
        """
        Wrapper to call the unobservable command GetMaximumFlowRateWithCalibration on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetMaximumFlowRateWithCalibration:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = ParameterControlServicer_pb2.GetMaximumFlowRateWithCalibration_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetMaximumFlowRateWithCalibration_Parameters(
                    **ParameterControlServicer_default_dict['GetMaximumFlowRateWithCalibration_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetMaximumFlowRateWithCalibration(parameter)
    
            logging.debug('GetMaximumFlowRateWithCalibration response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_GetSpeedSettingRPM(self,channel) \
            -> ParameterControlServicer_pb2.GetSpeedSettingRPM_Responses:
        """
        Wrapper to call the unobservable command GetSpeedSettingRPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSpeedSettingRPM:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = ParameterControlServicer_pb2.GetSpeedSettingRPM_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetSpeedSettingRPM_Parameters(
                    **ParameterControlServicer_default_dict['GetSpeedSettingRPM_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetSpeedSettingRPM(parameter)
    
            logging.debug('GetSpeedSettingRPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_SetSpeedSettingRPM(self,channel, value) \
            -> ParameterControlServicer_pb2.SetSpeedSettingRPM_Responses:
        """
        Wrapper to call the unobservable command SetSpeedSettingRPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSpeedSettingRPM:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel),
            'Speed': silaFW_pb2.Real(value=value)        }
        try:
            parameter = ParameterControlServicer_pb2.SetSpeedSettingRPM_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetSpeedSettingRPM_Parameters(
                    **ParameterControlServicer_default_dict['SetSpeedSettingRPM_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetSpeedSettingRPM(parameter)
    
            logging.debug('SetSpeedSettingRPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_SetCurrentRunTime(self, channel, time) \
            -> ParameterControlServicer_pb2.SetCurrentRunTime_Responses:
        """
        Wrapper to call the unobservable command SetCurrentRunTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCurrentRunTime:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel),
            'RunTime': silaFW_pb2.Real(value=time)}
        try:
            parameter = ParameterControlServicer_pb2.SetCurrentRunTime_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetCurrentRunTime_Parameters(
                    **ParameterControlServicer_default_dict['SetCurrentRunTime_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetCurrentRunTime(parameter)
    
            logging.debug('SetCurrentRunTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_GetCurrentRunTime(self,channel) \
            -> ParameterControlServicer_pb2.GetCurrentRunTime_Responses:
        """
        Wrapper to call the unobservable command GetCurrentRunTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCurrentRunTime:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = ParameterControlServicer_pb2.GetCurrentRunTime_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetCurrentRunTime_Parameters(
                    **ParameterControlServicer_default_dict['GetCurrentRunTime_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetCurrentRunTime(parameter)
    
            logging.debug('GetCurrentRunTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_SetPumpingPauseTime(self, channel, time) \
            -> ParameterControlServicer_pb2.SetPumpingPauseTime_Responses:
        """
        Wrapper to call the unobservable command SetPumpingPauseTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetPumpingPauseTime:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel),
            'PumpingPauseTime': silaFW_pb2.Real(value=time)
                            }
        try:
            parameter = ParameterControlServicer_pb2.SetPumpingPauseTime_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetPumpingPauseTime_Parameters(
                    **ParameterControlServicer_default_dict['SetPumpingPauseTime_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetPumpingPauseTime(parameter)
    
            logging.debug('SetPumpingPauseTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_GetPumpingPauseTime(self, channel) \
            -> ParameterControlServicer_pb2.GetPumpingPauseTime_Responses:
        """
        Wrapper to call the unobservable command GetPumpingPauseTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPumpingPauseTime:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)  }
        try:
            parameter = ParameterControlServicer_pb2.GetPumpingPauseTime_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetPumpingPauseTime_Parameters(
                    **ParameterControlServicer_default_dict['GetPumpingPauseTime_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetPumpingPauseTime(parameter)
    
            logging.debug('GetPumpingPauseTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_GetCycleCount(self,channel) \
            -> ParameterControlServicer_pb2.GetCycleCount_Responses:
        """
        Wrapper to call the unobservable command GetCycleCount on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCycleCount:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = ParameterControlServicer_pb2.GetCycleCount_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetCycleCount_Parameters(
                    **ParameterControlServicer_default_dict['GetCycleCount_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetCycleCount(parameter)
    
            logging.debug('GetCycleCount response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_SetCycleCount(self, channel, cycles) \
            -> ParameterControlServicer_pb2.SetCycleCount_Responses:
        """
        Wrapper to call the unobservable command SetCycleCount on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCycleCount:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel),
            'CycleCount': silaFW_pb2.Real(value=cycles)
        }
        try:
            parameter = ParameterControlServicer_pb2.SetCycleCount_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetCycleCount_Parameters(
                    **ParameterControlServicer_default_dict['SetCycleCount_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetCycleCount(parameter)
    
            logging.debug('SetCycleCount response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_GetDispenseTimeMlMin(self, channel, volume, flowrate) \
            -> ParameterControlServicer_pb2.GetDispenseTimeMlMin_Responses:
        """
        Wrapper to call the unobservable command GetDispenseTimeMlMin on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetDispenseTimeMlMin:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel),
            'Volume': silaFW_pb2.Real(value=volume),
            'FlowRate': silaFW_pb2.Real(value=flowrate)
        }
        try:
            parameter = ParameterControlServicer_pb2.GetDispenseTimeMlMin_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetDispenseTimeMlMin_Parameters(
                    **ParameterControlServicer_default_dict['GetDispenseTimeMlMin_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetDispenseTimeMlMin(parameter)
    
            logging.debug('GetDispenseTimeMlMin response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_GetDispenseTimeRPM(self, channel, volume, flowrate) \
            -> ParameterControlServicer_pb2.GetDispenseTimeRPM_Responses:
        """
        Wrapper to call the unobservable command GetDispenseTimeRPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetDispenseTimeRPM:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel),
            'Volume': silaFW_pb2.Real(value=volume),
            'FlowRate': silaFW_pb2.Real(value=flowrate)
        }
        try:
            parameter = ParameterControlServicer_pb2.GetDispenseTimeRPM_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetDispenseTimeRPM_Parameters(
                    **ParameterControlServicer_default_dict['GetDispenseTimeRPM_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetDispenseTimeRPM(parameter)
    
            logging.debug('GetDispenseTimeRPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_GetFlowRateAtModes(self, channel) \
            -> ParameterControlServicer_pb2.GetFlowRateAtModes_Responses:
        """
        Wrapper to call the unobservable command GetFlowRateAtModes on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFlowRateAtModes:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel)}
        try:
            parameter = ParameterControlServicer_pb2.GetFlowRateAtModes_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.GetFlowRateAtModes_Parameters(
                    **ParameterControlServicer_default_dict['GetFlowRateAtModes_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.GetFlowRateAtModes(parameter)
    
            logging.debug('GetFlowRateAtModes response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def ParameterControlServicer_SetFlowRateAtModes(self, channel, flowrate) \
            -> ParameterControlServicer_pb2.SetFlowRateAtModes_Responses:
        """
        Wrapper to call the unobservable command SetFlowRateAtModes on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFlowRateAtModes:")

        default_dict = {
            'Channel': silaFW_pb2.Integer(value=channel),
            'FlowRate': silaFW_pb2.Real(value=flowrate)
                        }
        try:
            parameter = ParameterControlServicer_pb2.SetFlowRateAtModes_Parameters(**default_dict)
            if parameter is None:
                parameter = ParameterControlServicer_pb2.SetFlowRateAtModes_Parameters(
                    **ParameterControlServicer_default_dict['SetFlowRateAtModes_Parameters']
                )
    
            response = self.ParameterControlServicer_stub.SetFlowRateAtModes(parameter)
    
            logging.debug('SetFlowRateAtModes response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    

    def Subscribe_DeviceServicer_CurrentStatus(self) \
            -> DeviceServicer_pb2.Subscribe_CurrentStatus_Responses:
        """Wrapper to get property CurrentStatus from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading observable property CurrentStatus:")
        try:
            response = self.DeviceServicer_stub.Subscribe_CurrentStatus(
                DeviceServicer_pb2.Subscribe_CurrentStatus_Parameters()
            )
            logging.debug(
                'Subscribe_CurrentStatus response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    @staticmethod
    def grpc_error_handling(error_object: grpc.Call) -> None:
        """Handles exceptions of type grpc.RpcError"""
        logging.exception(
            (
                'Error during gRPC communication.' '\n'
                '\t' 'Status code: {error_code}' '\n'
                '\t' 'Details: {error_details}' '\n'

            ).format(error_code=error_object.code(), error_details=error_object.details())
        )


def parse_command_line():
    """
    Just looking for command line arguments
    """
    parser = argparse.ArgumentParser(description="A SiLA2 client: RegloICCService")
    parser.add_argument('-s', '--server-name', action='store',
                        help='SiLA server to connect with [server-name]', default="PumpService")
    parser.add_argument('-v', '--version', action='version', version='%(prog)s ' + __version__)
    
    return parser.parse_args()


if __name__ == '__main__':
    # or use logging.INFO (=20) or logging.ERROR (=30) for less output
    logging.basicConfig(format='%(levelname)-8s| %(module)s.%(funcName)s: %(message)s', level=logging.DEBUG)

    parsed_args = parse_command_line()

    # start the server
    # sila_client = RegloICCServiceClient(name=parsed_args.server_name, server_ip='10.152.248.35', server_port=55001)
    sila_client = RegloICCServiceClient(name=parsed_args.server_name, server_ip='127.0.0.1', server_port=50001)
    sila_client.run()

    # Log connection info
    logging.info(
        (
            'Connected to SiLA Server {display_name} running in version {version}.' '\n'
            'Service description: {service_description}'
        ).format(
            display_name=sila_client.server_display_name,
            version=sila_client.server_version,
            service_description=sila_client.server_description
        )
    )

    # TODO:
    #   Write your further function calls here to run the client as a standalone application.
