import { Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { BaseNamespaceProps, INamespace, NamespaceType } from './namespace';
import { BaseServiceProps, Service } from './service';
/**
 * @stability stable
 */
export interface HttpNamespaceProps extends BaseNamespaceProps {
}
/**
 * @stability stable
 */
export interface IHttpNamespace extends INamespace {
}
/**
 * @stability stable
 */
export interface HttpNamespaceAttributes {
    /**
     * A name for the Namespace.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Namespace Id for the Namespace.
     *
     * @stability stable
     */
    readonly namespaceId: string;
    /**
     * Namespace ARN for the Namespace.
     *
     * @stability stable
     */
    readonly namespaceArn: string;
}
/**
 * Define an HTTP Namespace.
 *
 * @stability stable
 */
export declare class HttpNamespace extends Resource implements IHttpNamespace {
    /**
     * @stability stable
     */
    static fromHttpNamespaceAttributes(scope: Construct, id: string, attrs: HttpNamespaceAttributes): IHttpNamespace;
    /**
     * A name for the namespace.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Namespace Id for the namespace.
     *
     * @stability stable
     */
    readonly namespaceId: string;
    /**
     * Namespace Arn for the namespace.
     *
     * @stability stable
     */
    readonly namespaceArn: string;
    /**
     * Type of the namespace.
     *
     * @stability stable
     */
    readonly type: NamespaceType;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: HttpNamespaceProps);
    /**
     * @stability stable
     * @attribute true
     */
    get httpNamespaceArn(): string;
    /**
     * @stability stable
     * @attribute true
     */
    get httpNamespaceName(): string;
    /**
     * @stability stable
     * @attribute true
     */
    get httpNamespaceId(): string;
    /**
     * Creates a service within the namespace.
     *
     * @stability stable
     */
    createService(id: string, props?: BaseServiceProps): Service;
}
