import { IResource, Resource } from '@aws-cdk/core';
import { IService } from './service';
/**
 * @stability stable
 */
export interface IInstance extends IResource {
    /**
     * The id of the instance resource.
     *
     * @stability stable
     * @attribute true
     */
    readonly instanceId: string;
    /**
     * The Cloudmap service this resource is registered to.
     *
     * @stability stable
     */
    readonly service: IService;
}
/**
 * Used when the resource that's associated with the service instance is accessible using values other than an IP address or a domain name (CNAME), i.e. for non-ip-instances.
 *
 * @stability stable
 */
export interface BaseInstanceProps {
    /**
     * The id of the instance resource.
     *
     * @default Automatically generated name
     * @stability stable
     */
    readonly instanceId?: string;
    /**
     * Custom attributes of the instance.
     *
     * @default none
     * @stability stable
     */
    readonly customAttributes?: {
        [key: string]: string;
    };
}
/**
 * @stability stable
 */
export declare abstract class InstanceBase extends Resource implements IInstance {
    /**
     * The Id of the instance.
     *
     * @stability stable
     */
    abstract readonly instanceId: string;
    /**
     * The Cloudmap service to which the instance is registered.
     *
     * @stability stable
     */
    abstract readonly service: IService;
    /**
     * Generate a unique instance Id that is safe to pass to CloudMap.
     *
     * @stability stable
     */
    protected uniqueInstanceId(): string;
}
