# Generated by Django 3.2 on 2021-11-01 18:44

from django.db import migrations


MIGRATION_SQL = [
    """
    CREATE MATERIALIZED VIEW urlid_graph_object_fts AS
        SELECT
            object_uuid,
            to_tsvector('pg_catalog.portuguese', STRING_AGG(value, ' ')) AS search_data
        FROM urlid_graph_property
        WHERE
            value_type = 1
            AND value IS NOT NULL
            AND value <> ''
        GROUP BY object_uuid
        WITH NO DATA;
    """,
    """
    CREATE UNIQUE INDEX IF NOT EXISTS idx_urlid_object_fts_uuid ON urlid_graph_object_fts (
        object_uuid
    );
    """,
    """
    CREATE INDEX IF NOT EXISTS idx_urlid_object_fts_vector ON urlid_graph_object_fts USING gin (
        search_data
    );
    """,
]


class Migration(migrations.Migration):

    dependencies = [
        ('urlid_graph', '0002_savedgraph'),
    ]

    operations = [
        migrations.RunSQL(sql=MIGRATION_SQL),
    ]
