# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class ServiceFeeEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'amazon_order_id': 'str',
        'fee_reason': 'str',
        'fee_list': 'FeeComponentList',
        'seller_sku': 'str',
        'fn_sku': 'str',
        'fee_description': 'str',
        'asin': 'str'
    }

    attribute_map = {
        'amazon_order_id': 'AmazonOrderId',
        'fee_reason': 'FeeReason',
        'fee_list': 'FeeList',
        'seller_sku': 'SellerSKU',
        'fn_sku': 'FnSKU',
        'fee_description': 'FeeDescription',
        'asin': 'ASIN'
    }

    def __init__(self, amazon_order_id=None, fee_reason=None, fee_list=None, seller_sku=None, fn_sku=None, fee_description=None, asin=None):  # noqa: E501
        """ServiceFeeEvent - a model defined in Swagger"""  # noqa: E501
        self._amazon_order_id = None
        self._fee_reason = None
        self._fee_list = None
        self._seller_sku = None
        self._fn_sku = None
        self._fee_description = None
        self._asin = None
        self.discriminator = None
        if amazon_order_id is not None:
            self.amazon_order_id = amazon_order_id
        if fee_reason is not None:
            self.fee_reason = fee_reason
        if fee_list is not None:
            self.fee_list = fee_list
        if seller_sku is not None:
            self.seller_sku = seller_sku
        if fn_sku is not None:
            self.fn_sku = fn_sku
        if fee_description is not None:
            self.fee_description = fee_description
        if asin is not None:
            self.asin = asin

    @property
    def amazon_order_id(self):
        """Gets the amazon_order_id of this ServiceFeeEvent.  # noqa: E501

        An Amazon-defined identifier for an order.  # noqa: E501

        :return: The amazon_order_id of this ServiceFeeEvent.  # noqa: E501
        :rtype: str
        """
        return self._amazon_order_id

    @amazon_order_id.setter
    def amazon_order_id(self, amazon_order_id):
        """Sets the amazon_order_id of this ServiceFeeEvent.

        An Amazon-defined identifier for an order.  # noqa: E501

        :param amazon_order_id: The amazon_order_id of this ServiceFeeEvent.  # noqa: E501
        :type: str
        """

        self._amazon_order_id = amazon_order_id

    @property
    def fee_reason(self):
        """Gets the fee_reason of this ServiceFeeEvent.  # noqa: E501

        A short description of the service fee reason.  # noqa: E501

        :return: The fee_reason of this ServiceFeeEvent.  # noqa: E501
        :rtype: str
        """
        return self._fee_reason

    @fee_reason.setter
    def fee_reason(self, fee_reason):
        """Sets the fee_reason of this ServiceFeeEvent.

        A short description of the service fee reason.  # noqa: E501

        :param fee_reason: The fee_reason of this ServiceFeeEvent.  # noqa: E501
        :type: str
        """

        self._fee_reason = fee_reason

    @property
    def fee_list(self):
        """Gets the fee_list of this ServiceFeeEvent.  # noqa: E501


        :return: The fee_list of this ServiceFeeEvent.  # noqa: E501
        :rtype: FeeComponentList
        """
        return self._fee_list

    @fee_list.setter
    def fee_list(self, fee_list):
        """Sets the fee_list of this ServiceFeeEvent.


        :param fee_list: The fee_list of this ServiceFeeEvent.  # noqa: E501
        :type: FeeComponentList
        """

        self._fee_list = fee_list

    @property
    def seller_sku(self):
        """Gets the seller_sku of this ServiceFeeEvent.  # noqa: E501

        The seller SKU of the item. The seller SKU is qualified by the seller's seller ID, which is included with every call to the Selling Partner API.  # noqa: E501

        :return: The seller_sku of this ServiceFeeEvent.  # noqa: E501
        :rtype: str
        """
        return self._seller_sku

    @seller_sku.setter
    def seller_sku(self, seller_sku):
        """Sets the seller_sku of this ServiceFeeEvent.

        The seller SKU of the item. The seller SKU is qualified by the seller's seller ID, which is included with every call to the Selling Partner API.  # noqa: E501

        :param seller_sku: The seller_sku of this ServiceFeeEvent.  # noqa: E501
        :type: str
        """

        self._seller_sku = seller_sku

    @property
    def fn_sku(self):
        """Gets the fn_sku of this ServiceFeeEvent.  # noqa: E501

        A unique identifier assigned by Amazon to products stored in and fulfilled from an Amazon fulfillment center.  # noqa: E501

        :return: The fn_sku of this ServiceFeeEvent.  # noqa: E501
        :rtype: str
        """
        return self._fn_sku

    @fn_sku.setter
    def fn_sku(self, fn_sku):
        """Sets the fn_sku of this ServiceFeeEvent.

        A unique identifier assigned by Amazon to products stored in and fulfilled from an Amazon fulfillment center.  # noqa: E501

        :param fn_sku: The fn_sku of this ServiceFeeEvent.  # noqa: E501
        :type: str
        """

        self._fn_sku = fn_sku

    @property
    def fee_description(self):
        """Gets the fee_description of this ServiceFeeEvent.  # noqa: E501

        A short description of the service fee event.  # noqa: E501

        :return: The fee_description of this ServiceFeeEvent.  # noqa: E501
        :rtype: str
        """
        return self._fee_description

    @fee_description.setter
    def fee_description(self, fee_description):
        """Sets the fee_description of this ServiceFeeEvent.

        A short description of the service fee event.  # noqa: E501

        :param fee_description: The fee_description of this ServiceFeeEvent.  # noqa: E501
        :type: str
        """

        self._fee_description = fee_description

    @property
    def asin(self):
        """Gets the asin of this ServiceFeeEvent.  # noqa: E501

        The Amazon Standard Identification Number (ASIN) of the item.  # noqa: E501

        :return: The asin of this ServiceFeeEvent.  # noqa: E501
        :rtype: str
        """
        return self._asin

    @asin.setter
    def asin(self, asin):
        """Sets the asin of this ServiceFeeEvent.

        The Amazon Standard Identification Number (ASIN) of the item.  # noqa: E501

        :param asin: The asin of this ServiceFeeEvent.  # noqa: E501
        :type: str
        """

        self._asin = asin

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ServiceFeeEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ServiceFeeEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
