import * as certificatemanager from '@aws-cdk/aws-certificatemanager';
import * as route53 from '@aws-cdk/aws-route53';
import * as sns from '@aws-cdk/aws-sns';
import { Construct as CoreConstruct } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * @experimental
 */
export interface ConstructHubProps {
    /**
     * (experimental) Connect the hub to a domain (requires a hosted zone and a certificate).
     *
     * @experimental
     */
    readonly domain?: WebAppDomain;
    /**
     * (experimental) Contact URLs to be used for contacting this Construct Hub operators.
     *
     * @default - none
     * @experimental
     */
    readonly contactUrls?: ContactURLs;
    /**
     * (experimental) Whether the package feed from the npmjs.com registry should be enabled.
     *
     * @default true
     * @experimental
     */
    readonly enableNpmFeed?: boolean;
    /**
     * (experimental) An optional topic to be notified whenever a new package is indexed into this Construct Hub instance.
     *
     * @default - none
     * @experimental
     */
    readonly updatesTopic?: sns.ITopic;
    /**
     * (experimental) The name of the CloudWatch Dashboard created to observe this application.
     *
     * @default - the path to this construct is used as the dashboard name.
     * @experimental
     */
    readonly dashboardName?: string;
}
/**
 * @experimental
 */
export interface WebAppDomain {
    /**
     * (experimental) The root domain name where this instance of Construct Hub will be served.
     *
     * @experimental
     */
    readonly zone: route53.IHostedZone;
    /**
     * (experimental) The certificate to use for serving the Construct Hub over a custom domain.
     *
     * @default - a DNS-Validated certificate will be provisioned using the
     *   provided `hostedZone`.
     * @experimental
     */
    readonly cert: certificatemanager.ICertificate;
}
/**
 * @experimental
 */
export interface ContactURLs {
    /**
     * (experimental) The URL to the issue tracker or documentation for reporting security issues.
     *
     * @default - none
     * @experimental
     */
    readonly securityIssue?: string;
    /**
     * (experimental) The URL to the issue tracker or documentation for requesting a package be un-listed from this Construct Hub instance.
     *
     * @default - none
     * @experimental
     */
    readonly unlistPackage?: string;
    /**
     * (experimental) The URL to the issue tracker or documentation for reporting other issues.
     *
     * @default - none
     * @experimental
     */
    readonly other?: string;
}
/**
 * @experimental
 */
export declare class ConstructHub extends CoreConstruct {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ConstructHubProps);
}
