"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Monitoring = void 0;
const core_1 = require("@aws-cdk/core");
const cdk_watchful_1 = require("cdk-watchful");
/**
 * Construct hub monitoring.
 */
class Monitoring extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const watchful = new cdk_watchful_1.Watchful(this, 'Watchful', {
            dashboardName: 'construct-hub',
        });
        watchful.watchScope(props.watchScope);
    }
}
exports.Monitoring = Monitoring;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvbW9uaXRvcmluZy9pbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSx3Q0FBMEM7QUFDMUMsK0NBQXdDO0FBYXhDOztHQUVHO0FBQ0gsTUFBYSxVQUFXLFNBQVEsZ0JBQVM7SUFDdkMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFzQjtRQUM5RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sUUFBUSxHQUFHLElBQUksdUJBQVEsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQzlDLGFBQWEsRUFBRSxlQUFlO1NBQy9CLENBQUMsQ0FBQztRQUVILFFBQVEsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7Q0FDRjtBQVZELGdDQVVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBXYXRjaGZ1bCB9IGZyb20gJ2Nkay13YXRjaGZ1bCc7XG5cbi8qKlxuICogUHJvcHMgZm9yIHRoZSBtb25pdG9yaW5nIGNvbnN0cnVjdC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBNb25pdG9yaW5nUHJvcHMge1xuICAvKipcbiAgICogVGhlIGNvbnN0cnVjdCBzY29wZSB0byBtb25pdG9yLiBBbGwgXCJ3YXRjaGFibGVcIiByZXNvdXJjZXMgd2l0aGluIHRoaXMgc2NvcGVcbiAgICogd2lsbCBiZSBhdXRvbWF0aWNhbGx5IG1vbml0b3JlZCB0aHJvdWdoIHN0YW5kYXJkIG1vbml0b3JpbmcuXG4gICAqL1xuICByZWFkb25seSB3YXRjaFNjb3BlOiBDb25zdHJ1Y3Q7XG59XG5cbi8qKlxuICogQ29uc3RydWN0IGh1YiBtb25pdG9yaW5nLlxuICovXG5leHBvcnQgY2xhc3MgTW9uaXRvcmluZyBleHRlbmRzIENvbnN0cnVjdCB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBNb25pdG9yaW5nUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3Qgd2F0Y2hmdWwgPSBuZXcgV2F0Y2hmdWwodGhpcywgJ1dhdGNoZnVsJywge1xuICAgICAgZGFzaGJvYXJkTmFtZTogJ2NvbnN0cnVjdC1odWInLFxuICAgIH0pO1xuXG4gICAgd2F0Y2hmdWwud2F0Y2hTY29wZShwcm9wcy53YXRjaFNjb3BlKTtcbiAgfVxufSJdfQ==