# Generated by Django 2.2 on 2022-07-19 15:19

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Token',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('jti', models.CharField(db_index=True, max_length=512, verbose_name='JTI')),
                ('token', models.TextField(db_index=True, verbose_name='Token')),
                ('expired_at', models.DateTimeField(verbose_name='Expired at')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='children', to='wcd_jwt_registry.Token', verbose_name='Parent token')),
            ],
            options={
                'verbose_name': 'Token',
                'verbose_name_plural': 'Tokens',
            },
        ),
        migrations.CreateModel(
            name='TokenUserConnection',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('token', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='user_connections', to='wcd_jwt_registry.Token', verbose_name='Connected token')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='token_connections', to=settings.AUTH_USER_MODEL, verbose_name='Connected user')),
            ],
            options={
                'verbose_name': 'User token connection',
                'verbose_name_plural': 'User token connections',
                'unique_together': {('user', 'token')},
            },
        ),
    ]
