# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_editorjs']

package_data = \
{'': ['*'], 'django_editorjs': ['static/*', 'templates/*']}

setup_kwargs = {
    'name': 'django-editorjs',
    'version': '0.1.1',
    'description': 'Django plugin for using Editor.js in admin',
    'long_description': '# django-editorjs\n\n[![GitHub version](https://badge.fury.io/gh/VLZH%2Fdjango-editorjs.svg)](https://badge.fury.io/gh/VLZH%2Fdjango-editorjs)\n[![PyPi downloads](https://img.shields.io/pypi/dm/django-editorjs)](https://pypi.org/project/django-editorjs/)\n\nPlugin for using [Editor.js](https://editorjs.io/) in django admin.\n\n# Supported plugins/tools\n\n- `@editorjs/paragraph` - [![npm version](https://badge.fury.io/js/%40editorjs%2Fparagraph.svg)](https://badge.fury.io/js/%40editorjs%2Fparagraph)\n- `@editorjs/image` - [![npm version](https://badge.fury.io/js/%40editorjs%2Fimage.svg)](https://badge.fury.io/js/%40editorjs%2Fimage)\n- `@editorjs/header` - [![npm version](https://badge.fury.io/js/%40editorjs%2Fheader.svg)](https://badge.fury.io/js/%40editorjs%2Fheader)\n- `@editorjs/checklist` - [![npm version](https://badge.fury.io/js/%40editorjs%2Fchecklist.svg)](https://badge.fury.io/js/%40editorjs%2Fchecklist)\n- `@editorjs/list` - [![npm version](https://badge.fury.io/js/%40editorjs%2Flist.svg)](https://badge.fury.io/js/%40editorjs%2Flist)\n- `@editorjs/quote` - [![npm version](https://badge.fury.io/js/%40editorjs%2Fquote.svg)](https://badge.fury.io/js/%40editorjs%2Fquote)\n- `@editorjs/raw` - [![npm version](https://badge.fury.io/js/%40editorjs%2Fraw.svg)](https://badge.fury.io/js/%40editorjs%2Fraw)\n- `@editorjs/embed` - [![npm version](https://badge.fury.io/js/%40editorjs%2Fembed.svg)](https://badge.fury.io/js/%40editorjs%2Fembed)\n- `@editorjs/delimiter` - [![npm version](https://badge.fury.io/js/%40editorjs%2Fdelimiter.svg)](https://badge.fury.io/js/%40editorjs%2Fdelimiter)\n- `@editorjs/warning` - [![npm version](https://badge.fury.io/js/%40editorjs%2Fwarning.svg)](https://badge.fury.io/js/%40editorjs%2Fwarning)\n- `@editorjs/link` - [![npm version](https://badge.fury.io/js/%40editorjs%2Flink.svg)](https://badge.fury.io/js/%40editorjs%2Flink)\n- `@editorjs/marker` - [![npm version](https://badge.fury.io/js/%40editorjs%2Fmarker.svg)](https://badge.fury.io/js/%40editorjs%2Fmarker)\n- `@editorjs/attaches` - [![npm version](https://badge.fury.io/js/%40editorjs%2Fattaches.svg)](https://badge.fury.io/js/%40editorjs%2Fattaches)\n- `@editorjs/table` - [![npm version](https://badge.fury.io/js/%40editorjs%2Ftable.svg)](https://badge.fury.io/js/%40editorjs%2Ftable)\n\n> #### ⚠️ Note (for plugin configuration)\n>\n> Usually in examples for Editor.js you will see tool names starts with lowercase, but for bypass potential conflicts i use uppercase.\n\n# Installation\n\n```bash\npip install django-editorjs\n```\n\n# Simple example\n\n```python\n# models.py\nfrom django.db import models\nfrom django_editorjs import EditorJsField\n\nclass Post(models.Model):\n    title = models.CharField(max_length=255)\n    body = EditorJsField()\n\n    def __str__(self):\n        return self.title\n```\n\n# How to configure\n\nYou can provide field specific configuration options to `EditorJsField` by argument `editorjs_config`.\n\n#### Example\n\n```python\nclass Post(models.Model):\n    title = models.TextField()\n    body = EditorJsField(\n        editorjs_config={\n            "tools": {\n                "Table": {\n                    "disabled": False,\n                    "inlineToolbar": True,\n                    "config": {"rows": 2, "cols": 3,},\n                }\n            }\n        }\n    )\n\n```\n\n## Config schema\n\n- `tools`\n  - `Image` - (`dict`) configuration for tool `ImageTool`. (_For more info see official documentation for tool_).\n  - `Header` - (`dict`) configuration for tool `Header`. (_For more info see official documentation for tool_).\n  - `Checklist` - (`dict`) configuration for tool `Checklist`. (_For more info see official documentation for tool_).\n  - `List` - (`dict`) configuration for tool `List`. (_For more info see official documentation for tool_).\n  - `Quote` - (`dict`) configuration for tool `Quote`. (_For more info see official documentation for tool_).\n  - `Raw` - (`dict`) configuration for tool `RawTool`. (_For more info see official documentation for tool_).\n  - `Embed` - (`dict`) configuration for tool `Embed`. (_For more info see official documentation for tool_).\n  - `Delimiter` - (`dict`) configuration for tool `Delimiter`. (_For more info see official documentation for tool_).\n  - `Warning` - (`dict`) configuration for tool `Warning`. (_For more info see official documentation for tool_).\n  - `Link` - (`dict`) configuration for tool `LinkTool`. (_For more info see official documentation for tool_).\n  - `Marker` - (`dict`) configuration for tool `Marker`. (_For more info see official documentation for tool_).\n  - `Attaches` - (`dict`) configuration for tool `AttachesTool`. (_For more info see official documentation for tool_).\n  - `Table` - (`dict`) configuration for tool `Table`. (_For more info see official documentation for tool_).\n\n# API\n\n- `EditorJsField`\n\n  Extends `TextField` and use `EditorJsWidget` as widget + have additional argument in constructor: `editorjs_config`.\n\n- `EditorJsWidget`\n\n  Widget that you can to use for using Editor.js in Django.\n\n# TODO\n\n- load tool on demand\n- more examples in README.md\n- view-function for file uploading\n- view-function for image uploading\n- view-function for link info crawler\n',
    'author': 'vlzh',
    'author_email': 'vlzh@pm.me',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/VLZH/django-editorjs',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.4,<4.0',
}


setup(**setup_kwargs)
