# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Author",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("salutation", models.CharField(max_length=10)),
                ("name", models.CharField(max_length=200)),
                ("email", models.EmailField(max_length=254)),
                (
                    "headshot",
                    models.ImageField(
                        null=True, upload_to=b"author_headshots", blank=True
                    ),
                ),
            ],
            options={
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="Book",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("title", models.CharField(max_length=100)),
                ("publication_date", models.DateField()),
                ("isbn", models.CharField(max_length=100)),
                ("price", models.DecimalField(max_digits=10, decimal_places=2)),
                ("authors", models.ManyToManyField(to="books.Author")),
            ],
            options={
                "ordering": ["isbn"],
            },
        ),
        migrations.CreateModel(
            name="Order",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("created", models.DateField(auto_now_add=True)),
                ("updated", models.DateField(auto_now=True)),
            ],
            options={
                "ordering": ["-created"],
            },
        ),
        migrations.CreateModel(
            name="OrderLine",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("book", models.ForeignKey(to="books.Book", on_delete=models.CASCADE)),
            ],
            options={
                "ordering": ["order__created"],
            },
        ),
        migrations.CreateModel(
            name="Publisher",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=30)),
                ("address", models.CharField(max_length=50)),
                ("city", models.CharField(max_length=60)),
                ("state_province", models.CharField(max_length=30)),
                ("country", models.CharField(max_length=50)),
                ("website", models.URLField()),
            ],
            options={
                "ordering": ["name"],
            },
        ),
        migrations.AddField(
            model_name="order",
            name="lines",
            field=models.ManyToManyField(to="books.OrderLine", blank=True),
        ),
        migrations.AddField(
            model_name="order",
            name="owner",
            field=models.ForeignKey(
                to=settings.AUTH_USER_MODEL, on_delete=models.CASCADE
            ),
        ),
        migrations.AddField(
            model_name="book",
            name="publisher",
            field=models.ForeignKey(to="books.Publisher", on_delete=models.CASCADE),
        ),
    ]
