"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyApiGatewayJavaProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const open_api_gateway_java_project_1 = require("./open-api-gateway-java-project");
const setup_smithy_build_1 = require("./smithy/setup-smithy-build");
/**
 * Synthesizes a Java Project with a Smithy model, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid smithy-api-gateway-java
 */
class SmithyApiGatewayJavaProject extends open_api_gateway_java_project_1.OpenApiGatewayJavaProject {
    constructor(options) {
        super(options);
        /**
         * The directory in which the smithy model files reside
         */
        this.modelDir = "model";
    }
    preConstruct(options) {
        const { modelDir, generatedSpecFilePath } = setup_smithy_build_1.setupSmithyBuild(this, 
        // Options are the same as those in the constructor, so it is safe to cast to SmithyApiGatewayProjectOptions
        options);
        // @ts-ignore this method is called by the constructor
        this.modelDir = modelDir;
        return {
            ...options,
            specFile: generatedSpecFilePath,
        };
    }
}
exports.SmithyApiGatewayJavaProject = SmithyApiGatewayJavaProject;
_a = JSII_RTTI_SYMBOL_1;
SmithyApiGatewayJavaProject[_a] = { fqn: "@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayJavaProject", version: "0.14.6" };
//# sourceMappingURL=data:application/json;base64,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