"""Fluent Solver TUI Commands"""
#
# This is an auto-generated file.  DO NOT EDIT!
#
# pylint: disable=line-too-long

from ansys.fluent.core.services.datamodel_tui import PyMenu, TUIMenu



class main_menu(TUIMenu):
    """
    Fluent solver main menu.
    """
    def __init__(self, path, service):
        self.path = path
        self.service = service
        self.turbo_post = self.__class__.turbo_post(path + ["turbo_post"], service)
        self.define = self.__class__.define(path + ["define"], service)
        self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
        self.report = self.__class__.report(path + ["report"], service)
        self.surface = self.__class__.surface(path + ["surface"], service)
        self.adjoint = self.__class__.adjoint(path + ["adjoint"], service)
        self.turbo_workflow = self.__class__.turbo_workflow(path + ["turbo_workflow"], service)
        self.file = self.__class__.file(path + ["file"], service)
        self.mesh = self.__class__.mesh(path + ["mesh"], service)
        self.solve = self.__class__.solve(path + ["solve"], service)
        self.solution = self.__class__.solution(path + ["solution"], service)
        self.parallel = self.__class__.parallel(path + ["parallel"], service)
        self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
        self.results = self.__class__.results(path + ["results"], service)
        self.server = self.__class__.server(path + ["server"], service)
        self.plot = self.__class__.plot(path + ["plot"], service)
        self.parameters__and__customization = self.__class__.parameters__and__customization(path + ["parameters__and__customization"], service)
        self.setup = self.__class__.setup(path + ["setup"], service)
        self.preferences = self.__class__.preferences(path + ["preferences"], service)
        self.icing = self.__class__.icing(path + ["icing"], service)
        self.views = self.__class__.views(path + ["views"], service)
        self.display = self.__class__.display(path + ["display"], service)
        super().__init__(path, service)
    def switch_to_meshing_mode(self, *args, **kwargs):
        """
        Switches from the solution mode to the meshing mode. This text command is only available if you have not yet read a mesh or a case file.
        """
        return PyMenu(self.service, "/switch_to_meshing_mode").execute(*args, **kwargs)
    def exit(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/exit").execute(*args, **kwargs)
    def print_license_usage(self, *args, **kwargs):
        """
        Print license usage information.
        """
        return PyMenu(self.service, "/print_license_usage").execute(*args, **kwargs)
    def close_fluent(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/close_fluent").execute(*args, **kwargs)

    class turbo_post(TUIMenu):
        """
        Enter the turbo menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            super().__init__(path, service)
        def two_d_contours(self, *args, **kwargs):
            """
            Display 2d contours.
            """
            return PyMenu(self.service, "/turbo_post/two_d_contours").execute(*args, **kwargs)
        def compute_report(self, *args, **kwargs):
            """
            Computes turbomachinery quantities.
            """
            return PyMenu(self.service, "/turbo_post/compute_report").execute(*args, **kwargs)
        def avg_contours(self, *args, **kwargs):
            """
            Displays average contours.
            """
            return PyMenu(self.service, "/turbo_post/avg_contours").execute(*args, **kwargs)
        def write_report(self, *args, **kwargs):
            """
            Writes the turbo report to file.
            """
            return PyMenu(self.service, "/turbo_post/write_report").execute(*args, **kwargs)
        def xy_plot_avg(self, *args, **kwargs):
            """
            Displays average XY plots.
            """
            return PyMenu(self.service, "/turbo_post/xy_plot_avg").execute(*args, **kwargs)
        def current_topology(self, *args, **kwargs):
            """
            Sets the current turbo topology for global use.
            """
            return PyMenu(self.service, "/turbo_post/current_topology").execute(*args, **kwargs)

    class define(TUIMenu):
        """
        Enter the define menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.models = self.__class__.models(path + ["models"], service)
            self.periodic_conditions = self.__class__.periodic_conditions(path + ["periodic_conditions"], service)
            self.user_defined = self.__class__.user_defined(path + ["user_defined"], service)
            self.mesh_interfaces = self.__class__.mesh_interfaces(path + ["mesh_interfaces"], service)
            self.turbo_model = self.__class__.turbo_model(path + ["turbo_model"], service)
            self.boundary_conditions = self.__class__.boundary_conditions(path + ["boundary_conditions"], service)
            self.materials = self.__class__.materials(path + ["materials"], service)
            self.named_expressions = self.__class__.named_expressions(path + ["named_expressions"], service)
            self.spectral = self.__class__.spectral(path + ["spectral"], service)
            self.dynamic_mesh = self.__class__.dynamic_mesh(path + ["dynamic_mesh"], service)
            self.custom_field_functions = self.__class__.custom_field_functions(path + ["custom_field_functions"], service)
            self.operating_conditions = self.__class__.operating_conditions(path + ["operating_conditions"], service)
            self.parameters = self.__class__.parameters(path + ["parameters"], service)
            self.overset_interfaces = self.__class__.overset_interfaces(path + ["overset_interfaces"], service)
            self.phases = self.__class__.phases(path + ["phases"], service)
            self.curvilinear_coordinate_system = self.__class__.curvilinear_coordinate_system(path + ["curvilinear_coordinate_system"], service)
            self.reference_frames = self.__class__.reference_frames(path + ["reference_frames"], service)
            self.mixing_planes = self.__class__.mixing_planes(path + ["mixing_planes"], service)
            self.profiles = self.__class__.profiles(path + ["profiles"], service)
            self.virtual_boundary = self.__class__.virtual_boundary(path + ["virtual_boundary"], service)
            self.gap_model = self.__class__.gap_model(path + ["gap_model"], service)
            self.solution_strategy = self.__class__.solution_strategy(path + ["solution_strategy"], service)
            super().__init__(path, service)
        def enable_mesh_morpher_optimizer(self, *args, **kwargs):
            """
            Enables the mesh morpher/optimizer. When the mesh morpher/optimizer is enabled, the define/mesh-morpher-optimizer text command becomes available.
            """
            return PyMenu(self.service, "/define/enable_mesh_morpher_optimizer").execute(*args, **kwargs)
        def units(self, *args, **kwargs):
            """
            Sets unit conversion factors.
            """
            return PyMenu(self.service, "/define/units").execute(*args, **kwargs)
        def set_unit_system(self, *args, **kwargs):
            """
            Applies a standard set of units to all quantities. The options include default,si, british, andcgs.
            """
            return PyMenu(self.service, "/define/set_unit_system").execute(*args, **kwargs)
        def physics(self, *args, **kwargs):
            """
            Manage Physics-regions.
            """
            return PyMenu(self.service, "/define/physics").execute(*args, **kwargs)
        def beta_feature_access(self, *args, **kwargs):
            """
            Enable access to beta features in the interface.
            """
            return PyMenu(self.service, "/define/beta_feature_access").execute(*args, **kwargs)
        def injections(self, *args, **kwargs):
            """
            Enters the injections menu.  For a description of the items in this menu, see define/models/dpm/injections.
            """
            return PyMenu(self.service, "/define/injections").execute(*args, **kwargs)

        class models(TUIMenu):
            """
            Enters the models menu to configure the solver.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.dpm = self.__class__.dpm(path + ["dpm"], service)
                self.solver = self.__class__.solver(path + ["solver"], service)
                self.shell_conduction = self.__class__.shell_conduction(path + ["shell_conduction"], service)
                self.optics = self.__class__.optics(path + ["optics"], service)
                self.radiation = self.__class__.radiation(path + ["radiation"], service)
                self.nox_parameters = self.__class__.nox_parameters(path + ["nox_parameters"], service)
                self.structure = self.__class__.structure(path + ["structure"], service)
                self.two_temperature = self.__class__.two_temperature(path + ["two_temperature"], service)
                self.acoustics = self.__class__.acoustics(path + ["acoustics"], service)
                self.cht = self.__class__.cht(path + ["cht"], service)
                self.species = self.__class__.species(path + ["species"], service)
                self.viscous = self.__class__.viscous(path + ["viscous"], service)
                self.eulerian_wallfilm = self.__class__.eulerian_wallfilm(path + ["eulerian_wallfilm"], service)
                self.soot_parameters = self.__class__.soot_parameters(path + ["soot_parameters"], service)
                self.system_coupling_settings = self.__class__.system_coupling_settings(path + ["system_coupling_settings"], service)
                self.electrolysis = self.__class__.electrolysis(path + ["electrolysis"], service)
                self.multiphase = self.__class__.multiphase(path + ["multiphase"], service)
                self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
                super().__init__(path, service)
            def unsteady_2nd_order_bounded(self, *args, **kwargs):
                """
                Selects the bounded second-order implicit formulation for transient simulations.
                """
                return PyMenu(self.service, "/define/models/unsteady_2nd_order_bounded").execute(*args, **kwargs)
            def unsteady_structure_newmark(self, *args, **kwargs):
                """
                Selects the Newmark method for the direct time integration of the finite element semi-discrete equation of motion. This text command is only available for transient simulations that use the structural model.
                """
                return PyMenu(self.service, "/define/models/unsteady_structure_newmark").execute(*args, **kwargs)
            def unsteady_2nd_order(self, *args, **kwargs):
                """
                Selects the second-order implicit formulation for transient simulations.
                """
                return PyMenu(self.service, "/define/models/unsteady_2nd_order").execute(*args, **kwargs)
            def nox(self, *args, **kwargs):
                """
                Enables/disables the NOx model.
                """
                return PyMenu(self.service, "/define/models/nox").execute(*args, **kwargs)
            def unsteady_global_time(self, *args, **kwargs):
                """
                Selects the explicit transient formulation. This text command is only available for unsteady cases that use the density-based solver with the explicit formulation.
                """
                return PyMenu(self.service, "/define/models/unsteady_global_time").execute(*args, **kwargs)
            def swirl(self, *args, **kwargs):
                """
                Enables/disables axisymmetric swirl velocity.
                """
                return PyMenu(self.service, "/define/models/swirl").execute(*args, **kwargs)
            def addon_module(self, *args, **kwargs):
                """
                Loads addon module.
                """
                return PyMenu(self.service, "/define/models/addon_module").execute(*args, **kwargs)
            def crevice_model(self, *args, **kwargs):
                """
                Enables/disables the crevice model.
                """
                return PyMenu(self.service, "/define/models/crevice_model").execute(*args, **kwargs)
            def unsteady_1st_order(self, *args, **kwargs):
                """
                Selects the first-order implicit formulation for transient simulations.
                """
                return PyMenu(self.service, "/define/models/unsteady_1st_order").execute(*args, **kwargs)
            def axisymmetric(self, *args, **kwargs):
                """
                Specifies whether or not the domain is axisymmetric.
                """
                return PyMenu(self.service, "/define/models/axisymmetric").execute(*args, **kwargs)
            def battery_model(self, *args, **kwargs):
                """
                Enables the dual potential MSMD battery model. For text commands that become available when the battery model is enabled, refer to Battery Model Text Commands.
                """
                return PyMenu(self.service, "/define/models/battery_model").execute(*args, **kwargs)
            def frozen_flux(self, *args, **kwargs):
                """
                Enables/disables frozen flux formulation for transient flows.
                """
                return PyMenu(self.service, "/define/models/frozen_flux").execute(*args, **kwargs)
            def unsteady_structure_euler(self, *args, **kwargs):
                """
                Selects the backward Euler method for the direct time integration of the finite element semi-discrete equation of motion. This text command is only available for transient simulations that use the structural model.
                """
                return PyMenu(self.service, "/define/models/unsteady_structure_euler").execute(*args, **kwargs)
            def steady(self, *args, **kwargs):
                """
                Enables/disables the steady solution model.
                """
                return PyMenu(self.service, "/define/models/steady").execute(*args, **kwargs)
            def soot(self, *args, **kwargs):
                """
                Enables/disables the soot model.
                """
                return PyMenu(self.service, "/define/models/soot").execute(*args, **kwargs)
            def crevice_model_controls(self, *args, **kwargs):
                """
                Enters the crevice model controls menu.
                """
                return PyMenu(self.service, "/define/models/crevice_model_controls").execute(*args, **kwargs)
            def vbm(self, *args, **kwargs):
                """
                Enable/disable Virtual Blade Model.
                """
                return PyMenu(self.service, "/define/models/vbm").execute(*args, **kwargs)
            def solidification_melting(self, *args, **kwargs):
                """
                Enables/disables the solidification and melting model.
                """
                return PyMenu(self.service, "/define/models/solidification_melting").execute(*args, **kwargs)
            def noniterative_time_advance(self, *args, **kwargs):
                """
                Enables/disables noniterative time advancement scheme.
                """
                return PyMenu(self.service, "/define/models/noniterative_time_advance").execute(*args, **kwargs)
            def ablation(self, *args, **kwargs):
                """
                Enables/disables the ablation model.
                """
                return PyMenu(self.service, "/define/models/ablation").execute(*args, **kwargs)
            def energy(self, *args, **kwargs):
                """
                Enable/disable the energy model.
                """
                return PyMenu(self.service, "/define/models/energy").execute(*args, **kwargs)
            def potential_and_li_ion_battery(self, *args, **kwargs):
                """
                Enables/disables the electric-potential model.
                """
                return PyMenu(self.service, "/define/models/potential_and_li_ion_battery").execute(*args, **kwargs)
            def virtual_blade_model(self, *args, **kwargs):
                """
                Enter VBM model menu.
                """
                return PyMenu(self.service, "/define/models/virtual_blade_model").execute(*args, **kwargs)

            class dpm(TUIMenu):
                """
                Enters the dispersed phase model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.collisions = self.__class__.collisions(path + ["collisions"], service)
                    self.options = self.__class__.options(path + ["options"], service)
                    self.splash_options = self.__class__.splash_options(path + ["splash_options"], service)
                    self.parallel = self.__class__.parallel(path + ["parallel"], service)
                    self.erosion_dynamic_mesh = self.__class__.erosion_dynamic_mesh(path + ["erosion_dynamic_mesh"], service)
                    self.numerics = self.__class__.numerics(path + ["numerics"], service)
                    self.stripping_options = self.__class__.stripping_options(path + ["stripping_options"], service)
                    self.interaction = self.__class__.interaction(path + ["interaction"], service)
                    super().__init__(path, service)
                def fill_injection_material_sources(self, *args, **kwargs):
                    """
                    Initialize the DPM sources corresponding to each material.
                    """
                    return PyMenu(self.service, "/define/models/dpm/fill_injection_material_sources").execute(*args, **kwargs)
                def injections(self, *args, **kwargs):
                    """
                    Enters the injections menu.
                    """
                    return PyMenu(self.service, "/define/models/dpm/injections").execute(*args, **kwargs)
                def unsteady_tracking(self, *args, **kwargs):
                    """
                    Enables/disables unsteady particle tracking.
                    """
                    return PyMenu(self.service, "/define/models/dpm/unsteady_tracking").execute(*args, **kwargs)
                def clear_particles_from_domain(self, *args, **kwargs):
                    """
                    Removes/keeps all particles currently in the domain.
                    """
                    return PyMenu(self.service, "/define/models/dpm/clear_particles_from_domain").execute(*args, **kwargs)
                def spray_model(self, *args, **kwargs):
                    """
                    Enters the spray model menu. This command is available only if the breakup model 	enabled globally.
                    """
                    return PyMenu(self.service, "/define/models/dpm/spray_model").execute(*args, **kwargs)
                def user_defined(self, *args, **kwargs):
                    """
                    Sets DPM user-defined functions.
                    """
                    return PyMenu(self.service, "/define/models/dpm/user_defined").execute(*args, **kwargs)

                class collisions(TUIMenu):
                    """
                    Enters the DEM collisions menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.collision_partners = self.__class__.collision_partners(path + ["collision_partners"], service)
                        super().__init__(path, service)
                    def dem_collisions(self, *args, **kwargs):
                        """
                        Enables/disables the DEM collision model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/collisions/dem_collisions").execute(*args, **kwargs)
                    def max_particle_velocity(self, *args, **kwargs):
                        """
                        Sets the maximum particle velocity that may arise from collisions.
                        """
                        return PyMenu(self.service, "/define/models/dpm/collisions/max_particle_velocity").execute(*args, **kwargs)
                    def collision_pair_settings(self, *args, **kwargs):
                        """
                        Supplies settings for collisions to a pair of collision partners. You will be prompted to specify theImpact collision partner and the Target collision partner.
                        """
                        return PyMenu(self.service, "/define/models/dpm/collisions/collision_pair_settings").execute(*args, **kwargs)
                    def list_all_pair_settings(self, *args, **kwargs):
                        """
                        For each pair of collision partners, lists the collision laws and their parameters.
                        """
                        return PyMenu(self.service, "/define/models/dpm/collisions/list_all_pair_settings").execute(*args, **kwargs)
                    def collision_mesh(self, *args, **kwargs):
                        """
                        Input for the collision mesh.
                        """
                        return PyMenu(self.service, "/define/models/dpm/collisions/collision_mesh").execute(*args, **kwargs)

                    class collision_partners(TUIMenu):
                        """
                        Manages collision partners.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def delete(self, *args, **kwargs):
                            """
                            Deletes a collision partner.
                            """
                            return PyMenu(self.service, "/define/models/dpm/collisions/collision_partners/delete").execute(*args, **kwargs)
                        def copy(self, *args, **kwargs):
                            """
                            Copies a collision partner.
                            """
                            return PyMenu(self.service, "/define/models/dpm/collisions/collision_partners/copy").execute(*args, **kwargs)
                        def create(self, *args, **kwargs):
                            """
                            Creates a collision partner.
                            """
                            return PyMenu(self.service, "/define/models/dpm/collisions/collision_partners/create").execute(*args, **kwargs)
                        def rename(self, *args, **kwargs):
                            """
                            Renames a collision partner.
                            """
                            return PyMenu(self.service, "/define/models/dpm/collisions/collision_partners/rename").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            Lists all known collision partners.
                            """
                            return PyMenu(self.service, "/define/models/dpm/collisions/collision_partners/list").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    Enters the options menu to set optional models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def stagger_spatially_atomizer_injections(self, *args, **kwargs):
                        """
                        Enables/disables spatial staggering for atomizer and solid-cone injections.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/stagger_spatially_atomizer_injections").execute(*args, **kwargs)
                    def current_positions_in_sample_file_format(self, *args, **kwargs):
                        """
                        When enabled, generates a file containing particle current positions (step-by-step history report for unsteady tracking) in the sampling file format.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/current_positions_in_sample_file_format").execute(*args, **kwargs)
                    def init_erosion_accretion_rate(self, *args, **kwargs):
                        """
                        Initializes the erosion/accretion rates with zero.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/init_erosion_accretion_rate").execute(*args, **kwargs)
                    def particle_radiation(self, *args, **kwargs):
                        """
                        Enables/disables particle radiation.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/particle_radiation").execute(*args, **kwargs)
                    def thermophoretic_force(self, *args, **kwargs):
                        """
                        Enables/disables thermophoretic force.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/thermophoretic_force").execute(*args, **kwargs)
                    def stagger_radius(self, *args, **kwargs):
                        """
                        Specifies the region over which to spatially stagger particles when particle-staggering is enabled for non-atomizer injections.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/stagger_radius").execute(*args, **kwargs)
                    def virtual_mass_force(self, *args, **kwargs):
                        """
                        Enables/disables inclusion of the virtual mass force in the particle force balance.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/virtual_mass_force").execute(*args, **kwargs)
                    def step_report_sig_figures(self, *args, **kwargs):
                        """
                        Sets significant figures in the step-by-step report.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/step_report_sig_figures").execute(*args, **kwargs)
                    def stagger_temporally(self, *args, **kwargs):
                        """
                        Enables/disables temporal staggering.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/stagger_temporally").execute(*args, **kwargs)
                    def staggering_factor(self, *args, **kwargs):
                        """
                        S.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/staggering_factor").execute(*args, **kwargs)
                    def enable_contour_plots(self, *args, **kwargs):
                        """
                        Enables computation of mean and/or RMS values of additional discrete phase variables for postprocessing.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/enable_contour_plots").execute(*args, **kwargs)
                    def stagger_spatially_standard_injections(self, *args, **kwargs):
                        """
                        Enables/disables spatial staggering for standard (non-atomizer and non-solid-cone) injections.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/stagger_spatially_standard_injections").execute(*args, **kwargs)
                    def allow_supercritical_pressure_vaporization(self, *args, **kwargs):
                        """
                        Enforces the switching from vaporization to boiling even if the boiling point is not calculated from the vapor pressure data. If the pressure in your model is above critical you must retain the default setting (yes). This options is available only if whenPressure Dependent Boiling is enabled in the Physical Models tab of the Discrete Phase Models dialog box. For more details, see .
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/allow_supercritical_pressure_vaporization").execute(*args, **kwargs)
                    def convective_film_heat_transfer(self, *args, **kwargs):
                        """
                        Enable/disable convection/conduction film to wall heat transfer model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/convective_film_heat_transfer").execute(*args, **kwargs)
                    def pressure_gradient_force(self, *args, **kwargs):
                        """
                        Enables/disables inclusion of pressure gradient effects in the particle force balance.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/pressure_gradient_force").execute(*args, **kwargs)
                    def set_thermolysis_limit(self, *args, **kwargs):
                        """
                        Sets the limit for the thermolysis model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/set_thermolysis_limit").execute(*args, **kwargs)
                    def ensemble_average(self, *args, **kwargs):
                        """
                        Ensembles average cloud properties.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/ensemble_average").execute(*args, **kwargs)
                    def scr_urea_deposition_risk_analysis(self, *args, **kwargs):
                        """
                        Enters the menu for setting up the risk for solids deposit formation for the Selective Catalytic Reduction (SCR) process. For more information, see .
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/scr_urea_deposition_risk_analysis").execute(*args, **kwargs)
                    def include_lwf_particles_in_dpm_concentration(self, *args, **kwargs):
                        """
                        Include LWF particle mass in DPM Concentration.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/include_lwf_particles_in_dpm_concentration").execute(*args, **kwargs)
                    def track_in_absolute_frame(self, *args, **kwargs):
                        """
                        Enables/disables tracking in absolute frame.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/track_in_absolute_frame").execute(*args, **kwargs)
                    def remove_wall_film_temperature_limiter(self, *args, **kwargs):
                        """
                        Answering yes at the prompt removes the wall temperature limiter for Lagrangian wall-film walls. If you enter no (default), two additional prompts will appear in the console allowing you to define the temperature difference above the boiling point and to enable/disable the reporting of the Leidenfrost temperature on the wall faces.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/remove_wall_film_temperature_limiter").execute(*args, **kwargs)
                    def lowest_volatiles_mass_fraction(self, *args, **kwargs):
                        """
                        Set the lowest volatiles mass fraction.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/lowest_volatiles_mass_fraction").execute(*args, **kwargs)
                    def two_way_coupling(self, *args, **kwargs):
                        """
                        Enables/disables calculation of DPM sources in TKE equation.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/two_way_coupling").execute(*args, **kwargs)
                    def brownian_motion(self, *args, **kwargs):
                        """
                        Enables/disables Brownian motion of particles.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/brownian_motion").execute(*args, **kwargs)
                    def treat_multicomponent_saturation_temperature_failure(self, *args, **kwargs):
                        """
                        Enables/disables dumping multicomponent particle mass into the continuous phase if the saturation temperature calculation fails.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/treat_multicomponent_saturation_temperature_failure").execute(*args, **kwargs)
                    def saffman_lift_force(self, *args, **kwargs):
                        """
                        Enables/disables Saffman lift force.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/saffman_lift_force").execute(*args, **kwargs)
                    def maximum_udf_species(self, *args, **kwargs):
                        """
                        Specifies the maximum number of species that will be accessible from discrete phase model UDFs. Only species with indices up to this value are accessible in discrete phase model UDFs.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/maximum_udf_species").execute(*args, **kwargs)
                    def vaporization_options(self, *args, **kwargs):
                        """
                        Sets Vaporization options.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/vaporization_options").execute(*args, **kwargs)
                    def set_minimum_particle_diameter(self, *args, **kwargs):
                        """
                        Set the minimum particle diameter.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/set_minimum_particle_diameter").execute(*args, **kwargs)
                    def use_absolute_pressure_for_vaporization(self, *args, **kwargs):
                        """
                        Determines whether the absolute pressure or constant operating pressure (specified in define/operating-conditions/operating-pressure) will be used in vaporization rates calculations.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/use_absolute_pressure_for_vaporization").execute(*args, **kwargs)
                    def uniform_mass_distribution_for_injections(self, *args, **kwargs):
                        """
                        Specifies a uniform distribution of mass over the cross-section of solid cone and atomizer injections. This can become important when the mesh is smaller than the diameter (or another characteristic size) of the injection.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/uniform_mass_distribution_for_injections").execute(*args, **kwargs)
                    def erosion_accretion(self, *args, **kwargs):
                        """
                        Enables/disables erosion/accretion.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/erosion_accretion").execute(*args, **kwargs)
                    def vaporization_heat_transfer_averaging(self, *args, **kwargs):
                        """
                        Enables averaging of the Spalding heat transfer term for the convection/diffusion-controlled model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/options/vaporization_heat_transfer_averaging").execute(*args, **kwargs)

                class splash_options(TUIMenu):
                    """
                    Enters the splash option menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def splash_pdf_limiting(self, *args, **kwargs):
                        """
                        Sets the splash pdf limiting method. Available methods are: the splash pdf tail limiting (default for the LWF model) and the splash pdf peak limiting (default for the EWF model). For the splash pdf peak limiting, you will be prompted to specify the peak limiting value.
                        """
                        return PyMenu(self.service, "/define/models/dpm/splash_options/splash_pdf_limiting").execute(*args, **kwargs)
                    def orourke_splash_fraction(self, *args, **kwargs):
                        """
                        Enables/disables the O’Rourke formulation (default for the Lagrangian Wall Film (LWF) model). If the O’Rourke formulation is disabled, the Stanton formulation (default for the Eulerian Wall Film (EWF) model) is used in a simulation.
                        """
                        return PyMenu(self.service, "/define/models/dpm/splash_options/orourke_splash_fraction").execute(*args, **kwargs)

                class parallel(TUIMenu):
                    """
                    Enters the parallel menu to set parameters for parallel DPM calculations.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        super().__init__(path, service)
                    def hybrid_workpile(self, *args, **kwargs):
                        """
                        Optimize multi-thread load balancing within each partition in hybrid-parallel DPM tracking.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/hybrid_workpile").execute(*args, **kwargs)
                    def use_message_passing(self, *args, **kwargs):
                        """
                        Specifies that the calculations are performed using cluster computing or shared-memory machines. With this option, the compute node processes themselves perform the particle work on their local partitions and particle migration to other compute nodes is implemented using message passing primitives.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/use_message_passing").execute(*args, **kwargs)
                    def fix_source_term_accumulation_order(self, *args, **kwargs):
                        """
                        Enforce deterministic order of source term accumulation.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/fix_source_term_accumulation_order").execute(*args, **kwargs)
                    def report(self, *args, **kwargs):
                        """
                        Prints particle workpile statistics. This option is only available when the define/models/dpm/parallel/enable-workpile? option is enabled.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/report").execute(*args, **kwargs)
                    def hybrid_2domain(self, *args, **kwargs):
                        """
                        Enables/disables the use of a second domain for DPM particle tracking.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/hybrid_2domain").execute(*args, **kwargs)
                    def hybrid_collision_model(self, *args, **kwargs):
                        """
                        An EXPERIMENTAL feature to allow 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/hybrid_collision_model").execute(*args, **kwargs)
                    def n_threads(self, *args, **kwargs):
                        """
                        Sets the number of processors to use for DPM. This option is only available when the define/models/dpm/parallel/enable-workpile? option is enabled.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/n_threads").execute(*args, **kwargs)
                    def enable_workpile(self, *args, **kwargs):
                        """
                        Turns on/off particle workpile algorithm. This option is only available when the define/models/dpm/parallel/use-shared-memory option is selected.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/enable_workpile").execute(*args, **kwargs)
                    def use_shared_memory(self, *args, **kwargs):
                        """
                        Specifies that the calculations are performed on shared-memory multiprocessor machines.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/use_shared_memory").execute(*args, **kwargs)
                    def hybrid_collision_unidirectional(self, *args, **kwargs):
                        """
                        A faster, yet potentially somewhat less accurate, modification to the beta feature
                        that allows 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/hybrid_collision_unidirectional").execute(*args, **kwargs)
                    def hybrid_collision_variant(self, *args, **kwargs):
                        """
                        Further reduce the residual risk of dead-locks in the experimental feature that
                        allows 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/hybrid_collision_variant").execute(*args, **kwargs)
                    def use_hybrid(self, *args, **kwargs):
                        """
                        Specifies that the calculations are performed using multicore cluster computing or shared-memory machines. This option works in conjunction withopenmpi for a dynamic load balancing without migration of cells.
                        """
                        return PyMenu(self.service, "/define/models/dpm/parallel/use_hybrid").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enters the menu for expert DPM parallel text commands.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def partition_method_hybrid_2domain(self, *args, **kwargs):
                            """
                            Enables/disables a partitioning method that is more granular and can yield faster calculations (especially for cases that are running on a low to moderate number of processors). This partitioning method is only applied when you use the DPM domain for the hybrid parallel DPM tracking mode (that is, when you have enabled the define/models/dpm/parallel/hybrid-2domain? text command).
                            """
                            return PyMenu(self.service, "/define/models/dpm/parallel/expert/partition_method_hybrid_2domain").execute(*args, **kwargs)

                class erosion_dynamic_mesh(TUIMenu):
                    """
                    Enters the menu to enable/configure/run the erosion-dynamic mesh interaction.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.run_parameters = self.__class__.run_parameters(path + ["run_parameters"], service)
                        self.general_parameters = self.__class__.general_parameters(path + ["general_parameters"], service)
                        super().__init__(path, service)
                    def enable_erosion_dynamic_mesh_coupling(self, *args, **kwargs):
                        """
                        Enables mesh deformation due to wall erosion.
                        """
                        return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/enable_erosion_dynamic_mesh_coupling").execute(*args, **kwargs)
                    def run_simulation(self, *args, **kwargs):
                        """
                        Performs a coupled erosion-dynamic mesh simulation.
                        """
                        return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_simulation").execute(*args, **kwargs)

                    class run_parameters(TUIMenu):
                        """
                        Manages erosion-dynamic mesh run settings.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def autosave_files(self, *args, **kwargs):
                            """
                            Sets the iteration increment and filename to save data files.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_parameters/autosave_files").execute(*args, **kwargs)
                        def simulation_termination(self, *args, **kwargs):
                            """
                            Sets the total time of erosion.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_parameters/simulation_termination").execute(*args, **kwargs)
                        def mesh_motion_time_step(self, *args, **kwargs):
                            """
                            Sets the mesh motion time stepping parameters and method.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_parameters/mesh_motion_time_step").execute(*args, **kwargs)
                        def flow_simulation_control(self, *args, **kwargs):
                            """
                            Sets the number of iterations per flow simulation step.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_parameters/flow_simulation_control").execute(*args, **kwargs)
                        def autosave_graphics(self, *args, **kwargs):
                            """
                            Sets the iteration increment to save graphics files.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/run_parameters/autosave_graphics").execute(*args, **kwargs)

                    class general_parameters(TUIMenu):
                        """
                        Enters the menu for setting erosion coupling with dynamic mesh.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def participating_walls(self, *args, **kwargs):
                            """
                            Specifies all participating walls.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/general_parameters/participating_walls").execute(*args, **kwargs)
                        def erosion_settings(self, *args, **kwargs):
                            """
                            Sets parameters for erosion calculations.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/general_parameters/erosion_settings").execute(*args, **kwargs)
                        def dynamic_mesh_settings(self, *args, **kwargs):
                            """
                            Sets parameters for dynamic mesh calculations.
                            """
                            return PyMenu(self.service, "/define/models/dpm/erosion_dynamic_mesh/general_parameters/dynamic_mesh_settings").execute(*args, **kwargs)

                class numerics(TUIMenu):
                    """
                    Enters the numerics menu to set numerical solution parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.high_resolution_tracking = self.__class__.high_resolution_tracking(path + ["high_resolution_tracking"], service)
                        super().__init__(path, service)
                    def automated_scheme_selection(self, *args, **kwargs):
                        """
                        Enables/disables the adaptation of integration step length based on a maximum error.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/automated_scheme_selection").execute(*args, **kwargs)
                    def enhanced_packing_limit_numerics(self, *args, **kwargs):
                        """
                        Enable enhanced packing limit numerics to avoid exceeding of packing limit for granular phases.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/enhanced_packing_limit_numerics").execute(*args, **kwargs)
                    def mppic_settings(self, *args, **kwargs):
                        """
                        Enable PIC and MPPIC to compute DPM and DDPM source terms.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/mppic_settings").execute(*args, **kwargs)
                    def dynamic_interaction(self, *args, **kwargs):
                        """
                        Enable/disable dynamic interaction range.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/dynamic_interaction").execute(*args, **kwargs)
                    def drag_law(self, *args, **kwargs):
                        """
                        Sets the drag law.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/drag_law").execute(*args, **kwargs)
                    def coupled_heat_mass_update(self, *args, **kwargs):
                        """
                        Enables/disables coupled heat and mass update.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/coupled_heat_mass_update").execute(*args, **kwargs)
                    def tracking_statistics(self, *args, **kwargs):
                        """
                        Controls the format of the one-line tracking statistics to be printed after every DPM tracking pass. A value of 0 (the default) prints only fates with non-zero values. A value of 1 prints all fates, including fates with zero values.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/tracking_statistics").execute(*args, **kwargs)
                    def average_each_step(self, *args, **kwargs):
                        """
                        Enables/disables mesh node averaging during integration time step.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/average_each_step").execute(*args, **kwargs)
                    def tracking_parameters(self, *args, **kwargs):
                        """
                        Sets parameters for the (initial) tracking step length.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/tracking_parameters").execute(*args, **kwargs)
                    def underrelax_film_height(self, *args, **kwargs):
                        """
                        Sets the under-relaxation factor for the film height calculation. The recommended values range between 0.5 (default) and 0.9.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/underrelax_film_height").execute(*args, **kwargs)
                    def error_control(self, *args, **kwargs):
                        """
                        Adapts integration step length based on a maximum error.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/error_control").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Adjust the DPM tracker's verbosity level.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/verbosity").execute(*args, **kwargs)
                    def vaporization_limiting_factors(self, *args, **kwargs):
                        """
                        Sets the Vaporization Fractional Change Limits.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/vaporization_limiting_factors").execute(*args, **kwargs)
                    def average_source_terms(self, *args, **kwargs):
                        """
                        Enables/disables mesh node averaging of DPM source terms.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/average_source_terms").execute(*args, **kwargs)
                    def average_DDPM_variables(self, *args, **kwargs):
                        """
                        Enables/disables mesh node averaging of DDPM quantities.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/average_DDPM_variables").execute(*args, **kwargs)
                    def predictor_corrector(self, *args, **kwargs):
                        """
                        Enable predictor/corrector approach to track particles.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/predictor_corrector").execute(*args, **kwargs)
                    def tracking_scheme(self, *args, **kwargs):
                        """
                        Specifies a tracking scheme.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/tracking_scheme").execute(*args, **kwargs)
                    def average_kernel(self, *args, **kwargs):
                        """
                        Specifies the averaging kernel to use for mesh node averaging.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/average_kernel").execute(*args, **kwargs)
                    def gaussian_factor(self, *args, **kwargs):
                        """
                        Specifies the Gaussian constant when using thegaussian kernel for mesh node averaging.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/gaussian_factor").execute(*args, **kwargs)
                    def minimum_liquid_fraction(self, *args, **kwargs):
                        """
                        A droplet evaporates completely when the remaining mass is below this fraction of the initial droplet mass.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/minimum_liquid_fraction").execute(*args, **kwargs)
                    def enable_node_based_averaging(self, *args, **kwargs):
                        """
                        Enables/disables mesh node averaging of DPM quantities.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/enable_node_based_averaging").execute(*args, **kwargs)
                    def granular_stress_tensor(self, *args, **kwargs):
                        """
                        Enable granular stress tensor to be considered with solid pressure gradient as collision force.
                        """
                        return PyMenu(self.service, "/define/models/dpm/numerics/granular_stress_tensor").execute(*args, **kwargs)

                    class high_resolution_tracking(TUIMenu):
                        """
                        Enters the high resolution tracking menu. See  for more information about these options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.barycentric_interpolation = self.__class__.barycentric_interpolation(path + ["barycentric_interpolation"], service)
                            self.particle_relocation = self.__class__.particle_relocation(path + ["particle_relocation"], service)
                            super().__init__(path, service)
                        def check_subtet_validity(self, *args, **kwargs):
                            """
                            When enabled, checks the validity of a subtet when the particle first enters it. If the subtet is found to be degenerate, the tracking algorithm modifies to accommodate it.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/check_subtet_validity").execute(*args, **kwargs)
                        def enable_automatic_intersection_tolerance(self, *args, **kwargs):
                            """
                            Enables/disables the automatic calculation of intersection tolerance. By default, the tolerance used in intersection calculations is scaled by the residence time of the particle in the cell to improve robustness. For most cases, the scaled tolerance is sufficient to identify all intersections of the particle trajectory and the subtet faces. You can set the intersection tolerance manually using the set-subtet-intersection-tolerance text command.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/enable_automatic_intersection_tolerance").execute(*args, **kwargs)
                        def always_use_face_centroid_with_periodics(self, *args, **kwargs):
                            """
                            When enabled, ANSYS Fluent uses quad face centroids when creating subtets in cases with periodic boundaries.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/always_use_face_centroid_with_periodics").execute(*args, **kwargs)
                        def use_quad_face_centroid(self, *args, **kwargs):
                            """
                            Enables/disables using quad face centroids when creating subtets. This option changes the way hexahedral cells are decomposed to avoid creating degenerate subtets.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/use_quad_face_centroid").execute(*args, **kwargs)
                        def use_barycentric_sampling(self, *args, **kwargs):
                            """
                            When enabled, this option provides improved accuracy and parallel consistency when sampling particles at planes. This item is available only with the 3D solver. Using the double-precision solver and bounded planes is recommended.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/use_barycentric_sampling").execute(*args, **kwargs)
                        def set_film_spreading_parameter(self, *args, **kwargs):
                            """
                            Set the spreading parameter for Lagrangian wallfilm particles.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/set_film_spreading_parameter").execute(*args, **kwargs)
                        def remove_stuck_particles(self, *args, **kwargs):
                            """
                            Remove particles that are stuck at edges or faces.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/remove_stuck_particles").execute(*args, **kwargs)
                        def project_wall_film_particles_to_film(self, *args, **kwargs):
                            """
                            Enables/disables projecting existing particles to Lagrangian wall film to track using high-resolution tracking.  When reading in a data file that contains wall film particles previously tracked with the existing ANSYS Fluent tracking method, you need to either clear the particles from the domain or project their positions to the wall film surface using the project-wall-film-particles-to-film? text command prior to using the high-resolution tracking method. After tracking the particles for one timestep, this option can be disabled to improve performance.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/project_wall_film_particles_to_film").execute(*args, **kwargs)
                        def boundary_layer_tracking(self, *args, **kwargs):
                            """
                            Enables/disables the calculation of the particle time step that considers both the cell aspect ratio and the particle trajectory. This method improves the accuracy of the predictions in boundary layer cells, particularly in layers where flow gradients are large.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/boundary_layer_tracking").execute(*args, **kwargs)
                        def sliding_interface_crossover_fraction(self, *args, **kwargs):
                            """
                            Specifies the fraction of the distance to the subtet center to move the particle.  At non-conformal interfaces, the nodes used for the barycentric interpolation are different on either side of the interface. This may result in incomplete particles due to discontinuities in the variable interpolation. The number of incomplete particles may be reduced by moving the particles slightly off of the sliding interface. Recommended values range between 0 and 0.5.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/sliding_interface_crossover_fraction").execute(*args, **kwargs)
                        def enable_high_resolution_tracking(self, *args, **kwargs):
                            """
                            Enables/disables high resolution tracking.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/enable_high_resolution_tracking").execute(*args, **kwargs)
                        def use_particle_timestep_for_intersection_tolerance(self, *args, **kwargs):
                            """
                            Enables/disables the use of the particle timestep for the subtet intersection tolerance with axisymmetric grids (default: enabled). If disabled, the tolerance will be calculated in the same manner as non-axisymmetric meshes (a scaled value of the tolerance which is set using the define/models/dpm/numerics/high-resolution-tracking/set-subtet-intersection-tolerance text command).
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/use_particle_timestep_for_intersection_tolerance").execute(*args, **kwargs)
                        def enable_barycentric_intersections(self, *args, **kwargs):
                            """
                            Enables/disables an alternative method of calculating intersections with cell boundaries. Barycentric intersections are linear calculations and are faster than the default intersection algorithm. The default intersection algorithm is second-order for stationary meshes; therefore, using the barycentric intersection may sacrifice accuracy. You must verify that the barycentric intersections provide comparable results to the default intersection method. This option is available only for 3D stationary meshes and the double precision solver.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/enable_barycentric_intersections").execute(*args, **kwargs)
                        def use_velocity_based_error_control(self, *args, **kwargs):
                            """
                            Enables/disables an alternative method of timestep adaption. By default, ANSYS Fluent uses the half-step method of timestep adaption with particle integration. This alternative method of controlling the integration timestep based upon velocity changes is faster; however, you need to ensure that the accuracy is comparable for your specific application.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/use_velocity_based_error_control").execute(*args, **kwargs)
                        def set_subtet_intersection_tolerance(self, *args, **kwargs):
                            """
                            Specifies the tolerance used in intersection calculations. This tolerance will be scaled by the characteristic cell crossing time of the particle if the enable-automatic-intersection-tolerance? text command is enabled. If that option is disabled, the specified tolerance will be used without scaling. The default intersection tolerance is 10-5.
                            """
                            return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/set_subtet_intersection_tolerance").execute(*args, **kwargs)

                        class barycentric_interpolation(TUIMenu):
                            """
                            Enter the barycentric interpolation menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def precompute_pdf_species(self, *args, **kwargs):
                                """
                                When this option is enabled for premixed or non-premixed combustion simulations, the species composition in each cell is precomputed prior to tracking particles. This approach may improve performance for cases with many particles and relatively few cells. By default, this option is set to no, and ANSYS Fluent calculates the species composition during particle tracking. The solution results will be identical for both methods.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/precompute_pdf_species").execute(*args, **kwargs)
                            def interpolate_flow_density(self, *args, **kwargs):
                                """
                                Enables/disables the barycentric interpolation of the flow density. This option is recommended when the density varies with position to avoid discontinuities in the interpolated variable at cell boundaries. For constant density flows, this option is unnecessary.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_density").execute(*args, **kwargs)
                            def user_interpolation_function(self, *args, **kwargs):
                                """
                                Enter user interpolation function.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/user_interpolation_function").execute(*args, **kwargs)
                            def interpolate_temperature(self, *args, **kwargs):
                                """
                                Enables/disables the barycentric interpolation of temperature to the particle position. The cell temperature is used by default in calculations of heat transfer to/from the particle.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_temperature").execute(*args, **kwargs)
                            def enable_transient_variable_interpolation(self, *args, **kwargs):
                                """
                                Enable transient variable interpolation.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/enable_transient_variable_interpolation").execute(*args, **kwargs)
                            def interpolate_wallfilm_properties(self, *args, **kwargs):
                                """
                                When enabled, the wall film properties (film height, film mass, and wall shear) are interpolated to the particle position.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_wallfilm_properties").execute(*args, **kwargs)
                            def interpolate_flow_viscosity(self, *args, **kwargs):
                                """
                                Enables/disables the barycentric interpolation of flow viscosity to the particle position. This option is recommended when the flow viscosity varies with position to avoid discontinuities in the interpolated variable at cell boundaries. For flows with constant viscosity, this option is unnecessary.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_viscosity").execute(*args, **kwargs)
                            def zero_nodal_velocity_on_walls(self, *args, **kwargs):
                                """
                                When enabled, sets the velocity at wall nodes to zero. (By default, the nodal velocities on walls are first reconstructed from cell and face values and then corrected to ensure that there are no velocity components directed towards the walls). This may be useful if you want to consider particle impingement on the walls. Note that enabling this option will more likely produce incomplete particles as some particles may settle on the walls.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/zero_nodal_velocity_on_walls").execute(*args, **kwargs)
                            def nodal_reconstruction_frequency(self, *args, **kwargs):
                                """
                                Update nodal reconstruction every N'th DPM iteration.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/nodal_reconstruction_frequency").execute(*args, **kwargs)
                            def interpolate_flow_cp(self, *args, **kwargs):
                                """
                                Enables/disables the barycentric interpolation of specific heat to the particle position. This option is recommended when the specific heat varies with position to avoid discontinuities in the interpolated variable at cell boundaries. For flows with constant specific heat, this option is unnecessary.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_cp").execute(*args, **kwargs)
                            def interpolate_flow_solution_gradients(self, *args, **kwargs):
                                """
                                When enabled, flow solution gradients are interpolated to the particle position. This can be useful when using physical models that depend on these gradients (for example, the thermophoretic force, pressure-gradient force, or virtual mass force). Interpolating the gradients also improves the accuracy and robustness of the trapezoidal numerics scheme, which is the default method for pathlines.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_solution_gradients").execute(*args, **kwargs)

                        class particle_relocation(TUIMenu):
                            """
                            Enter the particle relocation menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def use_legacy_particle_location_method(self, *args, **kwargs):
                                """
                                Enable legacy method of locating particles in cells.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/use_legacy_particle_location_method").execute(*args, **kwargs)
                            def overset_relocation_robustness_level(self, *args, **kwargs):
                                """
                                Set the robustness level for particle relocation in overset meshes.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/overset_relocation_robustness_level").execute(*args, **kwargs)
                            def enhanced_wallfilm_location_method(self, *args, **kwargs):
                                """
                                Enable enhanced method of locating film particles on faces.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/enhanced_wallfilm_location_method").execute(*args, **kwargs)
                            def wallfilm_relocation_tolerance_scale_factor(self, *args, **kwargs):
                                """
                                Set the relocation tolerance scaling factor for wallfilm particles after remeshing.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/wallfilm_relocation_tolerance_scale_factor").execute(*args, **kwargs)
                            def load_legacy_particles(self, *args, **kwargs):
                                """
                                Load particles that were tracked without high-resolution tracking enabled.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/load_legacy_particles").execute(*args, **kwargs)
                            def enhanced_cell_relocation_method(self, *args, **kwargs):
                                """
                                Enable enhanced method of locating particles in cells.
                                """
                                return PyMenu(self.service, "/define/models/dpm/numerics/high_resolution_tracking/particle_relocation/enhanced_cell_relocation_method").execute(*args, **kwargs)

                class stripping_options(TUIMenu):
                    """
                    Enters the stripping options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def diameter_coefficient(self, *args, **kwargs):
                        """
                        Sets the diameter coefficient (  in  in the Theory Guide).
                        """
                        return PyMenu(self.service, "/define/models/dpm/stripping_options/diameter_coefficient").execute(*args, **kwargs)
                    def mass_coefficient(self, *args, **kwargs):
                        """
                        Sets the mass coefficient (  in  in the Theory Guide).
                        """
                        return PyMenu(self.service, "/define/models/dpm/stripping_options/mass_coefficient").execute(*args, **kwargs)

                class interaction(TUIMenu):
                    """
                    Sets parameters for coupled discrete phase calculations.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def update_dpm_sources_every_flow_iteration(self, *args, **kwargs):
                        """
                        Enables/disables the update of DPM source terms every flow iteration (if this option is not enabled, the terms will be updated every DPM iteration).
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/update_dpm_sources_every_flow_iteration").execute(*args, **kwargs)
                    def max_vf_allowed_for_blocking(self, *args, **kwargs):
                        """
                        Maximum DPM volume fraction used in continuous flow.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/max_vf_allowed_for_blocking").execute(*args, **kwargs)
                    def keep_linearized_dpm_source_terms_constant(self, *args, **kwargs):
                        """
                        Keep linearized DPM source terms constant until the next DPM Update.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/keep_linearized_dpm_source_terms_constant").execute(*args, **kwargs)
                    def choice_of_eulerian_phase_for_interaction(self, *args, **kwargs):
                        """
                        Enable/disable the option to choose for every injection the Eulerian phase for the DPM continuous phase interaction.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/choice_of_eulerian_phase_for_interaction").execute(*args, **kwargs)
                    def linearized_dpm_mixture_fraction_source_terms(self, *args, **kwargs):
                        """
                        Enables/disables linearization of mixture fraction source terms. This command is available only for non- or partially-premixed combustion cases.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/linearized_dpm_mixture_fraction_source_terms").execute(*args, **kwargs)
                    def dpm_iteration_interval(self, *args, **kwargs):
                        """
                        Sets the frequency with which the particle trajectory calculations are introduced.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/dpm_iteration_interval").execute(*args, **kwargs)
                    def linearized_dpm_species_source_terms(self, *args, **kwargs):
                        """
                        Perform linearization of species source terms.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/linearized_dpm_species_source_terms").execute(*args, **kwargs)
                    def linearized_dpm_source_terms(self, *args, **kwargs):
                        """
                        Enables/disables linearization of source terms for the discrete phase.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/linearized_dpm_source_terms").execute(*args, **kwargs)
                    def enable_drag_scaling_due_to_flow_blocking(self, *args, **kwargs):
                        """
                        Enable/disable scaling of DPM drag coefficient due to inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/enable_drag_scaling_due_to_flow_blocking").execute(*args, **kwargs)
                    def linearized_dpm_source_terms_limiter(self, *args, **kwargs):
                        """
                        Relative limit for DPM source linear coefficient with respect to fluid linear Ap coefficient.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/linearized_dpm_source_terms_limiter").execute(*args, **kwargs)
                    def implicit_momentum_coupling(self, *args, **kwargs):
                        """
                        Enables/disables implicit treatment for the DPM momentum source terms.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/implicit_momentum_coupling").execute(*args, **kwargs)
                    def underrelaxation_factor(self, *args, **kwargs):
                        """
                        Sets the under-relaxation factor for the discrete phase sources.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/underrelaxation_factor").execute(*args, **kwargs)
                    def reset_sources_at_timestep(self, *args, **kwargs):
                        """
                        Enables/disables flush of DPM source terms at beginning of every time step.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/reset_sources_at_timestep").execute(*args, **kwargs)
                    def linear_growth_of_dpm_source_term(self, *args, **kwargs):
                        """
                        Enables/disables the linear ramping up of the DPM source terms at every DPM iteration.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/linear_growth_of_dpm_source_term").execute(*args, **kwargs)
                    def ddpm_iad_particle(self, *args, **kwargs):
                        """
                        Enable/disable the non-default interfacial area method IA-particle.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/ddpm_iad_particle").execute(*args, **kwargs)
                    def ddpm_energy_coupling_via_source_term(self, *args, **kwargs):
                        """
                        Energy coupling in DDPM established via source term.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/ddpm_energy_coupling_via_source_term").execute(*args, **kwargs)
                    def replace_dpm_mass_source_by_mixture_fraction(self, *args, **kwargs):
                        """
                        When enabled, recalculates the mixture fraction source terms as a function of the primary mixture fraction. This command is available for non- or partially-premixed combustion cases only.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/replace_dpm_mass_source_by_mixture_fraction").execute(*args, **kwargs)
                    def implicit_source_term_coupling(self, *args, **kwargs):
                        """
                        Enables/disables implicit treatment for all DPM source terms.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/implicit_source_term_coupling").execute(*args, **kwargs)
                    def enable_flow_blocking_by_particles(self, *args, **kwargs):
                        """
                        Enable/disable inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/enable_flow_blocking_by_particles").execute(*args, **kwargs)
                    def coupled_calculations(self, *args, **kwargs):
                        """
                        Selects whether or not to couple continuous and discrete phase calculations.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/coupled_calculations").execute(*args, **kwargs)
                    def min_vf_threshold_for_dpm_src_scaling(self, *args, **kwargs):
                        """
                        Minimum DPM volume fraction below which no DPM source scaling is applied.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/min_vf_threshold_for_dpm_src_scaling").execute(*args, **kwargs)
                    def enable_source_scaling_due_to_flow_blocking(self, *args, **kwargs):
                        """
                        Enable/disable scaling of DPM source terms due to inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/enable_source_scaling_due_to_flow_blocking").execute(*args, **kwargs)
                    def ddpm_enhanced_inter_phase_exchange(self, *args, **kwargs):
                        """
                        Enhanced Eulerian inter-phase exchange.
                        """
                        return PyMenu(self.service, "/define/models/dpm/interaction/ddpm_enhanced_inter_phase_exchange").execute(*args, **kwargs)

            class solver(TUIMenu):
                """
                Enters the menu to select the solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def adjust_solver_defaults_based_on_setup(self, *args, **kwargs):
                    """
                    Enable/disable adjustment of solver defaults based on setup.
                    """
                    return PyMenu(self.service, "/define/models/solver/adjust_solver_defaults_based_on_setup").execute(*args, **kwargs)
                def density_based_implicit(self, *args, **kwargs):
                    """
                    Enables/disables the density-based-implicit solver.
                    """
                    return PyMenu(self.service, "/define/models/solver/density_based_implicit").execute(*args, **kwargs)
                def pressure_based(self, *args, **kwargs):
                    """
                    Enables/disables the pressure-based solver.
                    """
                    return PyMenu(self.service, "/define/models/solver/pressure_based").execute(*args, **kwargs)
                def density_based_explicit(self, *args, **kwargs):
                    """
                    Enables/disables the density-based-explicit solver.
                    """
                    return PyMenu(self.service, "/define/models/solver/density_based_explicit").execute(*args, **kwargs)

            class shell_conduction(TUIMenu):
                """
                Enters the shell conduction models menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def multi_layer_shell(self, *args, **kwargs):
                    """
                    Enables/disables the ability to define multi-layer 	shell conduction for walls. Note that the warped-face 	gradient correction (WFGC) is not supported when 	multi-layer shells are disabled.
                    """
                    return PyMenu(self.service, "/define/models/shell_conduction/multi_layer_shell").execute(*args, **kwargs)
                def enhanced_encapsulation(self, *args, **kwargs):
                    """
                    Enables/disables an enhanced routine for the encapsulation of coupled walls during 	mesh partitioning that is enabled by default when shell 	conduction and/or the surface to surface (S2S) radiation 	model is used.
                    """
                    return PyMenu(self.service, "/define/models/shell_conduction/enhanced_encapsulation").execute(*args, **kwargs)
                def write_csv(self, *args, **kwargs):
                    """
                    Writes your saved shell conduction settings to a CSV file.
                    """
                    return PyMenu(self.service, "/define/models/shell_conduction/write_csv").execute(*args, **kwargs)
                def save_shell_zones(self, *args, **kwargs):
                    """
                    Enables the saving of shell zones to case 	files.
                    """
                    return PyMenu(self.service, "/define/models/shell_conduction/save_shell_zones").execute(*args, **kwargs)
                def settings(self, *args, **kwargs):
                    """
                    Enables shell conduction and defines the settings for any wall or group of walls by 	manually entering the number and properties of the 	layers.
                    """
                    return PyMenu(self.service, "/define/models/shell_conduction/settings").execute(*args, **kwargs)
                def read_csv(self, *args, **kwargs):
                    """
                    Defines the shell conduction settings by reading a CSV file.
                    """
                    return PyMenu(self.service, "/define/models/shell_conduction/read_csv").execute(*args, **kwargs)

            class optics(TUIMenu):
                """
                Enter the optics model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.statistics = self.__class__.statistics(path + ["statistics"], service)
                    self.beams = self.__class__.beams(path + ["beams"], service)
                    super().__init__(path, service)
                def index_of_refraction(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/index_of_refraction").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/enable").execute(*args, **kwargs)
                def report(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/report").execute(*args, **kwargs)
                def sampling_iterations(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/sampling_iterations").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/define/models/optics/verbosity").execute(*args, **kwargs)

                class statistics(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def reset_statistics(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/define/models/optics/statistics/reset_statistics").execute(*args, **kwargs)
                    def statistics_controls(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/define/models/optics/statistics/statistics_controls").execute(*args, **kwargs)

                class beams(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def rename(self, *args, **kwargs):
                        """
                        Rename object.
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/rename").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Create a new beams object.
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/add").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete object.
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/delete").execute(*args, **kwargs)
                    def copy(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/copy").execute(*args, **kwargs)
                    def list_beam_parameters(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/list_beam_parameters").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edit beams object.
                        """
                        return PyMenu(self.service, "/define/models/optics/beams/edit").execute(*args, **kwargs)

            class radiation(TUIMenu):
                """
                Enters the radiation models menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.solar_parameters = self.__class__.solar_parameters(path + ["solar_parameters"], service)
                    self.dtrm_parameters = self.__class__.dtrm_parameters(path + ["dtrm_parameters"], service)
                    self.s2s_parameters = self.__class__.s2s_parameters(path + ["s2s_parameters"], service)
                    super().__init__(path, service)
                def mc_model_parameters(self, *args, **kwargs):
                    """
                    Specifies Monte Carlo model parameters. This text command is available only when the 	Monte Carlo model is enabled.
                    """
                    return PyMenu(self.service, "/define/models/radiation/mc_model_parameters").execute(*args, **kwargs)
                def fast_second_order_discrete_ordinate(self, *args, **kwargs):
                    """
                    Enables/disables the fast-second-order option for Discrete Ordinate Model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/fast_second_order_discrete_ordinate").execute(*args, **kwargs)
                def radiation_model_parameters(self, *args, **kwargs):
                    """
                    Set parameters for radiation models.
                    """
                    return PyMenu(self.service, "/define/models/radiation/radiation_model_parameters").execute(*args, **kwargs)
                def montecarlo(self, *args, **kwargs):
                    """
                    Enables/disables the Monte Carlo radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/montecarlo").execute(*args, **kwargs)
                def solution_method_for_do_coupling(self, *args, **kwargs):
                    """
                    Enables/disables the solution method for DO/energy coupling.
                    """
                    return PyMenu(self.service, "/define/models/radiation/solution_method_for_do_coupling").execute(*args, **kwargs)
                def target_cells_per_volume_cluster(self, *args, **kwargs):
                    """
                    Sets the amount of coarsening of the radiation mesh 	for the Monte Carlo radiation model. A number greater 	than one implies coarsening, whereas equal to one 	implies no coarsening.
                    """
                    return PyMenu(self.service, "/define/models/radiation/target_cells_per_volume_cluster").execute(*args, **kwargs)
                def do_acceleration(self, *args, **kwargs):
                    """
                    Enables/disables the acceleration of the discrete 	ordinates (DO) radiation model calculations. Note that 	this text command is only available when running on 	Linux in parallel.
                    """
                    return PyMenu(self.service, "/define/models/radiation/do_acceleration").execute(*args, **kwargs)
                def discrete_ordinates(self, *args, **kwargs):
                    """
                    Enables/disables discrete ordinates radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/discrete_ordinates").execute(*args, **kwargs)
                def blending_factor(self, *args, **kwargs):
                    """
                    Sets numeric option for Discrete Ordinate model. Make sure thatSecond Order Upwind is selected for the Discrete Ordinates spatial 	discretization for the blending-factor option to 	appear in the text command list.
                    """
                    return PyMenu(self.service, "/define/models/radiation/blending_factor").execute(*args, **kwargs)
                def beta_radiation_features(self, *args, **kwargs):
                    """
                    Enable Radiation Models with Non-Iterative Time Advancement (NITA) as Beta features in FL12.0.
                    """
                    return PyMenu(self.service, "/define/models/radiation/beta_radiation_features").execute(*args, **kwargs)
                def wsggm_cell_based(self, *args, **kwargs):
                    """
                    Enables/disables WSGGM cell based method. Note that when enabled, the wsggm-cell-based option will 	become available in theAbsorption Coefficient drop-down list in the Create/Edit Materials dialog 	box.
                    """
                    return PyMenu(self.service, "/define/models/radiation/wsggm_cell_based").execute(*args, **kwargs)
                def p1(self, *args, **kwargs):
                    """
                    Enables/disables P1 radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/p1").execute(*args, **kwargs)
                def radiation_iteration_parameters(self, *args, **kwargs):
                    """
                    Sets iteration parameters for radiation models.
                    """
                    return PyMenu(self.service, "/define/models/radiation/radiation_iteration_parameters").execute(*args, **kwargs)
                def discrete_transfer(self, *args, **kwargs):
                    """
                    Enables/disables discrete transfer radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/discrete_transfer").execute(*args, **kwargs)
                def solar_calculator(self, *args, **kwargs):
                    """
                    Calculates sun direction and intensity.
                    """
                    return PyMenu(self.service, "/define/models/radiation/solar_calculator").execute(*args, **kwargs)
                def apply_full_solar_irradiation(self, *args, **kwargs):
                    """
                    Enables/disables the application of the complete solar load to the first wavelength 	band only, reverting to the pre-2019 R1 behavior of the 	Solar Load and Discrete Ordinates models.
                    """
                    return PyMenu(self.service, "/define/models/radiation/apply_full_solar_irradiation").execute(*args, **kwargs)
                def solar(self, *args, **kwargs):
                    """
                    Enables/disables solar model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/solar").execute(*args, **kwargs)
                def rosseland(self, *args, **kwargs):
                    """
                    Enables/disables Rosseland radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/rosseland").execute(*args, **kwargs)
                def mc_under_relaxation(self, *args, **kwargs):
                    """
                    Sets the under-relaxation factor for Monte Carlo radiation sources used in the 	energy equation.
                    """
                    return PyMenu(self.service, "/define/models/radiation/mc_under_relaxation").execute(*args, **kwargs)
                def do_coupling(self, *args, **kwargs):
                    """
                    Enables/disables DO/energy coupling.
                    """
                    return PyMenu(self.service, "/define/models/radiation/do_coupling").execute(*args, **kwargs)
                def non_gray_model_parameters(self, *args, **kwargs):
                    """
                    Sets parameters for non-gray model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/non_gray_model_parameters").execute(*args, **kwargs)
                def method_partially_specular_wall(self, *args, **kwargs):
                    """
                    Sets the method for partially specular wall with discrete ordinate model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/method_partially_specular_wall").execute(*args, **kwargs)
                def solar_irradiation(self, *args, **kwargs):
                    """
                    Enables/disables the solar irradiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/solar_irradiation").execute(*args, **kwargs)
                def s2s(self, *args, **kwargs):
                    """
                    Enables/disables S2S radiation model.
                    """
                    return PyMenu(self.service, "/define/models/radiation/s2s").execute(*args, **kwargs)

                class solar_parameters(TUIMenu):
                    """
                    Enters the solar parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def solar_thread_control(self, *args, **kwargs):
                        """
                        Sets the number of threads to run the solar flux calculation. This item appears only when running in parallel with nodes located on a separate machine from the one running the host process andSolar Ray Tracing is enabled.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/solar_thread_control").execute(*args, **kwargs)
                    def use_direction_from_sol_calc(self, *args, **kwargs):
                        """
                        Sets direction computed from solar calculator.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/use_direction_from_sol_calc").execute(*args, **kwargs)
                    def scattering_fraction(self, *args, **kwargs):
                        """
                        Sets scattering fraction parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/scattering_fraction").execute(*args, **kwargs)
                    def sun_direction_vector(self, *args, **kwargs):
                        """
                        Sets sun direction vector.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/sun_direction_vector").execute(*args, **kwargs)
                    def autoread_solar_data(self, *args, **kwargs):
                        """
                        Sets autoread solar data parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/autoread_solar_data").execute(*args, **kwargs)
                    def sol_adjacent_fluidcells(self, *args, **kwargs):
                        """
                        Sets solar load on for adjacent fluid cells.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/sol_adjacent_fluidcells").execute(*args, **kwargs)
                    def quad_tree_parameters(self, *args, **kwargs):
                        """
                        Sets quad-tree refinement parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/quad_tree_parameters").execute(*args, **kwargs)
                    def autosave_solar_data(self, *args, **kwargs):
                        """
                        Sets autosave solar data parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/autosave_solar_data").execute(*args, **kwargs)
                    def illumination_parameters(self, *args, **kwargs):
                        """
                        Sets illumination parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/illumination_parameters").execute(*args, **kwargs)
                    def sol_camera_pos(self, *args, **kwargs):
                        """
                        Sets camera position based on sun direction vector.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/sol_camera_pos").execute(*args, **kwargs)
                    def ground_reflectivity(self, *args, **kwargs):
                        """
                        Sets ground reflectivity parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/ground_reflectivity").execute(*args, **kwargs)
                    def sol_on_demand(self, *args, **kwargs):
                        """
                        Sets solar load on demand.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/sol_on_demand").execute(*args, **kwargs)
                    def iteration_parameters(self, *args, **kwargs):
                        """
                        Sets update parameters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/solar_parameters/iteration_parameters").execute(*args, **kwargs)

                class dtrm_parameters(TUIMenu):
                    """
                    Enters the dtrm parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ray_trace(self, *args, **kwargs):
                        """
                        Creates DTRM rays for radiation.
                        """
                        return PyMenu(self.service, "/define/models/radiation/dtrm_parameters/ray_trace").execute(*args, **kwargs)
                    def controls(self, *args, **kwargs):
                        """
                        Sets dtrm solution controls.
                        """
                        return PyMenu(self.service, "/define/models/radiation/dtrm_parameters/controls").execute(*args, **kwargs)
                    def check_ray_file(self, *args, **kwargs):
                        """
                        Reads DTRM rays file.
                        """
                        return PyMenu(self.service, "/define/models/radiation/dtrm_parameters/check_ray_file").execute(*args, **kwargs)
                    def make_globs(self, *args, **kwargs):
                        """
                        Makes globs (coarser mesh) for radiation.
                        """
                        return PyMenu(self.service, "/define/models/radiation/dtrm_parameters/make_globs").execute(*args, **kwargs)

                class s2s_parameters(TUIMenu):
                    """
                    Enters the S2S parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def read_vf_file(self, *args, **kwargs):
                        """
                        Reads S2S file.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/read_vf_file").execute(*args, **kwargs)
                    def non_participating_boundary_zones_temperature(self, *args, **kwargs):
                        """
                        Sets temperature for the non-participating boundary zones.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/non_participating_boundary_zones_temperature").execute(*args, **kwargs)
                    def compute_vf_only(self, *args, **kwargs):
                        """
                        Computes/writes view factors only.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_vf_only").execute(*args, **kwargs)
                    def use_new_cluster_algorithm(self, *args, **kwargs):
                        """
                        Uses the new surface clustering algorithm.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/use_new_cluster_algorithm").execute(*args, **kwargs)
                    def print_thread_clusters(self, *args, **kwargs):
                        """
                        Prints the following for all boundary threads: thread-id, number of faces, faces per surface cluster, and the number of surface clusters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/print_thread_clusters").execute(*args, **kwargs)
                    def split_angle(self, *args, **kwargs):
                        """
                        Sets split angle for the clustering algorithm.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/split_angle").execute(*args, **kwargs)
                    def set_global_faces_per_surface_cluster(self, *args, **kwargs):
                        """
                        Sets global value of faces per surface cluster for all boundary zones.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/set_global_faces_per_surface_cluster").execute(*args, **kwargs)
                    def print_zonewise_radiation(self, *args, **kwargs):
                        """
                        Prints the zonewise incoming radiation, viewfactors, and average temperature.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/print_zonewise_radiation").execute(*args, **kwargs)
                    def compute_fpsc_values(self, *args, **kwargs):
                        """
                        Computes only fpsc values based on current settings.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_fpsc_values").execute(*args, **kwargs)
                    def compute_write_vf(self, *args, **kwargs):
                        """
                        Computes/writes surface clusters and view factors for S2S radiation model.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_write_vf").execute(*args, **kwargs)
                    def enable_mesh_interface_clustering(self, *args, **kwargs):
                        """
                        Enables surface clusters on mesh interfaces.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/enable_mesh_interface_clustering").execute(*args, **kwargs)
                    def use_old_cluster_algorithm(self, *args, **kwargs):
                        """
                        Uses the old surface clustering algorithm.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/use_old_cluster_algorithm").execute(*args, **kwargs)
                    def compute_clusters_and_vf_accelerated(self, *args, **kwargs):
                        """
                        Compute/Write surface cluster first and then view factors.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_clusters_and_vf_accelerated").execute(*args, **kwargs)
                    def set_vf_parameters(self, *args, **kwargs):
                        """
                        Sets the parameters needed for the viewfactor calculations.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/set_vf_parameters").execute(*args, **kwargs)
                    def compute_vf_accelerated(self, *args, **kwargs):
                        """
                        Compute/Write view factors from existing surface clusters.
                        """
                        return PyMenu(self.service, "/define/models/radiation/s2s_parameters/compute_vf_accelerated").execute(*args, **kwargs)

            class nox_parameters(TUIMenu):
                """
                Enters the NOx parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def nox_turbulence_interaction(self, *args, **kwargs):
                    """
                    Sets NOx turbulence interaction model.
                    """
                    return PyMenu(self.service, "/define/models/nox_parameters/nox_turbulence_interaction").execute(*args, **kwargs)
                def nox_expert(self, *args, **kwargs):
                    """
                    Selects additional NOx equations.
                    """
                    return PyMenu(self.service, "/define/models/nox_parameters/nox_expert").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enables/disables inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/define/models/nox_parameters/inlet_diffusion").execute(*args, **kwargs)
                def nox_chemistry(self, *args, **kwargs):
                    """
                    Selects NOx chemistry model.
                    """
                    return PyMenu(self.service, "/define/models/nox_parameters/nox_chemistry").execute(*args, **kwargs)

            class structure(TUIMenu):
                """
                Enters the structure model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.controls = self.__class__.controls(path + ["controls"], service)
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def linear_elasticity(self, *args, **kwargs):
                    """
                    Enables the linear elasticity model.
                    """
                    return PyMenu(self.service, "/define/models/structure/linear_elasticity").execute(*args, **kwargs)
                def structure_off(self, *args, **kwargs):
                    """
                    Disables the structural model.
                    """
                    return PyMenu(self.service, "/define/models/structure/structure_off").execute(*args, **kwargs)
                def thermal_effects(self, *args, **kwargs):
                    """
                    Enable structure thermal effects.
                    """
                    return PyMenu(self.service, "/define/models/structure/thermal_effects").execute(*args, **kwargs)
                def nonlinear_elasticity(self, *args, **kwargs):
                    """
                    Enable the nonlinear elasticity model.
                    """
                    return PyMenu(self.service, "/define/models/structure/nonlinear_elasticity").execute(*args, **kwargs)

                class controls(TUIMenu):
                    """
                    Enters the structure controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def amg_stabilization(self, *args, **kwargs):
                        """
                        Sets the algebraic multigrid (AMG) stabilization method for the structural model calculations.
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/amg_stabilization").execute(*args, **kwargs)
                    def max_iter(self, *args, **kwargs):
                        """
                        Sets the maximum number of iterations for the structural model calculations.
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/max_iter").execute(*args, **kwargs)
                    def numerical_damping_factor(self, *args, **kwargs):
                        """
                        Sets the damping factor for the structural model (that is, the amplitude decay factor  in  in the Theory Guide).
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/numerical_damping_factor").execute(*args, **kwargs)
                    def enhanced_strain(self, *args, **kwargs):
                        """
                        Enable enhanced strain element.
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/enhanced_strain").execute(*args, **kwargs)
                    def unsteady_damping_rayleigh(self, *args, **kwargs):
                        """
                        Enable/disable Newmark unsteady solution model.
                        """
                        return PyMenu(self.service, "/define/models/structure/controls/unsteady_damping_rayleigh").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enters the structure expert menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def starting_t_re_initialization(self, *args, **kwargs):
                        """
                        Set starting T-field re-initialization method.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/starting_t_re_initialization").execute(*args, **kwargs)
                    def include_pop_in_fsi_force(self, *args, **kwargs):
                        """
                        Enables/disables the inclusion of operating pressure into the fluid-structure interaction force.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/include_pop_in_fsi_force").execute(*args, **kwargs)
                    def explicit_fsi_force(self, *args, **kwargs):
                        """
                        Enables/disables an explicit fluid-structure interaction force.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/explicit_fsi_force").execute(*args, **kwargs)
                    def include_viscous_fsi_force(self, *args, **kwargs):
                        """
                        Enables/disables the inclusion of a viscous fluid-structure interaction force.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/include_viscous_fsi_force").execute(*args, **kwargs)
                    def steady_2way_fsi(self, *args, **kwargs):
                        """
                        Enable steady 2-way fsi workflow.
                        """
                        return PyMenu(self.service, "/define/models/structure/expert/steady_2way_fsi").execute(*args, **kwargs)

            class two_temperature(TUIMenu):
                """
                Enters the Two-Temperature model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Specifies the level of detail printed in the console 	about the Two-Temperature model. For a verbosity of one, 	Fluent will print the number of cells that reach the 	temperature limit, have an excessive temperature change, 	or get a negative temperature.
                    """
                    return PyMenu(self.service, "/define/models/two_temperature/set_verbosity").execute(*args, **kwargs)
                def weak_ionization(self, *args, **kwargs):
                    """
                    Apply weak ionization in the two-temperature model.
                    """
                    return PyMenu(self.service, "/define/models/two_temperature/weak_ionization").execute(*args, **kwargs)
                def robustness_enhancement(self, *args, **kwargs):
                    """
                    Enables/disables the robustness enhancement, which is 	on by default.
                    """
                    return PyMenu(self.service, "/define/models/two_temperature/robustness_enhancement").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables the Two-Temperature model.
                    """
                    return PyMenu(self.service, "/define/models/two_temperature/enable").execute(*args, **kwargs)
                def nasa9_enhancement(self, *args, **kwargs):
                    """
                    Apply nasa9 robustness enhancements in the two-temperature model.
                    """
                    return PyMenu(self.service, "/define/models/two_temperature/nasa9_enhancement").execute(*args, **kwargs)

            class acoustics(TUIMenu):
                """
                Enters the acoustics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.far_field_parameters = self.__class__.far_field_parameters(path + ["far_field_parameters"], service)
                    self.wave_equation_options = self.__class__.wave_equation_options(path + ["wave_equation_options"], service)
                    self.sources_fft = self.__class__.sources_fft(path + ["sources_fft"], service)
                    self.sponge_layers = self.__class__.sponge_layers(path + ["sponge_layers"], service)
                    super().__init__(path, service)
                def off(self, *args, **kwargs):
                    """
                    Enables/disables the acoustics model.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/off").execute(*args, **kwargs)
                def acoustic_modal_analysis(self, *args, **kwargs):
                    """
                    Iterate linear acoustic solver to compute the resonance frequencies and the acoustic modes.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/acoustic_modal_analysis").execute(*args, **kwargs)
                def moving_receiver(self, *args, **kwargs):
                    """
                    Enables/disables the moving receiver option.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/moving_receiver").execute(*args, **kwargs)
                def export_source_data(self, *args, **kwargs):
                    """
                    Enables/disables the export of acoustic source data in 	ASD format during the wave equation model run.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/export_source_data").execute(*args, **kwargs)
                def compute_write(self, *args, **kwargs):
                    """
                    Computes sound pressure.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/compute_write").execute(*args, **kwargs)
                def broad_band_noise(self, *args, **kwargs):
                    """
                    Enables/disables the broadband noise model.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/broad_band_noise").execute(*args, **kwargs)
                def read_compute_write(self, *args, **kwargs):
                    """
                    Reads acoustic source data files and computes sound pressure.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/read_compute_write").execute(*args, **kwargs)
                def auto_prune(self, *args, **kwargs):
                    """
                    Enables/disables auto prune of the receiver signal(s) during 	read-and-compute.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/auto_prune").execute(*args, **kwargs)
                def ffowcs_williams(self, *args, **kwargs):
                    """
                    Enables/disables the Ffowcs-Williams-and-Hawkings model.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/ffowcs_williams").execute(*args, **kwargs)
                def export_source_data_cgns(self, *args, **kwargs):
                    """
                    Enables/disables the export of acoustic source data in CGNS format.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/export_source_data_cgns").execute(*args, **kwargs)
                def cylindrical_export(self, *args, **kwargs):
                    """
                    Enables/disables the export of data in cylindrical coordinates.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/cylindrical_export").execute(*args, **kwargs)
                def export_volumetric_sources_cgns(self, *args, **kwargs):
                    """
                    Enables/disables the export of fluid zones.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/export_volumetric_sources_cgns").execute(*args, **kwargs)
                def convective_effects(self, *args, **kwargs):
                    """
                    Enables/disables the convective effects option.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/convective_effects").execute(*args, **kwargs)
                def receivers(self, *args, **kwargs):
                    """
                    Sets acoustic receivers.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/receivers").execute(*args, **kwargs)
                def wave_equation(self, *args, **kwargs):
                    """
                    Enables/disables the wave equation model.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/wave_equation").execute(*args, **kwargs)
                def export_volumetric_sources(self, *args, **kwargs):
                    """
                    Enables/disables the export of fluid zones.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/export_volumetric_sources").execute(*args, **kwargs)
                def display_flow_time(self, *args, **kwargs):
                    """
                    Enables/disables the display of flow time during read-and-compute.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/display_flow_time").execute(*args, **kwargs)
                def write_acoustic_signals(self, *args, **kwargs):
                    """
                    Writes on-the-fly sound pressure.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/write_acoustic_signals").execute(*args, **kwargs)
                def sources(self, *args, **kwargs):
                    """
                    Sets acoustic sources.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/sources").execute(*args, **kwargs)
                def write_centroid_info(self, *args, **kwargs):
                    """
                    Writes centroid info.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/write_centroid_info").execute(*args, **kwargs)
                def display_frequencies(self, *args, **kwargs):
                    """
                    Display resonance frequencies.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/display_frequencies").execute(*args, **kwargs)
                def modal_analysis(self, *args, **kwargs):
                    """
                    Enable/disable the modal analysis model.
                    """
                    return PyMenu(self.service, "/define/models/acoustics/modal_analysis").execute(*args, **kwargs)

                class far_field_parameters(TUIMenu):
                    """
                    Enters the menu to specify the far-field density and 	speed of sound. Note that this menu is currently 	available only with the acoustics wave equation model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def far_field_sound_speed(self, *args, **kwargs):
                        """
                        Specifies the far-field speed of sound value for the acoustics wave equation model.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/far_field_parameters/far_field_sound_speed").execute(*args, **kwargs)
                    def far_field_density(self, *args, **kwargs):
                        """
                        Specifies the far-field density value for the acoustics wave equation model.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/far_field_parameters/far_field_density").execute(*args, **kwargs)

                class wave_equation_options(TUIMenu):
                    """
                    Enters the menu to define the acoustics wave equation 	model options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.remote_receivers_options = self.__class__.remote_receivers_options(path + ["remote_receivers_options"], service)
                        self.basic_shapes = self.__class__.basic_shapes(path + ["basic_shapes"], service)
                        super().__init__(path, service)
                    def time_filter_source(self, *args, **kwargs):
                        """
                        Enables/disables a time filter for the sound source.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/time_filter_source").execute(*args, **kwargs)
                    def remote_receivers(self, *args, **kwargs):
                        """
                        Enables/disables the Kirchhoff integral model.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/remote_receivers").execute(*args, **kwargs)
                    def sponge_layer_base_level(self, *args, **kwargs):
                        """
                        Specify artificial viscosity base level applied everywhere.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/sponge_layer_base_level").execute(*args, **kwargs)
                    def source_mask_udf(self, *args, **kwargs):
                        """
                        Specifies the name of a user-defined function, which defines geometry of the source mask.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/source_mask_udf").execute(*args, **kwargs)
                    def sponge_layer_factor(self, *args, **kwargs):
                        """
                        Specifies the factor of the artificial viscosity coefficient.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/sponge_layer_factor").execute(*args, **kwargs)
                    def sponge_layer_udf(self, *args, **kwargs):
                        """
                        Specifies the name of a user-defined function, which defines geometry of the sponge layer.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/sponge_layer_udf").execute(*args, **kwargs)

                    class remote_receivers_options(TUIMenu):
                        """
                        Enters the menu to define remote receivers for the Kirchhoff integral model.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def integration_surface(self, *args, **kwargs):
                            """
                            Selects the integration surface for the Kirchhoff model.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/remote_receivers_options/integration_surface").execute(*args, **kwargs)
                        def write_signals(self, *args, **kwargs):
                            """
                            Writes the computed receiver signals to the ASCII files.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/remote_receivers_options/write_signals").execute(*args, **kwargs)

                    class basic_shapes(TUIMenu):
                        """
                        Enters the menu to define the geometry of the source mask and sponge layer using the basic shapes, represented by the cell registers of the type "Region".
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def remove_source_mask_shape(self, *args, **kwargs):
                            """
                            Remove a basic shape from the definition of the source mask geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/remove_source_mask_shape").execute(*args, **kwargs)
                        def list_region_registers(self, *args, **kwargs):
                            """
                            List all available cell registers of the type "Region".
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/list_region_registers").execute(*args, **kwargs)
                        def add_source_mask_shape(self, *args, **kwargs):
                            """
                            Adds a basic shape to the definition of the source mask geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/add_source_mask_shape").execute(*args, **kwargs)
                        def list_sponge_layer_shapes(self, *args, **kwargs):
                            """
                            List basic shapes, which are currently used in the definition of the sponge layer geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/list_sponge_layer_shapes").execute(*args, **kwargs)
                        def remove_sponge_layer_shape(self, *args, **kwargs):
                            """
                            Remove a basic shape from the definition of the sponge layer geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/remove_sponge_layer_shape").execute(*args, **kwargs)
                        def add_sponge_layer_shape(self, *args, **kwargs):
                            """
                            Adds a basic shape to the definition of the sponge layer geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/add_sponge_layer_shape").execute(*args, **kwargs)
                        def list_source_mask_shapes(self, *args, **kwargs):
                            """
                            List basic shapes, which are currently used in the definition of the source mask geometry.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/wave_equation_options/basic_shapes/list_source_mask_shapes").execute(*args, **kwargs)

                class sources_fft(TUIMenu):
                    """
                    Enters the acoustic sources fast Fourier transform (FFT) menu, to compute Fourier 	spectra from acoustic source data (ASD) files, create 	postprocessing variables for the pressure signals, and 	write CGNS files of the spectrum data.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.fft_surface_variables = self.__class__.fft_surface_variables(path + ["fft_surface_variables"], service)
                        super().__init__(path, service)
                    def read_asd_files(self, *args, **kwargs):
                        """
                        Reads ASD files to perform FFT of the pressure history field.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sources_fft/read_asd_files").execute(*args, **kwargs)
                    def clean_up_storage_area(self, *args, **kwargs):
                        """
                        De-allocates memory used to store the pressure histories and their Fourier spectra, as well as any created surface variables for the visualization.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sources_fft/clean_up_storage_area").execute(*args, **kwargs)
                    def compute_fft_fields(self, *args, **kwargs):
                        """
                        Computes FFT of the read pressure histories. The computed spectra replace the pressure histories in memory.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sources_fft/compute_fft_fields").execute(*args, **kwargs)
                    def write_cgns_files(self, *args, **kwargs):
                        """
                        Writes surface pressure spectra in CGNS format, which can be used for one-way coupling with Ansys Mechanical in the frequency domain.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sources_fft/write_cgns_files").execute(*args, **kwargs)

                    class fft_surface_variables(TUIMenu):
                        """
                        Enters the menu to create surface variables from the computed Fourier spectra for visualization.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def create_constant_width_bands(self, *args, **kwargs):
                            """
                            Selects up to 20 constant width bands and creates either the surface pressures level (SPL) variables or the PSD of dp/dt variables for them.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/sources_fft/fft_surface_variables/create_constant_width_bands").execute(*args, **kwargs)
                        def remove_variables(self, *args, **kwargs):
                            """
                            Removes all variables created in this menu.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/sources_fft/fft_surface_variables/remove_variables").execute(*args, **kwargs)
                        def create_set_of_modes(self, *args, **kwargs):
                            """
                            Selects up to 20 individual Fourier modes and create variable pairs for them, containing the real and the imaginary parts of the complex Fourier amplitudes.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/sources_fft/fft_surface_variables/create_set_of_modes").execute(*args, **kwargs)
                        def create_octave_bands(self, *args, **kwargs):
                            """
                            Creates either the surface pressure level (SPL) variables or the PSD of dp/dt variables for 17 technical octaves.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/sources_fft/fft_surface_variables/create_octave_bands").execute(*args, **kwargs)
                        def create_third_bands(self, *args, **kwargs):
                            """
                            Creates either the surface pressure level (SPL) variables or the PSD of dp/dt variables for 54 technical thirds.
                            """
                            return PyMenu(self.service, "/define/models/acoustics/sources_fft/fft_surface_variables/create_third_bands").execute(*args, **kwargs)

                class sponge_layers(TUIMenu):
                    """
                    Manage sponge layers where density is blended to eliminate reflections from boundary zones.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list(self, *args, **kwargs):
                        """
                        Prints a list of the existing sponge layers in the console.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/list").execute(*args, **kwargs)
                    def activate(self, *args, **kwargs):
                        """
                        Activate a sponge object.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/activate").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Deletes an existing sponge layer definition.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/delete").execute(*args, **kwargs)
                    def list_properties(self, *args, **kwargs):
                        """
                        Prints the properties of an existing sponge layer of your choice in the console.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/list_properties").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Add a new sponge layer definition.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/add").execute(*args, **kwargs)
                    def list_active(self, *args, **kwargs):
                        """
                        List the names of the active sponge layer definitions.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/list_active").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edits an existing sponge layer. You can revise the fields listed previously for the define/models/acoustics/sponge-layers/add text command.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/edit").execute(*args, **kwargs)
                    def deactivate(self, *args, **kwargs):
                        """
                        Deactivate a sponge layer definition.
                        """
                        return PyMenu(self.service, "/define/models/acoustics/sponge_layers/deactivate").execute(*args, **kwargs)

            class cht(TUIMenu):
                """
                Enters the cht (conjugate heat transfer) menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.explicit_time_averaged_coupling = self.__class__.explicit_time_averaged_coupling(path + ["explicit_time_averaged_coupling"], service)
                    super().__init__(path, service)
                def read_mi_type_wall(self, *args, **kwargs):
                    """
                    Read mapped interface data settings from a csv file.
                    """
                    return PyMenu(self.service, "/define/models/cht/read_mi_type_wall").execute(*args, **kwargs)
                def write_mi_type_wall(self, *args, **kwargs):
                    """
                    Write mapped interface settings to a scv file.
                    """
                    return PyMenu(self.service, "/define/models/cht/write_mi_type_wall").execute(*args, **kwargs)
                def implicit_coupling(self, *args, **kwargs):
                    """
                    Enables the implicit mapping scheme for any 	fluid-solid pair with a mapped mesh interface (only 	required for cases set up in version 19.2 or 	earlier).
                    """
                    return PyMenu(self.service, "/define/models/cht/implicit_coupling").execute(*args, **kwargs)

                class explicit_time_averaged_coupling(TUIMenu):
                    """
                    Enters the explicit time averaged thermal coupling 	menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def coupling_controls(self, *args, **kwargs):
                        """
                        Specify explcit coupling controls.
                        """
                        return PyMenu(self.service, "/define/models/cht/explicit_time_averaged_coupling/coupling_controls").execute(*args, **kwargs)
                    def conformal_coupled_walls(self, *args, **kwargs):
                        """
                        Select fluid-solid coupled walls (without shell) for explicit coupling using time averaged thermal variables.
                        """
                        return PyMenu(self.service, "/define/models/cht/explicit_time_averaged_coupling/conformal_coupled_walls").execute(*args, **kwargs)
                    def mapped_interfaces(self, *args, **kwargs):
                        """
                        Select fluid-solid mapped interfaces for explicit coupling using time averaged thermal variables.
                        """
                        return PyMenu(self.service, "/define/models/cht/explicit_time_averaged_coupling/mapped_interfaces").execute(*args, **kwargs)
                    def fuse_explicit_cht_zones(self, *args, **kwargs):
                        """
                        Fuse slitted conformal coupled walls marked for transient explicit thermal coupling.
                        """
                        return PyMenu(self.service, "/define/models/cht/explicit_time_averaged_coupling/fuse_explicit_cht_zones").execute(*args, **kwargs)

            class species(TUIMenu):
                """
                Enters the species models menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.CHEMKIN_CFD_parameters = self.__class__.CHEMKIN_CFD_parameters(path + ["CHEMKIN_CFD_parameters"], service)
                    super().__init__(path, service)
                def premixed_combustion(self, *args, **kwargs):
                    """
                    Enables/disables premixed combustion model.
                    """
                    return PyMenu(self.service, "/define/models/species/premixed_combustion").execute(*args, **kwargs)
                def wall_surface_reactions(self, *args, **kwargs):
                    """
                    Enables/disables wall surface reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/wall_surface_reactions").execute(*args, **kwargs)
                def non_premixed_combustion_parameters(self, *args, **kwargs):
                    """
                    Sets PDF parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/non_premixed_combustion_parameters").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enables/disables inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/define/models/species/inlet_diffusion").execute(*args, **kwargs)
                def surf_reaction_aggressiveness_factor(self, *args, **kwargs):
                    """
                    Sets the surface reaction aggressiveness factor.
                    """
                    return PyMenu(self.service, "/define/models/species/surf_reaction_aggressiveness_factor").execute(*args, **kwargs)
                def init_unsteady_flamelet_prob(self, *args, **kwargs):
                    """
                    Initializes Unsteady Flamelet Probability.
                    """
                    return PyMenu(self.service, "/define/models/species/init_unsteady_flamelet_prob").execute(*args, **kwargs)
                def partially_premixed_combustion_expert(self, *args, **kwargs):
                    """
                    Sets PDF expert parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/partially_premixed_combustion_expert").execute(*args, **kwargs)
                def species_transport_expert(self, *args, **kwargs):
                    """
                    Sets the convergence acceleration expert parameters. This command is only available 	when the species transport model is enabled.
                    """
                    return PyMenu(self.service, "/define/models/species/species_transport_expert").execute(*args, **kwargs)
                def relax_to_equil(self, *args, **kwargs):
                    """
                    Enables/disables the Relaxation to Chemical Equilibrium model.
                    """
                    return PyMenu(self.service, "/define/models/species/relax_to_equil").execute(*args, **kwargs)
                def combustion_expert(self, *args, **kwargs):
                    """
                    Enables import of the CHEMKIN mechanism transport 	data. When this option is enabled, you will be prompted 	for importing CHEMKIN transport property database when 	setting your combustion case.
                    """
                    return PyMenu(self.service, "/define/models/species/combustion_expert").execute(*args, **kwargs)
                def full_tabulation(self, *args, **kwargs):
                    """
                    Enables/disables building of a full 2-mixture fraction table.
                    """
                    return PyMenu(self.service, "/define/models/species/full_tabulation").execute(*args, **kwargs)
                def reacting_channel_model(self, *args, **kwargs):
                    """
                    Enables/disables the Reacting Channel Model.
                    """
                    return PyMenu(self.service, "/define/models/species/reacting_channel_model").execute(*args, **kwargs)
                def import_flamelet_for_restart(self, *args, **kwargs):
                    """
                    Imports Flamelet File for Restart.
                    """
                    return PyMenu(self.service, "/define/models/species/import_flamelet_for_restart").execute(*args, **kwargs)
                def reactor_network_model(self, *args, **kwargs):
                    """
                    Enables/disables the Reactor Network Model.
                    """
                    return PyMenu(self.service, "/define/models/species/reactor_network_model").execute(*args, **kwargs)
                def thickened_flame_model(self, *args, **kwargs):
                    """
                    Enables/disables the Relaxation to Chemical Equilibrium model.
                    """
                    return PyMenu(self.service, "/define/models/species/thickened_flame_model").execute(*args, **kwargs)
                def volumetric_reactions(self, *args, **kwargs):
                    """
                    Enables/disables volumetric reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/volumetric_reactions").execute(*args, **kwargs)
                def liquid_energy_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable energy diffusion for liquid regime.
                    """
                    return PyMenu(self.service, "/define/models/species/liquid_energy_diffusion").execute(*args, **kwargs)
                def partially_premixed_properties(self, *args, **kwargs):
                    """
                    Sets/changes partially-premixed mixture properties. 	This command is only available when partially-premixed-combustion? 	is enabled.
                    """
                    return PyMenu(self.service, "/define/models/species/partially_premixed_properties").execute(*args, **kwargs)
                def thermal_diffusion(self, *args, **kwargs):
                    """
                    Enables/disables thermal diffusion.
                    """
                    return PyMenu(self.service, "/define/models/species/thermal_diffusion").execute(*args, **kwargs)
                def set_turb_chem_interaction(self, *args, **kwargs):
                    """
                    Sets EDC model constants.
                    """
                    return PyMenu(self.service, "/define/models/species/set_turb_chem_interaction").execute(*args, **kwargs)
                def clear_isat_table(self, *args, **kwargs):
                    """
                    Clears ISAT table.
                    """
                    return PyMenu(self.service, "/define/models/species/clear_isat_table").execute(*args, **kwargs)
                def partially_premixed_combustion(self, *args, **kwargs):
                    """
                    Enables/disables partially premixed combustion model.
                    """
                    return PyMenu(self.service, "/define/models/species/partially_premixed_combustion").execute(*args, **kwargs)
                def CHEMKIN_CFD(self, *args, **kwargs):
                    """
                    Enables/disables the Ansys CHEMKIN-CFD solver.
                    """
                    return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD").execute(*args, **kwargs)
                def re_calc_par_premix_props(self, *args, **kwargs):
                    """
                    Re-calculate partially-premixed properties.
                    """
                    return PyMenu(self.service, "/define/models/species/re_calc_par_premix_props").execute(*args, **kwargs)
                def electro_chemical_surface_reactions(self, *args, **kwargs):
                    """
                    Enables/disables electrochemical surface reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/electro_chemical_surface_reactions").execute(*args, **kwargs)
                def set_multi_regime_fgm(self, *args, **kwargs):
                    """
                    Set-multi-regim-fgm-parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/set_multi_regime_fgm").execute(*args, **kwargs)
                def pdf_transport_expert(self, *args, **kwargs):
                    """
                    Enables/disables PDF Transport expert user.
                    """
                    return PyMenu(self.service, "/define/models/species/pdf_transport_expert").execute(*args, **kwargs)
                def off(self, *args, **kwargs):
                    """
                    Enables/disables solution of species models.
                    """
                    return PyMenu(self.service, "/define/models/species/off").execute(*args, **kwargs)
                def reaction_diffusion_balance(self, *args, **kwargs):
                    """
                    Enables/disables reaction diffusion balance at reacting surface for surface 	reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/reaction_diffusion_balance").execute(*args, **kwargs)
                def liquid_micro_mixing(self, *args, **kwargs):
                    """
                    Enables/disables liquid micro mixing.
                    """
                    return PyMenu(self.service, "/define/models/species/liquid_micro_mixing").execute(*args, **kwargs)
                def particle_surface_reactions(self, *args, **kwargs):
                    """
                    Enables/disables particle surface reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/particle_surface_reactions").execute(*args, **kwargs)
                def ignition_model(self, *args, **kwargs):
                    """
                    Enables/disables the ignition model.
                    """
                    return PyMenu(self.service, "/define/models/species/ignition_model").execute(*args, **kwargs)
                def partially_premixed_combustion_parameters(self, *args, **kwargs):
                    """
                    Sets PDF parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/partially_premixed_combustion_parameters").execute(*args, **kwargs)
                def premixed_model(self, *args, **kwargs):
                    """
                    Sets premixed combustion model.
                    """
                    return PyMenu(self.service, "/define/models/species/premixed_model").execute(*args, **kwargs)
                def decoupled_detailed_chemistry(self, *args, **kwargs):
                    """
                    Enables/disables the Decoupled Detailed Chemistry model.
                    """
                    return PyMenu(self.service, "/define/models/species/decoupled_detailed_chemistry").execute(*args, **kwargs)
                def diffusion_energy_source(self, *args, **kwargs):
                    """
                    Enables/disables diffusion energy source.
                    """
                    return PyMenu(self.service, "/define/models/species/diffusion_energy_source").execute(*args, **kwargs)
                def species_transport(self, *args, **kwargs):
                    """
                    Enables/disables the species transport model.
                    """
                    return PyMenu(self.service, "/define/models/species/species_transport").execute(*args, **kwargs)
                def species_migration(self, *args, **kwargs):
                    """
                    Includes species migration in electric field. This command is available only when 	the electrochemical surface reactions are 	enabled.
                    """
                    return PyMenu(self.service, "/define/models/species/species_migration").execute(*args, **kwargs)
                def surf_reaction_netm_params(self, *args, **kwargs):
                    """
                    Sets the surface reaction parameters for the Non-Equilibrium Thermal Model.
                    """
                    return PyMenu(self.service, "/define/models/species/surf_reaction_netm_params").execute(*args, **kwargs)
                def save_gradients(self, *args, **kwargs):
                    """
                    Enables/disables storage of species mass fraction gradients.
                    """
                    return PyMenu(self.service, "/define/models/species/save_gradients").execute(*args, **kwargs)
                def mixing_model(self, *args, **kwargs):
                    """
                    Sets PDF Transport mixing model.
                    """
                    return PyMenu(self.service, "/define/models/species/mixing_model").execute(*args, **kwargs)
                def inert_transport_controls(self, *args, **kwargs):
                    """
                    Sets inert transport model parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/inert_transport_controls").execute(*args, **kwargs)
                def inert_transport_model(self, *args, **kwargs):
                    """
                    Enables/disables the inert transport model.
                    """
                    return PyMenu(self.service, "/define/models/species/inert_transport_model").execute(*args, **kwargs)
                def heat_of_surface_reactions(self, *args, **kwargs):
                    """
                    Enables/disables heat of surface reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/heat_of_surface_reactions").execute(*args, **kwargs)
                def flamelet_expert(self, *args, **kwargs):
                    """
                    Sets flamelet expert parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/flamelet_expert").execute(*args, **kwargs)
                def coal_calculator(self, *args, **kwargs):
                    """
                    Sets up coal modeling inputs.
                    """
                    return PyMenu(self.service, "/define/models/species/coal_calculator").execute(*args, **kwargs)
                def ignition_model_controls(self, *args, **kwargs):
                    """
                    Sets ignition model parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/ignition_model_controls").execute(*args, **kwargs)
                def stiff_chemistry(self, *args, **kwargs):
                    """
                    Enables/disables stiff chemistry option.
                    """
                    return PyMenu(self.service, "/define/models/species/stiff_chemistry").execute(*args, **kwargs)
                def integration_parameters(self, *args, **kwargs):
                    """
                    Sets chemistry ODE integrator parameters. Enables/disables stiff chemistry 	acceleration methods and set their parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/integration_parameters").execute(*args, **kwargs)
                def mass_deposition_source(self, *args, **kwargs):
                    """
                    Enables/disables mass deposition source due to surface reactions.
                    """
                    return PyMenu(self.service, "/define/models/species/mass_deposition_source").execute(*args, **kwargs)
                def non_premixed_combustion_expert(self, *args, **kwargs):
                    """
                    Sets PDF expert parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/non_premixed_combustion_expert").execute(*args, **kwargs)
                def epdf_energy(self, *args, **kwargs):
                    """
                    Enables/disables EPDF energy option.
                    """
                    return PyMenu(self.service, "/define/models/species/epdf_energy").execute(*args, **kwargs)
                def spark_model(self, *args, **kwargs):
                    """
                    Switches between the R15 and R14.5 spark models and sets spark model 	parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/spark_model").execute(*args, **kwargs)
                def set_premixed_combustion(self, *args, **kwargs):
                    """
                    Sets premixed combustion parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/set_premixed_combustion").execute(*args, **kwargs)
                def multicomponent_diffusion(self, *args, **kwargs):
                    """
                    Enables/disables multicomponent diffusion.
                    """
                    return PyMenu(self.service, "/define/models/species/multicomponent_diffusion").execute(*args, **kwargs)
                def combustion_numerics(self, *args, **kwargs):
                    """
                    Applies optimal solver settings automatically to provide a faster solution time. 	This command is available only for transient 	non-premixed and partially premixed combustion 	models.
                    """
                    return PyMenu(self.service, "/define/models/species/combustion_numerics").execute(*args, **kwargs)
                def pdf_transport(self, *args, **kwargs):
                    """
                    Enables/disables the composition PDF transport combustion model.
                    """
                    return PyMenu(self.service, "/define/models/species/pdf_transport").execute(*args, **kwargs)
                def reacting_channel_model_options(self, *args, **kwargs):
                    """
                    Sets Reacting Channel Model parameters.
                    """
                    return PyMenu(self.service, "/define/models/species/reacting_channel_model_options").execute(*args, **kwargs)
                def non_premixed_combustion(self, *args, **kwargs):
                    """
                    Enables/disables non-premixed combustion model.
                    """
                    return PyMenu(self.service, "/define/models/species/non_premixed_combustion").execute(*args, **kwargs)
                def partially_premixed_combustion_grids(self, *args, **kwargs):
                    """
                    Sets values for the grid distribution for PDF table or 	flamelet parameter. This text command is available only 	for partially premixed combustion cases with FGM.
                    """
                    return PyMenu(self.service, "/define/models/species/partially_premixed_combustion_grids").execute(*args, **kwargs)

                class CHEMKIN_CFD_parameters(TUIMenu):
                    """
                    Enters the expert CHEMKIN-CFD parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def advanced_options(self, *args, **kwargs):
                        """
                        Sets advanced parameter options.
                        """
                        return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD_parameters/advanced_options").execute(*args, **kwargs)
                    def add_cell_monitor(self, *args, **kwargs):
                        """
                        Monitors cell for debug output.
                        """
                        return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD_parameters/add_cell_monitor").execute(*args, **kwargs)
                    def list_cell_monitors(self, *args, **kwargs):
                        """
                        Lists cell monitors.
                        """
                        return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD_parameters/list_cell_monitors").execute(*args, **kwargs)
                    def basic_options(self, *args, **kwargs):
                        """
                        Sets basic parameter options.
                        """
                        return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD_parameters/basic_options").execute(*args, **kwargs)
                    def delete_cell_monitors(self, *args, **kwargs):
                        """
                        Deletes cell monitors.
                        """
                        return PyMenu(self.service, "/define/models/species/CHEMKIN_CFD_parameters/delete_cell_monitors").execute(*args, **kwargs)

            class viscous(TUIMenu):
                """
                Enters the viscous model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.turbulence_expert = self.__class__.turbulence_expert(path + ["turbulence_expert"], service)
                    self.near_wall_treatment = self.__class__.near_wall_treatment(path + ["near_wall_treatment"], service)
                    self.transition_model_options = self.__class__.transition_model_options(path + ["transition_model_options"], service)
                    self.multiphase_turbulence = self.__class__.multiphase_turbulence(path + ["multiphase_turbulence"], service)
                    self.geko_options = self.__class__.geko_options(path + ["geko_options"], service)
                    super().__init__(path, service)
                def ke1e(self, *args, **kwargs):
                    """
                    Enable/disable the KE1E turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/ke1e").execute(*args, **kwargs)
                def kw_wj_bsl_earsm(self, *args, **kwargs):
                    """
                    Enable/disable the EASM k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/kw_wj_bsl_earsm").execute(*args, **kwargs)
                def mixing_length(self, *args, **kwargs):
                    """
                    Enables/disables mixing-length (algebraic) turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/mixing_length").execute(*args, **kwargs)
                def sas(self, *args, **kwargs):
                    """
                    Enables/disables Scale-Adaptive Simulation (SAS) in combination with the SST  -  turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/sas").execute(*args, **kwargs)
                def les_subgrid_dynamic_fvar(self, *args, **kwargs):
                    """
                    Enables/disables the dynamic subgrid-scale mixture fraction variance model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/les_subgrid_dynamic_fvar").execute(*args, **kwargs)
                def turb_compressibility(self, *args, **kwargs):
                    """
                    Enables/disables the compressibility correction option.
                    """
                    return PyMenu(self.service, "/define/models/viscous/turb_compressibility").execute(*args, **kwargs)
                def v2f(self, *args, **kwargs):
                    """
                    Enables/disables V2F turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/v2f").execute(*args, **kwargs)
                def trans_sst_roughness_correlation(self, *args, **kwargs):
                    """
                    Enables/disables the Transition-SST roughness correlation option.
                    """
                    return PyMenu(self.service, "/define/models/viscous/trans_sst_roughness_correlation").execute(*args, **kwargs)
                def les_subgrid_wmles_s_minus_omega(self, *args, **kwargs):
                    """
                    Enables/disables the WMLES -  subgrid-scale model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/les_subgrid_wmles_s_minus_omega").execute(*args, **kwargs)
                def k_kl_w(self, *args, **kwargs):
                    """
                    Enables/disables the k-kl-  turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/k_kl_w").execute(*args, **kwargs)
                def les_subgrid_wmles(self, *args, **kwargs):
                    """
                    Enables/disables the WMLES subgrid-scale model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/les_subgrid_wmles").execute(*args, **kwargs)
                def ke_easm(self, *args, **kwargs):
                    """
                    Enables/disables the EASM -  turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/ke_easm").execute(*args, **kwargs)
                def des_limiter_option(self, *args, **kwargs):
                    """
                    Selects the DES limiter option (none, F1, F2, Delayed DES, or Improved Delayed 	DES).
                    """
                    return PyMenu(self.service, "/define/models/viscous/des_limiter_option").execute(*args, **kwargs)
                def curvature_correction(self, *args, **kwargs):
                    """
                    Enables/disables the curvature correction.
                    """
                    return PyMenu(self.service, "/define/models/viscous/curvature_correction").execute(*args, **kwargs)
                def kw_low_re_correction(self, *args, **kwargs):
                    """
                    Enables/disables the -  low Re option.
                    """
                    return PyMenu(self.service, "/define/models/viscous/kw_low_re_correction").execute(*args, **kwargs)
                def les_subgrid_smagorinsky(self, *args, **kwargs):
                    """
                    Enables/disables the Smagorinsky-Lilly subgrid-scale model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/les_subgrid_smagorinsky").execute(*args, **kwargs)
                def large_eddy_simulation(self, *args, **kwargs):
                    """
                    Enables/disables large eddy simulation.
                    """
                    return PyMenu(self.service, "/define/models/viscous/large_eddy_simulation").execute(*args, **kwargs)
                def kw_easm(self, *args, **kwargs):
                    """
                    Enables/disables the EASM -  turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/kw_easm").execute(*args, **kwargs)
                def ke_rng(self, *args, **kwargs):
                    """
                    Enables/disables the RNG -  turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/ke_rng").execute(*args, **kwargs)
                def les_dynamic_energy_flux(self, *args, **kwargs):
                    """
                    Enables/disables the dynamic sub-grid scale turbulent Prandtl Number.
                    """
                    return PyMenu(self.service, "/define/models/viscous/les_dynamic_energy_flux").execute(*args, **kwargs)
                def laminar(self, *args, **kwargs):
                    """
                    Enables/disables laminar flow model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/laminar").execute(*args, **kwargs)
                def ke_realizable(self, *args, **kwargs):
                    """
                    Enables/disables the realizable -  turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/ke_realizable").execute(*args, **kwargs)
                def zero_equation_hvac(self, *args, **kwargs):
                    """
                    Enables/disables zero-equation HVAC turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/zero_equation_hvac").execute(*args, **kwargs)
                def kw_bsl(self, *args, **kwargs):
                    """
                    Enables/disables the baseline (BSL) -  turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/kw_bsl").execute(*args, **kwargs)
                def inviscid(self, *args, **kwargs):
                    """
                    Enables/disables inviscid flow model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/inviscid").execute(*args, **kwargs)
                def rsm_solve_tke(self, *args, **kwargs):
                    """
                    Enables/disables the solution of T.K.E. in RSM model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/rsm_solve_tke").execute(*args, **kwargs)
                def rsm_linear_pressure_strain(self, *args, **kwargs):
                    """
                    Enables/disables the linear pressure-strain model in RSM.
                    """
                    return PyMenu(self.service, "/define/models/viscous/rsm_linear_pressure_strain").execute(*args, **kwargs)
                def rsm_ssg_pressure_strain(self, *args, **kwargs):
                    """
                    Enables/disables quadratic pressure-strain model in RSM.
                    """
                    return PyMenu(self.service, "/define/models/viscous/rsm_ssg_pressure_strain").execute(*args, **kwargs)
                def les_subgrid_rng(self, *args, **kwargs):
                    """
                    Enable/disable the RNG subgrid-scale model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/les_subgrid_rng").execute(*args, **kwargs)
                def rsm_wall_echo(self, *args, **kwargs):
                    """
                    Enables/disables wall-echo effects in RSM model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/rsm_wall_echo").execute(*args, **kwargs)
                def curvature_correction_ccurv(self, *args, **kwargs):
                    """
                    Sets the strength of the curvature correction term. 	The default value is 1. This is available after the curvature-correction? 	option is enabled.
                    """
                    return PyMenu(self.service, "/define/models/viscous/curvature_correction_ccurv").execute(*args, **kwargs)
                def add_transition_model(self, *args, **kwargs):
                    """
                    Sets Transition model to account for transitional effects. The default is none, however you can 	select gamma-algebraic or gamma-transport-eqn.  After a transition model has been enabled, you have additional options in the 	submenu transition-model-options.
                    """
                    return PyMenu(self.service, "/define/models/viscous/add_transition_model").execute(*args, **kwargs)
                def ke_standard(self, *args, **kwargs):
                    """
                    Enables/disables the standard -  turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/ke_standard").execute(*args, **kwargs)
                def kw_standard(self, *args, **kwargs):
                    """
                    Enables/disables the standard -  turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/kw_standard").execute(*args, **kwargs)
                def transition_sst(self, *args, **kwargs):
                    """
                    Enables/disables the transition SST turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/transition_sst").execute(*args, **kwargs)
                def rsm_or_earsm_geko_option(self, *args, **kwargs):
                    """
                    Enables/disables the RSM version of the GEKO model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/rsm_or_earsm_geko_option").execute(*args, **kwargs)
                def kw_geko(self, *args, **kwargs):
                    """
                    Enables/disables the generalized -  (GEKO) turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/kw_geko").execute(*args, **kwargs)
                def turb_buoyancy_effects(self, *args, **kwargs):
                    """
                    Enables/disables effects of buoyancy on 	turbulence.
                    """
                    return PyMenu(self.service, "/define/models/viscous/turb_buoyancy_effects").execute(*args, **kwargs)
                def sa_damping(self, *args, **kwargs):
                    """
                    Enables/disables full low-Reynolds number form of Spalart-Allmaras model. This option is only available if your response wasno to sa-enhanced-wall-treatment?.
                    """
                    return PyMenu(self.service, "/define/models/viscous/sa_damping").execute(*args, **kwargs)
                def les_dynamic_scalar_flux(self, *args, **kwargs):
                    """
                    Enables/disables the dynamic sub-grid scale turbulent Schmidt Number.
                    """
                    return PyMenu(self.service, "/define/models/viscous/les_dynamic_scalar_flux").execute(*args, **kwargs)
                def sa_enhanced_wall_treatment(self, *args, **kwargs):
                    """
                    Enables/disables the enhanced wall treatment for the Spalart-Allmaras model. If 	disabled, no smooth blending between the viscous 	sublayer and the log-law formulation is employed, as was 	done in versions previous to Fluent 14.
                    """
                    return PyMenu(self.service, "/define/models/viscous/sa_enhanced_wall_treatment").execute(*args, **kwargs)
                def sa_alternate_prod(self, *args, **kwargs):
                    """
                    Enables/disables strain/vorticity production in Spalart-Allmaras model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/sa_alternate_prod").execute(*args, **kwargs)
                def les_subgrid_wale(self, *args, **kwargs):
                    """
                    Enables/disables WALE subgrid-scale model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/les_subgrid_wale").execute(*args, **kwargs)
                def user_defined(self, *args, **kwargs):
                    """
                    Selects user-defined functions to define the turbulent viscosity and the turbulent 	Prandtl and Schmidt numbers.
                    """
                    return PyMenu(self.service, "/define/models/viscous/user_defined").execute(*args, **kwargs)
                def kw_sst(self, *args, **kwargs):
                    """
                    Enables/disables the SST -  turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/kw_sst").execute(*args, **kwargs)
                def corner_flow_correction(self, *args, **kwargs):
                    """
                    Enables/disables the corner flow correction.
                    """
                    return PyMenu(self.service, "/define/models/viscous/corner_flow_correction").execute(*args, **kwargs)
                def les_subgrid_tke(self, *args, **kwargs):
                    """
                    Enables/disables kinetic energy transport subgrid-scale model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/les_subgrid_tke").execute(*args, **kwargs)
                def rsm_bsl_based(self, *args, **kwargs):
                    """
                    Enables/disables the stress-BSL Reynolds stress model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/rsm_bsl_based").execute(*args, **kwargs)
                def corner_flow_correction_ccorner(self, *args, **kwargs):
                    """
                    Sets the strength of the quadratic term of the corner flow correction. The default 	value is 1. This is available after the corner-flow-correction? 	option is enabled.
                    """
                    return PyMenu(self.service, "/define/models/viscous/corner_flow_correction_ccorner").execute(*args, **kwargs)
                def rng_swirl_model(self, *args, **kwargs):
                    """
                    Enables/disables swirl corrections for rng-model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/rng_swirl_model").execute(*args, **kwargs)
                def low_pressure_boundary_slip(self, *args, **kwargs):
                    """
                    Enables/disables the slip boundary formulation for 	low-pressure gas systems.
                    """
                    return PyMenu(self.service, "/define/models/viscous/low_pressure_boundary_slip").execute(*args, **kwargs)
                def detached_eddy_simulation(self, *args, **kwargs):
                    """
                    Enables/disables detached eddy simulation.
                    """
                    return PyMenu(self.service, "/define/models/viscous/detached_eddy_simulation").execute(*args, **kwargs)
                def reynolds_stress_model(self, *args, **kwargs):
                    """
                    Enables/disables the Reynolds-stress turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/reynolds_stress_model").execute(*args, **kwargs)
                def rng_differential_visc(self, *args, **kwargs):
                    """
                    Enables/disables the differential-viscosity model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/rng_differential_visc").execute(*args, **kwargs)
                def rsm_omega_based(self, *args, **kwargs):
                    """
                    Enables/disables the stress-omega Reynolds stress model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/rsm_omega_based").execute(*args, **kwargs)
                def user_defined_transition(self, *args, **kwargs):
                    """
                    Sets user-defined transition correlations.
                    """
                    return PyMenu(self.service, "/define/models/viscous/user_defined_transition").execute(*args, **kwargs)
                def spalart_allmaras(self, *args, **kwargs):
                    """
                    Enables/disables Spalart-Allmaras turbulence model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/spalart_allmaras").execute(*args, **kwargs)
                def kw_shear_correction(self, *args, **kwargs):
                    """
                    Enables/disables the -  shear-flow correction option. This 	text command is only available for the standard  -  model and the stress-omega RSM 	model.
                    """
                    return PyMenu(self.service, "/define/models/viscous/kw_shear_correction").execute(*args, **kwargs)

                class turbulence_expert(TUIMenu):
                    """
                    Enters the turbulence expert menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def turbulence_damping(self, *args, **kwargs):
                        """
                        Enables/disables turbulence damping and sets turbulence damping parameters.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/turbulence_damping").execute(*args, **kwargs)
                    def restore_sst_v61(self, *args, **kwargs):
                        """
                        Enables/disables SST formulation of v6.1.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/restore_sst_v61").execute(*args, **kwargs)
                    def kw_add_des(self, *args, **kwargs):
                        """
                        Enables/disables Detached Eddy Simulation (DES) in combination with the currently selected BSL -  model or transition SST model. This text command is only available for transient cases.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/kw_add_des").execute(*args, **kwargs)
                    def non_newtonian_modification(self, *args, **kwargs):
                        """
                        Enables/disables non-Newtonian modification for Lam-Bremhorst model.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/non_newtonian_modification").execute(*args, **kwargs)
                    def rke_cmu_rotation_term(self, *args, **kwargs):
                        """
                        Modifies the  definition for the realizable  -  model.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/rke_cmu_rotation_term").execute(*args, **kwargs)
                    def sbes_sgs_option(self, *args, **kwargs):
                        """
                        Selects the subgrid-scale model for the LES portion of your Stress-Blended Eddy Simulation (SBES).
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/sbes_sgs_option").execute(*args, **kwargs)
                    def kato_launder_model(self, *args, **kwargs):
                        """
                        Enables/disables Kato-Launder modification.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/kato_launder_model").execute(*args, **kwargs)
                    def low_re_ke_index(self, *args, **kwargs):
                        """
                        Specifies which low-Reynolds-number -  model is to be used. Six models are available:
                        Index
                        Model
                        0
                        Abid
                        1
                        Lam-Bremhorst
                        2
                        Launder-Sharma
                        3
                        Yang-Shih
                        4
                        Abe-Kondoh-Nagano
                        5
                        Chang-Hsieh-Chen
                        Contact your Ansys, Inc. technical support engineer for more details.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/low_re_ke_index").execute(*args, **kwargs)
                    def turb_pk_compressible(self, *args, **kwargs):
                        """
                        Enables/disables turbulent production due to compressible divergence.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/turb_pk_compressible").execute(*args, **kwargs)
                    def sbes_update_interval_k_omega(self, *args, **kwargs):
                        """
                        Sets the number of time steps between updates of the k-ω part of the SBES model.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/sbes_update_interval_k_omega").execute(*args, **kwargs)
                    def thermal_p_function(self, *args, **kwargs):
                        """
                        Enables/disables Jayatilleke P function.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/thermal_p_function").execute(*args, **kwargs)
                    def kw_vorticity_based_production(self, *args, **kwargs):
                        """
                        Enables/disables vorticity-based production.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/kw_vorticity_based_production").execute(*args, **kwargs)
                    def production_limiter(self, *args, **kwargs):
                        """
                        Enables/disables Production Limiter modification.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/production_limiter").execute(*args, **kwargs)
                    def sbes_les_subgrid_dynamic_fvar(self, *args, **kwargs):
                        """
                        Enable/disable the dynamic subgrid-scale mixture fraction variance model.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/sbes_les_subgrid_dynamic_fvar").execute(*args, **kwargs)
                    def sbes_sdes_hybrid_model(self, *args, **kwargs):
                        """
                        Selects the hybrid model, to specify whether you want to apply the Shielded Detached Eddy Simulation (SDES) model, Stress-Blended Eddy Simulation (SBES), or SBES with a user-defined function.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/sbes_sdes_hybrid_model").execute(*args, **kwargs)
                    def kw_add_sas(self, *args, **kwargs):
                        """
                        Enables/disables Scale-Adaptive Simulation (SAS) in combination with the currently selected -based URANS turbulence model. This text command is only available for transient cases.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/kw_add_sas").execute(*args, **kwargs)
                    def low_re_ke(self, *args, **kwargs):
                        """
                        Enables/disables the low-Re -  turbulence model.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/low_re_ke").execute(*args, **kwargs)
                    def turb_add_sbes_sdes(self, *args, **kwargs):
                        """
                        Enables/disables the Stress-Blended Eddy Simulation (SBES) model or Shielded Detached Eddy Simulation (SDES) model.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/turb_add_sbes_sdes").execute(*args, **kwargs)
                    def turb_non_newtonian(self, *args, **kwargs):
                        """
                        Enables/disables turbulence for non-Newtonian fluids.
                        """
                        return PyMenu(self.service, "/define/models/viscous/turbulence_expert/turb_non_newtonian").execute(*args, **kwargs)

                class near_wall_treatment(TUIMenu):
                    """
                    Enters the near wall treatment menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def wall_omega_treatment(self, *args, **kwargs):
                        """
                        Set wall omega treatment.
                        """
                        return PyMenu(self.service, "/define/models/viscous/near_wall_treatment/wall_omega_treatment").execute(*args, **kwargs)
                    def wf_pressure_gradient_effects(self, *args, **kwargs):
                        """
                        Enables/disables wall function pressure- gradient effects.
                        """
                        return PyMenu(self.service, "/define/models/viscous/near_wall_treatment/wf_pressure_gradient_effects").execute(*args, **kwargs)
                    def scalable_wall_functions(self, *args, **kwargs):
                        """
                        Enables/disables scalable wall functions.
                        """
                        return PyMenu(self.service, "/define/models/viscous/near_wall_treatment/scalable_wall_functions").execute(*args, **kwargs)
                    def non_equilibrium_wall_fn(self, *args, **kwargs):
                        """
                        Enables/disables non-equilibrium wall functions.
                        """
                        return PyMenu(self.service, "/define/models/viscous/near_wall_treatment/non_equilibrium_wall_fn").execute(*args, **kwargs)
                    def werner_wengle_wall_fn(self, *args, **kwargs):
                        """
                        Enables/disables Werner-Wengle wall functions.
                        """
                        return PyMenu(self.service, "/define/models/viscous/near_wall_treatment/werner_wengle_wall_fn").execute(*args, **kwargs)
                    def menter_lechner(self, *args, **kwargs):
                        """
                        Enables/disables the Menter-Lechner near-wall treatment.
                        """
                        return PyMenu(self.service, "/define/models/viscous/near_wall_treatment/menter_lechner").execute(*args, **kwargs)
                    def user_defined_wall_functions(self, *args, **kwargs):
                        """
                        Enables/disables user-defined wall functions.
                        """
                        return PyMenu(self.service, "/define/models/viscous/near_wall_treatment/user_defined_wall_functions").execute(*args, **kwargs)
                    def enhanced_wall_treatment(self, *args, **kwargs):
                        """
                        Enables/disables enhanced wall functions.
                        """
                        return PyMenu(self.service, "/define/models/viscous/near_wall_treatment/enhanced_wall_treatment").execute(*args, **kwargs)
                    def wf_thermal_effects(self, *args, **kwargs):
                        """
                        Enables/disables wall function thermal effects.
                        """
                        return PyMenu(self.service, "/define/models/viscous/near_wall_treatment/wf_thermal_effects").execute(*args, **kwargs)

                class transition_model_options(TUIMenu):
                    """
                    Enters the transition model options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def capg_lowtu(self, *args, **kwargs):
                        """
                        Sets the algebraic transition model coefficient CAPG_LOWTU.
                        """
                        return PyMenu(self.service, "/define/models/viscous/transition_model_options/capg_lowtu").execute(*args, **kwargs)
                    def cfpg_lowtu(self, *args, **kwargs):
                        """
                        Sets the algebraic transition model coefficient CFPG_LOWTU.
                        """
                        return PyMenu(self.service, "/define/models/viscous/transition_model_options/cfpg_lowtu").execute(*args, **kwargs)
                    def crossflow_transition(self, *args, **kwargs):
                        """
                        Enables/disables the effects of crossflow instability.
                        """
                        return PyMenu(self.service, "/define/models/viscous/transition_model_options/crossflow_transition").execute(*args, **kwargs)
                    def ctu_lowtu(self, *args, **kwargs):
                        """
                        Sets the algebraic transition model coefficient CTU_LOWTU.
                        """
                        return PyMenu(self.service, "/define/models/viscous/transition_model_options/ctu_lowtu").execute(*args, **kwargs)
                    def critical_reynolds_number_correlation(self, *args, **kwargs):
                        """
                        Sets the critical Reynolds number correlation.
                        """
                        return PyMenu(self.service, "/define/models/viscous/transition_model_options/critical_reynolds_number_correlation").execute(*args, **kwargs)
                    def ctu_hightu(self, *args, **kwargs):
                        """
                        Sets the algebraic transition model coefficient CTU_HIGHTU.
                        """
                        return PyMenu(self.service, "/define/models/viscous/transition_model_options/ctu_hightu").execute(*args, **kwargs)
                    def cfpg_hightu(self, *args, **kwargs):
                        """
                        Sets the algebraic transition model coefficient CFPG_HIGHTU.
                        """
                        return PyMenu(self.service, "/define/models/viscous/transition_model_options/cfpg_hightu").execute(*args, **kwargs)
                    def rec_c2(self, *args, **kwargs):
                        """
                        Sets the algebraic transition model coefficient REC_C2.
                        """
                        return PyMenu(self.service, "/define/models/viscous/transition_model_options/rec_c2").execute(*args, **kwargs)
                    def clambda_scale(self, *args, **kwargs):
                        """
                        Sets the algebraic transition model coefficient CLAMBDA_SCALE.
                        """
                        return PyMenu(self.service, "/define/models/viscous/transition_model_options/clambda_scale").execute(*args, **kwargs)
                    def rv1_switch(self, *args, **kwargs):
                        """
                        Sets the algebraic transition model coefficient RV1_SWITCH.
                        """
                        return PyMenu(self.service, "/define/models/viscous/transition_model_options/rv1_switch").execute(*args, **kwargs)
                    def cbubble_c1(self, *args, **kwargs):
                        """
                        Sets the algebraic transition model coefficient CBUBBLE_C1.
                        """
                        return PyMenu(self.service, "/define/models/viscous/transition_model_options/cbubble_c1").execute(*args, **kwargs)
                    def rec_c1(self, *args, **kwargs):
                        """
                        Sets the algebraic transition model coefficient REC_C1.
                        """
                        return PyMenu(self.service, "/define/models/viscous/transition_model_options/rec_c1").execute(*args, **kwargs)
                    def cbubble_c2(self, *args, **kwargs):
                        """
                        Sets the algebraic transition model coefficient CBUBBLE_C2.
                        """
                        return PyMenu(self.service, "/define/models/viscous/transition_model_options/cbubble_c2").execute(*args, **kwargs)
                    def capg_hightu(self, *args, **kwargs):
                        """
                        Sets the algebraic transition model coefficient CAPG_HIGHTU.
                        """
                        return PyMenu(self.service, "/define/models/viscous/transition_model_options/capg_hightu").execute(*args, **kwargs)
                    def rec_max(self, *args, **kwargs):
                        """
                        Sets the algebraic transition model coefficient REC_MAX.
                        """
                        return PyMenu(self.service, "/define/models/viscous/transition_model_options/rec_max").execute(*args, **kwargs)

                class multiphase_turbulence(TUIMenu):
                    """
                    Enters the multiphase turbulence menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def turbulence_multiphase_models(self, *args, **kwargs):
                        """
                        Selects -  multiphase model.
                        """
                        return PyMenu(self.service, "/define/models/viscous/multiphase_turbulence/turbulence_multiphase_models").execute(*args, **kwargs)
                    def multiphase_options(self, *args, **kwargs):
                        """
                        Enables/disables multiphase options.
                        """
                        return PyMenu(self.service, "/define/models/viscous/multiphase_turbulence/multiphase_options").execute(*args, **kwargs)
                    def subgrid_turbulence_contribution_aiad(self, *args, **kwargs):
                        """
                        Enable/disable the Subgrid Turbulence Contribution for the AIAD model.
                        """
                        return PyMenu(self.service, "/define/models/viscous/multiphase_turbulence/subgrid_turbulence_contribution_aiad").execute(*args, **kwargs)
                    def rsm_multiphase_models(self, *args, **kwargs):
                        """
                        Selects Reynolds Stress multiphase model.
                        """
                        return PyMenu(self.service, "/define/models/viscous/multiphase_turbulence/rsm_multiphase_models").execute(*args, **kwargs)

                class geko_options(TUIMenu):
                    """
                    Enters the GEKO model menu..
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def cmix(self, *args, **kwargs):
                        """
                        Setscmix, the parameter to optimize strength of mixing in free shear flows.
                        """
                        return PyMenu(self.service, "/define/models/viscous/geko_options/cmix").execute(*args, **kwargs)
                    def wall_distance_free(self, *args, **kwargs):
                        """
                        Enables/disables the wall distance free version of the GEKO model.
                        """
                        return PyMenu(self.service, "/define/models/viscous/geko_options/wall_distance_free").execute(*args, **kwargs)
                    def cjet_aux(self, *args, **kwargs):
                        """
                        Setscjet_aux, which allows fine-tuning of the parameter to optimize free jets.
                        """
                        return PyMenu(self.service, "/define/models/viscous/geko_options/cjet_aux").execute(*args, **kwargs)
                    def cnw(self, *args, **kwargs):
                        """
                        Setscnw, the parameter to optimize flow in non-equilibrium near wall regions.
                        """
                        return PyMenu(self.service, "/define/models/viscous/geko_options/cnw").execute(*args, **kwargs)
                    def cbf_lam(self, *args, **kwargs):
                        """
                        Setscbf_lam, a part of the blending function and shields the laminar boundary layer.
                        """
                        return PyMenu(self.service, "/define/models/viscous/geko_options/cbf_lam").execute(*args, **kwargs)
                    def csep(self, *args, **kwargs):
                        """
                        Setscsep, the parameter to optimize flow separation from smooth surfaces.
                        """
                        return PyMenu(self.service, "/define/models/viscous/geko_options/csep").execute(*args, **kwargs)
                    def cjet(self, *args, **kwargs):
                        """
                        Setscjet, the parameter to optimize free shear layer mixing (optimize free jets independent of mixing layer).
                        """
                        return PyMenu(self.service, "/define/models/viscous/geko_options/cjet").execute(*args, **kwargs)
                    def geko_defaults(self, *args, **kwargs):
                        """
                        Restores the defaults of all GEKO parameters.
                        """
                        return PyMenu(self.service, "/define/models/viscous/geko_options/geko_defaults").execute(*args, **kwargs)
                    def blending_function(self, *args, **kwargs):
                        """
                        Sets the blending function, which deactivatescmix and cjet inside boundary layers.
                        """
                        return PyMenu(self.service, "/define/models/viscous/geko_options/blending_function").execute(*args, **kwargs)
                    def cnw_sub(self, *args, **kwargs):
                        """
                        Setscnw_sub, which allows the adjustment of log-layer and cf.
                        """
                        return PyMenu(self.service, "/define/models/viscous/geko_options/cnw_sub").execute(*args, **kwargs)
                    def creal(self, *args, **kwargs):
                        """
                        Setscreal, a realizability limiter that ensures positive normal stresses in the entire domain.
                        """
                        return PyMenu(self.service, "/define/models/viscous/geko_options/creal").execute(*args, **kwargs)
                    def cbf_tur(self, *args, **kwargs):
                        """
                        Setscbf_tur, a factor for the main blending factor, controlling the thickness of the layer near walls.
                        """
                        return PyMenu(self.service, "/define/models/viscous/geko_options/cbf_tur").execute(*args, **kwargs)

            class eulerian_wallfilm(TUIMenu):
                """
                Enters the Eulerian wall film model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.implicit_options = self.__class__.implicit_options(path + ["implicit_options"], service)
                    self.coupled_solution = self.__class__.coupled_solution(path + ["coupled_solution"], service)
                    super().__init__(path, service)
                def initialize_wallfilm_model(self, *args, **kwargs):
                    """
                    Initializes Eulerian Wall Film Model.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/initialize_wallfilm_model").execute(*args, **kwargs)
                def film_material(self, *args, **kwargs):
                    """
                    Sets Film Material and Properties.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/film_material").execute(*args, **kwargs)
                def list_film_walls(self, *args, **kwargs):
                    """
                    List film walls.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/list_film_walls").execute(*args, **kwargs)
                def model_options(self, *args, **kwargs):
                    """
                    Set Eulerian wall film model options.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/model_options").execute(*args, **kwargs)
                def solution_options(self, *args, **kwargs):
                    """
                    Sets Eulerian Wall Film Model Solution Options.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/solution_options").execute(*args, **kwargs)
                def enable_wallfilm_model(self, *args, **kwargs):
                    """
                    Enables/disables Eulerian Wall Film Model.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/enable_wallfilm_model").execute(*args, **kwargs)
                def enable_film_vof_transition_message(self, *args, **kwargs):
                    """
                    Enable film-VOF transition message.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/enable_film_vof_transition_message").execute(*args, **kwargs)
                def solve_wallfilm_equation(self, *args, **kwargs):
                    """
                    Activates Eulerian Wall Film Equations.
                    """
                    return PyMenu(self.service, "/define/models/eulerian_wallfilm/solve_wallfilm_equation").execute(*args, **kwargs)

                class implicit_options(TUIMenu):
                    """
                    Enter Implicit Scheme Option (beta).
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def relative_error_residual(self, *args, **kwargs):
                        """
                        Enable relative error residual.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/implicit_options/relative_error_residual").execute(*args, **kwargs)
                    def new_implicit_scheme(self, *args, **kwargs):
                        """
                        Enable alternative implicit scheme.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/implicit_options/new_implicit_scheme").execute(*args, **kwargs)

                class coupled_solution(TUIMenu):
                    """
                    Enters the Coupled-Solution menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable_curvature_smoothing(self, *args, **kwargs):
                        """
                        Enables/disables the film curvature smoothing option and sets the smoothing parameters.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/coupled_solution/enable_curvature_smoothing").execute(*args, **kwargs)
                    def enable_coupled_solution(self, *args, **kwargs):
                        """
                        Enables/disables the coupled solution method.
                        """
                        return PyMenu(self.service, "/define/models/eulerian_wallfilm/coupled_solution/enable_coupled_solution").execute(*args, **kwargs)

            class soot_parameters(TUIMenu):
                """
                Enters the soot parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def modify_schmidt_number(self, *args, **kwargs):
                    """
                    Changes the turbulent Schmidt number for soot/nuclei equations.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/modify_schmidt_number").execute(*args, **kwargs)
                def soot_model_parameters(self, *args, **kwargs):
                    """
                    Selects soot model parameters.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_model_parameters").execute(*args, **kwargs)
                def soot_process_parameters(self, *args, **kwargs):
                    """
                    Selects soot process parameters.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_process_parameters").execute(*args, **kwargs)
                def soot_turbulence_interaction(self, *args, **kwargs):
                    """
                    Sets soot-turbulence interaction model.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_turbulence_interaction").execute(*args, **kwargs)
                def soot_model_udfs(self, *args, **kwargs):
                    """
                    User defined functions for soot model.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_model_udfs").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enables/disables inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/inlet_diffusion").execute(*args, **kwargs)
                def soot_radiation_interaction(self, *args, **kwargs):
                    """
                    Enables/disables the soot-radiation interaction model.
                    """
                    return PyMenu(self.service, "/define/models/soot_parameters/soot_radiation_interaction").execute(*args, **kwargs)

            class system_coupling_settings(TUIMenu):
                """
                Enters the system coupling menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.htc = self.__class__.htc(path + ["htc"], service)
                    super().__init__(path, service)
                def specify_system_coupling_volumetric_cell_zones(self, *args, **kwargs):
                    """
                    Enable/disable volumetric cell zones.
                    """
                    return PyMenu(self.service, "/define/models/system_coupling_settings/specify_system_coupling_volumetric_cell_zones").execute(*args, **kwargs)
                def use_face_or_element_based_data_transfer(self, *args, **kwargs):
                    """
                    Answering yes at the prompt 	enables Fluent to use element data for mapping surface 	conservative quantities such as surface forces and heat 	flows.
                    """
                    return PyMenu(self.service, "/define/models/system_coupling_settings/use_face_or_element_based_data_transfer").execute(*args, **kwargs)
                def update_rigid_body_mesh_motion_before_mesh_transfer(self, *args, **kwargs):
                    """
                    SC Enable/disable mesh motion.
                    """
                    return PyMenu(self.service, "/define/models/system_coupling_settings/update_rigid_body_mesh_motion_before_mesh_transfer").execute(*args, **kwargs)

                class htc(TUIMenu):
                    """
                    Enter the heat transfer coeficient menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.htc_calculation_method = self.__class__.htc_calculation_method(path + ["htc_calculation_method"], service)
                        self.unsteady_statistics = self.__class__.unsteady_statistics(path + ["unsteady_statistics"], service)
                        super().__init__(path, service)

                    class htc_calculation_method(TUIMenu):
                        """
                        Enter the htc calculation menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def use_tref_in_htc_calculation(self, *args, **kwargs):
                            """
                            Enable/disable tref in htc computation.
                            """
                            return PyMenu(self.service, "/define/models/system_coupling_settings/htc/htc_calculation_method/use_tref_in_htc_calculation").execute(*args, **kwargs)
                        def use_yplus_based_htc_calculation(self, *args, **kwargs):
                            """
                            Enable/disable yplus in htc computation.
                            """
                            return PyMenu(self.service, "/define/models/system_coupling_settings/htc/htc_calculation_method/use_yplus_based_htc_calculation").execute(*args, **kwargs)
                        def use_wall_function_based_htc(self, *args, **kwargs):
                            """
                            Enable/disable wall function based htc computation.
                            """
                            return PyMenu(self.service, "/define/models/system_coupling_settings/htc/htc_calculation_method/use_wall_function_based_htc").execute(*args, **kwargs)

                    class unsteady_statistics(TUIMenu):
                        """
                        Enter the unsteady statistics menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def sc_enable_sub_stepping_option_per_coupling_step(self, *args, **kwargs):
                            """
                            Enable/disable sub stepping option per coupling step.
                            """
                            return PyMenu(self.service, "/define/models/system_coupling_settings/htc/unsteady_statistics/sc_enable_sub_stepping_option_per_coupling_step").execute(*args, **kwargs)

            class electrolysis(TUIMenu):
                """
                Enter the electrolysis model setup menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.cathode_setup = self.__class__.cathode_setup(path + ["cathode_setup"], service)
                    self.anode_setup = self.__class__.anode_setup(path + ["anode_setup"], service)
                    self.membrane_setup = self.__class__.membrane_setup(path + ["membrane_setup"], service)
                    super().__init__(path, service)
                def model_options(self, *args, **kwargs):
                    """
                    Specify electrolysis model options.
                    """
                    return PyMenu(self.service, "/define/models/electrolysis/model_options").execute(*args, **kwargs)
                def electrical_tabs_setup(self, *args, **kwargs):
                    """
                    Specify settings for the electrical tabs.
                    """
                    return PyMenu(self.service, "/define/models/electrolysis/electrical_tabs_setup").execute(*args, **kwargs)
                def parameters(self, *args, **kwargs):
                    """
                    Specify electrolysis model parameters.
                    """
                    return PyMenu(self.service, "/define/models/electrolysis/parameters").execute(*args, **kwargs)

                class cathode_setup(TUIMenu):
                    """
                    Enter the menu for the cathode controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def flow_channel(self, *args, **kwargs):
                        """
                        Set parameters for the flow channel.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/cathode_setup/flow_channel").execute(*args, **kwargs)
                    def porous_layer(self, *args, **kwargs):
                        """
                        Set parameters for the porous layer.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/cathode_setup/porous_layer").execute(*args, **kwargs)
                    def current_collector(self, *args, **kwargs):
                        """
                        Set parameters for the current collector.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/cathode_setup/current_collector").execute(*args, **kwargs)
                    def catalyst_layer(self, *args, **kwargs):
                        """
                        Set parameters for the catalyst layer.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/cathode_setup/catalyst_layer").execute(*args, **kwargs)
                    def electrolyte(self, *args, **kwargs):
                        """
                        Set parameters for the electrolyte.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/cathode_setup/electrolyte").execute(*args, **kwargs)

                class anode_setup(TUIMenu):
                    """
                    Enter the menu for the anode controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def porous_layer(self, *args, **kwargs):
                        """
                        Set parameters for the porous layer.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/anode_setup/porous_layer").execute(*args, **kwargs)
                    def current_collector(self, *args, **kwargs):
                        """
                        Set parameters for the current collector.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/anode_setup/current_collector").execute(*args, **kwargs)
                    def electrolyte(self, *args, **kwargs):
                        """
                        Set parameters for the electrolyte.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/anode_setup/electrolyte").execute(*args, **kwargs)
                    def catalyst_layer(self, *args, **kwargs):
                        """
                        Set parameters for the catalyst layer.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/anode_setup/catalyst_layer").execute(*args, **kwargs)
                    def flow_channel(self, *args, **kwargs):
                        """
                        Set parameters for the flow channel.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/anode_setup/flow_channel").execute(*args, **kwargs)

                class membrane_setup(TUIMenu):
                    """
                    Specify parameters for electrolyte.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def electrolyte(self, *args, **kwargs):
                        """
                        Set parameters for the electrolyte.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/membrane_setup/electrolyte").execute(*args, **kwargs)
                    def catalyst_layer(self, *args, **kwargs):
                        """
                        Set parameters for the catalyst layer.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/membrane_setup/catalyst_layer").execute(*args, **kwargs)
                    def porous_layer(self, *args, **kwargs):
                        """
                        Set parameters for the porous layer.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/membrane_setup/porous_layer").execute(*args, **kwargs)
                    def current_collector(self, *args, **kwargs):
                        """
                        Set parameters for the current collector.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/membrane_setup/current_collector").execute(*args, **kwargs)
                    def flow_channel(self, *args, **kwargs):
                        """
                        Set parameters for the flow channel.
                        """
                        return PyMenu(self.service, "/define/models/electrolysis/membrane_setup/flow_channel").execute(*args, **kwargs)

            class multiphase(TUIMenu):
                """
                Enters the multiphase model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.sub_models = self.__class__.sub_models(path + ["sub_models"], service)
                    self.explicit_expert_options = self.__class__.explicit_expert_options(path + ["explicit_expert_options"], service)
                    self.phases = self.__class__.phases(path + ["phases"], service)
                    self.flow_regime_modeling = self.__class__.flow_regime_modeling(path + ["flow_regime_modeling"], service)
                    self.wet_steam = self.__class__.wet_steam(path + ["wet_steam"], service)
                    self.hybrid_models = self.__class__.hybrid_models(path + ["hybrid_models"], service)
                    self.population_balance = self.__class__.population_balance(path + ["population_balance"], service)
                    super().__init__(path, service)
                def volume_fraction_parameters(self, *args, **kwargs):
                    """
                    Volume fraction parameters.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/volume_fraction_parameters").execute(*args, **kwargs)
                def model(self, *args, **kwargs):
                    """
                    Specifies multiphase model.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/model").execute(*args, **kwargs)
                def coupled_level_set(self, *args, **kwargs):
                    """
                    Enables coupled level set interface tracking method.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/coupled_level_set").execute(*args, **kwargs)
                def mixture_parameters(self, *args, **kwargs):
                    """
                    Specifies mixture parameters.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/mixture_parameters").execute(*args, **kwargs)
                def number_of_phases(self, *args, **kwargs):
                    """
                    Specifies the number of phases.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/number_of_phases").execute(*args, **kwargs)
                def body_force_formulation(self, *args, **kwargs):
                    """
                    Specifies body force formulation.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/body_force_formulation").execute(*args, **kwargs)
                def vof_sub_models(self, *args, **kwargs):
                    """
                    Enables the Open Channel sub-model and/or the Open Channel Wave Boundary Condition 	sub-model.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/vof_sub_models").execute(*args, **kwargs)
                def interface_modeling_options(self, *args, **kwargs):
                    """
                    Specifies interface modeling options.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/interface_modeling_options").execute(*args, **kwargs)
                def regime_transition_modeling(self, *args, **kwargs):
                    """
                    Enables the Algebraic Interfacial Area Density (AIAD) 	model and sets the AIAD secondary continuous phase and 	the secondary entrained phase. Entering 0 as a phase ID cancels any 	previous phase selection. Note that you must define the 	phases in your simulation using the define/phases/ text command 	prior to using the regime-transition-modeling 	text command. This option is available only with the 	Eulerian multiphase model.
                    """
                    return PyMenu(self.service, "/define/models/multiphase/regime_transition_modeling").execute(*args, **kwargs)

                class sub_models(TUIMenu):
                    """
                    Enter the menu to select sub-models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.boiling_options = self.__class__.boiling_options(path + ["boiling_options"], service)
                        super().__init__(path, service)
                    def boiling(self, *args, **kwargs):
                        """
                        Activate boiling model.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/sub_models/boiling").execute(*args, **kwargs)

                    class boiling_options(TUIMenu):
                        """
                        Set boiling options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def options(self, *args, **kwargs):
                            """
                            Choose the type of boiling model.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/sub_models/boiling_options/options").execute(*args, **kwargs)
                        def nlbf_model(self, *args, **kwargs):
                            """
                            Set the non-local boundary field correction.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/sub_models/boiling_options/nlbf_model").execute(*args, **kwargs)

                class explicit_expert_options(TUIMenu):
                    """
                    Enters the menu to set explicit VOF expert 	options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.volume_fraction_filtering = self.__class__.volume_fraction_filtering(path + ["volume_fraction_filtering"], service)
                        super().__init__(path, service)
                    def solve_vof_every_iter(self, *args, **kwargs):
                        """
                        If you enter yes, the volume fraction equations will be solved every iteration. By default, the volume fraction equations will be solved only once per time step.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/explicit_expert_options/solve_vof_every_iter").execute(*args, **kwargs)
                    def sub_time_step_method(self, *args, **kwargs):
                        """
                        Selects the sub-time step method.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/explicit_expert_options/sub_time_step_method").execute(*args, **kwargs)

                    class volume_fraction_filtering(TUIMenu):
                        """
                        Enters the volume fraction filtering menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def vol_frac_cutoff(self, *args, **kwargs):
                            """
                            Specifies a cut-off value for the volume fraction filtering. This command becomes available after you select the node averaged cutoff method using the define/models/multiphase/explicit-expert-options/volume-fraction-filtering/filtering-options text command.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/explicit_expert_options/volume_fraction_filtering/vol_frac_cutoff").execute(*args, **kwargs)
                        def filtering_options(self, *args, **kwargs):
                            """
                            Selects the volume fraction filtering method. This command becomes available once the define/models/multiphase/explicit-expert-options/volume-fraction-filtering/enable? text option has been set to yes.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/explicit_expert_options/volume_fraction_filtering/filtering_options").execute(*args, **kwargs)
                        def enable(self, *args, **kwargs):
                            """
                            Enables/disables the volume fraction filtering treatment.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/explicit_expert_options/volume_fraction_filtering/enable").execute(*args, **kwargs)

                class phases(TUIMenu):
                    """
                    Enter the phases menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set_domain_properties = self.__class__.set_domain_properties(path + ["set_domain_properties"], service)
                        self.iac_expert = self.__class__.iac_expert(path + ["iac_expert"], service)
                        super().__init__(path, service)

                    class set_domain_properties(TUIMenu):
                        """
                        Enter the menu to set domain properties.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.interaction_domain = self.__class__.interaction_domain(path + ["interaction_domain"], service)
                            super().__init__(path, service)
                        def phase_domains(self, *args, **kwargs):
                            """
                            Enter the menu to select a specific phase domain.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/phase_domains").execute(*args, **kwargs)
                        def change_phases_names(self, *args, **kwargs):
                            """
                            Change names for all defined phases?.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/change_phases_names").execute(*args, **kwargs)

                        class interaction_domain(TUIMenu):
                            """
                            Enter the menu to set the interaction domain properties.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                self.model_transition = self.__class__.model_transition(path + ["model_transition"], service)
                                self.forces = self.__class__.forces(path + ["forces"], service)
                                self.heat_mass_reactions = self.__class__.heat_mass_reactions(path + ["heat_mass_reactions"], service)
                                self.interfacial_area = self.__class__.interfacial_area(path + ["interfacial_area"], service)
                                self.numerics = self.__class__.numerics(path + ["numerics"], service)
                                super().__init__(path, service)

                            class model_transition(TUIMenu):
                                """
                                Enter the menu to set model transition mechanisms.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    super().__init__(path, service)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/model_transition").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/drag").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/turbulent_dispersion").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/turbulence_interaction").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/restitution").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/slip_velocity").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interfacial_area").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/heat_coeff").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/wall_lubrication").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/reactions").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/mass_transfer").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/cavitation").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/virtual_mass").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/wall_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/slope_limiter").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/virtual_mass").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_discr").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_model_type").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_montoya").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_shaver_podowski").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/virtual_mass").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/cavitation").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_montoya").execute(*args, **kwargs)

                            class forces(TUIMenu):
                                """
                                Enter the menu to set interfacial forces related models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    super().__init__(path, service)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/reactions").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/slip_velocity").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interfacial_area").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/drag").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/wall_lubrication").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/model_transition").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/heat_coeff").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/restitution").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/mass_transfer").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/turbulent_dispersion").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/turbulence_interaction").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/cavitation").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/lift").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/wall_adhesion").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/visc_disp_factor").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_implicit").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/cavitation").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/lift").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/virtual_mass").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/sfc_modeling").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/lift_montoya").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/slope_limiter").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/vmass_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/interphase_discr").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit_options").execute(*args, **kwargs)

                            class heat_mass_reactions(TUIMenu):
                                """
                                Enter the menu to set heat, mass-transfer, or reaction related models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    super().__init__(path, service)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/drag").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interfacial_area").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/model_transition").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/reactions").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/heat_coeff").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/restitution").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/wall_lubrication").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulence_interaction").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/mass_transfer").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulent_dispersion").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/slip_velocity").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_coeff").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/cavitation").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/wall_adhesion").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_discr").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/cavitation").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_montoya").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/virtual_mass").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_model_type").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/slope_limiter").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit_options").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/jump_adhesion").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/cavitation").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/wall_adhesion").execute(*args, **kwargs)

                            class interfacial_area(TUIMenu):
                                """
                                Enter the menu to set interfacial area models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    super().__init__(path, service)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/model_transition").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interfacial_area").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/restitution").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/heat_coeff").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/drag").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/turbulent_dispersion").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/turbulence_interaction").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/slip_velocity").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/wall_lubrication").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/mass_transfer").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/reactions").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/cavitation").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/cavitation").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_model_type").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_model_type").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/slope_limiter").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/wall_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/cavitation").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/virtual_mass").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_discr").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/cavitation").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/visc_disp_factor").execute(*args, **kwargs)

                            class numerics(TUIMenu):
                                """
                                Enter the menu to set numerics models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    super().__init__(path, service)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/turbulence_interaction").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/model_transition").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/slip_velocity").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/reactions").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interfacial_area").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/drag").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/turbulent_dispersion").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/mass_transfer").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/restitution").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/wall_lubrication").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/heat_coeff").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/cavitation").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_visc_disp").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_model_type").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/slope_limiter").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift_montoya").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_coeff").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_model_type").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/jump_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_modeling").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/virtual_mass").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_discr").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/cavitation").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/wall_adhesion").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/define/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/virtual_mass").execute(*args, **kwargs)

                    class iac_expert(TUIMenu):
                        """
                        Enter the IAC expert setting menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def ishii_kim_model(self, *args, **kwargs):
                            """
                            Set ik model coefficients.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/phases/iac_expert/ishii_kim_model").execute(*args, **kwargs)
                        def iac_pseudo_time_step(self, *args, **kwargs):
                            """
                            Set iac pseudo-time.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/phases/iac_expert/iac_pseudo_time_step").execute(*args, **kwargs)
                        def hibiki_ishii_model(self, *args, **kwargs):
                            """
                            Set hi model coefficients.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/phases/iac_expert/hibiki_ishii_model").execute(*args, **kwargs)
                        def yao_morel_model(self, *args, **kwargs):
                            """
                            Set ym model coefficients.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/phases/iac_expert/yao_morel_model").execute(*args, **kwargs)

                class flow_regime_modeling(TUIMenu):
                    """
                    Flow Regime Modeling.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.aiad_parameters = self.__class__.aiad_parameters(path + ["aiad_parameters"], service)
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Enable flow regime modeling framework including phase state and morphology.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/enable").execute(*args, **kwargs)

                    class aiad_parameters(TUIMenu):
                        """
                        AIAD parameters.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def delta_vf(self, *args, **kwargs):
                            """
                            Parameter for transition width for bubbly and droplet flow blending factors.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/aiad_parameters/delta_vf").execute(*args, **kwargs)
                        def ncells_fs(self, *args, **kwargs):
                            """
                            Parameter for determining interfacial width.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/aiad_parameters/ncells_fs").execute(*args, **kwargs)
                        def critical_vf(self, *args, **kwargs):
                            """
                            Critical volume fraction for bubbly and droplet flow blending factors.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/aiad_parameters/critical_vf").execute(*args, **kwargs)
                        def delta_grad(self, *args, **kwargs):
                            """
                            Parameter for determining transition width for free surface blending factor.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/flow_regime_modeling/aiad_parameters/delta_grad").execute(*args, **kwargs)

                class wet_steam(TUIMenu):
                    """
                    Enters the wet steam model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set = self.__class__.set(path + ["set"], service)
                        super().__init__(path, service)
                    def compile_user_defined_wetsteam_functions(self, *args, **kwargs):
                        """
                        Compiles user-defined wet steam library.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/wet_steam/compile_user_defined_wetsteam_functions").execute(*args, **kwargs)
                    def load_unload_user_defined_wetsteam_library(self, *args, **kwargs):
                        """
                        Loads or unloads user-defined wet steam library.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/wet_steam/load_unload_user_defined_wetsteam_library").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enables/disables the wet steam model.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/wet_steam/enable").execute(*args, **kwargs)

                    class set(TUIMenu):
                        """
                        Enters the set menu for setting wet steam model options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def max_liquid_mass_fraction(self, *args, **kwargs):
                            """
                            Sets the maximum limit on the condensed liquid-phase mass-fraction to prevent divergence.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/max_liquid_mass_fraction").execute(*args, **kwargs)
                        def rgp_tables(self, *args, **kwargs):
                            """
                            Sets the RGP (real gas property) table to be used with the Wet Steam model.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/rgp_tables").execute(*args, **kwargs)
                        def droplet_growth_rate(self, *args, **kwargs):
                            """
                            S formulation (default) or Hill.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/droplet_growth_rate").execute(*args, **kwargs)
                        def zonal_phase_change(self, *args, **kwargs):
                            """
                            Select cell zones where phase change process is active.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/zonal_phase_change").execute(*args, **kwargs)
                        def stagnation_conditions(self, *args, **kwargs):
                            """
                            Computes stagnation conditions using either gas phase only, or mixture. For details, see .
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/stagnation_conditions").execute(*args, **kwargs)
                        def virial_equation(self, *args, **kwargs):
                            """
                            Sets the equation of state for steam to either Vukalovich formulation (default) or Young formulation.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/wet_steam/set/virial_equation").execute(*args, **kwargs)

                class hybrid_models(TUIMenu):
                    """
                    Enter the menu to select hybrid models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ddpm(self, *args, **kwargs):
                        """
                        Enable the dense discrete phase model.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/hybrid_models/ddpm").execute(*args, **kwargs)
                    def multi_fluid_vof(self, *args, **kwargs):
                        """
                        Enable the multi-fluid VOF model.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/hybrid_models/multi_fluid_vof").execute(*args, **kwargs)

                class population_balance(TUIMenu):
                    """
                    Enters the population balance models menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        self.phenomena = self.__class__.phenomena(path + ["phenomena"], service)
                        super().__init__(path, service)
                    def model(self, *args, **kwargs):
                        """
                        Allows you to select the population balance model and set its parameters.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/population_balance/model").execute(*args, **kwargs)
                    def include_expansion(self, *args, **kwargs):
                        """
                        Set expansion.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/population_balance/include_expansion").execute(*args, **kwargs)
                    def size_calculator(self, *args, **kwargs):
                        """
                        Gives you recommendations for appropriate bubble sizes and/or droplet size limits.
                        """
                        return PyMenu(self.service, "/define/models/multiphase/population_balance/size_calculator").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enter the expert menu for quadrature-based population balance method.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.qmom = self.__class__.qmom(path + ["qmom"], service)
                            super().__init__(path, service)

                        class qmom(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def retain_qmom_sources_for_low_vof(self, *args, **kwargs):
                                """
                                Retain qmom source calculation for low secondary phase vof.
                                """
                                return PyMenu(self.service, "/define/models/multiphase/population_balance/expert/qmom/retain_qmom_sources_for_low_vof").execute(*args, **kwargs)
                            def realizable_moments(self, *args, **kwargs):
                                """
                                Set the population balance model.
                                """
                                return PyMenu(self.service, "/define/models/multiphase/population_balance/expert/qmom/realizable_moments").execute(*args, **kwargs)
                            def inversion_algorithm(self, *args, **kwargs):
                                """
                                Select the inversion algorithm for quadrature-based population balance method.
                                """
                                return PyMenu(self.service, "/define/models/multiphase/population_balance/expert/qmom/inversion_algorithm").execute(*args, **kwargs)
                            def print_realizable_moment_warning(self, *args, **kwargs):
                                """
                                Print the information for realizable moments in the population balance model.
                                """
                                return PyMenu(self.service, "/define/models/multiphase/population_balance/expert/qmom/print_realizable_moment_warning").execute(*args, **kwargs)

                    class phenomena(TUIMenu):
                        """
                        Enters the phenomena menu for population balance.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def growth(self, *args, **kwargs):
                            """
                            Specifies the growth rate.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/growth").execute(*args, **kwargs)
                        def breakage_factor(self, *args, **kwargs):
                            """
                            Specifies a factor that controls the intensity of the selected breakage kernel.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/breakage_factor").execute(*args, **kwargs)
                        def breakage_aggregation_vof_cutoff(self, *args, **kwargs):
                            """
                            Specifies a cutoff limit for the volume fraction values for the breakage and aggregation kernels.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/breakage_aggregation_vof_cutoff").execute(*args, **kwargs)
                        def breakage(self, *args, **kwargs):
                            """
                            Set the breakage kernel.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/breakage").execute(*args, **kwargs)
                        def aggregation(self, *args, **kwargs):
                            """
                            Sets the aggregation kernel.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/aggregation").execute(*args, **kwargs)
                        def aggregation_factor(self, *args, **kwargs):
                            """
                            Specifies a factor that controls the intensity of the selected aggregation kernel.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/aggregation_factor").execute(*args, **kwargs)
                        def nucleation(self, *args, **kwargs):
                            """
                            Specifies the nucleation rate.
                            """
                            return PyMenu(self.service, "/define/models/multiphase/population_balance/phenomena/nucleation").execute(*args, **kwargs)

            class heat_exchanger(TUIMenu):
                """
                Enters the heat exchanger menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.macro_model = self.__class__.macro_model(path + ["macro_model"], service)
                    self.dual_cell_model = self.__class__.dual_cell_model(path + ["dual_cell_model"], service)
                    super().__init__(path, service)

                class macro_model(TUIMenu):
                    """
                    Enters the heat macro-model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def heat_exchanger_report(self, *args, **kwargs):
                        """
                        Reports the computed values of total heat rejection, outlet temperature, and inlet temperature for a specified heat-exchanger core.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_report").execute(*args, **kwargs)
                    def heat_exchanger(self, *args, **kwargs):
                        """
                        Enables/disables heat-exchanger model.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger").execute(*args, **kwargs)
                    def plot_NTU(self, *args, **kwargs):
                        """
                        Plots NTU vs. primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/plot_NTU").execute(*args, **kwargs)
                    def heat_exchanger_group(self, *args, **kwargs):
                        """
                        Defines heat-exchanger group.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_group").execute(*args, **kwargs)
                    def heat_exchanger_model(self, *args, **kwargs):
                        """
                        Defines heat-exchanger core model.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_model").execute(*args, **kwargs)
                    def write_NTU(self, *args, **kwargs):
                        """
                        Writes NTU vs. primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/write_NTU").execute(*args, **kwargs)
                    def heat_exchanger_macro_report(self, *args, **kwargs):
                        """
                        Reports the computed values of heat rejection, outlet temperature, and inlet temperature for the macroscopic cells (macros) in a heat exchanger.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_macro_report").execute(*args, **kwargs)
                    def delete_heat_exchanger_group(self, *args, **kwargs):
                        """
                        Deletes heat-exchanger group.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/delete_heat_exchanger_group").execute(*args, **kwargs)
                    def heat_exchanger_zone(self, *args, **kwargs):
                        """
                        Specifies the zone that represents the heat exchanger, the dimensions of the heat exchanger, the macro grid, and the coolant direction and properties.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/macro_model/heat_exchanger_zone").execute(*args, **kwargs)

                class dual_cell_model(TUIMenu):
                    """
                    Enters the dual cell model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def heat_exchanger(self, *args, **kwargs):
                        """
                        Enables/disables the dual cell heat-exchanger model.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/heat_exchanger").execute(*args, **kwargs)
                    def plot_NTU(self, *args, **kwargs):
                        """
                        Plots NTU vs. primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/plot_NTU").execute(*args, **kwargs)
                    def add_heat_exchanger(self, *args, **kwargs):
                        """
                        Adds heat-exchanger.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/add_heat_exchanger").execute(*args, **kwargs)
                    def alternative_formulation(self, *args, **kwargs):
                        """
                        Enables/disables alternative formulation for heat transfer calculations.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/alternative_formulation").execute(*args, **kwargs)
                    def modify_heat_exchanger(self, *args, **kwargs):
                        """
                        Modifies heat-exchanger.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/modify_heat_exchanger").execute(*args, **kwargs)
                    def write_NTU(self, *args, **kwargs):
                        """
                        Writes NTU vs. primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/write_NTU").execute(*args, **kwargs)
                    def delete_heat_exchanger(self, *args, **kwargs):
                        """
                        Deletes heat-exchanger.
                        """
                        return PyMenu(self.service, "/define/models/heat_exchanger/dual_cell_model/delete_heat_exchanger").execute(*args, **kwargs)

        class periodic_conditions(TUIMenu):
            """
            Enters the periodic conditions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def pressure_gradient_specification(self, *args, **kwargs):
                """
                Enables/disables specification of pressure gradient at the periodic boundary.
                """
                return PyMenu(self.service, "/define/periodic_conditions/pressure_gradient_specification").execute(*args, **kwargs)
            def massflow_rate_specification(self, *args, **kwargs):
                """
                Enables/disables specification of mass flow rate at the periodic boundary.
                """
                return PyMenu(self.service, "/define/periodic_conditions/massflow_rate_specification").execute(*args, **kwargs)

        class user_defined(TUIMenu):
            """
            Enters the user-defined functions and scalars menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.real_gas_models = self.__class__.real_gas_models(path + ["real_gas_models"], service)
                super().__init__(path, service)
            def use_built_in_compiler(self, *args, **kwargs):
                """
                Enables/disables the use of a built-in compiler (Clang) when the define/user-defined/compiled-functions text command is used. This text command / compiler is available for Windows only, and is provided as part of the ANSYS Fluent installation. It is recommended that you enable this text command when the compiler you installed on your machine is an older version that is no longer supported. Note that the built-in compiler is used automatically if Fluent determines that you have not installed Microsoft Visual Studio or Clang on your computer, whether this text command is enabled or not.
                """
                return PyMenu(self.service, "/define/user_defined/use_built_in_compiler").execute(*args, **kwargs)
            def user_defined_node_memory(self, *args, **kwargs):
                """
                Allocate user-defined node memory.
                """
                return PyMenu(self.service, "/define/user_defined/user_defined_node_memory").execute(*args, **kwargs)
            def enable_udf_on_gpu(self, *args, **kwargs):
                """
                Compile UDFs with OpenCL support.
                """
                return PyMenu(self.service, "/define/user_defined/enable_udf_on_gpu").execute(*args, **kwargs)
            def use_contributed_cpp(self, *args, **kwargs):
                """
                Enable/disable use of cpp from the Fluent.Inc/contrib directory.
                """
                return PyMenu(self.service, "/define/user_defined/use_contributed_cpp").execute(*args, **kwargs)
            def user_defined_memory(self, *args, **kwargs):
                """
                Allocates user-defined memory.
                """
                return PyMenu(self.service, "/define/user_defined/user_defined_memory").execute(*args, **kwargs)
            def one_D_coupling(self, *args, **kwargs):
                """
                Load 1D library.
                """
                return PyMenu(self.service, "/define/user_defined/one_D_coupling").execute(*args, **kwargs)
            def execute_on_demand(self, *args, **kwargs):
                """
                Executes UDFs on demand.
                """
                return PyMenu(self.service, "/define/user_defined/execute_on_demand").execute(*args, **kwargs)
            def compile_customized_addon_module(self, *args, **kwargs):
                """
                Compile customized addon module?.
                """
                return PyMenu(self.service, "/define/user_defined/compile_customized_addon_module").execute(*args, **kwargs)
            def interpreted_functions(self, *args, **kwargs):
                """
                Loads interpreted user-defined functions.
                """
                return PyMenu(self.service, "/define/user_defined/interpreted_functions").execute(*args, **kwargs)
            def auto_compile_compiled_udfs(self, *args, **kwargs):
                """
                For this Fluent session, specify whether to allow auto-compilation of compiled UDF when a case file (or settings file) is read.
                """
                return PyMenu(self.service, "/define/user_defined/auto_compile_compiled_udfs").execute(*args, **kwargs)
            def function_hooks(self, *args, **kwargs):
                """
                Hooks up user-defined functions.
                """
                return PyMenu(self.service, "/define/user_defined/function_hooks").execute(*args, **kwargs)
            def fan_model(self, *args, **kwargs):
                """
                Configures user-defined fan model.
                """
                return PyMenu(self.service, "/define/user_defined/fan_model").execute(*args, **kwargs)
            def compiled_functions(self, *args, **kwargs):
                """
                Opens user-defined function library.
                """
                return PyMenu(self.service, "/define/user_defined/compiled_functions").execute(*args, **kwargs)
            def user_defined_scalars(self, *args, **kwargs):
                """
                Defines user-defined scalars.
                """
                return PyMenu(self.service, "/define/user_defined/user_defined_scalars").execute(*args, **kwargs)

            class real_gas_models(TUIMenu):
                """
                Enters the real-gas menu to enable/configure real gas model.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def user_defined_real_gas_model(self, *args, **kwargs):
                    """
                    Loads the user-defined real-gas library.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/user_defined_real_gas_model").execute(*args, **kwargs)
                def nist_real_gas_model(self, *args, **kwargs):
                    """
                    Loads the NIST real-gas library.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/nist_real_gas_model").execute(*args, **kwargs)
                def nist_settings(self, *args, **kwargs):
                    """
                    Specifies the name and the location for the REFPROP library and fluid files.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/nist_settings").execute(*args, **kwargs)
                def nist_multispecies_real_gas_model(self, *args, **kwargs):
                    """
                    Loads the NIST real-gas library.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/nist_multispecies_real_gas_model").execute(*args, **kwargs)
                def user_defined_multispecies_real_gas_model(self, *args, **kwargs):
                    """
                    Loads a user-defined multispecies real-gas library.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/user_defined_multispecies_real_gas_model").execute(*args, **kwargs)
                def set_state(self, *args, **kwargs):
                    """
                    Selects the state for NIST real gas model.
                    """
                    return PyMenu(self.service, "/define/user_defined/real_gas_models/set_state").execute(*args, **kwargs)

        class mesh_interfaces(TUIMenu):
            """
            Enters the mesh-interfaces menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.mapped_interface_options = self.__class__.mapped_interface_options(path + ["mapped_interface_options"], service)
                self.auto_options = self.__class__.auto_options(path + ["auto_options"], service)
                self.non_conformal_interface_numerics = self.__class__.non_conformal_interface_numerics(path + ["non_conformal_interface_numerics"], service)
                super().__init__(path, service)
            def verbosity(self, *args, **kwargs):
                """
                Sets the mesh interface verbosity.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/verbosity").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Displays the specified mesh interface zone.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/display").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a mesh interface.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/delete").execute(*args, **kwargs)
            def improve_quality(self, *args, **kwargs):
                """
                Checks the quality of all mapped interfaces. If Fluent finds any mapped interfaces that require improvement it will list them and ask you if you would like to increase the tolerance to improve the interfaces.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/improve_quality").execute(*args, **kwargs)
            def make_phaselag_from_periodic(self, *args, **kwargs):
                """
                Convert periodic interface to phase lagged.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/make_phaselag_from_periodic").execute(*args, **kwargs)
            def make_periodic(self, *args, **kwargs):
                """
                Make interface zones periodic.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/make_periodic").execute(*args, **kwargs)
            def enable_visualization_of_interfaces(self, *args, **kwargs):
                """
                Enables/disables the filling of node coordinates on the zones of mesh interfaces, so that they can be displayed in the graphics window.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/enable_visualization_of_interfaces").execute(*args, **kwargs)
            def enforce_continuity_after_bc(self, *args, **kwargs):
                """
                Enables/disables continuity across the boundary condition interface for contour plots in postprocessing.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/enforce_continuity_after_bc").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all mesh interfaces.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/list").execute(*args, **kwargs)
            def make_phaselag_from_boundaries(self, *args, **kwargs):
                """
                Make interface zones phase lagged.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/make_phaselag_from_boundaries").execute(*args, **kwargs)
            def turbo_create(self, *args, **kwargs):
                """
                Creates a general turbo interface. This text command is only available if the define/turbo-model/enable-turbo-model? text command is enabled.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/turbo_create").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits attributes of existing mesh interfaces. For one-to-one interfaces, you can edit the name; for many-to-many interfaces, you can edit the interface options and (for a single interface) the name and the list of interface zones assigned to the interface.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/edit").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Creates mesh interfaces.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/create").execute(*args, **kwargs)
            def enforce_coupled_wall_between_solids(self, *args, **kwargs):
                """
                Enables/disables automatic definition of solid-solid interfaces as coupled walls. By default this option is disabled and ANSYS Fluent creates interior boundaries at solid-solid interfaces.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/enforce_coupled_wall_between_solids").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all mesh interfaces.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/delete_all").execute(*args, **kwargs)
            def remove_left_handed_interface_faces(self, *args, **kwargs):
                """
                Removes left-handed faces (which can cause the mesh to be invalid) during mesh interface creation.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/remove_left_handed_interface_faces").execute(*args, **kwargs)
            def auto_pairing(self, *args, **kwargs):
                """
                Automatically "pairs" some or all of the interface zones, in order to create mesh interfaces. This text command is only available when the define/mesh-interfaces/one-to-one-pairing? text command is disabled.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/auto_pairing").execute(*args, **kwargs)
            def transfer_motion_across_interfaces(self, *args, **kwargs):
                """
                Enables/disables the automatic transfer of motion across a mesh interface when only one side is moving as a result of user-defined or system coupling motion. You can specify the method by which the motion is transferred: transfer-displacements (the default) interpolates nodal displacement from the active side of the interface to the passive side, and is recommended when there are gaps and/or penetrations in the mesh interface that must be maintained; project-nodes projects the passive nodes onto the faces of active side, and is recommended when the active side includes significant tangential motion (as only the normal displacement is effectively transferred in this method).
                """
                return PyMenu(self.service, "/define/mesh_interfaces/transfer_motion_across_interfaces").execute(*args, **kwargs)
            def enable_si_with_nodes(self, *args, **kwargs):
                """
                Enable sliding interfaces with nodes.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/enable_si_with_nodes").execute(*args, **kwargs)
            def one_to_one_pairing(self, *args, **kwargs):
                """
                Use the default one-to-one interface creation method?.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/one_to_one_pairing").execute(*args, **kwargs)
            def non_overlapping_zone_name(self, *args, **kwargs):
                """
                Get non-overlapping zone name from the associated interface zone.
                """
                return PyMenu(self.service, "/define/mesh_interfaces/non_overlapping_zone_name").execute(*args, **kwargs)

            class mapped_interface_options(TUIMenu):
                """
                Enter the mapped-interface-options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def tolerance(self, *args, **kwargs):
                    """
                    Specification of mapped interface tolerance.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/mapped_interface_options/tolerance").execute(*args, **kwargs)
                def solution_controls(self, *args, **kwargs):
                    """
                    Specification of mapped frequency and under-relaxation factor for mapped interfaces.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/mapped_interface_options/solution_controls").execute(*args, **kwargs)
                def convert_to_mapped_interface(self, *args, **kwargs):
                    """
                    Convert non-conformal mesh interface to mapped mesh interfaces.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/mapped_interface_options/convert_to_mapped_interface").execute(*args, **kwargs)

            class auto_options(TUIMenu):
                """
                Enters the auto-options menu. This menu is only available when the define/mesh-interfaces/one-to-one-pairing? text command is enabled.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_default_name_prefix(self, *args, **kwargs):
                    """
                    Specifies the default interface 	name prefix used for one-to-one mesh interfaces.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/auto_options/set_default_name_prefix").execute(*args, **kwargs)
                def pairing_between_interface_zones_only(self, *args, **kwargs):
                    """
                    Pairing between interface zones only.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/auto_options/pairing_between_interface_zones_only").execute(*args, **kwargs)
                def naming_option(self, *args, **kwargs):
                    """
                    Specifies whether the name of each new one-to-one mesh 	interface (as well as existing mesh interfaces, if you 	so desire) has no additional suffix, or a suffix that 	includes the names of the associated boundary zones, the 	IDs of the associated boundary zones, or the names of 	the adjacent cell zones.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/auto_options/naming_option").execute(*args, **kwargs)
                def proximity_tolerance(self, *args, **kwargs):
                    """
                    Sets the tolerance used as part 	of the automatic grouping of zones to create mesh 	interfaces when the define/mesh-interfaces/one-to-one-pairing? 	text command is disabled. The proximity tolerance is 	defined relative to the edge lengths in the interface 	zones, and can range from 0 to 1 (representing the minimum 	and maximum edge lengths, respectively).
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/auto_options/proximity_tolerance").execute(*args, **kwargs)
                def set_one_to_one_pairing_tolerance(self, *args, **kwargs):
                    """
                    Enables/disables the use of adjustable tolerances to 	determine which of the selected boundary zones can be 	paired up to make the mesh interfaces, in order to 	account for gaps, thin layers, and/or complex 	geometries.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/auto_options/set_one_to_one_pairing_tolerance").execute(*args, **kwargs)
                def pairing_between_different_cell_zones_only(self, *args, **kwargs):
                    """
                    Specifies whether the 	one-to-one mesh interfaces are only created between 	different cell zones.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/auto_options/pairing_between_different_cell_zones_only").execute(*args, **kwargs)
                def keep_empty_interface(self, *args, **kwargs):
                    """
                    Keep empty interfaces during one-to-one mesh interface creation.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/auto_options/keep_empty_interface").execute(*args, **kwargs)

            class non_conformal_interface_numerics(TUIMenu):
                """
                Setting non-conformal numerics options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def change_numerics(self, *args, **kwargs):
                    """
                    Enable modified non-conformal interface numerics.
                    """
                    return PyMenu(self.service, "/define/mesh_interfaces/non_conformal_interface_numerics/change_numerics").execute(*args, **kwargs)

        class turbo_model(TUIMenu):
            """
            Enters the turbo menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.general_turbo_interface_settings = self.__class__.general_turbo_interface_settings(path + ["general_turbo_interface_settings"], service)
                self.blade_flutter_harmonics = self.__class__.blade_flutter_harmonics(path + ["blade_flutter_harmonics"], service)
                self.turbo_topology = self.__class__.turbo_topology(path + ["turbo_topology"], service)
                super().__init__(path, service)
            def isentropic_efficiency(self, *args, **kwargs):
                """
                Compute isentropic efficiency using general property functions for enthalpy.
                """
                return PyMenu(self.service, "/define/turbo_model/isentropic_efficiency").execute(*args, **kwargs)
            def separate_nonoverlapping_interface_boundary(self, *args, **kwargs):
                """
                Split a general turbo interface non-overlapping zone.
                """
                return PyMenu(self.service, "/define/turbo_model/separate_nonoverlapping_interface_boundary").execute(*args, **kwargs)
            def append_phaselag_spectral_content(self, *args, **kwargs):
                """
                Define phaselag related spectral content.
                """
                return PyMenu(self.service, "/define/turbo_model/append_phaselag_spectral_content").execute(*args, **kwargs)
            def delete_phaselag_spectral_content(self, *args, **kwargs):
                """
                Delete phaselag related spectral content.
                """
                return PyMenu(self.service, "/define/turbo_model/delete_phaselag_spectral_content").execute(*args, **kwargs)
            def phaselag_extra_settings(self, *args, **kwargs):
                """
                Define phaselag related extra settings.
                """
                return PyMenu(self.service, "/define/turbo_model/phaselag_extra_settings").execute(*args, **kwargs)
            def enable_turbo_model(self, *args, **kwargs):
                """
                Enables/disables turbo model menu.
                """
                return PyMenu(self.service, "/define/turbo_model/enable_turbo_model").execute(*args, **kwargs)
            def blade_flutter_row(self, *args, **kwargs):
                """
                Define the periodic displacement row.
                """
                return PyMenu(self.service, "/define/turbo_model/blade_flutter_row").execute(*args, **kwargs)
            def turbo_interface_check(self, *args, **kwargs):
                """
                Check General Turbo Interface and Phase-lag.
                """
                return PyMenu(self.service, "/define/turbo_model/turbo_interface_check").execute(*args, **kwargs)
            def make_phaselag_from_periodic(self, *args, **kwargs):
                """
                Convert periodic interface to phase lagged.
                """
                return PyMenu(self.service, "/define/turbo_model/make_phaselag_from_periodic").execute(*args, **kwargs)
            def create_turbomachine_description(self, *args, **kwargs):
                """
                Define turbomachine description.
                """
                return PyMenu(self.service, "/define/turbo_model/create_turbomachine_description").execute(*args, **kwargs)
            def make_phaselag_from_boundaries(self, *args, **kwargs):
                """
                Make interface zones phase lagged.
                """
                return PyMenu(self.service, "/define/turbo_model/make_phaselag_from_boundaries").execute(*args, **kwargs)
            def list_graphics_spectral_content(self, *args, **kwargs):
                """
                List post-processing related spectral content.
                """
                return PyMenu(self.service, "/define/turbo_model/list_graphics_spectral_content").execute(*args, **kwargs)
            def list_turbomachine_description(self, *args, **kwargs):
                """
                List turbomachine description.
                """
                return PyMenu(self.service, "/define/turbo_model/list_turbomachine_description").execute(*args, **kwargs)
            def graphics_extra_settings(self, *args, **kwargs):
                """
                Define phaselag related extra settings.
                """
                return PyMenu(self.service, "/define/turbo_model/graphics_extra_settings").execute(*args, **kwargs)
            def create_graphics_spectral_content(self, *args, **kwargs):
                """
                Define post-processing related spectral content.
                """
                return PyMenu(self.service, "/define/turbo_model/create_graphics_spectral_content").execute(*args, **kwargs)
            def delete_graphics_spectral_content(self, *args, **kwargs):
                """
                Delete post-processing related spectral content.
                """
                return PyMenu(self.service, "/define/turbo_model/delete_graphics_spectral_content").execute(*args, **kwargs)
            def append_graphics_spectral_content(self, *args, **kwargs):
                """
                Define post-processing related spectral content.
                """
                return PyMenu(self.service, "/define/turbo_model/append_graphics_spectral_content").execute(*args, **kwargs)
            def create_phaselag_spectral_content(self, *args, **kwargs):
                """
                Define phaselag related spectral content.
                """
                return PyMenu(self.service, "/define/turbo_model/create_phaselag_spectral_content").execute(*args, **kwargs)
            def list_phaselag_state(self, *args, **kwargs):
                """
                List all phaselag related case settings.
                """
                return PyMenu(self.service, "/define/turbo_model/list_phaselag_state").execute(*args, **kwargs)
            def delete_turbomachine_description(self, *args, **kwargs):
                """
                Delete turbomachine description.
                """
                return PyMenu(self.service, "/define/turbo_model/delete_turbomachine_description").execute(*args, **kwargs)
            def turbo_create(self, *args, **kwargs):
                """
                Creates a general turbo interface.
                """
                return PyMenu(self.service, "/define/turbo_model/turbo_create").execute(*args, **kwargs)

            class general_turbo_interface_settings(TUIMenu):
                """
                Enters the General Turbo Interface options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.mixing_plane_model_settings = self.__class__.mixing_plane_model_settings(path + ["mixing_plane_model_settings"], service)
                    super().__init__(path, service)
                def expert(self, *args, **kwargs):
                    """
                    Set the expert parameters for turbo interfaces.
                    """
                    return PyMenu(self.service, "/define/turbo_model/general_turbo_interface_settings/expert").execute(*args, **kwargs)

                class mixing_plane_model_settings(TUIMenu):
                    """
                    Defines settings for the mixing plane model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def bands_type(self, *args, **kwargs):
                        """
                        Specifies the averaging bands for mixing as fixed or variable width.
                        """
                        return PyMenu(self.service, "/define/turbo_model/general_turbo_interface_settings/mixing_plane_model_settings/bands_type").execute(*args, **kwargs)
                    def mixing_set_constraint(self, *args, **kwargs):
                        """
                        To set the mixing of primitive or total variable approach.
                        """
                        return PyMenu(self.service, "/define/turbo_model/general_turbo_interface_settings/mixing_plane_model_settings/mixing_set_constraint").execute(*args, **kwargs)
                    def number_of_bands(self, *args, **kwargs):
                        """
                        Sets the number of bands to be used for mixing.
                        """
                        return PyMenu(self.service, "/define/turbo_model/general_turbo_interface_settings/mixing_plane_model_settings/number_of_bands").execute(*args, **kwargs)
                    def list_mixing_planes(self, *args, **kwargs):
                        """
                        List the settings of mixing planes in the case.
                        """
                        return PyMenu(self.service, "/define/turbo_model/general_turbo_interface_settings/mixing_plane_model_settings/list_mixing_planes").execute(*args, **kwargs)
                    def averaging_method(self, *args, **kwargs):
                        """
                        Set the averaging method for the mixing.
                        """
                        return PyMenu(self.service, "/define/turbo_model/general_turbo_interface_settings/mixing_plane_model_settings/averaging_method").execute(*args, **kwargs)

            class blade_flutter_harmonics(TUIMenu):
                """
                Enters the blade flutter harmonics options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def write_harmonic_exports(self, *args, **kwargs):
                    """
                    Writes harmonic export data.
                    """
                    return PyMenu(self.service, "/define/turbo_model/blade_flutter_harmonics/write_harmonic_exports").execute(*args, **kwargs)
                def write_aerodamping_vs_nodal_diameter(self, *args, **kwargs):
                    """
                    Reads report definition file and Writes influence coefficient aerodynamic damping values vs nodal diameter.
                    """
                    return PyMenu(self.service, "/define/turbo_model/blade_flutter_harmonics/write_aerodamping_vs_nodal_diameter").execute(*args, **kwargs)
                def enable_harmonic_exports(self, *args, **kwargs):
                    """
                    Calculates/Deletes flutter harmonic export data.
                    """
                    return PyMenu(self.service, "/define/turbo_model/blade_flutter_harmonics/enable_harmonic_exports").execute(*args, **kwargs)

            class turbo_topology(TUIMenu):
                """
                Enters the turbo topology menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def define_topology(self, *args, **kwargs):
                    """
                    Defines a turbo topology.
                    """
                    return PyMenu(self.service, "/define/turbo_model/turbo_topology/define_topology").execute(*args, **kwargs)
                def search_method(self, *args, **kwargs):
                    """
                    Sets search method for a topology.
                    """
                    return PyMenu(self.service, "/define/turbo_model/turbo_topology/search_method").execute(*args, **kwargs)
                def mesh_method(self, *args, **kwargs):
                    """
                    Sets turbo structured mesh generation method.
                    """
                    return PyMenu(self.service, "/define/turbo_model/turbo_topology/mesh_method").execute(*args, **kwargs)
                def projection_method(self, *args, **kwargs):
                    """
                    Sets 2D projection method.
                    """
                    return PyMenu(self.service, "/define/turbo_model/turbo_topology/projection_method").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes a previously created turbo topology.
                    """
                    return PyMenu(self.service, "/define/turbo_model/turbo_topology/delete").execute(*args, **kwargs)

        class boundary_conditions(TUIMenu):
            """
            Enters the boundary conditions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.rename_zone = self.__class__.rename_zone(path + ["rename_zone"], service)
                self.perforated_walls = self.__class__.perforated_walls(path + ["perforated_walls"], service)
                self.set = self.__class__.set(path + ["set"], service)
                self.bc_settings = self.__class__.bc_settings(path + ["bc_settings"], service)
                self.impedance_data_fitting = self.__class__.impedance_data_fitting(path + ["impedance_data_fitting"], service)
                self.advanced = self.__class__.advanced(path + ["advanced"], service)
                self.modify_zones = self.__class__.modify_zones(path + ["modify_zones"], service)
                self.non_reflecting_bc = self.__class__.non_reflecting_bc(path + ["non_reflecting_bc"], service)
                super().__init__(path, service)
            def openchannel_threads(self, *args, **kwargs):
                """
                Lists open channel group IDs, names, types and variables.
                """
                return PyMenu(self.service, "/define/boundary_conditions/openchannel_threads").execute(*args, **kwargs)
            def intake_fan(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/intake_fan").execute(*args, **kwargs)
            def degassing(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/degassing").execute(*args, **kwargs)
            def recirculation_outlet(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/recirculation_outlet").execute(*args, **kwargs)
            def exhaust_fan(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/exhaust_fan").execute(*args, **kwargs)
            def knudsen_number_calculator(self, *args, **kwargs):
                """
                Computes the Knudsen number based on a characteristic physical length and the area-averaged flow quantities along an incoming-flow boundary. You can use this information to determine flow regime for selecting the appropriate wall boundary treatment. For details, see .
                """
                return PyMenu(self.service, "/define/boundary_conditions/knudsen_number_calculator").execute(*args, **kwargs)
            def network(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/network").execute(*args, **kwargs)
            def zone_type(self, *args, **kwargs):
                """
                Sets the type for a zone or multiple zones of the same category. You will be prompted for the name / ID of the zone to be changed and the new type for that zone. To change multiple zones, you can enter a list (separated by spaces and contained within a pair of parentheses) or use asterisks (\*) as wildcards.
                """
                return PyMenu(self.service, "/define/boundary_conditions/zone_type").execute(*args, **kwargs)
            def mass_flow_inlet(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/mass_flow_inlet").execute(*args, **kwargs)
            def interior(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/interior").execute(*args, **kwargs)
            def network_end(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/network_end").execute(*args, **kwargs)
            def overset(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/overset").execute(*args, **kwargs)
            def porous_jump(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/porous_jump").execute(*args, **kwargs)
            def target_mass_flow_rate_settings(self, *args, **kwargs):
                """
                Enters the targeted mass flow rate settings menu.
                """
                return PyMenu(self.service, "/define/boundary_conditions/target_mass_flow_rate_settings").execute(*args, **kwargs)
            def radiator(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/radiator").execute(*args, **kwargs)
            def zone_name(self, *args, **kwargs):
                """
                Gives a zone a new name.
                """
                return PyMenu(self.service, "/define/boundary_conditions/zone_name").execute(*args, **kwargs)
            def rans_les_interface(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/rans_les_interface").execute(*args, **kwargs)
            def copy_bc(self, *args, **kwargs):
                """
                Copies boundary conditions to other zones.
                """
                return PyMenu(self.service, "/define/boundary_conditions/copy_bc").execute(*args, **kwargs)
            def geometry(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/geometry").execute(*args, **kwargs)
            def axis(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/axis").execute(*args, **kwargs)
            def outlet_vent(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/outlet_vent").execute(*args, **kwargs)
            def fan(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/fan").execute(*args, **kwargs)
            def pressure_far_field(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/pressure_far_field").execute(*args, **kwargs)
            def wall(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/wall").execute(*args, **kwargs)
            def interface(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/interface").execute(*args, **kwargs)
            def periodic(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/periodic").execute(*args, **kwargs)
            def non_overlapping_zone_name(self, *args, **kwargs):
                """
                Displays the name of the non-overlapping zone associated with a specified interface zone. This text command is only available after a mesh interface has been created.
                """
                return PyMenu(self.service, "/define/boundary_conditions/non_overlapping_zone_name").execute(*args, **kwargs)
            def pressure_outlet(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/pressure_outlet").execute(*args, **kwargs)
            def open_channel_wave_settings(self, *args, **kwargs):
                """
                Opens channel wave input analysis.
                """
                return PyMenu(self.service, "/define/boundary_conditions/open_channel_wave_settings").execute(*args, **kwargs)
            def fluid(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/fluid").execute(*args, **kwargs)
            def inlet_vent(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/inlet_vent").execute(*args, **kwargs)
            def velocity_inlet(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/velocity_inlet").execute(*args, **kwargs)
            def outflow(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/outflow").execute(*args, **kwargs)
            def symmetry(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/symmetry").execute(*args, **kwargs)
            def shadow(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/shadow").execute(*args, **kwargs)
            def pressure_inlet(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/pressure_inlet").execute(*args, **kwargs)
            def solid(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/solid").execute(*args, **kwargs)
            def recirculation_inlet(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/recirculation_inlet").execute(*args, **kwargs)
            def mass_flow_outlet(self, *args, **kwargs):
                """
                Sets boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/define/boundary_conditions/mass_flow_outlet").execute(*args, **kwargs)
            def list_zones(self, *args, **kwargs):
                """
                Prints out the types and IDs of all zones in the console window. You can use your mouse to check a zone ID, following the instructions listed under Zone in the
                Boundary Conditions Task Page
                section of the User’s Guide.
                """
                return PyMenu(self.service, "/define/boundary_conditions/list_zones").execute(*args, **kwargs)

            class rename_zone(TUIMenu):
                """
                Enter the menu for renaming cell and face zones based on adjacency, adding suffixes or prefixes to names, and renaming zones based on the Fluent naming conventions.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def rename_to_default(self, *args, **kwargs):
                    """
                    Rename a zone to use the Fluent naming 	convention.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/rename_zone/rename_to_default").execute(*args, **kwargs)
                def rename_by_adjacency(self, *args, **kwargs):
                    """
                    Append the name of the adjacent cell zone to the 	specified face zone. For example, if fluid is the adjacent cell 	zone, and you select a face zone named interior, the resulting name of 	the face zone would be interior-fluid.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/rename_zone/rename_by_adjacency").execute(*args, **kwargs)
                def add_suffix_or_prefix(self, *args, **kwargs):
                    """
                    Add a suffix or prefix to one or more zones.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/rename_zone/add_suffix_or_prefix").execute(*args, **kwargs)

            class perforated_walls(TUIMenu):
                """
                Enters the perforated walls menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def read_input_file(self, *args, **kwargs):
                    """
                    Reads an input file for perforated walls.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/perforated_walls/read_input_file").execute(*args, **kwargs)
                def model_setup(self, *args, **kwargs):
                    """
                    Sets up the perforated wall model for each effusion 	surface.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/perforated_walls/model_setup").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Allows you to define one or more settings at single or multiple boundaries/cell zones of a given type at once. Enter q to exit the define/boundary-conditions/set/<type> command.  For a description of the items in this menu, see corresponding define/boundary-conditions/<type>.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def porous_jump(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/porous_jump").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/exhaust_fan").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/fluid").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/recirculation_outlet").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/interior").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/radiator").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/pressure_outlet").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/overset").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/axis").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/mass_flow_outlet").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/symmetry").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/pressure_far_field").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/velocity_inlet").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/degassing").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/rans_les_interface").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/outlet_vent").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/wall").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/shadow").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/interface").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/network_end").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/fan").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/periodic").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/pressure_inlet").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/network").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/recirculation_inlet").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/outflow").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/solid").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/intake_fan").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/mass_flow_inlet").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/geometry").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/set/inlet_vent").execute(*args, **kwargs)

            class bc_settings(TUIMenu):
                """
                Enters the boundary conditions settings menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.pressure_far_field = self.__class__.pressure_far_field(path + ["pressure_far_field"], service)
                    super().__init__(path, service)
                def mass_flow(self, *args, **kwargs):
                    """
                    Selects method for setting the mass flow rate.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/bc_settings/mass_flow").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Sets advanced options for pressure outlet boundaries.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/bc_settings/pressure_outlet").execute(*args, **kwargs)

                class pressure_far_field(TUIMenu):
                    """
                    Sets advanced options for pressure far field 	boundaries.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def riemann_invariants_tangency_correction(self, *args, **kwargs):
                        """
                        Enables/disables the Riemann-invariant tangency correction as described in .
                        """
                        return PyMenu(self.service, "/define/boundary_conditions/bc_settings/pressure_far_field/riemann_invariants_tangency_correction").execute(*args, **kwargs)
                    def type(self, *args, **kwargs):
                        """
                        Choose pressure-far-field boundary-condition type.
                        """
                        return PyMenu(self.service, "/define/boundary_conditions/bc_settings/pressure_far_field/type").execute(*args, **kwargs)

            class impedance_data_fitting(TUIMenu):
                """
                Enters the impedance data fitting menu, which provides text commands that can be helpful when you are using the impedance boundary condition (IBC).
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def verbosity(self, *args, **kwargs):
                    """
                    Sets the verbosity of the progress messages during the fitting performed from the define/boundary-conditions/impedance-data-fitting/ 	text command menu. Setting this to 1 results in messages being 	printed in the console as the fitting calculation 	progresses. The default value of 0 suppresses this 	output.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/impedance_data_fitting/verbosity").execute(*args, **kwargs)
                def absorption_data(self, *args, **kwargs):
                    """
                    Reads an input file with experimental absorption coefficient data in the frequency 	domain and then computes the terms needed for an 	approximation of the reflection coefficient as a series 	of poles / residues in the time domain. The resulting 	terms are printed in the console, and can be written to 	a pole / residue file (which can be imported and the 	impedance parameters applied to a boundary condition 	using the define/boundary-conditions/impedance-data-fitting/import-parameters 	text command). You can also write a file with fitted 	frequency / impedance data, which can be compared to the 	input data to evaluate how well it fits.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/impedance_data_fitting/absorption_data").execute(*args, **kwargs)
                def reflection_data(self, *args, **kwargs):
                    """
                    Reads an input file with experimental reflection coefficient data in the frequency 	domain and then computes the terms needed for an 	approximation of the reflection coefficient as a series 	of poles / residues in the time domain. The resulting 	terms are printed in the console, and can be written to 	a pole / residue file (which can be imported and the 	impedance parameters applied to a boundary condition 	using the define/boundary-conditions/impedance-data-fitting/import-parameters 	text command). You can also write a file with fitted 	frequency / impedance data, which can be compared to the 	input data to evaluate how well it fits.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/impedance_data_fitting/reflection_data").execute(*args, **kwargs)
                def import_parameters(self, *args, **kwargs):
                    """
                    Reads a pole / residue file with impedance parameters 	in the time domain and applies them to a specified 	boundary condition.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/impedance_data_fitting/import_parameters").execute(*args, **kwargs)
                def impedance_data(self, *args, **kwargs):
                    """
                    Reads an input file with experimental specific 	impedance data in the frequency domain and then computes 	the terms needed for an approximation of the reflection 	coefficient as a series of poles / residues in the time 	domain. The resulting terms are printed in the console, 	and can be written to a pole / residue file (which can 	be imported and the impedance parameters applied to a 	boundary condition using the define/boundary-conditions/impedance-data-fitting/import-parameters 	text command). You can also write a file with fitted 	frequency / impedance data, which can be compared to the 	input data to evaluate how well it fits.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/impedance_data_fitting/impedance_data").execute(*args, **kwargs)
                def convergence_tolerance(self, *args, **kwargs):
                    """
                    Sets the convergence tolerance, which is an accuracy 	that is used for completing the iterative fitting 	procedure in the calculations performed from the define/boundary-conditions/impedance-data-fitting/ 	text command menu. By default, the tolerance is set to 	1e-6.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/impedance_data_fitting/convergence_tolerance").execute(*args, **kwargs)
                def iterations(self, *args, **kwargs):
                    """
                    Sets the number of internal iterations used for the calculations performed from the define/boundary-conditions/impedance-data-fitting/ 	text command menu. By default, the number of iterations 	is set to 20.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/impedance_data_fitting/iterations").execute(*args, **kwargs)
                def residue_tolerance(self, *args, **kwargs):
                    """
                    Sets the residue tolerance, which is the minimum value of residues that are kept in 	the fitting performed from the define/boundary-conditions/impedance-data-fitting/ 	text command menu. This residue check helps to eliminate 	parasitic poles. By default, the tolerance is set to 	1e-6.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/impedance_data_fitting/residue_tolerance").execute(*args, **kwargs)

            class advanced(TUIMenu):
                """
                Control settings while doing BC setup.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delay_model_change_update(self, *args, **kwargs):
                    """
                    Set model change call update.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/advanced/delay_model_change_update").execute(*args, **kwargs)
                def batch_thread_update(self, *args, **kwargs):
                    """
                    Set batch thread update option.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/advanced/batch_thread_update").execute(*args, **kwargs)

            class modify_zones(TUIMenu):
                """
                Enters the modify zones menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def sep_cell_zone_mark(self, *args, **kwargs):
                    """
                    Separates cell zone based on cell marking.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/sep_cell_zone_mark").execute(*args, **kwargs)
                def recreate_all_shells(self, *args, **kwargs):
                    """
                    Recreates shells on all the walls that were deleted using the command delete-all-shells.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/recreate_all_shells").execute(*args, **kwargs)
                def sep_face_zone_face(self, *args, **kwargs):
                    """
                    Separates each face in zone into unique zone.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/sep_face_zone_face").execute(*args, **kwargs)
                def matching_tolerance(self, *args, **kwargs):
                    """
                    Sets normalized tolerance used for finding coincident nodes.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/matching_tolerance").execute(*args, **kwargs)
                def deactivate_cell_zone(self, *args, **kwargs):
                    """
                    Deactivates cell thread.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/deactivate_cell_zone").execute(*args, **kwargs)
                def delete_all_shells(self, *args, **kwargs):
                    """
                    Deletes all shell zones and switches off shell conduction on all the walls. These 	zones can be recreated using the command recreate-all-shells.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/delete_all_shells").execute(*args, **kwargs)
                def change_zone_state(self, *args, **kwargs):
                    """
                    Sets the state (liquid or vapor) for a specific fluid zone.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/change_zone_state").execute(*args, **kwargs)
                def scale_zone(self, *args, **kwargs):
                    """
                    Scales individual cell zones.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/scale_zone").execute(*args, **kwargs)
                def create_periodic_interface(self, *args, **kwargs):
                    """
                    Creates a conformal or non-conformal periodic 	interface.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/create_periodic_interface").execute(*args, **kwargs)
                def slit_face_zone(self, *args, **kwargs):
                    """
                    Slits two-sided wall into two connected wall zones.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/slit_face_zone").execute(*args, **kwargs)
                def zone_type(self, *args, **kwargs):
                    """
                    Sets the type for a zone or multiple zones of the same 	category. You will be prompted for the name / ID of the 	zone to be changed and the new type for that zone. To 	change multiple zones, you can enter a list (separated 	by spaces and contained within a pair of parentheses) or 	use asterisks (\*) as wildcards.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/zone_type").execute(*args, **kwargs)
                def change_zone_phase(self, *args, **kwargs):
                    """
                    Change the realgas phase for a zone.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/change_zone_phase").execute(*args, **kwargs)
                def copy_move_cell_zone(self, *args, **kwargs):
                    """
                    Creates a copy of a cell zone that is offset from the original either by a translational 	distance or a rotational angle. In the copied zone, the 	bounding face zones are all converted to walls, any 	existing cell data is initialized to a constant value, 	and non-conformal interfaces and dynamic zones are not 	copied; otherwise, the model settings are the same as in 	the original zone. Note that if you want the copied zone 	to be connected to existing zones, you must either fuse 	the boundaries (see ) or set up a 	non-conformal interface (see ).
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/copy_move_cell_zone").execute(*args, **kwargs)
                def orient_face_zone(self, *args, **kwargs):
                    """
                    Orients the face zone.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/orient_face_zone").execute(*args, **kwargs)
                def make_periodic(self, *args, **kwargs):
                    """
                    Attempts to establish periodic/shadow face zone connectivity.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/make_periodic").execute(*args, **kwargs)
                def sep_face_zone_region(self, *args, **kwargs):
                    """
                    Separates face zone based on contiguous regions.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/sep_face_zone_region").execute(*args, **kwargs)
                def append_mesh_data(self, *args, **kwargs):
                    """
                    Appends new mesh with data.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/append_mesh_data").execute(*args, **kwargs)
                def sep_face_zone_angle(self, *args, **kwargs):
                    """
                    Separates face zone based on significant angle.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/sep_face_zone_angle").execute(*args, **kwargs)
                def merge_zones(self, *args, **kwargs):
                    """
                    Merges zones of same type and condition into one.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/merge_zones").execute(*args, **kwargs)
                def slit_periodic(self, *args, **kwargs):
                    """
                    Slits periodic zone into two symmetry zones.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/slit_periodic").execute(*args, **kwargs)
                def extrude_face_zone_para(self, *args, **kwargs):
                    """
                    Extrudes a face thread a specified distance based on a distance and a list of 	parametric locations between 0 and 1, for example, 0 0.2 	0.4 0.8 1.0.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/extrude_face_zone_para").execute(*args, **kwargs)
                def copy_mrf_to_mesh_motion(self, *args, **kwargs):
                    """
                    Copies motion variable values for origin, axis, and velocities from Frame Motion to 	Mesh Motion.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/copy_mrf_to_mesh_motion").execute(*args, **kwargs)
                def convert_all_solid_mrf_to_solid_motion(self, *args, **kwargs):
                    """
                    Converts all solid zones using frame motion to instead 	use solid motion, copying the motion variable values for 	origin, axis, and velocities.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/convert_all_solid_mrf_to_solid_motion").execute(*args, **kwargs)
                def translate_zone(self, *args, **kwargs):
                    """
                    Translates individual cell zones.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/translate_zone").execute(*args, **kwargs)
                def mrf_to_sliding_mesh(self, *args, **kwargs):
                    """
                    Changes the motion specification from MRF to moving mesh.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/mrf_to_sliding_mesh").execute(*args, **kwargs)
                def slit_interior_between_diff_solids(self, *args, **kwargs):
                    """
                    Slits the interior zone between solid zones of differing materials to create a 	coupled wall. You will generally be prompted by Fluent 	if this is necessary.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/slit_interior_between_diff_solids").execute(*args, **kwargs)
                def fuse_face_zones(self, *args, **kwargs):
                    """
                    Attempts to fuse zones by removing duplicate faces and nodes.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/fuse_face_zones").execute(*args, **kwargs)
                def copy_mesh_to_mrf_motion(self, *args, **kwargs):
                    """
                    Copies motion variable values for origin, axis, and velocities from Mesh Motion to 	Frame Motion.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/copy_mesh_to_mrf_motion").execute(*args, **kwargs)
                def rotate_zone(self, *args, **kwargs):
                    """
                    Rotates individual cell zones.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/rotate_zone").execute(*args, **kwargs)
                def zone_name(self, *args, **kwargs):
                    """
                    Gives a zone a new name.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/zone_name").execute(*args, **kwargs)
                def activate_cell_zone(self, *args, **kwargs):
                    """
                    Activates cell thread.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/activate_cell_zone").execute(*args, **kwargs)
                def list_zones(self, *args, **kwargs):
                    """
                    Lists zone IDs, types, kinds, and names.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/list_zones").execute(*args, **kwargs)
                def append_mesh(self, *args, **kwargs):
                    """
                    Appends new mesh.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/append_mesh").execute(*args, **kwargs)
                def create_all_shell_threads(self, *args, **kwargs):
                    """
                    Marks all finite thickness walls for shell creation. Shell zones will be created at 	the start of the iterations.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/create_all_shell_threads").execute(*args, **kwargs)
                def sep_cell_zone_region(self, *args, **kwargs):
                    """
                    Separates cell zone based on contiguous regions.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/sep_cell_zone_region").execute(*args, **kwargs)
                def sep_face_zone_mark(self, *args, **kwargs):
                    """
                    Separates face zone based on cell marking.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/sep_face_zone_mark").execute(*args, **kwargs)
                def replace_zone(self, *args, **kwargs):
                    """
                    Replaces cell zone.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/replace_zone").execute(*args, **kwargs)
                def extrude_face_zone_delta(self, *args, **kwargs):
                    """
                    Extrudes a face thread a specified distance based on a list of deltas.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/extrude_face_zone_delta").execute(*args, **kwargs)
                def delete_cell_zone(self, *args, **kwargs):
                    """
                    Deletes a cell thread.
                    """
                    return PyMenu(self.service, "/define/boundary_conditions/modify_zones/delete_cell_zone").execute(*args, **kwargs)

            class non_reflecting_bc(TUIMenu):
                """
                Enters the non-reflecting boundary condition menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.general_nrbc = self.__class__.general_nrbc(path + ["general_nrbc"], service)
                    self.turbo_specific_nrbc = self.__class__.turbo_specific_nrbc(path + ["turbo_specific_nrbc"], service)
                    super().__init__(path, service)

                class general_nrbc(TUIMenu):
                    """
                    Setting for general non-reflecting b.c.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set = self.__class__.set(path + ["set"], service)
                        super().__init__(path, service)

                    class set(TUIMenu):
                        """
                        Enters the setup menu for general non-reflecting b.c.’s.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def sigma(self, *args, **kwargs):
                            """
                            Sets NRBC sigma factor (default value 0.15).
                            """
                            return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/general_nrbc/set/sigma").execute(*args, **kwargs)
                        def relax(self, *args, **kwargs):
                            """
                            Set NRBC relaxation factor (default value 0.5).
                            """
                            return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/general_nrbc/set/relax").execute(*args, **kwargs)
                        def tangential_source(self, *args, **kwargs):
                            """
                            Include or not NRBC tangential source (default value #t).
                            """
                            return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/general_nrbc/set/tangential_source").execute(*args, **kwargs)
                        def sigma2(self, *args, **kwargs):
                            """
                            Sets NRBC sigma2 factor (default value 5.0).
                            """
                            return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/general_nrbc/set/sigma2").execute(*args, **kwargs)
                        def verbosity(self, *args, **kwargs):
                            """
                            Enables/disables nrbc verbosity scheme output.
                            """
                            return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/general_nrbc/set/verbosity").execute(*args, **kwargs)

                class turbo_specific_nrbc(TUIMenu):
                    """
                    Enters the turbo specific nrbc menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set = self.__class__.set(path + ["set"], service)
                        super().__init__(path, service)
                    def initialize(self, *args, **kwargs):
                        """
                        Initializes non-reflecting b.c.’s.
                        """
                        return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/turbo_specific_nrbc/initialize").execute(*args, **kwargs)
                    def show_status(self, *args, **kwargs):
                        """
                        Shows current status of non-reflecting b.c.’s.
                        """
                        return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/turbo_specific_nrbc/show_status").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enables/disables non-reflecting b.c.’s.
                        """
                        return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/turbo_specific_nrbc/enable").execute(*args, **kwargs)

                    class set(TUIMenu):
                        """
                        Enters the set menu for non-reflecting b.c. parameters.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def verbosity(self, *args, **kwargs):
                            """
                            Sets non-reflecting b.c. verbosity level. 0 : silent, 1 : basic information (default), 2 : detailed information for debugging.
                            """
                            return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/turbo_specific_nrbc/set/verbosity").execute(*args, **kwargs)
                        def discretization(self, *args, **kwargs):
                            """
                            Enables use of higher-order reconstruction at boundaries if available.
                            """
                            return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/turbo_specific_nrbc/set/discretization").execute(*args, **kwargs)
                        def under_relaxation(self, *args, **kwargs):
                            """
                            Sets non-reflecting b.c. under-relaxation factor.
                            """
                            return PyMenu(self.service, "/define/boundary_conditions/non_reflecting_bc/turbo_specific_nrbc/set/under_relaxation").execute(*args, **kwargs)

        class materials(TUIMenu):
            """
            Enters the materials menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.data_base = self.__class__.data_base(path + ["data_base"], service)
                super().__init__(path, service)
            def copy(self, *args, **kwargs):
                """
                Copies a material from the database.
                """
                return PyMenu(self.service, "/define/materials/copy").execute(*args, **kwargs)
            def change_create(self, *args, **kwargs):
                """
                Changes the properties of a locally-stored material or create a new material.   Generally, the properties you enter at the prompts will be filtered according to your case and model settings. However, some of the listed properties may not match the selection choice in the Graphics User Interface. Typically, those excessive properties in the Text User Interface will not be used in your simulation.
                """
                return PyMenu(self.service, "/define/materials/change_create").execute(*args, **kwargs)
            def list_materials(self, *args, **kwargs):
                """
                Lists all locally-stored materials.
                """
                return PyMenu(self.service, "/define/materials/list_materials").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a locally-stored material.
                """
                return PyMenu(self.service, "/define/materials/list_properties").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a material from local storage.
                """
                return PyMenu(self.service, "/define/materials/delete").execute(*args, **kwargs)
            def copy_by_formula(self, *args, **kwargs):
                """
                Copies a material from the database by formula.
                """
                return PyMenu(self.service, "/define/materials/copy_by_formula").execute(*args, **kwargs)

            class data_base(TUIMenu):
                """
                Enters the material database menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def new(self, *args, **kwargs):
                    """
                    Defines new material.
                    """
                    return PyMenu(self.service, "/define/materials/data_base/new").execute(*args, **kwargs)
                def save(self, *args, **kwargs):
                    """
                    Saves user-defined database.
                    """
                    return PyMenu(self.service, "/define/materials/data_base/save").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    Lists the properties of a material in the database.
                    """
                    return PyMenu(self.service, "/define/materials/data_base/list_properties").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits material.
                    """
                    return PyMenu(self.service, "/define/materials/data_base/edit").execute(*args, **kwargs)
                def list_materials(self, *args, **kwargs):
                    """
                    Lists all materials in the database.
                    """
                    return PyMenu(self.service, "/define/materials/data_base/list_materials").execute(*args, **kwargs)
                def database_type(self, *args, **kwargs):
                    """
                    Sets the database type 	(fluent-database, 	granta-mds, or 	user-defined).
                    """
                    return PyMenu(self.service, "/define/materials/data_base/database_type").execute(*args, **kwargs)

        class named_expressions(TUIMenu):
            """
            Enters the named expressions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def export_to_tsv(self, *args, **kwargs):
                """
                Export one or more named expressions to a file in TSV format.
                """
                return PyMenu(self.service, "/define/named_expressions/export_to_tsv").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Allows you to delete a named expression, as long as it is not in use.
                """
                return PyMenu(self.service, "/define/named_expressions/delete").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Allows you to edit the definition of a named expression.
                """
                return PyMenu(self.service, "/define/named_expressions/edit").execute(*args, **kwargs)
            def import_from_tsv(self, *args, **kwargs):
                """
                Import one or more named expressions saved in TSV format.
                """
                return PyMenu(self.service, "/define/named_expressions/import_from_tsv").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Allows you to copy an existing named expression.
                """
                return PyMenu(self.service, "/define/named_expressions/copy").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the definition of a named expression.
                """
                return PyMenu(self.service, "/define/named_expressions/list_properties").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all of the currently defined named expressions.
                """
                return PyMenu(self.service, "/define/named_expressions/list").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a new named expression.
                """
                return PyMenu(self.service, "/define/named_expressions/add").execute(*args, **kwargs)
            def compute(self, *args, **kwargs):
                """
                Computes and prints the value of an expression. This is only available for expressions that evaluate to a single value.
                """
                return PyMenu(self.service, "/define/named_expressions/compute").execute(*args, **kwargs)

        class spectral(TUIMenu):
            """
            Enter the Spectral menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def calculate_fourier_coefficients(self, *args, **kwargs):
                """
                Calculates Fourier coefficient data.
                """
                return PyMenu(self.service, "/define/spectral/calculate_fourier_coefficients").execute(*args, **kwargs)
            def delete_fourier_coefficients(self, *args, **kwargs):
                """
                Deletes Fourier coefficient data.
                """
                return PyMenu(self.service, "/define/spectral/delete_fourier_coefficients").execute(*args, **kwargs)
            def delete_harmonic_exports(self, *args, **kwargs):
                """
                Deletes Harmonic Export data.
                """
                return PyMenu(self.service, "/define/spectral/delete_harmonic_exports").execute(*args, **kwargs)
            def calculate_harmonic_exports(self, *args, **kwargs):
                """
                Calculates Harmonic Export data.
                """
                return PyMenu(self.service, "/define/spectral/calculate_harmonic_exports").execute(*args, **kwargs)

        class dynamic_mesh(TUIMenu):
            """
            Enters the dynamic mesh menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.transient_settings = self.__class__.transient_settings(path + ["transient_settings"], service)
                self.actions = self.__class__.actions(path + ["actions"], service)
                self.events = self.__class__.events(path + ["events"], service)
                self.zones = self.__class__.zones(path + ["zones"], service)
                self.controls = self.__class__.controls(path + ["controls"], service)
                super().__init__(path, service)
            def dynamic_mesh(self, *args, **kwargs):
                """
                Enables/disables the dynamic mesh solver.
                """
                return PyMenu(self.service, "/define/dynamic_mesh/dynamic_mesh").execute(*args, **kwargs)

            class transient_settings(TUIMenu):
                """
                Enters the transient dynamic mesh settings menu. This text command is only available when you enable dynamic mesh using the prompts of the define/dynamic-mesh/dynamic-mesh? text command. Solver time must also be set to Transient.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def verbosity(self, *args, **kwargs):
                    """
                    Enables/disables transient scheme verbosity for dynamic mesh cases.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/transient_settings/verbosity").execute(*args, **kwargs)
                def allow_second_order(self, *args, **kwargs):
                    """
                    Enables/disables second order transient scheme for dynamic mesh cases.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/transient_settings/allow_second_order").execute(*args, **kwargs)

            class actions(TUIMenu):
                """
                Enters the dynamic mesh action menu, where you can initiate manual remeshing (that is, remeshing without running a calculation).
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def remesh_cell_zone(self, *args, **kwargs):
                    """
                    Manually remeshes a cell zone with option to remesh adjacent dynamic face 	zones.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/actions/remesh_cell_zone").execute(*args, **kwargs)

            class events(TUIMenu):
                """
                Enters the dynamic mesh events menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def export_event_file(self, *args, **kwargs):
                    """
                    Exports dynamic mesh events to file.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/events/export_event_file").execute(*args, **kwargs)
                def import_event_file(self, *args, **kwargs):
                    """
                    Imports dynamic mesh event file.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/events/import_event_file").execute(*args, **kwargs)

            class zones(TUIMenu):
                """
                Enters the dynamic mesh zones menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def remove_interior_layer(self, *args, **kwargs):
                    """
                    Removes an interior layer cell zone.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/remove_interior_layer").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes a dynamic zone.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/delete").execute(*args, **kwargs)
                def insert_interior_layer(self, *args, **kwargs):
                    """
                    Inserts a new layer cell zone at a specified location.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/insert_interior_layer").execute(*args, **kwargs)
                def insert_boundary_layer(self, *args, **kwargs):
                    """
                    Inserts a new cell zone.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/insert_boundary_layer").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Lists the dynamic zones.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/list").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Create dynamic zone.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/create").execute(*args, **kwargs)
                def remove_boundary_layer(self, *args, **kwargs):
                    """
                    Removes a cell zone.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/zones/remove_boundary_layer").execute(*args, **kwargs)

            class controls(TUIMenu):
                """
                Enters the dynamic mesh controls menu. This text command is only available when the define/dynamic-mesh/dynamic-mesh? text command is enabled.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.implicit_update_parameters = self.__class__.implicit_update_parameters(path + ["implicit_update_parameters"], service)
                    self.smoothing_parameters = self.__class__.smoothing_parameters(path + ["smoothing_parameters"], service)
                    self.remeshing_parameters = self.__class__.remeshing_parameters(path + ["remeshing_parameters"], service)
                    self.six_dof_parameters = self.__class__.six_dof_parameters(path + ["six_dof_parameters"], service)
                    self.contact_parameters = self.__class__.contact_parameters(path + ["contact_parameters"], service)
                    self.periodic_displacement_parameters = self.__class__.periodic_displacement_parameters(path + ["periodic_displacement_parameters"], service)
                    self.in_cylinder_parameters = self.__class__.in_cylinder_parameters(path + ["in_cylinder_parameters"], service)
                    self.layering_parameters = self.__class__.layering_parameters(path + ["layering_parameters"], service)
                    super().__init__(path, service)
                def smoothing(self, *args, **kwargs):
                    """
                    Enables/disables smoothing in cell zones.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing").execute(*args, **kwargs)
                def steady_pseudo_time_control(self, *args, **kwargs):
                    """
                    Enables/disables the pseudo time step control in the 	graphical user interface.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/controls/steady_pseudo_time_control").execute(*args, **kwargs)
                def remeshing(self, *args, **kwargs):
                    """
                    Enables/disables local remeshing in tri/tet and mixed cell zones.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing").execute(*args, **kwargs)
                def layering(self, *args, **kwargs):
                    """
                    Enables/disables dynamic-layering in quad/hex cell zones.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/controls/layering").execute(*args, **kwargs)
                def in_cylinder_output(self, *args, **kwargs):
                    """
                    Enables/disables in-cylinder output.
                    """
                    return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_output").execute(*args, **kwargs)

                class implicit_update_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh implicit update menu. This text command is only available 	when you enable implicit mesh updating using the prompts 	of the define/dynamic-mesh/dynamic-mesh? 	text command.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def motion_relaxation(self, *args, **kwargs):
                        """
                        Specifies a value (within the range of 0 to 1) for the motion relaxation, which is applied during the implicit mesh update.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/implicit_update_parameters/motion_relaxation").execute(*args, **kwargs)
                    def residual_criteria(self, *args, **kwargs):
                        """
                        Specifies the relative residual threshold that is used to check the motion convergence during the implicit mesh update.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/implicit_update_parameters/residual_criteria").execute(*args, **kwargs)
                    def update_interval(self, *args, **kwargs):
                        """
                        Specifies the update interval (that is, the frequency in iterations) at which the mesh is updated within a time step.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/implicit_update_parameters/update_interval").execute(*args, **kwargs)

                class smoothing_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh smoothing-parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def laplace_node_relaxation(self, *args, **kwargs):
                        """
                        Set the Laplace boundary node relaxation factor.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/laplace_node_relaxation").execute(*args, **kwargs)
                    def bnd_stiffness_factor(self, *args, **kwargs):
                        """
                        Sets the stiffness factor for springs connected to boundary nodes.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/bnd_stiffness_factor").execute(*args, **kwargs)
                    def constant_factor(self, *args, **kwargs):
                        """
                        Sets the spring constant relaxation factor.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/constant_factor").execute(*args, **kwargs)
                    def skew_smooth_face_skew_max(self, *args, **kwargs):
                        """
                        Sets the skewness threshold, above which faces will be smoothed using the skewness method.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/skew_smooth_face_skew_max").execute(*args, **kwargs)
                    def bnd_node_relaxation(self, *args, **kwargs):
                        """
                        The boundary node relaxation is used by spring smoothing. The boundary node relaxation allows you to relax the update of the node positions at deforming boundaries. A value of 0 prevents deforming boundary nodes from moving and a value of 1 indicates no under-relaxation.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/bnd_node_relaxation").execute(*args, **kwargs)
                    def diffusion_coeff_function(self, *args, **kwargs):
                        """
                        Specifies whether the diffusion coefficient for diffusion-based smoothing is based on the boundary distance or the cell volume.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/diffusion_coeff_function").execute(*args, **kwargs)
                    def diffusion_fvm(self, *args, **kwargs):
                        """
                        Answering yes at the prompt changes the diffusion-based smoothing method to the cell-based finite volume approach that was the default in releases prior to Fluent 15.0. Answering no at the prompt changes the diffusion-based smoothing method to the default node-based finite element method.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/diffusion_fvm").execute(*args, **kwargs)
                    def convergence_tolerance(self, *args, **kwargs):
                        """
                        Sets the convergence tolerance for spring-based solver.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/convergence_tolerance").execute(*args, **kwargs)
                    def smooth_from_reference_position(self, *args, **kwargs):
                        """
                        Enables/disables smoothing from a reference position. Such smoothing may produce greater mesh quality consistency for stationary or moving meshes with periodic or quasi-periodic motion, and is only available when the smoothing method is based on diffusion or the linearly elastic solid model.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/smooth_from_reference_position").execute(*args, **kwargs)
                    def smoothing_method(self, *args, **kwargs):
                        """
                        Specify the smoothing method used by the dynamic mesh model.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/smoothing_method").execute(*args, **kwargs)
                    def spring_on_simplex_elements(self, *args, **kwargs):
                        """
                        Enable/disable spring-based smoothing for tri/tet elements in mixed element zones.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/spring_on_simplex_elements").execute(*args, **kwargs)
                    def poisson_ratio(self, *args, **kwargs):
                        """
                        Sets the Poisson’s ratio used for smoothing based on the linearly elastic solid model.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/poisson_ratio").execute(*args, **kwargs)
                    def diffusion_coeff_parameter(self, *args, **kwargs):
                        """
                        Sets the diffusion coefficient parameter used for diffusion-based smoothing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/diffusion_coeff_parameter").execute(*args, **kwargs)
                    def skew_smooth_niter(self, *args, **kwargs):
                        """
                        Sets the number of skewness-based smoothing cycles.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/skew_smooth_niter").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Set the verbosity for spring smoothing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/verbosity").execute(*args, **kwargs)
                    def boundary_distance_method(self, *args, **kwargs):
                        """
                        Sets the method used to evaluate the boundary distance for the diffusion coefficient calculation, when diffusion-based smoothing is enabled.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/boundary_distance_method").execute(*args, **kwargs)
                    def skew_smooth_cell_skew_max(self, *args, **kwargs):
                        """
                        Sets the skewness threshold, above which cells will be smoothed using the skewness method.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/skew_smooth_cell_skew_max").execute(*args, **kwargs)
                    def max_iter(self, *args, **kwargs):
                        """
                        Set the maximum number of iterations for spring-based solver.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/max_iter").execute(*args, **kwargs)
                    def spring_on_all_elements(self, *args, **kwargs):
                        """
                        Enables/disables spring-based smoothing for all cell shapes; if disabled, the spring-based smoothing is applied based on the setting of the define/dynamic-mesh/controls/smoothing-parameters/spring-on-simplex-shapes? text command.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/spring_on_all_elements").execute(*args, **kwargs)
                    def relative_convergence_tolerance(self, *args, **kwargs):
                        """
                        Sets the relative residual convergence tolerance for smoothing based on diffusion or the linearly elastic solid model.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/relative_convergence_tolerance").execute(*args, **kwargs)
                    def amg_stabilization(self, *args, **kwargs):
                        """
                        Set the AMG stabilization method for mesh smoothing (FEM).
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/amg_stabilization").execute(*args, **kwargs)
                    def skew_smooth_all_deforming_boundaries(self, *args, **kwargs):
                        """
                        Enables/disables skewness smoothing for all deforming dynamic boundary zones. This is enabled by default. If disabled, skewness smoothing is only applied to the deforming dynamic boundary zones that have smoothing explicitly enabled or use local face remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/smoothing_parameters/skew_smooth_all_deforming_boundaries").execute(*args, **kwargs)

                class remeshing_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh remeshing menu to set 	parameters for all remeshing methods.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.prism_layer_parameters = self.__class__.prism_layer_parameters(path + ["prism_layer_parameters"], service)
                        self.prism_controls = self.__class__.prism_controls(path + ["prism_controls"], service)
                        self.sizing_controls = self.__class__.sizing_controls(path + ["sizing_controls"], service)
                        super().__init__(path, service)
                    def length_min(self, *args, **kwargs):
                        """
                        Sets the length threshold below which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/length_min").execute(*args, **kwargs)
                    def poly_remeshing(self, *args, **kwargs):
                        """
                        Enable/disable poly remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/poly_remeshing").execute(*args, **kwargs)
                    def sizing_funct_rate(self, *args, **kwargs):
                        """
                        Determines how far from the boundary the increase/decrease happens.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_funct_rate").execute(*args, **kwargs)
                    def unified_remeshing(self, *args, **kwargs):
                        """
                        Enables/disables unified remeshing, which specifies that an algorithm is used that combines aspects of a variety of remeshing methods. It is applied to triangular or tetrahedral cells and can produce wedge cells in 3D boundary layer meshes. Unified remeshing simplifies the remeshing setup and can provide increased robustness compared to methods-based remeshing, especially for parallel simulations.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/unified_remeshing").execute(*args, **kwargs)
                    def sizing_funct_variation(self, *args, **kwargs):
                        """
                        Sets the maximum sizing function increase/decrease in the interior.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_funct_variation").execute(*args, **kwargs)
                    def zone_remeshing(self, *args, **kwargs):
                        """
                        Enables/disables the cell zone remeshing method as part of methods-based remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/zone_remeshing").execute(*args, **kwargs)
                    def size_remesh_interval(self, *args, **kwargs):
                        """
                        Sets the interval (in time steps) when remeshing based on size is done for methods-based remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/size_remesh_interval").execute(*args, **kwargs)
                    def sizing_funct_defaults(self, *args, **kwargs):
                        """
                        Sets sizing function defaults.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_funct_defaults").execute(*args, **kwargs)
                    def face_skew_max(self, *args, **kwargs):
                        """
                        Sets the face skewness threshold above which faces will be remeshed.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/face_skew_max").execute(*args, **kwargs)
                    def retain_size_distribution(self, *args, **kwargs):
                        """
                        Enables/disables the use of local size criteria when marking cells for unified remeshing (in an attempt to maintain the initial mesh size distribution even as the mesh moves), rather than marking cells based on the minimum and maximum length scale values of the cell zone in the initial mesh. Either marking can be overridden if more restrictive values are specified using the define/dynamic-mesh/controls/remeshing-parameters/length-min and define/dynamic-mesh/controls/remeshing-parameters/length-max text commands.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/retain_size_distribution").execute(*args, **kwargs)
                    def sizing_function(self, *args, **kwargs):
                        """
                        Enables/disables the sizing function as part of methods-based remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_function").execute(*args, **kwargs)
                    def length_max(self, *args, **kwargs):
                        """
                        Sets the length threshold above which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/length_max").execute(*args, **kwargs)
                    def sizing_funct_resolution(self, *args, **kwargs):
                        """
                        Sets the sizing function resolution with respect to shortest boundary.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_funct_resolution").execute(*args, **kwargs)
                    def cell_skew_max(self, *args, **kwargs):
                        """
                        Sets the cell skewness threshold above which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/cell_skew_max").execute(*args, **kwargs)
                    def remeshing_after_moving(self, *args, **kwargs):
                        """
                        Enables a second round of remeshing based on the skewness parameters after the boundary has moved as part of methods-based remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/remeshing_after_moving").execute(*args, **kwargs)
                    def parallel_remeshing(self, *args, **kwargs):
                        """
                        Disables/enables parallel remeshing as part of methods-based remeshing..
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/parallel_remeshing").execute(*args, **kwargs)
                    def remeshing_methods(self, *args, **kwargs):
                        """
                        Enables/disables individual remeshing options as part of methods-based remeshing.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/remeshing_methods").execute(*args, **kwargs)

                    class prism_layer_parameters(TUIMenu):
                        """
                        Enters the dynamic mesh prism layer parameters menu, where you can define the parameters of the prism layers as part of methods-based remeshing.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def number_of_layers(self, *args, **kwargs):
                            """
                            Sets the number of elements in the prism layer.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/number_of_layers").execute(*args, **kwargs)
                        def growth_rate(self, *args, **kwargs):
                            """
                            Sets the geometric growth rate of the prism layer.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/growth_rate").execute(*args, **kwargs)
                        def first_height(self, *args, **kwargs):
                            """
                            Sets the first cell height in the prism layer.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/first_height").execute(*args, **kwargs)

                    class prism_controls(TUIMenu):
                        """
                        Enters the dynamic mesh prism controls menu, which provides text commands that can be useful when you want to modify the algorithm that attempts to retain the size distribution during unified remeshing. Each prism control definition is applied to one or more boundary zones, and then affects the height distribution and number of layers of the wedge cells in the adjacent boundary layers.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def add(self, *args, **kwargs):
                            """
                            Adds a new prism controls definition.   After being prompted for a name, you can enter the following to complete the definition:
                            first-height  Sets the height of the first layer of wedge cells in the boundary layer adjacent to the specified zones.
                            growth-method  Specifies the method used to determine the increase in height of the wedge cell layers beyond the first layer. The only available option is geometric, so that the height of each layer is the height of the previous layer multiplied by the rate.
                            name  Specifies the name of the prism controls definition.
                            nlayers  Sets the number of layers of wedge cells in the boundary layer adjacent to the specified zones.
                            rate  Sets the coefficient for the growth-method used to determine the increase in height of the wedge cell layers beyond the first layer.
                            zones  Specifies all of the boundary zones on which this prism controls definition is applied.
                            Enter q when the definition is complete to return to the text command menu.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_controls/add").execute(*args, **kwargs)
                        def edit(self, *args, **kwargs):
                            """
                            Edits an existing prism controls definition. You can revise the fields listed previously for the define/dynamic-mesh/controls/remeshing-parameters/prism-controls/add text command.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_controls/edit").execute(*args, **kwargs)
                        def delete(self, *args, **kwargs):
                            """
                            Deletes an existing prism controls definition.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_controls/delete").execute(*args, **kwargs)
                        def list_properties(self, *args, **kwargs):
                            """
                            Prints the properties of an existing prism controls definition of your choice in the console.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_controls/list_properties").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            Prints a list of the existing prism controls definitions in the console.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/prism_controls/list").execute(*args, **kwargs)

                    class sizing_controls(TUIMenu):
                        """
                        Enters the dynamic mesh sizing controls menu, which provides text commands that can be useful when you want to modify the algorithm that attempts to retain the size distribution during unified remeshing. Each sizing control definition is applied to one or more boundary zones, and then affects the size of the cells throughout the mesh based on their distance from those boundary zone(s) and your settings in the definition.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def list_properties(self, *args, **kwargs):
                            """
                            Prints the properties of an existing sizing controls definition of your choice in the console.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_controls/list_properties").execute(*args, **kwargs)
                        def delete(self, *args, **kwargs):
                            """
                            Deletes an existing sizing controls definition.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_controls/delete").execute(*args, **kwargs)
                        def add(self, *args, **kwargs):
                            """
                            Adds a new sizing controls definition.   After being prompted for a name, you can enter the following to complete the definition:
                            growth-rate  Sets the growth rate of the sizing controls definition.
                            max-length  Sets a maximum length threshold that is used when the type is set to auto or soft.
                            min-length  Sets a maximum length threshold that is used when the type is set to auto.
                            motion  Determines whether the size control definition affects the remeshing based on whether the mesh undergoes motion: auto specifies that it is applied whether or not there is motion; and static specifies that it is only applied if there is no motion.
                            name  Specifies the name of the sizing controls definition.
                            type  Specifies how the sizing is affected by the selected boundary zones: auto specifies that the default size distribution (rather than the initial size distribution in your selected boundary zones) is used, along with your specified max-length and min-length values; soft specifies that the maximum length scale of your selected boundary zones is used, along with your specified min-length value; and meshed specifies that the maximum and minimum length scales of your selected boundary zones are used, in order to respect their initial size distribution. This setting is only relevant if you have more than one sizing controls definition.
                            zones  Specifies all of the boundary zones on which the sizing controls definition is applied.
                            Enter q when the definition is complete to return to the text command menu.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_controls/add").execute(*args, **kwargs)
                        def edit(self, *args, **kwargs):
                            """
                            Edits an existing sizing controls definition. You can revise the fields listed previously for the define/dynamic-mesh/controls/remeshing-parameters/sizing-controls/add text command.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_controls/edit").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            Prints a list of the existing sizing controls definitions in the console.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/remeshing_parameters/sizing_controls/list").execute(*args, **kwargs)

                class six_dof_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh six degrees of freedom (DOF) solver menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def second_order(self, *args, **kwargs):
                        """
                        Enables/disables the second order six degrees of freedom solver.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/second_order").execute(*args, **kwargs)
                    def create_properties(self, *args, **kwargs):
                        """
                        Creates/edits a set of six DOF properties for rigid body motion.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/create_properties").execute(*args, **kwargs)
                    def delete_properties(self, *args, **kwargs):
                        """
                        Deletes a set of six DOF properties for rigid body motion.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/delete_properties").execute(*args, **kwargs)
                    def motion_history(self, *args, **kwargs):
                        """
                        Enables/disables writing position/orientation of six DOF zones to file.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/motion_history").execute(*args, **kwargs)
                    def x_component_of_gravity(self, *args, **kwargs):
                        """
                        Specifies x-component of gravity.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/x_component_of_gravity").execute(*args, **kwargs)
                    def z_component_of_gravity(self, *args, **kwargs):
                        """
                        Specifies z-component of gravity.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/z_component_of_gravity").execute(*args, **kwargs)
                    def list_properties(self, *args, **kwargs):
                        """
                        Prints summaries of the existing sets of six DOF properties for rigid body motion.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/list_properties").execute(*args, **kwargs)
                    def y_component_of_gravity(self, *args, **kwargs):
                        """
                        Specifies y-component of gravity.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/y_component_of_gravity").execute(*args, **kwargs)
                    def motion_history_file_name(self, *args, **kwargs):
                        """
                        Specifies the name and location of the six DOF motion history file.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/six_dof_parameters/motion_history_file_name").execute(*args, **kwargs)

                class contact_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh contact-parameters menu. This text command is only available 	when you enable contact detection using the prompts of 	the define/dynamic-mesh/dynamic-mesh? 	text command.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.flow_control_parameters = self.__class__.flow_control_parameters(path + ["flow_control_parameters"], service)
                        super().__init__(path, service)
                    def contact_udf(self, *args, **kwargs):
                        """
                        Selects the UDF to be invoked when contact is detected.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/contact_udf").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Sets the level of detail printed in the console regarding contact detection.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/verbosity").execute(*args, **kwargs)
                    def contact_method(self, *args, **kwargs):
                        """
                        Selects the method used for flow control in the contact region. Enter 0 for the contact zones method (which restricts the flow using additional cell zones with porous zone properties) or 1 for the contact marks method (which blocks the flow using zero-mass-flux boundaries).
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/contact_method").execute(*args, **kwargs)
                    def contact_threshold(self, *args, **kwargs):
                        """
                        Specifies threshold distance for contact detection.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/contact_threshold").execute(*args, **kwargs)
                    def flow_control(self, *args, **kwargs):
                        """
                        Enables/disables flow control in the contact region.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/flow_control").execute(*args, **kwargs)
                    def update_contact_marks(self, *args, **kwargs):
                        """
                        Updates which cells are marked in order to block flow in the contact region as part of the contact marks method.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/update_contact_marks").execute(*args, **kwargs)
                    def contact_face_zones(self, *args, **kwargs):
                        """
                        Selects face zones involved in contact detection.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/contact_face_zones").execute(*args, **kwargs)
                    def render_contact_cells(self, *args, **kwargs):
                        """
                        Enables/disables the availability of a field variable (contact-cell-mark) that can be used to display contours of cells marked for flow blocking as part of the contact marks method, and allows you to postprocess other field variables on those cells.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/render_contact_cells").execute(*args, **kwargs)

                    class flow_control_parameters(TUIMenu):
                        """
                        Enters the flow control parameters menu, which provides settings related to controlling the flow in the contact region.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def solution_stabilization(self, *args, **kwargs):
                            """
                            Enables/disables the performance of additional iterations per time step and the application of solution controls to improve the stability of the solver as part of the contact marks method.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/flow_control_parameters/solution_stabilization").execute(*args, **kwargs)
                        def delete_flow_control_zone(self, *args, **kwargs):
                            """
                            Deletes a flow control zone as part of the contact zones method.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/flow_control_parameters/delete_flow_control_zone").execute(*args, **kwargs)
                        def create_flow_control_zone(self, *args, **kwargs):
                            """
                            Creates a flow control zone as part of the contact zones method.
                            """
                            return PyMenu(self.service, "/define/dynamic_mesh/controls/contact_parameters/flow_control_parameters/create_flow_control_zone").execute(*args, **kwargs)

                class periodic_displacement_parameters(TUIMenu):
                    """
                    Enters the periodic displacement parameters 	menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def edit_group(self, *args, **kwargs):
                        """
                        Edit Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/edit_group").execute(*args, **kwargs)
                    def delete_all_displacements(self, *args, **kwargs):
                        """
                        Delete All Periodic Displacements.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/delete_all_displacements").execute(*args, **kwargs)
                    def copy_displacement(self, *args, **kwargs):
                        """
                        Copy Periodic Displacement.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/copy_displacement").execute(*args, **kwargs)
                    def set_active_displacement(self, *args, **kwargs):
                        """
                        Set Active Periodic Displacement in Group.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/set_active_displacement").execute(*args, **kwargs)
                    def create_displacement(self, *args, **kwargs):
                        """
                        Create Periodic Displacement.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/create_displacement").execute(*args, **kwargs)
                    def list_groups(self, *args, **kwargs):
                        """
                        List Periodic Displacement Groups.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/list_groups").execute(*args, **kwargs)
                    def delete_displacement(self, *args, **kwargs):
                        """
                        Delete Periodic Displacement.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/delete_displacement").execute(*args, **kwargs)
                    def edit_displacement(self, *args, **kwargs):
                        """
                        Edit Periodic Displacement.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/edit_displacement").execute(*args, **kwargs)
                    def delete_all_groups(self, *args, **kwargs):
                        """
                        Delete All Periodic Displacement Groups.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/delete_all_groups").execute(*args, **kwargs)
                    def create_group(self, *args, **kwargs):
                        """
                        Create Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/create_group").execute(*args, **kwargs)
                    def delete_group(self, *args, **kwargs):
                        """
                        Delete Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/delete_group").execute(*args, **kwargs)
                    def list_displacements(self, *args, **kwargs):
                        """
                        List Periodic Displacements.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/periodic_displacement_parameters/list_displacements").execute(*args, **kwargs)

                class in_cylinder_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh in-cylinder menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def print_plot_lift(self, *args, **kwargs):
                        """
                        Prints or plot valve lift curve.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/print_plot_lift").execute(*args, **kwargs)
                    def position_starting_mesh(self, *args, **kwargs):
                        """
                        Moves mesh from top dead center to starting crank angle.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/position_starting_mesh").execute(*args, **kwargs)
                    def minimum_lift(self, *args, **kwargs):
                        """
                        Specifies minimum lift for in-cylinder valves.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/minimum_lift").execute(*args, **kwargs)
                    def max_crank_angle_step(self, *args, **kwargs):
                        """
                        Specifies maximum crank angle step size.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/max_crank_angle_step").execute(*args, **kwargs)
                    def crank_angle_step(self, *args, **kwargs):
                        """
                        Specifies crank angle step size.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/crank_angle_step").execute(*args, **kwargs)
                    def piston_data(self, *args, **kwargs):
                        """
                        Specifies the crank radius and connecting rod length.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/piston_data").execute(*args, **kwargs)
                    def piston_stroke_cutoff(self, *args, **kwargs):
                        """
                        Specifies the cut off point for in-cylinder piston.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/piston_stroke_cutoff").execute(*args, **kwargs)
                    def modify_lift(self, *args, **kwargs):
                        """
                        Modifies lift curve (shift or scale).
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/modify_lift").execute(*args, **kwargs)
                    def starting_crank_angle(self, *args, **kwargs):
                        """
                        Specifies the initial value for the crank angle.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/starting_crank_angle").execute(*args, **kwargs)
                    def crank_period(self, *args, **kwargs):
                        """
                        Specifies the crank period.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/in_cylinder_parameters/crank_period").execute(*args, **kwargs)

                class layering_parameters(TUIMenu):
                    """
                    Enters the dynamic mesh layering menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def split_factor(self, *args, **kwargs):
                        """
                        Sets the factor determining when to split dynamic layers.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/layering_parameters/split_factor").execute(*args, **kwargs)
                    def constant_height(self, *args, **kwargs):
                        """
                        Enables/disables layering based on constant height, else layering based on constant ratio.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/layering_parameters/constant_height").execute(*args, **kwargs)
                    def collapse_factor(self, *args, **kwargs):
                        """
                        Sets the factor determining when to collapse dynamic layers.
                        """
                        return PyMenu(self.service, "/define/dynamic_mesh/controls/layering_parameters/collapse_factor").execute(*args, **kwargs)

        class custom_field_functions(TUIMenu):
            """
            Enters the custom field functions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list_valid_cell_function_names(self, *args, **kwargs):
                """
                Lists the names of cell functions that can be used in a custom field function.
                """
                return PyMenu(self.service, "/define/custom_field_functions/list_valid_cell_function_names").execute(*args, **kwargs)
            def load(self, *args, **kwargs):
                """
                Loads a custom field function.
                """
                return PyMenu(self.service, "/define/custom_field_functions/load").execute(*args, **kwargs)
            def example_cff_definitions(self, *args, **kwargs):
                """
                Lists example custom field functions.
                """
                return PyMenu(self.service, "/define/custom_field_functions/example_cff_definitions").execute(*args, **kwargs)
            def define(self, *args, **kwargs):
                """
                Defines a custom field function.
                """
                return PyMenu(self.service, "/define/custom_field_functions/define").execute(*args, **kwargs)
            def save(self, *args, **kwargs):
                """
                Saves a custom field function.
                """
                return PyMenu(self.service, "/define/custom_field_functions/save").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a custom field function.
                """
                return PyMenu(self.service, "/define/custom_field_functions/delete").execute(*args, **kwargs)

        class operating_conditions(TUIMenu):
            """
            Enters the define operating conditions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def operating_density(self, *args, **kwargs):
                """
                Multiphase flow Operating Density menu.
                """
                return PyMenu(self.service, "/define/operating_conditions/operating_density").execute(*args, **kwargs)
            def operating_temperature(self, *args, **kwargs):
                """
                Sets the operating temperature for Boussinesq.
                """
                return PyMenu(self.service, "/define/operating_conditions/operating_temperature").execute(*args, **kwargs)
            def set_state(self, *args, **kwargs):
                """
                Selects state for real gas EOS subcritical condition.
                """
                return PyMenu(self.service, "/define/operating_conditions/set_state").execute(*args, **kwargs)
            def gravity_mrf_behavior(self, *args, **kwargs):
                """
                Enable/disable the fix of gravity vector in a stationary reference frame.
                """
                return PyMenu(self.service, "/define/operating_conditions/gravity_mrf_behavior").execute(*args, **kwargs)
            def operating_pressure(self, *args, **kwargs):
                """
                Sets the operating pressure.
                """
                return PyMenu(self.service, "/define/operating_conditions/operating_pressure").execute(*args, **kwargs)
            def reference_pressure_method(self, *args, **kwargs):
                """
                Specifies the method used for adjusting the gauge pressure field after each iteration to keep it from floating: the method can assume that all of the cell zones are connected by internal boundary zones (such as interior zones), or can account for connected and disconnected cell zones. Such adjustment is only allowed for incompressible flows, and will be limited partially or entirely by the presence of a pressure boundary.
                """
                return PyMenu(self.service, "/define/operating_conditions/reference_pressure_method").execute(*args, **kwargs)
            def gravity(self, *args, **kwargs):
                """
                Sets gravitational acceleration.
                """
                return PyMenu(self.service, "/define/operating_conditions/gravity").execute(*args, **kwargs)
            def use_inlet_temperature_for_operating_density(self, *args, **kwargs):
                """
                Uses inlet temperature to calculate operating density.
                """
                return PyMenu(self.service, "/define/operating_conditions/use_inlet_temperature_for_operating_density").execute(*args, **kwargs)
            def used_ref_pressure_location(self, *args, **kwargs):
                """
                Prints the coordinates of the reference pressure cell or cells (depending on the selected reference pressure method). The pressure value in such cells can be used to adjust the gauge pressure field after each iteration to keep it from floating.
                """
                return PyMenu(self.service, "/define/operating_conditions/used_ref_pressure_location").execute(*args, **kwargs)
            def reference_pressure_location(self, *args, **kwargs):
                """
                Sets a location that determines the reference pressure cell or cells (depending on the selected reference pressure method). The pressure value in such cells can be used to adjust the gauge pressure field after each iteration to keep it from floating.
                """
                return PyMenu(self.service, "/define/operating_conditions/reference_pressure_location").execute(*args, **kwargs)

        class parameters(TUIMenu):
            """
            Enters the parameters menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.input_parameters = self.__class__.input_parameters(path + ["input_parameters"], service)
                self.list_parameters = self.__class__.list_parameters(path + ["list_parameters"], service)
                self.output_parameters = self.__class__.output_parameters(path + ["output_parameters"], service)
                super().__init__(path, service)
            def enable_in_TUI(self, *args, **kwargs):
                """
                Enables/disables parameters in the text user interface.
                """
                return PyMenu(self.service, "/define/parameters/enable_in_TUI").execute(*args, **kwargs)

            class input_parameters(TUIMenu):
                """
                Enters the input-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.advance = self.__class__.advance(path + ["advance"], service)
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Deletes an input parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/input_parameters/delete").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits an input parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/input_parameters/edit").execute(*args, **kwargs)

                class advance(TUIMenu):
                    """
                    Define custom variable to use input parameter.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def use_in(self, *args, **kwargs):
                        """
                        Use input parameter in solver-udf or in scheme-procedure.
                        """
                        return PyMenu(self.service, "/define/parameters/input_parameters/advance/use_in").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List of custom-input-parameters.
                        """
                        return PyMenu(self.service, "/define/parameters/input_parameters/advance/list").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete selected custom-input-parameters.
                        """
                        return PyMenu(self.service, "/define/parameters/input_parameters/advance/delete").execute(*args, **kwargs)

            class list_parameters(TUIMenu):
                """
                Enter list-param menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def output_parameters(self, *args, **kwargs):
                    """
                    List all output parameters.
                    """
                    return PyMenu(self.service, "/define/parameters/list_parameters/output_parameters").execute(*args, **kwargs)
                def input_parameters(self, *args, **kwargs):
                    """
                    List all input parameters.
                    """
                    return PyMenu(self.service, "/define/parameters/list_parameters/input_parameters").execute(*args, **kwargs)

            class output_parameters(TUIMenu):
                """
                Enters the output-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def print_to_console(self, *args, **kwargs):
                    """
                    Displays parameter value in the console.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/print_to_console").execute(*args, **kwargs)
                def write_all_to_file(self, *args, **kwargs):
                    """
                    Writes all parameter values to file.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/write_all_to_file").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits an output parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/edit").execute(*args, **kwargs)
                def write_to_file(self, *args, **kwargs):
                    """
                    Writes parameter value to file.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/write_to_file").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes an output parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/delete").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Creates an output parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/create").execute(*args, **kwargs)
                def rename(self, *args, **kwargs):
                    """
                    Renames an output parameter.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/rename").execute(*args, **kwargs)
                def print_all_to_console(self, *args, **kwargs):
                    """
                    Displays all parameter values in the console.
                    """
                    return PyMenu(self.service, "/define/parameters/output_parameters/print_all_to_console").execute(*args, **kwargs)

        class overset_interfaces(TUIMenu):
            """
            Enters the overset interfaces menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.cut_control = self.__class__.cut_control(path + ["cut_control"], service)
                self.adapt = self.__class__.adapt(path + ["adapt"], service)
                self.options = self.__class__.options(path + ["options"], service)
                super().__init__(path, service)
            def intersect(self, *args, **kwargs):
                """
                Executes the hole cutting of an overset interface and establishes the domain connectivity. This text command is only available when define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/intersect").execute(*args, **kwargs)
            def mark_cell_change(self, *args, **kwargs):
                """
                Marks cells that have undergone a specified overset cell type change (from solve,receptor, or dead to any other type) in the last time step. Adaption registers are automatically filled based on these markings. This text command is only available for unsteady simulations and if define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/mark_cell_change").execute(*args, **kwargs)
            def read_dci_from_case(self, *args, **kwargs):
                """
                Read domain connectivity information (DCI) from case file.
                """
                return PyMenu(self.service, "/define/overset_interfaces/read_dci_from_case").execute(*args, **kwargs)
            def write_cell_types(self, *args, **kwargs):
                """
                Write overset cell types into file.
                """
                return PyMenu(self.service, "/define/overset_interfaces/write_cell_types").execute(*args, **kwargs)
            def free_dci(self, *args, **kwargs):
                """
                Free overset domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/define/overset_interfaces/free_dci").execute(*args, **kwargs)
            def fill_dci(self, *args, **kwargs):
                """
                Fill overset domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/define/overset_interfaces/fill_dci").execute(*args, **kwargs)
            def intersect_all(self, *args, **kwargs):
                """
                Executes hole cutting for all overset interfaces in the domain. This text command is only available when define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/intersect_all").execute(*args, **kwargs)
            def find_all_bounding_cells(self, *args, **kwargs):
                """
                Find bounding cells for all cell centroids.
                """
                return PyMenu(self.service, "/define/overset_interfaces/find_all_bounding_cells").execute(*args, **kwargs)
            def set_mark_bounds(self, *args, **kwargs):
                """
                Allows you to set bounds so that any marking of cells is performed within a spherical region based on a specified origin and radius. This can be useful when diagnosing a local problem on a large mesh. This text command is only available if define/overset-interfaces/options/expert? is set to yes. After defining the bounds, you can then mark the cells using the define/overset-interfaces/mark-cell-change or define/overset-interfaces/mark-cells text command. To disable the bounds, enter a radius of 0.
                """
                return PyMenu(self.service, "/define/overset_interfaces/set_mark_bounds").execute(*args, **kwargs)
            def write_dci_to_case(self, *args, **kwargs):
                """
                Save domain connectivity information (DCI) to case file.
                """
                return PyMenu(self.service, "/define/overset_interfaces/write_dci_to_case").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes an overset interface.
                """
                return PyMenu(self.service, "/define/overset_interfaces/delete").execute(*args, **kwargs)
            def clear(self, *args, **kwargs):
                """
                Clears the domain connectivity of an overset interface. This text command is only available when define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/clear").execute(*args, **kwargs)
            def find_bounding_cell(self, *args, **kwargs):
                """
                Find bounding cell for given cell or search point.
                """
                return PyMenu(self.service, "/define/overset_interfaces/find_bounding_cell").execute(*args, **kwargs)
            def write_dci(self, *args, **kwargs):
                """
                Save domain connectivity information (DCI) to a text file.
                """
                return PyMenu(self.service, "/define/overset_interfaces/write_dci").execute(*args, **kwargs)
            def clear_all(self, *args, **kwargs):
                """
                Clears the domain connectivity of all overset interfaces. This text command is only available when define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/clear_all").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists information about the overset interfaces. The output depends on the overset verbosity setting.
                """
                return PyMenu(self.service, "/define/overset_interfaces/list").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all overset interfaces in the domain.
                """
                return PyMenu(self.service, "/define/overset_interfaces/delete_all").execute(*args, **kwargs)
            def mark_cells(self, *args, **kwargs):
                """
                Marks the specified overset cells (solve, receptor, donor, orphan, or dead) and fills registers based on the markings. Display the marked cells via the text command define/overset-interfaces/display-cells.
                """
                return PyMenu(self.service, "/define/overset_interfaces/mark_cells").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Creates an overset interface.
                """
                return PyMenu(self.service, "/define/overset_interfaces/create").execute(*args, **kwargs)
            def display_cells(self, *args, **kwargs):
                """
                Displays the overset cells marked using the text command define/overset-interfaces/mark-cells.
                """
                return PyMenu(self.service, "/define/overset_interfaces/display_cells").execute(*args, **kwargs)
            def debug_hole_cut(self, *args, **kwargs):
                """
                Debugging tool to troubleshoot hole cutting of overset interfaces. This text command is only available when define/overset-interfaces/options/expert? is set to yes.
                """
                return PyMenu(self.service, "/define/overset_interfaces/debug_hole_cut").execute(*args, **kwargs)
            def check(self, *args, **kwargs):
                """
                Checks the integrity of the overset interfaces. Reports orphan cells and errors in the domain connectivity.
                """
                return PyMenu(self.service, "/define/overset_interfaces/check").execute(*args, **kwargs)
            def update_from_dci(self, *args, **kwargs):
                """
                Update all overset intrfaces from stored domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/define/overset_interfaces/update_from_dci").execute(*args, **kwargs)
            def grid_priorities(self, *args, **kwargs):
                """
                Allows you to specify grid priorities on background and component meshes, used in the overlap minimization of an overset interface.
                """
                return PyMenu(self.service, "/define/overset_interfaces/grid_priorities").execute(*args, **kwargs)

            class cut_control(TUIMenu):
                """
                Enters the overset hole cut control menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.cut_seeds = self.__class__.cut_seeds(path + ["cut_seeds"], service)
                    super().__init__(path, service)
                def add(self, *args, **kwargs):
                    """
                    Adds a hole cut control, so that a boundary zone does 	not cut specified cell zones.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/cut_control/add").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Lists the defined hole cut controls.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/cut_control/list").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Deletes the hole cut controls for all boundary 	zones.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/cut_control/delete_all").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes the hole cut control for a boundary 	zone.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/cut_control/delete").execute(*args, **kwargs)

                class cut_seeds(TUIMenu):
                    """
                    Enters the overset hole cut seeds menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def delete(self, *args, **kwargs):
                        """
                        Delete a hole cut seed.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/cut_control/cut_seeds/delete").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List the defined hole cut seeds.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/cut_control/cut_seeds/list").execute(*args, **kwargs)
                    def cut_seeds_for_all_component_zones(self, *args, **kwargs):
                        """
                        Specifies whether all component zones get cut seeds, which cut pilot holes into the overlapping meshes that will then be enlarged during overlap minimization.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/cut_control/cut_seeds/cut_seeds_for_all_component_zones").execute(*args, **kwargs)
                    def delete_all(self, *args, **kwargs):
                        """
                        Delete all hole cut seeds.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/cut_control/cut_seeds/delete_all").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Add a hole cut seed.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/cut_control/cut_seeds/add").execute(*args, **kwargs)

            class adapt(TUIMenu):
                """
                Enters the overset adaption menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.set = self.__class__.set(path + ["set"], service)
                    super().__init__(path, service)
                def mark_adaption(self, *args, **kwargs):
                    """
                    Marks cells to identify those that can be adapted in 	order to improve your overset mesh.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/adapt/mark_adaption").execute(*args, **kwargs)
                def adapt_mesh(self, *args, **kwargs):
                    """
                    Marks and adapts the mesh to improve your overset 	mesh.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/adapt/adapt_mesh").execute(*args, **kwargs)

                class set(TUIMenu):
                    """
                    Enters the overset adaption set menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def length_ratio_max(self, *args, **kwargs):
                        """
                        Sets the length scale ratio threshold used to determine which cells are marked for adaption based on donor-receptor cell size differences.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/length_ratio_max").execute(*args, **kwargs)
                    def anisotropic(self, *args, **kwargs):
                        """
                        Enable the option to use anisotropic adaption in prismatic cells.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/anisotropic").execute(*args, **kwargs)
                    def automatic(self, *args, **kwargs):
                        """
                        Enable the option to automatically adapt overset meshes during solution update.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/automatic").execute(*args, **kwargs)
                    def mark_size(self, *args, **kwargs):
                        """
                        Enables/disables the option to adapt based on donor-receptor cell size differences.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/mark_size").execute(*args, **kwargs)
                    def gap_resolution(self, *args, **kwargs):
                        """
                        Set the target (minimum) gap resolution used when marking cells for gap adaption.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/gap_resolution").execute(*args, **kwargs)
                    def buffer_layers(self, *args, **kwargs):
                        """
                        Sets the number of cell layers marked in addition to the cells marked for orphan adaption.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/buffer_layers").execute(*args, **kwargs)
                    def maximum_refinement_level(self, *args, **kwargs):
                        """
                        Sets the maximum level of refinement during overset adaption, in conjunction with the value set using the mesh/adapt/set/maximum-refinement-level text command (the larger of the two values is used).
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/maximum_refinement_level").execute(*args, **kwargs)
                    def mark_gaps(self, *args, **kwargs):
                        """
                        Enable the option to adapt underresolved gaps.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/mark_gaps").execute(*args, **kwargs)
                    def mark_orphans(self, *args, **kwargs):
                        """
                        Enables/disables the option to adapt for orphan reduction.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/mark_orphans").execute(*args, **kwargs)
                    def adaption_sweeps(self, *args, **kwargs):
                        """
                        Sets the number of rounds of adaption applied during each adaption cycle.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/adaption_sweeps").execute(*args, **kwargs)
                    def mark_fixed_orphans(self, *args, **kwargs):
                        """
                        Enables/disables the option to also adapt based on cells that are not actual orphans because they were fixed by accepting neighbor donors. This option is only applied if define/overset-interfaces/adapt/set/mark-orphans? is enabled.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/mark_fixed_orphans").execute(*args, **kwargs)
                    def mark_coarsening(self, *args, **kwargs):
                        """
                        Enables/disables the option to coarsen the mesh if mesh refinement is no longer needed. This option is enabled by default.
                        """
                        return PyMenu(self.service, "/define/overset_interfaces/adapt/set/mark_coarsening").execute(*args, **kwargs)

            class options(TUIMenu):
                """
                Enters the overset interface options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def donor_priority_method(self, *args, **kwargs):
                    """
                    Allows you to specify whether the cell donor priority used in the overlap 	minimization of an overset interface is inversely proportional to either the 	cell size or the distance to the nearest boundary.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/donor_priority_method").execute(*args, **kwargs)
                def minimize_overlap(self, *args, **kwargs):
                    """
                    Allows you to disable overlap minimization during hole cutting.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/minimize_overlap").execute(*args, **kwargs)
                def mesh_interfaces(self, *args, **kwargs):
                    """
                    Allows the inclusion of non-conformal mesh interfaces 	inside overset cell zones, as long as the mesh 	interfaces do not spatially overlap with the cells where 	the overset interfaces lie.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/mesh_interfaces").execute(*args, **kwargs)
                def transient_caching(self, *args, **kwargs):
                    """
                    Sets the options to control caching of entities in transient overset simulations. This text 	command is only available when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/transient_caching").execute(*args, **kwargs)
                def solve_island_removal(self, *args, **kwargs):
                    """
                    Sets the method used to control the removal of isolated patches of solve cells. This text 	command is only available when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/solve_island_removal").execute(*args, **kwargs)
                def dead_cell_update(self, *args, **kwargs):
                    """
                    Enables/disables the updating of dead cells during the solution process, which may 	be helpful for some moving and dynamic mesh simulations 	(though at the cost of solver performance). You can 	enter the number of layers of dead cells adjacent to the 	receptor cells that you want updated, or enter -1 to request that all dead 	cells are updated. This text command is only available 	for transient simulations when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/dead_cell_update").execute(*args, **kwargs)
                def modified_donor_search(self, *args, **kwargs):
                    """
                    Enables / disables modified donor search parameters. When enabled, these parameters result in 	a more extended donor search, which can be helpful for 	meshes with orphans. This text command is only available 	when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/modified_donor_search").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Enables / disables overset-related expert tools.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/expert").execute(*args, **kwargs)
                def render_receptor_cells(self, *args, **kwargs):
                    """
                    Allows you to enable visualization of receptor cells in contour and mesh 	displays.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/render_receptor_cells").execute(*args, **kwargs)
                def modified_hole_cutting(self, *args, **kwargs):
                    """
                    Enables / disables modified hole cutting parameters. When enabled, the parameters used can 	help avoid dead cell zones that result from a hole 	cutting failure. This text command is only available 	when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/modified_hole_cutting").execute(*args, **kwargs)
                def node_connected_donors(self, *args, **kwargs):
                    """
                    Allows you to switch between face or node connected donor cells. This text command is only 	available when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/node_connected_donors").execute(*args, **kwargs)
                def partial_cut_faces(self, *args, **kwargs):
                    """
                    Enables/disables enhanced hole cutting, where partially overlapping cut faces are 	decomposed into overlapping and non-overlapping 	fractions, and only the non-overlapping fractions 	participate in the hole cutting. This can help avoid the 	situation where a region or cell zone is erroneously 	identified as dead because of leakage during flood 	filling, even though it has overlapping boundaries that 	match well. When this text command is disabled, the 	partially overlapping faces are entirely protected from 	cutting.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/partial_cut_faces").execute(*args, **kwargs)
                def update_before_case_write(self, *args, **kwargs):
                    """
                    Enables/disables the updating of the overset interfaces before writing a case file in the 	Common Fluids Format (CFF). This text command is only 	available when define/overset-interfaces/options/expert? 	is set to yes.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/update_before_case_write").execute(*args, **kwargs)
                def parallel(self, *args, **kwargs):
                    """
                    Allows you to select the algorithm used for overset parallel processing. You can 	select from the default cell exchange model or the local 	cell zone replication model; the cell exchange model 	should require less memory and may result in faster 	calculations.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/parallel").execute(*args, **kwargs)
                def auto_create(self, *args, **kwargs):
                    """
                    Enables the automatic creation of a default overset interface during 	initialization or mesh motion update.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/auto_create").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Specifies the level of detail printed in the console about overset 	interfaces.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/verbosity").execute(*args, **kwargs)
                def overlap_boundaries(self, *args, **kwargs):
                    """
                    Allows you to disable the detection of overlapping boundaries during hole cutting, 	in order to reduce the computational expense for cases 	that do not include such boundaries. When enabled, this 	text command also allows you to specify which boundary 	zones should be considered when detecting overlapping 	boundaries; this can be helpful when the default hole 	cutting process fails.
                    """
                    return PyMenu(self.service, "/define/overset_interfaces/options/overlap_boundaries").execute(*args, **kwargs)

        class phases(TUIMenu):
            """
            Enters the phases menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.set_domain_properties = self.__class__.set_domain_properties(path + ["set_domain_properties"], service)
                self.iac_expert = self.__class__.iac_expert(path + ["iac_expert"], service)
                super().__init__(path, service)

            class set_domain_properties(TUIMenu):
                """
                Enters the menu to set phase domain properties.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.interaction_domain = self.__class__.interaction_domain(path + ["interaction_domain"], service)
                    super().__init__(path, service)
                def phase_domains(self, *args, **kwargs):
                    """
                    Enters the menu to select a specific phase.
                    """
                    return PyMenu(self.service, "/define/phases/set_domain_properties/phase_domains").execute(*args, **kwargs)
                def change_phases_names(self, *args, **kwargs):
                    """
                    Allows you to change the names of all the phases in your simulation.
                    """
                    return PyMenu(self.service, "/define/phases/set_domain_properties/change_phases_names").execute(*args, **kwargs)

                class interaction_domain(TUIMenu):
                    """
                    Enters the menu to set the interaction domain 	properties.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.interfacial_area = self.__class__.interfacial_area(path + ["interfacial_area"], service)
                        self.heat_mass_reactions = self.__class__.heat_mass_reactions(path + ["heat_mass_reactions"], service)
                        self.model_transition = self.__class__.model_transition(path + ["model_transition"], service)
                        self.forces = self.__class__.forces(path + ["forces"], service)
                        self.numerics = self.__class__.numerics(path + ["numerics"], service)
                        super().__init__(path, service)

                    class interfacial_area(TUIMenu):
                        """
                        Enters the menu to set interfacial area models. This menu is available only for the Mixture and Eulerian multiphase models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            super().__init__(path, service)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/reactions").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Set the model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/model_transition").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/mass_transfer").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/heat_coeff").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/turbulent_dispersion").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/wall_lubrication").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/turbulence_interaction").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/slip_velocity").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Specifies the interfacial area model for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interfacial_area").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/drag").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/restitution").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enter the menu to set cavitation models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_modeling").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/cavitation").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/slope_limiter").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_montoya").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/virtual_mass").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/cavitation").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/wall_adhesion").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enter the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enter the menu to set lift models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/visc_disp_factor").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/wall_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/virtual_mass").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_montoya").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_modeling").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/cavitation").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_model_type").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/slope_limiter").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_discr").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/lift/jump_adhesion").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enter the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/cavitation").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/visc_disp_factor").execute(*args, **kwargs)

                    class heat_mass_reactions(TUIMenu):
                        """
                        Enters the menu to set heat, mass-transfer, and reaction models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            super().__init__(path, service)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/restitution").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Set the model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/model_transition").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/wall_lubrication").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulence_interaction").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/drag").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interfacial_area").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/slip_velocity").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Allows you to define multiple heterogeneous reactions and stoichiometry. This option is available only with the species model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/reactions").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulent_dispersion").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/mass_transfer").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Species the heat transfer coefficient function between each pair of phases (constant-htc, nusselt-number, ranz-marshall, hughmark, tomiyama, fixed-to-sat-temp, two-resistance, or user-defined). This command is enable only with the Eulerian multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/heat_coeff").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enter the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/wall_adhesion").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enters the menu to set cavitation models. This option is available only for the Mixture multiphase model with the Singhal-et-al cavitation model enabled via solve/set/advanced/singhal-et-al-cavitation-model.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/virtual_mass").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_discr").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_montoya").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/slope_limiter").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_modeling").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Sets the vaporization pressure, surface tension coefficient, and non-condensable gas mass fraction. This command is available only when cavitation? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/cavitation").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/jump_adhesion").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enter the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/cavitation").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enter the menu to set lift models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/wall_adhesion").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_model_type").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/cavitation").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_montoya").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/virtual_mass").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/visc_disp_factor").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_discr").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_modeling").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/jump_adhesion").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/slope_limiter").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/cavitation").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/virtual_mass").execute(*args, **kwargs)

                    class model_transition(TUIMenu):
                        """
                        Enters the menu to set model transition mechanisms.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            super().__init__(path, service)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/slip_velocity").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/restitution").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/drag").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/turbulence_interaction").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interfacial_area").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/mass_transfer").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/wall_lubrication").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/turbulent_dispersion").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/heat_coeff").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Sets the VOF-to-DPM model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/model_transition").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/reactions").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enter the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/cavitation").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/virtual_mass").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enter the menu to set cavitation models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/virtual_mass").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/slope_limiter").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_discr").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_montoya").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/cavitation").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_modeling").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/cavitation").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enter the menu to set lift models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_discr").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/cavitation").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_model_type").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/jump_adhesion").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_modeling").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/slope_limiter").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/virtual_mass").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_coeff").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/lift").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_montoya").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/lift/wall_adhesion").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enter the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)

                    class forces(TUIMenu):
                        """
                        Enters the menu to set interfacial forces models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            super().__init__(path, service)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specifies the turbulent dispersion model for each primary-secondary phase pair. This command is available only with the Eulerian multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/turbulent_dispersion").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specifies the drag function, drag modification, and drag factor for each pair of phases. This command is available only with the Eulerian and Mixture multiphase models.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/drag").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interfacial_area").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specifies the slip velocity function for each secondary phase with respect to the primary phase. This command is available only for the Mixture multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/slip_velocity").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/heat_coeff").execute(*args, **kwargs)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/mass_transfer").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specifies the wall lubrication model for each primary-secondary phase pair. This command is available only with the Eulerian multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/wall_lubrication").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specifies the restitution coefficient for collisions between each pair of granular phases, and for collisions between particles of the same granular phase. This command is available only for multiphase flows with two or more granular phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/restitution").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specifies the turbulence interaction model for each primary-secondary phase pair. This command is available only with the Eulerian multiphase model.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/turbulence_interaction").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/reactions").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Set the model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/model_transition").execute(*args, **kwargs)

                        class cavitation(TUIMenu):
                            """
                            Enter the menu to set cavitation models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/virtual_mass").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/lift").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_coeff").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/visc_disp_factor").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_montoya").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/wall_adhesion").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/jump_adhesion").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/cavitation").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_modeling").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/slope_limiter").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_model_type").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enters the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enables/disables the treatment of the contact angle specification at the porous jump boundary. This command is available only for the VOF multiphase model with the continuum surface stress model option and when sfc-modeling? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/jump_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specifies the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enables/disables the specification for a wall adhesion angle. This item is available only whensfc-modeling? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/wall_adhesion").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/cavitation").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Allows you to include the effects of surface tension along the fluid-fluid interface. This option is only available for the VOF and Eulerian multiphase models.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_modeling").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Selects the surface tension model. You can choose between the continuum surface force and continuum surface stress methods. This item is available only when sfc-modeling? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/slope_limiter").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit_options").execute(*args, **kwargs)

                        class virtual_mass(TUIMenu):
                            """
                            Enters the menu to set virtual mass models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/cavitation").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Specifies what form of the implicit method to use (default, option-2, or option-3). default models the entire virtual mass force while option-2 and option-3 model truncated expressions which may further improve convergence. This option is available only if vmass-implicit? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/interphase_discr").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/slope_limiter").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Allows you to include the virtual mass force effect that occurs when a secondary phase accelerates relative to the primary phase. This command is available only with the Eulerian multiphase model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/virtual_mass").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enables/disables the implicit method for the virtual mass force. This option can improve convergence in some cases. This option is available only if virtual-mass? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift_montoya").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specifies the virtual mass coefficient for each pair of phases. This option is available only ifvirtual-mass? is enabled.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_coeff").execute(*args, **kwargs)

                        class lift(TUIMenu):
                            """
                            Enters the menu to set the lift force. This item is available only with the Eulerian multiphase model.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Enables/disables the Shaver-Podowski lift correction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/lift_shaver_podowski").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/slope_limiter").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/wall_adhesion").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/sfc_modeling").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/virtual_mass").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/sfc_model_type").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                Specifies the lift function for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/lift").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit_options").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/jump_adhesion").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/sfc_tension_coeff").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/lift_montoya").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/interphase_discr").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/cavitation").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/vmass_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/lift/interphase_visc_disp").execute(*args, **kwargs)

                        class interphase_discretization(TUIMenu):
                            """
                            Enter the menu to set interphase discretization models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/cavitation").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/jump_adhesion").execute(*args, **kwargs)

                        class interphase_viscous_dissipation(TUIMenu):
                            """
                            Enter the menu to set interphase viscous dissipation related models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                            def sfc_modeling(self, *args, **kwargs):
                                """
                                Include the effects of surface tension along the fluid-fluid interface?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                            def cavitation(self, *args, **kwargs):
                                """
                                Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                            def wall_adhesion(self, *args, **kwargs):
                                """
                                Enable the specification for a wall adhesion angle?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                            def jump_adhesion(self, *args, **kwargs):
                                """
                                Enable the treatment of the contact angle specification at the porous jump boundary?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)

                    class numerics(TUIMenu):
                        """
                        Enters the menu to set numerics models. This menu is available for multiphase models with the sharp-dispersed and phase localized discretization interface modeling options (set in define/models/multiphase/interface-modeling-options).
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                            self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                            self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                            self.lift = self.__class__.lift(path + ["lift"], service)
                            self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                            self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                            super().__init__(path, service)
                        def mass_transfer(self, *args, **kwargs):
                            """
                            Specify the mass transfer mechanisms.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/mass_transfer").execute(*args, **kwargs)
                        def drag(self, *args, **kwargs):
                            """
                            Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/drag").execute(*args, **kwargs)
                        def model_transition(self, *args, **kwargs):
                            """
                            Set the model transition mechanism.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/model_transition").execute(*args, **kwargs)
                        def restitution(self, *args, **kwargs):
                            """
                            Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/restitution").execute(*args, **kwargs)
                        def interfacial_area(self, *args, **kwargs):
                            """
                            Set the interfacial area parameters for each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/interfacial_area").execute(*args, **kwargs)
                        def wall_lubrication(self, *args, **kwargs):
                            """
                            Specify the wall lubrication model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/wall_lubrication").execute(*args, **kwargs)
                        def turbulent_dispersion(self, *args, **kwargs):
                            """
                            Specify the turbulent dispersion model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/turbulent_dispersion").execute(*args, **kwargs)
                        def slip_velocity(self, *args, **kwargs):
                            """
                            Specify the slip velocity function for each secondary phase with respect to the primary phase.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/slip_velocity").execute(*args, **kwargs)
                        def turbulence_interaction(self, *args, **kwargs):
                            """
                            Specify the turbulence interaction model for each primary-secondary phase pair.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/turbulence_interaction").execute(*args, **kwargs)
                        def reactions(self, *args, **kwargs):
                            """
                            Define multiple heterogeneous reactions and stoichiometry.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/reactions").execute(*args, **kwargs)
                        def heat_coeff(self, *args, **kwargs):
                            """
                            Specify the heat transfer coefficient function between each pair of phases.
                            """
                            return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/heat_coeff").execute(*args, **kwargs)

                        class surface_tension(TUIMenu):
                            """
                            Enter the menu to set surface tension models.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def virtual_mass(self, *args, **kwargs):
                                """
                                Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/virtual_mass").execute(*args, **kwargs)
                            def vmass_implicit(self, *args, **kwargs):
                                """
                                Enable the implicit method for the virtual mass force?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit").execute(*args, **kwargs)
                            def lift_shaver_podowski(self, *args, **kwargs):
                                """
                                Include the Shaver-Podowski correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                            def interphase_discr(self, *args, **kwargs):
                                """
                                Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_discr").execute(*args, **kwargs)
                            def vmass_implicit_options(self, *args, **kwargs):
                                """
                                Select the virtual mass implicit option.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                            def lift_montoya(self, *args, **kwargs):
                                """
                                Include the Montoya correction for Lift.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_montoya").execute(*args, **kwargs)
                            def lift(self, *args, **kwargs):
                                """
                                .
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift").execute(*args, **kwargs)
                            def visc_disp_factor(self, *args, **kwargs):
                                """
                                Set the dissipation intensity.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                            def vmass_coeff(self, *args, **kwargs):
                                """
                                Specify the virtual mass coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_coeff").execute(*args, **kwargs)
                            def sfc_model_type(self, *args, **kwargs):
                                """
                                Select the surface tension model.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_model_type").execute(*args, **kwargs)
                            def interphase_visc_disp(self, *args, **kwargs):
                                """
                                Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                            def sfc_tension_coeff(self, *args, **kwargs):
                                """
                                Specify the surface tension coefficient for each pair of phases.
                                """
                                return PyMenu(self.service, "/define/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                            def slope_limiter(self, *args, **kwargs):
                                """
                                Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global 