# mkdocs-bootstrap-tables-plugin

This plugin converts the raw `<table>` elements that result from basic markdown, and augments them with [Bootstrap table classes](https://getbootstrap.com/docs/4.0/content/tables/) for improved styling. 

## Setup

Install the plugin using pip:

`pip install mkdocs-bootstrap-tables-plugin`

Activate the plugin in `mkdocs.yml`:
```yaml
plugins:
  - search
  - bootstrap-tables
```

> **Note:** If you have no `plugins` entry in your config file yet, you'll likely also want to add the `search` plugin. MkDocs enables it by default if there is no `plugins` entry set, but now you have to enable it explicitly.

More information about plugins in the [MkDocs documentation][mkdocs-plugins].

## Usage

Enabling this plugin will take a simple table generated by markdown:

### Original Markdown

```
| Parameter       | Type   | Description |
| --------------- | ------ | ----------- |
| `foo` | string | A parameter that does something. |
| `bar` | int | A parameter that does something. | 
| `baz` | URI     | Required. You better use this. |
```

### HTML before processing

This is the HTML that Markdown will produce:

```html
<table>
<thead>
<tr>
<th>Parameter</th>
<th>Type</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td><code>foo</code></td>
<td>string</td>
<td></td>
</tr>
<tr>
<td><code></code></td>
<td>int</td>
<td>A parameter that does something.</td>
</tr>
<tr>
<td><code>baz</code></td>
<td>A parameter that does something.URI</td>
<td>Required. You better use this.</td>
</tr>
</tbody>
</table>
```

### HTML after processing

This is the HTML after this plugin has run:

```html
<table class="table">
<thead>
<tr>
<th scope="col">Parameter</th>
<th scope="col">Type</th>
<th scope="col">Description</th>
</tr>
</thead>
<tbody>
<tr>
<td><code>foo</code></td>
<td>string</td>
<td></td>
</tr>
<tr>
<td><code></code></td>
<td>int</td>
<td>A parameter that does something.</td>
</tr>
<tr>
<td><code>baz</code></td>
<td>A parameter that does something.URI</td>
<td>Required. You better use this.</td>
</tr>
</tbody>
</table>
```

## See Also

More information about templates [here][mkdocs-template].

More information about blocks [here][mkdocs-block].

[mkdocs-plugins]: http://www.mkdocs.org/user-guide/plugins/
[mkdocs-template]: https://www.mkdocs.org/user-guide/custom-themes/#template-variables
[mkdocs-block]: https://www.mkdocs.org/user-guide/styling-your-docs/#overriding-template-blocks
