--------------------------------------------------------
--  DDL for Table PROJECT
--------------------------------------------------------

  CREATE TABLE "PROJECT" 
   (	"PROJECT_ID" NUMBER, 
	"PROJECT_NAME" VARCHAR2(1024), 
	"NCBI_BIOPROJECT_ID" NUMBER(*,0), 
	"ADD_DATE" TIMESTAMP (6), 
	"MOD_DATE" TIMESTAMP (6), 
	"MOD_BY" NUMBER(*,0), 
	"DESCRIPTION" VARCHAR2(4000), 
	"SPECIMEN_ID" NUMBER(*,0), 
	"ORGANISM_TYPE" VARCHAR2(32), 
	"NUCLEIC_ACID" VARCHAR2(16), 
	"SUBMITTER_PROJECT_NAME" VARCHAR2(1000), 
	"NCBI_PROJECT_NAME" VARCHAR2(1000), 
	"ISOLATION_PUBLICATION_ID" NUMBER(*,0), 
	"COMPLETION_DATE" DATE, 
	"ACTIVE" VARCHAR2(3) DEFAULT 'Yes', 
	"PMO_PROJECT_ID" NUMBER(*,0), 
	"ITS_SPID" NUMBER(*,0), 
	"PROJECT_OID" NUMBER(*,0), 
	"SAMPLE_OID" NUMBER(*,0), 
	"GOLD_ID" VARCHAR2(20), 
	"OLD_LEGACY_GOLD_ID" VARCHAR2(20), 
	"LEGACY_GOLD_ID" VARCHAR2(20), 
	"IS_PUBLIC" VARCHAR2(20) DEFAULT NULL, 
	"ORGANISM_ID" NUMBER(*,0), 
	"SEQUENCING_STATUS_ID" NUMBER(*,0), 
	"SEQUENCING_QUALITY_ID" NUMBER(*,0), 
	"FINISHING_GOAL_ID" NUMBER(*,0), 
	"SEQUENCING_COMMENTS" VARCHAR2(3000), 
	"GC_PERCENT" NUMBER(*,0), 
	"CONTIG_COUNT" NUMBER(*,0), 
	"EST_SIZE" NUMBER(*,0), 
	"CHROMOSOME_COUNT" NUMBER(*,0), 
	"PLASMID_COUNT" NUMBER(*,0), 
	"SCAFFOLD_COUNT" NUMBER(*,0), 
	"EST_COUNT" NUMBER(*,0), 
	"SUBMITTER_ID" NUMBER(*,0), 
	"NCBI_BIOPROJECT_ACCESSION" VARCHAR2(20), 
	"PROJECT_COMMENTS" VARCHAR2(3000), 
	"ANNOTATOR_COMMENTS" VARCHAR2(4000), 
	"ITS_PROPOSAL_ID" NUMBER, 
	"GPTS_PROPOSAL_ID" NUMBER, 
	"NCBI_SRA_ID" VARCHAR2(64), 
	"LIBRARY_METHOD" VARCHAR2(500), 
	"READ_COUNT" VARCHAR2(500), 
	"VECTOR" VARCHAR2(500), 
	"READ_SIZE" VARCHAR2(500), 
	"NCBI_LOCUS_TAG" VARCHAR2(1024), 
	"ASSEMBLY_ACCESSION" VARCHAR2(50), 
	"IS_DRAFT" VARCHAR2(3) DEFAULT 'No', 
	"NUCLEIC_ACID_ID" NUMBER DEFAULT NULL, 
	"PI_ID" NUMBER, 
	"PROJECT_STATUS" VARCHAR2(265), 
	"MASTER_STUDY_ID" NUMBER, 
	"OTHER_PROJECT_NAMES" VARCHAR2(4000), 
	"ITS_PROJECT_NAME" VARCHAR2(4000), 
	"IS_SINGLE_CELL_MATERIAL" VARCHAR2(3) DEFAULT NULL, 
	"ITS_SEQUENCING_PRODUCT_NAME" VARCHAR2(256), 
	"PROJECT_MANAGER_ID" NUMBER, 
	"NCBI_BIOSAMPLE_ACCESSION" VARCHAR2(128), 
	"LOW_QUALITY_GENOME" VARCHAR2(3) DEFAULT 'No', 
	"SEQUENCING_STRATEGY" VARCHAR2(100), 
	"PUBLIC_AP_COUNT" NUMBER DEFAULT 0, 
	"ADMIN_AP_COUNT" NUMBER DEFAULT 0, 
	"PUBLIC_DAP_COUNT" NUMBER DEFAULT 0, 
	"ADMIN_DAP_COUNT" NUMBER DEFAULT 0, 
	"IS_JGI" VARCHAR2(10), 
	"SRA_SRS_ACCESSION" VARCHAR2(50), 
	"SRA_SRX_ACCESSION" VARCHAR2(50), 
	"FUNDING_PROGRAM" VARCHAR2(32), 
	"FUNDING_YEAR" NUMBER, 
	"ITS_SAMPLE_ID" NUMBER, 
	"ITS_SAMPLE_GROUP_NAME" VARCHAR2(255), 
	"EXPERIMENTAL_CONDITIONS" VARCHAR2(4000), 
	"SAMPLE_GROUP_NAME" VARCHAR2(256), 
	"ITS_SAMPLE_NAME" VARCHAR2(256), 
	"PROJECT_SUBTYPE" VARCHAR2(100), 
	"SEQUENCING_STRATEGY_FULL" VARCHAR2(100), 
	"IS_TEST" VARCHAR2(100) DEFAULT 'No', 
	"IS_APPROVED" VARCHAR2(15) DEFAULT 'No', 
	"IS_LOCKED" VARCHAR2(15) DEFAULT 'No', 
	"GPTS_SAMPLE_ID" NUMBER, 
	"GPTS_DISAMBIGUATOR" VARCHAR2(128), 
	"SINGLE_CELL_LYSIS_PROT" VARCHAR2(250), 
	"WGA_AMP_APPR" VARCHAR2(250), 
	"SORT_TECH" VARCHAR2(250), 
	"SINGLE_CELL_LYSIS_APPR" VARCHAR2(250), 
	"LIBRARY_LAYOUT" VARCHAR2(250), 
	"CONTAM_SCREEN_INPUT" VARCHAR2(250), 
	"WGA_AMP_KIT" VARCHAR2(250), 
	"NUCL_ACID_EXT_LIT" VARCHAR2(250), 
	"NUCL_ACID_AMP_LIT" VARCHAR2(250), 
	"LIBRARY_SCREEN" VARCHAR2(250), 
	"PCR_PRIMERS" VARCHAR2(250), 
	"MULTIPLEX_IDENTIFIERS" VARCHAR2(250), 
	"ADAPTERS" VARCHAR2(250), 
	"PCR_COND" VARCHAR2(250), 
	"TARGET_GENE" VARCHAR2(250), 
	"TARGET_SUBFRAGMENT" VARCHAR2(250)
   )
