"""
Built using ansys documentation from
https://www.sharcnet.ca/Software/Ansys/

"""

# consider moving the docstrings into a different module


class _MapdlCommands(object):
    """ANSYS class containing MAPDl functions generated from ANSYS 16.2

    """

    def mforder(self, fnumb1="", fnumb2="", fnumb3="", fnumb4="", fnumb5="",
                fnumb6="", fnumb7="", fnumb8="", fnumb9="", fnumb10="",
                fnumb11="", fnumb12="", fnumb13="", fnumb14="", fnumb15="",
                fnumb16="", fnumb17="", fnumb18="", fnumb19="", fnumb20="",
                **kwargs):
        """APDL Command: MFORDER

        Specifies field solution order for an ANSYS Multi-field solver
        analysis.

        Parameters
        ----------
        fnumb1, fnumb2, fnumb3, . . . , fnumb20
            Field numbers defined by the MFELEM command .

        Notes
        -----
        You can define up to twenty fields in an ANSYS Multi-field solver
        analysis.

        This command is also valid in PREP7.

        See Multi-field Commands in the Coupled-Field Analysis Guide for a list
        of all ANSYS Multi-field solver commands and their availability for MFS
        and MFX analyses.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "MFORDER,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(fnumb1), str(fnumb2), str(fnumb3), str(fnumb4), str(fnumb5), str(fnumb6), str(fnumb7), str(fnumb8), str(fnumb9), str(fnumb10), str(fnumb11), str(fnumb12), str(fnumb13), str(fnumb14), str(fnumb15), str(fnumb16), str(fnumb17), str(fnumb18), str(fnumb19), str(fnumb20))
        return self.run(command, **kwargs)

    def pdshis(self, rlab="", name="", type="", conf="", **kwargs):
        """APDL Command: PDSHIS

        Plots the sample history values.

        Parameters
        ----------
        rlab
            Result set label. Identifies the result set to be used for
            postprocessing. A result set label can be the solution set label
            you defined in a PDEXE command, or the response surface set label
            defined in an RSFIT command.

        name
            Parameter name. The parameter must have been previously defined as
            a random input variable or a random output parameter using the
            PDVAR command.

        type
            Keyword to identify which type of data is to be plotted:

            SAMP - Sampled values (default).

            MEAN - Mean values for results based on Monte Carlo simulation methods only.

            STDV - Standard deviations for results based on Monte Carlo simulation methods only.

            MIN - Minimum values for results based on Monte Carlo simulation methods only.

            MAX - Maximum values for results based on Monte Carlo simulation methods only.

        conf
            Confidence level. The confidence level is used to plot confidence
            bounds for the history value. The value for the confidence level
            must be between 0.0 and 1.0 and it defaults to 0.95 (95%).
            Confidence bound(s) plotting is suppressed for CONF  0.5. This
            option is ignored for Type = SAMP (no confidence bounds are
            plotted).

        Notes
        -----
        Plots the sample history values as a function of the number of
        simulation loops.

        If Rlab is left blank, then the result set label is inherited from the
        last PDEXE command (Slab), RSFIT command (RSlab), or the most recently
        used PDS postprocessing command where a result set label was explicitly
        specified.

        The confidence level is a probability expressing the confidence that
        the value for the requested probability is in fact between the
        confidence bounds. The larger the confidence level, the wider the
        confidence bounds. For Type = MEAN and Type = STDV, lower and upper
        confidence curves are plotted. For Type = MEAN, the mean value curve
        starts at the first simulation and the confidence bounds start with
        simulation number 2. For Type = MIN only the upper confidence bound is
        shown (the interpretation is that by a certain probability the true
        minimum value is below this curve). This probability (or confidence) is
        set using CONF. Likewise, for Type = MAX, only the lower confidence
        bound is shown. For all Type options, confidence curves are plotted
        starting with the simulation at which enough data is available to
        calculate the bounds. However, for scaling reasons, no confidence
        bounds are plotted for simulation numbers 1 to 5 even if they might be
        available.
        """
        command = "PDSHIS,%s,%s,%s,%s" % (str(rlab), str(name), str(type), str(conf))
        return self.run(command, **kwargs)

    def cscir(self, kcn="", kthet="", kphi="", **kwargs):
        """APDL Command: CSCIR

        Locates the singularity for non-Cartesian local coordinate systems.

        Parameters
        ----------
        kcn
            Number of the local coordinate system in which singularity location
            is to be changed.  Must be greater than 10.

        kthet
            Theta singularity location for cylindrical, spherical, and toroidal
            systems:

            0 - Singularity at ±180°.

            1 - Singularity at 0° (360°).

        kphi
            Phi singularity location for toroidal systems:

            0 - Singularity in phi direction at ±180°.

            1 - Singularity in phi direction at 0° (360°).

        Notes
        -----
        Continuous closed surfaces (circles, cylinders, spheres, etc.) have a
        singularity (discontinuity) at θ = ±180°. For local cylindrical,
        spherical, and toroidal coordinate systems, this singularity location
        may be changed to 0° (360°).

        An additional, similar singularity occurs in the toroidal coordinate
        system at: Φ = ±180° and can be moved with KPHI.  Additional
        singularities occur in the spherical coordinate system at: Φ = ±90°,
        but cannot be moved.

        This command is valid in any processor.
        """
        command = "CSCIR,%s,%s,%s" % (str(kcn), str(kthet), str(kphi))
        return self.run(command, **kwargs)

    def pras(self, quantity="", loadstep="", substep="", **kwargs):
        """APDL Command: PRAS

        Calculates a specified acoustic quantity on the selected exterior
        surface or the frequency-band sound pressure level (SPL).

        Parameters
        ----------
        quantity
            The acoustic quantity to calculate:

            SIMP - Specific acoustic impedance on the selected surface.

            AIMP  - Acoustic impedance on the selected surface.

            MIMP  - Mechanical impedance on the selected surface.

            PRES  - Average pressure on the selected surface.

            FORC  - Force on the selected surface.

            POWE  - Acoustic power on the selected surface.

            BSPL  - Frequency-band sound pressure level.

            BSPA  - A-weighted frequency-band sound pressure level.

        loadstep
            Specified load step. Default = 1.

        substep
            Specified substep. Default = All substeps at the specified load
            step. Not valid for Quantity = BSPL or BSPA.

        Notes
        -----
        The PRAS command calculates a specified acoustic quantity on the
        selected exterior surface in postprocessing. The calculation is based
        on the pressure and velocity solution or the frequency-band sound
        pressure level (SPL).

        The total pressure and velocity are used if the selected surface is the
        excitation source surface. To calculate the incoming and outgoing
        acoustic power, and other sound power parameters, on the excitation
        source surface, issue the SF,,PORT and SPOWER commands.

        The sound pressure level of the octave bands and general frequency band
        (defined via the HARFRQ command) is calculated at the selected nodes in
        the model.
        """
        command = "PRAS,%s,%s,%s" % (str(quantity), str(loadstep), str(substep))
        return self.run(command, **kwargs)

    def tbplot(self, lab="", mat="", tbopt="", temp="", segn="", **kwargs):
        """APDL Command: TBPLOT

        Displays the material data table.

        Parameters
        ----------
        lab
            Data table label.  Valid labels are:  MKIN, KINH, MELAS, MISO,
            BKIN, BISO, BH, GASKET, and JOIN.  Defaults to the active table
            label.  For B-H data, also valid are: NB to display NU-B2, MH to
            display MU vs. H, and SBH, SNB, SMH to display the slopes of the
            corresponding data.

        mat
            Material number to be displayed (defaults to the active material).

        tbopt
            Gasket material or joint element material option to be plotted.

            ALL - Plots all gasket data.

            COMP - Plots gasket compression data only.

            LUNL - Plots gasket linear unloading data with compression curve.

            NUNL - Plots gasket nonlinear unloading data only.

        temp
            Specific temperature at which gasket data or joint element material
            data will be plotted (used only when Lab = GASKET or JOIN). Use
            TEMP = ALL to plot gasket data or joint element material data at
            all temperatures.

        segn
            Segment number of plotted curve (valid only when Lab = GASKET):

            NO - Segment number is not added to plotted curve (default).

            YES - Segment number is added to plotted curve. This option is ignored if the number
                  of data points in a curve exceeds 20.

        Notes
        -----
        Only data for stress-strain, B-H, gasket curves, or joint element
        nonlinear material model curves can be displayed.

        The TBOPT and TEMP values are valid only when Lab = GASKET or JOIN.

        The SEGN value is valid only when Lab = GASKET.

        This command is valid in any processor.
        """
        command = "TBPLOT,%s,%s,%s,%s,%s" % (str(lab), str(mat), str(tbopt), str(temp), str(segn))
        return self.run(command, **kwargs)

    def hptdelete(self, np1="", np2="", ninc="", **kwargs):
        """APDL Command: HPTDELETE

        Deletes selected hardpoints.

        Parameters
        ----------
        np1, np2, ninc
            Delete the pattern of hard points beginning with NP1 to NP2 in
            steps of NINC (defaults to 1).  If NP1 = ALL, NP2 and NINC are
            ignored and the pattern is all selected hard points [KSEL].  If NP1
            = P, graphical picking is enabled and all remaining command fields
            are ignored.

        Notes
        -----
        Deletes all attributes attached to the designated hard points as well
        as the hard points themselves.  If any entity is attached to a
        designated hard point, the command detaches the hard point from that
        entity (the program will alert you that this will occur).
        """
        command = "HPTDELETE,%s,%s,%s" % (str(np1), str(np2), str(ninc))
        return self.run(command, **kwargs)

    def sfcalc(self, labr="", labs="", labt="", type="", **kwargs):
        """APDL Command: SFCALC

        Calculates the safety factor or margin of safety.

        Parameters
        ----------
        labr
            Label assigned to results.  If same as existing label, the existing
            values will be overwritten by these results.

        labs
            Labeled result item corresponding to the element stress.

        labt
            Labeled result item corresponding to the element temperature.

        type
            Type of calculation:

            0 or 1 - Use safety factor (SF) calculation.

            2 - Use margin of safety (MS) calculation.

            3 - Use 1/SF calculation.

        Notes
        -----
        Calculates safety factor (SF) or margin of safety (MS) as described for
        the SFACT command for any labeled result item (see ETABLE command) for
        the selected elements.  Use the PRETAB or PLETAB command to display
        results.  Allowable element stress is determined from the SALLOW-TALLOW
        table [SALLOW, TALLOW].
        """
        command = "SFCALC,%s,%s,%s,%s" % (str(labr), str(labs), str(labt), str(type))
        return self.run(command, **kwargs)

    def writemap(self, fname="", **kwargs):
        """APDL Command: WRITEMAP

        Writes interpolated pressure data to a file.

        Parameters
        ----------
        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        Notes
        -----
        Writes the interpolated pressure data to the specified file. The data
        is written as SFE commands applied to the SURF154 elements that are on
        the target surface. You may read this data for inclusion in an analysis
        by using /INPUT,Fname.
        """
        command = "WRITEMAP,%s" % (str(fname))
        return self.run(command, **kwargs)

    def ewrite(self, fname="", ext="", unused="", kappnd="", format="", **kwargs):
        """APDL Command: EWRITE

        Writes elements to a file.

        Parameters
        ----------
        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        kappnd
            Append key:

            0 - Rewind file before the write operation.

            1 - Append data to the end of the existing file.

        format
            Format key:

            SHORT - I6 format (the default).

            LONG - I8 format.

        Notes
        -----
        Writes the selected elements to a file. The write operation is not
        necessary in a standard ANSYS run but is provided as convenience to
        users wanting a coded element file. If issuing EWRITE from ANSYS to be
        used in ANSYS, you must also issue NWRITE to store nodal information
        for later use. Only elements having all of their nodes defined (and
        selected) are written. Data are written in a coded format. The data
        description of each record is: I, J, K, L, M, N, O, P, MAT, TYPE, REAL,
        SECNUM, ESYS, IEL, where MAT, TYPE, REAL, and ESYS are attribute
        numbers, SECNUM is the beam section number, and IEL is the element
        number.

        The format is (14I6) if Format is set to SHORT and (14I8) if the Format
        is set to LONG, with one element description per record for elements
        having eight nodes of less. For elements having more than eight nodes,
        nodes nine and above are written on a second record with the same
        format.
        """
        command = "EWRITE,%s,%s,%s,%s,%s" % (str(fname), str(ext), str(unused),
                                             str(kappnd), str(format))
        return self.run(command, **kwargs)

    def f(self, node="", lab="", value="", value2="", nend="", ninc="",
          **kwargs):
        """APDL Command: F

        Specifies force loads at nodes.

        Parameters
        ----------
        node
            Node at which force is to be specified.  If ALL, NEND and NINC are
            ignored and forces are applied to all selected nodes [NSEL]. If
            NODE = P, graphical picking is enabled and all remaining command
            fields are ignored (valid only in the GUI).  A component name may
            also be substituted for NODE.

        lab
            Valid force label.  Structural labels:  FX, FY, or FZ (forces); MX,
            MY, or MZ (moments).  Thermal labels:  HEAT, HBOT, HE2, HE3, . . .,
            HTOP (heat flow).  Fluid labels:  FLOW (fluid flow).   Electric
            labels:  AMPS (current flow), CHRG (electric charge).  Magnetic
            labels:  FLUX (magnetic flux);  CSGX, CSGY, or CSGZ (magnetic
            current segments).  Diffusion labels: RATE (diffusion flow rate).

        value
            Force value or table name reference for specifying tabular boundary
            conditions.  To specify a table, enclose the table name in percent
            signs (%), e.g., F, NODE,HEAT,%tabname%).  Use the *DIM command to
            define a table.

        value2
            Second force value (if any).  If the analysis type and the force
            allow a complex input, VALUE (above) is the real component and
            VALUE2 is the imaginary component.

        nend, ninc
            Specifies the same values of force at the nodes ranging from NODE
            to NEND (defaults to NODE), in steps of NINC (defaults to 1).

        Notes
        -----
        The available force loads per node correspond to the degrees of freedom
        listed under "Degrees of Freedom" in the input table for each element
        type in the Element Reference.  If both a force and a constrained
        degree of freedom [D] are specified at the same node, the constraint
        takes precedence.  Forces are defined in the nodal coordinate system.
        The positive directions of structural forces and moments are along and
        about the positive nodal axis directions.  The node and the degree of
        freedom label corresponding to the force must be selected [NSEL,
        DOFSEL].

        For hydrostatic fluid elements (HSFLD241 and HSFLD242), DVOL is used to
        specify fluid mass flow rate (with units of mass/time) at the pressure
        node. This allows fluid to be added or taken out of the fluid elements
        sharing the pressure node. A fluid density must also be specified (via
        the MP command or TB command) to apply a volume change corresponding to
        the prescribed fluid mass flow rate.

        Tabular boundary conditions (VALUE = %tabname%) are available only for
        the following labels: Fluid (FLOW), Electric (AMPS), Structural force
        (FX, FY, FZ, MX, MY, MZ), and Thermal (HEAT, HBOT, HE2, HE3, . . .,
        HTOP). Tabular boundary conditions are valid only in static
        (ANTYPE,STATIC), full transient (ANTYPE,TRANS), full harmonic (ANTYPE,
        HARMIC), modal superposition harmonic and modal superposition transient
        analyses.

        This command is also valid in PREP7.
        """
        command = "F,%s,%s,%s,%s,%s,%s" % (str(node), str(lab), str(value), str(value2), str(nend), str(ninc))
        return self.run(command, **kwargs)

    def bfadele(self, area="", lab="", **kwargs):
        """APDL Command: BFADELE

        Deletes body force loads on an area.

        Parameters
        ----------
        area
            Area at which body load is to be deleted.  If ALL, delete for all
            selected areas [ASEL]. A component name may also be substituted for
            AREA.

        lab
            Valid body load label. If ALL, use all appropriate labels. Load
            labels are listed under "Body Loads" in the input table for each
            element type in the Element Reference. See the BFA command for
            labels.

        Notes
        -----
        Deletes body force loads (and all corresponding finite element loads)
        for a specified area and label.  Body loads may be defined on an area
        with the BFA command.

        Graphical picking is available only via the listed menu paths.

        This command is also valid in PREP7.
        """
        command = "BFADELE,%s,%s" % (str(area), str(lab))
        return self.run(command, **kwargs)

    def voper(self, parr="", par1="", oper="", par2="", con1="", con2="",
              **kwargs):
        """APDL Command: *VOPER

        Operates on two array parameters.

        Parameters
        ----------
        parr
            The name of the resulting array parameter vector.  See *SET  for
            name restrictions.

        par1
            First array parameter vector in the operation.  May also be a
            scalar parameter or a literal constant.

        oper
            Operations:

            Addition: Par1+Par2. - Subtraction: Par1-Par2.

            Multiplication: Par1*Par2. - Division: Par1/Par2  (a divide by zero results in a value of zero).

            Minimum: minimum of Par1 and Par2. - Maximum: maximum of Par1 and Par2.

            Less than comparison: Par1<Par2 gives 1.0 if true, 0.0 if false. - Less than or equal comparison: Par1 Par2 gives 1.0 if true, 0.0 if false.

            Equal comparison: Par1 = Par2 gives 1.0 if true, 0.0 if false. - Not equal comparison: Par1 ≠ Par2 gives 1.0 if true, 0.0 if false.

            Greater than or equal comparison: Par1 Par2 gives 1.0 if true, 0.0 if false. - Greater than comparison: Par1>Par2 gives 1.0 if true, 0.0 if false.

            First derivative: d(Par1)/d(Par2).  The derivative at a point is determined  over points half way between the previous and next points (by linear  interpolation). Par1 must be a function (a unique Par1 value for each Par2 value) and Par2 must be in ascending order. - Second derivative: d2(Par1)/d(Par2)2.  See also DER1.

            Single integral:    Par1 d(Par2), where CON1 is the integration constant.  The integral at a point is determined by using the single integration procedure described in the Mechanical APDL Theory Reference. - Double integral:       Par1 d(Par2), where CON1 is the integration constant of
                              the first integral and CON2 is the integration
                              constant of the second integral.  If Par1
                              contains acceleration data, CON1 is the initial
                              velocity and CON2 is the initial displacement.
                              See also INT1.

            Dot product: Par1  . Par2.  Par1 and Par2 must each have three consecutive columns of data, with the columns containing the i, j, and k vector components, respectively.  Only the starting row index and the column index for the i components are specified for Par1 and Par2, such as A(1,1).  The j and k components of the vector are assumed to begin in the corresponding next columns, such as A(1,2) and A(1,3). - Cross product: Par1 x Par2.  Par1, Par2, and ParR must each have 3 components,
                              respectively.  Only the starting row index and
                              the column index for the i components are
                              specified for Par1, Par2, and ParR, such as
                              A(1,1).  The j and k components of the vector are
                              assumed to begin in the corresponding next
                              columns, such as A(1,2) and A(1,3).

            Gather:  For a vector of position numbers, Par2, copy the value of Par1 at each position number to ParR.  Example:  for Par1 = 10,20,30,40 and Par2 = 2,4,1;  ParR = 20,40,10. - Scatter:  Opposite of GATH operation.  For a vector of position numbers, Par2,
                              copy the value of Par1 to that position number in
                              ParR.  Example: for Par1 = 10,20,30,40,50 and
                              Par2 = 2,1,0,5,3; ParR = 20,10,50,0,40.

            Arctangent: arctangent of Par1/Par2 with the sign of each component considered. - Transform the data in Par1 from the global Cartesian coordinate system to the
                              local coordinate system given in CON1. Par1 must
                              be an N x 3 (i.e., vector) or an N x 6 (i.e.,
                              stress or strain tensor) array. If the local
                              coordinate system is a cylindrical, spherical, or
                              toroidal system, then you must provide the global
                              Cartesian coordinates in Par2 as an N x 3 array.
                              Set CON2 = 1 if the data is strain data.

        par2
            Second array parameter vector in the operation.  May also be a
            scalar parameter or a literal constant.

        con1
            First constant (used only with the INT1 and INT2 operations).

        con2
            Second constant (used only with the INT2 operation).

        Notes
        -----
        Operates on two input array parameter vectors and produces one output
        array parameter vector according to:

        ParR = Par1 o Par2

        where the operations (o) are described below.  ParR may be the same as
        Par1 or Par2.  Absolute values and scale factors may be applied to all
        parameters [*VABS, *VFACT].  Results may be cumulative [*VCUM].
        Starting array element numbers must be defined for each array parameter
        vector if it does not start at the first location, such as
        *VOPER,A,B(5),ADD,C(3) which adds the third element of C to the fifth
        element of B and stores the result in the first element of A.
        Operations continue on successive array elements [*VLEN, *VMASK] with
        the default being all successive elements.  Skipping array elements via
        *VMASK or *VLEN for the DER_ and INT_ functions skips only the writing
        of the results (skipped array element data are used in all
        calculations).

        Parameter functions and operations are available to operate on a scalar
        parameter or a single element of an array parameter, such as SQRT(B) or
        SQRT(A(4)).  See the *SET command for details.  Operations on a
        sequence of array elements can be done by repeating the desired
        function or operation in a do-loop [*DO].  The vector operations within
        the ANSYS program (*VXX commands) are internally programmed do-loops
        that conveniently perform the indicated operation over a sequence of
        array elements.  If the array is multidimensional, only the first
        subscript is incremented in the do-loop, that is, the operation repeats
        in column vector fashion "down" the array.  For example, for A(1,5),
        A(2,5), A(3,5), etc.  The starting location of the row index must be
        defined for each parameter read and for the result written.

        The default number of loops is from the starting result location to the
        last result location and can be altered with the *VLEN command.  A
        logical mask vector may be defined to control at which locations the
        operations are to be skipped [*VMASK].  The default is to skip no
        locations.  Repeat operations automatically terminate at the last array
        element of the result array column if the number of loops is undefined
        or if it exceeds the last result array element.  Zeroes are used in
        operations for values read beyond the last array element of an input
        array column.  Existing values in the rows and columns of the results
        matrix
        """
        command = "*VOPER,%s,%s,%s,%s,%s,%s" % (str(parr), str(par1), str(oper), str(par2), str(con1), str(con2))
        return self.run(command, **kwargs)

    def keep(self, key="", **kwargs):
        """APDL Command: KEEP

        Stores POST26 definitions and data during active session.

        Parameters
        ----------
        key
            State or value

            On or 1  - Allows you to exit and reenter /POST26 without losing your current time history
                       variable information. Keeps a cache of the /POST26
                       variable information including the active file name
                       (FILE),  variable definitions (NSOL, ESOL, GAPF, RFORCE,
                       SOLU, and EDREAD) and stored variable data in memory for
                       the current ANSYS session.

            Off or 0  - /POST26 variable information is deleted when you exit /POST26.

        Notes
        -----
        Your variable information is saved in memory only for the current
        active ANSYS session. It is deleted when you exit ANSYS. This
        information is also deleted when you issue /CLEAR, RESUME, SOLVE, or
        RESET.

        When you reenter /POST26 all time history variable data is available
        for use. When you issue STORE,NEW, variable definitions created by math
        operations such as ADD or PROD will not be restored. However, variables
        defined with NSOL, ESOL, GAPF, RFORCE, SOLU, and EDREAD will be
        restored. Only the last active results file name is kept in memory
        (FILE).

        Commands such as LAYERP26, SHELL, and FORCE that specify the location
        or a component of data to be stored will retain the setting at the time
        of exiting /POST26 .
        """
        command = "KEEP,%s" % (str(key))
        return self.run(command, **kwargs)

    def czmesh(self, ecomps1="", ecomps2="", kcn="", kdir="", value="",
               cztol="", **kwargs):
        """APDL Command: CZMESH

        Create and mesh an interface area composed of cohesive zone elements.

        Parameters
        ----------
        ecomps1
            Component name or number for the group of plane or solid structural
            elements adjacent to the interface being meshed.

        ecomps2
            Component name or number for the opposing (from ecomps1) group of
            plane or solid structural elements adjacent to the interface being
            meshed.

        kcn
            Coordinate system number for the separation surface and normal
            direction. (if ecomps1 and ecomps2 not specified)

        kdir
            Direction (x, y, or z) normal to separation surface in the KCN
            coordinate system (if ecomps1 and ecomps2 not specified).

        value
            Coordinate value along the KDIR axis at which to locate the
            interface (if ecomps1 and ecomps2 not specified).

        cztol
            Optional absolute tolerance about VALUE (if ecomps1 and ecomps2 not
            specified). Allows nodes occurring slightly above or below the
            separation to be grouped properly. The following expression
            represents the default value:

        Notes
        -----
        CZMESH is used on a mesh with shared nodes at the interface.

        If ecomps1 and ecomps2 are specified, the CZMESH command creates/meshes
        interface elements (INTER202, INTER203, INTER204, INTER205) along the
        boundary between the two components or groups of elements.

        The elements in each of the components or groups of elements will share
        nodes with each other and also with the interface elements. This one-
        element thick boundary of interface elements will split the body
        between the two components or groups of elements.

        Subsequent separation (delamination and failure) of the interface zone
        will result in an increasing displacement between the nodes (within the
        interface element) along the cohesive zone elements. Unless otherwise
        specified, the CZMESH command analyzes the configuration and geometry
        of the adjacent structural elements and provides the appropriate
        interface element.

        The CZMESH operation copies any nodal temperatures you have defined on
        the split surface of the original mesh from the original nodes to the
        newly created coincident duplicate nodes. However, displacements,
        forces, and other boundary conditions are not copied.

        The CZMESH command is valid for structural analyses only.
        """
        command = "CZMESH,%s,%s,%s,%s,%s,%s" % (str(ecomps1), str(ecomps2), str(kcn), str(kdir), str(value), str(cztol))
        return self.run(command, **kwargs)

    def edsp(self, option="", min="", max="", inc="", **kwargs):
        """APDL Command: EDSP

        Specifies small penetration checking for contact entities in an
        explicit dynamic analysis.

        Parameters
        ----------
        option
            Label identifying the option to be performed (no default).

            ON   - Turn small penetration checking on for specified contact entities.

            OFF - Turn small penetration checking off for specified contact entities.

            LIST   - List current setting for penetration checking.

        min
            Minimum contact entity number for which to turn on/off small
            penetration check (default = 1).

        max
            Maximum contact entity number for which to turn on/off small
            penetration check (defaults to MIN).

        inc
            Contact entity number increment (default = 1).

        Notes
        -----
        This command controls small penetration checking in an explicit dynamic
        analysis. EDSP is applicable only to the following contact types: STS,
        NTS, OSTS, TNTS, and TSTS. The penetration checking specified by EDSP
        is similar to PENCHK on the EDCONTACT command. However, EDSP controls
        penetration checking for individual contact entities whereas PENCHK is
        a global control that applies to all defined contact (of the types
        mentioned above). EDSP can be used in a new analysis, or in a small
        restart (EDSTART,2).

        Use the EDCLIST command to list the contact entity numbers for all
        defined contact.

        This command is also valid in SOLUTION.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDSP,%s,%s,%s,%s" % (str(option), str(min), str(max), str(inc))
        return self.run(command, **kwargs)

    def rmclist(self, **kwargs):
        """APDL Command: RMCLIST

        Lists all lumped capacitance pairs defined.

        Notes
        -----
        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "RMCLIST," % ()
        return self.run(command, **kwargs)

    def latt(self, mat="", real="", type="", unused="", kb="", ke="", secnum="",
             **kwargs):
        """APDL Command: LATT

        Associates element attributes with the selected, unmeshed lines.

        Parameters
        ----------
        mat, real, type
            Material number, real constant set number, and type number to be
            associated with selected, unmeshed lines.

        --
            Unused field.

        kb, ke
            Beginning and ending orientation keypoints to be associated with
            selected, unmeshed lines.  ANSYS uses the location of these
            keypoints to determine how to orient beam cross sections during
            beam meshing.  Beam elements may be created along a line with a
            constant orientation by specifying only one orientation keypoint
            (KB), or a pre-twisted beam may be created by selecting different
            orientation keypoints at each end of the line (KB and KE).  (For a
            line bounded by two keypoints (KP1 and KP2), the orientation vector
            at the beginning of the line extends from KP1 to KB, and the
            orientation vector at the end of the line extends from KP2 to KE.
            The orientation vectors are used to compute the orientation nodes
            of the elements.)

        secnum
            Section identifier to be associated with selected, unmeshed lines.
            For details, see the description of the SECTYPE and SECNUM
            commands.

        Notes
        -----
        The element attributes specified by the LATT command will be used when
        the lines are meshed.

        Lines subsequently generated from the lines will also have the
        attributes specified by MAT, REAL, TYPE, and SECNUM.  If a line does
        not have these attributes associated with it (by this command) at the
        time it is meshed, the attributes are obtained from the then current
        MAT, REAL, TYPE, and SECNUM command settings.

        In contrast, the values specified by KB and KE apply only to the
        selected lines; that is, lines subsequently generated from these lines
        will not share these attributes.  Similarly, if a line does not have KB
        and KE attributes associated with it via the LATT command at the time
        it is meshed, ANSYS cannot obtain the attributes from elsewhere.  See
        the discussion on beam meshing in Meshing Your Solid Model in the
        Modeling and Meshing Guide for more information.

        Reissue the LATT command (before lines are meshed) to change the
        attributes.  A zero (or blank) argument removes the corresponding
        association. If any of the arguments are defined as -1, then that value
        will be left unchanged in the selected set.

        In some cases, ANSYS can proceed with a line meshing operation even
        when no logical element type has been assigned via LATT,,,TYPE or TYPE.
        See Meshing Your Solid Model in the Modeling and Meshing Guide for more
        information about setting element attributes.
        """
        command = "LATT,%s,%s,%s,%s,%s,%s,%s" % (str(mat), str(real), str(type),
                                                 str(unused), str(kb), str(ke),
                                                 str(secnum))
        return self.run(command, **kwargs)

    def fdele(self, node="", lab="", nend="", ninc="", lkey="", **kwargs):
        """APDL Command: FDELE

        Deletes force loads on nodes.

        Parameters
        ----------
        node
            Node for which force is to be deleted.  If ALL, NEND and NINC are
            ignored and forces are deleted on all selected nodes [NSEL].  If
            NODE = P, graphical picking is enabled and all remaining command
            fields are ignored (valid only in the GUI).  A component name may
            also be substituted for NODE.

        lab
            Valid force label.  If ALL, use all appropriate labels.  Structural
            labels:  FX, FY, or FZ (forces); MX, MY, or MZ (moments).  Thermal
            labels:  HEAT, HBOT, HE2, HE3, . . ., HTOP (heat flow).  Fluid
            labels:  FLOW (fluid flow).  Electric labels:  AMPS (current flow),
            CHRG (electric charge).  Magnetic labels:  FLUX (magnetic flux);
            CSGX, CSGY, or CSGZ (magnetic current segments).  Diffusion labels:
            RATE (diffusion flow rate).

        nend, ninc
            Delete forces from NODE to NEND (defaults to NODE) in steps of NINC
            (defaults to 1).

        lkey
            Lock key:

            (blank) - The DOF is not locked (default).

            FIXED - Displacement on the specified degrees of freedom (Lab) is locked. The program
                    prescribes the degree of freedom to the “current” relative
                    displacement value in addition to deleting the force. If a
                    displacement constraint (for example, D command) is applied
                    in conjunction with this option, the actual applied
                    displacement will be ramped during the next load step. The
                    displacement is ramped from the current value to the newly
                    defined value. This option is only valid for the following
                    labels: FX, FY, FZ, MX, MY, MZ. This option is intended
                    primarily for use in the ANSYS Workbench interface to apply
                    an increment length adjustment (bolt pretension loading).

        Notes
        -----
        The node and the degree of freedom label corresponding to the force
        must be selected [NSEL, DOFSEL].

        This command is also valid in PREP7.
        """
        command = "FDELE,%s,%s,%s,%s,%s" % (str(node), str(lab), str(nend), str(ninc), str(lkey))
        return self.run(command, **kwargs)

    def edri(self, option="", part="", xc="", yc="", zc="", tm="", ixx="",
             iyy="", izz="", ixy="", iyz="", ixz="", **kwargs):
        """APDL Command: EDRI

        Defines inertia properties for a new rigid body that is created when a
        deformable part is switched to rigid in an explicit dynamic analysis.

        Parameters
        ----------
        option
            Label identifying the option to be performed.

            ADD - Define inertia for specified part (default).

            DELE - Delete inertia definition for specified part.

            LIST - List inertia definitions.

        part
            Part number for which inertia is defined (no default).

        xc, yc, zc
            X, Y, and Z-coordinates of the center of mass (no defaults).

        tm
            Translational mass (no default).

        ixx, iyy, izz, ixy, iyz, ixz
            Components (xx, yy, etc.) of inertia tensor. IXX, IYY, and IZZ must
            be input (no defaults). IXY, IYZ, and IXZ default to zero.

        Notes
        -----
        Use this command to define inertia properties for a rigid body that is
        created when a deformable part is switched to rigid (using the EDRD,D2R
        command) in an explicit dynamic analysis. If these properties are not
        defined, LS-DYNA will compute the new rigid body properties from the
        finite element mesh (which requires an accurate mesh representation of
        the body). When rigid bodies are merged to a master rigid body, the
        inertia properties defined for the master rigid body apply to all
        members of the merged set.

        EDRI can only be issued in a new analysis. Therefore, if you are going
        to use inertia properties in a subsequent restart analysis, you must
        issue EDRI in the original analysis for the part that will later be
        switched to rigid in the restart.

        This command is also valid in PREP7.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDRI,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(option), str(part), str(xc), str(yc), str(zc), str(tm), str(ixx), str(iyy), str(izz), str(ixy), str(iyz), str(ixz))
        return self.run(command, **kwargs)

    def mfdtime(self, dtime="", dtmin="", dtmax="", carry="", **kwargs):
        """APDL Command: MFDTIME

        Sets time step sizes for an ANSYS Multi-field solver analysis.

        Parameters
        ----------
        dtime
            Multi-field time step size.  If automatic time stepping is being
            used [see Notes below], DTIME is the starting time step.

        dtmin
            Minimum time step. Defaults to DTIME.

        dtmax
            Maximum time step. Defaults to DTIME.

        carry
            Time step carryover key.

            OFF  - Use DTIME as the starting time step for the next restart run (default).

            ON  - Use the final time step from the previous run as the starting time step for the
                  next restart run.

        Notes
        -----
        This command specifies time step sizes for an ANSYS Multi-field solver
        analysis. If either DTMIN or DTMAX is not equal to DTIME, auto time-
        stepping is turned on for the multi-field loop. ANSYS will
        automatically adjust the time step size for the next multi-field step
        between DTMIN and DTMAX, based on the status of the current
        convergence, the number of target stagger iterations (specified by
        MFITER), and the actual number of iterations needed to reach
        convergence at the current time step.

        If auto time-stepping is turned off, the time step size must be evenly
        divisible into the end time (specified by MFTIME) minus the start time
        (0 for a new analysis or a restart time specified by MFRSTART).

        You can use a smaller time step within each ANSYS field analysis. This
        is called subcycling. Use the DELTIM and AUTOTS commands to subcycle a
        structural, thermal, or electromagnetic analysis.

        This command is also valid in PREP7.

        See Multi-field Commands in the Coupled-Field Analysis Guide for a list
        of all ANSYS Multi-field solver commands and their availability for MFS
        and MFX analyses.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "MFDTIME,%s,%s,%s,%s" % (str(dtime), str(dtmin), str(dtmax), str(carry))
        return self.run(command, **kwargs)

    def ocread(self, fname="", ext="", option="", **kwargs):
        """APDL Command: OCREAD

        Reads externally defined ocean data.

        Parameters
        ----------
        fname
            External ocean data file name (excluding the filename extension)
            and directory path containing the file. For more information, see
            the Notes section.

        ext
            Filename extension (limited to eight characters).

        --
            Reserved field.

        option
            Integer value passed to the userOceanRead subroutine (as iOption)
            for user-defined waves. This value does not apply to the diffracted
            wave type.

        Notes
        -----
        The OCREAD command imports ocean data that has been defined externally
        (for example, via the Hydrodynamic Diffraction System (AQWA)).

        The command operates on the ocean load ID specified via the most
        recently issued OCTYPE command. Issue a separate OCREAD command for
        each ocean load that you want to read into the program.

        Fname is limited to 248 characters, including the directory path. If
        Fname does not include a directory path, the program searches for the
        specified file in the current working directory. An unspecified Fname
        defaults to Jobname.

        For the diffracted wave type (KWAVE = 8 on the OCDATA command), you
        must issue an OCREAD command for the ocean wave ID in order to import
        the hydrodynamic data from the hydrodynamic analysis.

        For more information, see Applying Ocean Loading from a Hydrodynamic
        Analysis in the Advanced Analysis Guide.

        To learn more about creating user-defined waves, see Subroutine
        userPanelHydFor (Calculating Panel Loads Caused by Ocean Loading) in
        the Programmer's Reference.

        This command is also valid in PREP7.
        """
        command = "OCREAD,%s,%s,%s" % (str(fname), str(ext), str(option))
        return self.run(command, **kwargs)

    def anim(self, ncycl="", kcycl="", delay="", **kwargs):
        """APDL Command: ANIM

        Displays animated graphics data for linear problems.

        Parameters
        ----------
        ncycl
            Number of cycles associated with the animation (defaults to 5 in
            non-GUI mode only)

        kcycl
            Animation mode:

            0 - Continuous animation cycle (forward-reverse-forward-etc.) (default).

            1 - Discontinuous animation cycle (forward-reset-forward-etc.).

        delay
            Time delay (seconds) between animation frames (defaults to 0.1
            seconds).

        Notes
        -----
        Use the ANIM command to create animations for linear problems only. The
        command uses the currently displayed picture based on one particular
        data set from the results file, and linearly interpolates that data
        into different sets, displaying pictures of each interpolated data set
        in sequence to create animation.  For information about creating
        animations for nonlinear problems, see the ANDATA command.

        This command is device-dependent.

        Do not resize the graphic while animation is in progress; doing so can
        result in distorted plots.

        For more information, see the /SEG command for details about segment
        storage, and the ANCNTR macro for a convenient method of storing
        graphics frames in terminal memory segments.

        This command is valid in any processor.
        """
        command = "ANIM,%s,%s,%s" % (str(ncycl), str(kcycl), str(delay))
        return self.run(command, **kwargs)

    def lcsum(self, lab="", **kwargs):
        """APDL Command: LCSUM

        Specifies whether to process non-summable items in load case
        operations.

        Parameters
        ----------
        lab
            Combination option

            (blank) - Only combine summable items [default].

            ALL - Combine all items including non summable items.

        Notes
        -----
        Allows non-summable items (e.g. plastic strains) to be included in load
        combinations.  Issue LCSUM,ALL before the first load case operation
        (LCXX command).  May also be used to include nonsummable items in the
        appending of a results file (RAPPND command).
        """
        command = "LCSUM,%s" % (str(lab))
        return self.run(command, **kwargs)

    def bfalist(self, area="", lab="", **kwargs):
        """APDL Command: BFALIST

        Lists the body force loads on an area.

        Parameters
        ----------
        area
            Area at which body load is to be listed.  If ALL (or blank), list
            for all selected areas [ASEL].  If AREA = P, graphical picking is
            enabled and all remaining command fields are ignored (valid only in
            the GUI).  A component name may also be substituted for AREA.

        lab
            Valid body load label. If ALL, use all appropriate labels. Load
            labels are listed under "Body Loads" in the input table for each
            element type in the Element Reference. See the BFA command for
            labels.

        Notes
        -----
        Lists the body force loads for the specified area and label.  Body
        loads may be defined on an area with the BFA command.

        This command is valid in any processor.
        """
        command = "BFALIST,%s,%s" % (str(area), str(lab))
        return self.run(command, **kwargs)

    def etable(self, lab="", item="", comp="", option="", **kwargs):
        """APDL Command: ETABLE

        Fills a table of element values for further processing.

        Parameters
        ----------
        lab
            Any unique user defined label for use in subsequent commands and
            output headings (maximum of eight characters and not a General
            predefined Item label). Defaults to an eight character label formed
            by concatenating the first four characters of the Item and Comp
            labels. If the same as a previous user label, this result item will
            be included under the same label. Up to 200 different labels may be
            defined. The following labels are predefined and are not available
            for user-defined labels:  REFL, STAT, and ERAS.  Lab = REFL refills
            all tables previously defined with the ETABLE commands (not the
            CALC module commands) according to the latest ETABLE specifications
            and is convenient for refilling tables after the load step (SET)
            has been changed. Remaining fields will be ignored if Lab is REFL.
            Lab = STAT displays stored table values.  Lab = ERAS erases the
            entire table.

        item
            Label identifying the item. General item labels are shown in the
            table below. Some items also require a component label. Character
            parameters may be used. Item = ERAS erases a Lab column.

        comp
            Component of the item (if required). General component labels are
            shown in the table below. Character parameters may be used.

        option
            Option for storing element table data:

            MIN - Store minimum element nodal value of the specified item component.

            MAX - Store maximum element nodal value of the specified item component.

            AVG - Store averaged element centroid value of the specified item component
                  (default).

        Notes
        -----
        The ETABLE command defines a table of values per element (the element
        table) for use in further processing. The element table is organized
        similar to spreadsheet, with rows representing all selected elements
        and columns consisting of result items which have been moved into the
        table (Item,Comp) via ETABLE. Each column of data is identified by a
        user-defined label (Lab) for listings and displays.

        After entering the data into the element table, you are not limited to
        merely listing or displaying your data (PLESOL, PRESOL, etc.). You may
        also perform many types of operations on your data, such as adding or
        multiplying columns (SADD, SMULT), defining allowable stresses for
        safety calculations (SALLOW), or multiplying one column by another
        (SMULT).  See Getting Started in theBasic Analysis Guide for more
        information.

        Various results data can be stored in the element table. For example,
        many items for an element are inherently single-valued (one value per
        element). The single-valued items include: SERR, SDSG, TERR, TDSG,
        SENE, SEDN, TENE, KENE, AENE, JHEAT, JS, VOLU, and CENT. All other
        items are multivalued (varying over the element, such that there is a
        different value at each node). Because only one value is stored in the
        element table per element, an average value (based on the number of
        contributing nodes) is calculated for multivalued items. Exceptions to
        this averaging procedure are FMAG and all element force items, which
        represent the sum only of the contributing nodal values.

        Two methods of data access can be used with the ETABLE command. The
        method you select depends upon the type of data that you want to store.
        Some results can be accessed via a generic label (Component Name
        method), while others require a label and number (Sequence Number
        method).

        The Component Name method is used to access the General element data
        (that is, element data which is generally available to most element
        types or groups of element types). All of the single-valued items and
        some of the more general multivalued items are accessible with the
        Component Name method.  Various element results depend on the
        calculation method and the selected results location (AVPRIN, RSYS,
        LAYER, SHELL, and ESEL).

        Although nodal data is readily available for listings and displays
        (PRNSOL, PLNSOL) without using the element table, you may also use the
        Component Name method to enter these results into the element table for
        further "worksheet" manipulation. (See Getting Started in theBasic
        Analysis Guide for more information.) A listing of the General Item and
        Comp labels for the Component Name method is shown below.

        The Sequence Number method allows you to view results for data that is
        not averaged (such as pressures at nodes, temperatures at integration
        points, etc.), or data that is not easily described in a generic
        fashion (such as all derived data for structural line elements and
        contact elements, all derived data for thermal line elements, layer
        data for layered elements, etc.). A table illustrating the Items (such
        as LS, LEPEL, LEPTH, SMISC, NMISC, SURF, etc.) and corresponding
        sequence numbers for each element is shown in the Output Data section
        of each element description found in the Element Reference.

        Some element table data are reported in the results coordinate system.
        These include all component results (for example, UX, UY, etc.; SX, SY,
        etc.). The solution writes component results in the database and on the
        results file in the solution coordinate system. When you issue the
        ETABLE command, these results are then transformed into the results
        coordinate system (RSYS) before being stored in the element table. The
        default results coordinate system is global Cartesian (RSYS,0).  All
        other data are retrieved from the database and stored in the element
        table with no coordinate transformation.

        Use the PRETAB, PLETAB, or ETABLE,STAT commands to display the stored
        table values. Issue ETABLE,ERAS to erase the entire table. Issue
        ETABLE,Lab,ERAS to erase a Lab column.

        When the GUI is on, if a Delete operation in a Define Element Table
        Data dialog box writes this command to a log file (Jobname.LOG or
        Jobname.LGW), you will observe that Lab is blank, Item = ERASE, and
        Comp is an integer number. In this case, the GUI has assigned a value
        of Comp that corresponds to the location of a chosen variable name in
        the dialog box's list. It is not intended that you type in such a
        location value for Comp in a session.  However, a file that contains a
        GUI-generated ETABLE command of this form can be used for batch input
        or for use with the /INPUT command.

        The element table data option (Option) is not available for all output
        items. See the table below for supported items.

        Table: 135:: : ETABLE - General Item and Component Labels
        """
        command = "ETABLE,%s,%s,%s,%s" % (str(lab), str(item), str(comp), str(option))
        return self.run(command, **kwargs)

    def mult(self, m1="", t1="", m2="", t2="", m3="", **kwargs):
        """APDL Command: *MULT

        Performs the matrix multiplication M3 = M1(T1)*M2(T2).

        Parameters
        ----------
        m1
            Name of matrix M1. Must have been previously specified by a *DMAT
            or *SMAT command.

        t1
            Transpose key. Set T1 = TRANS to use the transpose of M1. If blank,
            transpose will not be used.

        m2
            Name of matrix M2. Must have been previously specified by a *DMAT
            command.

        t2
            Transpose key. Set T2 = TRANS to use the transpose of M2. If blank,
            transpose will not be used.

        m3
            Name of resulting matrix, M3. Must be specified.

        Notes
        -----
        The matrices must be dimensionally consistent such that the number of
        columns of M1 (or the transposed matrix, if requested) is equal to the
        number of rows of M2 (or the transposed matrix, if requested).

        You cannot multiply two sparse matrices with this command (that is, M1
        and M2 cannot both be sparse). The resulting matrix, M3, will always be
        a dense matrix, no matter what combination of input matrices is used
        (dense*sparse, sparse*dense, or dense*dense).
        """
        command = "*MULT,%s,%s,%s,%s,%s" % (str(m1), str(t1), str(m2), str(t2), str(m3))
        return self.run(command, **kwargs)

    def norl(self, line="", area="", ndir="", **kwargs):
        """APDL Command: NORL

        Rotates nodal coordinate systems perpendicular to line normal

        Parameters
        ----------
        line
            Line number containing the nodes to be rotated. If ALL, applies to
            all selected lines (see the LSEL command). If LINE = P, graphical
            picking is enabled.

        area
            The area number containing the selected lines. The normal of the
            line(s) selected is supposed to lie on this area. Defaults to the
            lowest numbered selected area containing the line number.

        ndir
            Direction of the normal. If NDIR = -1, the nodal coordinate system
            is rotated in the opposite direction of the line normal. The
            default is the same direction as the surface normal.

        Notes
        -----
        The NORL command rotates the X-axis of the nodal coordinate
        perpendicular to the line normal. The rotated nodal coordinate systems
        may be displayed through the /PSYMB command. In case multiple lines are
        selected, there could be conflicts at the boundaries. If a node belongs
        to two lines that have a different normal, its nodal coordinate system
        will be rotated to the line normal with the lowest number. Keep the
        following in mind when using the NORL command:

        If the nodal coordinate system is parallel to the global Cartesian
        system, it is not displayed through the /PSYMB command.

        Previously specified rotation on the selected nodes are overridden.
        """
        command = "NORL,%s,%s,%s" % (str(line), str(area), str(ndir))
        return self.run(command, **kwargs)

    def trplis(self, ntrp1="", ntrp2="", trpinc="", opt="", **kwargs):
        """APDL Command: TRPLIS

        Lists the particle flow or charged particle trace points.

        Parameters
        ----------
        ntrp1, ntrp2, trpinc
            List points from NTRP1 to NTRP2 (defaults to NTRP1) in steps of
            TRPINC (defaults to 1).  If NTRP1 = ALL, NTRP2 and TRPINC are
            ignored and all trace points are listed.  If NTRP1 = P, graphical
            picking is enabled and all remaining command fields are ignored
            (valid only in the GUI).

        opt
            Opt = LOC lists the trace point number location (X, Y, Z). Default.

        Notes
        -----
        Lists the particle flow or charged particle trace points in the active
        display coordinate system [DSYS].  Trace points are defined with the
        TRPOIN command.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "TRPLIS,%s,%s,%s,%s" % (str(ntrp1), str(ntrp2), str(trpinc), str(opt))
        return self.run(command, **kwargs)

    def mfem(self, fnumb="", itype1="", itype2="", itype3="", itype4="",
             itype5="", itype6="", itype7="", itype8="", itype9="", itype10="",
             **kwargs):
        """APDL Command: MFEM

        Add more element types to a previously defined field number.

        Parameters
        ----------
        fnumb
            Existing field number defined by the MFELEM command.

        itype1, itype2, itype3, . . . , itype10
            Element types defined by the ET command.

        Notes
        -----
        You can add up to ten element types per MFEM command. This command
        should not be used after an initial solution.

        This command is also valid in PREP7.

        See Multi-field Commands in the Coupled-Field Analysis Guide for a list
        of all ANSYS Multi-field solver commands and their availability for MFS
        and MFX analyses.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "MFEM,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(fnumb), str(itype1), str(itype2), str(itype3), str(itype4), str(itype5), str(itype6), str(itype7), str(itype8), str(itype9), str(itype10))
        return self.run(command, **kwargs)

    def ksel(self, type="", item="", comp="", vmin="", vmax="", vinc="",
             kabs="", **kwargs):
        """APDL Command: KSEL

        Selects a subset of keypoints or hard points.

        Parameters
        ----------
        type
            Label identifying the type of select:

            S - Select a new set (default).

            R - Reselect a set from the current set.

            A - Additionally select a set and extend the current set.

            U - Unselect a set from the current set.

            ALL - Restore the full set.

            NONE - Unselect the full set.

            INVE - Invert the current set (selected becomes unselected and vice versa).

            STAT - Display the current select status.

        Notes
        -----
        Selects a subset of keypoints or hard points.  For example, to select a
        new set of keypoints based on keypoint numbers 1 through 7, use
        KSEL,S,KP,,1,7.  The selected subset is used when the ALL label is
        entered (or implied) on other commands, such as KLIST,ALL.  Only data
        identified by keypoint number are selected.  Data are flagged as
        selected and unselected; no data are actually deleted from the
        database.

        This command is valid in any processor.

        For selections based on non-integer numbers (coordinates, results,
        etc.), items that are within the range VMIN -Toler and VMAX + Toler are
        selected. The default tolerance Toler is based on the relative values
        of VMIN and VMAX as follows:

        If VMIN = VMAX, Toler = 0.005 x VMIN.

        If VMIN = VMAX = 0.0, Toler = 1.0E-6.

         If VMAX ≠ VMIN, Toler = 1.0E-8 x (VMAX - VMIN).

        Use the SELTOL command to override this default and specify Toler
        explicitly.

        Table: 203:: : KSEL - Valid Item and Component Labels
        """
        command = "KSEL,%s,%s,%s,%s,%s,%s,%s" % (str(type), str(item), str(comp), str(vmin), str(vmax), str(vinc), str(kabs))
        return self.run(command, **kwargs)

    def modseloption(self, dir1="", dir2="", dir3="", dir4="", dir5="", dir6
                     ="", **kwargs):
        """APDL Command: MODSELOPTION

        Specifies the criteria for selecting the modes to be expanded.

        Parameters
        ----------
        dir1, dir2, …, dir6
            Selection of the direction to be expanded.

        Notes
        -----
        This command is only applicable when a mode selection method is defined
        (ModeSelMethod on the MXPAND command). See Using Mode Selection in the
        Mechanical APDL Structural Analysis Guide for more details.

        If a numerical value is specified for a direction, the significance
        threshold (SIGNIF on the MXPAND command) is ignored for the selection
        of the modes in this direction.

        If a mode is determined to be expanded in any of the 6 directions, it
        will be expanded in the .MODE file. : Otherwise, the mode will not be
        expanded.

        The default behavior is to consider all directions for expansion.
        """
        command = "MODSELOPTION,%s,%s,%s,%s,%s,%s" % (str(dir1), str(dir2), str(dir3), str(dir4), str(dir5), str(dir6 ))
        return self.run(command, **kwargs)

    def block(self, x1="", x2="", y1="", y2="", z1="", z2="", **kwargs):
        """APDL Command: BLOCK

        Creates a block volume based on working plane coordinates.

        Parameters
        ----------
        x1, x2
            Working plane X coordinates of the block.

        y1, y2
            Working plane Y coordinates of the block.

        z1, z2
            Working plane Z coordinates of the block.

        Notes
        -----
        Defines a hexahedral volume based on the working plane.  The block must
        have a spatial volume greater than zero (i.e., this volume primitive
        command cannot be used to create a degenerate volume as a means of
        creating an area.)  The volume will be defined with eight keypoints,
        twelve lines, and six areas, with the top and bottom faces parallel to
        the working plane.  See the BLC4 and BLC5 commands for alternate ways
        to create blocks.
        """
        command = "BLOCK,%s,%s,%s,%s,%s,%s" % (str(x1), str(x2), str(y1), str(y2), str(z1), str(z2))
        return self.run(command, **kwargs)

    def device(self, label="", key="", **kwargs):
        """APDL Command: /DEVICE

        Controls graphics device options.

        Parameters
        ----------
        label
            Device function label:

            BBOX - Bounding box mode. For PowerGraphics plots involving elements with /SHOW,x11
                   and /SHOW,win32, ANSYS generally displays dynamic rotations
                   faster. If KEY = 1 (ON), then a bounding box (not the
                   elements) encompassing the model is displayed and rotated,
                   rather than the element outlines (ON is default in
                   preprocessing). When KEY = 0 (OFF), then dynamic rotations
                   may be slower (ANSYS redraws the element outlines) for plots
                   involving elements with /SHOW,x11 and /SHOW,win32.  OFF is
                   default in postprocessing. This command is ignored if
                   /EDGE,WN,1 is set for any WN. This is ignored in POST1 and
                   SOLUTION plots.

            For any PowerGraphics plots involving elements, regardless of /SHOW settings, plots will generally be displayed faster. - VECTOR

            Vector mode. In vector mode, areas, volumes, elements, and postprocessing display geometries are shown as outlines (wireframes).  When vector mode is off (default), these entities are shown filled with color. - DITHER

            When dithering is turned on (default), color intensity transitions are smoothed.  This selection a - applies only to smooth-shaded images, i.e., Z-buffered [/TYPE], or raster plots
                              with Gouraud or Phong shading [/SHADE].

            ANIM - Select the animation type used on 2-D devices on the PC platform. A KEY value
                   of BMP (or 0) sets animation mode to ANSYS Animation
                   Controller (default). A KEY value of AVI (or 2) sets
                   animation mode to AVI movie player file.

            FONT - Font selection for the ANSYS graphics window. When Label = FONT, the command
                   format is: /DEVICE,FONT,KEY,Val1,Val2,Val3,Val4,Val5,Val6
                   where KEY determines the type of font being controlled, and
                   values 1 through 6 control various font parameters. Note
                   that these values are device specific; using the same
                   command input file [/INPUT] on different machines may yield
                   different results.. The following KEY values determine the
                   font information that will be supplied to the appropriate
                   driver (e.g., Postscript, X11, Win32, JPEG, ...):

            KEY = 1 - The command controls the LEGEND (documentation column) font.

            KEY = 2 - The command controls the ENTITY (node and keypoint number) font.

            KEY = 3 - The command controls the ANNOTATION/GRAPH font.

            Linux: Values 1 through 4 are used to find a match in the X11 database of font strings. Values 1, 2, and 3 are character strings; value 4 is a nonzero integer:    - Val1

            Family name (e.g., Courier). If Val1 = MENU, all other values are ignored and a font selection menu appears (GUI must be active). - Val2

            Weight (e.g., medium) - Val3

            Slant (e.g., r) - Val4

            Pixel size (e.g., 14). Note that this value does no affect the annotation fonts (KEY = 3). Use the /TSPEC command for annotation font size.  - Val5

            unused - Val6

            unused - PC: The values are encoded in a PC logical font
                     structure.  Value 1 is a character string, and
                     the remaining values are integers:

            Val1 - Family name (e.g., Courier*New) Substitute an asterisk (*) for any blank
                   character that appears in a family name. If Val1 = MENU, all
                   other values are ignored and a font selection menu appears
                   (GUI must be active). When this value is blank ANSYS uses
                   the first available resource it finds.

            Val2 - Weight (0 - 1000)

            Val3 - Orientation (in tenths of a degree)

            Val4 - Height (in logical units)

            Val5 - Width (in logical units)

            Val6 - Italics (0 = OFF, 1 = ON)

            TEXT - Text size specification for the ANSYS Graphics window.  Using this label with
                   the /DEVICE command requires the following form:
                   /DEVICE,TEXT,KEY,PERCENT.  KEY = 1 for LEGEND fonts; KEY = 2
                   for ENTITY fonts.  PERCENT specifies the new text size as a
                   percent of the default text size.  If PERCENT = 100, the new
                   text size is precisely the default size.  If PERCENT = 200,
                   the new text size is twice the default text size.

        key
            Control key:

            OFF or 0 - Turns specified function off.

            ON or 1 - Turns specified function on or designates the LEGEND font.

            2 - Designates the ENTITY font.

            3 - Designates the ANNOTATION/GRAPH font.

        Notes
        -----
        This command is valid in any processor.

        The /DEVICE,BBOX command is ignored in POST1 and SOLUTION plots. Also,
        the elements are displayed and rotated if you use /DEVICE,BBOX,ON and
        /EDGE,WN,1,ANGLE (effectively ignoring the BBOX option).
        """
        command = "/DEVICE,%s,%s" % (str(label), str(key))
        return self.run(command, **kwargs)

    def intsrf(self, lab="", **kwargs):
        """APDL Command: INTSRF

        Integrates nodal results on an exterior surface.

        Parameters
        ----------
        lab
            Label indicating degree of freedom to be integrated:

            PRES - Pressure.

            TAUW - Wall shear stress.

            FLOW - Both pressure and wall shear stress.

        Notes
        -----
        Integrates nodal results on a surface.  Use node selection (such as the
        EXT option of the NSEL command) to indicate the surface(s) of element
        faces to be used in the integration.  A surface can be "created" by
        unselecting elements (such as unselecting non-fluid elements that are
        adjacent to fluid elements for the postprocessing of fluid flow
        result).  Element faces attached to the selected nodes will be
        automatically determined.  All nodes on a face must be selected for the
        face to be used.  The integration results will cancel for nodes on
        common faces of adjacent selected elements.

        Integration results are in the active coordinate system (see the RSYS
        command). The type of results coordinate system must match the type
        used in the analysis. However, you may translate and rotate forces and
        moments as needed. Use the *GET command (Utility Menu> Parameters> Get
        Scalar Data) to retrieve the results.
        """
        command = "INTSRF,%s" % (str(lab))
        return self.run(command, **kwargs)

    def mshkey(self, key="", **kwargs):
        """APDL Command: MSHKEY

        Specifies whether free meshing or mapped meshing should be used to mesh
        a model.

        Parameters
        ----------
        key
            Key indicating the type of meshing to be used:

            0 - Use free meshing (the default).

            1 - Use mapped meshing.

            2 - Use mapped meshing if possible; otherwise, use free meshing.  If you specify
                MSHKEY,2, SmartSizing will be inactive even while free meshing
                non-map-meshable areas.

        Notes
        -----
        The MSHKEY, MSHAPE, and MSHMID commands replace the functionality that
        was provided by the ESHAPE command in ANSYS 5.3 and earlier releases.

        This command is also valid for rezoning.
        """
        command = "MSHKEY,%s" % (str(key))
        return self.run(command, **kwargs)

    def edint(self, shellip="", beamip="", **kwargs):
        """APDL Command: EDINT

        Specifies number of integration points for explicit shell and beam
        output.

        Parameters
        ----------
        shellip
            Number of shell integration points used for output (defaults to 3).
            For element SHELL163, each integration point is associated with a
            layer. SHELLIP must be  3. If SHELLIP = 3, results are written for
            the shell top, middle, and bottom. If SHELLIP >3, then the results
            for the first SHELLIP layers are written.

        beamip
            Number of beam integration points used for stress output for
            BEAM161 (defaults to 4).

        Notes
        -----
        The number of integration points is defined by the element real
        constant NIP for both the beam elements (in the cross section) and the
        shell elements (through the thickness).

        For shell elements that have only 1 or 2 integration points (NIP = 1 or
        2), use the default of SHELLIP = 3. If NIP = 1, the same results are
        reported at the top, middle, and bottom layers.  If the NIP = 2, the
        results at the bottom correspond to integration point 1, the results at
        the top correspond to integration point 2, and the results at the
        middle are an average of the top and bottom results.

        For shell elements with 2 x 2 integration points in the plane, the data
        from the four points are averaged, and there is a single output value
        for each layer.

        If you set BEAMIP = 0, no stress output is written for BEAM161
        elements. In this case, the beams will not appear in any POST1 plots
        because the program assumes they are failed elements.

        This command is also valid in PREP7.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDINT,%s,%s" % (str(shellip), str(beamip))
        return self.run(command, **kwargs)

    def rsfit(self, rslab="", slab="", name="", rmod="", ytrans="", yval="",
              xfilt="", conf="", **kwargs):
        """APDL Command: RSFIT

        Fit a response surface for an output parameter in a solution set.

        Parameters
        ----------
        rslab
            Response surface set label. Identifies the response surface results
            for later postprocessing. This label can be used as Rlab for
            postprocessing response surface results, and for evaluating the fit
            results with RSPLOT and RSPRNT. You must have separate
            identification labels for the solution sets and for the response
            surface sets, because you can perform a response surface fit based
            on Monte Carlo results. For this case, the original Monte Carlo
            results are identified by the solution set label provided in the
            PDEXE command and the results generated with the fitted response
            surfaces are identified by the response surface set label (RSlab)
            provided here. RSlab must not contain blanks. Maximum length of
            this field is 16 characters; if this field contains more than 16
            characters, it will be truncated to 16 characters.

        slab
            Solution set label that identifies the probabilistic analysis
            containing the results to be fitted. This solution set label is
            defined with the PDEXE command.

        name
            Parameter name. The parameter must have been previously defined as
            a random output parameter with the PDVAR command. The result values
            of this parameter (stored in the solution set identified by Slab)
            are fitted as a function of all random input variables.

        rmod
            Regression model to use for the evaluation of the response surface.

            LIN - Regression model with linear terms only.

            QUAD - Regression model with linear and pure quadratic terms (no cross-terms).

            QUAX - Regression model with linear and all quadratic terms (including cross-terms).
                   (Default.)

        ytrans
            Option for the transformation type applied to the output parameter
            identified with Name.

            NONE - The values of the output parameter Name are not transformed (default).

            EXP - The values of the output parameter Name are transformed according to Y* =
                  exp(Y). The transformed values Y* are used for the fitting
                  process.

            LOGA - The values of the output parameter Name are transformed according to Y* =
                   loga(Y), where the basis a is specified by Yval. The
                   transformed values Y* are used for the fitting process.

        yval
            Value needed for Ytrans = LOGA, Ytrans = POW, and Ytrans = BOX.
            Ignored for all other options of Ytrans. For Ytrans = LOGA and
            Ytrans = POW, the default value is Yval = 1.0. For Ytrans = BOX,
            the default value is Yval = 0.01.

        xfilt
            Option that specifies if irrelevant terms of the regression model
            should be filtered out.

            NONE - Regression term filtering is not done. A full regression model as specified
                   with the Rmod option is evaluated.

            FSR - Use the "forward-stepwise-regression" to automatically filter out individual
                  and irrelevant terms of the regression model. If irrelevant
                  terms are sorted out this leads to a smaller number of
                  coefficients to be determined in the regression analysis,
                  which then leads to increased accuracy of the coefficients of
                  the remaining terms in the regression model (default).

        conf
            Confidence level that is used to filter the terms of the regression
            model if the Xfilt = FSR option has been selected. The value of
            CONF must be between 0.0 and 1.0 (default is 0.95). The higher this
            value, the more terms will be filtered out. Consequently, higher
            CONF values lead to a fewer terms in the regression model.
            Likewise, lower CONF values lead to more terms being included in
            the regression model.

        Notes
        -----
        Evaluates a response surface for a random output parameter Name. The
        result values for the parameter Name as stored in the solution set Slab
        are fitted as a function of all random input parameters. There can be
        only one response surface set for each solution set. A response surface
        set can include the fitted response surfaces of one or more output
        parameters.

        Note:: : If the RSFIT command is used for an existing response surface
        set for which Monte Carlo simulations have already been generated using
        the RSSIMS command then these Monte Carlo samples are deleted by the
        RSFIT command. In this case they need to be generated again using the
        RSSIMS command. It is necessary to delete the Monte Carlo simulations
        in order to make sure that the samples, their statistics and
        correlations are consistent with the response surfaces.
        """
        command = "RSFIT,%s,%s,%s,%s,%s,%s,%s,%s" % (str(rslab), str(slab), str(name), str(rmod), str(ytrans), str(yval), str(xfilt), str(conf))
        return self.run(command, **kwargs)

    def pdlhs(self, nsim="", nrep="", isopt="", unused="", astop="", accmean="",
              accstdv="", check="", seed="", **kwargs):
        """APDL Command: PDLHS

        Specifies options for Monte Carlo Simulations using Latin-Hypercube
        sampling.

        Parameters
        ----------
        nsim
            Number of simulation loops per repetition cycle.

        nrep
            Number of repetition cycles of the analysis.

        isopt
            Latin-Hypercube sampling divides the domain of each random input
            variable into intervals of equal probability. The interval sampling
            option ISopt determines where the samples are located within each
            interval.

            RAND - Picks a random location within the interval (default).

            MEAN - Picks the mean value location within the interval.

            MEDI - Picks the median value location within the interval.

        --
            Unused field.

        astop
            Autostop option label.

            AUTO - Enable Autostop. When Autostop is used, the PDS feature continues the
                   simulation loops until the convergence criteria for the mean
                   value and the standard deviation have been met or until the
                   number of simulations NSIM are complete, whichever comes
                   first. The convergence criteria (mean value and standard
                   deviations of all random output parameters) are specified by
                   the ACCMEAN and ACCSTDEV parameters. The criteria are met if
                   the mean value and the standard deviations converge within
                   the accuracy specified in the ACCMEAN and ACCSTDEV options.
                   The convergence check is done every i-th loop, where i is
                   specified in the CHECK parameter.

            ALL - Disable Autostop option. All Monte Carlo Simulations as specified by NSIM and
                  NREP are performed (default).

        accmean
            Accuracy of the mean values of all random output parameters that
            must be met to activate Autostop. Default is 0.01 (1%). ACCMEAN is
            ignored for Astop = ALL. The convergence for the mean values is met
            if for all random output parameters y the following equation is
            true:

        accstdev
            Accuracy of the standard deviations of all random output parameters
            that must be met to activate Autostop. The default is 0.02 (2%).
            ACCSTDEV is ignored for Astop = ALL. The convergence for the
            standard deviations is met if for all random output parameters y
            the following equation is true:

        check
            Sets how often conditions for convergence are checked for Autostop.
            The PDS feature checks if the convergence criteria are met every
            i-th loop, where i is given by the CHECK parameter. The default
            value is 10. It not recommended to use CHECK = 1, because it could
            cause Autostop to terminate the simulations prematurely. The mean
            values and standard deviation might not show large differences
            between all simulation loops but might still have a visible
            "global" trend if viewed over several simulations. This behavior
            indicates that convergence has not really been achieved. If you set
            CHECK = 1, then Autostop is not able to detect such a global trend.
            CHECK is ignored for Astop = ALL.

        seed
            Seed value label. Random number generators require a seed value
            that is used to calculate the next random number. After each random
            number generation finishes, the seed value is updated and is used
            again to calculate the next random number. ANSYS initializes the
            seed value with the system time when the ANSYS session started.

            CONT - Continues updating using the derived seed value (default).

            TIME - Initializes the seed value with the system time. You can use this if you want
                   the seed value set to a specific value for one analysis and
                   then you want to continue with a "random" seed in the next
                   analysis. It is not recommended to "randomize" the seed
                   value with the Seed = TIME option for multiple analyses. If
                   the Monte Carlo simulations requested with this command will
                   be appended to previously existing simulations, then the
                   Seed option is ignored and Seed = CONT is used.

            INIT - Initializes the seed value using 123457 (a typical recommendation). This option
                   leads to identical random numbers for all random input
                   variables when the exact analysis will be repeated, making
                   it useful for benchmarking and validation purposes (where
                   identical random numbers are desired). If the Monte Carlo
                   simulations requested with this command will be appended to
                   previously existing simulations, then the Seed option is
                   ignored and Seed = CONT is used.

            Value - Uses the specified (positive) value for the initialization of the seed value.
                    This option has the same effect as Seed = INIT, except you
                    can chose an arbitrary (positive) number for the
                    initialization. If the Monte Carlo simulations requested
                    with this command will be appended to previously existing
                    simulations, then the Seed option is ignored and Seed =
                    CONT is used.

        Notes
        -----
        Defines the number of simulations per repetition cycle, number of
        repetition cycles, specification of the Autostop option, checking
        frequency for the Autostop option, and the seed value for random number
        generation.

        For Latin-Hypercube sampling, it is advantageous to divide the total
        number of requested simulations into a few repetitions. This adds more
        randomness to the sampling process. If NTOT is the total number of
        simulations, then as a rough rule of thumb NTOT should be NREP =
        repetitions. The number obtained with this rule of thumb must be
        adjusted such that NTOT = NREP*NSIM. For example if NTOT = 1000 then
        NREP =  = 10, so the 1000 simulations can be done in 100 simulations
        with 10 repetitions. If for example NTOT = 100 then NREP =  = 3.16,
        which means that the 100 simulations could be broken up into either
        2*50 or 4*25 simulations.

        If Autostop is enabled then the maximum number of simulations to be
        performed is given by NSIM*NREP. The Autostop option will terminate the
        simulations before the NSIM*NREP simulations are done if the
        convergence criteria are met.
        """
        command = "PDLHS,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(nsim),
                                                        str(nrep),
                                                        str(isopt),
                                                        str(unused),
                                                        str(astop),
                                                        str(accmean),
                                                        str(accstdv),
                                                        str(check),
                                                        str(seed))
        return self.run(command, **kwargs)

    def plvar(self, nvar1="", nvar2="", nvar3="", nvar4="", nvar5="", nvar6="",
              nvar7="", nvar8="", nvar9="", nvar10="", **kwargs):
        """APDL Command: PLVAR

        Displays up to ten variables in the form of a graph.

        Parameters
        ----------
        nvar1, nvar2, nvar3, . . . , nvar10
            Variables to be displayed, defined either by the reference number
            or a unique thirty-two character name. If duplicate names are used
            the command will plot the data for the lowest-numbered variable
            with that name.

        Notes
        -----
        Variables are displayed vs. variable N on the XVAR command. The string
        value will be a predefined, unique name. For complex variables, the
        amplitude is displayed by default [PLCPLX].  Each PLVAR command
        produces a new frame.  See the /GRTYP command for displaying multiple
        variables in a single frame with separate Y-axes.
        """
        command = "PLVAR,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(nvar1), str(nvar2), str(nvar3), str(nvar4), str(nvar5), str(nvar6), str(nvar7), str(nvar8), str(nvar9), str(nvar10))
        return self.run(command, **kwargs)

    def dsurf(self, kcn="", xsurf="", ysurf="", zsurf="", **kwargs):
        """APDL Command: DSURF

        Defines the surface upon which digitized nodes lie.

        Parameters
        ----------
        kcn
            Surface is located in coordinate system KCN.  KCN may be 0,1,2 or
            any previously defined local coordinate system number.

        xsurf, ysurf, zsurf
            Input one value to define the surface constant.  Input 999 in the
            other two fields.  Interpret fields as R, θ, Z for cylindrical or
            R, θ, Φ for spherical or toroidal coordinate systems.  XSURF and
            YSURF default to 999 if KCN = 0.

        Notes
        -----
        Defines the surface upon which the nodes to be digitized (with the DIG
        command) actually lie.  Surfaces are defined by a coordinate system
        number and a coordinate constant [MOVE].  Two coordinates are
        determined from the drawing and converted to surface coordinates.  The
        third coordinate is defined from the input surface constant.  If nodes
        lie on warped or undefined surfaces, use the DMOVE command.
        """
        command = "DSURF,%s,%s,%s,%s" % (str(kcn), str(xsurf), str(ysurf), str(zsurf))
        return self.run(command, **kwargs)

    def tbpt(self, oper="", x1="", x2="", x3="", xn="", **kwargs):
        """APDL Command: TBPT

        Defines a point on a nonlinear data curve.

        Parameters
        ----------
        oper
            Operation to perform:

            DEFI - Defines a new data point (default).  The point is inserted into the table in
                   ascending order of X1.  If a point already exists with the
                   same X1 value, it is replaced.

            DELE - Deletes an existing point.  The X1 value must match the X1 value of the point
                   to be deleted (XN is ignored).

        x1, x2, ..., xn
            The N components of the point. N depends on the type of data table.
            Except for TB,EXPE all other TB Tables support only 2 components.

        Notes
        -----
        TBPT defines a point on a nonlinear data curve (such as a stress-strain
        curve, B-H curve, etc.) at the temperature specified on the last TBTEMP
        command. The meaning of the values depends on the type of data table
        specified on the last TB command (MISO, BH, etc.).

        This command is also valid in SOLUTION.
        """
        command = "TBPT,%s,%s,%s,%s,%s" % (str(oper), str(x1), str(x2), str(x3), str(xn))
        return self.run(command, **kwargs)

    def cmsel(self, type="", name="", entity="", **kwargs):
        """APDL Command: CMSEL

        Selects a subset of components and assemblies.

        Parameters
        ----------
        type
            Label identifying the type of select:

            S - Select a new set (default).

            R - Reselect a set from the current set.

            A - Additionally select a set and extend the current set.

            U - Unselect a set from the current set.

            ALL - Also select all components.

            NONE - Unselect all components.

        name
            Name of component or assembly whose items are to be selected (valid
            only if Type = S, R, A, or U).

        entity
            If Name is blank, then the following entity types can be specified:

            VOLU - Select the volume components only.

            AREA - Select the area components only.

            LINE - Select the line components only.

            KP - Select the keypoint components only.

            ELEM - Select the element components only.

            NODE - Select the node components only.

        Notes
        -----
        Selecting by component is a convenient adjunct to individual item
        selection (e.g., VSEL, ESEL, etc.). CMSEL, ALL allows you to select
        components in addition to other items you have already selected.

        If Type = R for an assembly selection [CMSEL,R,<assembly-name>], the
        reselect operation is performed on each component in the assembly in
        the order in which the components make up the assembly.  Thus, if one
        reselect operation results in an empty set, subsequent operations will
        also result in empty sets.  For example, if the first reselect
        operation tries to reselect node 1 from the selected set of nodes 3, 4,
        and 5, the operation results in an empty set (that is, no nodes are
        selected).  Since the current set is now an empty set, if the second
        reselect operation tries to reselect any nodes, the second operation
        also results in an empty set, and so on.  This is equivalent to
        repeating the command CMSEL,R,<component-name> once for each component
        making up the assembly.

        This command is valid in any processor.
        """
        command = "CMSEL,%s,%s,%s" % (str(type), str(name), str(entity))
        return self.run(command, **kwargs)

    def pvect(self, oper="", labxr="", labyr="", labzr="", **kwargs):
        """APDL Command: PVECT

        Interpolates a set of items onto a path.

        Parameters
        ----------
        oper
            Valid operations for geometry operations along a path are:

            NORM - Defines a unit normal vector at each interpolation point in the direction of
                   the cross product of the tangent to the path and the active
                   Z axis.  Resulting vector components are in the active
                   coordinate system (which must be Cartesian).

            TANG - Defines a unit vector tangent to the path at each interpolation point.  Vector
                   components are in the active coordinate system (which must
                   be Cartesian).

            RADI - Defines the position vector of each interpolation point of the path from the
                   center of the active coordinate system (which must be
                   Cartesian).

        labxr
            Label (8 characters maximum) assigned to X-component of the
            resulting vector.

        labyr
            Label (8 characters maximum) assigned to Y-component of the
            resulting vector.

        labzr
            Label (8 characters maximum) assigned to Z-component of the
            resulting vector.

        Notes
        -----
        Defines and interpolates a set of labeled path items along predefined
        path [PATH] and performs various geometric operations on these path
        items.  A path item must be defined before it can be used with other
        path operations.  Additional path items may be defined with the PDEF,
        PCALC, PDOT, and PCROSS commands.  Path items may be listed or
        displayed with the PLPATH, PLPAGM and PRPATH commands.  Path geometry
        items (XG, YG, ZG, S) are automatically interpolated (in the active
        CSYS) if not done so previously with the PDEF command.
        """
        command = "PVECT,%s,%s,%s,%s" % (str(oper), str(labxr), str(labyr), str(labzr))
        return self.run(command, **kwargs)

    def clrmshln(self, **kwargs):
        """APDL Command: CLRMSHLN

        Clears meshed entities.

        Notes
        -----
        When you use the GUI method to set the number of elements on specified
        lines, and any of those lines is connected to one or more meshed lines,
        areas, or volumes, ANSYS gives you the option to clear the meshed
        entities.  (This occurs only when you perform this operation via the
        GUI; ANSYS does not provide such an option when you use the command
        method [LESIZE].)

        If you activate the mesh clearing option, the program invokes an ANSYS
        macro, CLRMSHLN, that clears the meshed entities.  This macro name will
        appear in the log file (Jobname.LOG).  This macro is for the ANSYS
        program's internal use only.  This command is not intended to be typed
        in directly in an ANSYS session, although it can be included in an
        input file for batch input or for use with the /INPUT command.
        """
        command = "CLRMSHLN," % ()
        return self.run(command, **kwargs)

    def ppath(self, point="", node="", x="", y="", z="", cs="", **kwargs):
        """APDL Command: PPATH

        Defines a path by picking or defining nodes, or locations on the
        currently active working plane, or by entering specific coordinate
        locations.

        Parameters
        ----------
        point
            The point number.  It must be greater than zero and less than or
            equal to the nPts value specified on the PATH command if graphical
            picking is not being used.

        node
            The node number defining this point.  If blank, use the X, Y, Z
            coordinates to define the point.  A valid node number will override
            X, Y, Z coordinate arguments.

        x, y, z
            The location of the point in the global Cartesian coordinate
            system.  Use these arguments only if you omit the NODE argument.

        cs
            The coordinate system for interpolation of the path between the
            previous point and this point.  Omit this argument if you wish to
            use the currently active (CSYS) coordinate system.  If the
            coordinate system of two adjacent points is different, the CS value
            of the latter point will be used.

        Notes
        -----
        For linearized stress calculations, the path must be defined with
        nodes.

        This command is designed and works best in interactive (GUI) mode,
        using the menu paths listed below. For command line operations, issue
        PPATH,P to define your path by picking nodes.

        For information on displaying paths you have defined, see Defining Data
        to be Retrieved in the Basic Analysis Guide.
        """
        command = "PPATH,%s,%s,%s,%s,%s,%s" % (str(point), str(node), str(x), str(y), str(z), str(cs))
        return self.run(command, **kwargs)

    def fclist(self, mat="", unused="", temp="", **kwargs):
        """APDL Command: FCLIST

        To list what the failure criteria is that you have input.

        Parameters
        ----------
        mat
             Material number (defaults to ALL for all materials).

        --
            Unused field.

        temp
            Temperature to be evaluated at (defaults to TUNIF).

        Notes
        -----
        This command allows you to see what you have already input for failure
        criteria using the FC commands.
        """
        command = "FCLIST,%s,%s,%s" % (str(mat), str(unused), str(temp))
        return self.run(command, **kwargs)

    def d(self, node="", lab="", value="", value2="", nend="", ninc="",
          lab2="", lab3="", lab4="", lab5="", lab6="", **kwargs):
        """APDL Command: D

        Defines degree-of-freedom constraints at nodes.

        Parameters
        ----------
        node
            Node at which constraint is to be specified. If ALL, NEND and NINC
            are ignored and constraints are applied to all selected nodes
            (NSEL). If Node = P, graphical picking is enabled and all remaining
            command fields are ignored (valid only in the GUI).  A component
            name may also be substituted for Node.

        lab
            Valid degree-of-freedom label.  If ALL, use all appropriate labels.

        value
            Degree-of-freedom value or table name reference for tabular
            boundary conditions.  To specify a table, enclose the table name in
            percent (%) signs (for example, D,Node,TEMP,%tabname%). Use the
            *DIM command to define a table.

        value2
            Second degree-of-freedom value (if any).  If the analysis type and
            the degree of freedom allow a complex input, Value (above) is the
            real component and VALUE2 is the imaginary component.

        nend, ninc
            Specifies the same values of constraint at the range of nodes from
            Node to NEND (defaults to Node), in steps of NINC (defaults to 1).

        lab2, lab3, lab4, lab5, lab6
            Additional degree-of-freedom labels. The same values are applied to
            the nodes for these labels.

        Notes
        -----
        The available degrees of freedom per node are listed under "Degrees of
        Freedom" in the input table for each element type in the Element
        Reference.  Degrees of freedom are defined in the nodal coordinate
        system.  The positive directions of structural translations and
        rotations are along and about the positive nodal axes directions.
        Structural rotations should be input in radians.  The node and the
        degree-of-freedom label must be selected (NSEL, DOFSEL).

        In a structural analysis, you can apply only one displacement,
        velocity, or acceleration load at any degree of freedom. If multiple
        loads are specified, the last applied load overrides the previous ones.
        For example, the following commands apply loads to node 100:

        In this case, the velocity load (VELX) applied in the last command will
        override the displacement load (UX).

        For elements used in static and low frequency electromagnetic analysis
        (SOLID236 and SOLID237), the AZ degree of freedom is not a z-component
        of a vector potential, but rather the flux contribution on the element
        edge.  To specify a flux-parallel condition, set AZ = 0.  For more
        information, see 3-D Magnetostatics and Fundamentals of Edge-based
        Analysis in the Low-Frequency Electromagnetic Analysis Guide.

        In an explicit dynamic analysis, the D command can only be used to fix
        nodes in the model. The degree-of-freedom value must be zero; no other
        values are valid. Use the EDLOAD command to apply a nonzero
        displacement in an explicit dynamic analysis.

        For ELBOW290 cross-section degrees of freedom (Lab = SE, SO, SW, SRA,
        SRT, or SECT), the D command can only specify fixed constraints. The
        degree-of-freedom value must be zero; no other values are valid.

        For hydrostatic fluid elements (HSFLD241 and HSFLD242), the HDSP
        degree-of-freedom constraint at the pressure node prescribes the
        pressure value for all the fluid elements sharing the pressure node.

        Tabular boundary conditions (VALUE = %tabname%) are available only for
        the following degree-of-freedom labels: Electric (VOLT), structural
        (UX, UY, UZ, ROTX, ROTY, ROTZ, and velocity and acceleration loads
        VELX, VELY, VELZ, OMGX, OMGY, OMGZ, ACCX, ACCY, ACCZ, DMGX, DMGY,
        DMGZ), acoustic (PRES, UX, UY, UZ,), and temperature (TEMP, TBOT, TE2,
        TE3, . . ., TTOP). All labels are valid only in static (ANTYPE,STATIC)
        and full transient (ANTYPE,TRANS) analyses.

        %_FIX% is an ANSYS reserved table name. When VALUE is set to %_FIX%,
        ANSYS will prescribe the degree of freedom to the “current” relative
        displacement value. This option is only valid for the following labels:
        UX, UY, UZ, ROTX, ROTY, ROTZ. Alternatively, functions UX(), UY(), etc.
        may be used (see *GET for a complete list of available functions). In
        most cases, %_FIX% usage is efficient and recommended for all
        structural degrees of freedom.

        When Value = SUPPORT, specify only the minimum number of displacement
        constraints necessary to prevent rigid body motion: three constraints
        (or fewer, depending on the element type) for 2-D models and six (or
        fewer) for 3-D models.

        If constraints and initial conditions (IC) are applied at the same
        node, the constraint specification overrides. This combination is
        useful when a constraint degree-of-freedom value needs to start with a
        nonzero value at time = 0.0. For example, if the constraint degree-of-
        freedom value is prescribed to be a cosine function, then specifying an
        initial condition for the same node and degree of freedom ensures that
        the initial value for the constraint degree of freedom at time = 0.0 is
        same as the cosine function evaluated at time = 0.0. If initial
        conditions are not specified, the constraint degree-of-freedom value
        ramps from zero in the first substep of the first loadstep.

        If more than one rotational degrees of freedom are constrained with
        non-zero rotations (ROTX, ROTY, ROTZ), rotational velocities (OMGX,
        OMGY, OMGZ), or rotational accelerations (DMGX, DMGY, DMGZ), then the
        rotation of the constrained node from its initial configuration to its
        final configuration depends on the combination and the sequence in
        which the constraints are applied. See Rotations in a Large-Deflection
        Analysis in Structural Analysis Guide.

        This command is also valid in PREP7.
        """
        command = "D,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(node), str(lab), str(value), str(value2), str(nend), str(ninc), str(lab2), str(lab3), str(lab4), str(lab5), str(lab6))
        return self.run(command, **kwargs)

    def klist(self, np1="", np2="", ninc="", lab="", **kwargs):
        """APDL Command: KLIST

        Lists the defined keypoints or hard points.

        Parameters
        ----------
        np1, np2, ninc
            List keypoints from NP1 to NP2 (defaults to NP1) in steps of NINC
            (defaults to 1).  If NP1 = ALL (default), NP2 and NINC are ignored
            and all selected keypoints [KSEL] are listed.  If NP1 = P,
            graphical picking is enabled and all remaining command fields are
            ignored (valid only in the GUI).  A component name may also be
            substituted for NP1 (NP2 and NINC are ignored).

        lab
            Coordinate listing key:

            (blank) - List all keypoint information.

            COORD - Suppress all but the keypoint coordinates (shown to a higher degree of accuracy
                    than when displayed with all information).

            HPT - List only hard point information.

        Notes
        -----
        Lists keypoints in the active display coordinate system [DSYS].  An
        attribute (TYPE, MAT, REAL, or ESYS) listed as a zero is unassigned;
        one listed as a positive value indicates that the attribute was
        assigned with the KATT command (and will not be reset to zero if the
        mesh is cleared); one listed as a negative value indicates that the
        attribute was assigned using the attribute pointer [TYPE, MAT, REAL, or
        ESYS] that was active during meshing (and will be reset to zero if the
        mesh is cleared).

        This command is valid in any processor.
        """
        command = "KLIST,%s,%s,%s,%s" % (str(np1), str(np2), str(ninc), str(lab))
        return self.run(command, **kwargs)

    def edadapt(self, part="", key="", **kwargs):
        """APDL Command: EDADAPT

        Activates adaptive meshing in an explicit dynamic analysis.

        Parameters
        ----------
        part
            Part ID (number) for which adaptive meshing is to be turned on (or
            off). Use PART = STAT to list the current adaptive meshing
            definitions.

        key
            Adaptivity key:

            OFF - Do not use adaptive meshing for the specified part ID (default).

            ON - Use adaptive meshing for the specified part ID.

        Notes
        -----
        When adaptive meshing (adaptivity) is turned on, the mesh will
        automatically be regenerated to ensure adequate element aspect ratios.
        Adaptive meshing is most commonly used in the analysis of large
        deformation processes such as metal forming, in which the blank would
        need to be adaptively meshed.

        Adaptive meshing is only valid for parts consisting of SHELL163
        elements. By default, adaptive meshing is OFF for all parts in the
        model. To specify adaptive meshing for more than one part in the model,
        you must issue the EDADAPT command for each part ID. Use the EDPART
        command to create and list valid part IDs. Use the EDCADAPT command to
        define additional adaptive meshing parameters.

        The EDADAPT command is not supported in an explicit dynamic full
        restart analysis (EDSTART,3). In addition, a full restart cannot be
        performed successfully if adaptive meshing was used in the previous
        analysis.

        This command is also valid in PREP7.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDADAPT,%s,%s" % (str(part), str(key))
        return self.run(command, **kwargs)

    def fsplot(self, nloc="", nev="", item="", **kwargs):
        """APDL Command: FSPLOT

        Displays a fatigue stress item for a fatigue location and event.

        Parameters
        ----------
        nloc
            Display stresses associated with location NLOC.

        nev
            Display stresses associated with event NEV.

        item
            Display stresses associated with item number ITEM.  Items are as
            follows:

            1-6 - SX, SY, SZ, SXY, SYZ, SXZ total stress components

            7 - Temperature

            8-13 - SX, SY, SZ, SXY, SYZ, SXZ membrane-plus-bending stress components.

            14 - Time

        Notes
        -----
        Displays a fatigue stress item as a function of loading number for a
        particular fatigue location and event.
        """
        command = "FSPLOT,%s,%s,%s" % (str(nloc), str(nev), str(item))
        return self.run(command, **kwargs)

    def filname(self, fname="", key="", **kwargs):
        """APDL Command: /FILNAME

        Changes the Jobname for the analysis.

        Parameters
        ----------
        fname
            Name (32 characters maximum) to be used as the Jobname.  Defaults
            to the initial Jobname as specified on the ANSYS execution command,
            or to file if none specified.

        key
            Specify whether to use the existing log, error, lock, page, and
            output files (.LOG, .ERR, .LOCK, .PAGE and .OUT) or start new
            files.

            0, OFF - Continue using current log, error, lock, page, and output files.

            1, ON - Start new log, error, lock, page, and output files (old log and error files are
                    closed and saved, but old lock, page, and output files are
                    deleted). Existing log and error files are appended.

        Notes
        -----
        All subsequently created files will be named with this Jobname if Key =
        0.  Use Key = 1 to start new log, error, lock, page, and output files.
        The previous Jobname is typically defined on the ANSYS program
        execution line (see the Operations Guide).  This command is useful when
        different groups of files created throughout the run are to have
        different names.  For example, the command may be used before each
        substructure pass to avoid overwriting files or having to rename each
        file individually.

        This command is valid only at the Begin level.
        """
        command = "/FILNAME,%s,%s" % (str(fname), str(key))
        return self.run(command, **kwargs)

    def cformat(self, nfirst="", nl_ast="", **kwargs):
        """APDL Command: /CFORMAT

        Controls the graphical display of alphanumeric character strings for
        parameters, components, assemblies, and tables.

        Parameters
        ----------
        nfirst
            Display the first n characters of the parameter, component,
            assembly, or table name, up to 32. Defaults to 32.

        nlast
            Display the last n characters of the parameter, component,
            assembly, or table name, up to 32. Defaults to 0.

        Notes
        -----
        Use this command to control the length of the character string that is
        shown in the graphics window for a parameter, component, assembly, or
        table name.

        The total number of characters (NFIRST + NLAST +3) cannot exceed 32.

        If NFIRST is greater than zero and NLAST = 0, only the NFIRST
        characters are displayed, followed by an ellipsis.

        If NFIRST = 0 and NLAST is greater than zero, only the NLAST characters
        are displayed, preceded by an ellipsis (...).

        If both NFIRST and NLAST are greater than zero, the name will be shown
        as NFIRST, followed by an ellipsis (...), followed by NLAST, up to a
        maximum of 32 characters.

        For example, if NFIRST = 6 and NLAST = 3, and the character string is
        LENGTHOFSIDEONE, then it will appear in the graphics window as
        LENGTH...ONE.

        If the actual length of the character string is less than the specified
        combination of NFIRST + NLAST +3, then the actual string will be used.

        This command is valid in any processor.
        """
        command = "/CFORMAT,%s,%s" % (str(nfirst), str(nl_ast))
        return self.run(command, **kwargs)

    def radopt(self, unused="", fluxtol="", solver="", maxiter="",
               toler="", overrlex="", maxfluxiter="", **kwargs):
        """APDL Command: RADOPT

        Specifies Radiosity Solver options.

        Parameters
        ----------
        --
            Unused field.

        fluxtol
            Convergence tolerance for radiation flux. Defaults to 0.0001. This
            value is a relative tolerance.

        solver
            Choice of solver for radiosity calculation:

            0 - Gauss-Seidel iterative solver (default).

            1 - Direct solver.

            2 - Jacobi solver.

        maxiter
            Maximum number of iterations for iterative solver (SOLVER = 0 or
            2). Defaults to 1000.

        toler
            Convergence tolerance for the iterative solver (SOLVER = 0 or 2).
            Defaults to 0.1.

        overrlex
            Over-relaxation factor applied to the iterative solver (SOLVER = 0
            or 2). Defaults to 0.1.

        --, --, --, --
            Unused fields

        maxfluxiter
            Maximum number of flux iterations to be performed according to the
            specified solver type:

            0 - If the FULL solver is specified (THOPT,FULL), convergence criteria are
                monitored and iterations are performed until convergence
                occurs. If the QUASI solver is specified (THOPT,QUASI),
                convergence criteria are ignored and one iteration is
                performed. This value is the default.

            1, 2, 3, ...N  - If the FULL solver is specified (THOPT,FULL), convergence criteria are
                             monitored and iterations are performed until
                             convergence occurs, or until the specified number
                             of iterations has been completed, whichever comes
                             first. If the QUASI solver is specified
                             (THOPT,QUASI), convergence criteria are ignored
                             and the specified number of iterations are
                             completed.

        Notes
        -----
        The radiation heat flux is linearized, resulting in robust convergence.

        The radiation flux norm for FLUXTOL is expressed as:

        where i is the pass or iteration number and j is the surface facet for
        radiation.

        For a sufficiently small absolute tolerance value, relative tolerance
        converges in fewer iterations than absolute tolerance. For a
        sufficiently large absolute tolerance value, relative tolerance may
        cause convergence difficulties.

        For more information about FLUXTOL and MAXFLUXITER usage, see Figure:
        3.5:: FULL Solution Method When Radiosity Is Present and Figure: 3.6::
        QUASI Solution Method When Radiosity Is Present in the Thermal Analysis
        Guide.

        In Figure: 3.5:: FULL Solution Method When Radiosity Is Present and
        Figure: 3.6:: QUASI Solution Method When Radiosity Is Present (under
        Solving for Temperature and Radiosity in the Thermal Analysis Guide),
        refer to the KQQ = FQ equation system via the iterative method:

        If TOLER ≥ 0, the iterative solver is converged for maximum value over
        a different j as shown:

        If TOLER < 0, the iterative solver is converged for maximum value over
        a different j as shown:

        where:

        The Jacobi solver (SOLVER = 2) is suitable when using Distributed
        ANSYS. This option is only available for 3-D models; if SOLVER is set
        to 2 for a 2-D analysis, the Gauss-Seidel iterative solver (SOLVER = 0)
        is used.
        """
        command = "RADOPT,%s,%s,%s,%s,%s,%s" % (str(unused),
                                                str(fluxtol),
                                                str(solver),
                                                str(maxiter),
                                                str(toler),
                                                str(overrlex),
                                                str(maxfluxiter))
        return self.run(command, **kwargs)

    def tiff(self, kywrd="", opt="", **kwargs):
        """APDL Command: TIFF

        Provides TIFF file Export for ANSYS Displays.

        Parameters
        ----------
        kywrd
            Specifies various TIFF file export options.

            COMP - If Kywrd = COMP, then OPT controls data compression for the output file. If
                   COMP = 0, then compression is off. If COMP = 1 (default),
                   then compression is on.

            ORIENT - If Kywrd = ORIENT, then OPT will determine the orientation of the entire plot.
                     OPT can be either Horizontal (default) or Vertical.

            COLOR - If Kywrd = COLOR, then OPT will determine the color attribute of the saved
                    file. OPT can be 0, 1, or 2, corresponding to Black and
                    White, Grayscale, and Color (default), respectively.

            TMOD - If Kywrd = TMOD, then OPT will determine the text method. OPT can be either 1
                   or 0, corresponding to bitmap text (default) or line stroke
                   text, respectively.

            DEFAULT - If Kywrd = DEFAULT, then all of the default values, for all of the Kywrd
                      parameters listed above, are active.

        opt
            OPT can have the following names or values, depending on the value
            for Kywrd (see above).

            1 or 0 - If Kywrd = COMP, a value or 1 (on) or 0 (off) will control compression for the
                     TIFF file.

            Horizontal, Vertical - If Kywrd = ORIENT, the terms Horizontal or Vertical determine the orientation
                              of the plot.

            0, 1, 2 - If Kywrd = COLOR, the numbers 0, 1, and 2 correspond to Black and White ,
                      Grayscale and Color, respectively.

            1, 0 - If Kywrd = TMOD, the values 1 and 0 determine whether bitmap (1) or stroke text
                   (0) fonts will be used
        """
        command = "TIFF,%s,%s" % (str(kywrd), str(opt))
        return self.run(command, **kwargs)

    def impd(self, vpath="", ipath="", vsymm="", isymm="", **kwargs):
        """APDL Command: IMPD

        Calculates the impedance of a conductor at a reference plane.

        Parameters
        ----------
        vpath
            Path name for a predefined path [PATH command] for calculating the
            EMF (voltage drop) from the conductor to a reference point. The
            path should start at the outer conductor wall and end at a
            reference voltage point.

        ipath
            Path name for a predefined path [PATH command] for calculating the
            MMF (current) in a conductor. The path should traverse a closed
            contour surrounding the conductor, and you should define the path
            in a counterclockwise direction.

        vsymm
            Symmetry factor applied to the calculated EMF (voltage drop). The
            EMF (voltage drop) from the conductor to the reference point is
            multiplied by Vsymm.

        isymm
            Symmetry factor applied to the calculated current. The calculated
            current is multiplied by Isymm.

        Notes
        -----
        Used in a harmonic high-frequency electromagnetic analysis, IMPD
        calculates the impedance of a conductor at a reference plane from the
        EMF (voltage) and MMF (current) at the reference plane. The EMF
        (voltage drop) is calculated by a line integral from the input path
        name (specified by the Vpath argument) that extends from the conductor
        to a reference point. The MMF (current) is calculated by a closed path
        around the conductor from the input path name (specified with Ipath).
        In cases having modeled symmetry, you can multiply the voltage drop or
        current by symmetry factors (Vsymm and Isymm respectively).

        This command macro returns the scalar parameters Zre and Zim,
        representing the real and imaginary components of the impedance.

        See magnetic macros for further details.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "IMPD,%s,%s,%s,%s" % (str(vpath), str(ipath), str(vsymm), str(isymm))
        return self.run(command, **kwargs)

    def vsbv(self, nv1="", nv2="", sepo="", keep1="", keep2="", **kwargs):
        """APDL Command: VSBV

        Subtracts volumes from volumes.

        Parameters
        ----------
        nv1
            Volume (or volumes, if picking is used) to be subtracted from.  If
            ALL, use all selected volumes.  Volumes specified in set NV2 are
            removed from set NV1.  If P, graphical picking is enabled (valid
            only in the GUI) and remaining fields are ignored.  A component
            name may also be substituted for NV1.

        nv2
            Volume (or volumes, if picking is used) to subtract.  If ALL, use
            all selected volumes (except those included in the NV1 argument).
            A component name may also be substituted for NV2.

        sepo
            Behavior if the intersection of the NV1 volumes and the NV2 volumes
            is an area or areas:

            (blank) - The resulting volumes will share area(s) where they touch.

            SEPO - The resulting volumes will have separate, but coincident area(s) where they
                   touch.

        keep1
            Specifies whether NV1 volumes are to be deleted:

            (blank) - Use the setting of KEEP on the BOPTN command.

            DELETE - Delete NV1 volumes after VSBV operation (override BOPTN command settings).

            KEEP - Keep NV1 volumes after VSBV operation (override BOPTN command settings).

        keep2
            Specifies whether NV2 volumes are to be deleted:

            (blank) - Use the setting of KEEP on the BOPTN command.

            DELETE - Delete NV2 volumes after VSBV operation (override BOPTN command settings).

            KEEP - Keep NV2 volumes after VSBV operation (override BOPTN command settings).

        Notes
        -----
        Generates new volumes by subtracting the regions common to both NV1 and
        NV2 volumes (the intersection) from the NV1 volumes.  The intersection
        can be a volume(s) or area(s).  If the intersection is an area and SEPO
        is blank, the NV1 volume is divided at the area and the resulting
        volumes will be connected, sharing a common area where they touch.  If
        SEPO is set to SEPO, NV1 is divided into two unconnected volumes with
        separate areas where they touch.  See the Modeling and Meshing Guide
        for an illustration.  See the BOPTN command for an explanation of the
        options available to Boolean operations.  Element attributes and solid
        model boundary conditions assigned to the original entities will not be
        transferred to the new entities generated.  VSBV,ALL,ALL will have no
        effect because all the volumes in set NV1will have been moved to set
        NV2.
        """
        command = "VSBV,%s,%s,%s,%s,%s" % (str(nv1), str(nv2), str(sepo), str(keep1), str(keep2))
        return self.run(command, **kwargs)

    def sfl(self, line="", lab="", vali="", valj="", val2i="", val2j="",
            **kwargs):
        """APDL Command: SFL

        Specifies surface loads on lines of an area.

        Parameters
        ----------
        line
            Line to which surface load applies.  If ALL, apply load to all
            selected lines [LSEL].  If Line = P, graphical picking is enabled
            and all remaining command fields are ignored (valid only in the
            GUI).  A component name may be substituted for Line.

        lab
            Valid surface load label.  Load labels are listed under "Surface
            Loads" in the input table for each element type in the Element
            Reference.

        vali, valj
            Surface load values at the first keypoint (VALI) and at the second
            keypoint (VALJ) of the line, or table name for specifying tabular
            boundary conditions.  If VALJ is blank, it defaults to VALI.  If
            VALJ is zero, a zero is used.  If Lab = CONV, VALI and VALJ are the
            film coefficients and VAL2I and VAL2J are the bulk temperatures.
            To specify a table, enclose the table name in percent signs (%),
            e.g., %tabname%.  Use the *DIM command to define a table.  If Lab =
            CONV and VALI = -N, the film coefficient may be a function of
            temperature and is determined from the HF property table for
            material N [MP].  If Lab = RAD, VALI and VALJ values are surface
            emissivities and VAL2I and VAL2J are ambient temperatures.  The
            temperature used to evaluate the film coefficient is usually the
            average between the bulk and wall temperatures, but may be user
            defined for some elements.  If Lab = RDSF, VALI is the emissivity
            value; the following condition apply: If VALI = -N, the emissivity
            may be a function of the temperature and is determined from the
            EMISS property table for material N [MP]. If Lab = FSIN in a Multi-
            field solver (single or multiple code coupling) analysis, VALI is
            the surface interface number. If Lab = FSIN in a unidirectional
            ANSYS to CFX analysis, VALJ is the surface interface number (not
            available from within the GUI) and VALI is not used unless the
            ANSYS analysis is performed using the Multi-field solver.

        val2i, val2j
            Second surface load values (if any).  If Lab = CONV, VAL2I and
            VAL2J are the bulk temperatures. If Lab = RAD, VAL2I and VAL2J are
            the ambient temperatures. If Lab = RDSF, VAL2I is the enclosure
            number. Radiation will occur between surfaces flagged with the same
            enclosure numbers. If the enclosure is open, radiation will occur
            to the ambient. VAL2I and VAL2J are not used for other surface load
            labels.  If VAL2J is blank, it defaults to VAL2I.  If VAL2J is
            zero, a zero is used.  To specify a table (Lab = CONV), enclose the
            table name in percent signs (%), e.g., %tabname%.  Use the *DIM
            command to define a table.

        Notes
        -----
        Specifies surface loads on the selected lines of area regions.  The
        lines represent either the edges of area elements or axisymmetric shell
        elements themselves.  Surface loads may be transferred from lines to
        elements with the SFTRAN or SBCTRAN commands.  See the SFE command for
        a description of surface loads.  Loads input on this command may be
        tapered.  See the SFGRAD command for an alternate tapered load
        capability.

        You can specify a table name only when using structural (PRES) and
        thermal (CONV [film coefficient and/or bulk temperature], HFLUX), and
        surface emissivity and ambient temperature (RAD) surface load labels.
        VALJ and VAL2J are ignored for tabular boundary conditions.

        This command is also valid in PREP7.
        """
        command = "SFL,%s,%s,%s,%s,%s,%s" % (str(line), str(lab), str(vali), str(valj), str(val2i), str(val2j))
        return self.run(command, **kwargs)

    def srss(self, signif="", label="", abssumkey="", forcetype="", **kwargs):
        """APDL Command: SRSS

        Specifies the square root of sum of squares mode combination method.

        Parameters
        ----------
        signif
            Combine only those modes whose significance level exceeds the
            SIGNIF threshold.  For single point, multipoint, or DDAM response
            (SPOPT,SPRS, MPRS or DDAM), the significance level of a mode is
            defined as the mode coefficient of the mode, divided by the maximum
            mode coefficient of all modes.  Any mode whose significance level
            is less than SIGNIF is considered insignificant and is not
            contributed to the mode combinations.  The higher the SIGNIF
            threshold, the fewer the number of modes combined. SIGNIF defaults
            to 0.001.  If SIGNIF is specified as 0.0, it is taken as 0.0.
            (This mode combination method is not valid for SPOPT,PSD.)

        label
            Label identifying the combined mode solution output.

            DISP - Displacement solution (default).  Displacements, stresses, forces, etc., are
                   available.

            VELO - Velocity solution.  Velocities, "stress velocities," "force velocities," etc.,
                   are available.

            ACEL - Acceleration solution.  Accelerations, "stress accelerations," "force
                   accelerations," etc., are available.

        abssumkey
            Absolute Sum combination key (for SPOPT,MPRS only):

            NO - Do not use the Absolute Sum method (default).

            YES - Combine the modes per excitation direction using the Absolute Sum method, then
                  combine the resulting quantities using the square root of sum
                  of squares method.

        forcetype
            Label identifying the forces to be combined:

            STATIC - Combine the modal static forces (default).

            TOTAL - Combine the modal static plus inertial forces.

        Notes
        -----
        This command is also valid for PREP7.
        """
        command = "SRSS,%s,%s,%s,%s" % (str(signif), str(label), str(abssumkey), str(forcetype))
        return self.run(command, **kwargs)

    def eusort(self, **kwargs):
        """APDL Command: EUSORT

        Restores original order of the element table.

        Notes
        -----
        Changing the selected element set [ESEL] also restores the original
        element order.
        """
        command = "EUSORT," % ()
        return self.run(command, **kwargs)

    def vsum(self, lab="", **kwargs):
        """APDL Command: VSUM

        Calculates and prints geometry statistics of the selected volumes.

        Parameters
        ----------
        lab
            Controls the degree of tessellation used in the calculation of area
            properties.  If LAB = DEFAULT, area calculations will use the
            degree of tessellation set through the /FACET command.  If LAB =
            FINE, area calculations are based on a finer tessellation.

        Notes
        -----
        Calculates and prints geometry statistics (volume, centroid location,
        moments of inertia, etc.) associated with the selected volumes.
        Geometry items are reported in the global Cartesian coordinate system.
        A unit density is assumed unless the volumes have a material
        association via the VATT command.  Items calculated by VSUM and later
        retrieved by a *GET or *VGET command are valid only if the model is not
        modified after the VSUM command is issued.

        Setting a finer degree of tessellation will provide area calculations
        with greater accuracy, especially for thin, hollow models.  However,
        using a finer degree of tessellation requires longer processing.

        For very thin volumes, such that the ratio of the minimum to the
        maximum dimension is less than 0.01, the VSUM command can provide
        erroneous volume information.  To ensure that such calculations are
        accurate, make certain that you subdivide such volumes so that the
        ratio of the minimum to the maximum is at least 0.05.
        """
        command = "VSUM,%s" % (str(lab))
        return self.run(command, **kwargs)

    def smin(self, labr="", lab1="", lab2="", fact1="", fact2="", **kwargs):
        """APDL Command: SMIN

        Forms an element table item from the minimum of two other items.

        Parameters
        ----------
        labr
            Label assigned to results.  If same as existing label, the existing
            values will be overwritten by these results.

        lab1
            First labeled result item in operation.

        lab2
            Second labeled result item in operation (may be blank).

        fact1
            Scale factor applied to Lab1. A (blank) or '0' entry defaults to
            1.0.

        fact2
            Scale factor applied to Lab2. A (blank) or '0' entry defaults to
            1.0.

        Notes
        -----
        Forms a labeled result item (see ETABLE command) for the selected
        elements by comparing two existing labeled result items according to
        the operation:

        LabR = (FACT1 x Lab1) cmn (FACT2 x Lab2)

        where "cmn" means "compare and save minimum."  If absolute values are
        requested [SABS,1], the absolute values of Lab1 and Lab2 are used.
        """
        command = "SMIN,%s,%s,%s,%s,%s" % (str(labr), str(lab1), str(lab2), str(fact1), str(fact2))
        return self.run(command, **kwargs)

    def mplib(self, r_w_opt="", path="", **kwargs):
        """APDL Command: /MPLIB

        Sets the default material library read and write paths.

        Parameters
        ----------
        r-w_opt
            Determines what path is being set.  Possible values are:

            READ - Set the read path.

            WRITE - Set the write path.

            STAT - Report what read and write paths are currently in use.

        path
            The directory path to be used for material library files.

        Notes
        -----
        The /MPLIB command sets two path strings used in conjunction with the
        material library feature and the MPREAD and MPWRITE commands.

        For MPREAD, when you use the LIB option and no directory path is given
        in the file name, the command searches for the file in these locations:
        the current working directory, the user's home directory, the user-
        specified material library directory (as defined by the
        /MPLIB,READ,PATH command), and /ansys_dir/matlib.

        For MPWRITE, when you use the LIB option and the directory portion of
        the specification for the material library file is blank, the command
        writes the material  library file to the directory specified by the
        /MPLIB,WRITE,PATH command (if that path has been set).  If the path has
        not been set, the default is to write the file to the current working
        directory.

        The Material Library files supplied with the distribution disks are
        meant for demonstration purposes only.  These files are not intended
        for use in customer applications.
        """
        command = "/MPLIB,%s,%s" % (str(r_w_opt), str(path))
        return self.run(command, **kwargs)

    def asbl(self, na="", nl="", unused="", keepa="", keepl="", **kwargs):
        """APDL Command: ASBL

        Subtracts lines from areas.

        Parameters
        ----------
        na
            Area (or areas, if picking is used) to be subtracted from.  If ALL,
            use all selected areas.  If P, graphical picking is enabled (valid
            only in the GUI) and remaining fields are ignored.  A component
            name may also be substituted for NA.

        nl
            Line (or lines, if picking is used) to subtract.  If ALL, use all
            selected lines.    A component name may also be substituted for NL.

        --
            Unused field.

        keepa
            Specifies whether NA areas are to be deleted:

            (blank) - Use the setting of KEEP on the BOPTN command.

            DELETE - Delete NA areas after ASBL operation (override BOPTN command settings).

            KEEP - Keep NA areas after ASBL operation (override BOPTN command settings).

        keepl
            Specifies whether NL lines are to be deleted:

            (blank) - Use the setting of KEEP on the BOPTN command.

            DELETE - Delete NL lines after ASBL operation (override BOPTN command settings).

            KEEP - Keep NL lines after ASBL operation (override BOPTN command settings).

        Notes
        -----
        Generates new areas by subtracting the regions common to both the areas
        and lines (the intersection) from the NA areas.  The intersection will
        be a line(s).  See Solid Modeling in the Modeling and Meshing Guide for
        an illustration.  See the BOPTN command for an explanation of the
        options available to Boolean operations.  Element attributes and solid
        model boundary conditions assigned to the original entities will not be
        transferred to the new entities generated.
        """
        command = "ASBL,%s,%s,%s,%s,%s" % (str(na),
                                           str(nl),
                                           str(unused),
                                           str(keepa),
                                           str(keepl))
        return self.run(command, **kwargs)

    def neqit(self, neqit="", forcekey="", **kwargs):
        """APDL Command: NEQIT

        Specifies the maximum number of equilibrium iterations for nonlinear
        analyses.

        Parameters
        ----------
        neqit
            Maximum number of equilibrium iterations allowed each substep.

        forcekey
            One iteration forcing key:

            FORCE - Forces one iteration per substep. Leave this field blank otherwise.

        Notes
        -----
        This command is also valid in PREP7.
        """
        command = "NEQIT,%s,%s" % (str(neqit), str(forcekey))
        return self.run(command, **kwargs)

    def bfescal(self, lab="", fact="", tb_ase="", **kwargs):
        """APDL Command: BFESCAL

        Scales element body force loads.

        Parameters
        ----------
        lab
            Valid body load label.  If ALL, use all appropriate labels.

        fact
            Scale factor for the element body load values.  Zero (or blank)
            defaults  to 1.0.  Use a small number for a "zero" scale factor.
            The scale factor is not applied to body load phase angles.

        tbase
            Base temperature for temperature difference.  Used only with Lab =
            TEMP.  Scale factor is applied to the temperature difference (T -
            TBASE)  and then added to TBASE.  T is the current temperature.

        Notes
        -----
        Scales element body force loads on the selected elements in the
        database.  Issue the BFELIST command to list the element body loads.
        Solid model boundary conditions are not scaled by this command, but
        boundary conditions on the FE model are scaled.  (Note that such scaled
        FE boundary conditions may still be overwritten by unscaled solid model
        boundary conditions if a subsequent boundary condition transfer
        occurs.)

        BFESCAL does not work for tabular boundary conditions.

        This command is also valid in PREP7.
        """
        command = "BFESCAL,%s,%s,%s" % (str(lab), str(fact), str(tb_ase))
        return self.run(command, **kwargs)

    def edtp(self, option="", value1="", value2="", **kwargs):
        """APDL Command: EDTP

        Plots explicit elements based on their time step size.

        Parameters
        ----------
        option
             Plotting option (default = 1).

            1 - Plots the elements with the smallest time step sizes. The number of elements
                plotted and listed is equal to VALUE1 (which defaults to 100).
                Each element is shaded red or yellow based on its time step
                value (see "Notes" for details).

            2 - Produces the same plot as for OPTION = 1, and also produces a list of the
                plotted elements and their corresponding time step values.

            3 - Produces a plot similar to OPTION = 1, except that all selected elements are
                plotted. Elements beyond the first VALUE1 elements are blue and
                translucent. The amount of translucency is specified by VALUE2.
                This option also produces a list of the first VALUE1 elements
                with their corresponding time step values.

        value1
            Number of elements to be plotted and listed (default = 100). For
            example, if VALUE1 = 10, only the elements with the 10 smallest
            time step sizes are plotted and listed.

        value2
            Translucency level ranging from 0 to 1 (default = 0.9). VALUE2 is
            only used when OPTION = 3, and only for the elements plotted in
            blue. To plot these elements as non-translucent, set VALUE2 = 0.

        Notes
        -----
        EDTP invokes an ANSYS macro that plots and lists explicit elements
        based on their time step size. For OPTION = 1 or 2, the number of
        elements plotted is equal to VALUE1 (default = 100). For OPTION = 3,
        all selected elements are plotted.

        The elements are shaded red, yellow, or blue based on their time step
        size. Red represents the smallest time step sizes, yellow represents
        the intermediate time step sizes, and blue represents the largest time
        step sizes. For example, if you specify VALUE1 = 30, and if T1 is the
        smallest critical time step of all elements and T30 is the time step of
        the 30th smallest element, then the elements are shaded as follows:

        Translucent blue elements only appear when OPTION = 3.

        This command is also valid in PREP7.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDTP,%s,%s,%s" % (str(option), str(value1), str(value2))
        return self.run(command, **kwargs)

    def arctrm(self, lab="", val="", node="", dof="", **kwargs):
        """APDL Command: ARCTRM

        Controls termination of the solution when the arc-length method is
        used.

        Parameters
        ----------
        lab
            Specifies the basis of solution termination:

            OFF - Does not use ARCTRM to terminate analysis (default).

            L - Terminates the analysis if the first limit point has been reached.  The first
                limit point is that point in the response history when the
                tangent stiffness matrix becomes singular (i.e., the point at
                which the structure becomes unstable).  If Lab = L, arguments
                VAL, NODE, DOF are ignored.

            U - Terminates the analysis when the displacement first equals or exceeds the
                maximum desired value.

        val
            Maximum desired displacement (absolute value).  Valid only if Lab =
            U.  The analysis terminates whenever the calculated displacement
            first equals or exceeds this value.  For rotational degrees of
            freedom, VAL must be in radians (not degrees).

        node
            Node number corresponding to displacement used to compare with
            displacement specified by VAL.  If blank, the maximum displacement
            will be used.  Valid only if Lab = U.

        dof
            Valid degree of freedom label for nodal displacement specified by
            NODE.  Valid labels are UX, UY, UZ, ROTX, ROTY, ROTZ.  Valid only
            if NODE>0 and Lab = U.

        Notes
        -----
        The ARCTRM command is valid only when the arc-length method (ARCLEN,ON)
        is used.

        It can be convenient to use this command to terminate the analysis when
        the first limit point is reached. In addition, the NCNV command should
        be used to limit the maximum number of iterations. If the ARCTRM
        command is not used, and the applied load is so large that the solution
        path can never reach that load, the arc-length solution will continue
        to run until a CPU time limit or a "maximum number of iterations" is
        reached.
        """
        command = "ARCTRM,%s,%s,%s,%s" % (str(lab), str(val), str(node), str(dof))
        return self.run(command, **kwargs)

    def bfv(self, volu="", lab="", val1="", val2="", val3="", ph_ase="",
            **kwargs):
        """APDL Command: BFV

        Defines a body force load on a volume.

        Parameters
        ----------
        volu
            Volume to which body load applies.  If ALL, apply to all selected
            volumes [VSEL]. A component name may also be substituted for Volu.

        lab
            Valid body load label. Load labels are listed under "Body Loads" in
            the input table for each element type in the Element Reference.

        val1, val2, val3
            Value associated with the Lab item or a table name for specifying
            tabular boundary conditions.  Use only VAL1 for TEMP, FLUE, HGEN,
            and CHRGD.  Use VAL1, VAL2, and VAL3 for the X, Y, and Z components
            of JS.  For Lab = JS in magnetics, use VAL1, VAL2, and VAL3 for the
            X, Y, and Z components. For acoustics, if Lab = JS,  use VAL1 for
            mass source in a harmonic analysis or mass source rate in a
            transient analysis, and ignoreVAL2 and VAL3. For Lab = VLTG, VAL1
            is the voltage drop and VAL2 is the phase angle.  When specifying a
            table name, you must enclose the table name in percent signs (%),
            e.g., BFV,Volu,Lab,%tabname%.  Use the *DIM command to define a
            table.

        phase
            Phase angle in degrees associated with the JS label.

        Notes
        -----
        Defines a body force load (such as temperature in a structural
        analysis, heat generation rate in a thermal analysis, etc.) on a
        volume.  Body loads may be transferred from volumes to volume elements
        (or to nodes if volume elements do not exist) with the BFTRAN or
        SBCTRAN commands.  Body loads default to the value specified on the
        BFUNIF command, if it was previously specified.

        You can specify a table name only when using temperature (TEMP) and
        heat generation rate (HGEN) body load labels.

        Body loads specified by the BFV command can conflict with other
        specified body loads.  See Resolution of Conflicting Body Load
        Specifications in the Basic Analysis Guide for details.

        Graphical picking is available only via the listed menu paths.

        This command is also valid in PREP7.
        """
        command = "BFV,%s,%s,%s,%s,%s,%s" % (str(volu), str(lab), str(val1), str(val2), str(val3), str(ph_ase))
        return self.run(command, **kwargs)

    def anfile(self, lab="", fname="", ext="", **kwargs):
        """APDL Command: /ANFILE

        Saves or resumes an animation sequence to or from a file.

        Parameters
        ----------
        lab
            Label type.

            SAVE - Save the current animation to a file.

            RESUME - Resume an animation from a file.

        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        Notes
        -----
        This command saves an animation to a file from local terminal segments
        or resumes an animation from a file to local terminal segments.  See
        the /SEG command for details on segment storage.  See the ANCNTR macro
        for a convenient method of storing graphics frames in terminal memory
        segments.  This command is device dependent and is valid in any
        processor.
        """
        command = "/ANFILE,%s,%s,%s" % (str(lab), str(fname), str(ext))
        return self.run(command, **kwargs)

    def mptgen(self, stloc="", num="", tstrt="", tinc="", **kwargs):
        """APDL Command: MPTGEN

        Adds temperatures to the temperature table by generation.

        Parameters
        ----------
        stloc
            Starting location in table for generating temperatures.  Defaults
            to last location filled + 1.

        num
            Number of temperatures to be generated (1-100).

        tstrt
            Temperature assigned to STLOC location.

        tinc
            Increment previous temperature by TINC and assign to next location
            until all NUM locations are filled.

        Notes
        -----
        Adds temperatures to the temperature table by generation.  May be used
        in combination (or in place of) the MPTEMP command.

        This command is also valid in SOLUTION.
        """
        command = "MPTGEN,%s,%s,%s,%s" % (str(stloc), str(num), str(tstrt), str(tinc))
        return self.run(command, **kwargs)

    def mpdres(self, labf="", matf="", labt="", matt="", **kwargs):
        """APDL Command: MPDRES

        Reassembles existing material data with the temperature table.

        Parameters
        ----------
        labf
            Material property label associated with MATF.

        matf
            Material reference number of property to restore from virtual
            space.

        labt
            Material property label associated with MATT (defaults to label
            associated with MATF).

        matt
            Material reference number assigned to generated property (defaults
            to MATF).

        Notes
        -----
        Restores into the database (from virtual space) a data table previously
        defined [MP] for a particular property, assembles data with current
        database temperature table, and stores back in virtual space as a new
        property.

        This command is also valid in SOLUTION.
        """
        command = "MPDRES,%s,%s,%s,%s" % (str(labf), str(matf), str(labt), str(matt))
        return self.run(command, **kwargs)

    def a(self, p1="", p2="", p3="", p4="", p5="", p6="", p7="", p8="", p9="",
          p10="", p11="", p12="", p13="", p14="", p15="", p16="", p17="",
          p18="", **kwargs):
        """APDL Command: A

        Defines an area by connecting keypoints.

        Parameters
        ----------
        p1, p2, p3, . . . , p18
            List of keypoints defining the area (18 maximum if using keyboard
            entry).  At least 3 keypoints must be entered.  If P1 = P,
            graphical picking is enabled and all remaining arguments are
            ignored (valid only in the GUI).

        Returns
        -------
        result : int
            Returns the area number of the created area or None,
            if something went wrong.

        Notes
        -----
        Keypoints (P1 through P18) must be input in a clockwise or
        counterclockwise order around the area.  This order also determines the
        positive normal direction of the area according to the right-hand rule.
        Existing lines between adjacent keypoints will be used; missing lines
        are generated "straight" in the active coordinate system and assigned
        the lowest available numbers [NUMSTR].  If more than one line exists
        between two keypoints, the shorter one will be chosen.  If the area is
        to be defined with more than four keypoints, the required keypoints and
        lines must lie on a constant coordinate value in the active coordinate
        system (such as a plane or a cylinder).  Areas may be redefined only if
        not yet attached to a volume.  Solid modeling in a toroidal coordinate
        system is not recommended.
        """
        command = "A,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(p1), str(p2), str(p3), str(p4), str(p5), str(p6), str(p7), str(p8), str(p9), str(p10), str(p11), str(p12), str(p13), str(p14), str(p15), str(p16), str(p17), str(p18))
        return self.run(command, **kwargs)

    def hptcreate(self, type="", entity="", nhp="", label="", val1="", val2="",
                  val3="", **kwargs):
        """APDL Command: HPTCREATE

        Defines a hard point.

        Parameters
        ----------
        type
            Type of entity on which the hard point will be created.

            LINE - Hard point will be created on a line.

            AREA - Hard point will be created within an area (not on the boundaries).

        entity
            Number of the line or area on which the hard point will be created.

        nhp
            Number assigned to the hard point.  Defaults to the lowest
            available hard point number.

        label
            If LABEL = COORD, VAL1, VAL2, and VAL3 are the respective global X,
            Y, and Z coordinates.  If LABEL = RATIO, VAL1 is the parameter
            value (this is available only for lines).  Valid parameter values
            are between 0 and 1.  VAL2 and VAL3 are ignored.

        val1
            If LABEL = RATIO, ratio value for line.  If LABEL = COORD, global X
            coordinate value.

        val2
            If LABEL = COORD, global Y coordinate value.

        val3
            If LABEL = COORD, global Z coordinate value.

        Notes
        -----
        The ability to enter a parameter value provides a simple way of
        positioning hard points on lines.  For example, to place a hard point
        halfway along a line, one can simply specify a VAL1 value of 0.5.

        For models imported through the DEFAULT IGES filter, you can place hard
        points on models only by specifying coordinates (you can't place a hard
        point using interactive picking).

        If you issue any commands that update the geometry of an entity, such
        as Boolean or simplification commands, any hard points associated with
        that entity are deleted.  Therefore, you should add any hard points
        after completing the solid model.  If you delete an entity that has
        associated hard points, those hard points are either

        Deleted along with the entity (if the hard point is not associated with
        any other entities).

        Detached from the deleted entity (if the hard point is associated with
        additional entities).

        When archiving your model (CDWRITE), hardpoint information cannot be
        written to the IGES file. The Jobname.cdb file can be written with the
        CDWRITE,DB option.

        Hard points are only applicable for area and volume meshing, not for
        beams.
        """
        command = "HPTCREATE,%s,%s,%s,%s,%s,%s,%s" % (str(type), str(entity), str(nhp), str(label), str(val1), str(val2), str(val3))
        return self.run(command, **kwargs)

    def smcons(self, **kwargs):
        """APDL Command: SMCONS

        Specifies "Constraints on the solid model" as the subsequent status
        topic.

        Notes
        -----
        This is a status [STAT] topic command. Status topic commands are
        generated by the GUI and will appear in the log file (Jobname.LOG) if
        status is requested for some items under Utility Menu> List> Status.
        This command will be immediately followed by a STAT command, which will
        report the status for the specified topic.

        If entered directly into the program, the STAT command should
        immediately follow this command.
        """
        command = "SMCONS," % ()
        return self.run(command, **kwargs)

    def tref(self, tref="", **kwargs):
        """APDL Command: TREF

        Defines the reference temperature for the thermal strain calculations.

        Parameters
        ----------
        tref
            Reference temperature for thermal expansion.

        Notes
        -----
        Defines the reference temperature for the thermal strain calculations
        in structural analyses and explicit dynamic analyses.  Thermal strains
        are given by : α *(T-TREF), where α is the coefficient of thermal
        expansion (for more on this see the Mechanical APDL Theory Reference).
        Input the strain via ALPX, ALPY, ALPZ (the secant or mean coefficient
        value), or CTEX, CTEY, CTEZ (the instantaneous coefficient value), or
        the thermal strain value (THSX, THSY, THSZ). T is the element
        temperature. If α is temperature-dependent, TREF should be in the range
        of temperatures you define using the MPTEMP command.

        Reference temperatures may also be input per material by specifying a
        value on the MP material property command:

        MP,REFT,MAT,C0.

        Only a constant (non-temperature-dependent) value is valid. The value
        input on the TREF command applies to all materials not having a
        specified material property definition.

        To convert temperature-dependent secant coefficients of thermal
        expansion (SCTE) data (properties ALPX, ALPY, ALPZ) from the definition
        temperature to the reference temperature defined via a TREF (or
        MP,REFT) command, issue the MPAMOD command.

        This command is also valid in PREP7.
        """
        command = "TREF,%s" % (str(tref))
        return self.run(command, **kwargs)

    def cbdof(self, fname1="", ext1="", fname2="", ext2="", kpos="", clab="",
              kshs="", tolout="", tolhgt="", tolthk="", **kwargs):
        """APDL Command: CBDOF

        Activates cut-boundary interpolation (for submodeling).

        Parameters
        ----------
        fname1
            File name and directory path (248 characters maximum, including
            directory) from which to read boundary node data. If no specified
            directory path exists, the path defaults to your working directory
            and you can use all 248 characters for the file name.

        ext1
            Filename extension (eight-character maximum).

        --
            Unused field.

        fname2
            File name and directory path (248 characters maximum, including
            directory) to which cut-boundary D commands are written. If no
            specified directory path exists, the path defaults to your working
            directory and you can use all 248 characters for the file name.

        ext2
            Filename extension (eight-character maximum).

        --
            Unused field.

        kpos
            Position on Fname2 to write block of D commands:

            0 - Beginning of file (overwrite existing file).

            1 - End of file (append to existing file).

        clab
            Label (eight characters maximum, including the colon) for this
            block of D commands on Fname2.  his label is appended to the colon
            (:).  Defaults to CBn, where n is the cumulative iteration number
            for the data set currently in the database.  For imaginary data
            (see KIMG on the *SET command), Clab defaults to CIn.

        kshs
            Shell-to-solid submodeling key:

            0 - Solid-to-solid or shell-to-shell submodel.

            1 - Shell-to-solid submodel.

        tolout
            Extrapolation tolerance about elements, based on a fraction of the
            element dimension. Submodel nodes outside the element by more than
            TOLOUT are not accepted as candidates for DOF extrapolation.
            Defaults to 0.5 (50 percent).

        tolhgt
            Height tolerance above or below shell elements, in units of length.
            Used only for shell-to-shell submodeling (KSHS = 0). Submodel nodes
            off the element surface by more than TOLHGT are not accepted as
            candidates for degree-of-freedom interpolation or extrapolation.
            Defaults to 0.0001 times the maximum element dimension.

        tolthk
            Height tolerance above or below shell elements, based on a fraction
            of the shell element thickness. Used only for shell-to-solid
            submodeling (KSHS = 1). Submodel nodes off the element surface by
            more than TOLTHK are not accepted as candidates for DOF
            interpolation or extrapolation. Defaults to 0.1 times the average
            shell thickness.

        Notes
        -----
        File Fname1 should contain a node list for which boundary conditions
        are to be interpolated (NWRITE).  File Fname2 is created to contain
        interpolated boundary conditions written as a block of D commands.

        Boundary conditions are written for the active degree-of-freedom set
        for the element from which interpolation is performed. Interpolation
        occurs on the selected set of elements.  The block of D commands begins
        with an identifying colon label and ends with a /EOF command.  The
        colon label is of the form :Clab (described above).

        Interpolation from multiple results sets can be performed by looping
        through the results file in a user-defined macro.  Additional blocks
        can be appended to Fname2 by using KPOS and unique colon labels.  To
        read the block of commands, issue the /INPUT command with the
        appropriate colon label.

        If the model has coincident (or very close) nodes, the CBDOF must be
        applied to each part of the model separately to ensure that the mapping
        of the nodes is correct.  For example, if nodes belonging to two
        adjacent parts linked by springs are coincident, the operation should
        be performed on each part of the model separately.

        Resume the coarse model database at the beginning of the cut-boundary
        procedure. The database should have been saved after the first coarse
        model solution, as the number of nodes in the database and the results
        file must match, and internal nodes are sometimes created during the
        solution.

        Caution:: : Relaxing the TOLHGT or TOLTHK tolerances to allow submodel
        nodes to be “found” can produce poor submodel results.
        """
        command = "CBDOF,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(fname1), str(ext1), str(fname2), str(ext2), str(kpos), str(clab), str(kshs), str(tolout), str(tolhgt), str(tolthk))
        return self.run(command, **kwargs)

    def nsll(self, type="", nkey="", **kwargs):
        """APDL Command: NSLL

        Selects those nodes associated with the selected lines.

        Parameters
        ----------
        type
            Label identifying the type of node select:

            S - Select a new set (default).

            R - Reselect a set from the current set.

            A - Additionally select a set and extend the current set.

            U - Unselect a set from the current set.

        nkey
            Specifies whether only interior line nodes are to be selected:

            0 - Select only nodes interior to selected lines.

            1 - Select all nodes (interior to line and at keypoints) associated with the
                selected lines.

        Notes
        -----
        Valid only if the nodes were generated by a line meshing operation
        [LMESH, AMESH, VMESH] on a solid model that contains the associated
        lines.

        This command is valid in any processor.
        """
        command = "NSLL,%s,%s" % (str(type), str(nkey))
        return self.run(command, **kwargs)

    def cs(self, kcn="", kcs="", norig="", nxax="", nxypl="", par1="", par2="",
           **kwargs):
        """APDL Command: CS

        Defines a local coordinate system by three node locations.

        Parameters
        ----------
        kcn
            Arbitrary reference number assigned to this coordinate system.
            Must be greater than 10.  A coordinate system previously defined
            with this number will be redefined.

        kcs
            Coordinate system type:

            0 or CART - Cartesian

            1 or CYLIN - Cylindrical (circular or elliptical)

            2 or SPHE - Spherical (or spheroidal)

            3 or TORO - Toroidal

        norig
            Node defining the origin of this coordinate system.  If NORIG = P,
            graphical picking is enabled and all remaining command fields are
            ignored (valid only in the GUI).

        nxax
            Node defining the positive x-axis orientation of this coordinate
            system.

        nxypl
            Node defining the x-y plane (with NORIG and NXAX) in the first or
            second quadrant of this coordinate system.

        par1
            Used for elliptical, spheroidal, or toroidal systems.  If KCS = 1
            or 2, PAR1 is the ratio of the ellipse Y-axis radius to X-axis
            radius (defaults to 1.0 (circle)).  If KCS  = 3, PAR1 is the major
            radius of the torus.

        par2
            Used for spheroidal systems.  If KCS = 2, PAR2 = ratio of ellipse
            Z-axis radius to X-axis radius (defaults to 1.0 (circle)).

        Notes
        -----
        Defines and activates a local right-handed coordinate system by
        specifying three existing nodes: to locate the origin, to locate the
        positive x-axis, and to define the positive x-y plane.  This local
        system becomes the active coordinate system.  See the CLOCAL, CSKP,
        CSWPLA, and LOCAL commands for alternate definitions.  Local coordinate
        systems may be displayed with the /PSYMB command.

        This command is valid in any processor.
        """
        command = "CS,%s,%s,%s,%s,%s,%s,%s" % (str(kcn), str(kcs), str(norig), str(nxax), str(nxypl), str(par1), str(par2))
        return self.run(command, **kwargs)

    # def else(self, **kwargs):
    #     """APDL Command: *ELSE

    #     Separates the final if-then-else block.

    #     Notes
    #     -----
    #     Optional final block separator within an if-then-else construct. See
    #     the *IF for details.  If a batch input stream hits an end-of-file
    #     during a false *IF  condition, the ANSYS run will not terminate
    #     normally. You will need to terminate it externally (use either the
    #     Linux “kill” function or the Windows task manager). The *ELSE command
    #     must appear on the same file as the *IF  command, and all five
    #     characters must be input.

    #     This command is valid in any processor.
    #     """
    #     command = "*ELSE," % ()
    #     return self.run(command, **kwargs)

    def nladaptive(self, component="", action="", criterion="", option="",
                   val1="", val2="", val3="", **kwargs):
        """APDL Command: NLADAPTIVE

        Defines the criteria under which the mesh is refined or modified during
        a nonlinear solution.

        Parameters
        ----------
        component
            Specifies the element component upon which this command should act:

            ALL  - All selected components, or all selected elements if no component is selected
                   (default).

            Name - Component name.

        action
            The action to perform on the selected component(s):

            ADD  - Add a criterion to the database.

            LIST  - List the criteria defined for the specified component(s).

            DELETE  - Delete the criteria defined for the specified component(s).

            ON - Enable the defined criteria for the specified component(s) and specify how
                 frequently and when to check them (via ON,,,VAL1,VAL2,VAL3):

            VAL1 -- Checking frequency. If > 0, check criteria at every VAL1 substeps. If < 0, check criteria at each of the VAL1 points (approximately equally spaced) between VAL2 and VAL3. (Default = -1.) - VAL2 -- Checking start time, where VAL2 < VAL3. (Default is the start time of
                              the load step.)

            VAL3 -- Checking end time, where VAL3 > VAL2. (Default is the end time of the load step.)  - OFF

        criterion
            The type of criterion to apply to the selected component(s):

            CONTACT  - Contact-based. (Valid only for Action = ADD, Action = LIST, or Action =
                       DELETE.)

            ENERGY  - Energy-based. (Valid only for Action = ADD, Action = LIST, or Action = DELETE.)

            BOX  - A position-based criterion, defined by a box. (Valid only for Action = ADD,
                   Action = LIST, or Action = DELETE.)

            MESH  - A mesh-quality-based criterion. (Valid only for Action = LIST, or Action =
                    DELETE.)

            ALL  - All criteria and options. (Valid only for Action = LIST or Action = DELETE.
                   Option and all subsequent arguments are ignored.)

        option
            Criterion option to apply to the selected component(s):

            NUMELEM  - For target elements only, define the minimum number of contact elements to
                       contact with each target element. If this criterion is
                       not satisfied, the program refines the contact elements
                       and the associated solid elements. For this option, VAL1
                       must be a positive integer. (Valid only for Action =
                       ADD, Action = LIST, or Action = DELETE. )

            MEAN  - Check the strain energy of any element that is part of the defined component
                    for the condition Ee ≥ c1 * Etotal / NUME (where c1 = VAL1,
                    Etotal is the total strain energy of the component, and
                    NUME is the number of elements of the component). If this
                    criterion is satisfied at an element, the program refines
                    the element. For this option, VAL1 must be non-negative and
                    defaults to 1. (Valid only for Action = ADD, Action = LIST,
                    or Action = DELETE.)

            XYZRANGE  - Define the location box in which all elements within are to be split or
                        refined. Up to six values following the Option argument
                        (representing the x1, x2, y1, y2, z1, and z2
                        coordinates) are allowed. An unspecified coordinate is
                        not checked. (Valid only for Action = ADD, Action =
                        LIST, or Action = DELETE.)

            SKEWNESS - Mesh-quality control threshold for element SOLID285. Valid values (VAL1) are
                       0.0 through 1.0. Default = 0.9. (Valid only for Action =
                       ADD, Action = LIST, or Action = DELETE.)

            WEAR - This option is valid only for contact elements having surface wear specified
                   (TB,WEAR). Define VAL1 as a critical ratio of magnitude of
                   wear to the average depth of the solid element underlying
                   the contact element. Once this critical ratio is reached for
                   any element, the program morphs the mesh to improve the
                   quality of the elements. VAL1 must be a positive integer.
                   (Valid only for Action = ADD, Action = LIST, or Action =
                   DELETE.) The WEAR criterion cannot be combined with any
                   other criterion.

            ALL  - All options. (Valid only for Action = LIST or Action = DELETE. All subsequent
                   arguments are ignored.)

        Notes
        -----
        If a specified component (Component) is an assembly, the defined
        criterion applies to all element components included in the assembly.

        All components must be defined and selected before the first solve
        (SOLVE), although their nonlinear adaptivity criteria can be modified
        from load step to load step, and upon restart. For nonlinear adaptivity
        to work properly, ensure that all components are selected before each
        solve.

        After using this command to define a new criterion, the new criterion
        becomes active and is checked one time during each load step, roughly
        in mid-loading (unless this behavior is changed via Action = ON).

        When a criterion is defined, it overwrites a previously defined
        criterion (if one exists) through the same component, or through the
        component assembly that includes the specified component.

        During solution, the same criteria defined for an element through
        different components are combined, and the tightest criteria and action
        control (Action,ON,,,VAL1) are used. If an ON action is defined by a
        positive VAL1 value through one component and a negative VAL1 value
        through another, the program uses the positive value.

        For Action = ON, if VAL2 (start time) and/or VAL3 (end time) are
        unspecified or invalid, the program uses the start and/or end time
        (respectively) of the load step. If VAL1 < 0, the program checks VAL1
        points between VAL2 and VAL3. The time interval between each check
        points is determined by (VAL3 - VAL2) / (VAL1 + 1), with the first
        check point as close to VAL2 + (VAL3 - VAL2) / (VAL1 + 1) as possible.
        Fewer check points can be used if the number of substeps during
        solution is insufficient (as the program can only check at the end of a
        substep).

        Option = SKEWNESS applies to linear tetrahedral element SOLID285 only.
        When the skewness of a SOLID285 element is >= the defined value, the
        element is used as the core (seed) element of the remeshed region(s).
        If this criterion is used together with any other criteria for the same
        component, the other criteria defined for the component are ignored.
        The most desirable skewness value is 0, applicable when the element is
        a standard tetrahedral element; the highest value is 1, applicable when
        the element becomes flat with zero volume. For more information about
        skewness and remeshing, see Mesh Nonlinear Adaptivity in the Advanced
        Analysis Guide.

        For more granular control of the source mesh geometry, see NLMESH.
        """
        command = "NLADAPTIVE,%s,%s,%s,%s,%s,%s,%s" % (str(component), str(action), str(criterion), str(option), str(val1), str(val2), str(val3))
        return self.run(command, **kwargs)

    def atran(self, kcnto="", na1="", na2="", ninc="", kinc="", noelem="",
              imove="", **kwargs):
        """APDL Command: ATRAN

        Transfers a pattern of areas to another coordinate system.

        Parameters
        ----------
        kcnto
            Reference number of coordinate system where the pattern is to be
            transferred.  Transfer occurs from the active coordinate system.
            The coordinate system type and parameters of KCNTO must be the same
            as the active system.

        na1, na2, ninc
            Transfer area pattern beginning with NA1 to NA2 (defaults to NA1)
            in steps of NINC (defaults to 1).  If NA1 = ALL, NA2 and NINC are
            ignored and the pattern is all selected areas [ASEL].  If NA1 = P,
            graphical picking is enabled and all remaining arguments are
            ignored (valid only in the GUI).  A component name may also be
            substituted for NA1 (NA2 and NINC are ignored).

        kinc
            Keypoint increment between sets.  If zero, the lowest available
            keypoint numbers are assigned [NUMSTR].

        noelem
            Specifies whether elements and nodes are also to be generated:

            0 - Generate nodes and elements associated with the original areas, if they exist.

            1 - Do not generate nodes and elements.

        imove
            Specifies whether to redefine the existing areas:

            0 - Generate additional areas.

            1 - Move original areas to new position retaining the same keypoint numbers (KINC
                and NOELEM are ignored).  Valid only if the old areas are no
                longer needed at their original positions.  Corresponding
                meshed items are also moved if not needed at their original
                position.

        Notes
        -----
        Transfers a pattern of areas (and their corresponding lines, keypoints
        and mesh) from one coordinate system to another (see analogous node
        TRANSFER command).  The MAT, TYPE, REAL, and ESYS attributes are based
        upon the areas in the pattern and not upon the current settings.
        Coordinate systems may be translated and rotated relative to each
        other.  Initial pattern may be generated in any coordinate system.
        However, solid modeling in a toroidal coordinate system is not
        recommended.  Coordinate and slope values are interpreted in the active
        coordinate system and are transferred directly.  Areas are generated as
        described in the AGEN command.
        """
        command = "ATRAN,%s,%s,%s,%s,%s,%s,%s" % (str(kcnto), str(na1), str(na2), str(ninc), str(kinc), str(noelem), str(imove))
        return self.run(command, **kwargs)

    def cycspec(self, label="", node="", item="", comp="", **kwargs):
        """APDL Command: CYCSPEC

        Defines the set of result items for a subsequent CYCCALC command in
        postprocessing a cyclic harmonic mode-superposition analysis.

        Parameters
        ----------
        label
            One of the following labels:

            ADD - Adds a new specification to the set (default). The maximum number of
                  specifications that can be defined is 50.

            LIST - Lists the current set of specifications. Node, Item, Comp are ignored.

            ERASE - Erases the current set of specifications. Node, Item, Comp are ignored.

            DELETE - Deletes an existing specification. Item, Comp are ignored.

        node
            The node at which to evaluate the results. If Node is a nodal
            component, then all nodes in the component are included. All
            sectors containing this node (or set of nodes) are evaluated.

        item
            Specifies the type of values to evaluate:

            U - Displacement

            S - Stress

            EPEL - Elastic strain

        comp
            Specifies the specific component of displacement, stress, or strain
            to evaluate:

            X,Y,Z - Direct components

            XY,YZ,XZ - Shear components (stress and strain only)

            1,2,3 - Principal values (stress and strain only)

            EQV - Equivalent value (stress and strain only)

            SUM - Vector sum (displacement only)

            NORM - L2 norm for the set of nodes (displacement only)

        Notes
        -----
        Up to 50 specifications can be defined for use in a subsequent CYCCALC
        command. If more than 50 specifications are desired, erase the table
        after the CYCCALC operation and add new specifications and repeat the
        CYCCALC command. All the specified nodes, items, and components are
        evaluated for all sectors and the maximum amplitude value output. For
        combined stresses and strains (Comp = 1,2,3 or EQV) or displacement
        vector sum (Comp = SUM), a 360 degree phase sweep is performed at each
        location to determine the maximum.

        Additional POST1 controls are used to refine the specification. For
        component values, components are in the RSYS direction. For shell
        elements, the results are at the SHELL location. For EPEL,EQV, the
        results are based on the EFFNU value on the AVPRIN command. The
        controls active when the CYCCALC command is issued determine the result
        values. If results at another SHELL location are desired, issue the new
        SHELL command and then re-issue the CYCCALC command.

        If a single node is input, the Item/Comp value at that location in each
        sector is output. If a node component is given, then the maximum
        Item/Comp value within the set of nodes of each sector is output, one
        value for each sector (the node of the maximum may vary from sector to
        sector). For stress and strain items, only corner nodes are valid.

        For the displacement norm option (Item = U, Comp = NORM), the L2 norm
        computed from all the nodes in the component is output, one per sector.
        """
        command = "CYCSPEC,%s,%s,%s,%s" % (str(label), str(node), str(item), str(comp))
        return self.run(command, **kwargs)

    def adams(self, nmodes="", kstress="", kshell="", **kwargs):
        """APDL Command: ADAMS

        Performs solutions and writes flexible body information to a modal
        neutral file (Jobname.MNF) for use in an ADAMS analysis.

        Parameters
        ----------
        nmodes
            Number of normal modes to be written to Jobname.MNF file (no
            default).

        kstress
            Specifies whether to write stress or strain results:

            0 - Do not write stress or strain results (default).

            1 - Write stress results.

            2 - Write strain results.

            3 - Write both stress and strain results.

        kshell
            Shell element output location. This option is valid only for shell
            elements.

            0, 1 - Shell top surface (default).

            2 - Shell middle surface.

            3 - Shell bottom surface.

        Notes
        -----
        ADAMS invokes a predefined ANSYS macro that solves a series of analyses
        and then writes the modal neutral file, Jobname.MNF. This file can be
        imported into the ADAMS program in order to perform a rigid body
        dynamics simulation. For detailed information on how to use the ADAMS
        command macro to create a modal neutral file, see Rigid Body Dynamics
        and the ANSYS-ADAMS Interface in the Substructuring Analysis Guide.

        Before running the ADAMS command macro, you must specify the units with
        the /UNITS command. The interface points should be the only selected
        nodes when the command macro is initiated. (Interface points are nodes
        where constraints may be applied in ADAMS.) Only selected elements will
        be considered in the calculations.

        By default, stress and strain data is transferred to the ADAMS program
        for all nodes, as specified by the KSTRESS value.  If you want to
        transfer stress/strain data for only a subset of nodes, select the
        desired subset and create a node component named "STRESS" before
        running the ADAMS command macro.  For example, you may want to select
        exterior nodes for the purpose of visualization in the ADAMS program.

        The default filename for the modal neutral file is Jobname.MNF. In
        interactive (GUI) mode, you can specify a filename other than
        Jobname.MNF. In batch mode, there is no option to change the filename,
        and the modal neutral file is always written to Jobname.MNF.
        """
        command = "ADAMS,%s,%s,%s" % (str(nmodes), str(kstress), str(kshell))
        return self.run(command, **kwargs)

    def write(self, fname="", **kwargs):
        """APDL Command: WRITE

        Writes the radiation matrix file.

        Parameters
        ----------
        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        Notes
        -----
        Writes radiation matrix file (File.SUB) for input to the substructure
        thermal "use" pass.  Subsequent WRITE operations to the same file
        overwrite the file.
        """
        command = "WRITE,%s" % (str(fname))
        return self.run(command, **kwargs)

    def mpdata(self, lab="", mat="", sloc="", c1="", c2="", c3="", c4="",
               c5="", c6="", **kwargs):
        """APDL Command: MPDATA

        Defines property data to be associated with the temperature table.

        Parameters
        ----------
        lab
            Valid property label.  Applicable labels are listed under "Material
            Properties" in the input table for each element type in the Element
            Reference.  See Linear Material Properties in the Mechanical APDL
            Material Reference for more complete property label definitions:

            ALPD - Mass matrix multiplier for damping.

            ALPX - Secant coefficients of thermal expansion (also ALPY, ALPZ).  (See also MPAMOD
                   command for adjustment to reference temperature).

            BETD - Stiffness matrix multiplier for damping.

            BETX - Coefficient of diffusion expansion (also BETY, BETZ)

            C - Specific heat.

            CREF - Reference concentration (may not be temperature dependent)

            CSAT - Saturated concentration

            CTEX - Instantaneous coefficients of thermal expansion (also CTEY, CTEZ).

            DENS - Mass density.

            DMPR - Constant material damping coefficient.

            DXX - Diffusivity coefficients (also DYY, DZZ)

            EMIS - Emissivity.

            ENTH - Enthalpy.

            EX - Elastic moduli (also EY, EZ).

            GXY - Shear moduli (also GYZ, GXZ).

            HF - Convection or film coefficient.

            KXX - Thermal conductivities (also KYY, KZZ).

            LSST - Dielectric loss tangent.

            MGXX - Magnetic coercive forces (also MGYY, MGZZ).

            MU - Coefficient of friction.

            MURX - Magnetic relative permeabilities (also MURY, MURZ).

            NUXY - Minor Poisson's ratios (also NUYZ, NUXZ).

            PERX - Electric relative permittivities (also PERY, PERZ).

            PRXY - Major Poisson's ratios (also PRYZ, PRXZ).

            QRATE - Heat generation rate.

            REFT - Reference temperature (may not be temperature dependent).

            RH - Hall Coefficient.

            RSVX - Electrical resistivities (also RSVY, RSVZ).

            SBKX - Seebeck coefficients (also SBKY, SBKZ).

            SONC - Sonic velocity.

            THSX - Thermal strain (also THSY, THSZ).

            VISC - Viscosity.

        mat
            Material reference number to be associated with the elements
            (defaults to 1 if you specify zero or no material number).

        sloc
            Starting location in table for generating data.  For example, if
            SLOC = 1, data input in the C1 field is the first constant in the
            table.  If SLOC = 7, data input in the C1 field is the seventh
            constant in the table, etc.  Defaults to the last location filled +
            1.

        c1, c2, c3, . . . , c6
            Property data values assigned to six locations starting with SLOC.
            If a value is already in this location, it is redefined.  A blank
            (or zero) value for C1 resets the previous value in SLOC to zero.
            A value of zero can only be assigned by C1.  Blank (or zero) values
            for C2 to C6 leave the corresponding previous values unchanged.

        Notes
        -----
        Defines a table of property data to be associated with the temperature
        table.  Repeat MPDATA command for additional values (100 maximum).
        Temperatures must be defined first [MPTEMP].  Also stores assembled
        property function table (temperature and data) in virtual space.

        This command is also valid in SOLUTION.

        Without Emag enabled, the MUR_ and MG__ properties are not allowed.  In
        ANSYS Professional, all structural and thermal properties are allowed
        except ALPD, BETD, and MU.  In ANSYS Emag, only the RSV_, PER_, MUR_,
        and MG__ properties are allowed. Only products that include ANSYS Emag
        can use the LSST property. The SBK_ property is only available in ANSYS
        Multiphysics and ANSYS PrepPost.
        """
        command = "MPDATA,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(lab), str(mat), str(sloc), str(c1), str(c2), str(c3), str(c4), str(c5), str(c6))
        return self.run(command, **kwargs)

    def mfrc(self, freq="", maxfiles="", **kwargs):
        """APDL Command: MFRC

        Controls file writing for multiframe restarts for the ANSYS Multi-field
        solver.

        Parameters
        ----------
        freq
            Frequency at which the .Xnnn files are written.

            0 - Do not write any .Xnnn files for this simulation

            LAST - Write the .Xnnn files for the last multifield time step (default).

            N - If N is a positive number, write the .Xnnn file every Nth multifield time step.

        maxfiles
            Maximum number of .Xnnn files to save for a multifield analysis.

            0 - Do not overwrite existing .Xnnn files (default). The total maximum number of
                .Xnnn files for one run is 999. If this number is reached
                before the analysis is complete, the analysis will continue,
                but will no longer write .Xnnn files.

            N - The maximum number of .Xnnn file to keep for this multifield simulation. When
                this number of .Rnnn have been written, ANSYS will overwrite
                the first .Xnnn file of the subsequent multifield time step.

        Notes
        -----
        This command sets up the restart parameters for a multiframe restart,
        allowing you to restart an analysis from any multifield time step for
        which there is a .Rnnn file. You can perform a multiframe restart only
        for nonlinear static and full transient structural, thermal and
        thermal- structural (see RESCONTROL for details).

        If you have many multifield time steps, and are writing .Xnnn files
        frequently, use MAXFILES to limit the number of .Xnnn files saved,
        since these files can fill up your disk quickly.

        For a CFX analysis, you must also configure the MFOUTPUT and MFRSTART
        settings to ensure consistent time points for postprocessing and
        restart simulation.

        For MFX simulation, the RESCONTROL command will be ignored.

        Default Behavior

        In nonlinear static and full transient analyses, the default behavior
        is multiframe restart. (MFRC,LAST). By default, the .Rnnn file is
        written at the last multifield time step . An .Rnnn file and
        corresponding load set of .ldhi files is also written at the multifield
        time step prior to the abort point of the run if an abort file was
        used, or if the job terminated because of a failure to converge or some
        other solution error. No information at the aborted multifield time
        step is saved in either the .Rnnn file or the .ldhi file.

        This command cannot be issued after restarting a multifield analysis.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "MFRC,%s,%s" % (str(freq), str(maxfiles))
        return self.run(command, **kwargs)

    def mmass(self, option="", zpa="", **kwargs):
        """APDL Command: MMASS

        Specifies the missing mass response calculation.

        Parameters
        ----------
        option
            Flag to activate or deactivate missing mass response calculation.

            0 (OFF or NO) - Deactivate (default).

            1 (ON or YES) - Activate.

        zpa
            Zero Period Acceleration Value. If a scale factor FACT is defined
            on the SVTYP command, it is applied to this value.

        Notes
        -----
        The missing mass calculation is valid only for single point excitation
        response spectrum analysis (SPOPT, SPRS) and for multiple point
        response spectrum analysis (SPOPT, MPRS) performed with base excitation
        using acceleration response spectrum loading. Missing mass is supported
        in a spectrum analysis only when the preceding modal analysis is
        performed with the Block Lanczos, PCG Lanczos, Supernode, or Subspace
        eigensolver (Method =LANB, LANPCG, SNODE, or SUBSP on the MODOPT
        command).

        The velocity solution is not available (Label = VELO on the combination
        command: SRSS, CQC...) when the missing mass calculation is activated.

        The missing mass calculation is not supported when the spectrum
        analysis is based on a linear perturbation modal analysis performed
        after a nonlinear base analysis.

        The missing mass is not supported when superelements are present.

        To take into account the contribution of the truncated modes, the
        residual vector (RESVEC) can be used in place of the missing mass
        response. This is of particular interest if the velocity solution is
        requested or if a nonlinear prestress is included in the analysis
        (linear perturbation), or if a superelement is present, since the
        missing mass cannot be used in these cases.

        In a multiple point response spectrum analysis (SPOPT,MPRS), the MMASS
        command must precede the participation factor calculation command
        (PFACT).

        This command is also valid in PREP7.
        """
        command = "MMASS,%s,%s" % (str(option), str(zpa))
        return self.run(command, **kwargs)

    def trpdel(self, ntrp1="", ntrp2="", trpinc="", **kwargs):
        """APDL Command: TRPDEL

        Deletes particle flow or charged particle trace points.

        Parameters
        ----------
        ntrp1, ntrp2, trpinc
            Delete points from NTRP1 to NTRP2 (defaults to NTRP1) in steps of
            TRPINC (defaults to 1).  If NTRP1 = ALL, NTRP2 and TRPINC are
            ignored and all trace points are deleted.  If NTRP1 = P, graphical
            picking is enabled and all remaining command fields are ignored
            (valid only in the GUI).

        Notes
        -----
        Deletes particle flow or charged particle trace points defined with the
        TRPOIN command.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "TRPDEL,%s,%s,%s" % (str(ntrp1), str(ntrp2), str(trpinc))
        return self.run(command, **kwargs)

    def estif(self, kmult="", **kwargs):
        """APDL Command: ESTIF

        Specifies the matrix multiplier for deactivated elements.

        Parameters
        ----------
        kmult
            Stiffness matrix multiplier for deactivated elements (defaults to
            1.0E-6).

        Notes
        -----
        Specifies the stiffness matrix multiplier for elements deactivated with
        the EKILL command (birth and death).

        This command is also valid in PREP7.
        """
        command = "ESTIF,%s" % (str(kmult))
        return self.run(command, **kwargs)

    def wsprings(self, **kwargs):
        """APDL Command: WSPRINGS

        Creates weak springs on corner nodes of a bounding box of the currently
        selected elements.

        Notes
        -----
        WSPRINGS invokes a predefined ANSYS macro that is used during the
        import of loads from the ADAMS program into the ANSYS program. WSPRINGS
        creates weak springs on the corner nodes of the bounding box of the
        currently selected elements. The six nodes of the bounding box are
        attached to ground using COMBIN14 elements. The stiffness is chosen as
        a small number and can be changed by changing the real constants of the
        COMBIN14 elements. This command works only for models that have a
        geometric extension in two or three dimensions. One dimensional
        problems (pure beam in one axis) are not supported.

        For more information on how WSPRINGS is used during the transfer of
        loads from the ADAMS program to ANSYS, see Import Loads into ANSYS in
        the Substructuring Analysis Guide.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "WSPRINGS," % ()
        return self.run(command, **kwargs)

    def fsnode(self, node="", nev="", nlod="", **kwargs):
        """APDL Command: FSNODE

        Calculates and stores the stress components at a node for fatigue.

        Parameters
        ----------
        node
            Node number for which stress components are stored.

        nev
            Event number to be associated with these stresses (defaults to 1).

        nlod
            Loading number to be associated with these stresses (defaults to
            1).

        Notes
        -----
        Calculates and stores the total stress components at a specified node
        for fatigue.  Stresses are stored according to the event number and
        loading number specified.  The location is associated with that
        previously defined for this node [FL] or else it is automatically
        defined.  Stresses are stored as six total components (SX through SYZ).
        Temperature and current time are also stored along with the total
        stress components.  Calculations are made from the stresses currently
        in the database (last SET or LCASE command).  Stresses stored are in
        global Cartesian coordinates, regardless of the active results
        coordinate system [RSYS].  The FSLIST command may be used to list
        stresses.  The FS command can be used to modify stored stresses.
        """
        command = "FSNODE,%s,%s,%s" % (str(node), str(nev), str(nlod))
        return self.run(command, **kwargs)

    def edclist(self, num="", **kwargs):
        """APDL Command: EDCLIST

        Lists contact entity specifications in an explicit dynamics analysis.

        Parameters
        ----------
        num
            Number identifying contact entity to be listed. Use NUM = ALL to
            list all contact entities (ALL is the default).

        Notes
        -----
        Lists contact entity specifications previously defined with the EDCGEN
        command. The listing will include any contact parameters defined using
        the EDCMORE command.

        This command is also valid in SOLUTION.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDCLIST,%s" % (str(num))
        return self.run(command, **kwargs)

    def noerase(self, **kwargs):
        """APDL Command: /NOERASE

        Prevents the screen erase between displays.

        Notes
        -----
        Preventing the normal screen erase between requested displays allows
        you to overlay multiple views.

        Clearing the screen with the ERASE command (Utility Menu> PlotCtrls>
        Erase Options> Erase screen) active simply clears the display area.
        Subsequent replots will provide the cumulative plots previously
        generated by the /NOERASE command.

        For 3-D devices, you can issue /DV3D,DELS to suppress repeated screen
        overlays and generate clear contour plots.

        Use the /ERASE command to reactivate automatic screen erase.

        For 3-D devices (/SHOW,3D), the model in all active windows will be the
        same, even if you issue a different display command (NPLOT, EPLOT,
        etc.) for each active window.  Use the Multi-Plot command (GPLOT) to
        display different entities, in different windows, on 3-D devices.

        This command is valid in any processor.
        """
        command = "/NOERASE," % ()
        return self.run(command, **kwargs)

    def spopt(self, sptype="", nmode="", elcalc="", modereusekey="", **kwargs):
        """APDL Command: SPOPT

        Selects the spectrum type and other spectrum options.

        Parameters
        ----------
        sptype
            Spectrum type:

            SPRS - Single point excitation response spectrum (default).  See also the SVTYP
                   command.

            MPRS - Multiple point excitation response spectrum.

            DDAM - Dynamic design analysis method.

            PSD - Power spectral density.

        nmode
            Use the first NMODE modes from the modal analysis.  Defaults to all
            extracted modes, as specified by the MODOPT and BUCOPT commands.
            NMODE cannot be larger than 10000.

        elcalc
            Element results calculation key (for Sptype = PSD only):

            NO - Do not calculate element results and reaction forces (default).

            YES - Calculate element results and reaction forces, as well as the nodal degree of
                  freedom solution.

        modereusekey
            Key for existing MODE file reuse when running multiple spectrum
            analyses:

            NO - No spectrum analysis has been performed yet (default).

            YES - This is not the first spectrum analysis.  The MODE file will be reused and the
                  necessary files will be cleaned up for the new spectrum
                  analysis.

        Notes
        -----
        Valid only for a spectrum analysis (ANTYPE,SPECTR).  This operation
        must be preceded by a modal solution (ANTYPE,MODAL) with the
        appropriate files available.  Both the spectrum analysis and the
        preceding modal analysis must be performed under the same ANSYS version
        number.

        If used in SOLUTION, this command is valid only within the first load
        step.

        This command is also valid in PREP7.

        Only Sptype = SPRS is allowed in ANSYS Professional.
        """
        command = "SPOPT,%s,%s,%s,%s" % (str(sptype), str(nmode), str(elcalc), str(modereusekey))
        return self.run(command, **kwargs)

    def vdrag(self, na1="", na2="", na3="", na4="", na5="", na6="", nlp1="",
              nlp2="", nlp3="", nlp4="", nlp5="", nlp6="", **kwargs):
        """APDL Command: VDRAG

        Generates volumes by dragging an area pattern along a path.

        Parameters
        ----------
        na1, na2, na3, . . . , na6
            List of areas in the pattern to be dragged (6 maximum if using
            keyboard entry).  If NA1 = P, graphical picking is enabled and all
            remaining command fields are ignored (valid only in the GUI).  If
            NA1 = ALL, all selected areas will be swept along the path.  A
            component name may also be substituted for NA1.

        nlp1, nlp2, nlp3, . . . , nlp6
            List of lines defining the path along which the pattern is to  be
            dragged (6 maximum if using keyboard entry).  Must be a continuous
            set of lines.  To be continuous, adjacent lines must share the
            connecting keypoint (the end keypoint of one line must also be
            first keypoint of the next line).

        Notes
        -----
        Generates volumes (and their corresponding keypoints, lines, and areas)
        by sweeping a given area pattern along a characteristic drag path.  If
        the drag path consists of multiple lines, the drag direction is
        determined by the sequence in which the path lines are input (NLP1,
        NLP2, etc.).  If the drag path is a single line (NLP1), the drag
        direction is from the keypoint on the drag line that is closest to the
        first keypoint of the given area pattern to the other end of the drag
        line.

        The magnitude of the vector between the keypoints of the given pattern
        and the first path keypoint remains constant for all generated keypoint
        patterns and the path keypoints.  The direction of the vector relative
        to the path slope also remains constant so that patterns may be swept
        around curves.  Lines are generated with the same shapes as the given
        pattern and the path lines.

        Keypoint, line, area, and volume numbers are automatically assigned
        (beginning with the lowest available values [NUMSTR]).  Adjacent lines
        use a common keypoint, adjacent areas use a common line, and adjacent
        volumes use a common area.  For best results, the entities to be
        dragged should be orthogonal to the start of the drag path.  Drag
        operations that produce an error message may create some of the desired
        entities prior to terminating.

        If element attributes have been associated with the input area via the
        AATT command, the opposite area generated by the VDRAG operation will
        also have those attributes (i.e., the element attributes from the input
        area are copied to the opposite area).  Note that only the area
        opposite the input area will have the same attributes as the input
        area; the areas adjacent to the input area will not.

        If the input areas are meshed or belong to a meshed volume, the area(s)
        can be extruded to a 3-D mesh.  Note that the NDIV argument of the
        ESIZE command should be set before extruding the meshed areas.
        Alternatively, mesh divisions can be specified directly on the drag
        line(s) (LESIZE).  See the Modeling and Meshing Guide for more
        information.

        You can use the VDRAG command to generate 3-D interface element meshes
        for elements INTER194 and INTER195. When generating interface element
        meshes using VDRAG, you must specify the line divisions to generate one
        interface element directly on the drag line using the LESIZE command.
        The source area to be extruded becomes the bottom surface of the
        interface element. Interface elements must be extruded in what will
        become the element's local x direction, that is, bottom to top.
        """
        command = "VDRAG,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(na1), str(na2), str(na3), str(na4), str(na5), str(na6), str(nlp1), str(nlp2), str(nlp3), str(nlp4), str(nlp5), str(nlp6))
        return self.run(command, **kwargs)

    def dlist(self, node1="", node2="", ninc="", **kwargs):
        """APDL Command: DLIST

        Lists DOF constraints.

        Parameters
        ----------
        node1, node2, ninc
            List constraints for nodes NODE1 to NODE2 (defaults to NODE1) in
            steps of NINC (defaults to 1).  If ALL (default), NODE2 and NINC
            are ignored and constraints for all selected nodes [NSEL] are
            listed.  If NODE1 = P, graphical picking is enabled and all
            remaining command fields are ignored (valid only in the GUI).  A
            component name may also be substituted for NODE1(NODE2 and NINC are
            ignored).

        Notes
        -----
        Listing applies to the selected nodes [NSEL] and the selected degree of
        freedom labels [DOFSEL].

        This command is valid in any processor.
        """
        command = "DLIST,%s,%s,%s" % (str(node1), str(node2), str(ninc))
        return self.run(command, **kwargs)

    def vtype(self, nohid="", nzone="", **kwargs):
        """APDL Command: VTYPE

        Specifies the viewing procedure used to determine the form factors for
        the Radiation Matrix method.

        Parameters
        ----------
        nohid
            Type of viewing procedure:

            0 - Hidden procedure.

            1 - Non-hidden (faster, but less general) procedure.

        nzone
            Number of sampling zones for the hidden procedure (100 maximum for
            3-D, 1000 maximum for 2-D).  Defaults to 20 for 3-D, 200 for 2-D.
            Number of points is 2*NZONE for 2-D and 2*NZONE*(NZONE+1) for 3-D.
        """
        command = "VTYPE,%s,%s" % (str(nohid), str(nzone))
        return self.run(command, **kwargs)

    def edcontact(self, sfsi="", rwpn="", ipck="", shtk="", peno="", stcc="",
                  orie="", cspc="", penchk="", **kwargs):
        """APDL Command: EDCONTACT

        Specifies contact surface controls for an explicit dynamics analysis.

        Parameters
        ----------
        sfsi
            Scale factor for sliding interface penalties. Defaults to 0.1.

        rwpn
            Scale factor for rigid wall penalties (defaults to 0). If RWPN = 0,
            rigid bodies interacting with rigid walls are not considered. If
            RWPN>0, rigid bodies interact with fixed rigid walls. A value of
            1.0 should be optimal; however, this may be problem dependent.

        ipck
            Initial contact surface penetration checking option:

            1 - No checking.

            2 - Full check of initial penetration is performed (default).

        shtk
            Shell thickness contact option for surface-to-surface and nodes-to-
            surface contact (see Notes below):

            0 - Thickness is not considered (default).

            1 - Thickness is considered, except in rigid bodies.

            2 - Thickness is considered, including rigid bodies.

        peno
            Penalty stiffness option (options 4 and 5 are useful for metal
            forming calculations):

            1 - Minimum of master segment and slave node (default).

            2 - Use master segment stiffness.

            3 - Use slave node value.

            4 - Use area or mass weighted slave node value.

            5 - Use slave node value inversely proportional to shell thickness. (This may
                require special scaling and is not generally recommended.)

        stcc
            Shell thickness change option for single surface contact:

            1 - Shell thickness changes are not considered (default).

            2 - Shell thickness changes are included.

        orie
            Option for automatic reorientation of contact surface segments
            during initialization:

            1 - Activate for automated (part ID) input only (default).

            2 - Activate for manual (nodal component) and automated (part ID) input.

            3 - Do not activate.

        cspc
            Contact surface penetration check multiplier, used if small
            penetration checking is on (PENCHK = 1 or 2). Defaults to 4.

        penchk
            Small penetration check, used only for contact types STS, NTS,
            OSTS, TNTS, and TSTS. If the contact surface node penetrates more
            than the target thickness times CSPC, the penetration is ignored
            and the contacting node is set free. The target thickness is the
            element thickness for shell elements, or 1/20 of the shortest
            diagonal for solid elements.

            0 - Penetration checking is off (default).

            1 - Penetration checking is on.

            2 - Penetration checking is on, but shortest diagonal is used.

        Notes
        -----
        The thickness offsets are always included in single surface, automatic
        surface-to-surface, and automatic nodes-to-surface contact. The shell
        thickness change option must be used [EDSHELL,,,1] and a nonzero value
        must be specified for SHTK before the shell thickness changes can be
        included in the surface-to-surface contact type. Additionally, STCC
        must be set to 2 if thickness changes are to be included in the single
        surface contact algorithms.

        To reset the contact options to default values, issue the EDCONTACT
        command with no fields specified.

        This command is also valid in SOLUTION.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDCONTACT,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(sfsi), str(rwpn), str(ipck), str(shtk), str(peno), str(stcc), str(orie), str(cspc), str(penchk))
        return self.run(command, **kwargs)

    def cmmod(self, cname="", keyword="", value="", **kwargs):
        """APDL Command: CMMOD

        Modifies the specification of a component.

        Parameters
        ----------
        cname
            Name of the existing component or assembly to be modified.

        keyword
            The label identifying the type of value to be modified.

        value
            If Keyword is NAME, then the value is the alphanumeric label to be
            applied. See the CM command for naming convention details. If a
            component named Value already exists, the command will be ignored
            and an error message will be generated.

        Notes
        -----
        The naming conventions for components, as specified in the CM command,
        apply for CMMOD (32 characters, “ALL”, “STAT” and “DEFA” are not
        allowed, etc.). However, if you choose a component name that is already
        designated for another component, an error message will be issued and
        the command will be ignored.

        This command is valid in any processor.
        """
        command = "CMMOD,%s,%s,%s" % (str(cname), str(keyword), str(value))
        return self.run(command, **kwargs)

    def unpause(self, **kwargs):
        """APDL Command: UNPAUSE

        Restores use of a temporarily released product license.

        Notes
        -----
        The UNPAUSE command restores use of a temporarily released (paused)
        product license. The command is valid only after a previously issued
        PAUSE command.

        When use of the product license is paused via the PAUSE command, no
        other operation (other than SAVE or /EXIT) is possible until you issue
        the UNPAUSE command.

        For more information, see the documentation for the PAUSE command and
        the ANSYS, Inc. Licensing Guide.
        """
        command = "UNPAUSE," % ()
        return self.run(command, **kwargs)

    def cyl5(self, xedge1="", yedge1="", xedge2="", yedge2="", depth="",
             **kwargs):
        """APDL Command: CYL5

        Creates a circular area or cylindrical volume by end points.

        Parameters
        ----------
        xedge1, yedge1
            Working plane X and Y coordinates of one end of the circle or
            cylinder face.

        xedge2, yedge2
            Working plane X and Y coordinates of the other end of the circle or
            cylinder face.

        depth
            The perpendicular distance (either positive or negative based on
            the working plane Z direction) from the working plane representing
            the depth of the cylinder.  If DEPTH = 0 (default), a circular area
            is created on the working plane.

        Notes
        -----
        Defines a circular area anywhere on the working plane or a cylindrical
        volume with one face anywhere on the working plane by specifying
        diameter end points.  For a solid cylinder of 360°, the top and bottom
        faces will be circular (each area defined with four lines) and they
        will be connected with two surface areas (each spanning 180°).  See the
        CYL4, PCIRC, and CYLIND commands for alternate ways to create circles
        and cylinders.
        """
        command = "CYL5,%s,%s,%s,%s,%s" % (str(xedge1), str(yedge1), str(xedge2), str(yedge2), str(depth))
        return self.run(command, **kwargs)

    def fmagsum(self, cnam1="", cnam2="", cnam3="", cnam4="", cnam5="",
                cnam6="", cnam7="", cnam8="", cnam9="", **kwargs):
        """APDL Command: FMAGSUM

        Summarizes electromagnetic force calculations on element components.

        Parameters
        ----------
        cnam1, cnam2, cnam3, . . . , cnam9
            Names of existing element components for which Maxwell or virtual
            work boundary conditions were applied in the preprocessor.  Must be
            enclosed in single quotes (e.g., `Cnam1') when the command is
            manually typed in.

        Notes
        -----
        FMAGSUM invokes an ANSYS macro that summarizes the Maxwell and virtual
        work forces.  The element components must have had appropriate Maxwell
        or virtual work boundary conditions established in the preprocessor
        prior to solution in order to retrieve forces (see FMAGBC, SF, BF
        commands). The forces are also stored on a per-element basis for the
        adjacent air layer surrounding the components in the element table
        [ETABLE].  Maxwell forces are stored as items FMX_X, FMX_Y, and FMX_Z,
        and virtual work forces are stored as items FVW_X, FVW_Y, and FVW_Z.
        Use the PLETAB and PRETAB commands to plot and list the element table
        items.

         If using elements PLANE121, SOLID122, SOLID123, PLANE233, SOLID236,
        and SOLID237, use EMFT to summarize electromagnetic force and torque.

        FMAGSUM can also be used to summarize time-average forces from a 2-D
        harmonic analysis.
        """
        command = "FMAGSUM,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(cnam1), str(cnam2), str(cnam3), str(cnam4), str(cnam5), str(cnam6), str(cnam7), str(cnam8), str(cnam9))
        return self.run(command, **kwargs)

    def ui(self, func="", type="", format="", screen="", color="", krev="",
           orient="", compress="", quality="", **kwargs):
        """APDL Command: /UI

        Activates specified GUI dialog boxes.

        Parameters
        ----------
        func
            Label identifying the dialog box to be activated:

            HELP - Activates the online help system. Valid only in non-UI graphics mode
                   (/MENU,GRPH).

            VIEW - Activates the Pan, Zoom, Rotate dialog box

            WPSE - Activates the Working Plane Settings dialog box.

            WPVI - Activates the Offset Working Plane dialog box.

            RESULT - Activates the Query Picking Menu for reviewing results.

            QUERY - Activates the Query Picked Entities (preprocess) dialog box.

            COPY - Activates the Hard Copy dialog box.

            ANNO - Activates the 2D Annotation dialog box.

            AN3D - Activates the 3D Annotation dialog box.

            SELECT - Activates the Select Entities dialog box.

            NSEL - Activates a picking menu to select nodes.

            ESEL - Activates a picking menu to select elements.

            KSEL - Activates a picking menu to select keypoints.

            LSEL - Activates a picking menu to select lines.

            ASEL - Activates a picking menu to select areas.

            VSEL - Activates a picking menu to select volumes.

            REFRESH - Refreshes the graphics window (non-UI mode only).

            COLL - Controls the collapse of the ANSYS Main Menu when a FINISH command is issued.
                   See Type below for a discussion of the arguments.

        type
            Label identifying the type of select operation.  Valid only for the
            following Func labels; NSEL, ESEL, KSEL, LSEL, ASEL, and VSEL:

            S - Select a new set.

            R - Reselect a set from the current set.

            A - Additionally select a set and extend the current set.

            U - Unselect a set from the current set.

        Notes
        -----
        Allows you to activate specified GUI dialog boxes directly in either
        GUI or non-GUI mode.
        """
        command = "/UI,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(func), str(type), str(format), str(screen), str(color), str(krev), str(orient), str(compress), str(quality))
        return self.run(command, **kwargs)

    def ktran(self, kcnto="", np1="", np2="", ninc="", kinc="", noelem="",
              imove="", **kwargs):
        """APDL Command: KTRAN

        Transfers a pattern of keypoints to another coordinate system.

        Parameters
        ----------
        kcnto
            Reference number of coordinate system where the pattern is to be
            transferred.  Transfer occurs from the active coordinate system.

        np1, np2, ninc
            Transfer keypoints from pattern beginning with NP1 to NP2 (defaults
            to NP1) in steps of NINC (defaults to 1).  If NP1 = ALL, NP2 and
            NINC are ignored and pattern is all selected keypoints [KSEL].  If
            NP1 = P, graphical picking is enabled and all remaining command
            fields are ignored (valid only in the GUI).  A component name may
            also be substituted for NP1 (NP2 and NINC are ignored).

        kinc
            Keypoint increment between sets.  If zero, the lowest available
            keypoint numbers are assigned [NUMSTR].

        noelem
            Specifies whether nodes and elements are also to be generated:

            0 - Generate nodes and point elements associated with the original keypoints, if
                they exist.

            1 - Do not generate nodes and elements.

        imove
            Specifies whether keypoints will be moved or newly defined:

            0 - Generate additional keypoints.

            1 - Move original keypoints to new position retaining the same keypoint numbers
                (KINC and NOELEM are ignored).  Valid only if the old keypoints
                are no longer needed at their original positions.
                Corresponding meshed items are also moved if not needed at
                their original position.

        Notes
        -----
        Transfers a pattern of keypoints (and corresponding mesh) from one
        coordinate system to another (see analogous node transfer command,
        TRANSFER).  The MAT, TYPE, REAL, and ESYS attributes are based upon the
        keypoints in the pattern and not upon the current settings.  Coordinate
        systems may be translated and rotated relative to each other.  Initial
        pattern may be generated in any coordinate system.  Coordinate values
        are interpreted in the active coordinate system and are transferred
        directly.  Solid modeling in a toroidal coordinate system is not
        recommended.
        """
        command = "KTRAN,%s,%s,%s,%s,%s,%s,%s" % (str(kcnto), str(np1), str(np2), str(ninc), str(kinc), str(noelem), str(imove))
        return self.run(command, **kwargs)

    def keyopt(self, itype="", knum="", value="", **kwargs):
        """APDL Command: KEYOPT

        Sets element key options.

        Parameters
        ----------
        itype
            Element type number as defined on the ET command. The label GCN is
            also valid input for general contact elements (see Notes).

        knum
            Number of the KEYOPT to be defined (KEYOPT(KNUM)).

        value
            Value of this KEYOPT.

        Notes
        -----
        Alternative to inputting KEYOPT values on ET command.  Must be used if
        KEYOPT(7) or greater values are to be input. ITYPE must first be
        defined with the ET command.

        Specify ITYPE = GCN to set element key options for all contact elements
        types used in any existing general contact definitions (that is,
        contact elements having a real constant set number = 0).
        """
        command = "KEYOPT,%s,%s,%s" % (str(itype), str(knum), str(value))
        return self.run(command, **kwargs)

    def hemiopt(self, hres="", **kwargs):
        """APDL Command: HEMIOPT

        Specifies options for Hemicube view factor calculation.

        Parameters
        ----------
        hres
            Hemicube resolution.  Increase value to increase the accuracy of
            the view factor calculation.  Defaults to 10.
        """
        command = "HEMIOPT,%s" % (str(hres))
        return self.run(command, **kwargs)

    def rmflvec(self, **kwargs):
        """APDL Command: RMFLVEC

        Writes eigenvectors of fluid nodes to a file for use in damping
        parameter extraction.

        Notes
        -----
        RMFLVEC extracts the modal information from the modal results file for
        all nodes specified in a node component called 'FLUN'. This component
        should include all nodes which are located at the fluid-structural
        interface. Mode shapes, element normal orientation, and a scaling
        factor are computed and stored in a file Jobname.EFL. For damping
        parameter extraction, use the DMPEXT command macro. See Introduction
        for more information on thin film analyses.

        FLUID136 and FLUID138 are used to model the fluid interface. Both the
        structural and fluid element types must be active. The fluid interface
        nodes must be grouped into a component 'FLUN'. A results file of the
        last modal analysis must be available.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "RMFLVEC," % ()
        return self.run(command, **kwargs)

    def asel(self, type="", item="", comp="", vmin="", vmax="", vinc="",
             kswp="", **kwargs):
        """APDL Command: ASEL

        Selects a subset of areas.

        Parameters
        ----------
        type
            Label identifying the type of select:

            S - Select a new set (default)

            R - Reselect a set from the current set.

            A - Additionally select a set and extend the current set.

            U - Unselect a set from the current set.

            ALL - Restore the full set.

            NONE - Unselect the full set.

            INVE - Invert the current set (selected becomes unselected and vice versa).

            STAT - Display the current select status.

        Notes
        -----
        Selects a subset of areas. For example, to select those areas with area
        numbers 1 through 7, use ASEL,S,AREA,,1,7.  The selected subset is then
        used when the ALL label is entered (or implied) on other commands, such
        as ALIST,ALL.  Only data identified by area number are selected.  Data
        are flagged as selected and unselected; no data are actually deleted
        from the database.

        In a cyclic symmetry analysis, area hot spots can be modified.
        Consequently, the result of an area selection may be different before
        and after the CYCLIC command.

        If Item = ACCA, the command selects only those areas that were created
        by concatenation.  The KSWP field is processed, but the Comp, VMIN,
        VMAX, and VINC fields are ignored.

        This command is valid in any processor.

        For Selects based on non-integer numbers (coordinates, results, etc.),
        items that are within the range VMIN-Toler and VMAX+Toler are selected.
        The default tolerance Toler is based on the relative values of VMIN and
        VMAX as follows:

        If VMIN = VMAX, Toler = 0.005 x VMIN.

        If VMIN = VMAX = 0.0, Toler = 1.0E-6.

         If VMAX ≠ VMIN, Toler = 1.0E-8 x (VMAX-VMIN).

        Use the SELTOL command to override this default and specify Toler
        explicitly.

        Table: 127:: : ASEL - Valid Item and Component Labels
        """
        command = "ASEL,%s,%s,%s,%s,%s,%s,%s" % (str(type), str(item), str(comp), str(vmin), str(vmax), str(vinc), str(kswp))
        return self.run(command, **kwargs)

    def mfrelax(self, lab="", value="", option="", **kwargs):
        """APDL Command: MFRELAX

        Sets relaxation values for an ANSYS Multi-field solver analysis.

        Parameters
        ----------
        lab
            Valid labels:

        value
            Relaxation value. Defaults to 0.75 for all labels.

        option
            Valid options are:

            RELX  - Uses relaxation method for load transfer (default).

            LINT  - Uses a linear interpolation for loaf transfer.

        Notes
        -----
        MFRELAX sets relaxation values for the load transfer variables at a
        surface or volume interface. Option = RELX will usually give you a more
        stable and smooth load transfer and is suitable for strongly coupled
        problems (such as FSI problems). Option = LINT is suitable for weakly
        coupled problems because it will transfer the full load in fewer
        stagger iterations.

        See the MFFR and MFITER commands for more information on relaxation in
        the ANSYS Multi-field solver.

        This command is also valid in PREP7.

        See Multi-field Commands in the Coupled-Field Analysis Guide for a list
        of all ANSYS Multi-field solver commands and their availability for MFS
        and MFX analyses.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "MFRELAX,%s,%s,%s" % (str(lab), str(value), str(option))
        return self.run(command, **kwargs)

    def dcvswp(self, option="", elem="", cnum="", vmax="", vinc1="", vinc2="",
               gap="", **kwargs):
        """APDL Command: DCVSWP

        Performs a DC voltage sweep on a ROM element.

        Parameters
        ----------
        option
            Sweep option:

            GV - Perform voltage sweep up to given voltage Vmax.

        elem
            Element number of the ROM element for the ROM use pass analysis.

        cnum
            Number of sweep conductor.

        vmax
            Maximum voltage. For the PI option, this voltage should be below
            the pull-in voltage value.

        vinc1
            Voltage increment for Vmax (default = Vmax/20).

        vinc2
            Voltage increment for pull-in voltage (default = 1).

        gap
            Gap elements option:

            0 - Create gap elements (COMBIN40) (default).

        Notes
        -----
        Vinc1 is used to ramp the sweep conductor voltage from 0 to Vmax. Vinc2
        is used to increase the sweep conductor voltage from Vmax to the pull-
        in value if the PI sweep option is used.

        Because ramping the voltage may lead to the unstable region of an
        electromechanical system, DCVSWP might not converge when the sweep
        conductor voltage approaches the pull-in value. To avoid non-converged
        solutions, you should use the gap option to create a set of spring-gap
        elements (COMBIN40). By default, DCVSWP creates two spring-gap elements
        with opposite orientations for each active modal displacement DOF of
        the ROM element. The gap size is set to the maximum absolute values of
        the deflection range for the corresponding mode, as calculated by
        RMMSELECT or modified  using the RMMRANGE command. The spring constants
        are set to 1.E5 for all the COMBIN40 elements. Along with the spring-
        gap elements, DCVSWP creates a set of constraint equations relating the
        ROM element modal displacements DOF (EMF) and the displacement DOF (UX)
        of the gap elements. Constraining the modal displacements using the
        spring-gap elements allows DCVSWP to converge in the pull-in range. The
        DCVSWP macro has a limit of 900 equilibrium iterations. If this limit
        is not sufficient to reach convergence, try the advanced techniques
        given in Overcoming Convergence Problems in the Structural Analysis
        Guide. For more information on gap elements, see Using Gap Elements
        with ROM144 in the Coupled-Field Analysis Guide.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "DCVSWP,%s,%s,%s,%s,%s,%s,%s" % (str(option), str(elem), str(cnum), str(vmax), str(vinc1), str(vinc2), str(gap))
        return self.run(command, **kwargs)

    def qrdopt(self, reusekey="", symmeth="", cmccoutkey="", **kwargs):
        """APDL Command: QRDOPT

        Specifies additional QRDAMP modal analysis options.

        Parameters
        ----------
        reusekey
            Reuse key for method=QRDAMP specified in MODOPT command.

            ON - Reuse the symmetric eigensolution from the previous load steps or from the
                 previous solution.

            OFF - Do not reuse (calculates symmetric eigensolution at current load step). This is
                  the default.

        --, --
            Unused fields.

        symmeth
            Mode-extraction method to be used for the symmetric eigenvalue
            problem.

            LANB - Block Lanczos (default for shared-memory parallel processing).

            SUBSP - Subspace algorithm (default for distributed-memory parallel processing).

        cmccoutkey
            Complex Modal Contribution Coefficients (CMCC) output key. See
            Calculate the Complex Mode Contribution Coefficients (CMCC) in the
            Structural Analysis Guide for details and usage.

            ON - Output the CMCC to the text file Jobname.CMCC.

            OFF - Do not output the CMCC. This is the default.

        Notes
        -----
        If the filename.modesym file exists in the working directory and
        ReuseKey = ON, filename.modesym will be reused. If filename.modesym
        does not exist in the working directory, the symmetric eigensolution
        will be calculated.

        When ReuseKey=ON, both the new modal analysis (filename.modesym usage)
        and the preceding modal analysis (filename.modesym generation) must be
        performed using the same product version number.

        The mode-extraction method changes depending on the type of parallelism
        involved. For performance reasons, the subspace method is used with
        distributed-memory parallel processing (Distributed ANSYS) runs, while
        the Block Lanczos method is used with shared-memory parallel processing
        runs.
        """
        command = "QRDOPT,%s,%s,%s" % (str(reusekey), str(symmeth), str(cmccoutkey))
        return self.run(command, **kwargs)

    def abs(self, ir="", ia="", name="", facta="", **kwargs):
        """APDL Command: ABS

        Forms the absolute value of a variable.

        Parameters
        ----------
        ir
            Arbitrary reference number assigned to the resulting variable (2 to
            NV [NUMVAR]).  If this number is the same as for a previously
            defined variable, the previously defined variable will be
            overwritten with this result.

        ia
            Reference number of the variable to be operated on.

        --, --
            Unused fields.

        name
            Thirty-two character name for identifying the variable on the
            printout and displays.  Embedded blanks are compressed upon output.

        --, --
            Unused fields.

        facta
            Scaling factor (positive or negative) applied to variable IA
            (defaults to 1.0).

        Notes
        -----
        The new variable is calculated as:

        IR = | FACTA x IA |

        For a complex number (a + ib), the absolute value is the magnitude,
        where the IA values are obtained from:

        See POST26 - Data Operations in the Mechanical APDL Theory Reference
        for details.
        """
        command = "ABS,%s,%s,%s,%s" % (str(ir), str(ia), str(name), str(facta))
        return self.run(command, **kwargs)

    def rigid(self, dof1="", dof2="", dof3="", dof4="", dof5="", dof6="",
              **kwargs):
        """APDL Command: RIGID

        Specifies known rigid body modes (if any) of the model.

        Parameters
        ----------
        dof1, dof2, dof3, . . . , dof6
            Up to six global Cartesian directions of the rigid modes.  For a
            completely free 2-D model, use ALL or UX, UY, ROTZ.   For a
            completely free 3-D model, use ALL or UX, UY, UZ, ROTX, ROTY, ROTZ.
            For a constrained model, use UX, UY, UZ, ROTX, ROTY, or ROTZ, as
            appropriate, to specify each and every unconstrained direction
            which exists in the model (not specifying every direction may cause
            difficulties in extracting the modes).

        Notes
        -----
        Specifies known rigid body modes (if any) of the model.  This command
        applies only to a component mode synthesis (CMS) analysis (see the
        CMSOPT command).  Any rigid body modes specified must be permitted by
        the applied displacement constraints (i.e., do not specify a rigid body
        mode in a constrained direction).  Reissue the command to redefine the
        specification.  If used in SOLUTION, this command is valid only within
        the first load step.

        This command is also valid in PREP7.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "RIGID,%s,%s,%s,%s,%s,%s" % (str(dof1), str(dof2), str(dof3), str(dof4), str(dof5), str(dof6))
        return self.run(command, **kwargs)

    def svtyp(self, ksv="", fact="", keyinterp="", **kwargs):
        """APDL Command: SVTYP

        Defines the type of single-point response spectrum.

        Parameters
        ----------
        ksv
            Response spectrum type:

            0 - Seismic velocity response spectrum loading (SV values interpreted as velocities
                with units of length/time).

            1 - Force response spectrum loading (SV values interpreted as force amplitude
                multipliers).

            2 - Seismic acceleration response spectrum loading (SV values interpreted as
                accelerations with units of length/time2).

            3 - Seismic displacement response spectrum loading (SV values interpreted as
                displacements with units of length).

            4 - PSD loading (SV values interpreted as acceleration2/(cycles/time), such as
                (in/sec2)2/Hz (not g2/Hz)).  (Not recommended)

        fact
            Scale factor applied to spectrum values (defaults to 1.0).  Values
            are scaled when the solution is initiated [SOLVE].  Database values
            remain the same.

        keyinterp
            Key to activate or deactivate the linear interpolation between
            input response spectrum points and input response spectrum curves:

            0 (OFF or NO) - Deactivate linear and use logarithmic interpolation. This value is the default.

            1 (ON or YES) - Activate linear interpolation.

        Notes
        -----
        Defines the type of single-point response spectrum [SPOPT].  The
        seismic excitation direction is defined with the SED command.

        This command is also valid in PREP7.
        """
        command = "SVTYP,%s,%s,%s" % (str(ksv), str(fact), str(keyinterp))
        return self.run(command, **kwargs)

    def n(self, node="", x="", y="", z="", thxy="", thyz="", thzx="",
          **kwargs):
        """APDL Command: N

        Defines a node.

        Parameters
        ----------
        node
            Node number to be assigned.  A previously defined node of the same
            number will be redefined.  Defaults to the maximum node number used
            +1.

        x, y, z
            Node location in the active coordinate system (R, θ, Z for
            cylindrical, R, θ, Φ for spherical or toroidal).  If X = P,
            graphical picking is enabled and all remaining command fields are
            ignored (valid only in the GUI).

        thxy
            First rotation about nodal Z (positive X toward Y).

        thyz
            Second rotation about nodal X (positive Y toward Z).

        thzx
            Third rotation about nodal Y (positive Z toward X).

        Notes
        -----
        Defines a node in the active coordinate system [CSYS].  The nodal
        coordinate system is parallel to the global Cartesian system unless
        rotated.  Rotation angles are in degrees and redefine any previous
        rotation angles.  See the NMODIF, NANG, NROTAT, and NORA commands for
        other rotation options.
        """
        command = "N,%s,%s,%s,%s,%s,%s,%s" % (str(node), str(x), str(y), str(z), str(thxy), str(thyz), str(thzx))
        return self.run(command, **kwargs)

    def axlab(self, axis="", lab="", **kwargs):
        """APDL Command: /AXLAB

        Labels the X and Y axes on graph displays.

        Parameters
        ----------
        axis
            Axis specifier:

            X - Apply label to X axis.

            Y - Apply label to Y axis.

        lab
            Axis label (user defined text up to 30 characters long).  Leave
            blank to reestablish the default for Axis axis.

        Notes
        -----
        This command is valid in any processor.
        """
        command = "/AXLAB,%s,%s" % (str(axis), str(lab))
        return self.run(command, **kwargs)

    def ssbt(self, bt11="", bt22="", bt12="", t="", **kwargs):
        """APDL Command: SSBT

        Specifies preintegrated bending thermal effects for shell sections.

        Parameters
        ----------
        bt11, bt22, bt12
            Bending thermal effects component [BT].

        t
            Temperature.

        Notes
        -----
        The behavior of shell elements is governed by the generalized-
        stress/generalized-strain relationship of the form:

        The SSBT command, one of several preintegrated shell section commands,
        specifies the bending thermal effects quantity (submatrix [BT] data)
        for a preintegrated shell section. The section data defined is
        associated with the section most recently defined (via the SECTYPE
        command).

        The [BT] quantity represents bending stress resultants caused by a unit
        raise in temperature on a fully constrained model. For a layered
        composite shell, it is usually necessary to specify both the [BT] and
        [MT] quantities (by issuing the SSBT and SSMT commands, respectively).

        Unspecified values default to zero.

        Related commands are SSPA, SSPB, SSPD, SSPE, SSMT, and SSPM.

        If you are using the SHELL181 or SHELL281 element's Membrane option
        (KEYOPT(1) = 1), it is not necessary to issue this command.

        For complete information, see Using Preintegrated General Shell
        Sections.
        """
        command = "SSBT,%s,%s,%s,%s" % (str(bt11), str(bt22), str(bt12), str(t))
        return self.run(command, **kwargs)

    def icscale(self, wn="", factor="", **kwargs):
        """APDL Command: /ICSCALE

        Scales the icon size for elements supported in the circuit builder.

        Parameters
        ----------
        wn
            Window number (or ALL) to which command applies (defaults to 1).

        factor
            Factor applied to the default icon size (defaults to 1).

        Notes
        -----
        Scaling the icon size can provide better visualization of the circuit
        components when using the Circuit Builder (an interactive builder
        available in the ANSYS GUI).

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "/ICSCALE,%s,%s" % (str(wn), str(factor))
        return self.run(command, **kwargs)

    def kuse(self, key="", **kwargs):
        """APDL Command: KUSE

        Specifies whether or not to reuse the factorized matrix.

        Parameters
        ----------
        key
            Reuse key:

            0  - Program decides whether or not to reuse the previous factorized stiffness
                 matrix.

            1  - Force the previous factorized stiffness matrix to be reused.  Used mainly in a
                 restart.  Forcing reuse of the matrix is a nonstandard use of
                 the program, and should be done with caution.  For instance,
                 using this option and changing the number of elements, or the
                 number or type of degrees of freedom, may cause an abort.

            -1  - All element matrices are reformed and are used to reform a new factorized
                  stiffness matrix.

        Notes
        -----
        Overrides the program logic to determine whether or not to reuse the
        previous factorized stiffness matrix for each substep of this load
        step.  Applies only to static or full transient analyses and to full
        harmonic analyses if the frequency is not changed for continuing
        loadsteps. For full harmonic analyses, only KEY = 1 or KEY = 0 is
        valid.

        This command is also valid in PREP7.
        """
        command = "KUSE,%s" % (str(key))
        return self.run(command, **kwargs)

    def cskp(self, kcn="", kcs="", porig="", pxaxs="", pxypl="", par1="",
             par2="", **kwargs):
        """APDL Command: CSKP

        Defines a local coordinate system by three keypoint locations.

        Parameters
        ----------
        kcn
            Arbitrary reference number assigned to this coordinate system.
            Must be greater than 10.  A coordinate system previously defined
            with this number will be redefined.

        kcs
            Coordinate system type:

            0 or CART - Cartesian

            1 or CYLIN - Cylindrical (circular or elliptical)

            2 or SPHE - Spherical (or spheroidal)

            3 or TORO - Toroidal

        porig
            Keypoint defining the origin of this coordinate system.  If PORIG =
            P, graphical picking is enabled and all remaining command fields
            are ignored (valid only in the GUI).

        pxaxs
            Keypoint defining the positive x-axis orientation of this
            coordinate system.

        pxypl
            Keypoint defining the x-y plane (with PORIG and PXAXS) in the first
            or second quadrant of this coordinate system.

        par1
            Used for elliptical, spheroidal, or toroidal systems.  If KCS = 1
            or 2, PAR1 is the ratio of the ellipse Y-axis radius to X-axis
            radius (defaults to 1.0 (circle)).  If KCS = 3, PAR1 is the major
            radius of the torus.

        par2
            Used for spheroidal systems.  If KCS = 2, PAR2 = ratio of ellipse
            Z-axis radius to X-axis radius (defaults to 1.0 (circle)).

        Notes
        -----
        Defines and activates a local right-handed coordinate system by
        specifying three existing keypoints: to locate the origin, to locate
        the positive x-axis, and to define the positive x-y plane.  This local
        system becomes the active coordinate system.  See the CLOCAL, CS,
        CSWPLA, and LOCAL commands for alternate definitions.  Local coordinate
        systems may be displayed with the /PSYMB command.

        This command is valid in any processor.
        """
        command = "CSKP,%s,%s,%s,%s,%s,%s,%s" % (str(kcn), str(kcs), str(porig), str(pxaxs), str(pxypl), str(par1), str(par2))
        return self.run(command, **kwargs)

    def bsm2(self, val1="", val2="", t="", **kwargs):
        """APDL Command: BSM2

        Specifies the bending curvature and moment relationship in plane XY for
        beam sections.

        Parameters
        ----------
        val1
            Curvature component (κ2).

        val2
            Bending moment component (M2).

        t
            Temperature.

        Notes
        -----
        The behavior of beam elements is governed by the generalized-
        stress/generalized-strain relationship of the form:

        The BSM2 command, one of several nonlinear general beam section
        commands, specifies the bending curvature and moment relationship for
        plane XY of a beam section. The section data defined is associated with
        the section most recently defined (via the SECTYPE command).

        Unspecified values default to zero.

        Related commands are BSAX, BSM1, BSTQ, BSS1, BSS2, BSMD, and BSTE.

        For complete information, see Using Nonlinear General Beam Sections.
        """
        command = "BSM2,%s,%s,%s" % (str(val1), str(val2), str(t))
        return self.run(command, **kwargs)

    def torqsum(self, cnam1="", cnam2="", cnam3="", cnam4="", cnam5="",
                cnam6="", cnam7="", cnam8="", cnam9="", **kwargs):
        """APDL Command: TORQSUM

        Summarizes electromagnetic torque calculations on element components.

        Parameters
        ----------
        cnam1, cnam2, cnam3, . . . , cnam9
            Names of existing element components for which Maxwell or virtual
            work boundary conditions were applied in the preprocessor.  Must be
            enclosed in single quotes (e.g., 'CNAM1') when the command typed in
            the command input box.

        Notes
        -----
        TORQSUM invokes an ANSYS macro that summarizes the Maxwell and virtual
        work torque values.  The element components must have had appropriate
        Maxwell or virtual work boundary conditions established in the
        preprocessor prior to solution in order to retrieve torques (see the
        FMAGBC command).  The torque values are stored on a per-element basis
        for the adjacent air layer elements surrounding the components and are
        retrieved and summed by the macro.  For a harmonic analysis, the
        calculated torque represents a time-average value.

        TORQSUM is valid only for 2-D planar analysis.
        """
        command = "TORQSUM,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(cnam1), str(cnam2), str(cnam3), str(cnam4), str(cnam5), str(cnam6), str(cnam7), str(cnam8), str(cnam9))
        return self.run(command, **kwargs)

    def plcrack(self, loc="", num="", **kwargs):
        """APDL Command: PLCRACK

        Displays cracking and crushing locations in SOLID65 elements.

        Parameters
        ----------
        loc
            Location at which symbols are to be displayed:

            0 - Plot symbols at integration points (default).

            1 - Plot symbol at element centroids (averaged).

        num
            Crack to be displayed:

            0 - Plot all cracks (default).

            1 - Plot only the first crack.

            2 - Plot only the second crack.

            3 - Plot only the third crack.

        Notes
        -----
        PLCRACK displays circles at locations of cracking or crushing in
        concrete elements.  Cracking is shown with a circle outline in the
        plane of the crack, and crushing is shown with an octahedron outline.
        If the crack has opened and then closed, the circle outline will have
        an X through it.  Each integration point can crack in up to three
        different planes.  The first crack at an integration point is shown
        with a red circle outline, the second crack with a green outline, and
        the third crack with a blue outline.

        Symbols shown at the element centroid (LOC = 1) are based on the status
        of all of the element's integration points.  If any integration point
        in the element has crushed, the crushed (octahedron) symbol is shown at
        the centroid.  If any integration point has cracked or cracked and
        closed, the cracked symbol is shown at the element centroid.  If at
        least five integration points have cracked and closed, the cracked and
        closed symbol is shown at the element centroid.  Finally, if more than
        one integration point has cracked, the circle outline at the element
        centroid shows the average orientation of all cracked planes for that
        element.

        Portions of this command are not supported by PowerGraphics
        [/GRAPHICS,POWER].
        """
        command = "PLCRACK,%s,%s" % (str(loc), str(num))
        return self.run(command, **kwargs)

    def ksymm(self, ncomp="", np1="", np2="", ninc="", kinc="", noelem="",
              imove="", **kwargs):
        """APDL Command: KSYMM

        Generates a reflected set of keypoints.

        Parameters
        ----------
        ncomp
            Symmetry key:

            X - X (or R) symmetry (default).

            Y - Y (or θ) symmetry.

            Z - Z (or Φ) symmetry.

        np1, np2, ninc
            Reflect keypoints from pattern beginning with NP1 to NP2 (defaults
            to NP1) in steps of NINC (defaults to 1).  If NP1 = ALL, NP2 and
            NINC are ignored and pattern is all selected keypoints [KSEL].  If
            Ncomp = P, graphical picking is enabled and all remaining command
            fields are ignored (valid only in the GUI).  A component name may
            also be substituted for NP1 (NP2 and NINC are ignored).

        kinc
            Keypoint increment between sets.  If zero, the lowest available
            keypoint numbers are assigned [NUMSTR].

        noelem
            Specifies whether nodes and elements are also to be generated:

            0 - Generate nodes and point elements associated with the original keypoints, if
                they exist.

            1 - Do not generate nodes and elements.

        imove
            Specifies whether keypoints will be moved or newly defined:

            0 - Generate additional keypoints.

            1 - Move original keypoints to new position retaining the same keypoint numbers
                (KINC and NOELEM are ignored).  Valid only if the old keypoints
                are no longer needed at their original positions.
                Corresponding meshed items are also moved if not needed at
                their original position.

        Notes
        -----
        Generates a reflected set of keypoints (and corresponding mesh) from a
        given keypoint pattern by a symmetry reflection (see analogous node
        symmetry command, NSYM).  The MAT, TYPE, REAL, and ESYS attributes are
        based upon the keypoints in the pattern and not upon the current
        settings.  Reflection is done in the active coordinate system by
        changing a particular coordinate sign.  Keypoints in the pattern may
        have been generated in any coordinate system.  However, solid modeling
        in a toroidal coordinate system is not recommended.
        """
        command = "KSYMM,%s,%s,%s,%s,%s,%s,%s" % (str(ncomp), str(np1), str(np2), str(ninc), str(kinc), str(noelem), str(imove))
        return self.run(command, **kwargs)

    def cmdele(self, name="", **kwargs):
        """APDL Command: CMDELE

        Deletes a component or assembly definition.

        Parameters
        ----------
        name
            Name of the component or assembly whose definition is to be
            removed.

        Notes
        -----
        Entities contained in the component, or the components within the
        assembly, are unaffected.  Only the grouping relationships are deleted.
        Assemblies are automatically updated to reflect deletion of their
        components or subassemblies, but they are not automatically deleted
        when all their components or subassemblies are deleted.

        This command is valid in any processor.
        """
        command = "CMDELE,%s" % (str(name))
        return self.run(command, **kwargs)

    def emodif(self, iel="", stloc="", i1="", i2="", i3="", i4="", i5="",
               i6="", i7="", i8="", **kwargs):
        """APDL Command: EMODIF

        Modifies a previously defined element.

        Parameters
        ----------
        iel
            Modify nodes and/or attributes for element number IEL.  If ALL,
            modify all selected elements [ESEL].  If IEL = P, graphical picking
            is enabled and all remaining command fields are ignored (valid only
            in the GUI). A component name may also be substituted for IEL.

        stloc
            Starting location (n) of first node to be modified or the attribute
            label.

        i1, i2, i3, . . . , i8
            Replace the previous node numbers assigned to this element with
            these corresponding values. A (blank) retains the previous value
            (except in the I1 field, which resets the STLOC node number to
            zero).

        Notes
        -----
        The nodes and/or attributes (MAT, TYPE, REAL, ESYS, and SECNUM values)
        of an existing element may be changed with this command.
        """
        command = "EMODIF,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(iel), str(stloc), str(i1), str(i2), str(i3), str(i4), str(i5), str(i6), str(i7), str(i8))
        return self.run(command, **kwargs)

    def susel(self, type="", name1="", name2="", name3="", name4="", name5="",
              name6="", name7="", name8="", **kwargs):
        """APDL Command: SUSEL

        Selects a subset of surfaces

        Parameters
        ----------
        type
            Label identifying the type of select:

            S - Selects a new set (default).

            R - Reselects a set from the current set.

            A - Additionally selects a set and extends the current set.

            U - Unselects a set from the current set.

            ALL - Also selects all surfaces.

            NONE - Unselects all surfaces.

        name1, name2, name3, . . . , name8
            Eight character surface names

        Notes
        -----
        The selected set of surfaces is used in the following operations:
        SUMAP, SUDEL, SUCALC, SUEVAL, and SUVECT.
        """
        command = "SUSEL,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(type), str(name1), str(name2), str(name3), str(name4), str(name5), str(name6), str(name7), str(name8))
        return self.run(command, **kwargs)

    def oczone(self, zonetype="", zonename="", compnameint="", compnameext="",
               **kwargs):
        """APDL Command: OCZONE

        Specifies the type of ocean zone data to follow.

        Parameters
        ----------
        zonetype
            The type of ocean zone data to be input following this command:

            COMP - Define by a component.

            ZLOC - Define by Z levels.

            PIP - Associate an internal pipe or pipes with an external pipe.

        zonename
            The ocean zone name. If no name is specified, the program assigns
            one.

        compnameint
            For Zonetype = COMP, the required name of a component.

        compnameext
            For Zonetype = PIP, the required name of an external pipe
            component.

        Notes
        -----
        The OCZONE command specifies the type of ocean zone data to follow
        (component, Z-level, or internal pipes associated with an external
        pipe). An ocean zone is a local space where you can override global
        ocean-loading parameters.

        Names specified for ZoneName, CompNameInt, and CompNameExt can consist
        of up to 32 alphanumeric characters. The name cannot contain
        punctuation, special characters, or spaces.

        For Zonetype = COMP, the zone is defined by a component. Only the
        elements in the component are affected by the local parameters. A
        partial component can be defined as the zone via the Z input on the
        OCTABLE command.

        For Zonetype = ZLOC, the zone is defined by Z levels. Structural
        elements (such as BEAM188, BEAM189, PIPE288, PIPE289, and LINK180) in
        the Z levels are included in the zone.

        For Zonetype = PIP, the zone is prepared for a special configuration of
        pipes. It associates an internal pipe or pipes with an external pipe to
        remove the hydrodynamic effect on the internal pipe. Only hydrostatic
        pressure is applied on the internal pipe.

        This command is also valid in PREP7.

        Figure: 6:: : Ocean Zone Types (Specified via ZoneType)

        Issue this command before defining your ocean load data (OCDATA or
        OCTABLE). Define components before defining a component-type or a pipe-
        type zone (OCZONE,COMP or OCZONE,PIP, respectively).
        """
        command = "OCZONE,%s,%s,%s,%s" % (str(zonetype), str(zonename), str(compnameint), str(compnameext))
        return self.run(command, **kwargs)

    def usrelem(self, nnodes="", ndim="", keyshape="", nreal="", nsavevars="",
                nrsltvar="", keyansmat="", nintpnts="", kestress="", keysym="",
                **kwargs):
        """APDL Command: USRELEM

        Specifies the characteristics of the user-defined element USER300.

        Parameters
        ----------
        nnodes
            The number of nodes.

        ndim
            The number of dimensions (of nodal coordinates). Valid values are 2
            or 3.

        keyshape
            One of the following element shape options:

            ANYSHAPE - Any shape (that is, no specified shape). This value is the default. (The ANSYS
                       MeshTool is unavailable.)

            POINT - Point.

            LINE - Straight line.

            TRIAN - Triangle.

            QUAD - Quadrilateral. This shape can be degenerated to a triangle.

            TET - Tetrahedron.

            BRICK - Brick. This shape can be degenerated to a wedge, pyramid, or tetrahedron.

        nreal
            The number of real constants.

        nsavevars
            The number of saved variables.

        nrsltvar
            The number of variables saved in results files.

        keyansmat
            Key for element formulation control:

            0 - Create your own material codes within the element formulation. In this case,
                the real constants are available to input material properties.
                You can also input linear material properties via MP and MPDATA
                commands .

            1 - Use ANSYS standard material routines or the USERMAT subroutine to form
                structural material data. ANSYS material properties must be
                input in the standard way (as you would for non-user-defined
                elements). This value is invalid when KeyShape = ANYSHAPE.

        nintpnts
            The maximum number of integration points (used when KEYANSMAT = 1).

        kestress
            Key for the element stress state (used when KEYANSMAT = 1):

            0 - Plane stress elements.

            1 - Axisymmetric elements.

            2 - Plane strain elements.

            3 - 3-D solid elements.

            4 - 3-D solid-shell elements.

            5 - Generalized plane strain elements.

            6 - Beam elements.

            7 - Link/truss elements.

            8 - 3-D shell elements.

            9 - Axisymmetric shell elements.

        keysym
            Key for specifying whether element stiffness matrices are symmetric
            or unsymmetric:

            0 - Symmetric.

            1 - Unsymmetric.

        Notes
        -----
        The USRELEM command specifies the characteristics of the user-defined
        element USER300.

        Although you can intersperse other commands as necessary for your
        analysis, issue the USRELEM command as part of the following general
        sequence of commands:

        Issue the ET command for element USER300, followed by the related TYPE
        command.

        Issue both the USRELEM and USRDOF commands (in either order).

        Define your element using USER300.

        The number of real constants (NREAL) can refer to geometry quantities,
        material quantities, or any parameters for element formulation.

        ANSYS saves variables in the .esav file to preserve element data when
        you specify a positive NSAVEVARS value. When KEYANSMAT = 0, all
        variables of both material and kinematic formulation are saved. When
        KEYANSMAT = 1, only the variables for kinematic formulation (such as
        deformation gradient tensor) are saved; in this case, the material
        routine saves all necessary material data automatically.

        Element data saved in results files (NRSLTVAR) are accessible only as
        nonsummable miscellaneous data.  ANSYS saves stress and total strain
        data for structural elements in the .rst file automatically (as it does
        for equivalent variables such as thermal gradient and thermal flux in
        thermal elements); therefore, NRSLTVAR does not need to include stress
        and total strain data.

        To learn more about creating user-defined elements, see Creating a New
        Element in the Programmer's Reference.
        """
        command = "USRELEM,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(nnodes), str(ndim), str(keyshape), str(nreal), str(nsavevars), str(nrsltvar), str(keyansmat), str(nintpnts), str(kestress), str(keysym))
        return self.run(command, **kwargs)

    def sallow(self, strs1="", strs2="", strs3="", strs4="", strs5="",
               strs6="", **kwargs):
        """APDL Command: SALLOW

        Defines the allowable stress table for safety factor calculations.

        Parameters
        ----------
        strs1, strs2, strs3, . . . , strs6
            Input up to six allowable stresses corresponding to the temperature
            points [TALLOW].

        Notes
        -----
        Defines the allowable stress table for safety factor calculations
        [SFACT,SFCALC].  Use the STAT command to list current allowable stress
        table.  Repeat SALLOW to zero table and redefine points (6 maximum).

        Safety factor calculations are not supported by PowerGraphics. Both the
        SALLOW and TALLOW commands must be used with the Full Model Graphics
        display method active.
        """
        command = "SALLOW,%s,%s,%s,%s,%s,%s" % (str(strs1), str(strs2), str(strs3), str(strs4), str(strs5), str(strs6))
        return self.run(command, **kwargs)

    def edpc(self, min="", max="", inc="", **kwargs):
        """APDL Command: EDPC

        Selects and plots explicit dynamic contact entities.

        Parameters
        ----------
        min
             Minimum contact entity number to be selected and plotted (default
            = 1).

        max
            Maximum contact entity number to be selected and plotted (default =
            MIN).

        inc
            Contact entity number increment (default = 1).

        Notes
        -----
        EDPC invokes an ANSYS macro which selects and plots explicit dynamic
        contact entities. The plot will consist of nodes or elements, depending
        on the method (node components or parts) that was used to define the
        contact surfaces (see the EDCGEN command). For single surface contact
        definitions, all external surfaces within the model are plotted.

        Note:: : EDPC changes the selected set of nodes and elements. After
        plotting contact entities, you must reselect all nodes and elements
        (NSEL and ESEL) required for subsequent operations, such as SOLVE

        Use the EDCLIST command to list the contact entity numbers for all
        defined contact.

        This command is also valid in SOLUTION.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDPC,%s,%s,%s" % (str(min), str(max), str(inc))
        return self.run(command, **kwargs)

    def pscontrol(self, option="", key="", **kwargs):
        """APDL Command: PSCONTROL

        Enables or disables shared-memory parallel operations.

        Parameters
        ----------
        option
            Specify the operations for which you intend to enable/disable
            parallel behavior:

            ALL  - Enable/disable parallel for all areas (default).

            PREP  - Enable/disable parallel during preprocessing (/PREP7).

            SOLU  - Enable/disable parallel during solution (/SOLU).

            FORM  - Enable/disable parallel during element matrix generation.

            SOLV  - Enable/disable parallel during equation solver.

            RESU - Enable/disable parallel during element results calculation.

            POST  - Enable/disable parallel during postprocessing (/POST1 and /POST26).

            STAT - List parallel operations that are enabled/disabled.

        key
             Option control key. Used for all Option values except STAT.

            ON  - Enable parallel operation.

            OFF  - Disable parallel operation.

        Notes
        -----
        Use this command in shared-memory parallel operations.

        This command is useful when you encounter minor discrepancies in a
        nonlinear solution when using different numbers of processors. A
        parallel operation applied to the element matrix generation can produce
        a different nonlinear solution with a different number of processors.
        Although the nonlinear solution converges to the same nonlinear
        tolerance, the minor discrepancy created may not be desirable for
        consistency.

        Enabling/disabling parallel behavior for the solution (Option = SOLU)
        supersedes the activation/deactivation of parallel behavior for element
        matrix generation (FORM), equation solver (SOLV), and element results
        calculation (RESU).

        The SOLV option supports only the sparse direct and PCG solvers
        (EQSLV,SPARSE or PCG). No other solvers are supported.

        This command applies only to shared-memory architecture. It does not
        apply to the Distributed ANSYS product.
        """
        command = "PSCONTROL,%s,%s" % (str(option), str(key))
        return self.run(command, **kwargs)

    def gtype(self, wn="", label="", key="", **kwargs):
        """APDL Command: /GTYPE

        Controls the entities that the GPLOT command displays.

        Parameters
        ----------
        wn
            Window number (or ALL) to which this command applies (defaults to
            1)

        label
            This represents the type of entity to display:

            NODE - Nodes

            ELEM - Elements

            KEYP - Keypoints

            LINE - Lines

            AREA - Areas

            VOLU - Volumes

            GRPH - Graph displays

        key
            Switch:

            0 - Turns the entity type off.

            1 - Turns the entity type on.

        Notes
        -----
        The /GTYPE command controls which entities the GPLOT command displays.
        NODE, ELEM, KEYP, LINE, AREA, and VOLU are on by default.  When ELEM is
        activated, you can control the type of element displayed via the /GCMD
        command (which also controls the type of graph display).  When the GRPH
        entity type is activated, all other entity types are deactivated.
        Conversely, when any of the NODE, ELEM, KEYP, LINE, AREA, and VOLU
        entity types are active, the GRPH entity type is deactivated.

        The /GTYPE command gives you several options for multi-window layout:

        One window

        Two windows (left and right or top and bottom of the screen)

        Three windows (two at the top and one at the bottom of the screen, or
        one top and two bottom windows

        Four windows (two at the top and two at the bottom)



        Once you choose a window layout, you can choose one of the following:
        multiple plots, replotting, or no redisplay.

        This command is valid in any processor.
        """
        command = "/GTYPE,%s,%s,%s" % (str(wn), str(label), str(key))
        return self.run(command, **kwargs)

    def nstore(self, tinc="", **kwargs):
        """APDL Command: NSTORE

        Defines which time points are to be stored.

        Parameters
        ----------
        tinc
            Store data associated with every TINC time (or frequency) point(s),
            within the previously defined range of TMIN to TMAX [TIMERANGE].
            (Defaults to 1)

        Notes
        -----
        Defines which time (or frequency) points within the range are to be
        stored.
        """
        command = "NSTORE,%s" % (str(tinc))
        return self.run(command, **kwargs)

    def cycfiles(self, fnamerst="", extrst="", fnamerfrq="", extrfrq="",
                 **kwargs):
        """APDL Command: CYCFILES

        Specifies the data files where results are to be found for a cyclic
        symmetry mode-superposition harmonic analysis.

        Parameters
        ----------
        fnamerst
            The file name and directory path of the results file from the
            cyclic modal solution. Defaults to Jobname.

        extrst
            File name extension for FnameRst. Defaults to rst.

        fnamerfrq
            The file name and directory path of the results file from the
            cyclic mode-superposition harmonic solution. Defaults to the value
            of the FnameRst argument.

        extrfrq
            File name extension for FnameRfrq. Defaults to rfrq.
        """
        command = "CYCFILES,%s,%s,%s,%s" % (str(fnamerst), str(extrst), str(fnamerfrq), str(extrfrq))
        return self.run(command, **kwargs)

    def kscale(self, kinc="", np1="", np2="", ninc="", rx="", ry="", rz="",
               **kwargs):
        """APDL Command: KSCALE

        Generates a scaled pattern of keypoints from a given keypoint pattern.

        Parameters
        ----------
        kinc
            Do this scaling operation one time, incrementing all keypoints in
            the given pattern by KINC.  If KINC = 0, keypoints will be
            redefined at the scaled locations.

        np1, np2, ninc
            Scale keypoints from pattern beginning with NP1 to NP2 (defaults to
            NP1) in steps of NINC (defaults to 1).  If NP1 = ALL, NP2 and NINC
            are ignored and pattern is all selected keypoints [KSEL].  If NP1 =
            P, graphical picking is enabled and all remaining command fields
            are ignored (valid only in the GUI).  A component name may also be
            substituted for NP1 (NP2 and NINC are ignored).

        rx, ry, rz
            Scale factor ratios.  Scaling is relative to the origin of the
            active coordinate system (RR, Rθ, RZ for cylindrical, RR, Rθ, RΦ
            for spherical).  If > 1.0, pattern is enlarged.  If < 1.0, pattern
            is reduced.  Ratios each default to 1.0.

        Notes
        -----
        Generates a scaled pattern of keypoints from a given keypoint pattern.
        Scaling is done in the active coordinate system (see analogous node
        scaling [NSCALE]).  Solid modeling in a toroidal coordinate system is
        not recommended.
        """
        command = "KSCALE,%s,%s,%s,%s,%s,%s,%s" % (str(kinc), str(np1), str(np2), str(ninc), str(rx), str(ry), str(rz))
        return self.run(command, **kwargs)

    def smsurf(self, **kwargs):
        """APDL Command: SMSURF

        Specifies "Surface loads on the solid model" as the subsequent status
        topic.

        Notes
        -----
        This is a status [STAT] topic command.  Status topic commands are
        generated by the GUI and will appear in the log file (Jobname.LOG) if
        status is requested for some items under Utility Menu> List> Status.
        This command will be immediately followed by a STAT command, which will
        report the status for the specified topic.

        If entered directly into the program, the STAT command should
        immediately follow this command.
        """
        command = "SMSURF," % ()
        return self.run(command, **kwargs)

    def plmc(self, lstep="", sbstep="", timfrq="", kimg="", hibeg="", hiend="",
             **kwargs):
        """APDL Command: PLMC

        Plots the modal coordinates from a mode-superposition solution.

        Parameters
        ----------
        lstep, sbstep
            Plot the solution identified as load step LSTEP and substep SBSTEP

        timfrq
            As an alternative to LSTEP and SBSTEP, plot the solution at the
            time value TIMFRQ (for ANTYPE,TRANS) or frequency value TIMFRQ (for
            ANTYPE,HARMIC). LSTEP and SBSTEP should be left blank.

        kimg
            If 0 (or blank), plot the real solution. If 1, plot the imaginary
            solution. Only valid for ANTYPE,HARMIC.

        hibeg, hiend
            For cyclic symmetry solutions, plot the solutions in the harmonic
            index solution range HIbeg to HIend. Defaults to all harmonic
            indices (all modes).

        Notes
        -----
        PLMC plots a histogram of the modal coordinates (the response
        amplitudes applied to each mode shape) at a certain time point
        (transient analyses) or frequency point (harmonic analyses). The
        absolute values of the modal coordinates are plotted. Use /XRANGE to
        plot only modes in a certain range, if desired.

        For transient analyses, the Jobname.RDSP file must be available. For
        harmonic analyses, the Jobname.RFRQ must be available. No SET command
        is required and no expansion pass is required.

        For a cyclic harmonic mode-superposition analysis, use the CYCFILES
        command to identify the Jobname.RFRQ and modal Jobname.RST file. You
        may limit the plot to display only those modes in a certain harmonic
        index range. The modes having the same harmonic index are each plotted
        in a unique color. If there are less than 10 harmonic indices, they are
        identified in the graphics legend.

        This is a graphical representation of the optional Jobname.MCF text
        file. (see the TRNOPT and HROPT commands). For more information on
        modal coordinates, see Mode-Superposition Method in the Mechanical APDL
        Theory Reference.
        """
        command = "PLMC,%s,%s,%s,%s,%s,%s" % (str(lstep), str(sbstep), str(timfrq), str(kimg), str(hibeg), str(hiend))
        return self.run(command, **kwargs)

    def create(self, fname="", ext="", **kwargs):
        """APDL Command: *CREATE

        Opens (creates) a macro file.

        Parameters
        ----------
        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        Notes
        -----
        See the *USE command for a discussion of macros.  All commands
        following the *CREATE command, up to the *END command, are written to
        the specified file without being executed.  An existing file of the
        same name, if any, will be overwritten.  Parameter values are not
        substituted for parameter names in the commands when the commands are
        written to the file.  Use *CFWRITE to create a file if this is desired.
        The resulting macro may be executed with a *USE command (which also
        allows parameters to be passed into the macro) or a /INPUT command
        (which does not allow parameters to be passed in).  Several macros may
        be stacked into a library file [*ULIB]. You cannot use *CREATE within a
        DO loop.

        This command is valid in any processor.
        """
        command = "*CREATE,%s,%s" % (str(fname), str(ext))
        return self.run(command, **kwargs)

    def clocal(self, kcn="", kcs="", xl="", yl="", zl="", thxy="", thyz="",
               thzx="", par1="", par2="", **kwargs):
        """APDL Command: CLOCAL

        Defines a local coordinate system relative to the active coordinate
        system.

        Parameters
        ----------
        kcn
            Arbitrary reference number assigned to this coordinate system.
            Must be greater than 10.  A coordinate system previously defined
            with this number will be redefined.

        kcs
            Coordinate system type:

            0 or CART - Cartesian

            1 or CYLIN - Cylindrical (circular or elliptical)

            2 or SPHE - Spherical (or spheroidal)

            3 or TORO - Toroidal

        xl, yl, zl
            Location (in the active coordinate system) of the origin of the new
            coordinate system (R, θ, Z for cylindrical, R, θ,Φ for spherical or
            toroidal).

        thxy
            First rotation about local Z (positive X toward Y).

        thyz
            Second rotation about local X (positive Y toward Z).

        thzx
            Third rotation about local Y (positive Z toward X).

        par1
            Used for elliptical, spheroidal, or toroidal systems.  If KCS = 1
            or 2, PAR1 is the ratio of the ellipse Y-axis radius to X-axis
            radius (defaults to 1.0 (circle)).  If KCS = 3, PAR1 is the major
            radius of the torus.

        par2
            Used for spheroidal systems.  If KCS = 2, PAR2 = ratio of ellipse
            Z-axis radius to X-axis radius (defaults to 1.0 (circle)).

        Notes
        -----
        Defines and activates a local coordinate system by origin location and
        orientation angles relative to the active coordinate system.  This
        local system becomes the active coordinate system, and is automatically
        aligned with the active system (i.e., x is radial if a cylindrical
        system is active, etc.).  Nonzero rotation angles (degrees) are
        relative to this automatic rotation.  See the CS, CSKP, CSWPLA, and
        LOCAL commands for alternate definitions.  Local coordinate systems may
        be displayed with the /PSYMB command.

        This command is valid in any processor.
        """
        command = "CLOCAL,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(kcn), str(kcs), str(xl), str(yl), str(zl), str(thxy), str(thyz), str(thzx), str(par1), str(par2))
        return self.run(command, **kwargs)

    def pmgtran(self, fname="", freq="", fcnam1="", fcnam2="", pcnam1="",
                pcnam2="", ecnam1="", ccnam1="", **kwargs):
        """APDL Command: PMGTRAN

        Summarizes electromagnetic results from a transient analysis.

        Parameters
        ----------
        fname
            File name (8 characters maximum) to which tabular data and plot
            files will be written.  Must be enclosed in single quotes when the
            command is manually typed in.  Defaults to MG_TRNS.  The data file
            extension is .OUT and the plot file extension is .PLT.

        freq
            Frequency of solution output.  Defaults to 1.  Every FREQth
            solution on the results file is output.

        fcnam1, fcnam2
            Names of element components for force calculation.  Must be
            enclosed in single quotes when the command is manually typed in.

        pcnam1, pcnam2
            Names of element components for power loss calculation.  Must be
            enclosed in single quotes when the command is manually typed in.

        ecnam1, ccnam1
            Names of element components for energy and total current
            calculations, respectively.  Must be enclosed in single quotes when
            the command is manually typed in.

        Notes
        -----
        PMGTRAN invokes an ANSYS macro which calculates and summarizes
        electromagnetic results from a transient analysis.  The results are
        summarized by element components and listed on the screen as well as
        written to a file (Fname.OUT).  Also, graph plots of results as a
        function of time are created and written to a file (Fname.PLT) for use
        in the DISPLAY program.

        Two components may be selected for the summary of electromagnetic
        forces (see FMAGSUM), two for power loss, and one each for stored
        energy (see SENERGY) and total current (see CURR2D).  See the
        referenced commands for other restrictions.

        PMGTRAN is restricted to MKSA units.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "PMGTRAN,%s,%s,%s,%s,%s,%s,%s,%s" % (str(fname), str(freq), str(fcnam1), str(fcnam2), str(pcnam1), str(pcnam2), str(ecnam1), str(ccnam1))
        return self.run(command, **kwargs)

    def sexp(self, labr="", lab1="", lab2="", exp1="", exp2="", **kwargs):
        """APDL Command: SEXP

        Forms an element table item by exponentiating and multiplying.

        Parameters
        ----------
        labr
            Label assigned to results.  If same as existing label, the existing
            values will be overwritten by these results.

        lab1
            First labeled result item in operation.

        lab2
            Second labeled result item in operation (may be blank).

        exp1
            Exponent applied to Lab1.

        exp2
            Exponent applied to Lab2.

        Notes
        -----
        Forms a labeled result item (see ETABLE command) for the selected
        elements by exponentiating and multiplying two existing labeled result
        items according to the operation:

        LabR = (|Lab1|EXP1) x (|Lab2|EXP2)

        Roots, reciprocals, and divides may also be done with this command.
        """
        command = "SEXP,%s,%s,%s,%s,%s" % (str(labr), str(lab1), str(lab2), str(exp1), str(exp2))
        return self.run(command, **kwargs)

    def center(self, node="", node1="", node2="", node3="", radius="",
               **kwargs):
        """APDL Command: CENTER

        Defines a node at the center of curvature of 2 or 3 nodes.

        Parameters
        ----------
        node
            Number to be assigned to the node generated at the center of
            curvature.

        node1, node2, node3
            Three nodes used to calculated the center of curvature, as
            described under RADIUS.

        radius
            Used to control the interpretation of NODE1, NODE2 and NODE3:

            0 - NODE1, NODE2 and NODE3 lie on a circular arc.  The program will calculate the
                center of curvature (and radius) (default).

            ≠0 - NODE1 and NODE2 are the endpoints of an arc, and RADIUS is the radius of
                 curvature.  The program will locate the center of curvature on
                 the NODE3 side of the NODE1-NODE2 line if RADIUS > 0, and
                 opposite to NODE3 if RADIUS < 0.
        """
        command = "CENTER,%s,%s,%s,%s,%s" % (str(node), str(node1), str(node2), str(node3), str(radius))
        return self.run(command, **kwargs)

    def quad(self, node1="", nintr="", node2="", nfill="", nstrt="", ninc="",
             pkfac="", **kwargs):
        """APDL Command: QUAD

        Generates a quadratic line of nodes from three nodes.

        Parameters
        ----------
        node1
            Begin fill-in from this node location.  If NODE1 = P, graphical
            picking is enabled and all remaining command fields are ignored
            (valid only in the GUI).

        nintr
            Intermediate or guiding node.  Quadratic curve will pass through
            this location.  NINTR may have any node number and any location.
            If the quadratic line also generates a node with number NINTR, the
            generated location overrides the previous NINTR location.

        node2
            End quadratic fill-in at this node location.

        nfill
            Fill-in NFILL nodes between NODE1 and NODE2 (defaults to
            |NODE2-NODE1|-1).  NFILL must be positive.

        nstrt
            Node number assigned to first filled-in node (defaults to NODE1 +
            NINC).

        ninc
            Add this increment to each of the remaining filled-in node numbers
            (may be positive or negative).  Defaults to (NODE2-NODE1)/(NFILL +
            1), i.e., linear interpolation.

        pkfac
            Peak location factor.  If PKFAC=0.5, the peak of the quadratic
            shape occurs at the NINTR location.  If 0.0 < PKFAC < 0.5, the peak
            occurs to the NODE2 side of the NINTR location.  If 0.5 < PKFAC <
            1.0, the peak occurs to the NODE1 side of the NINTR location.
            Defaults to 0.5.

        Notes
        -----
        Generates a quadratic line of nodes (in the active coordinate system)
        from three nodes.  The three nodes determine the plane of the curve and
        may have been defined in any coordinate system.  Any number of nodes
        may be filled-in and any node number sequence may be assigned.

        The quadratic line feature uses three nodes (NODE1,NINTR,NODE2) to
        determine the plane of the curve.  The curve passes through the three
        points, beginning from NODE1, through the intermediate (or guiding)
        point NINTR, and toward NODE2.

        Generated nodes are also quadratically spaced.  If the guiding node
        number is within the set being generated, it will be relocated
        according to the quadratic spacing.

        The peak location factor is used to determine how the quadratic fits
        through the three points.  Various nodal progressions can be obtained
        by different combinations of PKFAC and the guiding node location.  If
        the guiding node is at mid-length between NODE1 and NODE2, 0.293:
        PKFAC< 0.707 will ensure that all generated nodes fall within the
        NODE1,NODE2 bounds.  In the limit, as PKFAC approaches 0.0, the peak
        approaches the line through NODE1 and NINTR at an infinite distance
        from NODE1.  The QUAD command generates quadratic lines of nodes, which
        in turn may be used as a base line for generating irregular surfaces of
        nodes (by repeating [*REPEAT], generating [NGEN, NSCALE], etc.).
        Irregular surfaces may also be generated with the meshing commands.
        """
        command = "QUAD,%s,%s,%s,%s,%s,%s,%s" % (str(node1), str(nintr), str(node2), str(nfill), str(nstrt), str(ninc), str(pkfac))
        return self.run(command, **kwargs)

    def slashclog(self, fname="", ext="", **kwargs):
        """APDL Command: /CLOG

        Copies the session log file to a named file.

        Parameters
        ----------
        fname
            File name and directory path to which the log file is to be copied
            (248 characters maximum, including directory). If you do not
            specify a directory path, it will default to your working directory
            and you can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        Notes
        -----
        This command is valid in any processor, but only during an interactive
        run.
        """
        command = "/CLOG,%s,%s" % (str(fname), str(ext))
        return self.run(command, **kwargs)

    def nlgeom(self, key="", **kwargs):
        """APDL Command: NLGEOM

        Includes large-deflection effects in a static or full transient
        analysis.

        Parameters
        ----------
        key
            Large-deflection key:

            OFF - Ignores large-deflection effects (that is, a small-deflection analysis is
                  specified). This option is the default.

            ON - Includes large-deflection (large rotation) effects or large strain effects,
                 according to the element type.

        Notes
        -----
        Large-deflection effects are categorized as either large deflection (or
        large rotation) or large strain, depending on the element type. These
        are listed (if available) under Special Features in the input data
        table for each element in the Element Reference. When large deflection
        effects are included (NLGEOM,ON), stress stiffening effects are also
        included automatically.

        If used during the solution (/SOLU), this command is valid only within
        the first load step.

        In a large-deflection analysis, pressure loads behave differently than
        other load types. For more information, see Load Direction in a Large-
        Deflection Analysis.

        The gyroscopic matrix (that occurs due to rotational angular velocity)
        does not support large-deflection effects. The theoretical formulations
        for the gyroscopic matrix support small deflection (linear formulation)
        only.

        When large-deflection effects are included in a substructure or CMS
        transient analysis use pass, the OUTRES command ignores DSUBres = ALL.

        This command is also valid in PREP7.

        In ANSYS Professional NLT, large deflection effects should not be
        turned on if 2-D solid (PLANEn) or 3-D solid (SOLIDn) elements are
        defined. ANSYS Professional NLS supports NLGEOM,ON for plane and solid
        elements.
        """
        command = "NLGEOM,%s" % (str(key))
        return self.run(command, **kwargs)

    def cgomga(self, cgomx="", cgomy="", cgomz="", **kwargs):
        """APDL Command: CGOMGA

        Specifies the rotational velocity of the global origin.

        Parameters
        ----------
        cgomx, cgomy, cgomz
            Rotational velocity of the global origin about the acceleration
            system X, Y, and Z axes.

        Notes
        -----
        Specifies the rotational velocity of the global origin about each of
        the acceleration coordinate system axes.  The location of the
        acceleration coordinate system is defined with the CGLOC command.
        Rotational velocities may be defined in analysis types ANTYPE,STATIC,
        HARMIC (full or mode-superposition), TRANS (full or mode-
        superposition), and SUBSTR.  See Acceleration Effect in the Mechanical
        APDL Theory Reference for details.  Units are radians/time.  Related
        commands are ACEL, CGLOC, DCGOMG,   DOMEGA, and OMEGA.

        See Analysis Tools in the Mechanical APDL Theory Reference for more
        information.

        The CGOMGA command supports tabular boundary conditions (%TABNAME_X%,
        %TABNAME_Y%, and %TABNAME_Z%) for CGOMGA_X, CGOMGA_Y, and CGOMGA_Z
        input values (*DIM) for full transient and harmonic analyses.

        This command is also valid in PREP7.
        """
        command = "CGOMGA,%s,%s,%s" % (str(cgomx), str(cgomy), str(cgomz))
        return self.run(command, **kwargs)

    def se(self, file="", toler="", **kwargs):
        """APDL Command: SE

        Defines a superelement.

        Parameters
        ----------
        file
            The name (case sensitive) of the file containing the original
            superelement matrix created by the generation pass (Sename.SUB).
            The default is the current Jobname.

        --, --
            Unused fields.

        toler
            Tolerance used to determine if use pass nodes are noncoincident
            with master nodes having the same node numbers.  Defaults to
            0.0001.  Use pass nodes will always be replaced by master nodes of
            the same node number.  However, if a use pass node is more than
            TOLER away from the corresponding master node, a warning is
            generated.

        Notes
        -----
        Defines a superelement by reading in the superelement matrices and
        master nodes from the superelement matrix file.  The matrix file
        (File.SUB) must be available from the substructure generation pass.
        The proper element type (MATRIX50) must be active [TYPE] for this
        command.  A scratch file called File.SORD showing the superelement
        names and their corresponding element numbers is also written.
        """
        command = "SE,%s,%s" % (str(file), str(toler))
        return self.run(command, **kwargs)

    def sfact(self, type="", **kwargs):
        """APDL Command: SFACT

        Allows safety factor or margin of safety calculations to be made.

        Parameters
        ----------
        type
            Type of calculation:

            0 - No nodal safety factor or margin of safety calculations.

            1 - Calculate and store safety factors in place of nodal stresses.

            2 - Calculate and store margins of safety in place of nodal stresses.

        Notes
        -----
        Allows safety factor (SF) or margin of safety (MS) calculations to be
        made for the average nodal stresses according to:

        SF = SALLOW/|Stress|

        MS = (SALLOW/|Stress|) -- 1.0

        Calculations are done during the display, select, or sort operation (in
        the active coordinate system [RSYS]) with results stored in place of
        the nodal stresses.  Use the PRNSOL or PLNSOL command to display the
        results.

        Note:: : The results are meaningful only for the stress (SIG1, SIGE,
        etc.) upon which SALLOW is based.  Nodal temperatures used are those
        automatically stored for the node.  Related commands are SFCALC,
        SALLOW, TALLOW.
        """
        command = "SFACT,%s" % (str(type))
        return self.run(command, **kwargs)

    def mmf(self, **kwargs):
        """APDL Command: MMF

        Calculates the magnetomotive force along a path.

        Notes
        -----
        MMF invokes an ANSYS macro which calculates the magnetomotive force
        (mmf) along a predefined path [PATH].  It  is valid for both 2-D and
        3-D magnetic field analyses.  The calculated mmf value is stored in the
        parameter MMF.

        A closed path [PATH], passing through the magnetic circuit for which
        mmf is to be calculated, must be defined before this command is issued.
        A counterclockwise ordering of points on the PPATH command will yield
        the correct sign on the mmf.  The mmf is based on Ampere's Law.  The
        macro makes use of calculated values of field intensity (H), and uses
        path operations for the calculations.  All path items are cleared upon
        completion.  The MMF macro sets the "ACCURATE" mapping method and "MAT"
        discontinuity option of the PMAP command.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "MMF," % ()
        return self.run(command, **kwargs)

    def enddo(self, **kwargs):
        """APDL Command: *ENDDO

        Ends a do-loop and starts the looping action.

        Notes
        -----
        One *ENDDO  is required for each nested do-loop. The *ENDDO command
        must appear on the same file as the  *DO command, and all six
        characters must be input.

        This command is valid in any processor.
        """
        command = "*ENDDO," % ()
        return self.run(command, **kwargs)

    def numcmp(self, label="", **kwargs):
        """APDL Command: NUMCMP

        Compresses the numbering of defined items.

        Parameters
        ----------
        label
            Items to be compressed:

            NODE - Node numbers

            ELEM - Element numbers

            KP - Keypoint numbers

            LINE - Line numbers

            AREA - Area numbers

            VOLU - Volume numbers

            MAT - Material numbers

            TYPE - Element type numbers

            REAL - Real constant numbers

            CP - Coupled set numbers

            SECN - Section numbers

            CE - Constraint equation numbers

            ALL - All item numbers

        Notes
        -----
        The NUMCMP command effectively compresses out unused item numbers by
        renumbering all the items, beginning with one and continuing throughout
        the model.  The renumbering order follows the initial item numbering
        order (that is, compression lowers the maximum number by "sliding"
        numbers down to take advantage of unused or skipped numbers).  All
        defined items are renumbered, regardless of whether or not they are
        actually used or selected.  Applicable related items are also checked
        for renumbering as described for the merge operation (NUMMRG).

        Compressing material numbers (NUMCMP,ALL or NUMCMP,MAT) does not update
        the material number referenced by either of the following:

        A temperature-dependent convection or surface-to-surface radiation load
        (SF, SFE, SFL, SFA)

        Real constants for multi-material elements (such as SOLID65)

         Compression is usually not required unless memory space is limited and
        there are large gaps in the numbering sequence.
        """
        command = "NUMCMP,%s" % (str(label))
        return self.run(command, **kwargs)

    def add(self, ir="", ia="", ib="", ic="", name="", facta="", factb="",
            factc="", **kwargs):
        """APDL Command: ADD

        Adds (sums) variables.

        Parameters
        ----------
        ir
            Arbitrary reference number assigned to the resulting variable (2 to
            NV [NUMVAR]).  If this number is the same as for a previously
            defined variable, the previously defined variable will be
            overwritten with this result.

        ia, ib, ic
            Reference numbers of the three variables to be operated on.  If
            only two variables, leave IC blank.  If only one, leave IB and IC
            blank.

        name
            Thirty-two character name for identifying the variable on the
            printout and displays.  Embedded blanks are compressed upon output.

        --, --
            Unused fields.

        facta, factb, factc
            Scaling factors (positive or negative) applied to the corresponding
            variables (default to 1.0).

        Notes
        -----
        Adds variables (up to three at once) according to the operation:

        IR = (FACTA x IA) + (FACTB x IB) + (FACTC x IC)
        """
        command = "ADD,%s,%s,%s,%s,%s,%s,%s,%s" % (str(ir), str(ia), str(ib), str(ic), str(name), str(facta), str(factb), str(factc))
        return self.run(command, **kwargs)

    def gcolumn(self, curve="", string="", **kwargs):
        """APDL Command: /GCOLUMN

        Allows the user to apply a label to a specified curve.

        Parameters
        ----------
        curve
            Curve number on which label will be applied (integer value between
            1 and 10).

        string
            Name or designation that will be applied to the curve (8 characters
            max).

        Notes
        -----
        This command is used for an array parameter plot (a plot created by the
        *VPLOT command).  Normally the label for curve 1 is "COL 1", the label
        for curve 2 is "COL 2" and so on; the column number is the field
        containing the dependent variables for that particular curve. Issuing
        /GCOLUMN,CURVE, with no string value specified resets the label to the
        original value.
        """
        command = "/GCOLUMN,%s,%s" % (str(curve), str(string))
        return self.run(command, **kwargs)

    def jsol(self, nvar="", elem="", item="", comp="", name="", **kwargs):
        """APDL Command: JSOL

        Specifies result items to be stored for the joint element.

        Parameters
        ----------
        nvar
            Arbitrary reference number or name assigned to this variable.
            Variable numbers can be 2 to NV (NUMVAR) while the name can be an
            eight-byte character string. Overwrites any existing results for
            this variable.

        elem
            Element number for which to store results.

        item
            Label identifying the item.  Valid item labels are shown in
            Table 202: JSOL - Valid Item and Component Labels below.

        comp
            Component of the Item (if required).  Valid component labels are
            shown in Table 202: JSOL - Valid Item and Component Labels below.

        name
            Thirty-two character name identifying the item on printouts and
            displays.  Defaults to a label formed by concatenating the first
            four characters of the Item and Comp labels.

        Notes
        -----
        This command is valid for the MPC184 joint elements. The values stored
        are for the free or unconstrained degrees of freedom of a joint
        element. Relative reaction forces and moments are available only if
        stiffness, damping, or friction is associated with the joint element.

        Table: 202:: : JSOL - Valid Item and Component Labels


        """
        command = "JSOL,%s,%s,%s,%s,%s" % (str(nvar), str(elem), str(item), str(comp), str(name))
        return self.run(command, **kwargs)

    def emore(self, q="", r="", s="", t="", u="", v="", w="", x="", **kwargs):
        """APDL Command: EMORE

        Adds more nodes to the just-defined element.

        Parameters
        ----------
        q, r, s, t, u, v, w, x
            Numbers of nodes typically assigned to ninth (node Q) through
            sixteenth (node X) nodal positions, if any. If Q = P, graphical
            picking is enabled and all remaining command fields are ignored
            (valid only in the GUI).

        Notes
        -----
        Repeat EMORE command for up to 4 additional nodes (20 maximum). Nodes
        are added after the last nonzero node of the element.  Node numbers
        defined with this command may be zeroes.
        """
        command = "EMORE,%s,%s,%s,%s,%s,%s,%s,%s" % (str(q), str(r), str(s), str(t), str(u), str(v), str(w), str(x))
        return self.run(command, **kwargs)

    def pmacro(self, **kwargs):
        """APDL Command: /PMACRO

        Specifies that macro contents be written to the session log file.

        Notes
        -----
        This command forces the contents of a macro or other input file to be
        written to Jobname.LOG.  It is valid only within a macro or input file,
        and should be placed at the top of the file.  /PMACRO should be
        included in any macro or input file that calls GUI functions.
        """
        command = "/PMACRO," % ()
        return self.run(command, **kwargs)

    def fk(self, kpoi="", lab="", value="", value2="", **kwargs):
        """APDL Command: FK

        Defines force loads at keypoints.

        Parameters
        ----------
        kpoi
            Keypoint at which force is to be specified.  If ALL, apply to all
            selected keypoints [KSEL].  If KPOI = P, graphical picking is
            enabled and all remaining command fields are ignored (valid only in
            the GUI).  A component name may also be substituted for KPOI.

        lab
            Valid force label.  Structural labels:  FX, FY, or FZ (forces); MX,
            MY, or MZ (moments).  Thermal labels:  HEAT, HBOT, HE2, HE3, . . .,
            HTOP (heat flow).  Fluid labels:  FLOW (fluid flow).  Electric
            labels:  AMPS (current flow), CHRG (electric charge).  Magnetic
            labels:  FLUX (magnetic flux);  CSGX, CSGY, or CSGZ (magnetic
            current segments). Diffusion labels: RATE (diffusion flow rate).

        value
            Force value or table name reference for specifying tabular boundary
            conditions.  To specify a table, enclose the table name in percent
            signs (%), e.g., FK, KPOI, HEAT,%tabname%).  Use the *DIM command
            to define a table.

        value2
            Second force value (if any).  If the analysis type and the force
            allow a complex input, VALUE (above) is the real component and
            VALUE2 is the imaginary component.

        Notes
        -----
        Forces may be transferred from keypoints to nodes with the FTRAN or
        SBCTRAN commands.  See the F command for a description of force loads.

        Tabular boundary conditions (VALUE = %tabname%) are available only for
        the following labels: Fluid (FLOW), Electric (AMPS), Structural force
        (FX, FY, FZ, MX, MY, MZ), and Thermal (HEAT, HBOT, HE2, HE3, . . .,
        HTOP).

        This command is also valid in PREP7.
        """
        command = "FK,%s,%s,%s,%s" % (str(kpoi), str(lab), str(value), str(value2))
        return self.run(command, **kwargs)

    def rsopt(self, opt="", filename="", ext="", dir="", **kwargs):
        """APDL Command: RSOPT

        Creates or loads the radiosity mapping data file for SURF251 or SURF252
        element types.

        Parameters
        ----------
        opt
            File option:

            SAVE - Write the radiosity mapping data to a file. (Default)

            LOAD - Read in the specified mapping data file.

        fname
            File name for radiosity mapping data file. Defaults to Jobname.

        ext
            Filename extension for radiosity mapping data file (default =
            .rsm).

        dir
            Directory path for radiosity mapping data file. If you do not
            specify a directory path, it will default to your working
            directory.

        Notes
        -----
        Use this command to manually create or load a radiosity mapping data
        file. This command is useful if you want to create the mapping data
        file without issuing SAVE or CDWRITE, or if you want to specify that
        the file be located in a directory other than your working directory.
        Also use this command to manually load an existing mapping data file
        during a restart.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "RSOPT,%s,%s,%s,%s" % (str(opt), str(filename), str(ext), str(dir))
        return self.run(command, **kwargs)

    def pnum(self, label="", key="", **kwargs):
        """APDL Command: /PNUM

        Controls entity numbering/coloring on plots.

        Parameters
        ----------
        label
            Type of numbering/coloring:

            NODE - Node numbers on node and element plots.

            ELEM - Element numbers and colors on element plots.

            SEC - Section numbers and colors on element and solid model plots (see "Notes").

            MAT - Material set numbers and colors on element and solid model plots  (see
                  "Notes").

            TYPE - Element type reference numbers and colors on element and solid model plots (see
                   "Notes").

            REAL - Real constant set numbers and colors on element and solid model plots (see
                   "Notes").

            ESYS - Element coordinate system numbers on element and solid model plots (see
                   "Notes").

            PART - Element part numbers and colors on element plots (applicable to ANSYS LS-DYNA
                   only).

            LOC - Location numbers/colors of the element in matrix assembly order on element
                  plots.

            Note:LOC and ELEM numbers will be the same unless the model has been reordered. - KP

            Keypoint numbers on solid model plots. - LINE

            Line numbers on solid model plots (both numbers and colors on line plots). - AREA

            Area numbers on solid model plots (both numbers and colors on area plots). - VOLU

            Volume numbers on solid model plots (both numbers and colors on volume plots). - SVAL

            Stress (or any contour) values on postprocessing plots, and surface load values and colors on model plots (when surface load symbols are on [/PSF]).  For tabular boundary conditions, the table-evaluated values will be displayed on node, element, or contour displays in POST1 when load symbols (/PBF, /PSF, /PBC) are on and TABNAM is OFF. - TABNAM

            Table names for tabular boundary conditions.  If this label is turned on, the table name appears next to the appropriate symbol, arrow, face outline, or contour as dictated by the /PSF, /PBC, and /PBF commands. - STAT

            Shows current settings for /PNUM. - DEFA

        key
            Switch:

            0 - Turns OFF numbers/colors for specified label.

            1 - Turns ON numbers/colors for specified label.

        Notes
        -----
        This command specifies entity numbering and coloring for subsequent
        plots.

        The MAT, TYPE, REAL, and ESYS labels activate both the numbering and
        coloring of the corresponding attributes for  EPLOT, KPLOT, LPLOT,
        APLOT, and VPLOT. The ELEM, MAT, TYPE, REAL, ESYS, PART (ANSYS LS-DYNA
        only), and LOC labels are mutually exclusive, i.e., only one can be
        specified at a time. Also, turning on a LINE, AREA, or VOLU label will
        turn off the MAT, TYPE, REAL, and PART labels.

        PowerGraphics [/GRAPHICS,POWER] displays for/PNUM can be problematic.
        /PNUM,ELEM will display erratically depending on other display command
        specifications, while /PNUM,LOC and /PNUM,ESYS are not supported.

        Element and volume numbers are not visible for 3-D elements and volumes
        when Z-buffering is turned on (/TYPE,,[6,7, or 8]).

        Use /PSTATUS or /PNUM,STAT to show settings. Use /PNUM,DEFA to reset
        all specifications back to default. Use the /NUMBER command to control
        whether numbers and colors are displayed together.

        This command is valid in any processor
        """
        command = "/PNUM,%s,%s" % (str(label), str(key))
        return self.run(command, **kwargs)

    def rmsave(self, fname="", ext="", **kwargs):
        """APDL Command: RMSAVE

        Saves ROM data to file.

        Parameters
        ----------
        fname
            Name and directory path of the ROM database file. Default to
            Jobname.

        ext
            Extension of the ROM database file. Default to .rom.

        --
            Unused field.

        Notes
        -----
        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "RMSAVE,%s,%s" % (str(fname), str(ext))
        return self.run(command, **kwargs)

    def xfdata(self, enrichmentid="", elemnum="", nodenum="", phi="",
               **kwargs):
        """APDL Command: XFDATA

        Defines a crack in the model by specifying nodal level set values

        Parameters
        ----------
        enrichmentid
            Name of the enrichment specified via the associated XFENRICH
            command.

        lsm (or blank)
            Specify LSM to indicate that level set values (PHI and optional
            PSI) are specified.

        elemnum
            Element number.

        nodenum
            Node number associated with the specified element ELNUM.

        phi
            Signed normal distance of the node from the crack.

        Notes
        -----
        Issue the XFDATA command multiple times as needed to specify nodal
        level set values for all nodes of an element.

        This command is valid in PREP7 (/PREP7) only.
        """
        command = "XFDATA,%s,%s,%s,%s" % (str(enrichmentid), str(elemnum), str(nodenum), str(phi))
        return self.run(command, **kwargs)

    def prrfor(self, lab="", **kwargs):
        """APDL Command: PRRFOR

        Prints the constrained node reaction solution. Used with the FORCE
        command.

        Parameters
        ----------
        lab
            Nodal reaction load type.  If blank, use the first ten of all
            available labels. Valid labels are:

        Notes
        -----
        PRRFOR has the same functionality as the PRRSOL command; use PRRFOR
        instead of PRRSOL when a FORCE command has been issued.

        In a non-spectrum analysis, if either contact or pretension elements
        exist in the model, PRRFOR uses the PRRSOL command internally and the
        FORCE setting is ignored.

        Because modal displacements cannot be used to calculate contact element
        nodal forces,: those forces are not included in the spectrum and PSD
        analyses reaction solution. As a consequence, the: PRRFOR: command is
        not supported when constraints on contact element pilot nodes are
        present.
        """
        command = "PRRFOR,%s" % (str(lab))
        return self.run(command, **kwargs)

    def slashfdele(self, ident="", stat="", **kwargs):
        """APDL Command: /FDELE

        Deletes a binary file after it is used.

        Parameters
        ----------
        ident
            ANSYS file name identifier.  Valid identifiers are:  EMAT, ESAV,
            FULL, SUB, MODE, DSUB, USUB, OSAV, and SELD.  See the Basic
            Analysis Guide for file descriptions.

        stat
            Keep or delete key:

            KEEP - Keep this file.

            DELE - Delete (or do not write, if not necessary) this file.

        Notes
        -----
        Deletes as soon as possible (or prevents writing) a binary file created
        by the ANSYS program to save space.

        Caution:: : Deleting files that are necessary for the next substep,
        load step, or analysis will prevent continuation of the run.

        This command is valid only at the Begin Level.
        """
        command = "/FDELE,%s,%s" % (str(ident), str(stat))
        return self.run(command, **kwargs)

    def solu(self, nvar="", item="", comp="", name="", **kwargs):
        """APDL Command: SOLU

        Specifies solution summary data per substep to be stored.

        Parameters
        ----------
        nvar
            Arbitrary reference number assigned to this variable (2 to NV
            [NUMVAR]).

        item
            Label identifying the item.  Valid item labels are shown in the
            table below.  Some items may also require a component label.

        comp
            Component of the item (if required).  Valid component labels are
            shown in the table below.  None are currently required.

        name
            Thirty-two character name identifying the item on printouts and
            displays.  Defaults to an eight character label formed by
            concatenating the first four characters of the Item and Comp
            labels.

        Notes
        -----
        See also the PRITER command of POST1 to display some of these items
        directly.  Valid for a static or full transient analysis. All other
        analyses have zeros for the data. Valid item and component labels for
        solution summary values are:
        """
        command = "SOLU,%s,%s,%s,%s" % (str(nvar), str(item), str(comp), str(name))
        return self.run(command, **kwargs)

    def emft(self, **kwargs):
        """APDL Command: EMFT

        Summarizes electromagnetic forces and torques.

        Notes
        -----
        Use this command to summarize electromagnetic force and torque in both
        static electric and magnetic problems. To use this command, select the
        nodes in the region of interest and make sure that all elements are
        selected. If RSYS = 0, the force is reported in the global Cartesian
        coordinate system. If RSYS ≠ 0, force is reported in the specified
        coordinate system. However, for torque, if RSYS ≠ 0, this command will
        account for the shift and rotation as specified by RSYS, but will
        report only the Cartesian components.

        Forces are stored as items _FXSUM, _FYSUM, _FZSUM, and _FSSUM. Torque
        is stored as items _TXSUM, _TYSUM, _TZSUM, and _TSSUM.

        This command is valid only with PLANE121, SOLID122, SOLID123, PLANE233,
        SOLID236 and SOLID237 elements. For any other elements, you must use
        FMAGSUM.
        """
        command = "EMFT," % ()
        return self.run(command, **kwargs)

    def selist(self, sename="", kopt="", kint="", **kwargs):
        """APDL Command: SELIST

        Lists the contents of a superelement matrix file.

        Parameters
        ----------
        sename
            The name (case-sensitive) of the superelement matrix file created
            by the substructure generation pass (Sename.SUB).   Defaults to the
            current Jobname.  If a number, it is the element number of the
            superelement as used in the use pass.

        kopt
            List key:

            0 - List summary data only.

            1 - List contents, except load vectors and matrices.

            2 - List contents, except matrices.

            3 - List full contents.  Be aware that the listing may be extensive.

        kint
            Integer printout format key:

            OFF - Default.

            ON - Long format for large integers.

        Notes
        -----
        This command is valid in any processor.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "SELIST,%s,%s,%s" % (str(sename), str(kopt), str(kint))
        return self.run(command, **kwargs)

    def knode(self, npt="", node="", **kwargs):
        """APDL Command: KNODE

        Defines a keypoint at an existing node location.

        Parameters
        ----------
        npt
            Arbitrary reference number for keypoint.  If zero, the lowest
            available number is assigned [NUMSTR].

        node
            Node number defining global X, Y, Z keypoint location.  If NODE =
            P, graphical picking is enabled and all remaining command fields
            are ignored (valid only in the GUI).  A component name may also be
            substituted for NODE.
        """
        command = "KNODE,%s,%s" % (str(npt), str(node))
        return self.run(command, **kwargs)

    def ndist(self, nd1="", nd2="", **kwargs):
        """APDL Command: NDIST

        Calculates and lists the distance between two nodes.

        Parameters
        ----------
        nd1
            First node in distance calculation.  If ND1 = P, graphical picking
            is enabled and all remaining command fields are ignored (valid only
            in the GUI).

        nd2
            Second node in distance calculation.

        Notes
        -----
        NDIST lists the distance between nodes ND1 and ND2, as well as the
        current coordinate system offsets from ND1 to ND2, where the X, Y, and
        Z locations of ND1 are subtracted from the X, Y, and Z locations of ND2
        (respectively) to determine the offsets.  NDIST is valid in any
        coordinate system except toroidal [CSYS,3].

        NDIST returns a variable, called "_RETURN," which contains the distance
        value. You can use this value for various purposes, such as the
        calculation of distributed loads. In interactive mode, you can access
        this command by using the Model Query Picker (Utility Menu> List>
        Picked Entities), where you can also access automatic annotation
        functions and display the value on your model.

        This command is valid in any processor.
        """
        command = "NDIST,%s,%s" % (str(nd1), str(nd2))
        return self.run(command, **kwargs)

    def smax(self, labr="", lab1="", lab2="", fact1="", fact2="", **kwargs):
        """APDL Command: SMAX

        Forms an element table item from the maximum of two other items.

        Parameters
        ----------
        labr
            Label assigned to results.  If same as existing label, the existing
            values will be overwritten by these results.

        lab1
            First labeled result item in operation.

        lab2
            Second labeled result item in operation (may be blank).

        fact1
            Scale factor applied to Lab1. A (blank) or '0' entry defaults to
            1.0.

        fact2
            Scale factor applied to Lab2. A (blank) or '0' entry defaults to
            1.0.

        Notes
        -----
        Forms a labeled result item (see ETABLE command) for the selected
        elements by comparing two existing labeled result items according to
        the operation:

        LabR = (FACT1 x Lab1) cmx (FACT2 x Lab2)

        where "cmx" means "compare and save maximum."  If absolute values are
        requested [SABS,1], the absolute values of Lab1 and Lab2 are used.
        """
        command = "SMAX,%s,%s,%s,%s,%s" % (str(labr), str(lab1), str(lab2), str(fact1), str(fact2))
        return self.run(command, **kwargs)

    def emf(self, **kwargs):
        """APDL Command: EMF

        Calculates the electromotive force (emf), or voltage drop along a
        predefined path.

        Notes
        -----
        EMF invokes an ANSYS macro which calculates the electromotive force
        (emf), or voltage drop along a predefined path (specified with the PATH
        command). It is valid for both 2-D and 3-D electric field analysis or
        high-frequency electromagnetic field analysis. The calculated emf value
        is stored in the parameter EMF.

        You must define a line path (via the PATH command) before issuing the
        EMF command macro. The macro uses calculated values of the electric
        field (EF), and uses path operations for the calculations. All path
        items are cleared when the macro finishes executing.

        The EMF macro sets the "ACCURATE" mapping method and "MAT"
        discontinuity option on the PMAP command. The ANSYS program retains
        these settings after executing the macro.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EMF," % ()
        return self.run(command, **kwargs)

    def igesin(self, fname="", ext="", **kwargs):
        """APDL Command: IGESIN

        Transfers IGES data from a file into ANSYS.

        Parameters
        ----------
        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        Notes
        -----
        Reads a file containing IGES data and transfers it into the ANSYS
        database.  The file transferred is the IGES Version 5.1, ASCII format
        file.  IGES (Initial Graphics Exchange Specification) is a neutral
        format developed by the U.S. Dept. of Commerce, National Institute of
        Standards and Technology.  There is no output transfer file written
        since the transferred data is read directly into the ANSYS database.

        You can import multiple files into a single database, but you must use
        the same import option (set with the IOPTN command) for each file.

        The IOPTN command sets the parameters for reading the file.  Files read
        via the SMOOTH method (the only available method) use the standard
        database.
        """
        command = "IGESIN,%s,%s" % (str(fname), str(ext))
        return self.run(command, **kwargs)

    def mater(self, **kwargs):
        """APDL Command: MATER

        Specifies "Material properties" as the subsequent status topic.

        Notes
        -----
        This is a status [STAT] topic command.  Status topic commands are
        generated by the GUI and will appear in the log file (Jobname.LOG) if
        status is requested for some items under Utility Menu> List> Status.
        This command will be immediately followed by a STAT command, which will
        report the status for the specified topic.

        If entered directly into the program, the STAT command should
        immediately follow this command.
        """
        command = "MATER," % ()
        return self.run(command, **kwargs)

    def cfopen(self, fname="", ext="", loc="", **kwargs):
        """APDL Command: *CFOPEN

        Opens a "command" file.

        Parameters
        ----------
        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        loc
            Determines whether existing file will be overwritten or appended:

            The existing file will be overwritten. - The file will be appended to the existing file.

        Notes
        -----
        Data processed with the *VWRITE command will also be written to this
        file if the file is open when the *VWRITE command is issued.

        This command is valid in any processor.
        """
        command = "*CFOPEN,%s,%s,%s" % (str(fname), str(ext), str(loc))
        return self.run(command, **kwargs)

    def pldisp(self, kund="", **kwargs):
        """APDL Command: PLDISP

        Displays the displaced structure.

        Parameters
        ----------
        kund
            Undisplaced shape key:

            0 - Display only displaced structure.

            1 - Overlay displaced display with similar undisplaced display (appearance is
                system-dependent).

            2 - Same as 1 except overlay with undisplaced edge display (appearance is system-
                dependent).

        Notes
        -----
        Displays the displaced structure for the selected elements.

        For information on true scale plots, refer to the description of the
        /DSCALE command [/DSCALE,,1.0].
        """
        command = "PLDISP,%s" % (str(kund))
        return self.run(command, **kwargs)

    def chkmsh(self, comp="", **kwargs):
        """APDL Command: CHKMSH

        Checks area and volume entities for previous meshes.

        Parameters
        ----------
        comp
            Name of component containing areas or volumes.

        Notes
        -----
        CHKMSH invokes a predefined ANSYS macro that checks areas and volumes
        to find out if they were previously meshed.  This macro name will
        appear in the log file (Jobname.LOG) prior to area and volume meshing
        operations initiated through the GUI.  This command is not intended to
        be typed in directly in an ANSYS session (although it can be included
        in an input file for use with the /INPUT command).
        """
        command = "CHKMSH,%s" % (str(comp))
        return self.run(command, **kwargs)

    def edasmp(self, option="", _asmid="", part1="", part2="", part3="",
               part4="", part5="", part6="", part7="", part8="", part9="",
               part10="", part11="", part12="", part13="", part14="",
               part15="", part16="", **kwargs):
        """APDL Command: EDASMP

        Creates a part assembly to be used in an explicit dynamic analysis.

        Parameters
        ----------
        option
            Label identifying the part assembly option to be performed.

            ADD - Adds a part assembly (default).

            DELETE - Deletes a part assembly.

            LIST - Lists each part assembly number, and the part numbers that make up each part
                   assembly.

        asmid
             User defined part assembly ID number. The part assembly number
            cannot be the same as any currently defined part ID number.

        part1, part2, part3, . . . , part16
            Part numbers to be included in the assembly (up to 16 different
            parts).

        Notes
        -----
        Several ANSYS LS-DYNA commands (such as EDCGEN, EDPVEL, and EDIS) refer
        to assembly ID numbers. If you intend to use assembly ID numbers with
        these commands, you must first define the assembly ID numbers using
        EDASMP.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDASMP,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(option), str(_asmid), str(part1), str(part2), str(part3), str(part4), str(part5), str(part6), str(part7), str(part8), str(part9), str(part10), str(part11), str(part12), str(part13), str(part14), str(part15), str(part16))
        return self.run(command, **kwargs)

    def vput(self, par="", ir="", tstrt="", kcplx="", name="", **kwargs):
        """APDL Command: VPUT

        Moves an array parameter vector into a variable.

        Parameters
        ----------
        par
            Array parameter vector in the operation.

        ir
            Arbitrary reference number assigned to this variable (1 to NV
            [NUMVAR]).  Overwrites any existing results for this variable.

        tstrt
            Time (or frequency) corresponding to start of IR data.  If between
            values, the nearer value is used.

        kcplx
            Complex number key:

            0 - Use the real part of the IR data.

            1 - Use the imaginary part of the IR data.

        name
            Thirty-two character name identifying the item on printouts and
            displays. Defaults to the label formed by concatenating VPUT with
            the reference number IR.

        Notes
        -----
        At least one variable should be defined (NSOL, ESOL, RFORCE, etc.)
        before using this command.  The starting array element number must be
        defined.  For example, VPUT,A(1),2 moves array parameter A to variable
        2 starting at time 0.0.  Looping continues from array element A(1) with
        the index number incremented by one until the variable is filled.
        Unfilled variable locations are assigned a zero value.  The number of
        loops may be controlled with the *VLEN command (except that loop
        skipping (NINC) is not allowed).  For multi-dimensioned array
        parameters, only the first (row) subscript is incremented.
        """
        command = "VPUT,%s,%s,%s,%s,%s" % (str(par), str(ir), str(tstrt), str(kcplx), str(name))
        return self.run(command, **kwargs)

    def int1(self, ir="", iy="", ix="", name="", facta="", factb="", const="",
             **kwargs):
        """APDL Command: INT1

        Integrates a variable.

        Parameters
        ----------
        ir
            Arbitrary reference number assigned to the resulting variable (2 to
            NV [NUMVAR]).  If this number is the same as for a previously
            defined variable, the previously defined variable will be
            overwritten with this result.  Table values represent integrated
            sum of IY to current table position of IX.

        iy, ix
            Integrate variable IY with respect to IX.

        --
            Unused field.

        name
            Thirty-two character name for identifying the variable on the
            printout and displays.  Embedded blanks are compressed upon output.

        --, --
            Unused fields.

        facta, factb
            Scaling factors (positive or negative) applied to the corresponding
            variables (default to 1.0).

        const
            Initial value.

        Notes
        -----
        Integrates variables according to the operation:

        IR = ∫ (FACTA x IY) d(FACTB x IX) + CONST
        """
        command = "INT1,%s,%s,%s,%s,%s,%s,%s" % (str(ir), str(iy), str(ix), str(name), str(facta), str(factb), str(const))
        return self.run(command, **kwargs)

    def kscon(self, npt="", delr="", kctip="", nthet="", rrat="", **kwargs):
        """APDL Command: KSCON

        Specifies a keypoint about which an area mesh will be skewed.

        Parameters
        ----------
        npt
            Keypoint number at concentration.  If NPT = ALL, use all selected
            keypoints.  If remaining fields are blank, remove concentration
            from this keypoint (if unmeshed).  If NPT = P, graphical picking is
            enabled and all remaining command fields are ignored (valid only in
            the GUI).  A component name may also be substituted for NPT.

        delr
            Radius of first row of elements about keypoint.

        kctip
            Crack tip singularity key:

            0 - Do not skew midside nodes, if any, within the element.

            1 - Skew midside nodes of the first row of elements to the 1/4 point for crack tip
                singularity.

        nthet
            Number of elements in circumferential direction (defaults to
            approximately one per 45° (or one per 30°, if KCTIP = 1)).

        rrat
            Ratio of 2nd row element size to DELR (defaults to 0.75, or 0.5 if
            KCTIP = 1).

        Notes
        -----
        Defines a concentration keypoint about which an area mesh will be
        skewed. Useful for modeling stress concentrations and crack tips.
        During meshing, elements are initially generated circumferentially
        about, and radially away, from the keypoint. Lines attached to the
        keypoint are given appropriate divisions and spacing ratios. Only one
        concentration keypoint per unmeshed area is allowed.  Use KSCON,STAT to
        list current status of concentration keypoints. The KSCON command does
        not support 3-D modeling.

        This command is also valid for rezoning.
        """
        command = "KSCON,%s,%s,%s,%s,%s" % (str(npt), str(delr), str(kctip), str(nthet), str(rrat))
        return self.run(command, **kwargs)

    def rmmlist(self, **kwargs):
        """APDL Command: RMMLIST

        Lists all mode specifications for the ROM method.

        Notes
        -----
        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "RMMLIST," % ()
        return self.run(command, **kwargs)

    def pspec(self, pcolor="", kfill="", kbordr="", **kwargs):
        """APDL Command: /PSPEC

        Creates annotation polygon attributes (GUI).

        Parameters
        ----------
        pcolor
            Polygon color (0  PCOLOR   15):

            0 - Black.

            1 - Red-Magenta.

            2 - Magenta.

            3 - Blue-Magenta.

            4 - Blue.

            5 - Cyan-Blue.

            6 - Cyan.

            7 - Green-Cyan.

            8 - Green.

            9 - Yellow-Green.

            10 - Yellow.

            11 - Orange.

            12 - Red.

            13 - Dark Gray.

            14 - Light Gray.

            15 - White.

        kfill
            Polygon fill key:

            0 - Hollow polygon.

            1 - Filled polygon.

        kbordr
            Polygon border key:

            0 - No border.

            1 - Border.

        Notes
        -----
        Creates annotation polygon attributes to control certain
        characteristics of the polygons created via the /POLYGON, /PMORE,
        /PCIRCLE and /PWEDGE commands.  This is a command generated by the
        Graphical User Interface (GUI) and will appear in the log file
        (Jobname.LOG) if annotation is used.  This command is not intended to
        be typed in directly in an ANSYS session (although it can be included
        in an input file for batch input or for use with the /INPUT command).

        This command is valid in any processor.
        """
        command = "/PSPEC,%s,%s,%s" % (str(pcolor), str(kfill), str(kbordr))
        return self.run(command, **kwargs)

    def gline(self, wn="", style="", **kwargs):
        """APDL Command: /GLINE

        Specifies the element outline style.

        Parameters
        ----------
        wn
            Window number (or ALL) to which command applies (defaults to 1).

        style
            Outline key:

             0  - Solid element outlines (default)

             1  - Dashed element outlines

            -1  - No element outlines

        Notes
        -----
        Determines the element outline style.  Often used when node numbers are
        displayed to prevent element lines from overwriting node numbers.

        Unless you are using an OpenGL or Starbase driver, the dashed element
        outline option (/GLINE,WN,1) is not available in the following
        situations:

        Z-buffered displays (/TYPE,WN,6).

        Capped Z-buffered displays (/TYPE,WN,7).

        Qslice Z-buffered displays (/TYPE,WN,8).

        This command is valid in any processor.
        """
        command = "/GLINE,%s,%s" % (str(wn), str(style))
        return self.run(command, **kwargs)

    def nprint(self, n="", **kwargs):
        """APDL Command: NPRINT

        Defines which time points stored are to be listed.

        Parameters
        ----------
        n
            List data associated with every N time (or frequency) point(s),
            beginning with the first point stored (defaults to 1).

        Notes
        -----
        Defines which time (or frequency) points within the range stored are to
        be listed.
        """
        command = "NPRINT,%s" % (str(n))
        return self.run(command, **kwargs)

    def nsla(self, type="", nkey="", **kwargs):
        """APDL Command: NSLA

        Selects those nodes associated with the selected areas.

        Parameters
        ----------
        type
            Label identifying the type of node select:

            S - Select a new set (default).

            R - Reselect a set from the current set.

            A - Additionally select a set and extend the current set.

            U - Unselect a set from the current set.

        nkey
            Specifies whether only interior area nodes are to be selected:

            0 - Select only nodes interior to selected areas.

            1 - Select all nodes (interior to area, interior to lines, and at keypoints)
                associated with the selected areas.

        Notes
        -----
        Valid only if the nodes were generated by an area meshing operation
        [AMESH, VMESH] on a solid model that contains the selected areas.

        This command is valid in any processor.
        """
        command = "NSLA,%s,%s" % (str(type), str(nkey))
        return self.run(command, **kwargs)

    def addam(self, af="", aa="", ab="", ac="", ad="", amin="", **kwargs):
        """APDL Command: ADDAM

        Specifies the acceleration spectrum computation constants for the
        analysis of shock resistance of shipboard structures.

        Parameters
        ----------
        af
            Direction-dependent acceleration coefficient for elastic or
            elastic-plastic analysis option (default = 0).

        aa, ab, ac, ad
            Coefficients for the DDAM acceleration spectrum equations. Default
            for these coefficients is zero.

        amin
            The minimum acceleration value in inch/sec2.  It defaults to 2316
            inch/sec2 which equals 6g, where g is acceleration due to gravity
            (g = 386 inch/sec2).

        Notes
        -----
        This command specifies acceleration coefficients to analyze shock
        resistance of shipboard equipment.  These coefficients are used to
        compute mode coefficients according to the equations given in Dynamic
        Design Analysis Method in the Mechanical APDL Theory Reference.  The
        form of these equations is based on the Naval NRL Dynamic Design
        Analysis Method.  This command, along with the VDDAM and SED commands,
        is used with the spectrum (ANTYPE,SPECTR) analysis as a special purpose
        alternative to the SV, FREQ, and SVTYP commands.  The mass and length
        units of the model must be in pounds and inches, respectively.

        DDASPEC may alternatively be used to calculate spectrum coefficients.

        This command is also valid in PREP7.
        """
        command = "ADDAM,%s,%s,%s,%s,%s,%s" % (str(af), str(aa), str(ab), str(ac), str(ad), str(amin))
        return self.run(command, **kwargs)

    def quit(self, **kwargs):
        """APDL Command: /QUIT

        Exits a processor.

        Notes
        -----
        This is an alternative to the FINISH command.  If any cleanup or file
        writing is normally done by the FINISH command, it is bypassed if the
        /QUIT command is used instead.  A new processor may be entered after
        this command.  See the /EXIT command to terminate the run.

        This command is valid in any processor.  This command is not valid at
        the Begin level.
        """
        command = "/QUIT," % ()
        return self.run(command, **kwargs)

    def esol(self, nvar="", elem="", node="", item="", comp="", name="",
             **kwargs):
        """APDL Command: ESOL

        Specifies element data to be stored from the results file.

        Parameters
        ----------
        nvar
            Arbitrary reference number assigned to this variable (2 to NV
            [NUMVAR]). Overwrites any existing results for this variable.

        elem
            Element for which data are to be stored. If ELEM = P, graphical
            picking is enabled (valid only in the GUI).

        node
            Node number on this element for which data are to be stored. If
            blank, store the average element value (except for FMAG values,
            which are summed instead of averaged). If NODE = P, graphical
            picking is enabled (valid only in the GUI).

        item
            Label identifying the item. General item labels are shown in
            Table 134: ESOL - General Item and Component Labels below. Some
            items also require a component label.

        comp
            Component of the item (if required). General component labels are
            shown in Table 134: ESOL - General Item and Component Labels below.
            If Comp is a sequence number (n), the NODE field will be ignored.

        name
            Thirty-two character name for identifying the item on the printout
            and displays.  Defaults to a label formed by concatenating the
            first four characters of the Item and Comp labels.

        Notes
        -----
        See Table: 134:: ESOL - General Item and Component Labels for a list of
        valid item and component labels for element (except line element)
        results.

        The ESOL command defines element results data to be stored from a
        results file (FILE). Not all items are valid for all elements. To see
        the available items for a given element, refer to the input and output
        summary tables in the documentation for that element.

        Two methods of data access are available via the ESOL command. You can
        access some simply by using a generic label (component name method),
        while others require a label and number (sequence number method).

        Use the component name method to access general element data (that is,
        element data generally available to most element types or groups of
        element types).

        The sequence number method is required for data that is not averaged
        (such as pressures at nodes and temperatures at integration points), or
        data that is not easily described in a generic fashion (such as all
        derived data for structural line elements and contact elements, all
        derived data for thermal line elements, and layer data for layered
        elements).

        Element results are in the element coordinate system, except for
        layered elements where results are in the layer coordinate system.
        Element forces and moments are in the nodal coordinate system. Results
        are obtainable for an element at a specified node. Further location
        specifications can be made for some elements via the SHELL, LAYERP26,
        and FORCE commands.

        Table: 134:: : ESOL - General Item and Component Labels

        For more information on the meaning of contact status and its possible
        values, see Reviewing Results in POST1 in the Contact Technology Guide.
        """
        command = "ESOL,%s,%s,%s,%s,%s,%s" % (str(nvar), str(elem), str(node), str(item), str(comp), str(name))
        return self.run(command, **kwargs)

    def edcnstr(self, option="", ctype="", comp1="", comp2="", val1="",
                **kwargs):
        """APDL Command: EDCNSTR

        Defines various types of constraints for an explicit dynamic analysis.

        Parameters
        ----------
        option
            Label identifying the option to be performed.

            ADD - Define a constraint (default).

            DELE - Delete the constraint specified by Ctype, Comp1, and Comp2. If Ctype = ALL, all
                   constraints are deleted.

            LIST - List all of the constraints previously defined by the EDCNSTR command.

        ctype
            Constraint type. The command format will vary, depending on the
            Ctype value.

            ENS - Extra node set added to an existing rigid body.

            NRB - Nodal rigid body.

            STS - Tie between a shell edge and solid elements.

            RIVET - Massless rivet between two noncoincident nodes.

        Notes
        -----
        The EDCNSTR command allows you to define several types of constraints
        in an explicit dynamic analysis. A brief description of each constraint
        type is given below. See Constraints and Initial Conditions in the
        ANSYS LS-DYNA User's Guide for more information.

        Extra Node Set Added to a Rigid Body (Ctype = ENS)

        The ability to add extra nodes to an existing rigid body has many
        potential applications, including placing nodes where joints will be
        attached between rigid bodies, defining nodes where point loads will be
        applied, and defining a lumped mass at a specific location. The extra
        nodes specified by Comp2 may be located anywhere in the model and may
        have coordinates outside those of the original rigid body specified by
        Comp1.

        Nodal Rigid Body (Ctype = NRB)

        Unlike typical rigid bodies that are defined with the EDMP command,
        nodal rigid bodies defined with the EDCNSTR command are not associated
        with a part number. This can be advantageous for modeling rigid
        (welded) joints in a model. For a rigid joint, portions of different
        flexible components (having different MAT IDs) act together as a rigid
        body. It is difficult to define this type of rigid body with a unique
        MAT ID (and corresponding part number). However, the rigid joint can be
        easily defined using a nodal rigid body.

        Shell Edge to Solid Tie (Ctype = STS)

        The STS option ties regions of solid elements to regions of shell
        elements. A single shell node may be tied to up to nine brick element
        nodes that define a “fiber” vector. Solid element nodes constrained in
        this way remain linear throughout the analysis but can move relative to
        each other in the fiber direction.

        Rivet between Two Nodes (Ctype = RIVET)

        The RIVET option defines a massless rigid constraint between two nodes,
        similar to spotwelds defined with the EDWELD command. Unlike a
        spotweld, however, rivets contain nodes that are noncoincident, and
        failure cannot be specified. When a rivet is defined, the distance
        between the nodes is kept constant throughout any motion that occurs
        during a simulation. Nodes connected by a rivet cannot be part of any
        other constraints specified in the model.

        The EDCNSTR command is also valid in SOLUTION.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDCNSTR,%s,%s,%s,%s,%s" % (str(option), str(ctype), str(comp1), str(comp2), str(val1))
        return self.run(command, **kwargs)

    def slist(self, sfirst="", sl_ast="", sinc="", details="", type="",
              **kwargs):
        """APDL Command: SLIST

        Summarizes the section properties for all defined sections in the
        current session.

        Parameters
        ----------
        sfirst
            First section ID to be summarized. Defaults to first available
            section in the database.

        slast
            Last section ID to be summarized. Defaults to last available
            section in the database.

        sinc
            Increment of the section ID; defaults to 1.

        details
            Determines the content of the summarized information for beams and
            shells.

            BRIEF - For beams, lists only the section integrated properties (such as Area, Iyy, and
                    Iyz). This option is the default.

            FULL - For beams, lists the section integrated properties, as well as the section
                   nodal coordinates, section cell connectivity information,
                   and section cell integration point coordinates. For shells,
                   the section stiffness (membrane, bending, membrane-bending
                   coupling and transverse shear) are printed.

            The shell section stiffness listed considers elastic behavior of materials at reference temperature only. The elements that use the section data may alter the transverse shear stiffness based on slenderness considerations (in addition to the shear correction factors shown).  - Section stiffness terms listed via the FULL option do not include section
                              offsets. The ANSYS program considers section
                              offsets during the solution phase of the
                              analysis.

            GROUP - If a section calls other sections, this option lists those sections too.

        type
            The section type. Valid arguments are ALL (the default) and the
            types available on the SECTYPE command.

        Notes
        -----
        By default, the command lists information concerning all sections;
        however, you can limit the output to only beam or pretension sections
        via the Type key. Also, by default when ocean loading is present, the
        command lists the beam section properties used by ocean loading.

        Following is example output from the SLIST,,,,BRIEF command for a
        rectangular beam section subtype (SECTYPE,,BEAM,RECT):
        """
        command = "SLIST,%s,%s,%s,%s,%s" % (str(sfirst), str(sl_ast), str(sinc), str(details), str(type))
        return self.run(command, **kwargs)

    def pdinqr(self, rpar="", name="", type="", val="", **kwargs):
        """APDL Command: PDINQR

        Evaluates statistical characteristics of a random input variable.

        Parameters
        ----------
        rpar
            Name of scalar ANSYS parameter into which the characteristic value
            is stored.

        name
            Parameter name. The parameter must have been previously defined as
            a random input variable using the PDVAR command.

        type
            Keyword for the type of information you need to retrieve.

            MEAN - Mean value of the random input variable specified in Name.

            STDV - Standard deviation of the random input variable

            PDF - Probability density function of the random input variable specified in Name at
                  a given value specified by VAL.

            CDF - Cumulative distribution function of the random input variable specified in Name
                  at a given value specified by VAL.

            INV - Inverse cumulative distribution function of the random input variable specified
                  in Name at a given probability specified by VAL.

        val
            Value needed for Type = PDF, CDF, or INV. For Type = PDF and Type =
            CDF, this is the value of the random input variable at which the
            probabilistic density or cumulative distribution function should be
            evaluated. For Type = INV, VAL indicates the probability at which
            you want the inverse cumulative distribution function evaluated.

        Notes
        -----
        Evaluates statistical characteristics of a random input variable. The
        result is stored in the ANSYS parameter Rpar.
        """
        command = "PDINQR,%s,%s,%s,%s" % (str(rpar), str(name), str(type), str(val))
        return self.run(command, **kwargs)

    def asol(self, lab="", opt="", **kwargs):
        """APDL Command: ASOL

        Specifies the output type of an acoustic scattering analysis.

        Parameters
        ----------
        lab
            Acoustic solver specification (no default):

            SCAT - Set acoustic solver to the scattered field formulation.

        opt
            Option identifying an acoustic solver status:

            OFF - Deactivate the specified acoustic solver (default).

            ON - Activate the specified acoustic solver.

        Notes
        -----
        Use the ASOL command to activate the specified acoustic solution
        process.

        The scattered option (Lab = SCAT) sets the acoustic solver to the
        scattered-pressure field formulation.

        Issue the AWAVE command to define the incident pressure pinc. If the
        AWAVE command is defined with Opt2 = INT, the acoustic solver is set to
        the scattered field formulation regardless of the ASOL command issued.
        """
        command = "ASOL,%s,%s" % (str(lab), str(opt))
        return self.run(command, **kwargs)

    def trlcy(self, lab="", tlevel="", n1="", n2="", ninc="", **kwargs):
        """APDL Command: /TRLCY

        Specifies the level of translucency.

        Parameters
        ----------
        lab
            Apply translucency level to the items specified by the following
            labels:

            ELEM - Elements.  Use N1, N2, NINC fields for element numbers.

            AREA - Solid model areas.  Use N1, N2, NINC fields for area numbers.

            VOLU - Solid model volumes.  Use N1, N2, NINC fields for volume numbers.

            ISURF - Isosurfaces (surfaces of constant stress, etc., value).  Translucency varies
                    with result value, to a maximum of the specified
                    translucency level.

            CM - Component group.  Use N1 for component name, ignore N2 and NINC.

            CURVE - Filled areas under curves of line graphs.  Use N1, N2, NINC fields for curve
                    numbers.

            ZCAP - If /TYPE,WN,ZCAP is the current display type, then /TRLCY,ZCAP,TLEVEL will
                   display the model in window WN with the portion of the model
                   in front of the section plane displayed at the translucency
                   level TLEVEL.

            ON, OFF - Sets the specified translucency display on or off. All other fields are
                      ignored.

        tlevel
            Translucency level:  0.0 (opaque) to 1.0 (transparent).

        n1, n2, ninc
            Used only with labels as noted above.  Apply translucency level to
            Lab items numbered N1 to N2 (defaults to N1) in steps of NINC
            (defaults to 1).  If N1 is blank or ALL, apply specified
            translucency level to entire selected range.  If Lab is CM, use
            component name for N1 and ignore N2 and NINC. A value of N1 = P
            allows you to graphically pick elements, areas, and volumes. You
            can then assign translucency levels to the entities via the picker.
            The Lab and TLEVEL fields are ignored when translucency is applied
            by picking.

        Notes
        -----
        Specifies the level of translucency for various items.  Issue
        /TRLCY,DEFA to reset the default (0) translucency levels.  This command
        is valid only on selected 2-D and 3-D graphics devices; see  in the
        Basic Analysis Guide for more information on applying translucency.

        For 2-D devices, ANSYS displays only the visible faces of the items
        being displayed.  The information behind the facing planes is not
        displayed.  Issuing the /SHRINK command will force the hardware to
        display information behind the translucent items.

        This command is valid in any processor.
        """
        command = "/TRLCY,%s,%s,%s,%s,%s" % (str(lab), str(tlevel), str(n1), str(n2), str(ninc))
        return self.run(command, **kwargs)

    def pdexe(self, slab="", mrun="", nfail="", fopt="", fname="", **kwargs):
        """APDL Command: PDEXE

        Executes the probabilistic analysis.

        Parameters
        ----------
        slab
            Solution label. This is the name given to the files containing the
            results of different probabilistic analyses performed with a
            particular probabilistic model. Different solutions using different
            probabilistic methods or method options are stored in separate
            solution sets identified with this solution label. If the solution
            label is blank, ANSYS automatically assigns Slab = "SOLUnn", where
            nn is the current two-digit number of the probabilistic analysis
            (PDS allows a maximum of 10 solution sets identified by 10 solution
            labels); for example, the first analysis is SOLU01, the second is
            SOLU02, and so on up to SOLU10). This field cannot contain blanks.
            Maximum length of this field is 32 characters; if the field
            contains more than 32 characters, it will be truncated to 32
            characters.

        mrun
            Keyword for the processing of the simulation loops

            SER - Executes the simulation loops of the probabilistic analysis using a single
                  machine; serial processing (default).

            PAR - Executes the simulation loops of the probabilistic analysis in parallel using
                  the ANSYS parallel-processing tool. See Probabilistic Design
                  in the Advanced Analysis Guide.

        nfail
            This parameter sets the number of loops that are allowed to fail
            before the execution of the probabilistic analysis is terminated.
            For example, if geometric parameters are used as random variables
            then for some simulations (loops) the loop will fail because
            meshing was not successful. This might happen infrequently which
            might be acceptable. However, if the probabilistic problem is
            incorrectly defined then loops could fail frequently or even in
            every loop. You can define an upper limit for the number of failed
            loops that will be tolerated before the probabilistic analysis will
            be terminated. If you use NFAIL = 0 (default) then failed loops are
            not tolerated and the probabilistic analysis will terminate the
            first time a loop fails. NFAIL is used only if MRUN = PAR.

        fopt
            Keyword for the file option. This determines if a copy of the
            sample file should be saved or not.

            DEL - The sample file will be deleted (default).

            COPY - A copy of the sample file will be saved as the file name specified with the
                   Fname option.

        fname
            Name of the copy of the sample file. The directory for storing the
            sample file is always the current working directory. The file
            extension is always .csmp. This option is ignored for FOPT = DEL.

        Notes
        -----
        Runs the probabilistic analysis. The results of the probabilistic
        analysis are identified with the solution label specified here. This
        solution label is used for the postprocessing of the results. The
        maximum number of probabilistic analyses that can be executed, stored,
        and post-processed based on the same deterministic and probabilistic
        model in one session with the PDS is 10. However, it is not counted as
        a separate probabilistic analysis if the same solution label is used
        multiple times in order to append to or overwrite previous results.

        The probabilistic results are stored in result files in ASCII format.

        If you specify a solution label that has already been used, the results
        will be appended at the end of the results file.

        After the PDEXE command has been issued, you can no longer change the
        probabilistic model using probabilistic preprocessing commands; doing
        so would invalidate the probabilistic analysis results and potentially
        corrupt the probabilistic database. Also, you are not allowed to change
        the probabilistic analysis file using a PDANL command after the first
        PDEXE has been executed.

        If you need to change the probabilistic model (analysis file, random
        input variables, etc.) after the PDEXE command has been issued, you
        should use the PDCLR, POST command to clear the probabilistic results.
        We recommend that you first save the results using the PDSAVE command.

        By default, ANSYS creates a sample file (called Jobname.samp)
        containing all values of all random input parameters; unless you
        specify otherwise, this file is deleted after the analysis is finished.
        With the FOPT and Fname options you can determine if and where a copy
        of that file should be stored for later use in another analysis.
        """
        command = "PDEXE,%s,%s,%s,%s,%s" % (str(slab), str(mrun), str(nfail), str(fopt), str(fname))
        return self.run(command, **kwargs)

    def mshpattern(self, key="", **kwargs):
        """APDL Command: MSHPATTERN

        Specifies pattern to be used for mapped triangle meshing.

        Parameters
        ----------
        key
            Key indicating triangle pattern to be used (the figures below
            illustrate the pattern that will be used for each value of KEY):

            0 - Let ANSYS choose the pattern (the default).  ANSYS maximizes the minimum angle
                of the triangular-shaped elements that are created.

            1 - Unidirectional split at node I.

            2 - Unidirectional split at node J.

        Notes
        -----
        "Mapped triangle meshing" refers to the ANSYS program's ability to take
        a map-meshable area and mesh it with triangular elements, based on the
        value of MSHPATTERN,KEY. This type of meshing is particularly useful
        for analyses that involve the meshing of rigid contact elements.

        The MSHPATTERN command is valid only when you have specified that ANSYS
        use triangle-shaped elements [MSHAPE,1,2D] (or you are meshing with an
        element that supports only triangles), and you have also specified
        mapped meshing [MSHKEY,1] to mesh an area.

        For details about mapped meshing with triangles, see the Modeling and
        Meshing Guide.
        """
        command = "MSHPATTERN,%s" % (str(key))
        return self.run(command, **kwargs)

    def dmove(self, node1="", node2="", ninc="", **kwargs):
        """APDL Command: DMOVE

        Digitizes nodes on surfaces and along intersections.

        Parameters
        ----------
        node1, node2, ninc
            Digitize nodes NODE1through NODE2 in steps of NINC.  NODE2 defaults
            to NODE1 and NINC defaults to 1.

        Notes
        -----
        Digitizes nodes on undefined surfaces, warped surfaces, and along
        intersection lines.  Two orthogonal views showing the nodes on a plane
        in each view are required.  No surfaces need be specified.  Two
        coordinates are determined from the second view and the other
        coordinate is retained from the first view.  Use the DIG command to
        first define nodes in one view (as determined from the DSET command).
        Then reset the view and use this command to move the nodes to the
        proper location.
        """
        command = "DMOVE,%s,%s,%s" % (str(node1), str(node2), str(ninc))
        return self.run(command, **kwargs)

    def ldele(self, nl1="", nl2="", ninc="", kswp="", **kwargs):
        """APDL Command: LDELE

        Deletes unmeshed lines.

        Parameters
        ----------
        nl1, nl2, ninc
            Delete lines from NL1 to NL2 (defaults to NL1) in steps of NINC
            (defaults to 1).  If NL1 = ALL, NL2 and NINC are ignored and all
            selected lines [LSEL] are deleted.  If NL1 = P, graphical picking
            is enabled and all remaining command fields are ignored (valid only
            in the GUI).  A component name may also be substituted for NL1 (NL2
            and NINC are ignored).

        kswp
            Specifies whether keypoints are also to be deleted:

            0 - Delete lines only.

            1 - Delete lines, as well as keypoints attached to lines but not attached to other
                lines.

        Notes
        -----
        A line attached to an area cannot be deleted unless the area is first
        deleted.
        """
        command = "LDELE,%s,%s,%s,%s" % (str(nl1), str(nl2), str(ninc), str(kswp))
        return self.run(command, **kwargs)

    def waves(self, wopt="", oldmax="", oldrms="", **kwargs):
        """APDL Command: WAVES

        Initiates reordering.

        Parameters
        ----------
        wopt
            Option for comparison:

            MAX - Use maximum wavefront value for comparison (default).

            RMS - Use RMS wavefront value for comparison.

        oldmax, oldrms
            Maximum and RMS wavefront values of model to be used in place of
            the old values.  OLDRMS defaults to OLDMAX  (and vice versa).  If
            neither is specified, each defaults to its calculated old value.

        Notes
        -----
        Initiates the element reordering based upon the previously defined
        starting wave lists (if any).  Reordering affects only the element
        order for the solution phase and not the element numbers (input
        referring to element numbers, such as element pressures, is unaffected
        by reordering).

        Note:: : The new order is retained only if new the new maximum or RMS
        wavefront values are lower than the old values, as described below.
        See the WSORT command for another reordering procedure.  The resulting
        element ordering can be shown by listing the wavefront history
        [WFRONT,1] or by displaying elements with their element location
        numbers [/PNUM].

        The WAVES reordering procedure is based upon a list of nodes defining
        where the element reordering is to start (either input on the WSTART
        command, or automatically determined if not input).  If a list is
        input, additional starting wave lists may be defined to allow the user
        to block or guide the wave.  An input starting list usually consists of
        one node for a line element model, a line of nodes for an area element
        model, or a plane of nodes for a volume element model.  Elements are
        ordered from the first starting wave list in a direction that attempts
        to minimize the wavefront.  Nodes are deleted and added to the total
        wave list set as reordering progresses through the model.  Elements
        attached to nodes on succeeding starting lists, if any, are ignored at
        this time, thereby temporarily blocking that path.  Whenever no more
        elements can be reordered, the procedure is repeated starting from the
        nodes defined on the second starting list (if any).  The same node
        number should not appear on more than one list.  If no starting list is
        input, a starting node is automatically selected from an element
        weighting procedure (see Element Reordering in the Mechanical APDL
        Theory Reference).

        Reordering may be made from the previously reordered model or from the
        initial model (by issuing the SAVE command before reordering and then
        restoring that model back to PREP7 with the RESUME command after
        reordering).  The WFRONT command is useful for calculating and printing
        the current wavefront statistics at any time without causing any
        reordering of the elements.  If a model is to be used for both a
        thermal and a structural analysis, the reordered statistics should be
        based upon the structural model (because of the higher number of
        degrees of freedom per node).

        The reordering procedure treats separate portions of the model (i.e.,
        not connected by elements) as discontinuous.  Reordering automatically
        continues across a discontinuity as best as possible.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "WAVES,%s,%s,%s" % (str(wopt), str(oldmax), str(oldrms))
        return self.run(command, **kwargs)

    def vup(self, wn="", label="", **kwargs):
        """APDL Command: /VUP

        Specifies the global Cartesian coordinate system reference orientation.

        Parameters
        ----------
        wn
            Window number (or ALL) to which command applies (defaults to 1).

        label
            Orientation:

            Y  - Y vertical upward, X horizontal to the right, Z out from the screen (default).

            -Y  - Y vertical downward, X horizontal to the left, Z out from the screen.

            X  - X vertical upward, Y horizontal to the left, Z out from the screen.

            -X  - X vertical downward, Y horizontal to the right, Z out from the screen.

            Z  - Z vertical upward, Y horizontal to the right, X out from the screen.  With this
                 choice, you should use a view other than the /VIEW default of
                 (0,0,1).

            -Z  - Z vertical downward, Y horizontal to the left, X out from the screen.  With
                  this choice, you should use a view other than the /VIEW
                  default of (0,0,1).

        Notes
        -----
        Specifies the global Cartesian coordinate system reference orientation.
        The /VIEW and /ANGLE commands may be used to reorient the view and are
        relative to this reference orientation.  All coordinate systems are
        right-handed.

        This command is valid in any processor.
        """
        command = "/VUP,%s,%s" % (str(wn), str(label))
        return self.run(command, **kwargs)

    def anmres(self, delay="", min="", max="", inc="", autocntrky="", freq="",
               ext="", **kwargs):
        """APDL Command: ANMRES

        Performs animation of results over multiple results files in an
        explicit dynamic structural analysis or fluid flow analysis with
        remeshing.

        Parameters
        ----------
        delay
            Time delay during animation (default = 0.5 seconds).

        min
            Minimum results file number to animate. Default = 1 (for
            Jobname.RS01).

        max
            Maximum results file number to animate. Defaults to the highest
            numbered results file, Jobname.RSnn.

        inc
            Increment between results file numbers. Default = 1.

        autocntrky
            Automatic contour scaling option.

            0 - No auto-scaling (default).

            1 - Auto-scaling on.

        freq
             Results frequency key.

            0 or 1 - Animate every results set in each Jobname.EXT file (default).

            2 - Animate every other results set in each Jobname.EXT file.

            n - Animate every nth results set in each Jobname.EXT file.

        ext
            Extension of result files

            'rfl' - Animate Jobname.rflnn

            'rs' - Animate Jobname.rsnn. Default = 'rs'.

        Notes
        -----
        ANMRES invokes an ANSYS macro that performs animation across multiple
        results files (Jobname.EXT, Jobname.EXT, etc.) produced by an explicit
        dynamic structural analysis or fluid flow analysis with remeshing.
        Multiple results files typically occur when adaptive meshing is used in
        an explicit dynamic structural analysis or fluid flow analysis with
        remeshing. Each results file must have more than one set of results.
        ANMRES cannot be used for multiple results files that are caused by
        file splitting.

        ANMRES animates results from files having the currently specified
        jobname (Jobname.EXT - Jobname.EXT).  To change the current jobname,
        use  the /FILNAME command. The animation is based on the last plot
        command (e.g., PLDISP).

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "ANMRES,%s,%s,%s,%s,%s,%s,%s" % (str(delay), str(min), str(max), str(inc), str(autocntrky), str(freq), str(ext))
        return self.run(command, **kwargs)

    def dmpoption(self, filetype="", combine="", **kwargs):
        """APDL Command: DMPOPTION

        Specifies distributed memory parallel (Distributed ANSYS) file
        combination options.

        Parameters
        ----------
        filetype
            Type of solution file to combine after a distributed memory
            parallel solution. There is no default; if (blank), the command is
            ignored.

            RST - Results files (.RST, .RTH, .RMG, .RSTP)

            EMAT - Element matrix files (.EMAT).

            ESAV - Element saved data files (.ESAVE)

            MODE - Modal results files (.MODE)

            MLV - Modal load vector file (.MLV)

            IST - Initial state file (.IST)

            FULL - Full matrix file (.FULL)

            RFRQ - Reduced complex displacement file (.RFRQ)

            RDSP - Reduced displacement file (.RDSP)

        combine
            Option to combine solution files.

            Yes - Combine solution files (default).

            No - Do not combine solution files.

        Notes
        -----
        The DMPOPTION command controls how solution files are written during a
        distributed memory parallel (Distributed ANSYS) solution. This command
        is most useful for controlling how results files (.RST,.RTH, etc.) are
        written.

        In a distributed memory parallel solution, a local results file is
        written by each process (JobnameN.ext, where N is the process number).
        By default, the program automatically combines the local results files
        (for example, JobnameN.RST) upon leaving the SOLUTION processor (for
        example, upon the FINISH command) into a single global results file
        (Jobname.RST) which can be used in ANSYS postprocessing. To reduce the
        amount of communication and I/O performed by this operation, you can
        issue the command DMPOPTION,RST,NO to bypass this step of combining the
        local results files; the local files will remain on the local disks in
        the current working directory. You can then use the RESCOMBINE command
        macro in the POST1 general postprocessor (/POST1) to read all results
        into the database for postprocessing.

        The RESCOMBINE command macro is intended for use with POST1. If you
        want to postprocess distributed parallel solution results using the
        POST26 time-history postprocessor (/POST26), it is recommended that you
        combine your local results files into one global results file
        (DMPOPTION,RST,YES or COMBINE).

        Local .EMAT, .ESAV, .MODE, .MLV, .IST, .RFRQ, .RDSP, and .FULL files
        are also written (when applicable) by each process in a distributed
        memory parallel solution. If these files are not needed for a
        downstream solution or operation, you can issue the command
        DMPOPTION,FileType,NO for each file type to bypass the file combination
        step and thereby improve performance. You should not bypass the file
        combination step if a downstream PSD analysis or modal expansion pass
        will be performed.

        If DMPOPTION,MODE,NO or DMPOPTION,RST,NO is specified in a modal
        analysis, element results cannot be written to the combined mode file
        (Jobname.MODE). In this case, if Distributed ANSYS is used in a
        downstream harmonic or transient analysis that uses the mode-
        superposition method, the MSUPkey on the MXPAND command can retain its
        value. However, if shared memory parallel processing is used in the
        downstream harmonic or transient analysis, the MSUPkey is effectively
        set to NO.

        The DMPOPTION command can be changed between load steps; however, doing
        so will not affect which set of solution files are combined. Only the
        last values of FileType and Combine upon leaving the solution processor
        will be used to determine whether the solution files are combined. For
        example, given a two load step solution and FileType = RST, setting
        Combine = NO for the first load step and YES for the second load step
        will cause all sets on the local results files to be combined. If the
        opposite is true (Combine = YES for the first load step and NO for the
        second load step), no results will be combined.

        After using DMPOPTION to suppress file combination, you may find it
        necessary to combine the local files for a specific FileType for use in
        a subsequent analysis. In this case, use the COMBINE command to combine
        local solution files into a single, global file.
        """
        command = "DMPOPTION,%s,%s" % (str(filetype), str(combine))
        return self.run(command, **kwargs)

    def eshape(self, scale="", key="", **kwargs):
        """APDL Command: /ESHAPE

        Displays elements with shapes determined from the real constants or
        section definition.

        Parameters
        ----------
        scale
            Scaling factor:

            0 - Use simple display of line and area elements. This value is the default.

            1 - Use real constants or section definition to form a solid shape display of the
                applicable elements.

            FAC - Multiply certain real constants, such as thickness, by FAC (where FAC > 0.01)
                  and use them to form a solid shape display of elements.

        key
            Current shell thickness key:

            0 - Use current thickness in the displaced solid shape display of shell elements
                (valid for SHELL181, SHELL208, SHELL209, and SHELL281). This
                value is the default.

            1 - Use initial thickness in the displaced solid shape display of shell elements.

        Notes
        -----
        The /ESHAPE command allows beams, shells, current sources, and certain
        special-purpose elements to be displayed as solids with the shape
        determined from the real constants or section types. Elements are
        displayed via the EPLOT command. No checks for valid or complete input
        are made for the display.

        Following are details about using this command with various element
        types:

        SOLID65 elements are displayed with internal lines that represent rebar
        sizes and orientations (requires vector mode [/DEVICE] with a basic
        type of display [/TYPE,,BASIC]). The rebar with the largest volume
        ratio in each element plots as a red line, the next largest as green,
        and the smallest as blue.

        COMBIN14, COMBIN39, and MASS21 are displayed with a graphics icon, with
        the offset determined by the real constants and KEYOPT settings.

        BEAM188, BEAM189, PIPE288, PIPE289 and ELBOW290 are displayed as solids
        with the shape determined via the section-definition commands (SECTYPE
        and SECDATA). The arbitrary section option (Subtype = ASEC) has no
        definite shape and appears as a thin rectangle to show orientation. The
        elements are displayed with internal lines representing the cross-
        section mesh.

        SOLID272 and SOLID273 are displayed as solids with the shape determined
        via the section-definition commands (SECTYPE and SECDATA).  The 2-D
        master plane is revolved around the prescribed axis of symmetry.

        Contour plots are available for these elements in postprocessing for
        PowerGraphics only (/GRAPHICS,POWER). To view 3-D deformed shapes for
        the elements, issue OUTRES,MISC or OUTRES,ALL for static or transient
        analyses. To view 3-D mode shapes for a modal or eigenvalue buckling
        analysis, expand the modes with element results calculation ON (Elcalc
        = YES for MXPAND).

        SOURC36, CIRCU124, and TRANS126 elements always plot using /ESHAPE when
        PowerGraphics is activated (/GRAPHICS,POWER).

        In most cases, /ESHAPE renders a thickness representation of your
        shell, plane and layered elements more readily in PowerGraphics
        (/GRAPHICS,POWER). This type of representation employs PowerGraphics to
        generate the enhanced representation, and will often provide no
        enhancement in Full Graphics (/GRAPHICS,FULL). This is especially true
        for POST1 results displays, where /ESHAPE is not supported for most
        element types with FULL graphics.

        When PowerGraphics is active, /ESHAPE may degrade the image if adjacent
        elements have overlapping material, such as shell elements which are
        not co-planar. Additionally, if adjacent elements have different
        thicknesses, the polygons depicting the connectivity between the
        “thicker” and “thinner” elements along the shared element edges may not
        always be displayed.

        For POST1 results displays (such as PLNSOL), the following limitations
        apply:

        Rotational displacements for beam elements are used to create a more
        realistic displacement display. When /ESHAPE is active, displacement
        plots (via PLNSOL,U,X and PLDISP, for example) may disagree with your
        PRNSOL listings. This discrepancy will become more noticeable when the
        SCALE value is not equal to one.

        When shell elements are not co-planar, the resulting PLNSOL display
        with /ESHAPE will actually be a PLESOL display as the non-coincident
        pseudo-nodes are not averaged. Additionally, /ESHAPE should not be used
        with coincident elements because the plot may incorrectly average the
        displacements of the coincident elements.

        When nodes are initially coincident and PowerGraphics is active,
        duplicate polygons are eliminated to conserve display time and disk
        space. The command may degrade the image if initially coincident nodes
        have different displacements. The tolerance for determining coincidence
        is 1E-9 times the model’s bounding box diagonal.

        If you want to view solution results (PLNSOL, etc.) on layered elements
        (such as SHELL181, SOLSH190, SOLID185 Layered Solid, SOLID186 Layered
        Solid, SHELL208, SHELL209, SHELL281, and ELBOW290), set KEYOPT(8) = 1
        for the layer elements so that the data for all layers is stored in the
        results file.

        You can plot the through-thickness temperatures of elements SHELL131
        and SHELL132 regardless of the thermal DOFs in use by issuing the
        PLNSOL,TEMP command (with PowerGraphics and /ESHAPE active).

        The /ESHAPE,1 and /ESHAPE,FAC commands are incompatible with the
        /CYCEXPAND command used in cyclic symmetry analyses.

        This command is valid in any processor.
        """
        command = "/ESHAPE,%s,%s" % (str(scale), str(key))
        return self.run(command, **kwargs)

    def golist(self, **kwargs):
        """APDL Command: /GOLIST

        Reactivates the suppressed data input listing.

        Notes
        -----
        Reactivates printout of the data input listing suppressed with /NOLIST.

        This command is valid in any processor, but only within a batch run
        [/BATCH].
        """
        command = "/GOLIST," % ()
        return self.run(command, **kwargs)

    def pasave(self, lab="", fname="", ext="", **kwargs):
        """APDL Command: PASAVE

        Saves selected paths to an external file.

        Parameters
        ----------
        lab
            Write operation:

            S - Saves only selected paths.

            ALL - Saves all paths (default).

            Pname - Saves the named path (from the PSEL command).

        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        Notes
        -----
        Saves the paths selected with the PSEL command to an external file
        (Jobname.path by default).  Previous paths on this file, if any, will
        be overwritten.  The path file may be read with the PARESU command.

        This command is valid in POST1.
        """
        command = "PASAVE,%s,%s,%s" % (str(lab), str(fname), str(ext))
        return self.run(command, **kwargs)

    def mpcopy(self, matf="", matt="", **kwargs):
        """APDL Command: MPCOPY

        Copies linear material model data from one material reference number to
        another.

        Parameters
        ----------
        --
            Unused field

        matf
            Material reference number from where material property data will be
            copied.

        matt
            Material reference number to where material property data will be
            copied.

        Notes
        -----
        The MPCOPY command copies linear material properties only, which are
        all properties defined through the MP command. If you copy a model that
        includes both linear and yield behavior constants (for example, a BKIN
        model), the MPCOPY and TBCOPY, ALL commands are used together to copy
        the entire model.  All input data associated with the model is copied,
        that is, all data defined through the MP and TB commands.

        Also, if you copy a material model using the Material Model Interface
        (Edit> Copy), both the commands MPCOPY and TBCOPY, ALL are issued,
        regardless of whether the model includes linear constants only, or if
        it includes a combination of linear and yield behavior constants.

        This command is also valid in SOLUTION.
        """
        command = "MPCOPY,%s,%s" % (str(matf), str(matt))
        return self.run(command, **kwargs)

    def etype(self, **kwargs):
        """APDL Command: ETYPE

        Specifies "Element types" as the subsequent status topic.

        Notes
        -----
        This is a status [STAT] topic command. Status topic commands are
        generated by the GUI and will appear in the log file (Jobname.LOG) if
        status is requested for some items under Utility Menu> List> Status.
        This command will be immediately followed by a STAT command, which will
        report the status for the specified topic.

        If entered directly into the program, the STAT command should
        immediately follow this command.
        """
        command = "ETYPE," % ()
        return self.run(command, **kwargs)

    def tbfield(self, type="", value="", **kwargs):
        """APDL Command: TBFIELD

        Defines values of field variables for material data tables.

        Parameters
        ----------
        type
            Type of field variable:

            FREQ - A frequency is to be specified in Value

            TEMP - A temperature is to be specified in Value

            TIME - A time is to be specified in Value

            NPRES - A normal pressure is to be specified in Value

            SLDA - A total sliding distance (algebraic) is to be specified in Value

            SLDI - A total sliding distance (absolute) is to be specified in Value

            SLRV - A sliding velocity is to be specified in Value

            CYCLE - A healing cycle number is to be specified in Value

            UFXX - User-defined field variable (UF01,UF02, ..., UF09)

        value
            The field value to be referenced (use this command multiple times
            to enter values of different field variables).

        Notes
        -----
        Define your data tables as field-variable-dependent (via the
        appropriate TB command shown below), then issue the TBFIELD command to
        define the field values.

        Define data values in ascending order for all field quantities. If a
        field value is to be held constant, define it only once; subsequent
        definitions are ignored.

        There is no limit on the number of values you can specify. The
        specified field value remains active until the next TBFIELD command is
        input.

        After you have defined the field value(s), define your data for the
        data tables (TBDATA).

        See Understanding Field Variables in the Material Reference for more
        information about the interpolation scheme used for field-dependent
        material properties.

        See Full Harmonic Analysis in the Structural Analysis Guide for more
        information about using TBFIELD with TB,ELASTIC or TB,SDAMP.

        The TBFIELD command supports the following material models (TB,Lab
        commands):

        The TEMP value specified on this command corresponds to the average
        temperature on the contact surface for contact elements CONTA171,
        CONTA172, CONTA173, CONTA174, CONTA175, CONTA176, and CONTA177. For
        contact element CONTA178, the TEMP value corresponds to the average
        temperature of the nodes.

        The TIME value specified on this command corresponds to the analysis
        time specified on the TIME command.

        The algebraic sliding distance (SLDA) specified on this command is the
        total sliding distance (the algebraic sum) as reported in the element
        output definitions table for the contact elements (for example, TASS
        and TASR output items for CONTA174).

        The absolute sliding distance (SLDI) specified on this command is the
        total accumulated sliding distance (the absolute sum) as reported in
        the element output definitions table for the contact elements (for
        example, AASS and AASR output items for CONTA174).

        When used with TB,FRIC, field variables defined by TBFIELD are only
        available for isotropic friction (TBOPT = ISO) and orthotropic friction
        (TBOPT = ORTHO); they are not available for user-defined friction
        (TBOPT = USER).

        See Contact Friction in the Material Reference for more information
        about using TBFIELD with TB,FRIC.
        """
        command = "TBFIELD,%s,%s" % (str(type), str(value))
        return self.run(command, **kwargs)

    def mftol(self, key="", value="", toler="", **kwargs):
        """APDL Command: MFTOL

        Activates or deactivates normal distance checking for surface mapping
        in an ANSYS Multi-field solver analysis.

        Parameters
        ----------
        key
            Normal distance key

            ON - Activates normal distance checking.

            OFF - Deactivates normal distance checking (default).

        value
            The normal distance tolerance for surface mapping.  Defaults to
            1.0e-6. If Toler = REL, Value is dimensionless. If Toler = ABS,
            Value has the dimensions of length.

        toler
            Tolerance definition key

            REL - Activates relative gap tolerance, which is independent of units (default).

            ABS - Activates absolute gap tolerance.

        Notes
        -----
        For a dissimilar mesh interface, the nodes of one mesh are mapped to
        the local coordinates of an element in the other mesh. When normal
        distance checking is activated, the mapping tool checks the normal
        distance from the node to the nearest element. The node is considered
        improperly mapped if the normal distance exceeds the tolerance value.
        The mapping tool creates a component to graphically display the
        improperly mapped nodes. See Mapping Diagnostics in the Coupled-Field
        Analysis Guide for more information.

        When using relative gap tolerance (Toler = REL), the normal distance
        tolerance is derived from the product of the relative tolerance Value
        and the largest dimension of the Cartesian bounding box for a specific
        interface. Therefore, each interface will have a different normal
        distance tolerance , even though MFTOL is a global command.

        This command is also valid in PREP7.

        See Multi-field Commands in the Coupled-Field Analysis Guide for a list
        of all ANSYS Multi-field solver commands and their availability for MFS
        and MFX analyses.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "MFTOL,%s,%s,%s" % (str(key), str(value), str(toler))
        return self.run(command, **kwargs)

    def light(self, wn="", num="", int="", xv="", yv="", zv="", refl="",
              **kwargs):
        """APDL Command: /LIGHT

        Specifies the light direction for the display window.

        Parameters
        ----------
        wn
            Window number (or ALL) to which command applies (defaults to 1).

        num
            Ambient or directional light key:

            0 - Ambient light (default).

            1 - Directional light.

        int
            Light intensity factor (defaults to 0.3 for ambient, 1.0 for
            directional). This option is valid only for 3-D devices).

        xv, yv, zv
            Light direction (valid only for NUM = 1).  The directional light
            source is parallel to the line from point XV, YV, ZV to the origin,
            in the global Cartesian system origin.  Defaults to the viewing
            direction [/VIEW].

        refl
            Light reflectance factor (valid only for NUM = 1 and 3-D devices).

        Notes
        -----
        Defines the light direction for the window.  Use this command only with
        3-D graphics devices or 2-D devices when Z-buffering is used [/TYPE,,(6
        or 7)].  The ambient light has no direction, only an intensity.  You
        can position the directional light source  by defining a point (in the
        global Cartesian coordinate system) representing a point along the
        light directional line.  This point, and the global Cartesian
        coordinate system origin, define the line along which the light is
        positioned looking toward the origin.  You can use any point along the
        light line; for example, both (1.,1.,1.) and (2.,2.,2.) give the same
        light effect.  For 3-D graphics devices only, the directional light
        source also has intensity and reflectance factors.

        By choosing the highest intensity ambient light for 3-D graphics
        devices (via the command /LIGHT,WN,0,1), you can nullify color shading
        and other effects of directional lighting.

        This command is valid in any processor.
        """
        command = "/LIGHT,%s,%s,%s,%s,%s,%s,%s" % (str(wn), str(num), str(int), str(xv), str(yv), str(zv), str(refl))
        return self.run(command, **kwargs)

    def gssol(self, nvar="", item="", comp="", name="", **kwargs):
        """APDL Command: GSSOL

        Specifies which results to store from the results file when using
        generalized plane strain.

        Parameters
        ----------
        nvar
            Arbitrary reference number or name assigned to this variable.
            Variable numbers can be 2 to NV (NUMVAR) while the name can be an
            eight byte character string. Overwrites any existing results for
            this variable.

        item
            Label identifying item to be stored.

            LENGTH - Change of fiber length at the ending point.

            ROT - Rotation of the ending plane during deformation.

            F - Reaction force at the ending point in the fiber direction.

            M - Reaction moment applied on the ending plane.

        comp
            Component of the item, if Item = ROT or M.

            X - The rotation angle or reaction moment of the ending plane about X.

            Y - The rotation angle or reaction moment of the ending plane about Y.

        name
            Thirty-two character name identifying the item on the printout and
            display. Defaults to the label formed by concatenating the first
            four characters of the Item and Comp labels.

        Notes
        -----
        This command stores the results (new position of the ending plane after
        deformation) for generalized plane strain. All outputs are in the
        global Cartesian coordinate system. For more information about the
        generalized plane strain feature, see Generalized Plane Strain Option
        of Current-Technology Solid Elements in the Element Reference.
        """
        command = "GSSOL,%s,%s,%s,%s" % (str(nvar), str(item), str(comp), str(name))
        return self.run(command, **kwargs)

    def inquire(self, strarray="", func="", **kwargs):
        """APDL Command: /INQUIRE

        Returns system information to a parameter.

        Parameters
        ----------
        strarray
            Name of the "string array" parameter that will hold the returned
            values.  String array parameters are similar to character arrays,
            but each array element can be as long as 128 characters. If the
            string parameter does not exist, it will be created.

        Notes
        -----
        The /INQUIRE command is valid in any processor.
        """
        command = "/INQUIRE,%s,%s" % (str(strarray), str(func))
        return self.run(command, **kwargs)

    def focus(self, wn="", xf="", yf="", zf="", ktrans="", **kwargs):
        """APDL Command: /FOCUS

        Specifies the focus point (center of the window).

        Parameters
        ----------
        wn
            Window number (or ALL) to which command applies (defaults to 1).

        xf, yf, zf
            Location of the object to be at the focus point (center of the
            window) in the global Cartesian coordinate system.  If XF = AUTO,
            allow automatic location calculation.  If XF = USER, use focus
            location of last display (useful when last display had auto focus).

        ktrans
            Translate key:

            0 - Interpret numerical XF, YF, ZF values as described above.

            1 - Interpret XF, YF, ZF values as multiples of half-screens to translate from the
                current position in the screen coordinate system.  Example: XF
                of 2.4 translates the display approximately 2.4 half-screens to
                the left in the screen X (horizontal) direction.

            2 - Interpret XF, YF, ZF values as multiples of half-screens to translate from the
                current position in the global Cartesian coordinate system.
                Example: XF of 1.5 translates the display approximately 1.5
                half-screens in the global Cartesian X direction of the model.

        Notes
        -----
        Specifies the location on (or off) the model which is to be located at
        the focus point (center of the window).  For section and capped
        displays, the cutting plane is also assumed to pass through this
        location (unless the working plane is used via /CPLANE).  See also
        /AUTO and /USER commands.

        This command is valid in any processor.
        """
        command = "/FOCUS,%s,%s,%s,%s,%s" % (str(wn), str(xf), str(yf), str(zf), str(ktrans))
        return self.run(command, **kwargs)

    def cecheck(self, itemlab="", tolerance="", dof="", **kwargs):
        """APDL Command: CECHECK

        Check constraint equations and couplings for rigid body motions.

        Parameters
        ----------
        itemlab
            Item indicating what is to be checked:

            CE - Check constraint equations only

            CP - Check couplings only

            ALL - Check both CE and CP

        tolerance
            Allowed amount of out-of-balance for any constraint equation or
            coupled set. The default value of 1.0e-6 is usually good.

        dof
            Specifies which DOF is to be checked. Default is RIGID, the usual
            option. Other choices are individual DOF such as UX, ROTZ, etc. or
            THERM. The THERM option will check the constraint equations or
            coupled sets for free thermal expansions, whereas the individual
            DOFs check under rigid body motions. ALL is RIGID and THERM.

        Notes
        -----
        This command imposes a rigid body motion on the nodes attached to the
        constraint equation or coupled set and makes sure that no internal
        forces are generated for such rigid body motions. Generation of
        internal forces by rigid body motions usually indicates an error in the
        equation specification (possibly due to nodal coordinate rotations).
        The THERM option does a similar check to see that no internal forces
        are created by the equations if the body does a free thermal expansion
        (this check assumes a single isotropic coefficient of expansion).
        """
        command = "CECHECK,%s,%s,%s" % (str(itemlab), str(tolerance), str(dof))
        return self.run(command, **kwargs)

    def l2tan(self, nl1="", nl2="", **kwargs):
        """APDL Command: L2TAN

        Generates a line tangent to two lines.

        Parameters
        ----------
        nl1
            Number of the first line generated line is tangent to.  If
            negative, assume P1 (see below) is the second keypoint of the line
            instead of the first.  If NL1 = P, graphical picking is enabled and
            all remaining command fields are ignored (valid only in the GUI).

        nl2
            Number of the second line generated line is tangent to.  If
            negative, assume P3 is the second keypoint of the line instead of
            the first.

        Notes
        -----
        Generates a line (P2-P3) tangent at point P2 to line NL1 (P1-P2) and
        tangent at point P3 to line NL2 (P3-P4).
        """
        command = "L2TAN,%s,%s" % (str(nl1), str(nl2))
        return self.run(command, **kwargs)

    def dcum(self, oper="", rfact="", ifact="", tb_ase="", **kwargs):
        """APDL Command: DCUM

        Specifies that DOF constraint values are to be accumulated.

        Parameters
        ----------
        oper
            Accumulation key:

            REPL - Subsequent values replace the previous values (default).

            ADD - Subsequent values are added to the previous values.

            IGNO - Subsequent values are ignored.

        rfact
            Scale factor for the real component.  Zero (or blank) defaults to
            1.0.  Use a small number for a zero scale factor.

        ifact
            Scale factor for the imaginary component.  Zero (or blank) defaults
            to 1.0.  Use a small number for a zero scale factor.

        tbase
            Base temperature for temperature difference.  Used only with
            temperature degree of freedom.  Scale factor is applied to the
            temperature difference (T-TBASE) and then added to TBASE.  T is the
            current temperature.

        Notes
        -----
        Allows repeated degree of freedom constraint values (displacement,
        temperature, etc.)  to be replaced, added, or ignored.  Operations
        apply to the selected nodes [NSEL] and the selected degree of freedom
        labels [DOFSEL]. This command also operates on velocity and
        acceleration loads applied in a structural analysis.

        The operations occur when the next degree of freedom constraints are
        defined.  For example, issuing the command D,1,UX,.025 after a previous
        D,1,UX,.020 causes the new value of the displacement on node 1 in the
        x-direction to be 0.045 with the add operation, 0.025 with the replace
        operation, or 0.020 with the ignore operation.  Scale factors are also
        available to multiply the next value before the add or replace
        operation.  A scale factor of 2.0 with the previous "add" example
        results in a displacement of 0.070.  Scale factors are applied even if
        no previous values exist.  Issue DCUM,STAT to show the current label,
        operation, and scale factors.  Solid model boundary conditions are not
        affected by this command, but boundary conditions on the FE model are
        affected.

        Note:: : FE boundary conditions may still be overwritten by existing
        solid model boundary conditions if a subsequent boundary condition
        transfer occurs.

        DCUM does not work for tabular boundary conditions.

        This command is also valid in PREP7.
        """
        command = "DCUM,%s,%s,%s,%s" % (str(oper), str(rfact), str(ifact), str(tb_ase))
        return self.run(command, **kwargs)

    def display(self, **kwargs):
        """APDL Command: DISPLAY

        Specifies "Display settings" as the subsequent status topic.

        Notes
        -----
        This is a status [STAT] topic command.  Status topic commands are
        generated by the GUI and will appear in the log file (Jobname.LOG) if
        status is requested for some items under Utility Menu> List> Status.
        This command will be immediately followed by a STAT command, which will
        report the status for the specified topic.

        If entered directly into the program, the STAT command should
        immediately follow this command.
        """
        command = "DISPLAY," % ()
        return self.run(command, **kwargs)

    def cmwrite(self, fname="", ext="", fmat="", **kwargs):
        """APDL Command: CMWRITE

        Writes node and element components and assemblies to a file.

        Parameters
        ----------
        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        fmat
            Format of the output file (defaults to BLOCKED).

            BLOCKED - Blocked format. This format allows faster reading of the file.

            UNBLOCKED - Unblocked format.
        """
        command = "CMWRITE,%s,%s,%s" % (str(fname), str(ext), str(fmat))
        return self.run(command, **kwargs)

    def nlist(self, node1="", node2="", ninc="", lcoord="", sort1="", sort2="",
              sort3="", kinternal="", **kwargs):
        """APDL Command: NLIST

        Lists nodes.

        Parameters
        ----------
        node1, node2, ninc
            List nodes from NODE1 to NODE2 (defaults to NODE1) in steps of NINC
            (defaults to 1).  If NODE1 = ALL (default), NODE2 and NINC are
            ignored and all selected nodes [NSEL] are listed.  If NODE1 = P,
            graphical picking is enabled and all remaining command fields are
            ignored (valid only in the GUI).  A component name may also be
            substituted for NODE1 (NODE2 and NINC are ignored).

        lcoord
            Coordinate listing key:

            (blank) - List all nodal information

            COORD - Suppress all but the XYZ coordinates (shown to a higher degree of accuracy than
                    when displayed with all information).

        sort1
            First item on which to sort.  Valid item names are NODE, X, Y, Z,
            THXY, THYZ, THXZ

        sort2, sort3
            Second and third items on which to sort.  Valid item names are the
            same as for SORT1.

        kinternal
            Internal nodes listing key:

            (blank) - List only external nodes.

            INTERNAL - List all nodes, including internal nodes.

        Notes
        -----
        Lists nodes in the active display coordinate system [DSYS].  Nodal
        coordinate rotation angles are also listed (relative to the global
        Cartesian coordinate system).

        Node listing can be in a sorted order (ascending).  SORT2, for example,
        will be carried out on nodes having equal values of SORT1.

        This command is valid in any processor.
        """
        command = "NLIST,%s,%s,%s,%s,%s,%s,%s,%s" % (str(node1), str(node2), str(ninc), str(lcoord), str(sort1), str(sort2), str(sort3), str(kinternal))
        return self.run(command, **kwargs)

    def trpoin(self, x="", y="", z="", vx="", vy="", vz="", chrg="", m_ass="",
               **kwargs):
        """APDL Command: TRPOIN

        Defines a point through which a particle flow or charged particle trace
        will travel.

        Parameters
        ----------
        x, y, z
            Coordinate location of the trace point (in the active coordinate
            system).  If X = P, graphical picking is enabled and all remaining
            command fields are ignored (valid only in the GUI).

        vx, vy, vz
            Particle velocities in the X, Y and Z directions (in the active
            coordinate system).

        chrg
            Particle charge.

        mass
            Particle mass.

        Notes
        -----
        Defines a point through which a particle flow or charged particle trace
        [PLTRAC] will travel.  Multiple points (50 maximum) may be defined
        which will result in multiple flow traces.  Use TRPLIS to list the
        currently defined trace points and TRPDEL to delete trace points.

        The VX, VY, VZ, CHRG, and MASS arguments only apply to charged
        particles.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "TRPOIN,%s,%s,%s,%s,%s,%s,%s,%s" % (str(x), str(y), str(z), str(vx), str(vy), str(vz), str(chrg), str(m_ass))
        return self.run(command, **kwargs)

    def edcadapt(self, freq="", tol="", opt="", maxlvl="", btime="", dtime="",
                 lcid="", adpsize="", adp_ass="", ireflg="", adpene="",
                 adpth="", maxel="", **kwargs):
        """APDL Command: EDCADAPT

        Specifies adaptive meshing controls for an explicit dynamic analysis.

        Parameters
        ----------
        freq
            Time interval between adaptive mesh refinements (default = 0.0).
            Use FREQ = STAT to list the current adaptive meshing control
            settings.

        tol
            Adaptive angle tolerance (in degrees) for which adaptive meshing
            will occur (default = 1e31). If the relative angle change between
            elements exceeds the specified tolerance value, the elements will
            be refined.

        opt
            Adaptivity option:

            1 - Angle change (in degrees) of elements is based on original mesh configuration
                (default).

            2 - Angle change (in degrees) of elements is incrementally based on previously
                refined mesh.

        maxlvl
            Maximum number of mesh refinement levels (default = 3). This
            parameter controls the number of times an element can be remeshed.
            Values of 1, 2, 3, 4, etc. allow a maximum of 1, 4, 16, 64, etc.
            elements, respectively, to be created for each original element.

        btime
            Birth time to begin adaptive meshing (default = 0.0).

        dtime
            Death time to end adaptive meshing (default = 1e31).

        lcid
            Data curve number (previously defined on the EDCURVE command)
            identifying the interval of remeshing (no default). The abscissa of
            the data curve is time, and the ordinate is the varied adaptive
            time interval. If LCID is nonzero, the adaptive frequency (FREQ) is
            replaced by this load curve. Note that a nonzero FREQ value is
            still required to initiate the first adaptive loop.

        adpsize
            Minimum element size to be adapted based on element edge length
            (default = 0.0).

        adpass
            One or two pass adaptivity option.

            0 - Two pass adaptivity (default).

            1 - One pass adaptivity.

        ireflg
            Uniform refinement level flag (no default). Values of 1, 2, 3, etc.
            allow 4, 16, 64, etc. elements, respectively, to be created
            uniformly for each original element.

        adpene
            Adaptive mesh flag for starting adaptivity when approaching
            (positive ADPENE value) or penetrating (negative ADPENE value) the
            tooling surface (default = 0.0).

        adpth
            Absolute shell thickness level below which adaptivity should begin.
            This option works only if the adaptive angle tolerance (TOL) is
            nonzero. If thickness based adaptive remeshing is desired without
            angle change, set TOL to a large angle. The default is ADPTH = 0.0,
            which means this option is not used.

        maxel
            Maximum number of elements at which adaptivity will be terminated
            (no default). Adaptivity is stopped if this number of elements is
            exceeded.

        Notes
        -----
        The EDCADAPT command globally sets the control options for all part IDs
        that are to be adaptively meshed (see the EDADAPT command). Because
        FREQ defaults to zero, you must input a nonzero value in this field in
        order to activate adaptive meshing. You must also specify a reasonable
        value for TOL since the default adaptive angle tolerance (1e31) will
        not allow adaptive meshing to occur.

        The EDCADAPT command is not supported in an explicit dynamic full
        restart analysis (EDSTART,3).

        This command is also valid in PREP7.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDCADAPT,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(freq), str(tol), str(opt), str(maxlvl), str(btime), str(dtime), str(lcid), str(adpsize), str(adp_ass), str(ireflg), str(adpene), str(adpth), str(maxel))
        return self.run(command, **kwargs)

    def pcross(self, labxr="", labyr="", labzr="", labx1="", laby1="",
               labz1="", labx2="", laby2="", labz2="", **kwargs):
        """APDL Command: PCROSS

        Calculates the cross product of two path vectors along the current
        path.

        Parameters
        ----------
        labxr
            Label assigned to X-component of resultant vector.

        labyr
            Label assigned to Y-component of resultant vector.

        labzr
            Label assigned to Z-component of resultant vector.

        labx1
            X-component of first vector label (labeled path item).

        laby1
            Y-component of first vector label.

        labz1
            Z-component of first vector label.

        labx2
            X-component of second vector label (labeled path item).

        laby2
            Y-component of second vector label.

        labz2
            Z-component of second vector label.
        """
        command = "PCROSS,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(labxr), str(labyr), str(labzr), str(labx1), str(laby1), str(labz1), str(labx2), str(laby2), str(labz2))
        return self.run(command, **kwargs)

    def lsbw(self, nl="", sepo="", keep="", **kwargs):
        """APDL Command: LSBW

        Subtracts the intersection of the working plane from lines (divides
        lines).

        Parameters
        ----------
        nl
            Line (or lines, if picking is used) to be subtracted from.  If NL =
            ALL, use all selected lines.  If NL = P, graphical picking is
            enabled and all remaining command fields are ignored (valid only in
            the GUI).  A component name may also be input for NL.

        sepo
            Behavior of the created boundary.

            (blank) - The resulting lines will share keypoint(s) where they touch.

            SEPO - The resulting lines will have separate, but coincident keypoint(s).

        keep
            Specifies whether NL lines are to be deleted:

            (blank) - Use the setting of KEEP on the BOPTN command.

            DELETE - Delete NL lines after LSBW operation (override BOPTN command settings).

            KEEP - Keep NL lines after LSBW operation (override BOPTN command settings).

        Notes
        -----
        Generates new lines by subtracting the intersection of the working
        plane from the NL lines.  The intersection will be a keypoint(s).  The
        working plane must not be in the same plane as the NL line(s).  If SEPO
        is blank, the NL line is divided and the resulting lines will be
        connected, sharing a common keypoint where they touch.  If SEPO is set
        to SEPO, NL is divided into two unconnected lines with separate
        keypoints.  See the Modeling and Meshing Guide for an illustration.
        See the BOPTN command for an explanation of the options available to
        Boolean operations.  Element attributes and solid model boundary
        conditions assigned to the original entities will not be transferred to
        the new entities generated.  Areas that completely contain the input
        lines will be updated if the lines are divided by this operation.
        """
        command = "LSBW,%s,%s,%s" % (str(nl), str(sepo), str(keep))
        return self.run(command, **kwargs)

    def oclist(self, datatype="", zonename="", **kwargs):
        """APDL Command: OCLIST

        Summarizes all currently defined ocean loads.

        Parameters
        ----------
        datatype
            Ocean data type to list. Valid values are BASIC, CURRENT, WAVE,
            ZONE, and ALL.

        zonename
            The name of an ocean zone to list. If no name is specified, all
            defined ocean zones are listed. Valid only when DataType = ZONE.

        Notes
        -----
        The OCLIST command summarizes the ocean properties for all defined
        ocean loads in the current session.

        When this command follows the SOLVE command, certain waves types also
        list the calculated wave length.

        This command is also valid in PREP7.
        """
        command = "OCLIST,%s,%s" % (str(datatype), str(zonename))
        return self.run(command, **kwargs)

    def fsum(self, lab="", item="", **kwargs):
        """APDL Command: FSUM

        Sums the nodal force and moment contributions of elements.

        Parameters
        ----------
        lab
            Coordinate system in which to perform summation.

            (blank) - Sum all nodal forces in global Cartesian coordinate system (default).

            RSYS - Sum all nodal forces in the currently active RSYS coordinate system.

        item
            Selected set of nodes.

            (blank) - Sum all nodal forces for all selected nodes (default), excluding contact
                      elements.

            CONT - Sum all nodal forces for contact nodes only.

            BOTH - Sum all nodal forces for all selected nodes, including contact elements.

        Notes
        -----
        Sums and prints, in each component direction for the total selected
        node set, the nodal force and moment contributions of the selected
        elements attached to the node set. Selecting a subset of nodes [NSEL]
        and then issuing this command will give the total force acting on that
        set of nodes (default), excluding surface-to-surface, node-to-surface,
        line-to-line, and line-to-surface contact elements (TARGE169, TARGE170,
        CONTA171, CONTA172, CONTA173, CONTA174, CONTA175, CONTA176, and
        CONTA177).

        Setting ITEM = CONT sums the nodal forces and moment contributions of
        the selected contact elements (CONTA171, CONTA172, CONTA173, CONTA174,
        CONTA175, CONTA176, and CONTA177). Setting ITEM = BOTH sums the nodal
        forces for all selected nodes, including contact elements.

        Nodal forces associated with surface loads are not included. The
        effects of nodal coupling and constraint equations are ignored. Moment
        summations are about the global origin unless another point is
        specified with the SPOINT command. This vector sum is printed in the
        global Cartesian system unless it is transformed [RSYS] and a point is
        specified with the SPOINT command. By default, the sum is done in
        global Cartesian, and the resulting vector is transformed to the
        requested system.

        The LAB = RSYS option transforms each of the nodal forces into the
        active coordinate system before summing and printing. The FORCE command
        can be used to specify which component (static, damping, inertia, or
        total) of the nodal load is to be used. This command output is included
        in the NFORCE command.

        The command should not be used with axisymmetric elements because it
        might calculate a moment where none exists. Consider, for example, the
        axial load on a pipe modeled with an axisymmetric shell element.  The
        reaction force on the end of the pipe is the total force (for the full
        360 degrees) at that location. The net moment about the centerline of
        the pipe would be zero, but the program would incorrectly calculate a
        moment at the end of the element as the force multiplied by the radius.

        The command is not valid for elements that operate solely within the
        nodal coordinate system with 1-D option activated and rotated nodes
        (NROTAT).
        """
        command = "FSUM,%s,%s" % (str(lab), str(item))
        return self.run(command, **kwargs)

    def lsscale(self, nl1="", nl2="", ninc="", rx="", ry="", rz="", kinc="",
                noelem="", imove="", **kwargs):
        """APDL Command: LSSCALE

        Generates a scaled set of lines from a pattern of lines.

        Parameters
        ----------
        nl1, nl2, ninc
            Set of lines (NL1 to NL2 in steps of NINC) that defines the pattern
            to be scaled.  NL2 defaults to NL1, NINC defaults to 1.  If NL1 =
            ALL, NL2 and NINC are ignored and the pattern is defined by all
            selected lines.  If NL1 = P, graphical picking is enabled and all
            remaining command fields are ignored (valid only in the GUI).  A
            component name may also be substituted for NL1 (NL2 and NINC are
            ignored).

        rx, ry, rz
            Scale factors to be applied to the X, Y, Z keypoint coordinates in
            active coordinate system (RR, Rθ, RZ for cylindrical; RR, Rθ, RΦ
            for spherical).  Note that the Rθ and RΦ scale factors are
            interpreted as angular offsets.  For example, for CSYS,1, RR, Rθ,
            RZ input of (1.5,10,3) would scale the specified keypoints 1.5
            times in the radial and 3 times in the Z direction, while adding an
            offset of 10 degrees to the keypoints.  Zero, blank, or negative
            scale factor values are assumed to be 1.0.  Zero or blank angular
            offsets have no effect.

        kinc
            Increment to be applied to keypoint numbers for generated set.  If
            zero, the lowest available keypoint numbers will be assigned
            [NUMSTR].

        noelem
            Specifies whether nodes and elements are also to be generated:

            0 - Nodes and line elements associated with the original lines will be generated
                (scaled) if they exist.

            1 - Nodes and line elements will not be generated.

        imove
            Specifies whether lines will be moved or newly defined:

            0 - Additional lines will be generated.

            1 - Original lines will be moved to new position (KINC and NOELEM are ignored).
                Use only if the old lines are no longer needed at their
                original positions.  Corresponding meshed items are also moved
                if not needed at their original position.

        Notes
        -----
        Generates a scaled set of lines (and their corresponding keypoints and
        mesh) from a pattern of lines.  The MAT, TYPE, REAL, and ESYS
        attributes are based on the lines in the pattern and not the current
        settings.  Scaling is done in the active coordinate system.  Lines in
        the pattern could have been generated in any coordinate system.
        """
        command = "LSSCALE,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(nl1), str(nl2), str(ninc), str(rx), str(ry), str(rz), str(kinc), str(noelem), str(imove))
        return self.run(command, **kwargs)

    def mpwrite(self, fname="", ext="", mat="", **kwargs):
        """APDL Command: MPWRITE

        Writes linear material properties in the database to a file (if the LIB
        option is not specified) or writes both linear and nonlinear material
        properties (if LIB is specified) from the database to a file.

        Parameters
        ----------
        fname
            File name and directory path (248 characters maximum, including
            directory). If you do not specify the LIB option, the default
            directory is the current working directory. If you specify LIB and
            you have specified a material library directory (via the /MPLIB
            command), that directory is the default. Otherwise, the default is
            the current working directory. If you use the default for your
            directory, you can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        lib
            The only value allowed for this field is the string "LIB."

        mat
            Specifies the material to be written to the named material library
            file.  There is no default; you must either specify a material or
            omit the MAT argument.  Even if you specify a MAT value, the ANSYS
            program ignores it if the LIB argument is not specified.

        Notes
        -----
        Writes linear material properties currently in the database to a file.
        The file is rewound before and after writing.

        This command is also valid in SOLUTION.
        """
        command = "MPWRITE,%s,%s,%s" % (str(fname), str(ext), str(mat))
        return self.run(command, **kwargs)

    def bfk(self, kpoi="", lab="", val1="", val2="", val3="", ph_ase="",
            **kwargs):
        """APDL Command: BFK

        Defines a body force load at a keypoint.

        Parameters
        ----------
        kpoi
            Keypoint to which body load applies.  If ALL, apply to all selected
            keypoints [KSEL].  A component name may also be substituted for
            Kpoi.

        lab
            Valid body load label. Load labels are listed under "Body Loads" in
            the input table for each element type in the Element Reference.

        val1, val2, val3
            Value associated with the Lab item or a table name for specifying
            tabular boundary conditions.  Use only VAL1 for TEMP, FLUE, HGEN,
            MVDI and CHRGD.  For magnetics, use VAL1, VAL2, and VAL3 for the X,
            Y, and Z components of JS . For acoustics, if Lab = JS,  use VAL1
            for mass source in a harmonic analysis or mass source rate in a
            transient analysis, and ignoreVAL2 and VAL3. When specifying a
            table name, you must enclose the table name in percent signs (%),
            e.g., BFK,Kpoi,Lab,%tabname%.  Use the *DIM command to define a
            table.

        phase
            Phase angle in degrees associated with the JS label.

        Notes
        -----
        Defines a body force load (such as temperature in a structural
        analysis, heat generation rate in a thermal analysis, etc.) at a
        keypoint.  Body loads may be transferred from keypoints to nodes with
        the BFTRAN or SBCTRAN commands.  Interpolation will be used to apply
        loads to the nodes on the lines between keypoints.  All keypoints on a
        given area (or volume) must have the same BFK specification, with the
        same values, for the loads to be transferred to interior nodes in the
        area (or volume).  If only one keypoint on a line has a BFK
        specification, the other keypoint defaults to the value specified on
        the BFUNIF command.

        You can specify a table name only when using temperature (TEMP) and
        heat generation rate (HGEN) body load labels.

        Body loads specified by the BFK command can conflict with other
        specified body loads.  See Resolution of Conflicting Body Load
        Specifications in the Basic Analysis Guide for details.

        Graphical picking is available only via the listed menu paths.

        This command is also valid in PREP7.
        """
        command = "BFK,%s,%s,%s,%s,%s,%s" % (str(kpoi), str(lab), str(val1), str(val2), str(val3), str(ph_ase))
        return self.run(command, **kwargs)

    def bfklist(self, kpoi="", lab="", **kwargs):
        """APDL Command: BFKLIST

        Lists the body force loads at keypoints.

        Parameters
        ----------
        kpoi
            Keypoint at which body load is to be listed.  If ALL (or blank),
            list for all selected keypoints [KSEL].  If KPOI = P, graphical
            picking is enabled and all remaining command fields are ignored
            (valid only in the GUI).  A component name may also be substituted
            for KPOI

        lab
            Valid body load label. If ALL, use all appropriate labels. Load
            labels are listed under "Body Loads" in the input table for each
            element type in the Element Reference. See the BFK command for
            labels.

        Notes
        -----
        Lists the body force loads for the specified keypoint and label.
        Keypoint body loads may be defined with the BFK command.

        This command is valid in any processor.
        """
        command = "BFKLIST,%s,%s" % (str(kpoi), str(lab))
        return self.run(command, **kwargs)

    def cdopt(self, option="", **kwargs):
        """APDL Command: CDOPT

        Specifies format to be used for archiving geometry.

        Parameters
        ----------
        option
            IGES

            IGES - Write solid model geometry information using IGES format (default).

            ANF - Write solid model geometry information using ANSYS Neutral File format.

            STAT - Print out the current format setting.

        Notes
        -----
        This command controls your solid model geometry format for CDWRITE
        operations. The ANF option affects only the COMB and SOLID options of
        the CDWRITE command. All other options remain unaffected.

        This option setting is saved in the database.
        """
        command = "CDOPT,%s" % (str(option))
        return self.run(command, **kwargs)

    def nslk(self, type="", **kwargs):
        """APDL Command: NSLK

        Selects those nodes associated with the selected keypoints.

        Parameters
        ----------
        type
            Label identifying the type of node select:

            S - Select a new set (default).

            R - Reselect a set from the current set.

            A - Additionally select a set and extend the current set.

            U - Unselect a set from the current set.

        Notes
        -----
        Valid only if the nodes were generated by a keypoint meshing operation
        [KMESH, LMESH, AMESH, VMESH] on a solid model that contains the
        selected keypoints.

        This command is valid in any processor.
        """
        command = "NSLK,%s" % (str(type))
        return self.run(command, **kwargs)

    def mlist(self, node1="", node2="", ninc="", **kwargs):
        """APDL Command: MLIST

        Lists the MDOF of freedom.

        Parameters
        ----------
        node1, node2, ninc
            List master degrees of freedom from NODE1 to NODE2 (defaults
            toNODE1) in steps of NINC (defaults to 1).  If NODE1 = ALL
            (default), NODE2 and NINC are ignored and masters for all selected
            nodes [NSEL] are listed.  If NODE1 = P, graphical picking is
            enabled and all remaining command fields are ignored (valid only in
            the GUI).  A component name may also be substituted for NODE1
            (NODE2 and NINC are ignored).

        Notes
        -----
        Lists the master degrees of freedom.
        """
        command = "MLIST,%s,%s,%s" % (str(node1), str(node2), str(ninc))
        return self.run(command, **kwargs)

    def fjdele(self, elem="", lab="", **kwargs):
        """APDL Command: FJDELE

        Deletes forces (or moments) on the components of the relative motion of
        a joint element.

        Parameters
        ----------
        elem
            Element number, or ALL. (leaving this blank defaults to ALL)

        lab
            Valid labels are:

            FX - Force in local x direction.

            FY - Force in local y direction.

            FZ - Force in local z direction.

            MX - Moment about local x axis.

            MY - Moment about local y axis.

            MZ - Moment about local z axis.

            ALL, or (blank) - Delete all valid forces or moments.

        Notes
        -----
        Valid for MPC184 (joint options in KEYOPT(1)).

        See FJ for information on specifying forces (or moments).
        """
        command = "FJDELE,%s,%s" % (str(elem), str(lab))
        return self.run(command, **kwargs)

    def detab(self, elem="", lab="", v1="", v2="", v3="", v4="", v5="", v6="",
              **kwargs):
        """APDL Command: DETAB

        Modifies element table results in the database.

        Parameters
        ----------
        elem
            Element for which results are to be modified.  If ALL, modify all
            selected elements [ESEL] results.  If ELEM = P, graphical picking
            is enabled and all remaining command fields are ignored (valid only
            in the GUI).  A component name may also be substituted for ELEM.

        lab
            Label identifying results.  Valid labels are as defined with the
            ETABLE command.  Issue ETABLE,STAT to display labels and values.

        v1
            Value assigned to this element table result in the database.  If
            zero, a zero value will be assigned.  If blank, value remains
            unchanged.

        v2, v3, v4, . . . , v6
            Additional values (if any) assigned to consecutive element table
            columns.

        Notes
        -----
        Modifies element table [ETABLE] results in the database.  For example,
        DETAB,35,ABC,1000,2000,1000 assigns 1000, 2000, and 1000 to the first
        three table columns starting with label ABC for element 35.  Use the
        PRETAB command to list the current results.  After deleting a column of
        data using ETABLE,Lab,ERASE, the remaining columns of data are not
        shifted to compress the empty slot.  Therefore, the user must allocate
        null (blank) values for V1, V2...V6 for any ETABLE entries which have
        been deleted by issuing ETABLE,Lab,ERASE.  All data are stored in the
        solution coordinate system but will be displayed in the results
        coordinate system [RSYS].
        """
        command = "DETAB,%s,%s,%s,%s,%s,%s,%s,%s" % (str(elem), str(lab), str(v1), str(v2), str(v3), str(v4), str(v5), str(v6))
        return self.run(command, **kwargs)

    def dsym(self, lab="", normal="", kcn="", **kwargs):
        """APDL Command: DSYM

        Specifies symmetry or antisymmetry degree-of-freedom constraints on
        nodes.

        Parameters
        ----------
        lab
            Symmetry label:

            SYMM - Generate symmetry constraints as described below (default).

            ASYM - Generate antisymmetry constraints as described below.

        normal
            Surface orientation label to determine the constraint set (surface
            is assumed to be perpendicular to this coordinate direction in
            coordinate system KCN):

            X - Surface is normal to coordinate X direction (default).  Interpreted as R
                direction for non-Cartesian coordinate systems.

            Y - Surface is normal to coordinate Y direction.   θ direction for non-Cartesian
                coordinate systems.

            Z - Surface is normal to coordinate Z direction.   Φ direction for spherical or
                toroidal coordinate systems.

        kcn
            Reference number of global or local coordinate system used to
            define surface orientation.

        Notes
        -----
        Specifies symmetry or antisymmetry degree-of-freedom constraints on the
        selected nodes. The nodes are first automatically rotated (any
        previously defined rotations on these nodes are redefined) into
        coordinate system KCN, then zero-valued constraints are generated, as
        described below, on the selected degree-of-freedom set (limited to
        displacement, velocity, and magnetic degrees of freedom) [DOFSEL].
        Constraints are defined in the (rotated) nodal coordinate system, as
        usual. See the D and NROTAT commands for additional details about
        constraints and nodal rotations.

        This command is also valid in PREP7.

        Symmetry or antisymmetry constraint generations are based upon the
        valid degrees of freedom in the model, i.e., the degrees of freedom
        associated with the elements attached to the nodes.  The labels for
        degrees of freedom used in the generation depend on the Normal label.

        For displacement degrees of freedom, the constraints generated are:

        For velocity degrees of freedom, the constraints generated are:

        For magnetic degrees of freedom, the SYMM label generates flux normal
        conditions (flux flows normal to the surface).  Where no constraints
        are generated, the flux normal condition is "naturally" satisfied.  The
        ASYM label generates flux parallel conditions (flux flows parallel to
        the surface).
        """
        command = "DSYM,%s,%s,%s" % (str(lab), str(normal), str(kcn))
        return self.run(command, **kwargs)

    def abbsav(self, lab="", fname="", ext="", **kwargs):
        """APDL Command: ABBSAV

        Writes the current abbreviation set to a coded file.

        Parameters
        ----------
        lab
            Label that specifies the write operation:

        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        Notes
        -----
        Existing abbreviations on this file, if any, will be overwritten.  The
        abbreviation file may be read with the ABBRES command.

        This command is valid in any processor.
        """
        command = "ABBSAV,%s,%s,%s" % (str(lab), str(fname), str(ext))
        return self.run(command, **kwargs)

    def nocolor(self, key="", **kwargs):
        """APDL Command: NOCOLOR

        Removes color from graphics displays.

        Parameters
        ----------
        key
            Color key:

            0 - Color the displays.

            1 - Do not color the displays.

            2 - Do not shade the displays.
        """
        command = "NOCOLOR,%s" % (str(key))
        return self.run(command, **kwargs)

    def rsys(self, kcn="", **kwargs):
        """APDL Command: RSYS

        Activates a coordinate system for printout or display of element and
        nodal results.

        Parameters
        ----------
        kcn
            The coordinate system to use for results output:

            0 - Global Cartesian coordinate system (default, except for spectrum analyses).

            1 - Global cylindrical coordinate system.

            2 - Global spherical coordinate system.

            > 10 - Any existing local coordinate system.

            SOLU - Solution coordinate systems. For element quantities, these are the element
                   coordinate system for each element.  For nodal quantities,
                   these are the nodal coordinate systems. If an element or
                   nodal coordinate system is not defined, ANSYS uses the
                   global Cartesian coordinate system. If you issue a LAYER,N
                   command (where N refers to a layer number), the results
                   appear in the layer coordinate system. (SOLU is the default
                   for spectrum analyses.)

            LSYS - Layer coordinate system. For layered shell and solid elements, the results
                   appear in their respective layer coordinate systems.  For a
                   specific layer of interest, issue a LAYER,N command (where N
                   refers to a layer number). If a model has both nonlayered
                   and layered elements, you can use RSYS,SOLU and RSYS,LSYS
                   simultaneously (with RSYS,SOLU applicable to nonlayered
                   elements and RSYS,LSYS applicable to layered elements).  To
                   reverse effects of the LSYS option, issue an RSYS,0 command.
                   LSYS is the default for spectrum analysis.

        Notes
        -----
        The RSYS command activates a coordinate system for printing or
        displaying element results data such as stresses and heat fluxes, and
        nodal results data such as degrees of freedom and reactions. ANSYS
        rotates the results data to the specified coordinate system during
        printout, display, or element table operations (such as PRNSOL, PRESOL,
        PLNSOL, and ETABLE). You can define coordinate systems with various
        ANSYS commands such as LOCAL, CS, CLOCAL, and CSKP.

        If you issue RSYS with KCN > 10 (indicating a local coordinate system),
        and the specified system is subsequently redefined, you must reissue
        RSYS for results to be rotated into the redefined system.

        Note:: : The default coordinate system for certain elements, notably
        shells, is not global Cartesian and is frequently not aligned at
        adjacent elements.

        The use of RSYS,SOLU with these elements can make nodal averaging of
        component element results, such as SX, SY, SZ, SXY, SYZ, and SXZ,
        invalid and is not recommended.

        The RSYS command has no effect on beam or pipe stresses, which ANSYS
        displays (via /ESHAPE,1 and PowerGraphics) in the element coordinate
        system.

        Element results such as stresses and heat fluxes are in the element
        coordinate systems when KCN = SOLU. Nodal requests for element results
        (for example, PRNSOL,S,COMP) average the element values at the common
        node; that is, the orientation of the node is not a factor in the
        output of element quantities.  For nearly all solid elements, the
        default element coordinate systems are parallel to the global Cartesian
        coordinate system. For shell elements and the remaining solid elements,
        the default element coordinate system can differ from element to
        element. For layered shell and layered solid elements, ANSYS initially
        selects the element coordinate system when KCN = SOLU; you can then
        select the layer coordinate system via the LAYER command.

        Nodal results such as degrees of freedom and reactions can be properly
        rotated only if the resulting component set is consistent with the
        degree-of-freedom set at the node. (The degree-of-freedom set at a node
        is determined by the elements attached to the node.) For example, if a
        node does not have a UZ degree of freedom during solution, then any Z
        component resulting from a rotation does not print or display in POST1.
        Therefore, results at nodes with a single degree-of-freedom (UY only,
        for example) should not be rotated; that is, they should be viewed only
        in the nodal coordinate system or a system parallel to the nodal
        system. (The global Cartesian system--the RSYS command default--may not
        be parallel to the nodal system.) Results at nodes with a 2-D degree-
        of-freedom set (UX and UY, for example) should not be rotated out of
        the 2-D plane.

        PowerGraphics

        For PowerGraphics, ANSYS plots PLVECT vector arrow displays (such
        temperature, velocity, and force) in the global Cartesian coordinate
        system (RSYS = 0). Subsequent operations revert to your original
        coordinate system.

        PGR File

        When you generate a .PGR file in SOLUTION, you can use the Results
        Viewer to display your stresses only in the coordinate system in which
        you write your .PGR file. To view stresses in other coordinate systems,
        load your results file into the Results Viewer and regenerate the data.

        Large Deflections

        If large deflection is active (NLGEOM,ON), ANSYS rotates the element
        component result directions by the amount of rigid body rotation.

        ANSYS displays the element component results in the initial global
        coordinate system for the following elements: SHELL181, SHELL281,
        ELBOW290, PLANE182, PLANE183, SOLID185, SOLID186, SOLID187, SOLID272,
        SOLID273, SOLID285, SOLSH190, SHELL208, and SHELL209. All other element
        result transformations are, therefore, also relative to the initial
        global system. Nodal degree-of-freedom results are based on the initial
        (and not the updated) geometry. For all other element types, component
        results displayed in the co-rotated coordinate system include the
        element rigid body rotation from the initial global coordinate system,
        and all other element result transformations are relative to the
        rotated global system.

        LS-DYNA

        You can use the RSYS command to rotate stress data for all explicit
        (ANSYS LS-DYNA) elements except BEAM161, COMBI165, and composite
        SHELL163 (KEYOPT(3) = 1). In models that contain these element types
        combined with other explicit elements, you must unselect the
        unsupported elements before issuing the RSYS command. The command does
        not support strain data for any explicit element types. If you request
        strain results for explicit elements when RSYS is not set to the global
        Cartesian coordinate system (KCN = 0), ANSYS ignores the printing or
        plotting command. (ANSYS always rotates displacements into the results
        coordinate system, independent of the explicit element type.)
        """
        command = "RSYS,%s" % (str(kcn))
        return self.run(command, **kwargs)

    def nrm(self, name="", normtype="", parr="", normalize="", **kwargs):
        """APDL Command: *NRM

        Computes the norm of the specified matrix or vector.

        Parameters
        ----------
        name
            Matrix or vector for which the norm will be computed. This can be a
            dense matrix (created by the *DMAT command), a sparse matrix
            (created by the *SMAT command) or a vector (created by the *VEC
            command)

        normtype
            Mathematical norm to use:

            L2 (Euclidian or SRSS) norm (default). - L1 (absolute sum) norm (vectors only).

        parr
            Parameter name that contains the result.

        normalize
            Normalization key; to be used only for vectors created by *VEC:

            Normalize the vector such that the norm is 1.0. - Do not normalize the vector (default).

        Notes
        -----
        The NRM2 option corresponds to the Euclidian or L2 norm and is
        applicable to either vectors or matrices. The NRM1 option corresponds
        to the L1 norm and is applicable to vectors only. The NRMINF option is
        the maximum norm and is applicable to either vectors or matrices.
        """
        command = "*NRM,%s,%s,%s,%s" % (str(name), str(normtype), str(parr), str(normalize))
        return self.run(command, **kwargs)

    def sfgrad(self, lab="", slkcn="", sldir="", slzer="", slope="", **kwargs):
        """APDL Command: SFGRAD

        Specifies a gradient (slope) for surface loads.

        Parameters
        ----------
        lab
            Valid surface load label.  Load labels are listed under "Surface
            Loads" in the input table for each element type in the Element
            Reference.

        slkcn
            Reference number of slope coordinate system (used with Sldir and
            SLZER to determine COORD).  Defaults to 0 (the global Cartesian
            coordinate system).

        sldir
            Slope direction in coordinate system SLKCN:

            X - Slope is along X direction (default).  Interpreted as R direction for non-
                Cartesian coordinate systems.

            Y - Slope is along Y direction.  Interpreted as  θ direction for non-Cartesian
                coordinate systems.

            Z - Slope is along Z direction.  Interpreted as Φ direction for spherical or
                toroidal coordinate systems.

        slzer
            Coordinate location (degrees for angular input) where slope
            contribution is zero (CVALUE = VALUE).  Allows the slope
            contribution to be shifted along the slope direction.  For angular
            input, SLZER should be between ±180° if the singularity [CSCIR]  is
            at 180° and should be between 0° and 360° if the singularity is at
            0°.

        slope
            Slope value (load per unit length or per degree).

        Notes
        -----
        Specifies a gradient (slope) for surface loads.  All surface loads
        issued with the SF, SFE, SFL, or SFA commands while this specification
        is active will have this gradient applied (for complex pressures, only
        the real component will be affected; for convections, only the bulk
        temperature will be affected).  The load value, CVALUE, calculated at
        each node is:

        CVALUE = VALUE + (SLOPE X (COORD-SLZER))

        where VALUE is the load value specified on the subsequent SF, SFE, SFL,
        or SFA commands and COORD is the coordinate value (in the Sldir
        direction of coordinate system SLKCN) of the node.  Only one SFGRAD
        specification may be active at a time (repeated use of this command
        replaces the previous specification with the new specification).  Issue
        SFGRAD (with blank fields) to remove the specification.  Issue
        SFGRAD,STAT to show the current command status.  The SFGRAD
        specification (if active) is removed when the LSREAD (if any) command
        is issued.

        SFGRAD does not work for tabular boundary conditions.

        This command is also valid in PREP7.
        """
        command = "SFGRAD,%s,%s,%s,%s,%s" % (str(lab), str(slkcn), str(sldir), str(slzer), str(slope))
        return self.run(command, **kwargs)

    def elseif(self, val1="", oper1="", val2="", conj="", val3="", oper2="",
               val4="", **kwargs):
        """APDL Command: *ELSEIF

        Separates an intermediate if-then-else block.

        Parameters
        ----------
        val1
            First numerical value (or parameter which evaluates to numerical
            value) in the conditional comparison operation. VAL1, VAL2, VAL3,
            and VAL4 can also be character strings (enclosed in quotes) or
            parameters for Oper = EQ and NE only.

        oper1
            Operation label. A tolerance of 1.0E-10 is used for comparisons
            between real numbers:

            Equal (for VAL1 = VAL2). - Not equal (for VAL1 ≠VAL2).

            Less than (for VAL1<VAL2). - Greater than (for VAL1>VAL2).

            Less than or equal (for VAL1 VAL2). - Greater than or equal (for VAL1 VAL2).

            Absolute values of VAL1 and VAL2 before < operation. - Absolute values of VAL1 and VAL2 before > operation.

        val2
            Second numerical value (or parameter which evaluates to numerical
            value) in the conditional comparison operation.

        conj
            (Optional) Connection between two logical clauses.

            True if both clauses (Oper1 and Oper2) are true.  - True if either clause is true.

        val3
            (Optional) Third numerical value (or parameter which evaluates to
            numerical value).

        oper2
            (Optional) Operation label.  This will have the same labels as
            Oper1, except it uses Val3 and Val4. A tolerance of 1.0E-10 is used
            for comparisons between real numbers.

        val4
            (Optional) Fourth numerical value (or parameter value which
            evaluates to a numerical value).

        Notes
        -----
        Optional intermediate block separator within an if-then-else construct.
        All seven characters of the command name (*ELSEIF) must be input. This
        command is similar to the *IF  command except that the Base field is
        not used. The *IF, *ELSEIF, *ELSE, and *ENDIF commands for each if-
        then-else construct must all be read from the same file (or keyboard).

        This command is valid in any processor.
        """
        command = "*ELSEIF,%s,%s,%s,%s,%s,%s,%s" % (str(val1), str(oper1), str(val2), str(conj), str(val3), str(oper2), str(val4))
        return self.run(command, **kwargs)

    def prsect(self, rho="", kbr="", **kwargs):
        """APDL Command: PRSECT

        Calculates and prints linearized stresses along a section path.

        Parameters
        ----------
        rho
            In-plane (X-Y) average radius of curvature of the inside and
            outside surfaces of an axisymmetric section.  If zero (or blank), a
            plane or 3-D structure is assumed.  If nonzero, an axisymmetric
            structure is assumed.  Use any large number (or -1) for an
            axisymmetric straight section.

        kbr
            Through-thickness bending stresses key for an axisymmetric analysis
            (RHO  ≠ 0):

            0 - Include the thickness-direction bending stresses.

            1 - Ignore the thickness-direction bending stresses.

            2 - Include the thickness-direction bending stress using the same formula as the Y
                (axial direction ) bending stress. Also use the same formula
                for the shear stress.

        Notes
        -----
        You may choose to linearize the stresses through a section and separate
        them into categories for various code calculations.  PRSECT calculates
        and reports linearized stresses along a section path.  The linearized
        stresses are also separated into membrane, bending, membrane plus
        bending, peak, and total stress categories.

        First, define your section path using the PATH and PPATH (with the NODE
        option) commands.  Your path must lie entirely within the selected set
        of elements (that is, there must be no element gaps along the path).
        PATH and PPATH are used only to retrieve the two end nodes.  The path
        data is not retained.  The section path is defined by the two end
        nodes, and by 47 intermediate points that are automatically determined
        by linear interpolation in the active display coordinate system [DSYS].
        The number and location of the intermediate points are not affected by
        the number of divisions set by PATH,,,,nDiv.

        Your  linearized component stress values are obtained by interpolating
        each element’s  average corner nodal values along the section path
        points within each path element.  PRSECT reports the linearized
        component and principal stresses for each stress category at the
        beginning, mid-length, and end of the section path.  PRPATH can be used
        to report the total stresses at the intermediate points.

        Section paths may be through any set of solid (2-D plane, 2-D
        axisymmetric or 3-D) elements.  However, section paths are usually
        defined to be through the thickness of the structure and normal to the
        inner and outer structure surfaces.  Section paths (in-plane only) may
        also be defined for shell element structures.  See the Mechanical APDL
        Theory Reference for details.

        If the RHO option is set to indicate the axisymmetric option (non-
        zero), PRSECT reports the linearized stresses in the section
        coordinates (SX – along the path, SY – normal to the path, and SZ –
        hoop direction).  If the RHO option is set to indicate the 2-D planar
        or 3-D option (zero or blank), PRSECT reports the linearized stresses
        in the active results coordinate system [RSYS].  If the RHO option is
        zero or blank and either RSYS, SOLU or RSYS, -1 are active, the
        linearized stresses are calculated and reported in the global Cartesian
        coordinate system.  It is recommended that linearized stress
        calculations be performed in a rectangular coordinate system.
        Principal stresses are recalculated from the component stresses and are
        invariant with the coordinate system as long as SX is in the same
        direction at all points along the defined path.  The PLSECT command
        displays the linearized stresses in the same coordinate system as
        reported by PRSECT.

        Stress components through the section are linearized by a line integral
        method and separated into constant membrane stresses, bending stresses
        varying linearly between end points, and peak stresses (defined as the
        difference between the actual (total) stress and the membrane plus
        bending combination).

        For nonaxisymmetric structures,  the bending stresses are calculated
        such that the neutral axis is at the midpoint of the path.
        Axisymmetric results include the effects of both the radius of
        revolution (automatically determined from the node locations) and the
        in-plane average radius of curvature of the section surfaces (user
        input).

        For axisymmetric cases, Mechanical APDL calculates the linearized
        bending stress in the through-thickness direction as the difference
        between the total outer fiber stress and the membrane stress if KBR =
        1. The calculation method may be conservative for locations with a
        highly nonlinear variation of stress in the through-thickness
        direction.  Alternatively, you can specify KBR = 2 to calculate the
        bending stress using the same method and formula as the Y (axial
        direction) bending stress. For more information, see the discussion of
        axisymmetric cases (specifically Equation: 17–40) in the Mechanical
        APDL Theory Reference.

        Portions of this command are not supported by PowerGraphics
        [/GRAPHICS,POWER].
        """
        command = "PRSECT,%s,%s" % (str(rho), str(kbr))
        return self.run(command, **kwargs)

    def spmwrite(self, method="", nmode="", inputs="", inputlabels="",
                 outputs="", outputlabels="", nic="", velacckey="",
                 fileformat="", **kwargs):
        """APDL Command: SPMWRITE

        Calculates the state-space matrices and writes them to the SPM file.

        Parameters
        ----------
        method
            Reduction method for the calculation of the state-space matrices.

            MODAL - Method based on modal analysis results from LANB, LANPCG, SNODE, or SUBSP
                    eigensolver (default).

        nmode
            Number of modes to be used. Defaults to all modes.

        inputs
            Definition of the inputs. Defaults to all load vectors on the MODE
            file.

        inputlabels
            Definition of the input labels. Defaults to the load vector numbers
            or input definition (node and degree of freedom array parameter),
            depending on the Inputs specification.

        outputs
            Definition of the outputs. Defaults to the inputs.

        outputlabels
            Definition of the output labels. Defaults to the output definition
            (node and degree of freedom) if used, else defaults to the
            InputLabels.

        nic
            Load vector on the MODE file used for the calculation of the
            initial conditions. Defaults to no initial condition.

        velacckey
            Output velocities and accelerations key.

            OFF - Output displacements only (default).

            ON - Output displacements, velocities and accelerations.

        fileformat
            The format of the SPM file.

            0 - Dense format.

            1 - Matrix Market Exchange format (non-zero terms only).

            2 - Simplorer SML format without reference (default).

            3 - Simplorer SML format with common reference.

            4 - Simplorer SML format with independent references.

        Notes
        -----
        The SPMWRITE generates the file Jobname.SPM containing the state-space
        matrices and other information.

        The following applies to the SML formats (FileFormat = 2, 3, and 4):

        For conservative systems where the outputs are equal to the inputs
        (Outputs is left blank):

        The labels for the inputs (InputLabels) are required.

        The Inputs must use the array parameter option so that the input
        degrees of freedom (DOFs) are known.

        For non-conservative systems where the outputs are not equal to the
        inputs:

        The labels for the outputs (OutputLabels) are required.

        The file formats with references (FileFormat = 3 and 4) do not apply.

        Velocity and acceleration results are not included in the state-space
        matrices calculation (VelAccKey = OFF)

        File format with common reference (FileFormat = 3) does not apply if
        the inputs are based on DOFs of a different nature.  All input DOFs
        must be either all rotational or all translational and not a mix of the
        two.

        A graphics file (Jobname_SPM.PNG) is generated. It contains an element
        plot of the model.

        For more details about the reduction method and the generation of the
        state-space matrices, see Reduced-Order Modeling for State-Space
        Matrices Export in the Mechanical APDL Theory Reference.

        For examples of the command usage, see State-Space Matrices Export.
        """
        command = "SPMWRITE,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(method), str(nmode), str(inputs), str(inputlabels), str(outputs), str(outputlabels), str(nic), str(velacckey), str(fileformat))
        return self.run(command, **kwargs)

    def plgeom(self, item="", nodekey="", **kwargs):
        """APDL Command: PLGEOM

        Plots target and source geometries.

        Parameters
        ----------
        item
            Items to plot:

            BOTH - Plot both target and source geometries (default).

            TARGET - Plot only the target geometry.

            SOURCE - Plot only the source geometry.

        nodekey
            If the source data contains faces (that is, surface elements were
            created upon the READ command), set NODEkey = 1 to plot only the
            source nodes rather than both the nodes and the elements.

        Notes
        -----
        Target faces are displayed in gray and source points in yellow. If the
        source data contains faces (that is, surface elements were created upon
        the READ command), the source faces are also displayed in blue (unless
        NODEkey = 1), and both surfaces are made translucent.
        """
        command = "PLGEOM,%s,%s" % (str(item), str(nodekey))
        return self.run(command, **kwargs)

    def adele(self, na1="", na2="", ninc="", kswp="", **kwargs):
        """APDL Command: ADELE

        Deletes unmeshed areas.

        Parameters
        ----------
        na1, na2, ninc
            Delete areas from NA1 to NA2 (defaults to NA1) in steps of NINC
            (defaults to 1).  If NA1 = ALL, NA2 and NINC are ignored and all
            selected areas [ASEL] are deleted.  If NA1 = P, graphical picking
            is enabled and all remaining arguments are ignored (valid only in
            the GUI).  A component name may also be substituted for NA1 (NA2
            and NINC are ignored).

        kswp
            Specifies whether keypoints and lines are also to be deleted:

            0 - Delete areas only (default).

            1 - Delete areas, as well as keypoints and lines attached to specified areas but
                not shared by other areas.

        Notes
        -----
        An area attached to a volume cannot be deleted unless the volume is
        first deleted.
        """
        command = "ADELE,%s,%s,%s,%s" % (str(na1), str(na2), str(ninc), str(kswp))
        return self.run(command, **kwargs)

    def lsymbol(self, x="", y="", symang="", symtyp="", symsiz="", keybmp="",
                **kwargs):
        """APDL Command: /LSYMBOL

        Creates annotation symbols (GUI).

        Parameters
        ----------
        x
            X location for symbol (-1.0 < X < 2.0).

        y
            Y location for symbol (-1.0 < Y < 1.0).

        symang
            Symbol orientation angle.

        symtyp
            Symbol type:

            1 - Arrow.

            2 - Tee.

            3 - Circle.

            4 - Triangle.

            5 - Star.

        symsiz
            Symbol size multiplier (0.1 to 20.0).  Defaults to 1.0.

        keybmp
            If KEYBMP = 1, the annotation is a bitmap. SYMTYP will then be a
            number from 1-99, indicating the bitmap type (see notes), and X and
            Y will define the lower left corner of the bitmap. The SYMANG,
            SYMSIZarguments are ignored. If KEYBMP = 0, or blank, then the
            argument definitions above apply.

        Notes
        -----
        Defines annotation symbols to be written directly onto the display at a
        specified location.  This is a command generated by the GUI and will
        appear in the log file (Jobname.LOG) if annotation is used.  This
        command is not intended to be typed in directly in an ANSYS session
        (although it can be included in an input file for batch input or for
        use with the /INPUT command).

        All symbols are shown on subsequent displays unless the annotation is
        turned off or deleted.  Use the /LSPEC command to set the attributes of
        the symbol.

        The KEYBMP argument reads the symtype argument to determine which
        bitmap to insert. This bitmap is defined by an integer between 1 and
        99. Numbers 1 through 40 correspond to the standard texture values
        found in the /TXTRE  command, while numbers 51 through 99 correspond to
        user supplied bitmaps, as defined using the Filename option of the
        /TXTRE command. Numbers 51 through 57 are predefined (the logos, clamps
        and arrows available from the GUI) but can be overridden. Numbers 41
        through 50 are reserved.

        This command is valid in any processor.
        """
        command = "/LSYMBOL,%s,%s,%s,%s,%s,%s" % (str(x), str(y), str(symang), str(symtyp), str(symsiz), str(keybmp))
        return self.run(command, **kwargs)

    def bsax(self, val1="", val2="", t="", **kwargs):
        """APDL Command: BSAX

        Specifies the axial strain and axial force relationship for beam
        sections.

        Parameters
        ----------
        val1
            Axial strain component (ε).

        val2
            Axial force component (N).

        t
            Temperature.

        Notes
        -----
        The behavior of beam elements is governed by the generalized-
        stress/generalized-strain relationship of the form:

        The BSAX command, one of several nonlinear general beam section
        commands, specifies the relationship of axial strain and axial force
        for a beam section. The section data defined is associated with the
        section most recently defined (via the SECTYPE command).

        Unspecified values default to zero.

        Related commands are BSM1, BSM2, BSTQ, BSS1, BSS2, BSMD, and BSTE.

        For complete information, see Using Nonlinear General Beam Sections.
        """
        command = "BSAX,%s,%s,%s" % (str(val1), str(val2), str(t))
        return self.run(command, **kwargs)

    # def plot(self, nstrt="", nend="", ninc="", **kwargs):
    #     """APDL Command: PLOT

    #     Forms a display.

    #     Parameters
    #     ----------
    #     nstrt, nend, ninc
    #         Display plots sequentially from number NSTRT to NEND in steps of
    #         NINC. NSTRT defaults to the next plot.  NEND defaults to NSTRT.
    #         NINC defaults to 1.  If NSTRT = ALL, display all plots from the
    #         beginning of the file.  If NEND = ALL, display to the end of the
    #         file.

    #     Notes
    #     -----
    #     Output will be to the terminal or to a file, depending on the driver
    #     [/SHOWDISP].  The INTERLEAF and DUMP drivers produce an output file for
    #     each plot named INTLnn and DUMPnn, with nn sequentially ranging from 00
    #     to 99.  A blank line after the PLOT command causes the next plot to be
    #     formed.
    #     """
    #     command = "PLOT,%s,%s,%s" % (str(nstrt), str(nend), str(ninc))
    #     return self.run(command, **kwargs)

    def bfa(self, area="", lab="", val1="", val2="", val3="", val4="",
            **kwargs):
        """APDL Command: BFA

        Defines a body force load on an area.

        Parameters
        ----------
        area
            Area to which body load applies.  If ALL, apply to all selected
            areas [ASEL]. A component name may also be substituted for Area.

        lab
            Valid body load label. Load labels are listed under "Body Loads" in
            the input table for each element type in the Element Reference.

        val1, val2, val3
            Value associated with the Lab item or a table name for specifying
            tabular boundary conditions. Use only VAL1 for TEMP, FLUE, HGEN,
            CHRGD. For Lab = JS in magnetics, use VAL1, VAL2, and VAL3 for the
            X, Y, and Z components. For acoustics, if Lab = JS, use VAL1 for
            mass source in a harmonic analysis or mass source rate in a
            transient analysis, and ignore VAL2 and VAL3. For Lab = VLTG, VAL1
            is the voltage drop and VAL2 is the phase angle. If Lab = IMPD,
            VAL1 is the resistance and VAL2 is the reactance in ohms/square.
            When specifying a table name, you must enclose the table name in
            percent signs (%), e.g., BFA,Area,Lab,%tabname%. Use the *DIM
            command to define a table.

        val4
            If Lab = JS, VAL4 is the phase angle in degrees.

        Notes
        -----
        Defines a body force load (such as temperature in a structural
        analysis, heat generation rate in a thermal analysis, etc.) on an area.
        Body loads may be transferred from areas to area elements (or to nodes
        if area elements do not exist) with the BFTRAN or SBCTRAN commands.
        Body loads default to the value specified on the BFUNIF command, if it
        was previously specified.

        You can specify a table name only when using temperature (TEMP) and
        heat generation rate (HGEN) body load labels.

        Body loads specified by the BFA command can conflict with other
        specified body loads.  See Resolution of Conflicting Body Load
        Specifications in the Basic Analysis Guide for details.

        Graphical picking is available only via the listed menu paths.

        This command is also valid in PREP7.
        """
        command = "BFA,%s,%s,%s,%s,%s,%s" % (str(area), str(lab), str(val1), str(val2), str(val3), str(val4))
        return self.run(command, **kwargs)

    def lczero(self, **kwargs):
        """APDL Command: LCZERO

        Zeroes the results portion of the database.

        Notes
        -----
        Often used before the LCOPER command.  Same as LCOPER,ZERO.
        """
        command = "LCZERO," % ()
        return self.run(command, **kwargs)

    def lumpm(self, key="", **kwargs):
        """APDL Command: LUMPM

        Specifies a lumped mass matrix formulation.

        Parameters
        ----------
        key
            Formulation key:

            OFF - Use the element-dependent default mass matrix formulation (default).

            ON - Use a lumped mass approximation.

        Notes
        -----
        This command is also valid in PREP7.  If used in SOLUTION, this command
        is valid only within the first load step.
        """
        command = "LUMPM,%s" % (str(key))
        return self.run(command, **kwargs)

    def aremesh(self, lcomb="", angle="", **kwargs):
        """APDL Command: AREMESH

        Generates an area in which to create a new mesh for rezoning.

        Parameters
        ----------
        lcomb
            Specifies how to combine adjacent line segments:

             0 - Line segments combined by connecting ends to ends. This value is the default.

            -1 - No line segments combined.

        angle
            The maximum angle (in degrees) allowed for connecting two line
            segments together. The default value is 30. This value is valid
            only when LCOMB = 0.

        Notes
        -----
        Issue the AREMESH command after issuing a REMESH,START command and
        before issuing a REMESH,FINISH command.

        The AREMESH command cannot account for an open area (or “hole”) inside
        a completely enclosed region. Instead, try meshing around an open area
        by selecting two adjoining regions; for more information, see Hints for
        Remeshing Multiple Regions .
        """
        command = "AREMESH,%s,%s" % (str(lcomb), str(angle))
        return self.run(command, **kwargs)

    def pretab(self, lab1="", lab2="", lab3="", lab4="", lab5="", lab6="",
               lab7="", lab8="", lab9="", **kwargs):
        """APDL Command: PRETAB

        Prints the element table items.

        Parameters
        ----------
        lab1, lab2, lab3, . . . , lab9
            Print selected items.  Valid labels are (blank) or any label as
            specified with the ETABLE command.  Convenience labels may be used
            for Lab1 to select groups of labels (10 labels maximum):  GRP1 for
            first 10 stored items; GRP2 for items 11 to 20; GRP3 for items 21
            to 30; GRP4 for items 31 to 40; GRP5 for items 41 to 50.  Enter
            ETABLE,STAT command to list stored item order.  If all labels are
            blank, print first 10 stored items (GRP1).

        Notes
        -----
        Prints the items stored in the table defined with the ETABLE command.
        Item values will be listed for the selected elements in the sorted
        sequence [ESORT].  The FORCE command can be used to define which
        component of the nodal load is to be used (static,  damping, inertia,
        or total).

        Portions of this command are not supported by PowerGraphics
        [/GRAPHICS,POWER].
        """
        command = "PRETAB,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(lab1), str(lab2), str(lab3), str(lab4), str(lab5), str(lab6), str(lab7), str(lab8), str(lab9))
        return self.run(command, **kwargs)

    def cecyc(self, lowname="", highname="", nsector="", hindex="",
              tolerance="", kmove="", kpairs="", **kwargs):
        """APDL Command: CECYC

        Generates the constraint equations for a cyclic symmetry analysis

        Parameters
        ----------
        lowname
            Name of a component for the nodes on the low angle edge of the
            sector.  Enclosed in single quotes.

        highname
            Name of a component for the nodes on the high angle edge of the
            sector.  Enclosed in single quotes.

        nsector
            Number of sectors in the complete 360 degrees.

        hindex
            Harmonic index to be represented by this set of constraint
            equations.  If Hindex is -1, generate constraint equations for
            static cyclic symmetry.  If HIndex is -2, generate constraint
            equations for static cyclic asymmetry.

        tolerance
            A positive tolerance is an absolute tolerance (length units), and a
            negative tolerance is a tolerance relative to the local element
            size.

        kmove
            0

            0 - Nodes are not moved.

            1 - HIGHNAME component nodes are moved to match LOWNAME component nodes exactly.

        kpairs
            0

            0 - Do not print paired nodes

            1 - Print table of paired nodes

        Notes
        -----
        The analysis can be either modal cyclic symmetry or static cyclic
        symmetry.

        The pair of nodes for which constraint equations are written are
        rotated into CSYS,1.
        """
        command = "CECYC,%s,%s,%s,%s,%s,%s,%s" % (str(lowname), str(highname), str(nsector), str(hindex), str(tolerance), str(kmove), str(kpairs))
        return self.run(command, **kwargs)

    def title(self, title="", **kwargs):
        """APDL Command: /TITLE

        Defines a main title.

        Parameters
        ----------
        title
            Input up to 72 alphanumeric characters.  Parameter substitution may
            be forced within the title by enclosing the parameter name or
            parametric expression within percent (%) signs.

        Notes
        -----
        The title is carried through the printout and written on various files.
        The title written to a file is the title defined at that time.  Special
        characters may be used within the title text.  Subtitles may also be
        defined [/STITLE].

        This command is valid in any processor.
        """
        command = "/TITLE,%s" % (str(title))
        return self.run(command, **kwargs)

    def arotat(self, nl1="", nl2="", nl3="", nl4="", nl5="", nl6="", pax1="",
               pax2="", arc="", nseg="", **kwargs):
        """APDL Command: AROTAT

        Generates cylindrical areas by rotating a line pattern about an axis.

        Parameters
        ----------
        nl1, nl2, nl3, . . . , nl6
            List of lines in the pattern to be rotated (6 maximum if using
            keyboard entry of NL1 to NL6).  The lines must lie in the plane of
            the axis of rotation.  If NL1 = P, graphical picking is enabled and
            all remaining arguments are ignored (valid only in the GUI).  If
            NL1 = ALL, all selected lines will define the pattern to be
            rotated.  A component name may also be substituted for NL1.

        pax1, pax2
            Keypoints defining the axis about which the line pattern is to be
            rotated.

        arc
            Arc length (in degrees).  Positive follows right-hand rule about
            PAX1-PAX2 vector.  Defaults to 360°.

        nseg
            Number of areas (8 maximum) around circumference.  Defaults to
            minimum number required for 90° -maximum arcs, i.e., 4 for 360°, 3
            for 270°, etc.

        Notes
        -----
        Generates cylindrical areas (and their corresponding keypoints and
        lines) by rotating a line pattern (and its associated keypoint pattern)
        about an axis.  Keypoint patterns are generated at regular angular
        locations, based on a maximum spacing of 90°.  Line patterns are
        generated at the keypoint patterns.  Arc lines are also generated to
        connect the keypoints circumferentially.  Keypoint, line, and area
        numbers are automatically assigned, beginning with the lowest available
        values [NUMSTR].  Adjacent lines use a common keypoint.  Adjacent areas
        use a common line.
        """
        command = "AROTAT,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(nl1), str(nl2), str(nl3), str(nl4), str(nl5), str(nl6), str(pax1), str(pax2), str(arc), str(nseg))
        return self.run(command, **kwargs)

    def kl(self, nl1="", ratio="", nk1="", **kwargs):
        """APDL Command: KL

        Generates a keypoint at a specified location on an existing line.

        Parameters
        ----------
        nl1
            Number of the line.  If negative, the direction of line (as
            interpreted for RATIO) is reversed.  If NL1 = P, graphical picking
            is enabled and all remaining command fields are ignored (valid only
            in the GUI).

        ratio
            Ratio of line length to locate keypoint.  Must be between 0.0 and
            1.0.  Defaults to 0.5 (divide the line in half).

        nk1
            Number to be assigned to keypoint generated at division location
            (defaults to lowest available keypoint number [NUMSTR]).
        """
        command = "KL,%s,%s,%s" % (str(nl1), str(ratio), str(nk1))
        return self.run(command, **kwargs)

    def gsbdata(self, labz="", valuez="", labx="", valuex="", laby="",
                valuey="", **kwargs):
        """APDL Command: GSBDATA

        Specifies the constraints or applies the load at the ending point for
        generalized plane strain option.

        Parameters
        ----------
        labz
            Constraint or load at the ending point in the fiber Z direction.

            F - Apply a force in the fiber direction (default).

            LFIBER - Define a length change in the fiber direction.

        valuez
            Value for LabZ. The default is zero.

        labx
            Constraint or load on rotation about X.

            MX - Supply a moment to cause the rotation of the ending plane about X (default).

            ROTX - Define a rotation angle (in radians) of the ending plane about X.

        valuex
            Value for LabX. The default is zero.

        laby
            Constraint or load on rotation about Y

            MY - Supply a moment to cause the rotation of the ending plane about Y (default).

            ROTY - Define a rotation angle (in radians) of the ending plane about Y.

        valuey
            Value for LabY. The default is zero.

        Notes
        -----
        All inputs are in the global Cartesian coordinate system. For more
        information about the generalized plane strain feature, see Generalized
        Plane Strain Option of Current-Technology Solid Elements in the Element
        Reference.

        This command is also valid in PREP7.
        """
        command = "GSBDATA,%s,%s,%s,%s,%s,%s" % (str(labz), str(valuez), str(labx), str(valuex), str(laby), str(valuey))
        return self.run(command, **kwargs)

    def etcontrol(self, eltech="", eldegene="", **kwargs):
        """APDL Command: ETCONTROL

        Control the element technologies used in element formulation (for
        applicable elements).

        Parameters
        ----------
        eltech
            Element technology control:

            SUGGESTION - The program offers a suggestion for the best element technology before solving.
                         If necessary, mixed u-P (KEYOPT(6)) is also included
                         and reset. This behavior is the default.

            SET - The program informs you of the best settings and resets any applicable KEYOPT
                  settings automatically. This action overrides any previous
                  manual settings.

            OFF - Deactivates automatic selection of element technology. No suggestions are
                  issued, and no automatic resetting occurs.

        eldegene
            Element degenerated shape control:

            ON - If element shapes are degenerated, the degenerated shape function is employed
                 and enhanced strain, simplified enhanced strain, and B-bar
                 formulations are turned off (default).

            OFF - If element shapes are degenerated, regular shape functions are still used, and
                  the specified element technologies (e.g., enhanced strain,
                  B-bar, uniform reduced integration) are still used.

        Notes
        -----
        The command default is ETCONTROL,SUGGESTION,ON.

        This command is valid for elements SHELL181, PLANE182, PLANE183,
        SOLID185, SOLID186, SOLID187, BEAM188, BEAM189, SHELL208, SHELL209,
        PLANE223, SOLID226, SOLID227, REINF264, SOLID272, SOLID273, SHELL281,
        SOLID285, PIPE288, PIPE289, ELBOW290.

        For more information, see Automatic Selection of Element Technologies
        and Formulations in the Element Reference.
        """
        command = "ETCONTROL,%s,%s" % (str(eltech), str(eldegene))
        return self.run(command, **kwargs)

    def edcurve(self, option="", lcid="", par1="", par2="", **kwargs):
        """APDL Command: EDCURVE

        Specifies data curves for an explicit dynamic analysis.

        Parameters
        ----------
        option
            Label identifying the option to be performed.

            ADD - Define a data curve (default). If Option = ADD, Par1 and Par2 must be
                  previously defined array parameters.

            DELE - Delete the specified data curve (LCID). If LCID is blank, all data curves are
                   deleted. Par1 and Par2 are ignored for this option.

            LIST - List defined data curve (LCID). If LCID is blank, all data curves are listed.
                   Par1 and Par2 are ignored for this option.

            PLOT - Plot defined data curve (LCID). If Option = PLOT, LCID must be previously
                   defined with an EDCURVE command. Otherwise a warning message
                   will report that LCID has not been defined. Par1 and Par2
                   are ignored for this option.

        lcid
            Data curve ID number (no default). Must be a positive integer.

        par1
            Name of user-defined array parameter that contains the abscissa
            values of the curve data (e.g., time, effective plastic strain,
            effective strain rate, displacement, etc.).

        par2
            Name of user-defined array parameter that contains the ordinate
            values of the curve data (e.g., damping coefficients, initial yield
            stress, elastic modulus, force, etc.) corresponding to the abscissa
            values in Par1.

        Notes
        -----
        EDCURVE can be used to define material data curves (e.g., stress-
        strain) and load data curves (force-deflection) associated with
        material models in an explicit dynamics analysis. Material data
        specified by this command is typically required to define a particular
        material behavior (e.g., TB,HONEY), and the LCID number is used as
        input on the TBDATA command.

        EDCURVE can also be used to define load curves that represent time
        dependent loads (force, displacement, velocity, etc.). Par1 must
        contain the time values, and Par2 must contain the corresponding load
        values. The LCID number assigned to the load curve can be used as input
        on the EDLOAD command.

        Note:: : You cannot update a previously defined data curve by changing
        the array parameters that were input as Par1 and Par2. The data curve
        definition is written to the database at the time EDCURVE is issued.
        Therefore, subsequent changes to the array parameters that were used as
        input on EDCURVE will not affect the load curve definition. If you need
        to change the load curve definition, you must delete the load curve
        (EDCURVE,DELE,LCID) and define it again.

        LCID identifies the data curve. If the value input for LCID is the same
        as the ID number for a data curve previously defined by EDCURVE, the
        previous data will be overwritten. Use EDCURVE,LIST and EDCURVE,PLOT to
        check existing data curves.

        A starting array element number must be specified for Par1 and Par2.
        The input for these fields must be a single column array parameter, or
        a specific column from a multi-column array parameter. When using the
        GUI with multi-column parameters, you must specify the parameter name
        and starting position for Par1 and Par2 by typing the EDCURVE command
        in the Input Window. This is because only the parameter name is
        available through the dialog box, which pulls in the first position of
        a single-column array parameter.

        If you need to change a curve definition in an explicit dynamic small
        restart analysis, issue EDSTART,2 first (to specify the restart), then
        issue the EDCURVE command. The revised curve must contain the same
        number of points as the curve it replaces. This limitation does not
        apply to a full restart analysis (EDSTART,3).

        This command is also valid in SOLUTION.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDCURVE,%s,%s,%s,%s" % (str(option), str(lcid), str(par1), str(par2))
        return self.run(command, **kwargs)

    def cplist(self, nset1="", nset2="", ninc="", nsel="", **kwargs):
        """APDL Command: CPLIST

        Lists the coupled degree of freedom sets.

        Parameters
        ----------
        nset1, nset2, ninc
            List coupled sets from NSET1 to NSET2 (defaults to NSET1) in steps
            of NINC (defaults to 1).  If NSET1 = ALL (default), NSET2 and NINC
            are ignored and all coupled sets are listed.

        nsel
            Node selection control:

            ANY - List coupled set if any of the selected nodes are in the set (default).

            ALL - List coupled set only if all of the selected nodes are in the set.

        Notes
        -----
        This command is valid in any processor.
        """
        command = "CPLIST,%s,%s,%s,%s" % (str(nset1), str(nset2), str(ninc), str(nsel))
        return self.run(command, **kwargs)

    def emsym(self, nsect="", **kwargs):
        """APDL Command: EMSYM

        Specifies circular symmetry for electromagnetic sources.

        Parameters
        ----------
        nsect
            The number of circular symmetry sections (defaults to 1).

        Notes
        -----
        Specifies the number of times to repeat electromagnetic sources for
        circular symmetry. Applies to SOURC36 elements and to coupled-field
        elements with electric current conduction results in the database.
        Sources are assumed to be equally spaced over 360° about the global
        Cartesian Z axis.

        This command is also valid in SOLUTION.
        """
        command = "EMSYM,%s" % (str(nsect))
        return self.run(command, **kwargs)

    def tbdele(self, lab="", mat1="", mat2="", inc="", **kwargs):
        """APDL Command: TBDELE

        Deletes previously defined material data tables.

        Parameters
        ----------
        lab
            Data table label. (See the TB command for valid labels.)  If ALL,
            delete all data tables.

        mat1, mat2, inc
            Delete tables for materials MAT1 to (MAT2 defaults to MAT1) in
            steps of INC (defaults to 1).  If MAT1= ALL, ignore MAT2 and INC
            and delete data tables for all materials.

        Notes
        -----
        This command is also valid in SOLUTION.
        """
        command = "TBDELE,%s,%s,%s,%s" % (str(lab), str(mat1), str(mat2), str(inc))
        return self.run(command, **kwargs)

    def kesize(self, npt="", size="", fact1="", fact2="", **kwargs):
        """APDL Command: KESIZE

        Specifies the edge lengths of the elements nearest a keypoint.

        Parameters
        ----------
        npt
            Number of the keypoint whose lines will be adjusted.  If ALL, use
            all selected keypoints [KSEL].  If NPT = P, graphical picking is
            enabled and all remaining command fields are ignored (valid only in
            the GUI).

        size
            Size of elements along lines nearest keypoint NPT (overrides any
            other specified size).  If SIZE is zero (or blank), use FACT1 or
            FACT2.

        fact1
            Scale factor applied to a previously defined SIZE.  Not used if
            SIZE is input.

        fact2
            Scale factor applied to the minimum element division at keypoint
            NPT for any attached line.  This feature is useful with adaptive
            mesh refinement.  Not used if SIZE or FACT1 is input.

        Notes
        -----
        Affects only the line divisions adjacent to the keypoint on lines not
        previously assigned divisions by other line commands [LESIZE, etc.].
        The remaining line divisions are determined from the division nearest
        the keypoint at the other end of the line (specified by another KESIZE
        command or the ESIZE command).  Divisions are transferred to the lines
        during the mesh operation.  If smart element sizing is being used
        [SMRTSIZE], KESIZE specifications may be overridden (i.e., a smaller
        element size may be used) to accommodate curvature and small features.

        This command is valid in any processor. The command is also valid for
        rezoning.
        """
        command = "KESIZE,%s,%s,%s,%s" % (str(npt), str(size), str(fact1), str(fact2))
        return self.run(command, **kwargs)

    def pddmcs(self, nsim="", _astop="", accmean="", accstdev="", check="",
               seed="", **kwargs):
        """APDL Command: PDDMCS

        Specifies options for Monte Carlo Simulations using direct sampling.

        Parameters
        ----------
        nsim
            Number of simulation loops of the analysis.

        --
            Unused field.

        astop
            Autostop option label.

            AUTO - Enable Autostop. When Autostop is used, the PDS feature continues the
                   simulation loops until the convergence criteria for the mean
                   value and the standard deviation have been met or until the
                   number of simulations NSIM are complete, whichever comes
                   first. The convergence criteria (mean value and standard
                   deviations of all random output parameters) are specified by
                   the ACCMEAN and ACCSTDEV parameters. The criteria are met if
                   the mean value and the standard deviations converge within
                   the accuracy specified in the ACCMEAN and ACCSTDEV options.
                   The convergence check is done every i-th loop, where i is
                   specified in the CHECK parameter.

            ALL - Disable Autostop option. All Monte Carlo Simulations as specified by NSIM are
                  performed (default).

        accmean
            Accuracy of the mean values of all random output parameters that
            must be met for the Autostop option. Default is 0.01 (1%). ACCMEAN
            is ignored for Astop = ALL. The convergence of the mean values is
            met if for all random output parameters y the equation holds:

        accstdev
            Accuracy of the standard deviations of all random output parameters
            that must be met for the Autostop option. The default is 0.02 (2%).
            ACCSTDEV is ignored for Astop = ALL. The convergence for the
            standard deviations is met if for all random output parameters y
            the equation holds:

        check
            Sets how often conditions for convergence are checked for Autostop.
            The PDS checks if the convergence criteria are met every i-th loop,
            where i is given by the CHECK parameter. The default value is 10.
            It is not recommended to use CHECK = 1, because it could cause
            Autostop to terminate the simulations prematurely. The mean values
            and standard deviation might not show large differences between
            consecutive simulation loops but might still have a visible
            "global" trend if viewed over several simulations. This behavior
            indicates that convergence has not really been achieved. If you set
            CHECK = 1 (or another small number), then Autostop is not able to
            detect such a global trend. CHECK is ignored for Astop = ALL.

        seed
            Seed value label. Random number generators require a seed value
            that is used to calculate the next random number. After each random
            number generation finishes, the seed value is updated and is used
            again to calculate the next random number. ANSYS initializes the
            seed value with the system time when the ANSYS session started.

            CONT - Continues updating using the derived seed value (default).

            TIME - Initializes the seed value with the system time. You can use this if you want
                   the seed value set to a specific value for one analysis and
                   then you want to continue with a "random" seed in the next
                   analysis. It is not recommended to "randomize" the seed
                   value with the Seed = TIME option for multiple analyses. If
                   the Monte Carlo simulations requested with this command will
                   be appended to previously existing simulations, then the
                   Seed option is ignored and Seed = CONT is used.

            INIT - Initializes the seed value using 123457 (a typical recommendation). This option
                   leads to identical random numbers for all random input
                   variables when the exact analysis will be repeated, making
                   it useful for benchmarking and validation purposes (where
                   identical random numbers are desired). If the Monte Carlo
                   simulations requested with this command will be appended to
                   previously existing simulations, then the Seed option is
                   ignored and Seed = CONT is used.

            Value - Uses the specified (positive) value for the initialization of the seed value.
                    This option has the same effect as Seed = INIT, except you
                    can chose an arbitrary (positive) number for the
                    initialization. If the Monte Carlo simulations requested
                    with this command will be appended to previously existing
                    simulations, then the Seed option is ignored and Seed =
                    CONT is used.

        Notes
        -----
        Defines the number of simulations, the specification of the Autostop
        option, how frequently the Autostop option is checked and the seed
        value for random number generation. If the Autostop option is enabled,
        then the number of simulations given for NSIM can be regarded as the
        maximum number of simulations to be performed. The Autostop option may
        terminate the simulations before NSIM simulations are done if the
        convergence criteria are met.
        """
        command = "PDDMCS,%s,%s,%s,%s,%s,%s" % (str(nsim), str(_astop), str(accmean), str(accstdev), str(check), str(seed))
        return self.run(command, **kwargs)

    def ascres(self, opt="", **kwargs):
        """APDL Command: ASCRES

        Specifies the output type for an acoustic scattering analysis.

        Parameters
        ----------
        opt
            Output option:

            TOTAL - Output the total pressure field (default).

            SCAT - Output the scattered pressure field.

        Notes
        -----
        Use the ASCRES command to specify the output type for an acoustic
        scattering analysis.

        The scattered option (Opt = SCAT) provides a scattered pressure output,
        psc, required for calculating target strength (TS).

        The default behavior (Opt = TOTAL) provides a sum of the incident and
        scattering fields, ptotal = pinc + psc.

        Issue the AWAVE command to define the incident pressure pinc. If the
        AWAVE command is defined with Opt2 = INT, only the total pressure field
        is output regardless of the ASCRES,Opt command.
        """
        command = "ASCRES,%s" % (str(opt))
        return self.run(command, **kwargs)

    def nldpost(self, label="", key="", fileid="", prefix="", **kwargs):
        """APDL Command: NLDPOST

        Gets element component information from nonlinear diagnostic files.

        Parameters
        ----------
        label
            Specifies the type of command operation:

            EFLG - Element flag for nonlinear diagnostics.

            NRRE - Newton-Raphson residuals.

        key
            Specifies the command action:

            STAT - List information about the diagnostic files (Jobname.ndxxx or Jobname.nrxxx) in
                   the current directory.

            For Label = EFLG, the listing gives a summary that associates the loadstep, substep, time, equilibrium iteration number, cumulative iteration number, and the number of elements that fail each criteria with a specific file ID (Jobname.ndxxx). Use the list to create element components (via the CM option) based on the cumulative iteration number. - For Label = NRRE, the listing provides a summary that associates the loadstep,
                              substep, time, equilibrium iteration number, and
                              cumulative iteration number with a specific file
                              ID (Jobname.nrxxx).  Use the list to identify the
                              respective file ID for creating Newton-Raphson
                              residual contour plots (PLNSOL,NRRE,…,FileID).

            DEL - Delete Jobname.ndxxx or Jobname.nrxxx files in the working directory, if any
                  exist.

            CM - Create components for elements that violate criteria. This value is valid only
                 when Label = EFLG.

        fileid
            Valid only when Label = EFLG and Key = CM, this value specifies
            file IDs:

            IDnum - The file ID number. Creates the element components from the diagnostic files
                    corresponding to the specified file ID number in the
                    working directory.

            ALL - Creates element components from all available diagnostic files residing in the
                  working directory. This value is the default if you do not
                  specify an IDnum value.

        prefix
            Sets the prefix name for components. Specify up to 21 alphanumeric
            characters.

        Notes
        -----
        Based on the nonlinear diagnostic results (created via the NLDIAG,EFLG
        command), the NLDPOST command creates element components with
        predefined names.

        The following table lists the diagnostic criteria and component names
        (with specified prefix and without). Here xxx corresponds to the file
        ID (FileID) of Jobname.ndxxx or Jobname.nrxxx.

        If you have trouble viewing specific element components, see Viewing
        Hidden Element Components in the Basic Analysis Guide.

        For more information, see Performing Nonlinear Diagnostics.
        """
        command = "NLDPOST,%s,%s,%s,%s" % (str(label), str(key), str(fileid), str(prefix))
        return self.run(command, **kwargs)

    def mfcmmand(self, fnumb="", fname="", ext="", **kwargs):
        """APDL Command: MFCMMAND

        Captures field solution options in a command file.

        Parameters
        ----------
        fnumb
            Field number specified by the MFELEM command.

        fname
            Command file name specified for the field number. Defaults to field
            "FNUMB".

        ext
            Extension for Fname. Defaults to .cmd.

        Notes
        -----
        All relevant solution option commands for the specified field are
        written to a file with the extension .cmd. Refer to the commands in the
        following tables in the Command Reference: Analysis Options, Nonlinear
        Options, Dynamic Options, and Load Step Options.

        This command is also valid in PREP7.

        See Multi-field Commands in the Coupled-Field Analysis Guide for a list
        of all ANSYS Multi-field solver commands and their availability for MFS
        and MFX analyses.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "MFCMMAND,%s,%s,%s" % (str(fnumb), str(fname), str(ext))
        return self.run(command, **kwargs)

    def psdwav(self, tblno="", vx="", vy="", vz="", **kwargs):
        """APDL Command: PSDWAV

        Defines a wave propagation excitation in a PSD analysis.

        Parameters
        ----------
        tblno
            Input PSD table number defined with PSDVAL command.

        vx
            Global Cartesian X-velocity of traveling wave.

        vy
            Global Cartesian Y-velocity of traveling wave.

        vz
            Global Cartesian Z-velocity of traveling wave.

        Notes
        -----
        Defines a traveling wave in a PSD analysis. This command is not
        available for a pressure PSD analysis.

        This command is also valid in PREP7.
        """
        command = "PSDWAV,%s,%s,%s,%s" % (str(tblno), str(vx), str(vy), str(vz))
        return self.run(command, **kwargs)

    def rstmac(self, file1="", lstep1="", sbstep1="", file2="", lstep2="",
               sbstep2="", tolern="", maclim="", cname="", keyprint="",
               unvscale="", keym_ass="", **kwargs):
        """APDL Command: RSTMAC

        Calculates modal assurance criterion (MAC) and matches nodal solutions
        from two results files or from one results file and one universal
        format file.

        Parameters
        ----------
        file1
            File name (32 characters maximum) corresponding to the first
            results file (.rst or .rstp file). If the file name does not
            contain the extension, it defaults to .rst.

        lstep1
            Load step number of the results to be read in File1.

            N  - Reads load step N. Defaults to 1.

        sbstep1
            Substep number of the results to be read in File1.

            N  - Reads substep N.

            All  - Reads all substeps. This value is the default.

        file2
            File name (32 characters maximum) corresponding to the second file
            (.rst, .rstp, or .unv file). If the file name does not contain the
            extension, it defaults to .rst.

        lstep2
            Load step number of the results to be read in File2.

            N  - Reads load step N. Defaults to 1.

        sbstep2
            Substep number of the results to be read in File2.

            N  - Reads substep N.

            All  - Reads all substeps. This value is the default.

        tolern
            Tolerance for nodes matching. If TolerN = -1, the nodes on File2
            are mapped into the selected elements of File1. If TolerN is
            positive, the selected nodes of File1 are matched to the nodes of
            File2. The default value is 0.01.

        maclim
            Smallest acceptable MAC value. Must be  0 and  1. The default value
            is 0.90.

        cname
            Name of the component from the first file (File1). The component
            must be based on nodes. If unspecified, all nodes are matched and
            used for MAC calculations. If a component name is specified, only
            nodes included in the specified component are used. Not applicable
            to node mapping (TolerN=-1).

        keyprint
            Printout options:

            0  - Printout matched solutions table. This value is the default.

            1  - Printout matched solutions table and full MAC table.

            2  - Printout matched solutions table, full MAC table and matched nodes table.

        unvscale
            Scaling of the nodal coordinates when File2 is a universal format
            file (.unv).

            Blank or 0  - No scaling (default).

            Non-zero value  - Scaling factor applied to the nodal coordinates.

        keymass
            Key to include the mass matrix diagonal in the calculations.

            ON  - Include the mass matrix diagonal. This is the default.

            OFF  - Do not include the mass matrix diagonal.

        Notes
        -----
        The RSTMAC command allows the comparison of the solutions from either:

        Two different results files

        One result file and one universal format file

        The modal assurance criterion (MAC) is used.

        The meshes read on File1 and File2 may be different. If TolerN>0, the
        nodes are matched. This is the default. If TolerN = -1, the nodes are
        mapped and the solutions are interpolated from File1.

        Units and coordinate systems must be the same for both models. When a
        universal format file is used, the nodal coordinates can be scaled
        using UNVscale.

        The corresponding database file (.db) for File1 must be resumed before
        running the command only if a component (Cname) is used or if the nodes
        are mapped (TolerN = -1).

        Results may be real or complex; however, if results from File1 have a
        different type from results in File2, only the real parts of the
        solutions are taken into account in MAC calculations. The analysis type
        can be arbitrary.

        Only structural degrees of freedom are considered. Degrees of freedom
        can vary between File1 and File2, but at least one common degree of
        freedom must exist.

        When node mapping and solution interpolation is performed (TolerN=-1),
        File1 must correspond to a model meshed in solid and/or shell elements.
        Other types of elements can be present but the node mapping is not
        performed for those elements. Interpolation is performed on UX, UY, and
        UZ degrees of freedom.

        The solutions read on the results files are not all written to the
        database, therefore, subsequent plotting or printing of solutions is
        not possible.  A SET command must be issued after the RSTMAC command to
        post-process each solution.

        RSTMAC comparison on cyclic symmetry analysis works only if the number
        of sectors on File1 and File2 are the same. Also comparison cannot be
        made between cyclic symmetry results and full 360 degree model results
        (File1 – cyclic solution, File2 – full 360 degree model solution).
        Comparing cyclic symmetry solutions written on selected set of node
        (OUTRES) is not supported.

        The modal assurance criterion values can be retrieved as parameters
        using the *GET command (Entity = RSTMAC).

        For more information and an example, see Comparing Nodal Solutions From
        Two Models (RSTMAC) in the Basic Analysis Guide.
        """
        command = "RSTMAC,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(file1), str(lstep1), str(sbstep1), str(file2), str(lstep2), str(sbstep2), str(tolern), str(maclim), str(cname), str(keyprint), str(unvscale), str(keym_ass))
        return self.run(command, **kwargs)

    def ksum(self, **kwargs):
        """APDL Command: KSUM

        Calculates and prints geometry statistics of the selected keypoints.

        Notes
        -----
        Calculates and prints geometry statistics (centroid location, moments
        of inertia, etc.) associated with the selected keypoints.  Geometry
        items are reported in the global Cartesian coordinate system.  A unit
        density is assumed, irrespective of any material associations [KATT,
        MAT].  Items calculated by KSUM and later retrieved by a *GET or *VGET
        command are valid only if the model is not modified after the KSUM
        command is issued.
        """
        command = "KSUM," % ()
        return self.run(command, **kwargs)

    def ndsurf(self, snode="", telem="", dimn="", **kwargs):
        """APDL Command: NDSURF

        Generates surface elements overlaid on the edge of existing elements
        and assigns the extra node as the closest fluid element node.

        Parameters
        ----------
        snode
            Component name for the surface nodes of the solid elements.

        telem
            Component name for the target fluid elements.

        dimn
            Model dimensionality:

            2 - 2-D model.

            3 - 3-D model.

        Notes
        -----
        This command macro is used to generate surface effect elements (SURF151
        or SURF152) overlaid on the surface of existing plane or solid elements
        and, based on proximity, to determine and assign the extra node
        (FLUID116) for each surface element. The active element type must be
        SURF151 or SURF152 with appropriate settings for KEYOPT(4), KEYOPT(5),
        KEYOPT(6), and KEYOPT(8).

        The surface nodes of the plane or solid elements must be grouped into a
        node component and the fluid elements must be grouped into an element
        component and named using the CM command.  The names must be enclosed
        in single quotes (e.g., 'NOD') when the NDSURF command is manually
        typed in.

        When using the GUI method, node and element components are created
        through the picking dialog boxes associated with this command.

        The macro is applicable for the SURF151, SURF152, and FLUID116 element
        types.
        """
        command = "NDSURF,%s,%s,%s" % (str(snode), str(telem), str(dimn))
        return self.run(command, **kwargs)

    def ddele(self, node="", lab="", nend="", ninc="", rkey="", **kwargs):
        """APDL Command: DDELE

        Deletes degree-of-freedom constraints.

        Parameters
        ----------
        node
            Node for which constraint is to be deleted.  If ALL, NEND and NINC
            are ignored and constraints for all selected nodes [NSEL] are
            deleted.  If NODE = P, graphical picking is enabled and all
            remaining command fields are ignored (valid only in the GUI).  A
            component name may also be substituted for NODE.

        lab
            Valid degree of freedom label.  If ALL, use all selected labels
            [DOFSEL].  Structural labels:  UX, UY, or UZ (displacements); ROTX,
            ROTY, or ROTZ (rotations); WARP (warping).  Thermal labels: TEMP,
            TBOT, TE2, TE3, . . ., TTOP (temperature).  Acoustic labels:  PRES
            (pressure); UX, UY, or UZ (displacements for FSI coupled elements).
            Electric label:  VOLT (voltage).  Magnetic labels:  MAG (scalar
            magnetic potential); AX, AY, or AZ (vector magnetic potentials).
            Diffusion label: CONC (concentration).

        nend, ninc
            Delete constraints from NODE to NEND (defaults to NODE) in steps of
            NINC (defaults to 1).

        rkey
            Ramping key:

            OFF  - Loads are step-removed (default).

            ON or FORCE  - Forces on the specified degrees of freedom (Lab) are ramped during the next
                           load step. The forces are ramped from the reaction
                           forces of the previous load step, regardless of
                           whether or not a constraint was present. If the
                           specified node(s) and degree(s) of freedom has a
                           force value currently defined, the force is ramped
                           from the reaction force value to the currently
                           applied force value. If no force is currently
                           applied, the force is ramped from the reaction force
                           value to zero.

        Notes
        -----
        Deleting a constraint is not the same as setting it to zero (which
        "fixes" the degree of freedom to a zero value).  Deleting a constraint
        has the same effect as deactivating, releasing, or setting the
        constraint "free."  The node and the degree of freedom label must be
        selected [NSEL, DOFSEL].

        This command is also valid in PREP7.
        """
        command = "DDELE,%s,%s,%s,%s,%s" % (str(node), str(lab), str(nend), str(ninc), str(rkey))
        return self.run(command, **kwargs)

    def nolist(self, **kwargs):
        """APDL Command: /NOLIST

        Suppresses the data input listing.

        Notes
        -----
        Printout is suppressed until a /GOLIST command is read or the end of
        the listing is encountered.

        This command is valid in any processor, but only within a batch run
        [/BATCH].
        """
        command = "/NOLIST," % ()
        return self.run(command, **kwargs)

    def thexpand(self, key="", **kwargs):
        """APDL Command: THEXPAND

        Enables or disables thermal loading

        Parameters
        ----------
        key
            Activation key:

            ON  - Thermal loading is included in the load vector (default).

            OFF - Thermal loading is not included in the load vector.

        Notes
        -----
        Temperatures applied in the analysis are used by default to evaluate
        material properties and contribute to the load vector if the
        temperature does not equal the reference temperature and a coefficient
        of thermal expansion is specified.

        Use THEXPAND,OFF to evaluate the material properties but not contribute
        to the load vector. This capability is particularly useful when
        performing a harmonic analysis where you do not want to include
        harmonically varying thermal loads. It is also useful in a modal
        analysis when computing a modal load vector but excluding the thermal
        load.

        This command is valid for all analysis types except linear perturbation
        modal and linear perturbation harmonic analyses. For these two linear
        perturbation analysis types, the program internally sets THEXPAND,OFF,
        and it cannot be set to ON by using this command (THEXPAND,ON is
        ignored).
        """
        command = "THEXPAND,%s" % (str(key))
        return self.run(command, **kwargs)

    def plf2d(self, ncont="", olay="", anum="", win="", **kwargs):
        """APDL Command: PLF2D

        Generates a contour line plot of equipotentials.

        Parameters
        ----------
        ncont
            Number of contour lines to display.  Issue in multiples of 9 (i.e.,
            9, 18, 27, etc.).  Default is 27 contour lines.

        olay
            Overlay:

            0 - Overlay edge outlines by material number.

            1 - Overlay edge outlines by real constant number.

        anum
            Highest material or real constant attribute number.  Command will
            cycle through ANUM element display overlays.  Defaults to 10.

        win
            Window number to which command applies.  Defaults to 1.

        Notes
        -----
        PLF2D invokes an ANSYS macro which plots equipotentials of the degree
        of freedom AZ.  These equipotential lines are parallel to flux lines
        and thus give a good representation of flux patterns.  In the
        axisymmetric case, the display is actually r*AZ where "r" is the node
        radius.  The macro overlays (OLAY) edge outlines by material number or
        real constant number (ANUM) and allows user control over the number of
        contour lines to display (NCONT).

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "PLF2D,%s,%s,%s,%s" % (str(ncont), str(olay), str(anum), str(win))
        return self.run(command, **kwargs)

    def nsle(self, type="", nodetype="", num="", **kwargs):
        """APDL Command: NSLE

        Selects those nodes attached to the selected elements.

        Parameters
        ----------
        type
            Label identifying the type of node select:

            S - Select a new set (default).

            R - Reselect a set from the current set.

            A - Additionally select a set and extend the current set.

            U - Unselect a set from the current set.

        nodetype
            Label identifying type of nodes to consider when selecting:

            ALL - Select all nodes of the selected elements (default).

            ACTIVE - Select only the active nodes. An active node is a node that contributes DOFs to
                     the model.

            INACTIVE - Select only inactive  nodes (such as orientation or radiation).

            CORNER - Select only corner nodes.

            MID - Select only midside nodes.

            POS - Select nodes in position Num.

            FACE - Select nodes on face Num.

        num
            Position or face number for NodeType = POS or FACE.

        Notes
        -----
        NSLE selects NodeType nodes attached to the currently-selected set of
        elements. Only nodes on elements in the currently-selected element set
        can be selected.

        Note:: : When using degenerate hexahedral elements, NSLE, U,CORNER and
        NSLE,S,MID will not select the same set of nodes because some nodes
        appear as both corner and midside nodes.

        This command is valid in any processor.
        """
        command = "NSLE,%s,%s,%s" % (str(type), str(nodetype), str(num))
        return self.run(command, **kwargs)

    def dflab(self, dof="", displab="", forcelab="", **kwargs):
        """APDL Command: /DFLAB

        Changes degree-of-freedom labels for user custom elements.

        Parameters
        ----------
        dof
            Number between 1 and 32 indicating which degree of freedom is to
            have its labels changed. For a list of these quantities, see the
            degree-of-freedom table in the echprm.inc file. The first few
            quantities follow:

        displab
            New label (four-character maximum) for the displacement label. The
            prior label is no longer valid.

        forcelab
            New label (four-character maximum) for the force label for this
            degree of freedom. The prior label is no longer valid.

        Notes
        -----
        The /DFLAB command is rarely used. Use it if you are writing a custom
        element and want to use degrees of freedom that are not part of the
        standard element set.
        """
        command = "/DFLAB,%s,%s,%s" % (str(dof), str(displab), str(forcelab))
        return self.run(command, **kwargs)

    def sspa(self, a11="", a21="", a31="", a22="", a32="", a33="", t="",
             **kwargs):
        """APDL Command: SSPA

        Specifies a preintegrated membrane stiffness for shell sections.

        Parameters
        ----------
        a11, a21, a31, a22, a32, a33
            Membrane stiffness component (symmetric lower part of submatrix
            [A]).

        t
            Temperature.

        Notes
        -----
        The behavior of shell elements is governed by the generalized-
        stress/generalized-strain relationship of the form:

        The SSPA command, one of several preintegrated shell section commands,
        specifies the membrane stiffness quantity (submatrix [A]) for a
        preintegrated shell section. The section data defined is associated
        with the section most recently defined (via the SECTYPE command).

        Unspecified values default to zero.

        Related commands are SSPB, SSPD, SSPE, SSMT, SSBT, and SSPM.

        For complete information, see Using Preintegrated General Shell
        Sections.
        """
        command = "SSPA,%s,%s,%s,%s,%s,%s,%s" % (str(a11), str(a21), str(a31), str(a22), str(a32), str(a33), str(t))
        return self.run(command, **kwargs)

    def mshape(self, key="", dimension="", **kwargs):
        """APDL Command: MSHAPE

        For elements that support multiple shapes, specifies the element shape
        to be used for meshing.

        Parameters
        ----------
        key
            Key indicating the element shape to be used:

            0 - Mesh with quadrilateral-shaped elements when Dimension = 2-D mesh with
                hexahedral-shaped elements when Dimension = 3-D.

            1 - Mesh with triangle-shaped elements when Dimension = 2-D mesh with tetrahedral-
                shaped elements when Dimension = 3-D.

        dimension
            Specifies the dimension of the model to be meshed:

            2D - 2-D model (area mesh).

            3D - 3-D model (volume mesh).

        Notes
        -----
        If no value is specified for Dimension the value of KEY determines the
        element shape that will be used for both 2-D and 3-D meshing.  In other
        words, if you specify MSHAPE,0, quadrilateral-shaped and hexahedral-
        shaped elements will be used.  If you specify MSHAPE,1, triangle-shaped
        and tetrahedral-shaped elements will be used.

        The MSHAPE, MSHKEY, and MSHMID commands replace the functionality that
        was provided by the ESHAPE command in ANSYS 5.3 and earlier releases.

        This command is also valid for rezoning.
        """
        command = "MSHAPE,%s,%s" % (str(key), str(dimension))
        return self.run(command, **kwargs)

    def emagerr(self, **kwargs):
        """APDL Command: EMAGERR

        Calculates the relative error in an electrostatic or electromagnetic
        field analysis.

        Notes
        -----
        The relative error is an approximation of the mesh discretization error
        associated with a solution. It is based on the discrepancy between the
        unaveraged, element-nodal field values and the averaged, nodal field
        values. The calculation is valid within a material boundary and does
        not consider the error in continuity of fields across dissimilar
        materials.

        For electrostatics, the field values evaluated are the electric field
        strength (EFSUM) and the electric flux density (DSUM). A relative error
        norm of each is calculated on a per-element basis and stored in the
        element table [ETABLE] with the labels EF_ERR and D_ERR. Normalized
        error values EFN_ERR and DN_ERR are also calculated and stored in the
        element table. Corresponding quantities for electromagnetics are H_ERR,
        B_ERR, HN_ERR, and BN_ERR, which are calculated from the magnetic field
        intensity (HSUM) and the magnetic flux density (BSUM).  The normalized
        error value is the relative error norm value divided by the peak
        element-nodal field value for the currently selected elements.

        Use the PLETAB and PRETAB commands to plot and list the error norms and
        normalized error values.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EMAGERR," % ()
        return self.run(command, **kwargs)

    def iclist(self, node1="", node2="", ninc="", lab="", **kwargs):
        """APDL Command: ICLIST

        Lists the initial conditions.

        Parameters
        ----------
        node1, node2, ninc
            List initial conditions for nodes NODE1 to NODE2 (defaults to
            NODE1) in steps of NINC (defaults to 1).  If NODE1 = ALL (default),
            NODE2 and NINC are ignored and initial conditions for all selected
            nodes [NSEL] are listed.  If NODE1 = P, graphical picking is
            enabled and all remaining command fields are ignored (valid only in
            the GUI).  A component name may be substituted for NODE1 (NODE2 and
            NINC are ignored).

        lab
            Velocity key:

            DISP - Specification is for first order degree of freedom value (displacements,
                   temperature, etc.) (default).

            VELO - Specification is for second order degree of freedom value (velocities).

        Notes
        -----
        Lists the initial conditions specified by the IC command.  Listing
        applies to all the selected nodes [NSEL] and DOF labels.  ICLIST is not
        the same as the DLIST command.  All the initial conditions including
        the default conditions are listed for the selected nodes.

        This command is valid in any processor.
        """
        command = "ICLIST,%s,%s,%s,%s" % (str(node1), str(node2), str(ninc), str(lab))
        return self.run(command, **kwargs)

    def plesol(self, item="", comp="", kund="", fact="", **kwargs):
        """APDL Command: PLESOL

        Displays the solution results as discontinuous element contours.

        Parameters
        ----------
        item
            Label identifying the item.  Valid item labels are shown in
            Table 219: PLESOL - Valid Item and Component Labels for Element
            Results below.  Some items also require a component label.

        comp
            Component of the item (if required).  Valid component labels are
            shown in Table 219: PLESOL - Valid Item and Component Labels for
            Element Results below.

        kund
            Undisplaced shape key:

            0 - Do not overlay undeformed structure display

            1 - Overlay displaced contour plot with undeformed display (appearance is system-
                dependent)

            2 - Overlay displaced contour plot  with undeformed edge display (appearance is
                system-dependent)

        fact
            Scale factor for 2-D display of contact items (defaults to 1). A
            negative scaling factor may be used to invert the display.

        Notes
        -----
        Displays the solution results as element contours discontinuous across
        element boundaries for the selected elements.  For example, PLESOL,S,X
        displays the X component of stress S (that is, the SX stress
        component).  Various element results depend on the calculation method
        and the selected results location (AVPRIN, RSYS, and ESEL).  Contours
        are determined by linear interpolation within each element, unaffected
        by the surrounding elements (i.e., no nodal averaging is performed).
        The discontinuity between contours of adjacent elements is an
        indication of the gradient across elements.  Component results are
        displayed in the active results coordinate system [RSYS] (default is
        the global Cartesian).  See the ETABLE and PLETAB commands for
        displaying items not available through this command (such as line
        element results).

        For PowerGraphics displays [/GRAPHICS,POWER], results are plotted only
        for the model exterior surface.  The items marked with [1] in Table:
        219:: PLESOL - Valid Item and Component Labels for Element Results are
        not supported by PowerGraphics.

        Table: 219:: : PLESOL - Valid Item and Component Labels for Element
        Results
        """
        command = "PLESOL,%s,%s,%s,%s" % (str(item), str(comp), str(kund), str(fact))
        return self.run(command, **kwargs)

    def fesurf(self, **kwargs):
        """APDL Command: FESURF

        Specifies "Surface loads on elements" as the subsequent status topic.

        Notes
        -----
        This is a status [STAT] topic command.  Status topic commands are
        generated by the GUI and will appear in the log file (Jobname.LOG) if
        status is requested for some items under Utility Menu> List> Status.
        This command will be immediately followed by a STAT command, which will
        report the status for the specified topic.

        If entered directly into the program, the STAT command should
        immediately follow this command.
        """
        command = "FESURF," % ()
        return self.run(command, **kwargs)

    def btol(self, ptol="", **kwargs):
        """APDL Command: BTOL

        Specifies the Boolean operation tolerances.

        Parameters
        ----------
        ptol
            Point coincidence tolerance.  Points within this distance to each
            other will be assumed to be coincident during Boolean operations.
            Loosening the tolerance will increase the run time and storage
            requirements, but will allow more Boolean intersections to succeed.
            Defaults to 0.10E-4.

        Notes
        -----
        Use BTOL,DEFA to reset the setting to its default value.  Use BTOL,STAT
        to list the status of the present setting.
        """
        command = "BTOL,%s" % (str(ptol))
        return self.run(command, **kwargs)

    def pri2(self, p51x="", z1="", z2="", **kwargs):
        """APDL Command: PRI2

        Creates a polygonal area or a prism volume by vertices (GUI).

        Notes
        -----
        Creates a polygonal area or a prism volume using the vertices as input.
        This is a command generated by the Graphical User Interface (GUI) and
        will appear in the log file (Jobname.LOG) if graphical picking is used.
        This command is not intended to be typed in directly in an ANSYS
        session (although it can be included in an input file for batch input
        or for use with the /INPUT command).

        For polygons, the PRI2 command will appear in the log file as
        PRI2,P51X,0.0,0.0 preceded by FITEM commands that define the vertices
        (in global Cartesian coordinates).  For prisms, the PRI2 command will
        appear in the log file as PRI2,P51X preceded by FITEM commands that
        define the vertices and the Z-end of the prism.

        See the RPOLY, POLY, RPRISM, PRISM, and RPR4 commands for other ways to
        create polygons and prisms.
        """
        command = "PRI2,%s,%s,%s" % (str(p51x), str(z1), str(z2))
        return self.run(command, **kwargs)

    def vsba(self, nv="", na="", sepo="", keepv="", keepa="", **kwargs):
        """APDL Command: VSBA

        Subtracts areas from volumes.

        Parameters
        ----------
        nv
            Volume (or volumes, if picking is used) to be subtracted from.  If
            ALL, use all selected volumes.  If P, graphical picking is enabled
            (valid only in the GUI) and remaining fields are ignored.  A
            component name may also be substituted for NV.

        na
            Area (or areas, if picking is used) to subtract.  If ALL, use all
            selected areas.  A component name may also be substituted for NA.

        sepo
            Behavior of the touching boundary:

            (blank) - The resulting volumes will share area(s) where they touch.

            SEPO - The resulting volumes will have separate, but coincident area(s) where they
                   touch.

        keepv
            Specifies whether NV volumes are to be deleted:

            (blank) - Use the setting of KEEP on the BOPTN command.

            DELETE - Delete NV volumes after VSBA operation (override BOPTN command settings).

            KEEP - Keep NV volumes after VSBA operation (override BOPTN command settings).

        keepa
            Specifies whether NA areas are to be deleted:

            (blank) - Use the setting of KEEP on the BOPTN command.

            DELETE - Delete NA areas after VSBA operation (override BOPTN command settings).

            KEEP - Keep NA areas after VSBA operation (override BOPTN command settings).

        Notes
        -----
        Generates new volumes by subtracting the regions common to both the
        volumes and areas (the intersection) from the NV volumes.  The
        intersection will be an area(s).  If SEPO is blank, the volume is
        divided at the area and the resulting volumes will be connected,
        sharing a common area where they touch.  If SEPO is set to SEPO, the
        volume is divided into two unconnected volumes with separate areas
        where they touch.  See the Modeling and Meshing Guide for an
        illustration.  See the BOPTN command for an explanation of the options
        available to Boolean operations.  Element attributes and solid model
        boundary conditions assigned to the original entities will not be
        transferred to the new entities generated.
        """
        command = "VSBA,%s,%s,%s,%s,%s" % (str(nv), str(na), str(sepo), str(keepv), str(keepa))
        return self.run(command, **kwargs)

    def vplot(self, nv1="", nv2="", ninc="", degen="", scale="", **kwargs):
        """APDL Command: VPLOT

        Displays the selected volumes.

        Parameters
        ----------
        nv1, nv2, ninc
            Display volumes from NV1 to NV2 (defaults to NV1) in steps of NINC
            (defaults to 1).  If NV1 = ALL (default), NV2 and NINC are ignored
            and all selected volumes [VSEL] are displayed.

        degen
            Degeneracy marker:

            (blank) - No degeneracy marker is used (default).

            DEGE - A red star is placed on keypoints at degeneracies (see the Modeling and Meshing
                   Guide).  Not available if /FACET,WIRE is set.

        scale
            Scale factor for the size of the degeneracy-marker star.  The scale
            is the size in window space (-1 to 1 in both directions) (defaults
            to .075).

        Notes
        -----
        Displays selected volumes.  (Only volumes having areas within the
        selected area set [ASEL] will be plotted.)  With PowerGraphics on
        [/GRAPHICS,POWER], VPLOT will display only the currently selected
        areas. This command is also a utility command, valid anywhere.  The
        degree of tessellation used to plot the volumes is set through the
        /FACET command.
        """
        command = "VPLOT,%s,%s,%s,%s,%s" % (str(nv1), str(nv2), str(ninc), str(degen), str(scale))
        return self.run(command, **kwargs)

    def rmdir(self, dir="", **kwargs):
        """APDL Command: /RMDIR

        Removes (deletes) a directory.

        Parameters
        ----------
        dir
            The directory to remove. If no path is provided, it will be assumed
            to be in the current working directory. All files in the directory
            are also removed.

        Notes
        -----
        Removes a directory on the computer ANSYS is currently running on. No
        warning or prompt is given, so use with extreme caution.
        """
        command = "/RMDIR,%s" % (str(dir))
        return self.run(command, **kwargs)

    def jpeg(self, kywrd="", opt="", **kwargs):
        """APDL Command: JPEG

        Provides JPEG file export for ANSYS displays.

        Parameters
        ----------
        kywrd
            Specifies various JPEG file export options.

            QUAL - If Kywrd = QUAL, then OPT is an integer value defining the JPEG quality index
                   on an arbitrary scale ranging from 1 to 100. The default
                   value is 75.

            ORIENT - If Kywrd = ORIENT, then OPT will determine the orientation of the entire plot.
                     OPT can be either Horizontal (default) or Vertical.

            COLOR - If Kywrd = COLOR, then OPT will determine the color depth of the saved file.
                    OPT can be 0, 1, or 2, corresponding to Black and White,
                    Grayscale, and Color (default), respectively.

            TMOD - If Kywrd = TMOD, then OPT will determine the text method. OPT can be either 1
                   or 0, corresponding to bitmap text (default) or line stroke
                   text, respectively.

            DEFAULT - If Kywrd = DEFAULT, then all of the default values, for all of the Kywrd
                      parameters listed above, are active.

        opt
            OPT can have the following names or values, depending on the value
            for Kywrd (see above).

            1 to 100 - If Kywrd = QUAL, a value between 1 and 100 will determine the quality index of
                       the JPEG file.

            Horizontal, Vertical - If Kywrd = ORIENT, the terms Horizontal or Vertical determine the orientation
                              of the plot.

            0,1,2 - If Kywrd = COLOR, the numbers 0, 1, and 2 correspond to Black and White,
                    Grayscale and Color, respectively.

            1,0 - If Kywrd = TMOD, the values 1 and 0 determine whether bitmap (1) or stroke text
                  (0) fonts will be used
        """
        command = "JPEG,%s,%s" % (str(kywrd), str(opt))
        return self.run(command, **kwargs)

    def laylist(self, iel="", layr1="", layr2="", mplab1="", mplab2="",
                **kwargs):
        """APDL Command: LAYLIST

        Lists real constants material properties for layered elements.

        Parameters
        ----------
        iel
            Element number to be listed.  If ALL, list all selected elements
            [ESEL] of the appropriate type.  If blank and the current element
            type is a layered element type, list data from the current real
            constant table in the layered format.

        layr1, layr2
            Range of layer numbers to be listed.  If LAYR1 is greater than
            LAYR2, a reverse order list is produced.  LAYR1 defaults to 1.
            LAYR2 defaults to LAYR1 if LAYR1 is input or to the number of
            layers if LAYR1 is not input.

        mplab1, mplab2
            Material property labels (e.g., EX) to be listed along with the
            layer real constants.

        Notes
        -----
        Lists real constants and any two material properties for layered shell
        and solid elements.

        If matrix input is selected (KEYOPT(2) = 2 or 3), LAYR1, LAYR2, Mplab1,
        and Mplab2 are not used.

        This command is valid in any processor.
        """
        command = "LAYLIST,%s,%s,%s,%s,%s" % (str(iel), str(layr1), str(layr2), str(mplab1), str(mplab2))
        return self.run(command, **kwargs)

    def gp(self, node1="", node2="", lab="", stif="", gap="", damp="",
           **kwargs):
        """APDL Command: GP

        Defines a gap condition for transient analyses.

        Parameters
        ----------
        node1
            Node I of gap.  If NODE1 = P, graphical picking is enabled and all
            remaining command fields are ignored (valid only in the GUI).

        node2
            Node J of gap (must be different from NODE1).  Non-grounded gap
            nodes must be defined as master degrees of freedom or be
            unconstrained, active DOF in a full analysis type.  Grounded gap
            nodes (those not defined as MDOF) need not appear elsewhere in the
            model.

        lab
            Direction of gap action in the nodal coordinate system (implied
            from the following force labels): FX, FY, FZ, MX, MY, MZ.

        stif
            Stiffness (Force/Length) of closed gap (may be positive or
            negative).

        gap
            Initial size of gap.  A zero (or positive) value assumes an
            initially open gap.  A negative value defines an interference
            condition.  For a rotational gap, GAP should be in radians.

        damp
            Damping coefficient (Force*Time/Length) of closed gap using pseudo
            velocity (Newmark finite difference expansion scheme).

        Notes
        -----
        Defines a gap condition for the mode superposition transient analysis
        (ANTYPE,TRANS with TRNOPT,MSUP). If used in SOLUTION, this command is
        valid only within the first load step. Gap conditions specified in
        subsequent load steps are ignored.

        Repeat GP command for additional gap conditions. Gaps are numbered
        sequentially as input.

        Note:: : Gaps may be renumbered by the program during the solution (see
        output listing)

        The mode-superposition transient analysis does not allow gap action
        with the standard gap elements. However, you can define gap conditions
        which are similar to gap elements; gap conditions can be specified
        between surfaces that are expected to contact (impact) each other
        during the transient. The gap condition simulates the basic gap action
        of the COMBIN40 element.

        The gap condition is treated as an explicit force (equal to the
        interference times contact stiffness) and affects only the load vector
        calculation and not the stiffness matrix. The interference is
        calculated from the displacement extrapolated from the previous time
        points.

        Gap conditions can only be defined between two master degree of freedom
        (DOF) nodes or between master DOF nodes and ground, as shown in the
        following figure.

        Master degrees of freedom are the unconstrained and active degrees of
        freedom. Gap nodes not defined as active degrees of freedom or attached
        to an element are assumed to be grounded. Grounded gap nodes do not
        need a spatial location, nor do they need to be located on an element.

        Gap conditions may be defined in parallel (across the same nodes), with
        varying gap and stiffness values, to simulate a nonlinear (piecewise)
        force-deflection curve.

        The gap direction is determined from the force label input on the GP
        command; i.e., FX defines a translational gap acting in the UX nodal
        degree of freedom direction, and MZ defines a rotational gap acting in
        the nodal ROTZ degree of freedom direction. The actual degree of
        freedom directions available for a particular node depends upon the
        degrees of freedom associated with the element types [ET] at that node.

        If the coordinate systems of the nodes connecting the gap are rotated
        relative to each other, the same degree of freedom may be in different
        directions. The gap, however, assumes only a one-dimensional action.
        Nodes I and J may be anywhere in space (preferably coincident).  No
        moment effects are included due to noncoincident nodes. That is, if the
        nodes are offset from the line of action, moment equilibrium may not be
        satisfied.

        The contact stiffness value represents the stiffness of the closed gap.
        Stiffness values are related to the integration time step size and
        should be physically reasonable. High stiffness will require a small
        integration time step; otherwise, due to the displacement
        extrapolation, the solution may go unstable. Negative stiffness values
        may be used with gaps in parallel to produce a decreasing force-
        deflection curve.

        The order of specifying the gap nodes is important; i.e., a gap
        condition connecting two nodes will act differently depending upon
        which node is specified first on the GP command.  For example, for Node
        1 at X = 0.0, Node 2 at X = 0.1, and the gap defined from Node 1 to 2,
        a displacement of Node 1 greater than Node 2 will cause the gap to
        close.  For the gap defined from Node 2 to 1, a displacement of Node 2
        greater than Node 1 will cause the gap to close (like a hook action).
        In general, the gap closes whenever the separation (defined as UJ - UI
        + GAP) is negative.  UJ is the displacement of node J, UI is the
        displacement of node I, and GAP is the input gap value.  The gap force
        output appears in the printout only for the time steps for which the
        gap is closed.  A negative spring force is always associated with a
        closed gap (even with the hook option).

        Some guidelines to define gap conditions are presented below:

        Use enough gap conditions to obtain a smooth contact stress
        distribution between the contacting surfaces.

        Define a reasonable gap stiffness. If the stiffness is too low, the
        contacting surfaces may overlap too much. If the stiffness is too high,
        a very small time step will be required during impact. A general
        recommendation is to specify a gap stiffness that is one or two orders
        of magnitude higher than the adjacent element stiffness. You can
        estimate the adjacent element stiffness using AE/L, where A is the
        contributing area around the gap condition, E is the elastic modulus of
        the softer material at the interface, and L is the depth of the first
        layer of elements at the interface.

        A mode-superposition transient using the nonlinear gap damping provided
        through the DAMP field runs faster than a full transient analysis using
        a gap element (COMBIN40).

        Use the GPLIST command to list gap conditions and the GPDELE command to
        delete gap conditions.

        This command is also valid in PREP7.
        """
        command = "GP,%s,%s,%s,%s,%s,%s" % (str(node1), str(node2), str(lab), str(stif), str(gap), str(damp))
        return self.run(command, **kwargs)

    def adapt(self, nsoln="", stargt="", ttargt="", facmn="", facmx="",
              kykps="", kymac="", **kwargs):
        """APDL Command: ADAPT

        Adaptively meshes and solves a model.

        Parameters
        ----------
        nsoln
            Number of solutions allowed (1 or more) (defaults to 5).

        stargt
            Target percentage for structural percent error in energy norm
            (SEPC) (defaults to 5).  If -1, no target value is used.

        ttargt
            Target percentage for thermal percent error in energy norm (TEPC)
            (defaults to 1).  If -1, no target value is used.

        facmn
            Minimum factor for the keypoint element size changes (defaults to
            0.25).

        facmx
            Maximum factor for the keypoint element size changes (defaults to
            2.0).

        kykps
            Specifies whether element size is to be modified at selected
            keypoints:

            0 - Modify element size regardless of selected keypoint set (default).

            1 - Modify element size only at selected keypoints.

        kymac
            Specifies which user-written auxiliary macro files are to be used:

            0 - Ignore user-written auxiliary macro files, if any (default).

            1 - Use user-written auxiliary macro files (if they exist) as follows:  Use
                ADAPTMSH.MAC instead of the default meshing command sequence.
                Use ADAPTSOL.MAC instead of the default solution command
                sequence (/SOLU ... SOLVE ... FINISH).

        Notes
        -----
        ADAPT invokes a predefined ANSYS macro for adaptive meshing and
        solution.  The macro causes repeated runs of the PREP7, SOLUTION, and
        POST1 phases of the ANSYS program with mesh density refinements based
        upon the percentage error in energy norm.  See the Advanced Analysis
        Guide for additional details.   After the adaptive meshing process is
        complete, the ADAPT macro automatically turns element shape checking on
        (SHPP,ON).

        A copy of the macro, called UADAPT.MAC, is available on the ANSYS
        distribution medium (system dependent), and may be copied and modified
        by the user to suit a particular need.  The modified file should be
        given a suitable name (cmd.MAC) and run as described above with the
        ADAPT command name replaced by your "cmd" name.

        This command is also valid at the Begin level.
        """
        command = "ADAPT,%s,%s,%s,%s,%s,%s,%s" % (str(nsoln), str(stargt), str(ttargt), str(facmn), str(facmx), str(kykps), str(kymac))
        return self.run(command, **kwargs)

    def lgwrite(self, fname="", ext="", kedit="", **kwargs):
        """APDL Command: LGWRITE

        Writes the database command log to a file.

        Parameters
        ----------
        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        kedit
            Flag to suppress nonessential commands:

            NONE - Do not suppress any commands (default).

            COMMENT - Write nonessential commands as comments (starting with !).

            REMOVE - Do not write nonessential commands or comments.

        Notes
        -----
        Writes the database command log to a named file.  The database command
        log contains all commands that were used to create the current
        database.  These commands are recorded in the database as they are
        issued, and saved in the database file (File.DB) whenever the database
        is saved.  The LGWRITE command extracts these commands from the
        database and writes them to a file.  Nonessential commands (for
        listing, graphics displays, help, etc.) can be excluded from the file
        by using the Kedit field.  The file resulting from LGWRITE can be used
        as command input to the program.  This command is most useful if the
        session log file (File.LOG), which is normally saved during an
        interactive session, has been lost or corrupted.

        This command is valid in any processor.
        """
        command = "LGWRITE,%s,%s,%s" % (str(fname), str(ext), str(kedit))
        return self.run(command, **kwargs)

    def ainv(self, na="", nv="", **kwargs):
        """APDL Command: AINV

        Finds the intersection of an area with a volume.

        Parameters
        ----------
        na
            Number of area to be intersected.  If P, graphical picking is
            enabled and all remaining arguments are ignored (valid only in the
            GUI).

        nv
            Number of volume to be intersected.

        Notes
        -----
        New areas will be generated where the areas intersect the volumes.  If
        the regions of intersection are only lines, new lines will be generated
        instead.  See the Modeling and Meshing Guide for an illustration.  See
        the BOPTN command for the options available to Boolean operations.
        Element attributes and solid model boundary conditions assigned to the
        original entities will not be transferred to the new entities
        generated.
        """
        command = "AINV,%s,%s" % (str(na), str(nv))
        return self.run(command, **kwargs)

    def lsum(self, **kwargs):
        """APDL Command: LSUM

        Calculates and prints geometry statistics of the selected lines.

        Notes
        -----
        Calculates and prints geometry statistics (length, centroid, moments of
        inertia, etc.) associated with the selected lines.  Geometry items are
        reported in the global Cartesian coordinate system.  A unit density is
        assumed, irrespective of any material associations [LATT, MAT].  Items
        calculated by LSUM and later retrieved by a *GET or *VGET command are
        valid only if the model is not modified after the LSUM command is
        issued.
        """
        command = "LSUM," % ()
        return self.run(command, **kwargs)

    def eextrude(self, action="", nelem="", space="", dist="", theta="",
                 tfact="", **kwargs):
        """APDL Command: EEXTRUDE

        Extrudes 2-D plane elements into 3-D solids.

        Parameters
        ----------
        action
            Specifies one of the following command behaviors:

            AUTO - Extrudes plane elements (PLANE182 and PLANE183) based on the KEYOPT(3) setting.
                   Complementary elements are also extruded. (See Notes for
                   more information.) This behavior is the default.

            PLANE - Extrudes elements in the global Z direction. KEYOPT(3) of the parent elements
                    is ignored.

            AXIS - Extrudes elements about the global Y axis. KEYOPT(3) of the parent elements is
                   ignored.

            TANGENT - Similar to Action = AXIS, except that target elements are extruded in the
                      global Z direction.

        nelem
            Number of elements to generate in the extruded direction. If you do
            not specify a number, the program calculates a number automatically
            based on the average element size and extrusion distance.

        space
            Spacing ratio. If positive, this value is the nominal ratio of the
            last division size to the first division size (if > 1.0, sizes
            increase, if < 1.0, sizes decrease). If negative, |SPACE| is the
            nominal ratio of the center division size to the end division size.
            The default value is 1.0 (uniform spacing).

        dist
            Distance to extrude in the global Z direction for the plane strain
            case (Action = PLANE). The default is 1.

        theta
            Ending angle (in degrees) to extrude about the global Y axis for
            the axisymmetric case (Action = AXIS). The beginning angle is
            always 0 degrees. The ending angle defaults to 360 degrees.

        tfact
            Factor for increasing the rigid target size. The size of the
            extruded rigid target elements is determined automatically based on
            the size of the contact elements. The default value is 0.2.

        Notes
        -----
        The EEXTRUDE command extrudes current-technology elements PLANE182 and
        PLANE183. Complementary elements TARGE169, CONTA171, CONTA172, and
        REINF263 will also extrude. Extrusion operates automatically on
        elements in the selected element set.

        For automatic PLANE182 and PLANE183 extrusion (Action = AUTO), based on
        the element behavior of the plane elements, the command performs as
        follows:

        Plane stress; the element is ignored.

        Axisymmetric; the element is extruded 360 degrees about the Y-axis.
        THETA is ignored.

        Plane strain (Z strain = 0.0); the element is extruded a unit distance
        in the global Z direction.

        Plane stress with thickness input; the element is extruded in the
        Z-direction as specified by the thickness input via a real constant.

        Generalized plane strain; the element is ignored.

        For an axisymmetric extrusion (Action = AUTO with KEYOPT(3) = 1, Action
        = AXIS, or Action = TANGENT), the command merges any nodes within the
        specified tolerance (SELTOL,TOLER) of the axis into a single node, then
        forms degenerate tetrahedrons, pyramids, or wedges. The default
        tolerance value is 1.0E-6.

        When issuing the EEXTRUDE command within the MAP2DTO3D environment
        using KEYOPT(3) = 3, mapping results do not provide the correct 3-D
        results state; therefore, KEYOPT(3) = 3 is suggested only as a tool for
        extruding the mesh itself as a geometric feature.

        For an axisymmetric extrusion, SHELL208 and SHELL209 will extrude.

        You can control shape-checking options via the SHPP command.

        The extrusion behavior of accompanying contact (CONTA171 and CONTA172)
        is determined by the plane element settings. Rigid target (TARGE169)
        elements are extruded in the global Z direction unless axisymmetric
        extrusion (Action = AXIS) is in effect.

        The following table shows each 2-D element capable of extrusion and its
        corresponding post-extrusion 3-D element:

        All element properties are also transferred consistently during
        extrusion. For example, a  2-D element is extruded to a  3-D element,
        and a mixed u-P 2-D element is extruded to a mixed u-P 3-D element.
        """
        command = "EEXTRUDE,%s,%s,%s,%s,%s,%s" % (str(action), str(nelem), str(space), str(dist), str(theta), str(tfact))
        return self.run(command, **kwargs)

    def rose(self, signif="", label="", td="", forcetype="", **kwargs):
        """APDL Command: ROSE

        Specifies the Rosenblueth mode combination method.

        Parameters
        ----------
        signif
            Combine only those modes whose significance level exceeds the
            SIGNIF threshold. For single point, multipoint, or DDAM response
            (SPOPT, SPRS, MPRS, or DDAM), the significance level of a mode is
            defined as the mode coefficient of the mode, divided by the maximum
            mode coefficient of all modes. Any mode whose significance level is
            less than SIGNIF is considered insignificant and does not
            contribute to the mode combinations. The higher the SIGNIF
            threshold, the fewer the number of modes combined. SIGNIF defaults
            to 0.001. If SIGNIF is specified as 0.0, it is taken as 0.0.

        label
            Label identifying the combined mode solution output.

            DISP - Displacement solution (default). Displacements, stresses, forces, etc., are
                   available.

            VELO - Velocity solution. Velocities, "stress velocities," "force velocities," etc.,
                   are available.

            ACEL - Acceleration solution. Accelerations, "stress accelerations," "force
                   accelerations," etc. are available.

        td
            Time duration for earthquake or shock spectrum. TD defaults to 10.

        forcetype
            Label identifying the forces to be combined:

            STATIC - Combine the modal static forces (default).

            TOTAL - Combine the modal static plus inertial forces.

        Notes
        -----
        For more information on spectrum analysis combination methods, see
        Combination of Modes

        This command is also valid in PREP7.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "ROSE,%s,%s,%s,%s" % (str(signif), str(label), str(td), str(forcetype))
        return self.run(command, **kwargs)

    def arclen(self, key="", maxarc="", minarc="", **kwargs):
        """APDL Command: ARCLEN

        Activates the arc-length method.

        Parameters
        ----------
        key
            Arc-length key:

            OFF - Do not use the arc-length method (default).

            ON - Use the arc-length method.

        maxarc
            Maximum multiplier of the reference arc-length radius (default =
            25).

        minarc
            Minimum multiplier of the reference arc-length radius (default =
            1/1000).

        Notes
        -----
        Activates the arc-length method and sets the minimum and maximum
        multipliers for controlling the arc-length radius based on the initial
        arc-length radius.

        The initial arc-length radius, t0, is proportional (in absolute value)
        to the initial load factor. The initial load factor is given by:

        Initial Load Factor = TIME / NSBSTP

        where TIME is the time specified by the TIME command for the arc-length
        load step, and NSBSTP is the number of substeps specified by the NSUBST
        command.

        The factors MAXARC and MINARC are used to define the range for the arc-
        length radius to expand and shrink during the substep solution:

        In each substep, the arc-length radius is kept constant throughout the
        equilibrium iterations. After each converged substep, the arc-length
        radius for the next substep is modified depending on the convergence
        behavior. If the substep converges and the program heuristic predicts
        an easy convergence, the arc-length radius is enlarged. If the enlarged
        value is greater than tMAX, the arc-length radius is reset to tMAX. If
        the substep does not converge, bisection will take place until the arc-
        length radius is reduced to tMIN. If further nonconvergence is
        encountered, the solution terminates.

        The arc-length method predicts the next time increment (that is, load
        factor increment). Therefore, the AUTOTS and PRED commands are ignored
        when the arc-length method is used.

        The STABILIZE and LNSRCH commands are also ignored.

        The arc-length method cannot be used in a multiframe restart.

        For difficult problems, one suggestion is to increase the initial
        number of substeps (NSUBST), and to prevent the arc-length radius from
        increasing too rapidly (MAXARC = 1).

        ARCLEN cannot be used for any load step that has no applied load or
        displacement.

        The arc-length method does not support tabular loads. In order to use
        the arc-length method, you must replace tabular loads by other load
        types and then run the analysis again.
        """
        command = "ARCLEN,%s,%s,%s" % (str(key), str(maxarc), str(minarc))
        return self.run(command, **kwargs)

    def cmomega(self, cm_name="", omegax="", omegay="", omegaz="", x1="",
                y1="", z1="", x2="", y2="", z2="", **kwargs):
        """APDL Command: CMOMEGA

        Specifies the rotational velocity of an element component about a user-
        defined rotational axis.

        Parameters
        ----------
        cm_name
            The name of the element component.

        omegax, omegay, omegaz
            If the X2, Y2, Z2 fields are not defined, OMEGAX, OMEGAY, and
            OMEGAZ specify the components of the rotational velocity vector in
            the global Cartesian X, Y, Z directions.

        x1, y1, z1
            If the X2, Y2, Z2 fields are defined,X1, Y1, and Z1 define the
            coordinates of the beginning point of the rotational axis vector.
            Otherwise, X1, Y1, and Z1 are the coordinates of a point through
            which the rotational axis passes.

        x2, y2, z2
            The coordinates of the end point of the rotational axis vector.

        Notes
        -----
        Specifies the rotational velocity components OMEGAX, OMEGAY, and OMEGAZ
        of an element component CM_NAME about a user-defined rotational axis.
        The rotational axis can be defined either as a vector passing through a
        single point or a vector connecting two points.

        You can define rotational velocity and rotational axis for these
        analysis types:

        Static (ANTYPE,STATIC)

        Harmonic (ANTYPE,HARMIC) -- Full or modal superposition

        Transient (ANTYPE,TRANS)  -- Full or modal superposition

        Substructuring (ANTYPE,SUBSTR)

        Modal (ANTYPE,MODAL)

        Rotational velocities are combined with the element mass matrices to
        form a body force load vector term. Units are radians/time. Related
        commands are ACEL, CGLOC, CGLOC,  CGOMGA, CMDOMEGA, DCGOMG, DOMEGA.

        See Analysis Tools in the Mechanical APDL Theory Reference for more
        information.

        You can use the CMOMEGA command in conjunction with either one of the
        following two groups of commands, but not with both groups
        simultaneously:

        Components for which you want to specify rotational loading must
        consist of elements only. The elements you use cannot be part of more
        than one component, and elements that share nodes cannot exist in
        different element components. You cannot apply the loading to an
        assembly of element components.

        If you have applied the Coriolis effect (CORIOLIS) using a stationary
        reference frame, the CMOMEGA command takes the gyroscopic damping
        matrix into account for the elements listed under “Stationary Reference
        Frame” in the notes section of the CORIOLIS command. ANSYS verifies
        that the rotation vector axis is parallel to the axis of the element;
        if not, the gyroscopic effect is not applied. If you issue a CMOMEGA
        command when the Coriolis or gyroscopic effect is present, a
        subsequently issued OMEGA command has no effect.

        The CMOMEGA command supports tabular boundary conditions (%TABNAME_X%,
        %TABNAME_Y%, and %TABNAME_Z%) for CMOMEGA_X, CMOMEGA_Y, and CMOMEGA_Z
        input values (*DIM) for full transient and harmonic analyses.

        In a mode-superposition harmonic or transient analysis, you must apply
        the load in the modal portion of the analysis. Mechanical APDL
        calculates a load vector and writes it to the MODE file, which you can
        apply via the LVSCALE command.
        """
        command = "CMOMEGA,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(cm_name), str(omegax), str(omegay), str(omegaz), str(x1), str(y1), str(z1), str(x2), str(y2), str(z2))
        return self.run(command, **kwargs)

    def time(self, time="", **kwargs):
        """APDL Command: TIME

        Sets the time for a load step.

        Parameters
        ----------
        time
            Time at the end of the load step.

        Notes
        -----
        Associates the boundary conditions at the end of the load step with a
        particular TIME value.

        TIME must be a positive, nonzero, monotonically increasing quantity
        that "tracks" the input history.  Units of time should be consistent
        with those used elsewhere (for properties, creep equations, etc.).

        Typically, for the first load step TIME defaults to 1. However, for the
        first load step of a mode-superposition transient analysis
        (ANTYPE,TRANS and TRNOPT,MSUP), the TIME command is ignored and a
        static solution is performed at TIME = 0.

        For a full transient analyses, the command's default behavior does not
        apply. You must specify a time for each load step and it must be
        greater than the time at the end of the prior load step.

        TIME does not apply to modal (ANTYPE,MODAL), harmonic (ANTYPE,HARMIC),
        or substructure (ANTYPE,SUBSTR) analyses.

        This command is also valid in PREP7.
        """
        command = "TIME,%s" % (str(time))
        return self.run(command, **kwargs)

    def ssln(self, fact="", size="", **kwargs):
        """APDL Command: SSLN

        Selects and displays small lines in the model.

        Parameters
        ----------
        fact
            Factor used to determine small lines.  FACT times the average line
            length in the model is used as the line length limit below which
            lines will be selected.

        size
            Line length limit for line selection.  Lines that have a length
            less than or equal to SIZE will be selected.  Used only if FACT is
            blank.

        Notes
        -----
        SSLN invokes a predefined ANSYS macro for selecting small lines in a
        model.  Lines that are smaller than or equal to the specified limit
        (FACT or SIZE) are selected and line numbers are displayed.  This
        command macro is useful for detecting very small lines in a model that
        may cause problems (i.e., poorly shaped elements or a meshing failure)
        during meshing.  All lines that are not "small" will be unselected and
        can be reselected with the LSEL command.
        """
        command = "SSLN,%s,%s" % (str(fact), str(size))
        return self.run(command, **kwargs)

    def fluread(self, fname="", ext="", kdim="", kout="", limit="", listopt="",
                **kwargs):
        """APDL Command: FLUREAD

        Reads one-way Fluent-to-Mechanical APDL coupling data via a .cgns file
        with one-side fast Fourier transformation complex pressure peak value.

        Parameters
        ----------
        --
            Reserved.

        fname
            File name and directory path of a one-way Fluent-to-Mechanical APDL
            coupling data file (248 characters maximum, including the
            characters needed for the directory path). An unspecified directory
            path defaults to the working directory; in this case, you can use
            all 248 characters for the file name. Defaults to jobname.

        ext
            File name extension of the one-way Fluent-to-Mechanical APDL
            coupling data file. Defaults to .cgns).

        kdim
            Interpolation data for mapping. A value of 0 (default) or 2 applies
            2-D interpolation (where interpolation occurs on a surface).

        kout
            Outside region results for mapping:

            0 - Use the value(s) of the nearest region point for points outside of the region.
                This behavior is the default.

            1 - Set results extrapolated outside of the region to zero.

        limit
            Number of nearby nodes considered for mapping interpolation.
            Minimum = 5. Default = 20.

        listopt
            Type of items picked:

            (blank) - No listing (default).

            SOURCE - List the node coordinates and complex pressure values on the Fluent source side
                     during the solution.

            TARGET - List the node coordinates and complex pressure values on the mapped Mechanical
                     APDL target side during the solution.

            BOTH - List the node coordinates and complex pressure values on both the Fluent source
                   side and the mapped Mechanical APDL target side during the
                   solution.

        Notes
        -----
        The FLUREAD command reads one-way Fluent-to-Mechanical APDL coupling
        data from a .cgns file. The Fluent one-side fast Fourier transformation
        (FFT) peak complex pressure values are mapped to the Mechanical APDL
        structure model during the acoustic-structural solution at each FFT
        frequency.

        The command can be used only for the model with the acoustic elements.

        To apply complex pressure to the structure model, define the SURF154
        surface element, then define the one-way coupling interface (SF,,FSIN)
        on the element.

        You can define the solving frequency range via the HARFRQ command. The
        solver selects the FFT frequencies between the beginning and ending
        frequencies. The number of substeps is determined by the number of FFT
        frequencies over the frequency range. The number of substeps defined
        via the NSUBST command is overwritten.

        For better mapping performance, consider the following:

        Calculations for out-of-bound points require much more processing time
        than do points that are within bounds.

        For each point in the structural destination mesh, the command searches
        all possible triangles in the Fluent source mesh to find the best
        triangle containing each point, then performs a linear interpolation
        inside this triangle. For faster and more accurate results, consider
        your interpolation method and search criteria carefully. (See LIMIT.)

        It is possible to apply one-way coupling excitation to multiple
        frequencies. The one-side FFT peak complex pressure values are
        necessary to do so.
        """
        command = "FLUREAD,%s,%s,%s,%s,%s,%s" % (str(fname), str(ext), str(kdim), str(kout), str(limit), str(listopt))
        return self.run(command, **kwargs)

    def mfmap(self, lab1="", lab2="", filename="", opt="", **kwargs):
        """APDL Command: MFMAP

        Calculates, saves, resumes, or deletes mapping data in an ANSYS Multi-
        field solver analysis.

        Parameters
        ----------
        lab1
            Operation label:

            CALC  - Calculate mapping data and keep it in memory (default).

            SAVE  - Calculate mapping data, keep it in memory, and save it to a file. (If
                    MFMAP,CALC or MFMAP,RESU have been issued, just save it to
                    a file.)

            RESU  - Resume the mapping from a file and keep it in memory.

            DELE  - Free the mapping memory.

        lab2
            Applicable mapping label:

            ALL  - Surface and volumetric mapping.

            SURF  - Surface mapping only.

            VOLU  - Volumetric mapping only.

        filename
            The file name for a mapping data file (filename.sur for surface
            mapping and filename.vol for volumetric mapping). Defaults to
            Jobname. Applies to the commands MFMAP,SAVE and MFMAP,RESU only.

        opt
            File format:

            BINA  - Binary file (default).

            ASCI  - ASCII file.

        Notes
        -----
        This command calculates, saves, resumes, or deletes mapping data. It
        defaults to calculating the mapping data. If MFMAP has not been
        previously issued, the mapping data will be automatically calculated
        during the solution process. On the other hand, the ANSYS Multi-field
        solver will use previously created mapping data. Resumed mapping files
        must have load transfer specifications that are consistent with those
        of the current MFSURFACE and MFVOLUME commands and the ANSYS database.

        This command is also valid in PREP7.

        See Multi-field Commands in the Coupled-Field Analysis Guide for a list
        of all ANSYS Multi-field solver commands and their availability for MFS
        and MFX analyses.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "MFMAP,%s,%s,%s,%s" % (str(lab1), str(lab2), str(filename), str(opt))
        return self.run(command, **kwargs)

    def cpintf(self, lab="", toler="", **kwargs):
        """APDL Command: CPINTF

        Defines coupled degrees of freedom at an interface.

        Parameters
        ----------
        lab
            Degree of freedom label for coupled nodes (in the nodal coordinate
            system). If ALL, use all appropriate labels except HDSP.  Valid
            labels are: Structural labels:  UX, UY, or UZ (displacements);
            ROTX, ROTY, or ROTZ (rotations, in radians), HDSP (hydrostatic
            pressure).  Thermal labels: TEMP, TBOT, TE2, TE3, . . ., TTOP
            (temperature).  Fluid labels:  PRES (pressure);  VX, VY, or VZ
            (velocities).  Electric labels:  VOLT (voltage);  EMF
            (electromotive force drop);  CURR (current).  Magnetic labels:  MAG
            (scalar magnetic potential); AX, AY, or AZ (vector magnetic
            potentials);  CURR (current). Diffusion label: CONC
            (concentration).

        toler
            Tolerance for coincidence (based on maximum coordinate difference
            in each global Cartesian direction for node locations and on angle
            differences for node orientations).  Defaults to 0.0001.   Only
            nodes within the tolerance are considered to be coincident for
            coupling.

        Notes
        -----
        Defines coupled degrees of freedom between coincident nodes (within a
        tolerance).  May be used, for example, to "button" together elements
        interfacing at a seam, where the seam consists of a series of node
        pairs.  One coupled set is generated for each selected degree of
        freedom for each pair of coincident nodes.  For more than two
        coincident nodes in a cluster, a coupled set is generated from the
        lowest numbered node to each of the other nodes in the cluster.
        Coupled sets are generated only within (and not between) clusters.  If
        fewer than all nodes are to be checked for coincidence, use the NSEL
        command to select nodes.  Coupled set reference numbers are incremented
        by one from the highest previous set number.  Use CPLIST to display the
        generated sets.  Only nodes having the same nodal coordinate system
        orientations ("coincident" within a tolerance) are included.  Use the
        CEINTF command to connect nodes by constraint equations instead of by
        coupling.  Use the EINTF command to connect nodes by line elements
        instead of by coupling.
        """
        command = "CPINTF,%s,%s" % (str(lab), str(toler))
        return self.run(command, **kwargs)

    def enorm(self, enum="", **kwargs):
        """APDL Command: ENORM

        Reorients shell element normals or line element node connectivity.

        Parameters
        ----------
        enum
            Element number having the normal direction that the reoriented
            elements are to match. If ENUM = P, graphical picking is enabled
            and all remaining command fields are ignored (valid only in the
            GUI).

        Notes
        -----
        Reorients shell elements so that their outward normals are consistent
        with that of a specified element. ENORM can also be used to reorder
        nodal connectivity of line elements so that their nodal ordering is
        consistent with that of a specified element.

        For shell elements, the operation reorients the element by reversing
        and shifting the node connectivity pattern. For example, for a 4-node
        shell element, the nodes in positions I, J, K and L of the original
        element are placed in positions J, I, L and K of the reoriented
        element. All 3-D shell elements in the selected set are considered for
        reorientation, and no element is reoriented more than once during the
        operation. Only shell elements adjacent to the lateral (side) faces are
        considered.

        The command reorients the shell element normals on the same panel as
        the specified shell element. A panel is the geometry defined by a
        subset of shell elements bounded by free edges or T-junctions (anywhere
        three or more shell edges share common nodes).

        Reorientation progresses within the selected set until either of the
        following conditions is true:

        The edge of the model is reached.

        More than two elements (whether selected or unselected) are adjacent to
        a lateral face.

        In situations where unselected elements might undesirably cause case b
        to control, consider using ENSYM,0,,0,ALL instead of ENORM.  It is
        recommended that reoriented elements be displayed and graphically
        reviewed.

        You cannot use the ENORM command to change the normal direction of any
        element that has a body or surface load. We recommend that you apply
        all of your loads only after ensuring that the element normal
        directions are acceptable.

        Real constant values are not reoriented and may be invalidated by an
        element reversal.
        """
        command = "ENORM,%s" % (str(enum))
        return self.run(command, **kwargs)

    def delete(self, set="", nstart="", nend="", **kwargs):
        """APDL Command: DELETE

        Specifies sets in the results file to be deleted before postprocessing.

        Parameters
        ----------
        set
            Specifies that sets in the results file are to be deleted.

        nstart
            The first set in a results file to be deleted.

        nend
            The final set in a results file to be deleted. This field is used
            only if deleting more than one sequential sets.

        Notes
        -----
        DELETE is a specification command that flags sets in the results file
        for deletion. It should be followed by a COMPRESS command, the
        corresponding action command that deletes the specified sets.

        The DELETE command is valid only in the results file editing processor
        (ANSYS auxiliary processor AUX3).
        """
        command = "DELETE,%s,%s,%s" % (str(set), str(nstart), str(nend))
        return self.run(command, **kwargs)

    def atan(self, ir="", ia="", name="", facta="", **kwargs):
        """APDL Command: ATAN

        Forms the arctangent of a complex variable.

        Parameters
        ----------
        ir
            Arbitrary reference number assigned to the resulting variable (2 to
            NV [NUMVAR]).  If this number is the same as for a previously
            defined variable, the previously defined variable will be
            overwritten with this result.

        ia
            Reference number of the complex variable to be operated on.

        --, --
            Unused fields.

        name
            Thirty-two character name for identifying the variable on the
            printout and displays.  Embedded blanks are compressed upon output.

        --, --
            Unused fields.

        facta
            Scaling factor (positive or negative) applied to variable IA
            (defaults to 1.0).  Usually FACTA should be set to 1.  FACTA may
            affect the position of the angle by a multiple of  π, resulting in
            a quadrant change.

        Notes
        -----
        Forms the arctangent of a complex variable according to the operation:

        IR = ATAN(FACTA X b/a)

        where a and b are the real and imaginary parts, respectively, of the
        complex variable IA (which is of the form a + ib).  The arctangent
        represents the phase angle (in radians), and is valid only for a
        harmonic analysis (ANTYPE,HARMIC).

        Since the scaling factor is applied uniformly to b/a, applying any
        positive or negative scaling factor will not affect the size of the
        phase angle, with the exception that a negative scaling factor will
        change the results quadrant by : π.  The magnitude of a complex number
        is still obtained through the ABS command.  See POST26 - Data
        Operations in the Mechanical APDL Theory Reference for details.
        """
        command = "ATAN,%s,%s,%s,%s" % (str(ir), str(ia), str(name), str(facta))
        return self.run(command, **kwargs)

    def etdele(self, ityp1="", ityp2="", inc="", **kwargs):
        """APDL Command: ETDELE

        Deletes element types.

        Parameters
        ----------
        ityp1, ityp2, inc
            Deletes element types from ITYP1 to ITYP2 (defaults to ITYP1) in
            steps of INC (defaults to 1). If ITYP1 = ALL, ITYP2 and INC are
            ignored and all element types are deleted.  Element types are
            defined with the ET command.
        """
        command = "ETDELE,%s,%s,%s" % (str(ityp1), str(ityp2), str(inc))
        return self.run(command, **kwargs)

    def lsengine(self, type="", enginename="", matrix="", option="", **kwargs):
        """APDL Command: *LSENGINE

        Creates a linear solver engine.

        Parameters
        ----------
        type
            Specifies the algorithm to be used:

            Boeing sparse solver (default if applied to sparse matrices). - MKL sparse linear solver (Intel Windows and Linux systems only).

            LAPACK dense matrix linear solver (default if applied to dense matrices). - Distributed sparse solver.

        enginename
            Name used to identify this engine. Must be specified.

        matrix
            Name of the matrix to solve.

        option
            Option to control the memory mode of the DSS solver (used only if
            Type = DSS):

            In-core memory mode. - Out-of-core memory mode.

        Notes
        -----
        This command creates a linear solver engine.

        The BCS, DSS, and DSP solvers can only be used with sparse matrices.
        For dense matrices, use the LAPACK solver.
        """
        command = "*LSENGINE,%s,%s,%s,%s" % (str(type), str(enginename), str(matrix), str(option))
        return self.run(command, **kwargs)

    def prcplx(self, key="", **kwargs):
        """APDL Command: PRCPLX

        Defines the output form for complex variables.

        Parameters
        ----------
        key
            Output form key:

            0 - Real and imaginary parts.

            1 - Amplitude and phase angle.  Stored real and imaginary data are converted to
                amplitude and phase angle upon output.  Data remain stored as
                real and imaginary parts.

        Notes
        -----
        Defines the output form for complex variables.  Used only with harmonic
        analyses (ANTYPE,HARMIC).

        All results data are stored in the form of real and imaginary
        components and converted to amplitude and/or phase angle as specified
        via the PRCPLX command. The conversion is not  valid for derived
        results (such as principal stress/strain, equivalent stress/strain and
        USUM).
        """
        command = "PRCPLX,%s" % (str(key))
        return self.run(command, **kwargs)

    def demorph(self, elem="", dimn="", rmshky="", **kwargs):
        """APDL Command: DEMORPH

        Move nodes in selected elements to conform to structural displacements.

        Parameters
        ----------
        elem
             Non-structural elements to which mesh movement (morph) applies.
            If ALL, apply morphing to all selected elements [ESEL]. If ELEM =
            P, graphical picking is enabled.  A component may be substituted
            for ELEM.

        dimn
            Problem dimensionality.  Use "2" for a 2-D problem and "3" for a
            3-D problem (no default).

        rmshky
            Remesh flag option:

            0 - Remesh the selected non-structural regions only if mesh morphing fails.

            1 - Remesh the selected non-structural regions and bypass mesh morphing.

            2 - Perform mesh morphing only and do not remesh.

        Notes
        -----
        The selected elements should include only non-structural regions
        adjacent to structural regions. The exterior nodes of the selected
        elements will usually be on the boundary of the region which will have
        node positions displaced. For DIMN = 2, elements must lie on a flat
        plane. The DEMORPH command requires a single domain grouping of
        elements be provided (multiple domains of elements are not permitted).
        Exterior nodes will be assumed fixed (no nodes will be morphed) unless
        they coincide with structural nodes having nonzero displacements.

        Nodes in the structural regions move in accordance with computed
        displacements. Displacements from a structural analysis must be in the
        database prior to issuing DEMORPH.

        By default (RMSHKY = 0), DEMORPH will remesh the selected non-
        structural regions entirely if a satisfactory morphed mesh cannot be
        provided.

        If boundary conditions and loads are applied directly to nodes and
        elements, the DEMORPH command requires that these be removed before
        remeshing can take place.

        Exercise care with initial conditions defined by the IC command. Before
        a structural analysis is performed for a sequentially coupled analysis,
        the DEMORPH command requires that initial conditions be removed from
        all null element type nodes in the non-structural regions. Use ICDELE
        to delete the initial conditions.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "DEMORPH,%s,%s,%s" % (str(elem), str(dimn), str(rmshky))
        return self.run(command, **kwargs)

    def rmxport(self, **kwargs):
        """APDL Command: RMXPORT

        Exports ROM model to external VHDL-AMS simulator.

        Notes
        -----
        Use this command to generate all files necessary to run the ROM
        analysis in an external VHDL-AMS Simulator.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.

        VHDL files: Initial.vhd, S_ams_ijk.vhd, Cxxx_ams_ijk.vhd,
        transducer.vhd.
        """
        command = "RMXPORT," % ()
        return self.run(command, **kwargs)

    def sadd(self, labr="", lab1="", lab2="", fact1="", fact2="", const="",
             **kwargs):
        """APDL Command: SADD

        Forms an element table item by adding two existing items.

        Parameters
        ----------
        labr
            Label assigned to results.  If same as existing label, the existing
            values will be overwritten by these results.

        lab1
            First labeled result item in operation.

        lab2
            Second labeled result item in operation (may be blank).

        fact1
            Scale factor applied to Lab1. A (blank) or '0' entry defaults to
            1.0.

        fact2
            Scale factor applied to Lab2. A (blank) or '0' entry defaults to
            1.0.

        const
            Constant value.

        Notes
        -----
        Forms a labeled result (see ETABLE command) for the selected elements
        by adding two existing labeled result items according to the operation:

        LabR = (FACT1 x Lab1) + (FACT2 x Lab2) + CONST

        May also be used to scale results for a single labeled result item.  If
        absolute values are requested [SABS,1], absolute values of Lab1 and
        Lab2 are used.
        """
        command = "SADD,%s,%s,%s,%s,%s,%s" % (str(labr), str(lab1), str(lab2), str(fact1), str(fact2), str(const))
        return self.run(command, **kwargs)

    def rmodif(self, nset="", stloc="", v1="", v2="", v3="", v4="", v5="",
               v6="", **kwargs):
        """APDL Command: RMODIF

        Modifies real constant sets.

        Parameters
        ----------
        nset
            Number of existing real constant set to be modified.

        stloc
            Starting location in table for modifying data.  For example, if
            STLOC = 1, data input in the V1 field is the first constant in the
            set.  If STLOC = 7, data input in the V1 field is the seventh
            constant in the set, etc.  Must be greater than zero.

        v1
            New value assigned to constant in location STLOC.  If zero (or
            blank), a zero value will be assigned.

        v2, v3, v4, . . . , v6
            New values assigned to constants in the next five locations.  If
            blank, the value remains unchanged.

        Notes
        -----
        Allows modifying (or adding) real constants to an existing set [R] at
        any location.

        Specify NSET = GCN to define/modify real constants for real constant
        sets that were previously assigned by the GCDEF command (that is, real
        constants used in general contact interactions).

        This command is also valid in SOLUTION. For important information about
        using this command within the solution phase, see What Are Nonstandard
        Uses? in the Advanced Analysis Guide.
        """
        command = "RMODIF,%s,%s,%s,%s,%s,%s,%s,%s" % (str(nset), str(stloc), str(v1), str(v2), str(v3), str(v4), str(v5), str(v6))
        return self.run(command, **kwargs)

    def eof(self, **kwargs):
        """APDL Command: /EOF

        Exits the file being read.

        Notes
        -----
        Causes an end-of-file exit when encountered on a switched file (see
        /INPUT, *USE, etc.). Commands are then read continuing from the file
        that contained the file switching command (or from the terminal if the
        switch was made from the terminal). Use the /EXIT command to terminate
        an ANSYS run. This command cannot be used in a do-loop or if-then-else
        construct.

        This command is valid in any processor.
        """
        command = "/EOF," % ()
        return self.run(command, **kwargs)

    def mflist(self, option="", value="", **kwargs):
        """APDL Command: MFLIST

        Lists the settings for an ANSYS Multi-field solver analysis.

        Parameters
        ----------
        option
            ALL

            ALL - Lists all ANSYS Multi-field solver analysis options.

            SOLU - Lists all solution-related ANSYS Multi-field solver options.

            FIELD - Lists all ANSYS Multi-field solver options related to the specified field
                    number.

            SINT - Lists all surface interface information for the specified surface interface
                   number.

            VINT - Lists all volumetric interface information for the specified volumetric
                   interface number.

        value
            Use only for Option = FIELD, SINT, or VINT.

        Notes
        -----
        This command is also valid in PREP7.

        See Multi-field Commands in the Coupled-Field Analysis Guide for a list
        of all ANSYS Multi-field solver commands and their availability for MFS
        and MFX analyses.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "MFLIST,%s,%s" % (str(option), str(value))
        return self.run(command, **kwargs)

    def edele(self, iel1="", iel2="", inc="", **kwargs):
        """APDL Command: EDELE

        Deletes selected elements from the model.

        Parameters
        ----------
        iel1, iel2, inc
            Delete elements from IEL1 to IEL2 (defaults to IEL1) in steps of
            INC (defaults to 1). If IEL1 = ALL, IEL2 and INC are ignored and
            all selected elements [ESEL] are deleted. If IEL1 = P, graphical
            picking is enabled and all remaining command fields are ignored
            (valid only in the GUI). A component name may also be substituted
            for IEL1 (IEL2 and INC are ignored).

        Notes
        -----
        Deleted elements are replaced by null or "blank" elements. Null
        elements are used only for retaining the element numbers so that the
        element numbering sequence for the rest of the model is not changed by
        deleting elements. Null elements may be removed (although this is not
        necessary) with the NUMCMP command. If related element data (pressures,
        etc.) are also to be deleted, delete that data before deleting the
        elements. EDELE is for unattached elements only. You can use the xCLEAR
        family of commands to remove any attached elements from the database.
        """
        command = "EDELE,%s,%s,%s" % (str(iel1), str(iel2), str(inc))
        return self.run(command, **kwargs)

    def wait(self, dtime="", **kwargs):
        """APDL Command: /WAIT

        Causes a delay before the reading of the next command.

        Parameters
        ----------
        dtime
            Time delay (in seconds). Maximum time delay is 59 seconds.

        Notes
        -----
        The command following the /WAIT will not be processed until the
        specified wait time increment has elapsed.  Useful when reading from a
        prepared input file to cause a pause, for example, after a display
        command so that the display can be reviewed for a period of time.
        Another "wait" feature is available via the *ASK command.

        This command is valid in any processor.
        """
        command = "/WAIT,%s" % (str(dtime))
        return self.run(command, **kwargs)

    def l(self, p1="", p2="", ndiv="", space="", xv1="", yv1="", zv1="",
          xv2="", yv2="", zv2="", **kwargs):
        """APDL Command: L

        Defines a line between two keypoints.

        Parameters
        ----------
        p1
            Keypoint at the beginning of line.  If P1 = P, graphical picking is
            enabled and all remaining command fields are ignored (valid only in
            the GUI).

        p2
            Keypoint at the end of line.

        ndiv
            Number of element divisions within this line.  Normally this field
            is not used; specifying divisions with LESIZE, etc. is recommended.

        space
            Spacing ratio.  Normally this field is not used, as specifying
            spacing ratios with the LESIZE command is recommended.  If
            positive, SPACE is the nominal ratio of the last division size (at
            P2) to the first division size (at P1).  If the ratio is greater
            than 1, the division sizes increase from P1 to P2, and if less than
            1, they decrease.  If SPACE is negative, then |SPACE| is the
            nominal ratio of the center division size to those at the ends.

        Returns
        -------
        result : int
            Returns the line number of the created line or None,
            if something went wrong.

        Notes
        -----
        Defines a line between two keypoints from P1 to P2.  The line shape may
        be generated as "straight" (in the active coordinate system) or curved.
        The line shape is invariant with coordinate system after it is
        generated.  Note that solid modeling in a toroidal coordinate system is
        not recommended.  A curved line is limited to 180°.  Lines may be
        redefined only if not yet attached to an area.
        """
        command = "L,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(p1), str(p2), str(ndiv), str(space), str(xv1), str(yv1), str(zv1), str(xv2), str(yv2), str(zv2))
        return self.run(command, **kwargs)

    def mfoutput(self, freq="", **kwargs):
        """APDL Command: MFOUTPUT

        Specifies results file output frequency for an ANSYS
        Multi-field solver analysis.

        Parameters
        ----------
        freq
            N

            N - Write solution every Nth (and the last) time
                 step. Defaults to 1, for every time step.

            -N - Writes up to -N equally spaced results (for multifield auto time stepping).

            NONE - Suppresses writing of results for all multifield time steps.

            ALL - Writes results for every multifield time step (default).

            LAST - Writes results for only the last multifield time step.

            %array% - Where %array% is the name of an n X 1 X 1
                      dimensional array parameter defining n key
                      times, the data for the specified solution
                      results item is written at those key times. Key
                      times in the array parameter must appear in
                      ascending order. Value must be greater than or
                      equal to the ending time values for the load
                      step.

            For restart runs (see MFRSTART command), either change the parameter values to fall between the beginning and ending time values of the load step, or erase the current settings and reissue the command with a new array parameter.  - For more information about defining array parameters, see the *DIM command
                              documentation.

        Notes
        -----
         A MFOUTPUT setting overrides any other output frequency setting
        (OUTRES). To select the solution items, use the OUTRES command.

        For the case of Freq = -n and Freq = %array%, the results at the time
        points which first time reaches or exceeds the targeting ouptupt time
        points will be written.

        This command is also valid in PREP7.

        See Multi-field Commands in the Coupled-Field Analysis Guide for a list
        of all ANSYS Multi-field solver commands and their availability for MFS
        and MFX analyses.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "MFOUTPUT,%s" % (str(freq))
        return self.run(command, **kwargs)

    def pdsave(self, fname="", ext="", **kwargs):
        """APDL Command: PDSAVE

        Writes the probabilistic model data to a file.

        Parameters
        ----------
        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        Notes
        -----
        Writes the probabilistic model data to a file. Saved data include
        probabilistic data only; the results of the probabilistic analyses are
        not stored in the file (rather, these are stored in separate result
        files).
        """
        command = "PDSAVE,%s,%s" % (str(fname), str(ext))
        return self.run(command, **kwargs)

    def secdata(self, val1="", val2="", val3="", val4="", val5="", val6="",
                val7="", val8="", val9="", val10="", val11="", val12="",
                **kwargs):
        """APDL Command: SECDATA

        Describes the geometry of a section.

        Parameters
        ----------
        val1, val2, val3, . . . , val12
            Values, such as thickness or the length of a side or the numbers of
            cells along the width, that describe the geometry of a section. The
            terms VAL1, VAL2, etc. are specialized for each type of cross-
            section.

        Notes
        -----
        The SECDATA command defines the data describing the geometry of a
        section. The command is divided into these section types: Beams, Links,
        Pipes, Axisymmetric, Taper, Shells, Pretension, Joints, Reinforcing,
        and Contact.

        The data input on the SECDATA command is interpreted based on the most
        recently issued SECTYPE command. The data required is determined by the
        section type and subtype, and is different for each one.

        Beam sections are referenced by BEAM188 and BEAM189 elements. Not all
        SECOFFSET location values are valid for each subtype.

        Type: BEAM, Subtype: RECT

        Type: BEAM, Subtype: QUAD

        Degeneration to triangle is permitted by specifying the same
        coordinates for cells along an edge.

        Type: BEAM, Subtype: CSOLID

        Type: BEAM, Subtype: CTUBE

        This subtype is similar to type PIPE. However, elements using PIPE
        account for internal or external pressures, whereas elements using
        CTUBE do not.

        Type: BEAM, Subtype: CHAN

        Type: BEAM, Subtype: I

        Type: BEAM, Subtype: Z

        Type: BEAM, Subtype: L

        If W2 is a negative value, the section will be flipped.

        Type: BEAM, Subtype: T

        If W2 is a negative value, the section will be flipped.

        Type: BEAM, Subtype: HATS
        """
        command = "SECDATA,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(val1), str(val2), str(val3), str(val4), str(val5), str(val6), str(val7), str(val8), str(val9), str(val10), str(val11), str(val12))
        return self.run(command, **kwargs)

    def vdele(self, nv1="", nv2="", ninc="", kswp="", **kwargs):
        """APDL Command: VDELE

        Deletes unmeshed volumes.

        Parameters
        ----------
        nv1, nv2, ninc
            Delete volumes from NV1 to NV2 (defaults to NV1) in steps of NINC
            (defaults to 1).  If NV1 = ALL, NV2 and NINC are ignored and all
            selected volumes [VSEL] are deleted.  If NV1 = P, graphical picking
            is enabled and all remaining command fields are ignored (valid only
            in the GUI).  A component name may also be substituted for NV1 (NV2
            and NINC are ignored).

        kswp
            Specifies whether keypoints, lines, and areas are also deleted:

            0 - Delete volumes only (default).

            1 - Delete volumes, as well as keypoints, lines, and areas attached to the
                specified volumes but not shared by other volumes.
        """
        command = "VDELE,%s,%s,%s,%s" % (str(nv1), str(nv2), str(ninc), str(kswp))
        return self.run(command, **kwargs)

    def slashdscale(self, wn="", dmult="", **kwargs):
        """APDL Command: /DSCALE

        Sets the displacement multiplier for displacement displays.

        Parameters
        ----------
        wn
            Window number (or ALL) to which command applies (defaults to 1).

        dmult
            AUTO or 0

            AUTO or 0 - Scale displacements automatically so that maximum  displacement (vector
                        amplitude) displays as 5 percent of the maximum model
                        length, as measured in the global Cartesian X, Y, or Z
                        directions.

            1 - Do not scale displacements (i.e., scale displacements by 1.0, true to
                geometry).  Often used with large deflection results.

            FACTOR - Scale displacements by numerical value input for FACTOR.

            OFF - Remove displacement scaling (i.e., scale displacements by 0.0, no distortion).

            USER - Set DMULT to that used for last display (useful when last DMULT value was
                   automatically calculated).

        Notes
        -----
        If Multi-Plots are not being displayed, and the current device is a 3-D
        device [/SHOW,3D], then the displacement scale in all active windows
        will be the same, even if separate /DSCALE commands are issued for each
        active window. For efficiency, ANSYS 3-D graphics logic maintains a
        single data structure (segment), which contains only one displacement
        scale. The program displays the same segment (displacement scale) in
        all windows. Only the view settings will be different in each of the
        active windows.

        This command is valid in any processor.
        """
        command = "/DSCALE,%s,%s" % (str(wn), str(dmult))
        return self.run(command, **kwargs)

    def lcabs(self, lcno="", kabs="", **kwargs):
        """APDL Command: LCABS

        Specifies absolute values for load case operations.

        Parameters
        ----------
        lcno
            Load case pointer number.  If ALL, apply to all selected load cases
            [LCSEL].

        kabs
            Absolute value key:

            0 - Use algebraic values of load case LCNO in operations.

            1 - Use absolute values of load case LCNO in operations.

        Notes
        -----
        Causes absolute values to be used in the load case operations [LCASE or
        LCOPER].  Absolute values are taken prior to assigning a load case
        factor [LCFACT] and are applied only to defined load cases [LCDEF].
        """
        command = "LCABS,%s,%s" % (str(lcno), str(kabs))
        return self.run(command, **kwargs)

    def qsopt(self, opt="", **kwargs):
        """APDL Command: QSOPT

        Specifies quasi static radiation options.

        Parameters
        ----------
        opt
            Quasi static option:

            OFF - Do not run transient radiation problem to steady-state (default).

            ON - Run transient radiation problem to steady-state.

        Notes
        -----
        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "QSOPT,%s" % (str(opt))
        return self.run(command, **kwargs)

    def edout(self, option="", **kwargs):
        """APDL Command: EDOUT

        Specifies time-history output (ASCII format) for an explicit dynamics
        analysis.

        Parameters
        ----------
        option
            Output data option. Each option corresponds to a separate file that
            is written by the LS-DYNA solver. If Option = ALL, all files except
            NODOUT and ELOUT are written. Valid options are:

            GLSTAT - Global data (default).

            BNDOUT - Boundary condition forces and energy.

            RWFORC - Wall force.

            DEFORC - Discrete element data.

            MATSUM - Material energies data.

            NCFORC - Nodal interface forces.

            RCFORC - Resultant interface force data.

            DEFGEO - Deformed geometry data.

            SPCFORC - SPC reaction force data.

            SWFORC - Nodal constraint reaction force data (spotwelds and rivets).

            RBDOUT - Rigid body data.

            GCEOUT - Geometry contact entities.

            SLEOUT - Sliding interface energy.

            JNTFORC - Joint force data.

            NODOUT - Nodal data.

            ELOUT - Element data.

        Notes
        -----
        This command specifies output to be written during an explicit dynamics
        solution. The data corresponding to each Option is written to a
        separate ASCII file having the same name as the Option label. The data
        is written for the entire model at time intervals specified by the
        EDHTIME command. If no time interval is specified, output is written at
        1000 steps over the analysis. (See also the EDHIST command which
        specifies time-history output for a portion of the model.)  The data
        written to the MATSUM file is actually for each PART number (EDPART) at
        time intervals specified by the EDHTIME command, but the data is listed
        following the Mat no. in the file.

        For Option = NODOUT and ELOUT, you must specify a component; you must
        issue EDHIST before issuing EDOUT,NODOUT or EDOUT,ELOUT.

        Use EDOUT,LIST to list the current time-history output specifications.
        (The listing will include output requested with the EDHIST command.)
        Use EDOUT,DELE to delete all output specifications that have been
        defined with the EDOUT command.

        In order for the specified output files to be written, you must also
        request that explicit dynamics results be written to an LS-DYNA output
        file [EDWRITE,LSDYNA or EDWRITE,BOTH].

        In an explicit dynamic small restart analysis (EDSTART,2) or full
        restart analysis (EDSTART,3), the same ASCII files that were requested
        for the original analysis are written by default for the restart. You
        can request different files by issuing the appropriate EDOUT commands
        in the restart analysis.

        This command is also valid in PREP7.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDOUT,%s" % (str(option))
        return self.run(command, **kwargs)

    def aflist(self, **kwargs):
        """APDL Command: AFLIST

        Lists the current data in the database.

        Notes
        -----
        Lists the current data and specifications in the database.  If batch,
        lists all appropriate data.  If interactive, lists only summaries.
        """
        command = "AFLIST," % ()
        return self.run(command, **kwargs)

    def trtime(self, time="", spacing="", offset="", size="", length="",
               **kwargs):
        """APDL Command: TRTIME

        Defines the options used for the PLTRAC (particle flow or charged
        particle trace) command.

        Parameters
        ----------
        time
            Total Trace Time (seconds) (defaults to 0, which is the full flow
            trace).

        spacing
            Particle spacing in seconds (defaults to 0).

        offset
            Particle offset in seconds (defaults to 0).  It is used internally
            in the ANFLOW macro to produce an animation of particle flow in a
            flowing fluid or charged particle motion in an electric or magnetic
            field.

        size
            Particle size (defaults to 0, which is a line).

        length
            Particle length fraction (defaults to .1).

        Notes
        -----
        The TRTIME command varies the type of   PLTRAC display produced.
        Particle flow or charged particle traces follow a particle's path in
        the forward and backward direction of travel. The DOF selected
        determines the color of the particle trace.  SPACING defines the
        particle spacing in seconds from adjacent particles in the stream line.
        OFFSET defines the offset in seconds from the spacing set by the
        SPACING argument.

        LENGTH defines the particle length fraction.  The default value (.1),
        means the particle occupies 10% of the flow region, and the other 90%
        is a color-coded line.

        SIZE sets the radius of the particle. Use SPACING, OFFSET and LENGTH
        only when SIZE is nonzero (i.e., the particle is bigger than the line).

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "TRTIME,%s,%s,%s,%s,%s" % (str(time), str(spacing), str(offset), str(size), str(length))
        return self.run(command, **kwargs)

    def cbmx(self, row="", s_r__r_="", s_r__r_plus_1_="", s_r__r_plus_2_="",
             s_r__r_plus_3_="", s_r__r_plus_4_="", s_r__r_plus_5_="",
             s_r__r_plus_6_="", **kwargs):
        """APDL Command: CBMX

        Specifies preintegrated cross-section stiffness for composite beam
        sections.

        Parameters
        ----------
        row
            Row number of the matrix.

        s(r)(r), . . . , s(r)(r+6)
            Upper triangle of the cross-section stiffness matrix [S].

        Notes
        -----
        The behavior of beam elements is governed by the generalized-
        stress/generalized-strain relationship of the form:

        The CBMX command, one of several composite beam section commands,
        specifies the cross-section stiffness matrix (submatrix [S] data) for a
        composite beam section. The section data defined is associated with the
        section most recently defined (SECTYPE) at the specified temperature
        (CBTMP).

        Unspecified values default to zero.

        Related commands are CBTMP, CBTE, and CBMD.

        For complete information, see Using Preintegrated Composite Beam
        Sections.
        """
        command = "CBMX,%s,%s,%s,%s,%s,%s,%s,%s" % (str(row), str(s_r__r_), str(s_r__r_plus_1_), str(s_r__r_plus_2_), str(s_r__r_plus_3_), str(s_r__r_plus_4_), str(s_r__r_plus_5_), str(s_r__r_plus_6_))
        return self.run(command, **kwargs)

    def extopt(self, lab="", val1="", val2="", val3="", val4="", **kwargs):
        """APDL Command: EXTOPT

        Controls options relating to the generation of volume elements from
        area elements.

        Parameters
        ----------
        lab
            Label identifying the control option. The meanings of Val1, Val2,
            and Val3 will vary depending on Lab.

            ON - Sets carryover of the material attributes, real constant attributes, and
                 element coordinate system attributes of the pattern area
                 elements to the generated volume elements.  Sets the pattern
                 area mesh to clear when volume generations are done. Val1,
                 Val2, and Val3 are ignored.

            OFF - Removes all settings associated with this command. Val1, Val2, and Val3 are
                  ignored.

            STAT - Shows all settings associated with this command. Val1, Val2, Val3, and Val4 are
                   ignored.

            ATTR - Sets carryover of particular pattern area attributes (materials, real
                   constants, and element coordinate systems) of the pattern
                   area elements to the generated volume elements. (See 2.)
                   Val1 can be:

            0 - Sets volume elements to use current MAT command settings.

            1 - Sets volume elements to use material attributes of the pattern area elements.

            Val2 can be:  - 0

            Sets volume elements to use current REAL command settings. - 1

            Sets volume elements to use real constant attributes of the pattern area elements. - Val3 can be:

            0 - Sets volume elements to use current ESYS command settings.

            1 - Sets volume elements to use element coordinate system attributes of the pattern
                area elements.

            Val4 can be:  - 0

            Sets volume elements to use current SECNUM command settings. - 1

            Sets volume elements to use section attributes of the pattern area elements. -

            ESIZE - Val1 sets the number of element divisions in the direction of volume generation
                    or volume sweep. For VDRAG and VSWEEP, Val1 is overridden
                    by the LESIZE command NDIV setting. Val2 sets the spacing
                    ratio (bias) in the direction of volume generation or
                    volume sweep. If positive, Val2 is the nominal ratio of
                    last division size to first division size (if > 1.0, sizes
                    increase, if < 1.0, sizes decrease). If negative, Val2 is
                    the nominal ratio of center division(s) size to end
                    divisions size. Ratio defaults to 1.0 (uniform spacing).
                    Val3 and Val4 are ignored.

            ACLEAR - Sets clearing of pattern area mesh. (See 3.) Val1 can be:

            0 - Sets pattern area to remain meshed when volume generation is done.

            1 - Sets pattern area mesh to clear when volume generation is done. Val2, Val3 ,
                and Val4 are ignored.

            VSWE - Indicates that volume sweeping options will be set using Val1 and Val2.
                   Settings specified with EXTOPT,VSWE will be used the next
                   time the VSWEEP command is invoked. If Lab = VSWE, Val1
                   becomes a label. Val1 can be:

            AUTO - Indicates whether you will be prompted for the source and target used by VSWEEP
                   or if VSWE should automatically determine the source and
                   target. If Val1 = AUTO, Val2 is ON by default. VSWE will
                   automatically determine the source and target for VSWEEP.
                   You will be allowed to pick more than one volume for
                   sweeping. When Val2 = OFF, the user will be prompted for the
                   source and target for VSWEEP. You will only be allowed to
                   pick one volume for sweeping.

            TETS - Indicates whether VSWEEP will tet mesh non-sweepable volumes or leave them
                   unmeshed. If Val1 = TETS, Val2 is OFF by default. Non-
                   sweepable volumes will be left unmeshed. When Val2 = ON, the
                   non-sweepable volumes will be tet meshed if the assigned
                   element type supports tet shaped elements.

        val1, val2, val3, val4
            Additional input values as described under each option for Lab.

        Notes
        -----
        EXTOPT controls options relating to the generation of volume elements
        from pattern area elements using the VEXT, VROTAT, VOFFST, VDRAG, and
        VSWEEP commands.  (When using VSWEEP,  the pattern area is referred to
        as the source area.)

        Enables carryover of the attributes  of the pattern area elements to
        the generated volume elements when you are using VEXT, VROTAT, VOFFST,
        or VDRAG. (When using VSWEEP, since the volume already exists, use the
        VATT command to assign attributes before sweeping.)

        When you are using VEXT, VROTAT, VOFFST, or VDRAG, enables clearing of
        the pattern area mesh when volume generations are done. (When you are
        using VSWEEP, if selected, the area meshes on the pattern (source),
        target, and/or side areas clear when volume sweeping is done.)

        Neither EXTOPT,VSWE,AUTO nor EXTOPT,VSWE,TETS will be affected by
        EXTOPT,ON or EXTOPT, OFF.
        """
        command = "EXTOPT,%s,%s,%s,%s,%s" % (str(lab), str(val1), str(val2), str(val3), str(val4))
        return self.run(command, **kwargs)

    def genopt(self, **kwargs):
        """APDL Command: GENOPT

        Specifies "General options" as the subsequent status topic.

        Notes
        -----
        This is a status (STAT) topic command. Status topic commands are
        generated by the GUI and will appear in the log file (Jobname.LOG) if
        status is requested for some items under Utility Menu> List> Status.
        This command will be immediately followed by a STAT command, which will
        report the status for the specified topic.

        If entered directly into the program, the STAT command should
        immediately follow this command.
        """
        command = "GENOPT," % ()
        return self.run(command, **kwargs)

    def inrtia(self, **kwargs):
        """APDL Command: INRTIA

        Specifies "Inertial loads" as the subsequent status topic.

        Notes
        -----
        This is a status [STAT] topic command.  Status topic commands are
        generated by the GUI and will appear in the log file (Jobname.LOG) if
        status is requested for some items under Utility Menu> List> Status.
        This command will be immediately followed by a STAT command, which will
        report the status for the specified topic.

        If entered directly into the program, the STAT command should
        immediately follow this command.
        """
        command = "INRTIA," % ()
        return self.run(command, **kwargs)

    def pdot(self, labr="", labx1="", laby1="", labz1="", labx2="", laby2="",
             labz2="", **kwargs):
        """APDL Command: PDOT

        Calculates the dot product of two path vectors along the current path.

        Parameters
        ----------
        labr
            Label assigned to dot product result.

        labx1
            X-component of first vector label (labeled path item).

        laby1
            Y-component of first vector label (labeled path item).

        labz1
            Z-component of first vector label (labeled path item).

        labx2
            X-component of second vector label (labeled path item).

        laby2
            Y-component of second vector label (labeled path item).

        labz2
            Z-component of second vector label (labeled path item).
        """
        command = "PDOT,%s,%s,%s,%s,%s,%s,%s" % (str(labr), str(labx1), str(laby1), str(labz1), str(labx2), str(laby2), str(labz2))
        return self.run(command, **kwargs)

    def dflx(self, node="", bx="", by="", bz="", bx2="", by2="", bz2="",
             **kwargs):
        """APDL Command: DFLX

        Imposes a uniform magnetic flux B on an edge-element electromagnetic
        model.

        Parameters
        ----------
        node
            Nodes at which the edge-flux (AZ) constraints corresponding to the
            uniform magnetic flux are to be specified.  Valid options are ALL
            (default) or Component Name. If ALL, constraints are applied to all
            selected nodes (NSEL).

        bx, by, bz
            Real components of magnetic flux B.

        bx2, by2, bz2
            Imaginary components of magnetic flux B.

        Notes
        -----
        The DFLX command sets the constraints on the edge-flux (AZ) degrees of
        freedom to produce a uniform magnetic flux B in an edge-based
        electromagnetic analysis using elements SOLID236 and SOLID237. The
        command ignores the corner nodes of the elements (even if they were
        selected) and imposes the AZ-constraints on the mid-side nodes only.
        The AZ-constraints are imposed in the active Cartesian coordinate
        system. A non-Cartesian coordinate system will be ignored by the DFLX
        command.

        The edge-flux constraints at the mid-side nodes are derived from  the
        magnetic vector potential A, which is related to the imposed magnetic
        flux B as follows:

        where r is the position of the mid-side node.

        The DFLX command creates a component named _DFLX for the constrained
        midside nodes. You can use this component to delete the constraints
        imposed by the DFLX command.

        This command is also valid in PREP7.
        """
        command = "DFLX,%s,%s,%s,%s,%s,%s,%s" % (str(node), str(bx), str(by), str(bz), str(bx2), str(by2), str(bz2))
        return self.run(command, **kwargs)

    def ereinf(self, **kwargs):
        """APDL Command: EREINF

        Generates reinforcing elements from selected existing (base) elements.

        Notes
        -----
        The EREINF command generates reinforcing elements (REINF264 and
        REINF265) directly from selected base elements (that is, existing
        standard elements in your model). The command scans all selected base
        elements and generates (if necessary) a compatible reinforcing element
        type for each base element. (ANSYS allows a combination of different
        base element types.)

        Although predefining the reinforcing element type (ET) is not required,
        you must define the reinforcing element section type (SECTYPE);
        otherwise, ANSYS cannot generate the reinforcing element.

        The EREINF command does not create new nodes. The reinforcing elements
        and the base elements share the common nodes.

        Elements generated by this command are not associated with the solid
        model.

        After the EREINF command executes, you can issue ETLIST, ELIST, and
        EPLOT commands to verify the newly created reinforcing element types
        and elements.

        Reinforcing elements do not account for any subsequent modifications
        made to the base elements. ANSYS, Inc. recommends issuing the EREINF
        command only after the base elements are finalized. If you delete or
        modify base elements (via EDELE, EMODIF, ETCHG, EMID, EORIENT, NUMMRG,
        or NUMCMP commands, for example), remove all affected reinforcing
        elements and reissue the EREINF command to avoid inconsistencies.
        """
        command = "EREINF," % ()
        return self.run(command, **kwargs)

    def cpmerge(self, lab="", **kwargs):
        """APDL Command: CPMERGE

        Merges different couple sets with duplicate degrees of freedom into one
        couple set.

        Parameters
        ----------
        lab
            Degree of freedom label for coupled nodes (in the nodal coordinate
            system).  Valid labels are: Structural labels:  UX, UY, or UZ
            (displacements); ROTX, ROTY, or ROTZ (rotations) (in radians).
            Thermal labels: TEMP, TBOT, TE2, TE3, . . ., TTOP (temperature).
            Fluid labels:  PRES (pressure);  VX, VY, or VZ (velocities).
            Electric labels:  VOLT (voltage);  EMF (electromotive force drop);
            CURR (current).  Magnetic labels:  MAG (scalar magnetic potential);
            AX, AY, or AZ (vector magnetic potentials);  CURR (current).
            Diffusion label: CONC (concentration). Explicit analysis labels:
            UX, UY, or UZ (displacements).  The degree of freedom set is
            determined from all element types defined and the DOF command, if
            used.
        """
        command = "CPMERGE,%s" % (str(lab))
        return self.run(command, **kwargs)

    def egen(self, itime="", ninc="", iel1="", iel2="", ieinc="", minc="",
             tinc="", rinc="", cinc="", sinc="", dx="", dy="", dz="",
             **kwargs):
        """APDL Command: EGEN

        Generates elements from an existing pattern.

        Parameters
        ----------
        itime, ninc
            Do this generation operation a total of ITIMEs, incrementing all
            nodes in the given pattern by NINC each time after the first. ITIME
            must be >1 if generation is to occur. NINC may be positive, zero,
            or negative. If DX, DY, and/or DZ is specified, NINC should be set
            so any existing nodes (as on NGEN) are not overwritten.

        iel1, iel2, ieinc
            Generate elements from selected pattern beginning with IEL1 to IEL2
            (defaults to IEL1) in steps of IEINC (defaults to 1). If IEL1 is
            negative, IEL2 and IEINC are ignored and the last |IEL1| elements
            (in sequence backward from the maximum element number) are used as
            the pattern to be repeated.  If IEL1 = ALL, IEL2 and IEINC are
            ignored and use all selected elements [ESEL] as pattern to be
            repeated. If P1 = P, graphical picking is enabled and all remaining
            command fields are ignored (valid only in the GUI).  A component
            name may also be substituted for IEL1 (IEL2 and INC are ignored).

        minc
            Increment material number of all elements in the given pattern by
            MINC each time after the first.

        tinc
            Increment type number by TINC.

        rinc
            Increment real constant table number by RINC.

        cinc
            Increment element coordinate system number by CINC.

        sinc
            Increment section ID number by SINC.

        dx, dy, dz
            Define nodes that do not already exist but are needed by generated
            elements (as though the NGEN,ITIME,INC,NODE1,,,DX,DY,DZ were issued
            before EGEN). Zero is a valid value. If blank, DX, DY, and DZ are
            ignored.

        Notes
        -----
        A pattern may consist of any number of previously defined elements. The
        MAT, TYPE, REAL, ESYS, and SECNUM numbers of the new elements are based
        upon the elements in the pattern and not upon the current specification
        settings.

        You can use the EGEN command to generate interface elements (INTER192,
        INTER193, INTER194, and INTER195) directly. However, because interface
        elements require that the element connectivity be started from the
        bottom surface, you must make sure that you use the correct element
        node connectivity. See the element descriptions for INTER192, INTER193,
        INTER194, and INTER195 for the correct element node definition.
        """
        command = "EGEN,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(itime), str(ninc), str(iel1), str(iel2), str(ieinc), str(minc), str(tinc), str(rinc), str(cinc), str(sinc), str(dx), str(dy), str(dz))
        return self.run(command, **kwargs)

    def gpdele(self, gap1="", gap2="", ginc="", **kwargs):
        """APDL Command: GPDELE

        Deletes gap conditions.

        Parameters
        ----------
        gap1, gap2, ginc
            Delete gap conditions from GAP1 to GAP2 (defaults to GAP1) in steps
            of GINC  (defaults to 1).

        Notes
        -----
        Deletes gap conditions defined with the GP command.  Gap conditions
        following those deleted are automatically compressed and renumbered.
        If used in SOLUTION, this command is valid only within the first load
        step.

        This command is also valid in PREP7.
        """
        command = "GPDELE,%s,%s,%s" % (str(gap1), str(gap2), str(ginc))
        return self.run(command, **kwargs)

    def blc5(self, xcenter="", ycenter="", width="", height="", depth="",
             **kwargs):
        """APDL Command: BLC5

        Creates a rectangular area or block volume by center and corner points.

        Parameters
        ----------
        xcenter, ycenter
            Working plane X and Y coordinates of the center of the rectangle or
            block face.

        width
            The total distance on or parallel to the working plane X-axis
            defining the width of the rectangle or block face.

        height
            The total distance on or parallel to the working plane Y-axis
            defining the height of the rectangle or block face.

        depth
            The perpendicular distance (either positive or negative based on
            the working plane Z direction) from the working plane representing
            the depth of the block.  If DEPTH = 0 (default), a rectangular area
            is created on the working plane.

        Notes
        -----
        Defines a rectangular area anywhere on the working plane or a
        hexahedral volume with one face anywhere on the working plane by
        specifying the center and corner points.  A rectangle will be defined
        with four keypoints and four lines.  A volume will be defined with
        eight keypoints, twelve lines, and six areas, with the top and bottom
        faces parallel to the working plane.  See the BLC4, RECTNG, and BLOCK
        commands for alternate ways to create rectangles and blocks.
        """
        command = "BLC5,%s,%s,%s,%s,%s" % (str(xcenter), str(ycenter), str(width), str(height), str(depth))
        return self.run(command, **kwargs)

    def asum(self, lab="", **kwargs):
        """APDL Command: ASUM

        Calculates and prints geometry statistics of the selected areas.

        Parameters
        ----------
        lab
            Controls the degree of tessellation used in the calculation of area
            properties.  If LAB = DEFAULT, area calculations will use the
            degree of tessellation set through the /FACET command.  If LAB =
            FINE, area calculations are based on a finer tessellation.

        Notes
        -----
        Calculates and prints geometry statistics (area, centroid location,
        moments of inertia, volume, etc.) associated with the selected areas.
        ASUM should only be used on perfectly flat areas.

        Geometry items are reported in the global Cartesian coordinate system.
        A unit thickness is assumed unless the areas have a non-zero total
        thickness defined by real constant or section data.

        For layered areas, a unit density is always assumed. For single-layer
        areas, a unit density is assumed unless the areas have a valid material
        (density).

        The thickness and density are associated to the areas via the AATT
        command.

        Items calculated via ASUM and later retrieved via a *GET or *VGET
        command are valid only if the model is not modified after issuing the
        ASUM command.

        Setting a finer degree of tessellation will provide area calculations
        with greater accuracy, especially for thin, hollow models.  However,
        using a finer degree of tessellation requires longer processing.

        For very narrow (sliver) areas, such that the ratio of the minimum to
        the maximum dimension is less than 0.01, the ASUM command can provide
        erroneous area information.  To ensure that the calculations are
        accurate, subdivide such areas so that the ratio of the minimum to the
        maximum is at least 0.05.
        """
        command = "ASUM,%s" % (str(lab))
        return self.run(command, **kwargs)

    def nsym(self, ncomp="", inc="", node1="", node2="", ninc="", **kwargs):
        """APDL Command: NSYM

        Generates a reflected set of nodes.

        Parameters
        ----------
        ncomp
            Symmetry key:

            X - X (or R) symmetry (default).

            Y - Y (or θ) symmetry.

            Z - Z (or Φ) symmetry.

        inc
            Increment all nodes in the given pattern by INC to form the
            reflected node pattern.

        node1, node2, ninc
            Reflect nodes from pattern beginning with NODE1 to NODE2 (defaults
            to NODE1) in steps of NINC (defaults to 1).  If  NODE1 = ALL, NODE2
            and NINC are ignored and pattern is all selected nodes [NSEL].  If
            NODE1 = P, graphical picking is enabled and all remaining command
            fields are ignored (valid only in the GUI).  A component name may
            also be substituted for NODE1 (NODE2 and NINC are ignored).

        Notes
        -----
        Generates nodes from a given node pattern by a symmetry reflection.
        Reflection is done in the active coordinate system by changing a
        particular coordinate sign.  Nodes in the pattern may have been
        generated in any coordinate system.   Nodal rotation angles are not
        reflected.

        Symmetry reflection may be used with any node pattern, in any
        coordinate system, as many times as desired.  Reflection is
        accomplished by a coordinate sign change (in the active coordinate
        system).  For example, an X-reflection in a Cartesian coordinate system
        generates additional nodes from a given pattern, with a node increment
        added to each node number, and an X coordinate sign change.  An
        R-reflection in a cylindrical coordinate system gives a reflected
        "radial" location by changing the "equivalent" Cartesian (i.e., the
        Cartesian system with the same origin as the active cylindrical system)
        X and Y coordinate signs.  An R-reflection in a spherical coordinate
        system gives a reflected "radial" location by changing the equivalent
        Cartesian X, Y, and Z coordinate location signs.  Nodal coordinate
        system rotation angles are not reflected.
        """
        command = "NSYM,%s,%s,%s,%s,%s" % (str(ncomp), str(inc), str(node1), str(node2), str(ninc))
        return self.run(command, **kwargs)

    def edhist(self, comp="", **kwargs):
        """APDL Command: EDHIST

        Specifies time-history output for an explicit dynamic analysis.

        Parameters
        ----------
        comp
            Name of the component containing nodes or elements for which output
            is desired. Comp is required.

        Notes
        -----
        The time-history output is written to the file Jobname.HIS.  Output is
        written only for the nodes or elements contained in Comp.  The data is
        written at time intervals specified on the EDHTIME command. If no time
        interval is specified, output is written at 1000 steps over the
        analysis. (See also the EDOUT command which controls time-history
        output in ascii form for an explicit dynamics analysis.)

        Use EDHIST,LIST to list the time-history output specification. (The
        listing will include output requested with the EDOUT command.) Use
        EDHIST,DELE to delete the time-history output specification.

        Jobname.HIS is a binary file that is read by the ANSYS time-history
        postprocessor (POST26). If LS-DYNA output has been requested on the
        EDWRITE command [EDWRITE,LSDYNA or EDWRITE,BOTH], the file D3THDT will
        also be written. D3THDT is a binary file that is read by the LS-POST
        postprocessor.

        This command is also valid in PREP7.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDHIST,%s" % (str(comp))
        return self.run(command, **kwargs)

    def pdvar(self, name="", type="", par1="", par2="", par3="", par4="",
              **kwargs):
        """APDL Command: PDVAR

        Specifies the parameters to be treated as probabilistic design
        variables.

        Parameters
        ----------
        name
            Parameter name (must be a scalar ANSYS parameter). The parameter
            must have been previously defined as a random input variable or a
            random output parameter with the PDVAR command. See the *SET
            command for restrictions about ANSYS parameters.

        type
            Probabilistic design variable type. This is the statistical
            distribution type. For more information on each of these types, see
            Probabilistic Design in the Advanced Analysis Guide.

            BETA - Beta distributed random variable.

            PAR1 = Shape parameter. Defaults to 2.0. - PAR2 = Shape parameter. Defaults to 2.0.

            PAR3 = Lower minimum value. Defaults to 0.0.  - PAR4 = Upper maximum value. Defaults to 1.0.

            EXPO - Exponential distributed random variable.

            PAR1 = Decay parameter λ. Must be larger then 0.0 and defaults to 1.0.  - PAR2 = Shift or minimum value. Defaults to 0.0.

            PAR3, PAR4 are ignored. - GAMA

            Gamma distributed random variable. - PAR1 = Decay parameter λ. Must be larger then 0.0 and defaults to 1.0.

            PAR2 = Exponential parameter k. Must be larger then 0.0 and defaults to 1.0.  - PAR3, PAR4 are ignored. Exponential distributed random variable.

            GAUS - Gaussian (Normal) distributed random variable.

            PAR1 = Mean value. Defaults to 0.0. - PAR2 = Standard deviation. Must be larger then 0.0 and defaults to 1.0.

            PAR3, PAR4 are ignored. - LOG1

            Lognormal distributed random variable specified directly with the statistical parameters mean value and standard deviation. - PAR1 = Mean value. Must be larger then 0.0 and defaults to 1.0.

            PAR2 = Standard deviation. Must be larger then 0.0 and defaults to 1.0. - PAR3, PAR4 are ignored.

            LOG2 - Lognormal distributed random variable specified with the statistical parameters
                   mean value and standard deviation of the logarithm of the
                   random values.

            PAR1 and PAR2 must also be defined. PAR1 = Mean value of the logarithm of the data. Defaults to 0.0.  - PAR2 = Standard deviation of the logarithm of the data. Must be larger then 0.0
                              and defaults to 1.0.

            PAR3, PAR4 are ignored. - UNIF

            Uniform distributed random variable. Note that PAR1 must be less than PAR2. - PAR1 = Minimum value. Defaults to 0.0.

            PAR2 = Maximum value. Defaults to 1.0. - PAR3, PAR4 are ignored.

            TGAU - Truncated Gaussian distributed random variable. Note that PAR3 must be less
                   than PAR4.

            PAR1 = Mean value of the untruncated Gaussian distribution. Defaults to 0.0. -  PAR2 = Standard deviation of the untruncated Gaussian distribution. Must be
                              larger then 0.0 and defaults to 1.0.

            PAR3 = Minimum value and lower truncation boundary. Defaults to -3.0. - PAR4 = Maximum value and upper truncation boundary. Defaults to +3.0.

            TRIA - Triangular distributed random variable. Note that PAR1 must be less than PAR2
                   which must be less than PAR3.

            PAR1 = Minimum value. Defaults to 0.0.  - PAR2 = Most Likely Value (MLV). Defaults to 0.5.

            PAR3 = Maximum value. Defaults to 1.0.  - PAR4 is ignored.

            WEIB - Weibull (Type III smallest) distributed random variable. Note that PAR2 must be
                   greater than PAR3. If PAR3 = 0.0, the random distribution is
                   equivalent to a two-parameter Weibull distribution.

            PAR1 = Weibull exponent. Must be larger then 0.0 and defaults to 1.0. - PAR2 = Characteristic value. Must be larger then 0.0 and defaults to 1.0.

            PAR3 = Shift or minimum value. Defaults to 0.0. - PAR4 is ignored.

            RESP - Random output or response parameter.PAR1 to PAR4 are not used.

            DEL - Deletes this probabilistic design variable (does not delete the ANSYS
                  parameter). This option is only valid if the parameter Name
                  was previously defined as a probabilistic design variable
                  (using Type = BETA, ..., WEIB or Type = RESP). The parameter
                  retains the value assigned during the last probabilistic
                  design loop.PAR1 to PAR4 are not used.

        par1, par2, par3, par4
            Parameters of the distribution function. The parameters must be
            specified according to the requirements of the individual
            distribution types described above.

        Notes
        -----
        Specifies the parameters to be treated as probabilistic design
        variables. A random input variable is specified by the name of the
        ANSYS parameter, the type of the distribution function (Type) and its
        distribution parameters (PAR1, ..., PAR4). A random output parameter is
        specified by the name of the ANSYS parameter and the type identifying
        it as a random output parameter (Type = RESP).
        """
        command = "PDVAR,%s,%s,%s,%s,%s,%s" % (str(name), str(type), str(par1), str(par2), str(par3), str(par4))
        return self.run(command, **kwargs)

    def mfimport(self, fnumb="", option="", fname="", ext="", **kwargs):
        """APDL Command: MFIMPORT

        Imports a new field into a current ANSYS Multi-field solver analysis.

        Parameters
        ----------
        fnumb
            Field number specified by the MFELEM command.

        option
            Selects data to read.

            DB - Reads a CDB file. The CDB file name and extension are specified by Fname and
                 Ext.

        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        Notes
        -----
        The field to be imported should be written to a CDB file (CDWRITE
        command). This file is read into the database, offsetting all existing
        element type numbers, node numbers, etc. in order to accommodate the
        imported field. (See the NUMOFF command for information on offset
        capabilities.) It then updates all of the previously issued MFxx
        commands to the new element type numbers. A new field is created using
        the specified field number, which must not currently exist. If there
        are no ANSYS Multi-field solver command files written for the existing
        fields in the database, one will be written for each field with the
        default name (see the MFCMMAND command). A MFCMMAND will be issued for
        the imported field as well.

        Repeat the MFIMPORT command to import additional fields.

        See Multi-field Commands in the Coupled-Field Analysis Guide for a list
        of all ANSYS Multi-field solver commands and their availability for MFS
        and MFX analyses.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "MFIMPORT,%s,%s,%s,%s" % (str(fnumb), str(option), str(fname), str(ext))
        return self.run(command, **kwargs)

    def mcheck(self, lab="", **kwargs):
        """APDL Command: MCHECK

        Checks mesh connectivity.

        Parameters
        ----------
        lab
            Operation:

            ESEL - Unselects the valid elements.

        Notes
        -----
         Wherever two area or volume elements share a common face, MCHECK
        verifies that the way the elements are connected to the face is
        consistent with their relative normals or integrated volumes. (This may
        detect folds or otherwise overlapping elements.)

         MCHECK verifies that the element exterior faces form simply-connected
        closed surfaces. (This may detect unintended cracks in a mesh.)

         MCHECK warns if the number of element facets in a 2-D loop or 3-D
        shell is not greater than a computed limit. This limit is the smaller
        of either three times the number of faces on one element, or one-tenth
        the total number of element faces in the model. (This may detect holes
        in the middle of a mesh.)

        The MCHECK command will perform a number of validity checks on the
        selected elements, including:

        Normal check:  Wherever two area elements share a common edge, MCHECK
        verifies that the ordering of the nodes on each element is consistent
        with their relative normals.

        Volume check:  Wherever two volume elements share a common face, MCHECK
        verifies that the sign of the integrated volume of each element is
        consistent.

        Closed surface check:  MCHECK verifies that the element exterior faces
        form simply-connected closed surfaces (this may detect unintended
        cracks in a mesh).

        Check for holes in the mesh:  MCHECK warns if the number of element
        faces surrounding an interior void in the mesh is small enough to
        suggest one or more accidentally omitted elements, rather than a
        deliberately formed hole. For this test, the number of faces around the
        void is compared to the smaller of a) three times the number of faces
        on one element, or b) one-tenth the total number of element faces in
        the model.
        """
        command = "MCHECK,%s" % (str(lab))
        return self.run(command, **kwargs)

    def sstate(self, action="", cm_name="", val1="", val2="", val3="", val4="",
               val5="", val6="", val7="", val8="", val9="", **kwargs):
        """APDL Command: SSTATE

        Defines a steady-state analysis.

        Parameters
        ----------
        action
            Action to perform for defining or manipulating steady-state
            analysis data:

            DEFINE - Define steady-state analysis data

            LIST - List current steady-state analysis data

            DELETE - Delete steady-state analysis data

        cm_name
            Element component name

        val1, ..., val9
            Input values (based on the Action type)

        Notes
        -----
        The SSTATE command specifies steady-state analysis parameters for the
        given element component. The program runs the steady-state analysis if
        the corresponding element key option is enabled for that element
        component.

        The command supports the following elements:

        SOLID185

        3-D 8-Node Structural Solid

        SOLID186

        3-D 20-Node Structural Solid

        SOLID187

        3-D 10-Node Tetrahedral Structural Solid

        SOLSH190

        3-D 8-Node Structural Solid Shell

        Degenerated shape (prism) option not supported.

        SOLID285

        3-D 4-Node Tetrahedral Structural Solid with Nodal Pressures

        For information about steady-state rolling for rebar and solid
        elements, see Steady State Rolling in the Mechanical APDL Theory
        Reference.

        The following data types can be defined:

        SPIN -- Steady-state spinning motion

        TRANSLATE -- Rigid body motion (velocity) that the spinning component
        is undergoing

        Define the steady-state spinning motion:

        SSTATE, DEFINE, CM_Name, SPIN, OMEGA, Method, Val4, Val5, Val6, Val7,
        Val8, Val9

        Spin velocity

        Method to use for defining the spin axis:

        Define the spin axis using two points:

        Val4, Val5, Val6 -- Coordinates of the first point

        Val7, Val8, Val9 -- Coordinates of the second point

        This definition method is currently the only option.

        This command defines a steady state spinning motion of 120 rad/s around
        the spin axis:

        In this case, two points with coordinates (0,0,0) and (0,1,0) define
        the spin axis in the global Y direction.

        Define the rigid body motion (velocity):

        SSTATE, DEFINE, CM_Name, TRANSLATE, Val2, Val3, Val4

        SSTATE, LIST, CM_Name

        Lists all steady-state analysis data defined on the specified element
        component. All data is listed if no component (CM_Name) is specified.

        SSTATE, DELETE, CM_Name

        Deletes all steady-state analysis data defined on the specified element
        component. All data is deleted if no component (CM_Name) is specified.
        """
        command = "SSTATE,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(action), str(cm_name), str(val1), str(val2), str(val3), str(val4), str(val5), str(val6), str(val7), str(val8), str(val9))
        return self.run(command, **kwargs)

    def cmsopt(self, cmsmeth="", nmode="", freqb="", freqe="", fbddef="",
               fbdval="", iokey="", **kwargs):
        """APDL Command: CMSOPT

        Specifies component mode synthesis (CMS) analysis options.

        Parameters
        ----------
        cmsmeth
            The component mode synthesis method to use. This value is required.

            FIX - Fixed-interface method.

            FREE - Free-interface method.

            RFFB - Residual-flexible free-interface method.

        nmode
            The number of normal modes extracted and used in the superelement
            generation. This value is required; the minimum is 1.

        freqb
            Beginning, or lower end, of frequency range of interest. This value
            is optional.

        freqe
            Ending, or upper end, of frequency range of interest. This value is
            optional.

        fbddef
            In a free-interface (CMSMETH = FREE) or residual-flexible free-
            interface (CMSMETH = RFFB) CMS analysis, the method to use for
            defining free body modes:

            FNUM - The number (FDBVAL) of rigid body modes in the calculation.

            FTOL - Employ a specified tolerance (FDBVAL) to determine rigid body modes in the
                   calculation.

            FAUTO - Automatically determine rigid body modes in the calculation. This method is the
                    default.

            RIGID - If no rigid body modes exist, define your own via the RIGID command.

        fbdval
            In a free-interface CMS analysis (CMSMETH = FREE), the number of
            rigid body modes if FBDDEF = fnum (where the value is an integer
            from 0 through 6), or the tolerance to employ if FBDDEF = ftol
            (where the value is a positive real number representing rad/sec).
            This value is required only when FBDDEF = fnum or FBDDEF = ftol;
            otherwise, any specified value is ignored.

        iokey
            Output key to control writing of the transformation matrix to the
            .TCMS file (FIX or FREE methods) or body properties to the .EXB
            file (FIX method).

            TCMS - Write the transformation matrix of the nodal component defined by the OUTPR
                   command to a .TCMS file. Refer to TCMS File Format in the
                   Programmer's Reference for more information on the this
                   file.

            EXB - Write a body property input file (.EXB file) containing the condensed
                  substructure matrices and other body properties for use with
                  AVL EXCITE. Refer to ANSYS Interface to AVL EXCITE in the
                  Substructuring Analysis Guide for more information.

        Notes
        -----
        CMS employs the Block Lanczos eigensolution method in the generation
        pass.

        CMS supports damping matrix reduction when a damping matrix exists. Set
        the matrix generation key to 3 (SEOPT,Sename,SEMATR) to generate and
        then reduce stiffness, mass, and damping matrices.

        CMS does not support the SEOPT,,,,,RESOLVE command. Instead, ANSYS sets
        the expansion method for the expansion pass (EXPMTH) to BACKSUB.

        For more information about performing a CMS analysis, see Component
        Mode Synthesis in the Substructuring Analysis Guide.

        If IOKEY = TCMS is used to output the transformation matrix, then only
        ITEM = NSOL is valid in the OUTPR command.  In the interactive
        sessions, the transformation matrix will not be output if the model has
        more than 10 elements.

        This command is also valid in /PREP7.
        """
        command = "CMSOPT,%s,%s,%s,%s,%s,%s,%s" % (str(cmsmeth), str(nmode), str(freqb), str(freqe), str(fbddef), str(fbdval), str(iokey))
        return self.run(command, **kwargs)

    def cm(self, cname="", entity="", **kwargs):
        """APDL Command: CM

        Groups geometry items into a component.

        Parameters
        ----------
        cname
            An alphanumeric name used to identify this component. Cname may be
            up to 32 characters, beginning with a letter and containing only
            letters, numbers, and underscores.  Component names beginning with
            an underscore (e.g., _LOOP) are reserved for use by ANSYS and
            should be avoided.  Components named “ALL,” “STAT,” and “DEFA” are
            not permitted. Overwrites a previously defined name.

        entity
            Label identifying the type of geometry items to be grouped:

            VOLU - Volumes.

            AREA - Areas.

            LINE - Lines.

            KP - Keypoints.

            ELEM - Elements.

            NODE - Nodes.

        Notes
        -----
        Components may be further grouped into assemblies [CMGRP].  The
        selected items of the specified entity type will be stored as the
        component.  Use of this component in the select command [CMSEL] causes
        all these items to be selected at once, for convenience.

        A component is a grouping of some geometric entity that can then be
        conveniently selected or unselected.  A component may be redefined by
        reusing a previous component name.  The following entity types may
        belong to a component: nodes, elements, keypoints, lines, areas, and
        volumes.  A component may contain only 1 entity type, but an individual
        item of any entity may belong to any number of components.  Once
        defined, the items contained in a component may then be easily selected
        or unselected [CMSEL].  Components may be listed [CMLIST], modified
        [CMMOD] and deleted [CMDELE].  Components may also be further grouped
        into assemblies [CMGRP].  Other entities associated with the entities
        in a component (e.g., the lines and keypoints associated with areas)
        may be selected by the ALLSEL command.

        An item will be deleted from a component if it has been deleted by
        another operation (see the KMODIF command for an example).  Components
        are automatically updated to reflect deletions of one or more of their
        items.  Components are automatically deleted and a warning message is
        issued if all their items are deleted.  Assemblies are also
        automatically updated to reflect deletions of one or more of their
        components or subassemblies, but are not deleted if all their
        components and subassemblies are deleted.

        This command is valid in any processor.
        """
        command = "CM,%s,%s" % (str(cname), str(entity))
        return self.run(command, **kwargs)

    def del_(self, val1="", val2="", **kwargs):
        """APDL Command: *DEL

        Deletes a parameter or parameters (GUI).

        Parameters
        ----------
        val1
            Command behavior key:

            Delete all user-defined parameters, or all user-defined parameters and all system parameters, as specified by Val2. - Delete the parameter(s) specified by Val2.

        val2
            The parameter or parameters to delete (used only when Val1 = ALL or
            (blank)):

            When Val1 is (blank), specifies the location of the parameter within the Array Parameters dialog box.  The location number is based on an alphabetically ordered list of all parameters in the database.   - When Val1 is ALL, deletes all parameters, including those named with a leading
                              underscore (_) (except _STATUS and _RETURN). When
                              Val1 is (blank), deletes only those parameters
                              named with a leading underscore (_) (except
                              _STATUS and _RETURN).

            When Val1 is (blank), deletes only those parameters named with a trailing underscore (_).  - When Val1 is ALL, a (blank) value for Val2 causes all user-defined parameters
                              to be deleted.

        Notes
        -----
        This is a command generally created by the graphical user interface
        (GUI).  It appears in the log file (Jobname.LOG) if an array parameter
        is deleted from within the Array Parameters dialog.

        Usage examples:

        Delete all user-defined parameters: *DEL,ALL

        Delete only those user-defined parameters named with a trailing
        underscore: *DEL,,PRM_

        Delete all user-defined and all system parameters (except for _STATUS
        and _RETURN): *DEL,ALL,_PRM

        Delete a parameter by specifying its location within the Array
        Parameters dialog: *DEL,,LOC

        Delete a single specified parameter by name: *DEL,ParmName (You cannot
        specify more than one named parameter at a time.)

        This command is valid in any processor.
        """
        command = "*DEL,%s,%s" % (str(val1), str(val2))
        return self.run(command, **kwargs)

    def edenergy(self, hgen="", swen="", sien="", rlen="", **kwargs):
        """APDL Command: EDENERGY

        Specifies energy dissipation controls for an explicit dynamics
        analysis.

        Parameters
        ----------
        hgen
            Hourglass energy control key:

            OFF or 0 - Hourglass energy is not computed.

            ON or 1 - Hourglass energy is computed and included in the energy balance (default).

        swen
            Stonewall energy dissipation control key:

            OFF or 0 - Stonewall energy dissipation is not computed.

            ON or 1 - Stonewall energy dissipation is computed and included in the energy balance
                      (default).

        sien
            Sliding interface energy dissipation control key:

            OFF or 0 - Sliding interface energy dissipation is not computed.

            ON or 1 - Sliding interface energy dissipation is computed and included in the energy
                      balance (default).

        rlen
            Rayleigh (damping) energy dissipation control key:

            OFF or 0 - Rayleigh energy dissipation is not computed.

            ON or 1 - Rayleigh energy dissipation is computed and included in the energy balance
                      (default).

        Notes
        -----
        This command is also valid in PREP7.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDENERGY,%s,%s,%s,%s" % (str(hgen), str(swen), str(sien), str(rlen))
        return self.run(command, **kwargs)

    def tbft(self, oper="", id="", option1="", option2="", option3="",
             option4="", option5="", option6="", option7="", **kwargs):
        """APDL Command: TBFT

        Performs material curve-fitting operations.

        Parameters
        ----------
        oper
            The specific curve-fitting operation:

            Define a constitutive model. - Delete a constitutive model.

            Write data related to a constitutive model to the database (same as TB command). - Initialize coefficients of a constitutive model for nonlinear curve-fitting
                              procedure.

            Deletes coefficients at current reference temperature. Applicable only for temperature dependent coefficients.  - Solve for coefficients.

            Fix (hold constant) the coefficient you specify in Option4. - Add experimental data.

            Delete experimental data. - List all data associated with the material model represented by the material ID
                              number.

        id
            The material reference number (same as MAT argument used in the TB
            command). Valid entry is any number greater than zero (default = 1)
            but less than 100,000.

        option1
            For curve-fit function operations (Oper = FADD, FDEL, FSET, SET,
            CDEL, SOLVE or FIX) this field specifies the category (HYPER).

        option2
            For curve-fit function operations (Oper = FADD, FDEL, FSET, SET,
            CDEL, SOLVE, or FIX), this field specifies constitutive model type.
            The valid entries are listed in Table 231: Hyperelastic Options
            below.

        option3
            For Oper = FADD, FDEL, FSET, CDEL, SET, SOLVE or FIX, some of the
            cases specified in Option2 will require that the polynomial order
            be specified. The applicable values for the order specification are
            listed in Table 231: Hyperelastic Options.

        option4
            When you are working on a specific coefficient (Oper = FIX), this
            field specifies the index of that coefficient. Valid entries vary
            from 1 to n, where n is the total number of coefficients (default =
            1).

        option5
            When you are working on a specific coefficient (Oper = FIX), this
            field specifies the index of that coefficient. Valid entries vary
            from 1 to N, where N is the total number of coefficients (default =
            1)

        option6
            If Oper = SOLVE, specifies the allowed tolerance in residual change
            to stop an iteration. Valid entry is 0.0 to 1.0 (default = 0.0).

        option7
            If Oper = SOLVE, specifies the allowed tolerance in coefficient
            change to stop an iteration. Valid entry is 0 to 1 (default = 0).
        """
        command = "TBFT,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(oper), str(id), str(option1), str(option2), str(option3), str(option4), str(option5), str(option6), str(option7))
        return self.run(command, **kwargs)

    def grtyp(self, kaxis="", **kwargs):
        """APDL Command: /GRTYP

        Selects single or multiple Y-axes graph displays.

        Parameters
        ----------
        kaxis
            Axis selection key:

            0 or 1 - Single Y-axis.  Up to 10 curves scaled to a single Y-axis.

            2 - Additional Y-axes (one for each curve) (3 curves maximum).  Allows better
                scaling of curves with widely differing numbering ranges.

            3 - Same as 2 but with additional Y-axis and curves projected out of the plane (6
                curves maximum).  Allows clearer display with an isometric
                view.  The default view when KAXIS = 3 is View,1,1,2,3.

        Notes
        -----
        The basic line graph has one or more curves plotted against the same Y
        and X axes.  Multiple curve graphs can also be plotted with individual
        Y axes and the same X axis.  The Y axis of the first curve is referred
        to as the base Y-axis and the Y axes of the other curves as additional
        Y axes.  Curves are numbered sequentially from 1 (the base curve) in
        the order in which they are displayed.  See the /AXLAB, /GROPT, /GRID,
        and /GTHK commands for other display options.

        This command is valid in any processor.
        """
        command = "/GRTYP,%s" % (str(kaxis))
        return self.run(command, **kwargs)

    def large(self, ir="", ia="", ib="", ic="", name="", facta="", factb="",
              factc="", **kwargs):
        """APDL Command: LARGE

        Finds the largest (the envelope) of three variables.

        Parameters
        ----------
        ir
            Arbitrary reference number assigned to the resulting variable (2 to
            NV [NUMVAR]).  If this number is the same as for a previously
            defined variable, the previously defined variable will be
            overwritten with this result.

        ia, ib, ic
            Reference numbers of the three variables to be operated on.  If
            only two, leave IC blank.  If only one, leave IB blank also.

        name
            Thirty-two character name for identifying the variable on the
            printout and displays.  Embedded blanks are compressed upon output.

        --, --
            Unused fields.

        facta, factb, factc
            Scaling factors (positive or negative) applied to the corresponding
            variables (default to 1.0).

        Notes
        -----
        Creates a new variable by finding the largest of up to three variables
        according to the operation:

        IR = Largest of (FACTA x IA, FACTB x IB, FACTC x IC)

        The comparison is done at each time location, so that the new variable
        is the "envelope" of the three existing variables.
        """
        command = "LARGE,%s,%s,%s,%s,%s,%s,%s,%s" % (str(ir), str(ia), str(ib), str(ic), str(name), str(facta), str(factb), str(factc))
        return self.run(command, **kwargs)

    def sscale(self, wn="", smult="", **kwargs):
        """APDL Command: /SSCALE

        Sets the contour multiplier for topographic displays.

        Parameters
        ----------
        wn
            Window number (or ALL) to which command applies (defaults to 1).

        smult
            Contour multiplier that factors in results based on the product of
            the multiplier and the result being plotted. Defaults to 0.0 (no
            topographic effects).

        Notes
        -----
        Use this command to scale values to the geometry when the contours are
        shown elevated.  For section displays [/TYPE], the elevation is
        performed perpendicular to the section face.

        Nonzero contour multipliers factoring in large results (stresses or
        displacements) can produce very large distortion, causing images to
        disappear.  To bring a distorted image back into view, reduce the
        contour multiplier value.

        Portions of this command are not supported by PowerGraphics
        [/GRAPHICS,POWER].
        """
        command = "/SSCALE,%s,%s" % (str(wn), str(smult))
        return self.run(command, **kwargs)

    def bsmd(self, dens="", **kwargs):
        """APDL Command: BSMD

        Specifies mass per unit length for a nonlinear general beam section.

        Parameters
        ----------
        dens
            Mass density.

        Notes
        -----
        The BSMD command, one of several nonlinear general beam section
        commands, specifies the mass density (assuming a unit area) for a beam
        section. The value specified is associated with the section most
        recently defined (via the SECTYPE command).

        Related commands are BSAX, BSM1, BSM2, BSTQ, BSS1, BSS2, and BSTE.

        For complete information, see Using Nonlinear General Beam Sections.
        """
        command = "BSMD,%s" % (str(dens))
        return self.run(command, **kwargs)

    def psymb(self, label="", key="", **kwargs):
        """APDL Command: /PSYMB

        Shows various symbols on displays.

        Parameters
        ----------
        label
            Show symbols as selected from the following labels:

            CS - Local coordinate systems.

            NDIR - Nodal coordinate systems (on rotated nodes only).

            ESYS - Element coordinate systems (element displays only).

            LDIR - Line directions (line displays only).

            LDIV - Controls the display of element divisions on lines.

            ADIR - Area direction symbol (for keypoint, line, area and volume plots).

            LAYR - Layer orientations (relative to the projected element x-axis) or fiber
                   orientations in smeared reinforcing elements. Used only
                   within an element display. Use KEY to specify the layer
                   number.

            ECON - Element mesh symbols on keypoints and lines.

            DOT - Larger symbols displayed for node and keypoint locations.  When Label = DOT,
                  KEY = 1 by default.

            XNOD - Extra node of surface or circuit elements.

            FBCS - Force boundary condition scaling. Subsequent KEY value determines whether or
                   not to scale the applied and derived forces/moments to the
                   same maximum value.

            DEFA - Resets the symbol keys so that ANSYS displays none of the symbols controlled by
                   the /PSYMB command.  The value of the KEY field is ignored.

            STAT - Prints the status of the settings of the symbol keys controlled by the /PSYMB
                   command.  The KEY field is ignored.

        key
            Symbol key:

            -1  - Effective only if Label = LAYR and solid shape element display (/ESHAPE) is
                  active. Orientation of all layers appears with the solid
                  shape element display.

            0  - No symbol (default). If Label = LDIV, then KEY= 0 indicates that the displayed
                 element divisions will correspond to the existing mesh (the
                 word MESHED or EXISTING can also be substituted). Also, for
                 Label = LDIV, if you execute any meshing command (such as
                 AMESH or VMESH), KEY is set to 0 (MESHED) automatically. If
                 Label = FBCS, then KEY= 0 indicates that boundary condition
                 scaling will not be common. The applied and derived
                 forces/moments will be scaled to their respective maximum
                 values.

            1  - Include symbol. If Label = LDIV, then KEY = 1 indicates that the displayed line
                 divisions will correspond to the value assigned by LESIZE (the
                 word LESIZE can also be substituted). Also, for Label = LDIV,
                 if you execute the LESIZE command, KEY is set to 1 (LESIZE)
                 automatically. If Label = FBCS, then KEY= 1 indicates that
                 boundary condition scaling will be common. The applied and
                 derived forces/moments will be scaled to the same maximum
                 value.

            N  - If Label = LAYR, then N is equal to the layer number. If Label = DOT, then N
                 can be equal to 0,1,.....15, indicating the dot size. If Label
                 = LDIV, then KEY = -1, indicates that no element divisions
                 will be displayed (the word OFF can also be substituted).

        Notes
        -----
        Includes various symbols on the display.  Triads are right-handed with
        x displayed as the longest leg.  Where color is displayed, x is white,
        y is green, and z is blue.  For beams, x is always along the length of
        the element.   For lines, an arrow represents the direction of a line,
        from the beginning keypoint to the end keypoint.  See /PLOPTS command
        for additional display options.  Use /PSTATUS or /PSYMB,STAT to display
        settings.  Use /PSYMB,DEFA to reset all specifications back to their
        defaults.  The command /PSYMB,ECON,1 causes the symbol "M" to be
        displayed on keypoints and lines associated with meshed entities.  When
        you issue the command /PSYMB,DOT,1, a larger symbol is displayed for
        each node and keypoint location.

        PowerGraphics (/GRAPHICS,POWER) does not support /PSYMB,ESYS and
        /PSYMB,LAYR.

        If KEY = N and PowerGraphics is off, the centroid of the surface
        elements is connected to the extra node using a gray line.  However, if
        PowerGraphics is on, the color of the line connecting the centroid to
        the extra node is the same as that for the elements themselves (as
        determined by /PNUM).

        When Label = LAYR, the layer systems can be visualized with all
        current-technology layered elements and the smeared reinforcing element
        REINF265. To use /PSYMB,LAYR with REINF265, first set the vector-mode
        graphics option (/DEVICE,VECTOR,1).

        This command is valid in any processor.
        """
        command = "/PSYMB,%s,%s" % (str(label), str(key))
        return self.run(command, **kwargs)

    def gap(self, **kwargs):
        """APDL Command: GAP

        Specifies "mode-superposition transient gap conditions" as the
        subsequent status topic.

        Notes
        -----
        This is a status [STAT] topic command.  Status topic commands are
        generated by the GUI and will appear in the log file (Jobname.LOG) if
        status is requested for some items under Utility Menu> List> Status.
        This command will be immediately followed by a STAT command, which will
        report the status for the specified topic.

        If entered directly into the program, the STAT command should
        immediately follow this command.
        """
        command = "GAP," % ()
        return self.run(command, **kwargs)

    def rmuse(self, option="", usefil="", **kwargs):
        """APDL Command: RMUSE

        Activates ROM use pass for ROM elements.

        Parameters
        ----------
        option
            Type of data to be plotted. Valid types are:

            1 or "ON" - Activates ROM use pass.

        usefil
            Name of the reduced displacement file (.rdsp) created by the ROM
            Use Pass (required field only for the Expansion Pass).

        Notes
        -----
        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "RMUSE,%s,%s" % (str(option), str(usefil))
        return self.run(command, **kwargs)

    def fefor(self, **kwargs):
        """APDL Command: FEFOR

        Specifies "Forces on nodes" as the subsequent status topic.

        Notes
        -----
        This is a status [STAT] topic command.  Status topic commands are
        generated by the GUI and will appear in the log file (Jobname.LOG) if
        status is requested for some items under Utility Menu> List> Status.
        This command will be immediately followed by a STAT command, which will
        report the status for the specified topic.

        If entered directly into the program, the STAT command should
        immediately follow this command.
        """
        command = "FEFOR," % ()
        return self.run(command, **kwargs)

    def tallow(self, temp1="", temp2="", temp3="", temp4="", temp5="",
               temp6="", **kwargs):
        """APDL Command: TALLOW

        Defines the temperature table for safety factor calculations.

        Parameters
        ----------
        temp1, temp2, temp3, . . . , temp6
            Input up to six temperatures covering the range of nodal
            temperatures.  Temperatures must be input in ascending order.

        Notes
        -----
        Defines the temperature table for safety factor calculations [SFACT,
        SALLOW].  Use STAT command to list current temperature table.  Repeat
        TALLOW command to zero table and redefine points (6 maximum).

        Safety factor calculations are not supported by PowerGraphics. Both the
        SALLOW and TALLOW commands must be used with the Full Model Graphics
        display method active.
        """
        command = "TALLOW,%s,%s,%s,%s,%s,%s" % (str(temp1), str(temp2), str(temp3), str(temp4), str(temp5), str(temp6))
        return self.run(command, **kwargs)

    def ancntr(self, nfram="", delay="", ncycl="", **kwargs):
        """APDL Command: ANCNTR

        Produces an animated sequence of a contoured deformed shape.

        Parameters
        ----------
        nfram
            Number of frames captures (defaults to 5).

        delay
            Time delay during animation (defaults to 0.1 seconds).

        ncycl
            Number of animation cycles (defaults to 5).  Available in non-UI
            mode only.

        Notes
        -----
        ANCNTR involves an ANSYS macro which produces an animation of a
        contoured deformed shape of the last plot action command.  This command
        operates only on graphic display platforms supporting the /SEG command.
        After executing ANCNTR, you can replay the animated sequence by issuing
        the ANIM command.

        The command functions only in the postprocessor.
        """
        command = "ANCNTR,%s,%s,%s" % (str(nfram), str(delay), str(ncycl))
        return self.run(command, **kwargs)

    def starstatus(self, par="", imin="", imax="", jmin="", jmax="", kmin="",
                   kmax="", lmin="", lmax="", mmin="", mmax="", kpri="",
                   **kwargs):
        """APDL Command: *STATUS

        Lists the current parameters and abbreviations.

        Parameters
        ----------
        par
            Specifies the parameter or sets of parameters listed. For array
            parameters, use IMIN, IMAX, etc. to specify ranges.  Use *DIM to
            define array parameters. Use *VEDIT to review array parameters
            interactively. Use *VWRITE to print array values in a formatted
            output. If Par is blank, list all scalar parameter values, array
            parameter dimensions, and abbreviations.  If ARGX, list the active
            set of local macro parameters (ARG1 to ARG9 and AR10 to AR99)
            [*USE].

            Lists all parameters (except local macro parameters and those with names beginning or ending with an underbar) and toolbar abbreviations. - Lists only parameters with names beginning with an underbar (_). These are
                              ANSYS internal parameters.

            Lists only parameters with names ending with an underbar (_). A good APDL programming convention is to ensure that all parameters created by your system programmer are named with a trailing underbar. - Lists all toolbar abbreviations.

            Lists all parameters (except local macro parameters and those with names beginning or ending with an underbar). - Lists all APDL Math parameters, including vectors, matrices, and linear
                              solvers.

            Lists only the parameter specified. PARNAME cannot be a local macro parameter name. - Lists all local macro parameter values (ARG1- AR99) that are non-zero or non-
                              blank.

        imin, imax, jmin, jmax, kmin, kmax, lmin, lmax, mmin, mmax
            Range of array elements to display (in terms of the dimensions
            (row, column, plane, book, and shelf).   Minimum values default to
            1.  Maximum values default to the maximum dimension values.  Zero
            may be input for IMIN, JMIN, and KMIN to display the index numbers.
            See *TAXIS  command to list index numbers of 4- and 5-D tables.

        kpri
            Use this field to list your primary variable labels (X, Y, Z, TIME,
            etc.).

            List the labels (default). YES, Y, or ON are also valid entries.  - Do not list the labels. NO, N, or OFF are also valid entries.

        Notes
        -----
        You cannot obtain the value for a single local parameter (e.g.,
        *STATUS,ARG2). You can only request all local parameters simultaneously
        using *STATUS,ARGX.

        This command is valid in any processor.
        """
        command = "*STATUS,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(par), str(imin), str(imax), str(jmin), str(jmax), str(kmin), str(kmax), str(lmin), str(lmax), str(mmin), str(mmax), str(kpri))
        return self.run(command, **kwargs)

    def magsolv(self, opt="", nramp="", cnvcsg="", cnvflux="", neqit="",
                biot="", cnvtol="", **kwargs):
        """APDL Command: MAGSOLV

        Specifies magnetic solution options and initiates the solution.

        Parameters
        ----------
        opt
            Static magnetic solution option:

            0 - Vector potential (MVP) or edge formulation  (default).

            1 - Combined vector potential and reduced scalar potential (MVP-RSP).

            2 - Reduced scalar potential (RSP).

            3 - Difference scalar potential (DSP).

            4 - General scalar potential (GSP).

        nramp
            Number of ramped substeps for the first load step of a nonlinear
            MVP or MVP-RSP solution.  Defaults to 3.  If NRAMP = -1, ignore the
            ramped load step entirely.NRAMP is ignored for linear
            magnetostatics.

        cnvcsg
            Tolerance value on the program-calculated reference value for the
            magnetic current-segment convergence.  Used for the MVP, the MVP-
            RSP, and the edge formulation solution options (OPT = 0 and 1).
            Defaults to 0.001.

        cnvflux
            Tolerance value on the program-calculated reference value for the
            magnetic flux convergence.  Used for all scalar potential solution
            options (OPT = 2, 3, 4).  Defaults to 0.001.

        neqit
            Maximum number of equilibrium iterations per load step.  Defaults
            to 25.

        biot
            Option to force execution of a Biot-Savart integral solution
            [BIOT,NEW] for the scalar potential options.  Required if multiple
            load steps are being performed with different current source
            primitives (SOURC36 elements).

            0 - Do not force execution of Biot-Savart calculation (default); Biot-Savart is
                automatically calculated only for the first solution.

            1 - Force execution of Biot-Savart calculation.

        cnvtol
            Sets the convergence tolerance for AMPS reaction. Defaults to 1e-3.

        Notes
        -----
        MAGSOLV invokes an ANSYS macro which specifies magnetic solution
        options and initiates the solution.  The macro is applicable to any
        ANSYS magnetostatic analysis using the magnetic vector potential (MVP),
        reduced scalar potential (RSP), difference scalar potential (DSP),
        general scalar potential (GSP), or combined MVP-RSP formulation
        options.  Results are only stored for the final converged solution.
        (In POST1, issue *SET,LIST to identify the load step of solution
        results.)  The macro internally determines if a nonlinear analysis is
        required based on magnetic material properties.

        If you use the BIOT option and issue SAVE after solution or
        postprocessing, the Biot-Savart calculations are saved to the database,
        but will be overwritten upon normal exit from the program.  To save
        this data after issuing SAVE, use the /EXIT,NOSAVE command.  You can
        also issue the /EXIT,SOLU command to exit ANSYS and save all solution
        data, including the Biot-Savart calculations, in the database.
        Otherwise, when you issue RESUME, the Biot-Savart calculation will be
        lost (resulting in a zero solution).

        The MVP, MVP-RSP, and edge formulation options perform a two-load-step
        solution sequence.  The first load step ramps the applied loads over a
        prescribed number of substeps (NRAMP), and the second load step
        calculates the converged solution.  For linear problems, only a single
        load step solution is performed.  The ramped load step can be bypassed
        by setting NRAMP to -1.

        The RSP option solves in a single load step using the adaptive descent
        procedure.  The DSP option uses two load steps, and the GSP solution
        uses three load steps.

        The following analysis options and nonlinear options are controlled by
        this macro:  KBC, NEQIT, NSUBST, CNVTOL, NROPT, MAGOPT, and OUTRES.

        You cannot use constraint equations with OPT = 4.
        """
        command = "MAGSOLV,%s,%s,%s,%s,%s,%s,%s" % (str(opt), str(nramp), str(cnvcsg), str(cnvflux), str(neqit), str(biot), str(cnvtol))
        return self.run(command, **kwargs)

    def clear(self, read="", **kwargs):
        """APDL Command: /CLEAR

        Clears the database.

        Parameters
        ----------
        read
            File read option:

            START - Reread start162.ans file (default).

            NOSTART - Do not reread start162.ans file.

        Notes
        -----
        Resets the ANSYS database to the conditions at the beginning of the
        problem.  Sets the import and Boolean options back to the ANSYS
        default. All items are deleted from the database and memory values are
        set to zero for items derived from database information.  All files are
        left intact.  This command is useful between multiple analyses in the
        same run, or between passes of a multipass analysis (such as between
        the substructure generation, use, and expansion passes).  Should not be
        used in a do-loop since loop counters will be reset.  The start162.ans
        file will be reread (by default) after the database is cleared, unless
        Read is set to NOSTART.  Additional commands cannot be stacked (using
        the $ separator) on the same line as the /CLEAR command.

        Use care when placing the /CLEAR command within branching constructs
        (for example, those employing *DO or *IF commands).  The command
        deletes all parameters including the looping parameter for do-loops.
        (You can preserve your iteration parameter by issuing a PARSAV command
        prior to the /CLEAR command, then following the /CLEAR command with a
        PARRES command.)

        /CLEAR resets the jobname to match the currently open session .LOG and
        .ERR files. This will return the jobname to its original value, or to
        the most recent value specified on /FILNAME with KEY = 1.

        This command is valid only at the Begin level.
        """
        command = "/CLEAR,%s" % (str(read))
        return self.run(command, **kwargs)

    def hrexp(self, angle="", **kwargs):
        """APDL Command: HREXP

        Specifies the phase angle for the harmonic analysis expansion pass.

        Parameters
        ----------
        angle
            Phase angle (degrees) for expansion pass.  If ALL (default), use
            both 0.0° (real) and 90.0° (imaginary) phase angles.

        Notes
        -----
        Specifies the phase angle where the expansion pass will be done for a
        harmonic mode-superposition expansion pass.

        For a specific angle, the following real solution is stored in the
        results (*.rst) file:

        Where:

        i is the degree of freedom number.

         is the amplitude of the i th degree of freedom solution

        Φi is the phase shift angle of the i th degree of freedom solution

        ϕ is the supplied phase shift angle (ANGLE)

        If ANGLE is ALL, both the real and imaginary parts of the solution are
        stored in the results file.

        For more details about the solution equations, see Harmonic Analyses in
        the Mechanical APDL Theory Reference.

        This command is ignored if the HROPT command has been issued with
        Method = VT or Method = VTRU.

        This command is also valid in PREP7.
        """
        command = "HREXP,%s" % (str(angle))
        return self.run(command, **kwargs)

    def ealive(self, elem="", **kwargs):
        """APDL Command: EALIVE

        Reactivates an element (for the birth and death capability).

        Parameters
        ----------
        elem
            Element to be reactivated:

            ALL  - Reactivates all selected elements (ESEL).

            P  - Enables graphical picking of elements. All remaining command fields are
                 ignored. (Valid only in the ANSYS GUI.)

            Comp - Specifies a component name.

        Notes
        -----
        Reactivates the specified element when the birth and death capability
        is being used. An element can be reactivated only after it has been
        deactivated (EKILL).

        Reactivated elements have a zero strain (or thermal heat storage, etc.)
        state.

        ANSYS, Inc. recommends using the element deactivation/reactivation
        procedure for analyses involving linear elastic materials only. Do not
        use element deactivation/reactivation in analyses involving time-
        dependent materials, such as viscoelasticity, viscoplasticity, and
        creep analysis.

        This command is also valid in PREP7.
        """
        command = "EALIVE,%s" % (str(elem))
        return self.run(command, **kwargs)

    def secstop(self, dof1="", minvalue1="", maxvalue1="", dof2="",
                minvalue2="", maxvalue2="", dof3="", minvalue3="",
                maxvalue3="", **kwargs):
        """APDL Command: SECSTOP

        Specifies stops on the components of relative motion in a joint
        element.

        Parameters
        ----------
        dof
            Local degree of freedom to be stopped.

        minvalue
            Low end of the range of allowed movement for the specified DOF.

        maxvalue
            High end of the range of allowed movement for the specified DOF.

        Notes
        -----
        Stops restrict motion in a DOF; motion beyond the MINVALUE or MAXVALUE
        is prevented (motion away from a limit is allowed). You can specify up
        to three stops. If necessary, you can repeat the command.
        """
        command = "SECSTOP,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(dof1), str(minvalue1), str(maxvalue1), str(dof2), str(minvalue2), str(maxvalue2), str(dof3), str(minvalue3), str(maxvalue3))
        return self.run(command, **kwargs)

    def inistate(self, action="", val1="", val2="", val3="", val4="", val5="",
                 val6="", val7="", val8="", val9="", **kwargs):
        """APDL Command: INISTATE

        Defines initial state data and parameters.

        Parameters
        ----------
        action
            Specifies action for defining or manipulating initial state data:

            SET - Use Action = SET to designate initial state coordinate system, data type, and
                  material type parameters. See "Command Specification for
                  Action = SET".

            DEFINE - Use Action = DEFINE to specify the actual state values, and the corresponding
                     element, integration point, or layer information. See
                     "Command Specifications for Action = DEFINE".

            WRITE - Use Action = WRITE to write the initial state values to a file when the SOLVE
                    command is issued. See "Command Specifications for Action =
                    WRITE".

            READ - Use Action = READ to read the initial state values from a file. See "Command
                   Specifications for Action = READ".

            LIST - Use Action = LIST  to read out the initial state data. See "Command
                   Specifications for Action = LIST".

            DELETE - Use Action = DELE to delete initial state data from a selected set of elements.
                     See "Command Specifications for Action = DELETE"

        val1, val2, ..., val9
            Input values based on the Action type.

        Notes
        -----
        The INISTATE command is available for current-technology elements.
        Initial state supported for a given element is indicated in the
        documentation for the element under “Special Features.”

        The command is not for use with kinematic hardening material properties
        (TB,BKIN, TB,KINH, TB,PLAS,,,,KINH) or the shape memory alloy material
        model (TB,SMA).

        INISTATE with elastic strain alone is not supported for gasket
        materials (TB,GASK) and hyperelastic materials (TB,HYPER, TB,BB,
        TB,AHYPER, TB,CDM, TB,EXPE).

        INISTATE with initial stress alone is not supported for gasket
        materials (TB,GASK).

        INISTATE with plastic strain (which must include initial strain or
        stress, plastic strain, and accumulated plastic strain) does not
        support gasket materials (TB,GASK), porous media (TB,PM), rate-
        dependent plasticity (TB,RATE), and viscoplasticity (TB,PRONY,
        TB,SHIFT).

        For detailed information about using the initial state capability, see
        Initial State in the Basic Analysis Guide.
        """
        command = "INISTATE,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(action), str(val1), str(val2), str(val3), str(val4), str(val5), str(val6), str(val7), str(val8), str(val9))
        return self.run(command, **kwargs)

    def plnear(self, lab="", opt="", kcn="", val1="", val2="", val3="",
               val4="", val5="", val6="", val7="", val8="", val9="", **kwargs):
        """APDL Command: PLNEAR

        Plots the pressure in the near zone exterior to the equivalent source
        surface.

        Parameters
        ----------
        lab
            Plot the maximum pressure or sound pressure level:

            SPHERE - on the spherical structure

            PATH - along the path

        opt
            PSUM

            PSUM  - Maximum complex pressure for acoustics.

            PHAS  - Phase angle of complex pressure for acoustics.

            SPL  - Sound pressure level for acoustics.

            SPLA - A-weighted sound pressure level for acoustics (dBA).

        kcn
            KCN is the coordinate system reference number. It may be 0
            (Cartesian) or any previously defined local coordinate system
            number (>10). Defaults to 0.

        val1, val2, val3, . . . , val9
            For LAB = SPHERE:

            VAL1 - Radius of spherical surface in spherical coordinate system.

            VAL2 - Starting φ angle (degree) in the spherical coordinate system. Defaults to 0.

            VAL3 - Ending φ angle (degree) in the spherical coordinate system. Defaults to 0.

            VAL4 - Number of divisions between the starting and ending φ angles for data
                   computations. Defaults to 0.

            VAL5 - Starting θ angle (degrees) in the spherical coordinate system. Defaults to 0 in
                   3-D and 90 in 2-D extension.

            VAL6 - Ending θ angle (degrees) in the spherical coordinate system. Defaults to 0 in
                   3-D and 90 in 2-D extension.

            VAL7 - Number of divisions between the starting and ending θ angles for data
                   computations. Defaults to 0.

            VAL8 - Reference rms sound pressure. Defaults to 2x10-5 Pa.

            VAL9 - Thickness of 2-D model extension in z direction (defaults to 0).

        Notes
        -----
        PLNEAR uses the equivalent source principle to calculate the pressure
        in the near zone exterior to the equivalent source surface (flagged
        with the Maxwell surface flag in the preprocessor) for one of the
        following locations:

        A spherical surface in the KCN coordinate system

        A path defined by the PATH and PPATH commands

        To plot the pressure results for a path, use the PLPAGM or PLPATH
        commands. See the HFSYM command for the model symmetry.

        To retrieve saved equivalent source data, issue the
        SET,Lstep,Sbstep,,REAL command.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "PLNEAR,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(lab), str(opt), str(kcn), str(val1), str(val2), str(val3), str(val4), str(val5), str(val6), str(val7), str(val8), str(val9))
        return self.run(command, **kwargs)

    def escheck(self, sele="", levl="", defkey="", **kwargs):
        """APDL Command: ESCHECK

        Perform element shape checking for a selected element set.

        Parameters
        ----------
        sele
            Specifies whether to select elements for checking:

            (blank) - List all warnings/errors from element shape checking.

            ESEL - Select the elements based on the .Levl criteria specified below.

        levl
            WARN

            WARN - Select elements producing warning and error messages.

            ERR - Select only elements producing error messages (default).

        defkey
            Specifies whether check should be performed on deformed element
            shapes. .

            0 - Do not update node coordinates before performing shape checks (default).

            1 - Update node coordinates using the current set of deformations in the database.

        Notes
        -----
        Shape checking will occur according to the current SHPP settings.
        Although ESCHECK is valid in all processors, Defkey  uses the current
        results in the database. If no results are available a warning will be
        issued.

        This command is also valid in PREP7, SOLUTION and POST1.
        """
        command = "ESCHECK,%s,%s,%s" % (str(sele), str(levl), str(defkey))
        return self.run(command, **kwargs)

    def starexit(self, **kwargs):
        """APDL Command: *EXIT

        Exits a do-loop.

        Notes
        -----
        The command following the *ENDDO is executed next. The exit option may
        also be conditional [Use the *IF].  The *EXIT command must appear on
        the same file as the  *DO command.

        This command is valid in any processor.
        """
        command = "*EXIT," % ()
        return self.run(command, **kwargs)

    def color(self, lab="", clab="", n1="", n2="", ninc="", **kwargs):
        """APDL Command: /COLOR

        Specifies the color mapping for various items.

        Parameters
        ----------
        lab
            Apply color to the items specified by the following labels:

            AXES - Determines the color (specified in next argument, Clab) that the axes of a
                   graph will be plotted in.

            AXNUM - Determines the color (specified in next argument, Clab) that the numbering on
                    the axes of a graph will be plotted in.

            NUM - Discretely numbered items (such as element types, element materials, etc., as
                  shown on the /PNUM command).  Also specify number (1 to 11)
                  in the N1 field.  For example, /COLOR,NUM,RED,3 will assign
                  the color red to all items having the discrete number 3
                  (material displays would show elements having material 3 as
                  red).

            OUTL - Outline of elements, areas, and volumes.  Ex: /COLOR,OUTL,BLUE.

            ELEM - Elements. Use N1, N2, NINC fields for element numbers.

            LINE - Solid model lines.  Use N1, N2, NINC fields for line numbers.

            AREA - Solid model areas.  Use N1, N2, NINC fields for area numbers.

            VOLU - Solid model volumes.  Use N1, N2, NINC fields for volume numbers.

            ISURF - Isosurfaces (surfaces of constant stress, etc.).   This option is particularly
                    useful when capturing frames for animating a single
                    isosurface value.

            WBAK - Window background.  Use N1, N2, NINC fields for window numbers. The options
                   that you select using Lab = PBAK will supersede those
                   applied using Lab = WBAK.

            b.c.label - Boundary condition label.  Enter U, ROT, TEMP, PRES, V, VOLT, MAG, A, EMF,
                        CURR, F, M, HEAT, FLOW, VF, AMPS, FLUX, CSG, CURT,
                        VLTG, MAST, CP, CE, NFOR, NMOM, RFOR, RMOM, PATH. See
                        the /PBC command for boundary condition label
                        definitions.

            GRBAK - Graph background.

            GRID - Graph grid lines.

            AXLAB - Graph X and Y axis labels.

            CURVE - Graph curves (identify curve numbers (1-10) in N1, N2, NINC fields).

            CM - Component group.  Use N1 field for component name, ignore N2 and NINC.

            CNTR - ANSYS contour stress colors.  The maximum number of contours available is 128.
                   The number of colors that can be specified interactively
                   (GUI) is 9. (/CONTOUR, , 9). Any other setting will yield
                   inconsistent results.

            SMAX - Specifies that all stress values above the maximum value entered in /CONTOUR
                   will be displayed in the color designated in the Clab field.
                   Defaults to dark grey.

            SMIN - Specifies that all stress values below the minimum value entered in /CONTOUR
                   will be displayed in the color designated in the Clab field.
                   Defaults to dark grey.

            PBAK - Activates background shading options (see command syntax at end of argument
                   descriptions below). The options that you select using Lab =
                   PBAK will supersede those applied using Lab = WBAK.

        clab
            Valid color labels are:

            BLAC (0) - Black

            MRED (1) - Magenta-Red

            MAGE (2) - Magenta

            BMAG (3) - Blue-Magenta

            BLUE (4) - Blue

            CBLU (5) - Cyan-Blue

            CYAN (6) - Cyan

            GCYA ((7) - Green-Cyan

            GREE (8) - Green

            YGRE (9) - Yellow-Green

            YELL (10) - Yellow

            ORAN (11) - Orange

            RED (12) - Red

            DGRA (13) - Dark Gray

            LGRA (14) - Light Gray

            WHIT (15) - White

        n1, n2, ninc
            Apply color to Lab items numbered N1 to N2 (defaults to N1) in
            steps of NINC (defaults to 1).  If N1 is blank, apply color to
            entire selected range.  If Lab is CM, use component name for N1 and
            ignore N2 and NINC.  If N1 = P, graphical picking of elements,
            lines, areas and volumes is enabled; your can assign colors to the
            entities via the picker. When picking is enabled, the Lab and Clab
            fields are ignored.
        """
        command = "/COLOR,%s,%s,%s,%s,%s" % (str(lab), str(clab), str(n1), str(n2), str(ninc))
        return self.run(command, **kwargs)

    def dig(self, node1="", node2="", ninc="", **kwargs):
        """APDL Command: DIG

        Digitizes nodes to a surface.

        Parameters
        ----------
        node1, node2, ninc
            Digitize nodes NODE1 through NODE2 in steps of NINC.  NODE2
            defaults to NODE1 and NINC defaults to 1.

        Notes
        -----
        Digitizes nodes to the surface defined by the DSURF command.  The nodes
        indicated must be digitized from the tablet after this command is
        given.  The program must be in the interactive mode and the graphics
        terminal show option [/SHOW] must be active.  The global Cartesian
        coordinates of the nodes are stored.
        """
        command = "DIG,%s,%s,%s" % (str(node1), str(node2), str(ninc))
        return self.run(command, **kwargs)

    def anstoasas(self, fname="", key="", **kwargs):
        """APDL Command: ANSTOASAS

        Creates an ASAS input file from the current ANSYS model.

        Parameters
        ----------
        fname
            ASAS file name. Defaults to Jobname.

        key
            Key indicating type of file to produce:

            0 - ASAS file for use by ANSYS Aqwa (no loads written). Creates the file
                Fname.asas.

            1 - ASAS file (all data written, including loads). Creates the file Fname.asas.

            2 - ASAS(NL) file. Creates the file Fname.asnl.

        Notes
        -----
        This command creates an input file for the ANSYS Asas Finite Element
        Analysis System from the model and loads currently in the database,
        based on the currently selected set of elements. Most common structural
        element types are written, as well as sections (or real constants),
        materials, boundary conditions and loads, and solution and load step
        options.

        Data Written

        The following data is written:

        Solution control options

        Nodes

        Elements

        Material data

        Geometry data

        Section data

        ANSYS element components (ASAS sets)

        Boundary conditions

        Loads

        Added mass (via MASS21 element)

        Details are provided in the following sections.

        Not all data is written. You must verify the completeness and accuracy
        of the data. Only loading at the current step is transferred; hence, no
        load step history is captured.

        Solution Control Options

        The ASAS project name is defined as "ANSYS".

        The solution control options are converted as follows:

        JOB: STAT SPIT: KGEOM

        JOB: STAT SPIT: KGEOM

        For conversion to ASAS(NL), the large displacement option is set based
        on NLGEOM, final load solution time is set based on TIME, and sub-step
        times are set based on DELTIM or NSUBST (assuming constant step size).

        Element Data

        If you intend to use the data only with AQWA-WAVE, only the elements
        that form the wetted surface are required.  Selecting these elements
        before invoking the ANSTOASAS command will improve performance.  In
        order for AQWA-WAVE to identify the direction of the wave loading, all
        elements must be defined by nodes in a clockwise direction. For further
        information, refer to the AQWA-WAVE manual.

        The element types are converted as follows:

        SPR1:  SPR2: if: rotational: spring:  FLA2: (ASAS(L): only):  if:
        nodes: are: not: coincident:  and: longitudinal: spring:

        QUM4:  TRM3: -: if: Triangular

        BRK8:  TET4: -: if: Tetrahedral:  BRK6: -: if: Prism

        QUS4:  TBC3: -: if: Triangular

        QUM8:  TRM6: -: if: Triangular

        BR20:  TE10: -: if: Tetrahedral: :  BR15: -: if: Prism

        QUS4:  TBC3: -: if: Triangular

        QUM4:  TRM3: -: if: Triangular

        QUM8:  TRM6: -: if: Triangular

        BRK8:  TET4: -: if: Tetrahedral:  BRK6: -: if: Prism

        BR20:  TE10: -: if: Tetrahedral:  BR15: -: if: Prism

        TCBM: -: if: ASAS(L):  STF4: -: if: ASAS(NL)

        Documentation for this legacy element type appears in the Feature
        Archive.

        Material Data

        Linear isotropic material conversion is supported for ASAS and
        ASAS(NL).

        Geometry Data
        """
        command = "ANSTOASAS,%s,%s" % (str(fname), str(key))
        return self.run(command, **kwargs)

    def mshcopy(self, keyla="", laptrn="", lacopy="", kcn="", dx="", dy="",
                dz="", tol="", low="", high="", **kwargs):
        """APDL Command: MSHCOPY

        Simplifies the generation of meshes that have matching node element
        patterns on two different line groups (in 2-D) or area groups (3-D).

        Parameters
        ----------
        keyla
            Copy line mesh (default) if LINE, 0 or 1. Copy area mesh if AREA,
            or 2.

        laptrn
            Meshed line/area to be copied, or a component name containing a
            list. If LAPTRN = P, graphical picking is enabled (valid only in
            the GUI).

        lacopy
            Unmeshed line/area to get copied mesh, or a component name
            containing a list. If LACOPY = P, graphical picking is enabled
            (valid only in the GUI).

        kcn
            In coordinate system KCN, LAPTRN + DX DY DZ = LACOPY.

        dx, dy, dz
            Node location increments in the active coordinate system (DR, Dθ,
            DZ for cylindrical, DR, Dθ, DΦ for spherical or toroidal).

        tol
            Tolerance. Defaults to 1.e--4.

        low
            Name of low node component to be defined (optional).

        high
            Name of high node component to be defined (optional).

        Notes
        -----
        Matching meshes are used for rotational (cyclic) symmetry, or for
        contact analysis using coupling or node-to-node gap elements. See Using
        CPCYC and MSHCOPY Commands in the Modeling and Meshing Guide for more
        information.
        """
        command = "MSHCOPY,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(keyla), str(laptrn), str(lacopy), str(kcn), str(dx), str(dy), str(dz), str(tol), str(low), str(high))
        return self.run(command, **kwargs)

    def edipart(self, part="", option="", cvect="", tm="", ircs="", ivect="",
                vvect="", cid="", **kwargs):
        """APDL Command: EDIPART

        Defines inertia for rigid parts in an explicit dynamics analysis.

        Parameters
        ----------
        part
            Part number for which the inertia is defined (the part number must
            have been previously generated using the EDPART command).  The part
            should be composed of a rigid material (EDMP,RIGID). For Option =
            ADD, you must input a value; there is no default. For Option = DELE
            or LIST, PART defaults to all parts.

        option


            ADD - Define inertia for the specified PART (default).

            DELE - Delete the inertia properties for the specified PART. The remaining fields are
                   ignored. If PART is blank, inertia properties previously
                   specified using EDIPART are deleted for all rigid parts.

            LIST - List the inertia properties for the specified PART. The remaining fields are
                   ignored. If PART is blank, inertia properties are listed for
                   all rigid parts.

        cvect
            The vector containing the global Cartesian coordinates of the
            center of mass for the part. This vector must have been previously
            defined with a dimension of three (*DIM command) and filled in as
            shown below. If Cvect is blank, the global Cartesian origin (0,0,0)
            is used as the center of mass.

        tm
            Translation mass (no default, must be defined).

        ircs
            Flag for inertia tensor reference coordinate system.

            0 (or blank) - Global inertia tensor (default). You must supply all six inertia tensor
                           components (see Ivect).

            1 - Principal moments of inertia with orientation vectors. You must supply IXX,
                IYY, IZZ (see Ivect) and CID.

        ivect
            The name of a vector containing the components of the inertia
            tensor. This vector must have been previously defined (*DIM
            command) with a dimension of six and filled in as shown below.
            Vector entries 2, 3, and 5 are ignored if IRCS = 1. There is no
            default for this vector; it must be specified.

        vvect
            The name of a vector containing the initial velocity (relative to
            the global Cartesian coordinate system) of the rigid part. This
            vector must have been previously defined (*DIM command) with a
            dimension of six and filled in as shown below. If Vvect is blank,
            the initial velocity defaults to zero.

        cid
            Local coordinate system ID. This coordinate system must have been
            previously defined with the EDLCS command. You must input CID if
            IRCS = 1 (no default).

        Notes
        -----
        The EDIPART command applies only to rigid parts (EDMP,RIGID). It allows
        you to input the inertia properties for the rigid part rather than
        having the program calculate the properties from the finite element
        mesh.

        This command is also valid in Solution.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDIPART,%s,%s,%s,%s,%s,%s,%s,%s" % (str(part), str(option), str(cvect), str(tm), str(ircs), str(ivect), str(vvect), str(cid))
        return self.run(command, **kwargs)

    def rmlvscale(self, nload="", fact1="", fact2="", fact3="", fact4="",
                  fact5="", **kwargs):
        """APDL Command: RMLVSCALE

        Defines element load vector scaling for a ROM use pass.

        Parameters
        ----------
        nload
            Total number of load cases to be considered within a ROM use pass.
            If Nload = "DELETE", all defined load vectors are deleted.

        fact1, fact2, fact3, . . . , fact5
            Scale factors applied to load vectors (maximum 5). Defaults to 0.

        Notes
        -----
        Specifies the element load scale factor applied to a ROM analysis use
        pass.  Element load vectors are extracted from a Static Analysis using
        the RMNDISP command. Up to 5 element load vectors may be scaled and
        applied to a ROM use pass.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "RMLVSCALE,%s,%s,%s,%s,%s,%s" % (str(nload), str(fact1), str(fact2), str(fact3), str(fact4), str(fact5))
        return self.run(command, **kwargs)

    def prenergy(self, energytype="", cname1="", cname2="", cname3="",
                 cname4="", cname5="", cname6="", **kwargs):
        """APDL Command: PRENERGY

        Prints the total energies of a model or the energies of the specified
        components.

        Parameters
        ----------
        energytype
            Type of energies to be printed:

            ALL - All energies are printed: potential, kinetic, artificial hourglass/drill
                  stiffness, contact stabilization energy, and artificial
                  stabilization energy when applicable. This is the default.

            SENE - Potential energy.

            KENE - Kinetic energy.

        cname1, cname2, cname3,…
            Component names for energies of the components printout.

        Notes
        -----
        The PRENERGY command prints out either the total energies of the entire
        model or the energies of the components depending on the Cname1
        specification.

        Only existing components based on elements (defined with the CM
        command) are supported when component energies are listed.

        This command applies to structural elements only.
        """
        command = "PRENERGY,%s,%s,%s,%s,%s,%s,%s" % (str(energytype), str(cname1), str(cname2), str(cname3), str(cname4), str(cname5), str(cname6))
        return self.run(command, **kwargs)

    def ednb(self, option="", cname="", ad="", _as="", **kwargs):
        """APDL Command: EDNB

        Defines a nonreflecting boundary in an explicit dynamic analysis.

        Parameters
        ----------
        option
             Label identifying the nonreflecting boundary option to be
            performed.

            ADD - Define a nonreflecting boundary (default).

            DELE - Delete a nonreflecting boundary.

            LIST - List all defined nonreflecting boundaries (remaining fields are ignored).

        cname
            Name of existing nodal component to which the nonreflecting
            boundary is to be added or deleted. For Option = DELE, use Cname =
            ALL to delete all defined nonreflecting boundaries.

        ad
            Activation flag for dilatational waves (dampers normal to waves).

            0 - Dilatational activation flag is off (default).

            1 - Dilatational activation flag is on.

        as
            Activation flag for shear waves (dampers tangent to waves).

            0 - Shear activation flag is off (default).

            1 - Shear activation flag is on.

        Notes
        -----
        Nonreflecting boundaries can be defined on the external surfaces of
        SOLID164 and SOLID168 elements that are being used to model an infinite
        domain. They are typically used in geomechanical applications to limit
        the size of the model. For example, when a half space is being modeled
        with a finite geometry, the nonreflecting boundary option can be used
        to prevent artificial stress wave reflections generated at the boundary
        from reentering the model and contaminating the results.

        When using nonreflecting boundaries, you should not constrain the nodes
        at the boundary; doing so would negate the presence of the dampers.
        Usually, the large mass of the finite domain is sufficient to resist
        motion.

        This command is also valid in SOLUTION.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDNB,%s,%s,%s,%s" % (str(option), str(cname), str(ad), str(_as))
        return self.run(command, **kwargs)

    def annot(self, lab="", val1="", val2="", **kwargs):
        """APDL Command: /ANNOT

        Activates graphics for annotating displays (GUI).

        Parameters
        ----------
        lab
            Annotation control key:

            OFF - Turns off annotation for each subsequent display (default).

            ON - Turns on annotation for each subsequent display.

            DELE - Deletes all annotation.

            SAVE - Saves annotation on a file.  Use VAL1 for file name (defaults to Jobname) and
                   VAL2 for the extension (defaults to ANO).

            SCALE - Sets annotation scale factor (direct input only).  Use VAL1 for value (0.1 to
                    10.0) (defaults to 1.0).

            XORIG - Sets the annotation x origin (direct input only).  Use VAL1 for value (-3.0 to
                    3.0).

            YORIG - Sets annotation y origin (direct input only).  Use VAL1 for value (-3.0 to
                    3.0).

            SNAP - Sets annotation snap (menu button input only).  Use VAL1 for value (0.002 to
                   0.2) (defaults to 0.002).

            STAT - Displays current annotation status.

            DEFA - Sets annotation specifications to the default values.

            REFR - Redisplays annotation graphics.

            TMOD - Sets the annotation text mode. If VAL1 = 1, annotation text will be drawn in
                   scalable bitmap fonts (default). If VAL1 = 0, annotation
                   text will be drawn with stroke text.

        val1
            Value (or file name) as noted with label above.

        val2
            Value (or file name extension) as noted with label above.

        Notes
        -----
        This is a command generated by the GUI and will appear in the log file
        (Jobname.LOG) if annotation is used.  This command is not intended to
        be typed in directly in an ANSYS session (although it can be included
        in an input file for batch input or for use with the /INPUT command).

        You cannot use the “!” and “$” characters in ANSYS text annotation.

        /ANNOT activates annotation graphics for adding annotation to displays.
        Commands representing the annotation instructions are automatically
        created by the annotation functions in the GUI and written to
        Jobname.LOG.  The annotation commands are /ANNOT, /ANUM, /TLABEL,
        /LINE, /LARC, /LSYMBOL, /POLYGON, /PMORE, /PCIRCLE, /PWEDGE, /TSPEC,
        /LSPEC, and /PSPEC.  Annotation graphics are relative to the full
        Graphics Window and are not affected by ANSYS window-specific commands
        (/WINDOW, /VIEW, etc.).

        This command is valid in any processor.
        """
        command = "/ANNOT,%s,%s,%s" % (str(lab), str(val1), str(val2))
        return self.run(command, **kwargs)

    def mfpsimul(self, gname="", fname1="", fname2="", **kwargs):
        """APDL Command: MFPSIMUL

        Sets up a field solver group to simultaneously process with code
        coupling analyses.

        Parameters
        ----------
        gname
            Sets the group name with a character string of up to 80 characters.

        fname1, fname2
            Sets the field solver 1 and field solver 2 names, which are
            processed simultaneously, with a character string of up to 80
            characters.

        Notes
        -----
        This command is used to define a group of simultaneously-processed
        field solvers in an MFX analysis. For example, to define group g1 with
        field solvers ansys-code and cfx-code, enter MFPS,g1,ansys-code,cfx-
        code.

        To indicate groups of sequentially-processed field solvers for your MFX
        analysis, create two groups (g1 and g2).

        A field solver refers to a specific instance of an ANSYS or CFX solver
        execution that is defined by the respective input file(s) referenced
        when starting the solver (through the launcher or from the command
        line). The field solver names that are referenced in several MFX
        commands must be consistent with the names that will be used when
        starting the coupled simulation.

        Note:: : When running MFX from the launcher, you must use ANSYS and CFX
        (uppercase) as the field solver names (MFPSIMUL) in your input file.

        See Multi-field Commands in the Coupled-Field Analysis Guide for a list
        of all ANSYS Multi-field solver commands and their availability for MFS
        and MFX analyses.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "MFPSIMUL,%s,%s,%s" % (str(gname), str(fname1), str(fname2))
        return self.run(command, **kwargs)

    def dk(self, kpoi="", lab="", value="", value2="", kexpnd="", lab2="",
           lab3="", lab4="", lab5="", lab6="", **kwargs):
        """APDL Command: DK

        Defines DOF constraints at keypoints.

        Parameters
        ----------
        kpoi
            Keypoint at which constraint is to be specified.  If ALL, apply to
            all selected keypoints [KSEL].  If KPOI = P, graphical picking is
            enabled and all remaining command fields are ignored (valid only in
            the GUI).  A component name may also be substituted for KPOI.

        lab
            Valid degree of freedom label.  If ALL, use all appropriate labels
            except HDSP.  Structural labels:  UX, UY, or UZ (displacements);
            ROTX, ROTY, or ROTZ (rotations); WARP (warping); HDSP (hydrostatic
            pressure).  Thermal labels: TEMP, TBOT, TE2, TE3, . . ., TTOP
            (temperature). Acoustic labels:  PRES (pressure); UX, UY, or UZ
            (displacements for FSI coupled elements). Electric labels:  VOLT
            (voltage). Magnetic labels:  MAG (scalar magnetic potential); AX,
            AY, or AZ (vector magnetic potentials). Diffusion labels: CONC
            (concentration).

        value
            Degree of freedom value or table name reference for tabular
            boundary conditions.  To specify a table, enclose the table name in
            percent signs (%) (e.g., DK,NODE,TEMP,%tabname%).  Use the *DIM
            command to define a table.

        value2
            Second degree of freedom value (if any).  If the analysis type and
            the degree of freedom allow a complex input, VALUE (above) is the
            real component and VALUE2 is the imaginary component.

        kexpnd
            Expansion key:

            0 - Constraint applies only to the node at this keypoint.

            1 - Flags this keypoint for constraint expansion.

        lab2, lab3, lab4, . . . ,  lab6
            Additional degree of freedom labels.  The same values are applied
            to the keypoints for these labels.

        Notes
        -----
        A keypoint may be flagged using KEXPND to allow its constraints to be
        expanded to nodes on the attached solid model entities having similarly
        flagged keypoint constraints.  Constraints are transferred from
        keypoints to nodes with the DTRAN or SBCTRAN commands.  The expansion
        uses interpolation to apply constraints to the nodes on the lines
        between flagged keypoints.  If all keypoints of an area or volume
        region are flagged and the constraints (label and values) are equal,
        the constraints are applied to the interior nodes of the region.  See
        the D command for a description of nodal constraints.

        Tabular boundary conditions (VALUE = %tabname%) are available only for
        the following degree of freedom labels: Electric (VOLT), structural
        (UX, UY, UZ, ROTX, ROTY, ROTZ), Acoustic (PRES, UX, UY, UZ), and
        temperature (TEMP, TBOT, TE2, TE3, . . ., TTOP).

        Constraints specified by the DK command can conflict with other
        specified constraints.  See Resolution of Conflicting Constraint
        Specifications in the Basic Analysis Guide for details.

        This command is also valid in PREP7.
        """
        command = "DK,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(kpoi), str(lab), str(value), str(value2), str(kexpnd), str(lab2), str(lab3), str(lab4), str(lab5), str(lab6))
        return self.run(command, **kwargs)

    def prange(self, linc="", vmin="", vmax="", xvar="", **kwargs):
        """APDL Command: PRANGE

        Determines the path range.

        Parameters
        ----------
        linc, vmin, vmax
            Set the range for listing or displaying the table locations between
            a minimum value (VMIN) and a maximum value (VMAX) of the path
            distance with a location increment of LINC (defaults to 1).  The
            first location begins at VMIN.

        xvar
            Path variable item to be used as the x-axis plot variable.  Any
            valid path variable may be used (PDEF command).  Default variable
            is the path distance, S.

        Notes
        -----
        Determines the path distance range for use with the PRPATH and PLPATH
        commands.
        """
        command = "PRANGE,%s,%s,%s,%s" % (str(linc), str(vmin), str(vmax), str(xvar))
        return self.run(command, **kwargs)

    def ainp(self, na1="", na2="", na3="", na4="", na5="", na6="", na7="",
             na8="", na9="", **kwargs):
        """APDL Command: AINP

        Finds the pairwise intersection of areas.

        Parameters
        ----------
        na1, na2, na3, . . . , na9
            Numbers of areas to be intersected pairwise.  If NA1 = ALL, NA2 to
            NA9 are ignored and the pairwise intersection of all selected areas
            is found.  If NA1 = P, graphical picking is enabled and all
            remaining arguments are ignored (valid only in the GUI).  A
            component name may be substituted for NA1.

        Notes
        -----
        Finds the pairwise intersection of areas.  The pairwise intersection is
        defined as all regions shared by any two or more areas listed on this
        command.  New areas will be generated where the original areas
        intersect pairwise.  If the regions of pairwise intersection are only
        lines, new lines will be generated.  See the Modeling and Meshing Guide
        for an illustration.  See the BOPTN command for the options available
        to Boolean operations.  Element attributes and solid model boundary
        conditions assigned to the original entities will not be transferred to
        the new entities generated.
        """
        command = "AINP,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(na1), str(na2), str(na3), str(na4), str(na5), str(na6), str(na7), str(na8), str(na9))
        return self.run(command, **kwargs)

    def digit(self, **kwargs):
        """APDL Command: DIGIT

        Specifies "Node digitizing" as the subsequent status topic.

        Notes
        -----
        This is a status [STAT] topic command.  Status topic commands are
        generated by the GUI and will appear in the log file (Jobname.LOG) if
        status is requested for some items under Utility Menu> List> Status.
        This command will be immediately followed by a STAT command, which will
        report the status for the specified topic.

        If entered directly into the program, the STAT command should
        immediately follow this command.
        """
        command = "DIGIT," % ()
        return self.run(command, **kwargs)

    def cpdele(self, nset1="", nset2="", ninc="", nsel="", **kwargs):
        """APDL Command: CPDELE

        Deletes coupled degree of freedom sets.

        Parameters
        ----------
        nset1, nset2, ninc
            Delete coupled sets from NSET1 to NSET2 (defaults to NSET1) in
            steps of NINC (defaults to 1).  If NSET1 = ALL, NSET2 and NINC are
            ignored and all coupled sets are deleted.

        nsel
            Additional node selection control:

            ANY - Delete coupled set if any of the selected nodes are in the set (default).

            ALL - Delete coupled set only if all of the selected nodes are in the set.

        Notes
        -----
        See the CP command for a method to delete individual nodes from a set.
        """
        command = "CPDELE,%s,%s,%s,%s" % (str(nset1), str(nset2), str(ninc), str(nsel))
        return self.run(command, **kwargs)

    def lswrite(self, lsnum="", **kwargs):
        """APDL Command: LSWRITE

        Writes load and load step option data to a file.

        Parameters
        ----------
        lsnum
            Number to be assigned to the load step file name for identification
            purposes.  Defaults to 1 + highest LSNUM used in the current
            session.  Issue LSWRITE,STAT to list the current value of LSNUM.
            Issue LSWRITE,INIT to reset to 1.  The load step file will be named
            Jobname.Sn, where n is the specified LSNUM value (preceded by "0"
            for values 1-9).  On systems with a 3-character limit on the file
            name extension, the "S" is dropped for LSNUM > 99.

        Notes
        -----
        Writes all load and load step option data for the selected model to a
        load step file for later use.  LSWRITE does not capture changes made to
        real constants (R), material properties (MP), couplings (CP), or
        constraint equations (CE).

        Solid model loads will not be saved if the model is not meshed. Solid
        model loads, if any, are transferred to the finite element model. Issue
        LSCLEAR,FE to delete finite element loads.

        One file is written for each load step. Use the LSREAD command to read
        a single load step file, and the LSDELE command to delete load step
        files.  Use the LSSOLVE command to read and solve the load steps
        sequentially.

        Solution control commands are typically not written to the file unless
        you specifically change a default solution setting.

        LSWRITE does not support the following commands: DJ, FJ, GSBDATA,
        GSGDATA, ESTIF, EKILL, EALIVE, MPCHG, and OUTRES. These commands will
        not be written to the load step file.

        LSWRITE cannot be used with the birth-death option.

        This command is also valid in PREP7.
        """
        command = "LSWRITE,%s" % (str(lsnum))
        return self.run(command, **kwargs)

    def xrange(self, xmin="", xmax="", **kwargs):
        """APDL Command: /XRANGE

        Specifies a linear abscissa (X) scale range.

        Parameters
        ----------
        xmin
            Minimum abscissa scale value.

        xmax
            Maximum abscissa scale value.

        Notes
        -----
        Specifies a linear abscissa (X) scale range for the line graph display.
        Use /XRANGE,DEFAULT to return to automatic scaling.

        Automatic scaling will often yield inappropriate range values for
        logarithmic scales (/GROPT, LOGX).

        This command is valid in any processor.
        """
        command = "/XRANGE,%s,%s" % (str(xmin), str(xmax))
        return self.run(command, **kwargs)

    def numstr(self, label="", value="", **kwargs):
        """APDL Command: NUMSTR

        Establishes starting numbers for automatically numbered items.

        Parameters
        ----------
        label
            Apply starting number to one of the following sets of items:

            NODE - Node numbers.  Value defaults (and is continually reset) to 1 + maximum node
                   number in model.  Cannot be reset lower.

            ELEM - Element numbers.  Value defaults (and is continually reset) to 1 + maximum
                   element number in model.  Cannot be reset lower.

            KP - Keypoint numbers.  Value defaults to 1.  Only undefined numbers are used.
                 Existing keypoints are not overwritten.

            LINE - Line numbers.  Value defaults to 1.  Only undefined numbers are used.  Existing
                   lines are not overwritten.

            AREA - Area numbers.  Value defaults to 1.  Only undefined numbers are used.  Existing
                   areas are not overwritten.

            VOLU - Volume numbers.  Value defaults to 1.  Only undefined numbers are used.
                   Existing volumes are not overwritten.

            DEFA - Default.  Returns all starting numbers to their default values.

        value
            Starting number value.

        Notes
        -----
        Establishes starting numbers for various items that may have numbers
        automatically assigned (such as element numbers with the EGEN command,
        and node and solid model entity numbers with the mesh [AMESH, VMESH,
        etc.] commands).  Use NUMSTR,STAT to display settings.  Use NUMSTR,DEFA
        to reset all specifications back to defaults.  Defaults may be lowered
        by deleting and compressing items (i.e., NDELE and NUMCMP,NODE for
        nodes, etc.).

        Note:: : A mesh clear operation (VCLEAR, ACLEAR, LCLEAR, and KCLEAR)
        automatically sets starting node and element numbers to the highest
        unused numbers.  If a specific starting node or element number is
        desired, issue NUMSTR after the clear operation.
        """
        command = "NUMSTR,%s,%s" % (str(label), str(value))
        return self.run(command, **kwargs)

    def edcrb(self, option="", neqn="", partm="", parts="", **kwargs):
        """APDL Command: EDCRB

        Constrains two rigid bodies to act as one in an explicit dynamics
        analysis.

        Parameters
        ----------
        option
            Label identifying the option to be performed:

            ADD - Define an equation to constrain two rigid bodies (default).

            DELE - Delete the equation (specified by NEQN) that constrains two rigid bodies. If
                   NEQN is blank, all equations constraining rigid bodies are
                   deleted.

            LIST - List constrained rigid bodies specified by NEQN. If NEQN is blank, all
                   constrained rigid bodies are listed.

        neqn
            Equation reference number. Defaults to PARTS.  NEQN should be a
            unique number for each pair of PARTM and PARTS. If it is not
            unique, the equation reference number defined last will overwrite
            any previously defined NEQN with the same number.

        partm
            PART number [EDPART] identifying the master rigid body. This value
            is ignored if the DELE or LIST labels are specified. No default;
            you must enter a value.

        parts
            PART number [EDPART] identifying the slave rigid body. This value
            is ignored if the DELE or LIST labels are specified. No default;
            you must enter a value.

        Notes
        -----
        EDCRB is valid only for materials defined as rigid bodies with the
        EDMP,RIGID command. EDCRB automatically generates a constraint equation
        to force the specified rigid bodies to behave as a single rigid body.
        The slave rigid body takes on the material properties and loading of
        the master rigid body. Any loads [EDLOAD] existing on the slave rigid
        body are ignored.

        To create a single large rigid body from several smaller bodies, use a
        series of EDCRB commands. With the first command, specify a master and
        slave to create the first combined rigid body. Then, using that body as
        the master, specify another slave to create a larger rigid body.
        Continue the process, using the expanding rigid body as the master and
        adding slave bodies until you have defined the desired large rigid
        body. All slave rigid bodies will take on the material properties and
        loading of the original master rigid body. Note that you will need to
        use different NEQN values for each pair of PARTM and PARTS.  This
        command will be ignored if you specify the previously-defined master
        rigid body as a slave rigid body in the same analysis. To change the
        master and slave definitions, first use the DELE option to delete all
        master and slave definitions, and then use the ADD option to redefine
        them.

        The equation number, NEQN, is a reference number by which the
        constrained bodies can be identified for listing and deleting purposes
        on the EDCRB command. For any other reference to the constrained bodies
        (loading, contact definitions, etc.), use the master body part number
        (PARTM).

        This command is also valid in SOLUTION.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDCRB,%s,%s,%s,%s" % (str(option), str(neqn), str(partm), str(parts))
        return self.run(command, **kwargs)

    def deact(self, **kwargs):
        """APDL Command: DEACT

        Specifies "Element birth and death" as the subsequent status topic.

        Notes
        -----
        This is a status [STAT] topic command.  Status topic commands are
        generated by the GUI and will appear in the log file (Jobname.LOG) if
        status is requested for some items under Utility Menu> List> Status.
        This command will be immediately followed by a STAT command, which will
        report the status for the specified topic.

        If entered directly into the program, the STAT command should
        immediately follow this command.
        """
        command = "DEACT," % ()
        return self.run(command, **kwargs)

    def andyna(self, delay="", ncycl="", start="", end="", inc="",
               autocontourkey="", **kwargs):
        """APDL Command: ANDYNA

        Produces an animated sequence of contour values through substeps.

        Parameters
        ----------
        delay
            Time delay during animation (defaults to 0.1 seconds).

        ncycl
            Number of animation cycles (defaults to 5).  Available in non-UI
            mode only.

        start
            Number of the starting substep (defaults to 1).

        end
            Number of the ending substep (defaults to the maximum substep).

        inc
            Increment between substeps (defaults to 1).

        autocontourkey
            Auto-scales contour values, based on the overall subset range of
            values  (defaults to 0, no auto-scaling).

        Notes
        -----
        ANDYNA involves an ANSYS macro which produces an animation of contour
        values through all the substeps of the last plot action command.  This
        command operates only on graphic display platforms supporting the /SEG
        command.  After executing ANDYNA, you can replay the animated sequence
        by issuing the ANIM command.

        The command functions only in the postprocessor.
        """
        command = "ANDYNA,%s,%s,%s,%s,%s,%s" % (str(delay), str(ncycl), str(start), str(end), str(inc), str(autocontourkey))
        return self.run(command, **kwargs)

    def aadd(self, na1="", na2="", na3="", na4="", na5="", na6="", na7="",
             na8="", na9="", **kwargs):
        """APDL Command: AADD

        Adds separate areas to create a single area.

        Parameters
        ----------
        na1, na2, na3, . . . , na9
            Numbers of areas to be added.  If NA1 = ALL, add all selected areas
            and ignore NA2 to NA9.  If NA1 = P, graphical picking is enabled
            and all remaining arguments are ignored (valid only in the GUI).  A
            component name may also be substituted for NA1.

        Notes
        -----
        The areas must be coplanar.  The original areas (and their
        corresponding lines and keypoints) will be deleted by default.  See the
        BOPTN command for the options available to Boolean operations.  Element
        attributes and solid model boundary conditions assigned to the original
        entities will not be transferred to the new entities generated.
        Concatenated entities are not valid with this command.
        """
        command = "AADD,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(na1), str(na2), str(na3), str(na4), str(na5), str(na6), str(na7), str(na8), str(na9))
        return self.run(command, **kwargs)

    def aatt(self, mat="", real="", type="", esys="", secn="", **kwargs):
        """APDL Command: AATT

        Associates element attributes with the selected, unmeshed areas.

        Parameters
        ----------
        mat
            The material number to be associated with selected, unmeshed areas.

        real
            The real constant set number to be associated with selected,
            unmeshed areas.

        type
            The type number to be associated with selected, unmeshed areas.

        esys
            The coordinate system number to be associated with selected,
            unmeshed areas.

        secn
            The section number to be associated with selected unmeshed areas.

        Notes
        -----
        Areas subsequently generated from the areas will also have these
        attributes.  These element attributes will be used when the areas are
        meshed.  If an area does not have attributes associated with it (by
        this command) at the time it is meshed, the attributes are obtained
        from the then current MAT, REAL, TYPE, ESYS, and SECNUM command
        settings.  Reissue the AATT command (before areas are meshed) to change
        the attributes.  A zero (or blank) argument removes the corresponding
        association. If any of the arguments MAT, REAL, TYPE, ESYS, or SECN are
        defined as -1, then that value will be left unchanged in the selected
        set.

        In some cases, ANSYS can proceed with an area meshing operation even
        when no logical element type has been assigned via AATT,,,TYPE or TYPE.
        For more information, see the discussion on setting element attributes
        in Meshing Your Solid Model in the Modeling and Meshing Guide.
        """
        command = "AATT,%s,%s,%s,%s,%s" % (str(mat), str(real), str(type), str(esys), str(secn))
        return self.run(command, **kwargs)

    def rpoly(self, nsides="", lside="", majrad="", minrad="", **kwargs):
        """APDL Command: RPOLY

        Creates a regular polygonal area centered about the working plane
        origin.

        Parameters
        ----------
        nsides
            Number of sides in the regular polygon.  Must be greater than 2.

        lside
            Length of each side of the regular polygon.

        majrad
            Radius of the major (or circumscribed) circle of the polygon.  Not
            used if LSIDE is input.

        minrad
            Radius of the minor (or inscribed) circle of the polygon.  Not used
            if LSIDE or MAJRAD is input.

        Notes
        -----
        Defines a regular polygonal area on the working plane.  The polygon
        will be centered about the working plane origin, with the first
        keypoint defined at : θ = 0°.  The area will be defined with NSIDES
        keypoints and NSIDES lines.  See the RPR4 and POLY commands for other
        ways to create polygons.
        """
        command = "RPOLY,%s,%s,%s,%s" % (str(nsides), str(lside), str(majrad), str(minrad))
        return self.run(command, **kwargs)

    def dset(self, node1="", node2="", node3="", ddev="", **kwargs):
        """APDL Command: DSET

        Sets the scale and drawing plane orientation for a digitizing tablet.

        Parameters
        ----------
        node1, node2, node3
            Any three (noncolinear) nodes defining a plane parallel to the
            drawing.  Nodes and actual locations (in any coordinate system)
            must have been previously defined.

        ddev
            Digitizing device type number (device dependent).

        Notes
        -----
        Sets drawing scale size and defines the drawing plane orientation for
        use with a digitizing tablet.  Drawings must be to scale.  Views must
        represent standard orthogonal parallel projections.  The three nodes
        indicated must be digitized [DIG] from the tablet after this command is
        issued.
        """
        command = "DSET,%s,%s,%s,%s" % (str(node1), str(node2), str(node3), str(ddev))
        return self.run(command, **kwargs)

    def cnkmod(self, itype="", knum="", value="", **kwargs):
        """APDL Command: CNKMOD

        Modifies contact element key options.

        Parameters
        ----------
        itype
            Contact element type number as defined on the ET command.

        knum
            Number of the KEYOPT to be modified (KEYOPT(KNUM)).

        value
            Value to be assigned to the KEYOPT.

        Notes
        -----
        The CNKMOD command has the same syntax as the KEYOPT command. However,
        it is valid only in the SOLUTION processor. This command is intended
        only for use in a linear perturbation analysis, and can only be used to
        modify certain contact element KEYOPT values as described below.

        Modifying KEYOPT(12)

        One use for this command is to modify contact interface behavior
        between load steps in a linear perturbation analysis; it allows the
        user to control the contact status locally per contact pair. For this
        application, this command is limited to changing the contact interface
        behavior key option: KEYOPT(12) of CONTA171, CONTA172, CONTA173,
        CONTA174, CONTA175, CONTA176, and CONTA177; and KEYOPT(10) of CONTA178.

        When used for this purpose, the command adjusts the contact status from
        the linear perturbation base analysis (at the point of restart) as
        described in the table below. Note that CNKMOD allows you to take
        points in the base analysis that are near contact (within the pinball
        region) and modify them to be treated as "in contact" in the
        perturbation analysis; see the "1 - near-field" row with KEYOPT(12)
        values set to 4 or 5. CNKMOD also allows you to take points that are
        sliding in the base analysis and treat them as sticking in the
        perturbation analysis, irrespective of the MU value; see the "2 -
        sliding" row with KEYOPT(12) values set to 1,3, 5, or 6.

        Table: 128:: : Adjusted Contact Status with CNKMOD is Issued

        (if outside of the adjusted pinball region)

        (if inside of the adjusted pinball region)

        (if outside of the adjusted pinball region)

        (if inside of the adjusted pinball region)

        If an open gap exists at the end of the previous load step and the
        contact status is adjusted as sliding or sticking due to a “bonded” or
        “no seperation” contact behavior definition, then the program will
        treat it as near-field contact when executing CNKMOD in the subsequent
        load steps.

        In the linear perturbation analysis procedure, contact status can also
        be controlled or modified by the PERTURB command. The contact status
        always follows local controls defined by the CNKMOD command first, and
        is then adjusted by the global sticking or bonded setting (ContKey =
        STICKING or BONDED) on the PERTURB command (see the PERTURB command for
        details).

        Modifying KEYOPT(3)

        Another use for this command is to change the units of normal contact
        stiffness (contact element real constant FKN) in a linear perturbation
        modal analysis that is used to model brake squeal. For contact elements
        CONTA171, CONTA172, CONTA173, and CONTA174, KEYOPT(3) controls the
        units of normal contact stiffness. You can issue the command
        CNKMOD,ITYPE,3,1 during the first phase of the linear perturbation
        analysis in order to change the units of normal contact stiffness from
        FORCE/LENGTH3 (in the base analysis) to FORCE/LENGTH. Note that
        KEYOPT(3) = 1 is valid only when a penalty-based algorithm is used
        (KEYOPT(2) = 0 or 1) and the absolute normal contact stiffness value is
        explicitly specified (that is, a negative value input for real constant
        FKN).
        """
        command = "CNKMOD,%s,%s,%s" % (str(itype), str(knum), str(value))
        return self.run(command, **kwargs)

    def curr2d(self, **kwargs):
        """APDL Command: CURR2D

        Calculates current flow in a 2-D conductor.

        Notes
        -----
        CURR2D invokes an ANSYS macro which calculates the total current
        flowing in a conducting body for a 2-D planar or axisymmetric magnetic
        field analysis.  The currents may be applied source currents or induced
        currents (eddy currents).  The elements of the conducting region must
        be selected before this command is issued.  The total current
        calculated by the macro is stored in the parameter TCURR.  Also, the
        total current and total current density are stored on a per-element
        basis in the element table [ETABLE] with the labels TCURR and JT,
        respectively.  Use the PLETAB and PRETAB commands to plot and list the
        element table items.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "CURR2D," % ()
        return self.run(command, **kwargs)

    def physics(self, option="", title="", fname="", ext="", **kwargs):
        """APDL Command: PHYSICS

        Writes, reads, or lists all element information

        Parameters
        ----------
        option
            Specifies what to do with element information:

            WRITE - Write all appropriate element types, key options, real constants, material
                    properties, solution analysis options, load step options,
                    constraint equations, coupled nodes, defined components,
                    and GUI preference settings to the file specified with the
                    Fname and Ext arguments.

            READ - Deletes all solution information (material properties, solution options, load
                   step options, constraint equations, coupled nodes, results,
                   and GUI preference settings) then reads all the information
                   listed above into the ANSYS database from the location
                   specified by the Fname and Ext arguments.

            LIST - Lists currently defined physics files and their titles.

            DELETE - Deletes a specified physics file and its title from the database.

            CLEAR - Deletes all material properties, solution options, load step options,
                    constraint equations, coupled nodes, results, and GUI
                    preference settings from the database. Does NOT clear the
                    active physics file title from the database.

            STATUS - Displays information about all active elements and settings.

        title
            A user-defined title that quickly identifies a set of physics
            settings.  For example, you might use "Fluid," "Structural," or
            "Magnetic" as titles.  A title can contain up to 64 characters. It
            can be entered in lower or upper case. Lower case is internally
            converted to upper case within the program.

        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        Notes
        -----
        Use the PHYSICS command when you are performing a multiphysics analysis
        that involves two different disciplines (for example, magnetic and
        structural analyses) and you cannot solve both analyses simultaneously.
        Once you have set up physics environments for both analyses, you can
        use the PHYSICS,READ command to change between the defined physics
        environments.  For more information about doing multiphysics analyses,
        see Sequential Coupled-Field Analysis in the Coupled-Field Analysis
        Guide.

        The PHYSICS command outputs all solution information, including
        analysis options, to the Jobname.PHn file described above.  Although it
        also outputs components, the ANSYS program does not list entities
        (nodes, elements, lines, etc.).

        PHYSICS,WRITE will overwrite existing physics files with the same title
        (even if the name is different). In other words, if the directory has a
        physics file with the same title as the active physics file title, but
        a different name, the PHYSICS,WRITE command will overwrite the existing
        physics file and use the existing filename, not the filename specified
        on the PHYSICS,WRITE command.
        """
        command = "PHYSICS,%s,%s,%s,%s" % (str(option), str(title), str(fname), str(ext))
        return self.run(command, **kwargs)

    def mfouri(self, oper="", coeff="", mode="", isym="", theta="", curve="",
               **kwargs):
        """APDL Command: *MFOURI

        Calculates the coefficients for, or evaluates, a Fourier series.

        Parameters
        ----------
        oper
            Type of Fourier operation:

            Calculate Fourier coefficients COEFF from MODE, ISYM, THETA, and CURVE. - Evaluate the Fourier curve CURVE from COEFF, MODE, ISYM andTHETA

        coeff
            Name of the array parameter vector containing the Fourier
            coefficients (calculated if Oper = FIT, required as input if Oper =
            EVAL).  See *SET for name restrictions.

        mode
            Name of the array parameter vector containing the mode numbers of
            the desired Fourier terms.

        isym
            Name of the array parameter vector containing the symmetry key for
            the corresponding Fourier terms.  The vector should contain keys
            for each term as follows:

            Symmetric (cosine) term - Antisymmetric (sine) term.

        theta, curve
            Names of the array parameter vectors containing the theta vs. curve
            description, respectively.  Theta values should be input in
            degrees.  If Oper = FIT, one curve value should be supplied with
            each theta value.  If Oper = EVAL, one curve value will be
            calculated for each theta value.

        Notes
        -----
        Calculates the coefficients of a Fourier series for a given curve, or
        evaluates the Fourier curve from the given (or previously calculated)
        coefficients.  The lengths of the COEFF, MODE, and ISYM vectors must be
        the same--typically two times the number of modes desired, since two
        terms (sine and cosine) are generally required for each mode.  The
        lengths of the CURVE and THETA vectors should be the same or the
        smaller of the two will be used.  There should be a sufficient number
        of points to adequately define the curve--at least two times the number
        of coefficients.  A starting array element number (1) must be defined
        for each array parameter vector.  The vector specifications *VLEN,
        *VCOL, *VABS, *VFACT, and *VCUM do not apply to this command.  Array
        elements should not be skipped with the *VMASK and the NINC value of
        the *VLEN specifications.  The vector being calculated (COEFF if Oper
        is FIT, or CURVE if Oper is EVAL) must exist as a dimensioned array
        [*DIM].

        This command is valid in any processor.
        """
        command = "*MFOURI,%s,%s,%s,%s,%s,%s" % (str(oper), str(coeff), str(mode), str(isym), str(theta), str(curve))
        return self.run(command, **kwargs)

    def betad(self, value="", **kwargs):
        """APDL Command: BETAD

        Defines the stiffness matrix multiplier for damping.

        Parameters
        ----------
        value
            Stiffness matrix multiplier for damping.

        Notes
        -----
        This command defines the stiffness matrix multiplier β used to form the
        viscous damping matrix [C] = β [K] where [K] is the stiffness matrix.

        Values of : β may also be input as a material property (use the BETD
        label on the MP command).  If BETD is included, the BETD value is added
        to the BETAD value as appropriate (see Damping Matrices in the
        Mechanical APDL Theory Reference).  Damping is not used in the static
        (ANTYPE,STATIC) or buckling (ANTYPE,BUCKLE) analyses.

        This command is also valid in PREP7.
        """
        command = "BETAD,%s" % (str(value))
        return self.run(command, **kwargs)

    def kdist(self, kp1="", kp2="", **kwargs):
        """APDL Command: KDIST

        Calculates and lists the distance between two keypoints.

        Parameters
        ----------
        kp1
            First keypoint in distance calculation.  If KP1 = P, graphical
            picking is enabled and all remaining command fields are ignored
            (valid only in the GUI).

        kp2
            Second keypoint in distance calculation.

        Notes
        -----
        KDIST lists the distance between keypoints KP1 and KP2, as well as the
        current coordinate system offsets from KP1 to KP2, where the X, Y, and
        Z locations of KP1 are subtracted from the X, Y, and Z locations of KP2
        (respectively) to determine the offsets.  KDIST is valid in any
        coordinate system except toroidal [CSYS,3].

        KDIST returns a variable, called "_RETURN," which contains the distance
        value.  You can use this value for various purposes; for example, to
        set the default number of line divisions to be generated along region
        boundary lines [ESIZE,_RETURN]. In interactive mode, you can access
        this command by using the Model Query Picker (Utility Menu> List>
        Picked Entities), where you can also access automatic annotation
        functions, and display the value on your model.

        This command is valid in any processor.
        """
        command = "KDIST,%s,%s" % (str(kp1), str(kp2))
        return self.run(command, **kwargs)

    def harfrq(self, freqb="", freqe="", logopt="", freqarr="", toler="",
               **kwargs):
        """APDL Command: HARFRQ

        Defines the frequency range in a harmonic analysis.

        Parameters
        ----------
        freqb
            Frequency (Hz) at the beginning of the FREQB to FREQE range (if
            FREQE > FREQB).  If FREQE is blank, the solution is done only at
            frequency FREQB (the central frequency of octave bands, when LogOpt
            = OB1, OB2, OB3, OB6, OB12 or OB24).

        freqe
            Frequency at end of this range.  Solutions are done at an interval
            of (FREQE-FREQB) / NSBSTP, ending at FREQE.  No solution is done at
            the beginning of the frequency range.  NSBSTP is input via the
            NSUBST command.  See the EXPSOL command documentation for expansion
            pass solutions.

        --
            Reserved.

        logopt
            Logarithm frequency span. Solutions are done at an interval of
            (log(FREQE) - log(FREQB)) / (NSBSTP-1), (NSBSTP>1). The central
            frequency or beginning frequency is used for NSBSTP = 1. Valid
            values are:

            OB1 - Octave band.

            OB2 - 1/2 octave band.

            OB3 - 1/3 octave band.

            OB6 - 1/6 octave band.

            OB12 - 1/12 octave band.

            OB24 - 1/24 octave band.

            LOG - General logarithm frequency span.

        freqarr
            An array containing frequency values (Hz). Combined with the
            tolerance argument, Toler, these values are merged with values
            calculated based on the specifications from FREQB, FREQE, and
            LogOpt, as well NSBSTP on the NSUBST command and Clust on the HROUT
            command. Enclose the array name in percent (%) signs (for example,
            HARFRQ,,,,,%arrname%). Use *DIM to define the array.

        toler
            Tolerance to determine if a user input frequency value in FREQARR
            is a duplicate and can be ignored. Two frequency values are
            considered duplicates if their difference is less than the
            frequency range multiplied by the tolerance. The default value is 1
            x 10-5.

        Notes
        -----
        Defines the frequency range for loads in the harmonic analysis
        (ANTYPE,HARMIC).

        Do not use this command for a harmonic ocean wave analysis (HROCEAN).

        When frequencies are user-defined, the array FREQARR must be one-
        dimensional and contain positive values. User-defined frequency input
        is not supported in the following cases:

        in a cyclic symmetry harmonic analysis

        when the Variational Technology method is used (Method = VT on the
        HROPT command)

        This command is also valid in PREP7.
        """
        command = "HARFRQ,%s,%s,%s,%s,%s" % (str(freqb), str(freqe), str(logopt), str(freqarr), str(toler))
        return self.run(command, **kwargs)

    def mdplot(self, function="", dmpname="", scale="", **kwargs):
        """APDL Command: MDPLOT

        Plots frequency-dependent modal damping coefficients calculated by
        DMPEXT.

        Parameters
        ----------
        function
            Function to display.

            d_coeff - Damping coefficient

            s_coeff - Squeeze coefficient

            d_ratio - Damping ratio

            s_ratio - Squeeze stiffness ratio

        dmpname
            Array parameter name where damping information is stored. Defaults
            to d_damp.

        scale
            Indicates whether to perform a linear or a double logarithmic plot.

            LIN - Perform a linear plot. Default

            LOG - Perform a double logarithmic plot.

        Notes
        -----
        See Thin Film Analysis for more information on thin film analyses.
        """
        command = "MDPLOT,%s,%s,%s" % (str(function), str(dmpname), str(scale))
        return self.run(command, **kwargs)

    def pivcheck(self, key="", prntcntrl="", **kwargs):
        """APDL Command: PIVCHECK

        Controls the behavior of an analysis when a negative or zero equation
        solver pivot value is encountered.

        Parameters
        ----------
        key
            Determines whether to stop or continue an analysis when a negative
            or zero equation solver pivot value is encountered:

            AUTO - Check for negative or zero pivot values for analyses performed with the sparse
                   and PCG solvers. When one is encountered, an error or
                   warning is issued, per various criteria relating to the type
                   of analysis being solved. An error causes the analysis to
                   stop; a warning allows the analysis to continue. A negative
                   pivot value may be valid for some nonlinear and multiphysics
                   analyses (for example, electromagnetic and thermal
                   analyses); this key has no effect in these cases.

            ERROR - Check for negative or zero pivot values for analyses performed with the sparse
                    and PCG solvers. When one is encountered, an error is
                    issued, stopping the analysis. A negative pivot value may
                    be valid for some nonlinear and multiphysics analyses (for
                    example, electromagnetic and thermal analyses); this key
                    has no effect in these cases.

            WARN - Check for negative or zero pivot values for analyses performed with the sparse
                   and PCG solvers. When one is encountered, a warning is
                   issued and the analysis continues. A negative pivot value
                   may be valid for some nonlinear and multiphysics analyses
                   (for example, electromagnetic and thermal analyses); this
                   key has no effect in these cases.

            OFF - Pivot values are not checked. This key causes the analysis to continue in spite
                  of a negative or zero pivot value.

        prntcntrl
            Provides print options. Print output with these options will be
            sent to the default output file, not to the files created by the
            nonlinear diagnostic tools (NLDIAG).

            ONCE - Print only the maximum and minimum pivot information on the first call to the
                   sparse solver (which is the default solver). This is the
                   default behavior.

            EVERY - Print the maximum and minimum pivot information at every call to the sparse
                    solver. This option is provided for nonlinear analysis
                    diagnostics.

        Notes
        -----
        This command is valid for all analyses. In a nonlinear analysis, a
        negative pivot may be valid. In some cases, rigid body motions in a
        nonlinear analysis will be trapped by error routines checking
        infinitely large displacements (DOF limit exceeded) or nonconvergence
        status. An under-constrained model may avoid the pivot check, but fail
        with a DOF limit exceeded error.

        Machine precision may affect whether a small pivot triggers an error or
        bypasses this checking logic. You may wish to review the ratio of the
        maximum to absolute minimum pivot values. For ratios exceeding 12 to 14
        orders of magnitude, the accuracy of the computed solution may be
        degraded by the severe ill-conditioning of the assembled matrix.

        Note that negative pivots corresponding to Lagrange multiplier based
        mixed u-P elements are not checked or reported by this command.
        Negative pivots arising from the u-P element formulation and related
        analyses can occur and lead to correct solutions.

        This command is also valid in PREP7.
        """
        command = "PIVCHECK,%s,%s" % (str(key), str(prntcntrl))
        return self.run(command, **kwargs)

    def pred(self, sskey="", lskey="", **kwargs):
        """APDL Command: PRED

        Activates a predictor in a nonlinear analysis.

        Parameters
        ----------
        sskey
            Substep predictor key:

            OFF - No prediction occurs.

            ON - Use a predictor on all substeps after the first.

            AUTO - The program uses a predictor but, within certain exceptions, automatically
                   switches prediction off. This behavior is the default; see
                   "Command Default" for details.

        --
            Unused field.

        lskey
            Load step predictor:

            OFF - No prediction across load steps occurs. This is the default behavior.

            ON - Use a predictor also on the first substep of the load step. (Sskey = ON is
                 required.)

        Notes
        -----
        Activates a predictor in a nonlinear analysis on the degree-of-freedom
        solution for the first equilibrium iteration of each substep.

        When using the arc-length method (ARCLEN, ARCTRM), you cannot issue the
        DOF solution predictor command (PRED), the automatic time stepping
        command (AUTOTS), or the line search command (LNSRCH). If you activate
        the arc-length method after you set PRED, AUTOTS, or LNSRCH, a warning
        message appears. If you elect to proceed with the arc-length method,
        the program disables your DOF predictor, automatic time stepping, and
        line search settings, and the time step size is controlled by the arc-
        length method internally.

        When using step-applied loads, such as TUNIF, BFUNIF, etc., or other
        types of non-monotonic loads, the predictor may adversely affect the
        convergence. If the solution is discontinuous, the predictor may need
        to be turned off.

        When performing a nonlinear analysis involving large rotations, the
        predictor may require using smaller substeps.

        This command is also valid in PREP7.
        """
        command = "PRED,%s,%s" % (str(sskey), str(lskey))
        return self.run(command, **kwargs)

    def pdcorr(self, name1="", name2="", corr="", **kwargs):
        """APDL Command: PDCORR

        Specifies the correlation between two random input variables.

        Parameters
        ----------
        name1
            Parameter name. The parameter must have been previously defined as
            a random input variable with the PDVAR command.

        name2
            Parameter name. The parameter must have been previously defined as
            a random input variable with the PDVAR command. Must be different
            from Name1.

        corr
            Specification of the correlation:

            Value - Sets the correlation coefficient between Name1 and Name2 to the specified
                    value. If this correlation coefficient was already defined
                    it will be changed to this new value. The correlation
                    coefficient must be between -1.0 and +1.0.

            DEL - Delete the previously defined correlation between Name1 and Name2.

        Notes
        -----
        Specifies the correlations between two random input variables. The PDS
        tool generates correlated samples if correlations exist. This applies
        to both probabilistic methods (Monte Carlo Simulation and Response
        Surface Methods).

        If there are correlated random input variables, the sampled locations
        of the random input variables reflect the correlation as illustrated
        below for the case of two standard normal distributed variables X1 and
        X2. The illustrations show no correlation (correlation coefficient
        0.0), a relatively moderate negative correlation (correlation
        coefficient -0.6), and a relative strong positive correlation
        (correlation coefficient 0.9).

        : : :
        """
        command = "PDCORR,%s,%s,%s" % (str(name1), str(name2), str(corr))
        return self.run(command, **kwargs)

    def cmap(self, fname="", ext="", kywrd="", ncntr="", **kwargs):
        """APDL Command: /CMAP

        Changes an existing or creates a new color mapping table.

        Parameters
        ----------
        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        kywrd
            Keyword indicating the disposition of the color map file.

            (blank) - Loads existing color map file.

            CREATE - Starts the CMAP utility and modifies or creates the specified file.

            SAVE - Writes the active color map to the specified file, which can be imported into
                   future sessions.

        ncntr
            Number of contours to be defined. Default = 9 (even if an existing
            file is being modified). Maximum = 128.

        Notes
        -----
        Reads the color map file (RGB index specifications) to change from
        current specifications.  Only one color map may be active at a time.

        For 2-D drivers (especially Win32c), modifying the color map can
        produce anomalies, including legend/contour disagreement.

        When Kywrd equals CREATE, the 2-D drivers (X11c and Win32c) display the
        CMAP utility with an additional contour color picker called CONTOURS.
        Colors selected via the CONTOURS picker affect result contour displays
        (such as stresses). No other drivers offer the CONTOURS picker in the
        CMAP utility.

        Changing the color map using the /CMAP command changes the meaning of
        the color labels on the /COLOR command. See /COLOR for other color
        controls.

        This command is valid anywhere.
        """
        command = "/CMAP,%s,%s,%s,%s" % (str(fname), str(ext), str(kywrd), str(ncntr))
        return self.run(command, **kwargs)

    def cycfreq(self, option="", value1="", value2="", value3="", value4="",
                value5="", **kwargs):
        """APDL Command: CYCFREQ

        Specifies solution options for a cyclic symmetry mode-superposition
        harmonic analysis.

        Parameters
        ----------
        option
            One of the following options:

            AERO - Specify the array containing the aerodynamic damping coefficients.

            Value1 - The name of the array containing the aerodynamic stiffness damping
                     coefficients.

            BLADE - Blade information required for a mistuning analysis.

            Value1 - The name of the nodal component containing the blade boundary nodes at the
                     blade-to-disk interface. Also include boundary nodes at
                     any shroud interfaces.

            Value2 - The name of the element component containing the blade elements.

            Value3 - The number of blade modes to include in the CMS reduction.

            Value4 - The lower bound of the frequency range of interest. This value is optional.

            Value5 - The upper bound of the frequency range of interest. This value is optional.

            DEFAULT - Set the default cyclic harmonic solution settings.

            EO - Excitation engine order.

            Value1 - The value of the excitation order, which must be an integer. The loadings on
                     the other sectors will be related to the loading on the
                     basic sector based on the engine order phase shift.

            MIST - Mistuning parameters.

            Value1 - The type of mistuning:

            K - Stiffness (frequency) mistuning

            Value2 - The name of the array containing the stiffness mistuning parameters.

            MODAL - Specifies if a damped modal analysis should be performed on the reduced system.

            Value1 - On/Off key.

            0 (OFF or NO) - No modal solution. Perform the harmonic solution.

            1 (ON or YES) - Perform a damped modal analysis of the reduced system in order to obtain the
                            complex frequencies. The harmonic solution is not
                            performed.

            Value2 - Number of modes for the damped modal analysis.

            Value3 - The beginning, or lower end, of the frequency range of interest (in Hz).

            Value4 - The ending, or upper end, of the frequency range of interest (in Hz).

            RESTART - Defines the point at which to restart the harmonic analysis.

            Value1 - The restart point:

            OFF - No restart (default)

            SWEEP - Restart for a new frequency sweep range (HARFRQ)

            MIST - Restart for new mistuning parameters (new mistuning arrays)

            USER - Causes the program to call for a user-defined solution.

            Value1-5 - Values passed down to the user-defined solution.

            STATUS - List the harmonic solution option settings active for the cyclic model.

        Notes
        -----
        The program solves a cyclically symmetric model (set up via the CYCLIC
        command during preprocessing) at the harmonic indices specified via the
        CYCOPT command.

        The aerodynamic coefficients are specified in a 5×(N×r) array (*DIM),
        where N is the number of blades and r can be any positive integer. Each
        column has the structure:

        where:

        One aerodynamic damping coefficient must be specified for each IBPA
        (equal to the number of blades) while keeping m and n constant.

        For constant (frequency-independent) mistuning, the stiffness
        parameters are specified in an N×1 array (*DIM) where N is the number
        of blades.

        For stiffness mistuning, each row entry represents the deviation of
        Young’s modulus from nominal,  (or equivalently, the ratio of the
        frequency deviation squared). Each frequency can also be independently
        mistuned, in which case the array is N×M, where M is the number of
        blade frequencies (Value3 of CYCFREQ,BLADE). The entries in each row
        therefore correspond to the ratio of the mistuned frequency to the
        tuned frequency squared minus one:

        The USER option activates the solution macro CYCMSUPUSERSOLVE.MAC. The
        normal solution is skipped. You may implement your own mistuning
        solution using APDL and APDL Math operations, or call your own program
        for the solution.

        The CYCFREQ command is valid in the preprocessing and solution stages
        of an analysis.

        The CYCFREQ,MODAL,ON command writes modal frequencies to the output
        file. No other postprocessing is available for this modal solve.

        When using CYCFREQ,RESTART, only mistuning parameters or frequency
        range may be changed. All other changes in parameters are ignored.

        To learn more about analyzing a cyclically symmetric structure, see the
        Cyclic Symmetry Analysis Guide.
        """
        command = "CYCFREQ,%s,%s,%s,%s,%s,%s" % (str(option), str(value1), str(value2), str(value3), str(value4), str(value5))
        return self.run(command, **kwargs)

    def naxis(self, action="", val="", **kwargs):
        """APDL Command: NAXIS

        Generates nodes for general axisymmetric element sections.

        Parameters
        ----------
        action
            Specifies one of the following command behaviors:

            GEN - Generates nodes around the axis of an axisymmetric section (default).

            CLEAR - Clears all nodes around the axis of an axisymmetric section.

            EFACET - Specifies the number of facets per edge between nodal planes and integration
                     planes in the circumferential direction to display using
                     PowerGraphics.  This option is only valid with /ESHAPE,1
                     and RSYS,SOLU commands.

        val
            Tolerance value or number of facets per edge:

            TOLER - When Action = GEN, the tolerance to use for merging the generated nodes around
                    the axis.

            NUM - When Action = EFACET, the number of facets per element edge for element plots:

            AUTO - Use program-chosen facets per edge (default).

            1 - Use 1 facet per edge (default for elements with 9, 10, 11, or 12 nodal planes).
                Shows nodal and integration planes only.

            2 - Use 2 facets per edge (default for elements with 5, 6, 7, or 8 nodal planes,
                and maximum for elements with 9, 10, 11, or 12 nodal planes).

            3 - Use 3 facets per edge (default for elements with 3 or 4 nodal planes, and
                maximum for elements with 6, 7, or 8 nodal planes).

            4 - Use 4 facets per edge (maximum for elements with 5 nodal planes).

            5 - Use 5 facets per edge (maximum for elements with 4 nodal planes).

            6 - Use 6 facets per edge (maximum for elements with 3 nodal planes).

        Notes
        -----
        The NAXIS command generates or clears the nodes for general
        axisymmetric element sections. The command applies to elements SURF159,
        SOLID272, and SOLID273.

        The generate option (Action = GEN) operates automatically on any
        current-technology axisymmetric element. Any nodes within the tolerance
        value (TOLER) of the axis are merged into a single node. The default
        tolerance is 1.0e-4.

        If you want to change the number of nodes, use the clear option (Action
        = CLEAR) before regenerating the nodes.

        To cause the 3-D element plot to appear more like the actual 3-D model,
        use NAXIS,EFACET,NUM, where NUM > 1. In this case, the coordinate
        system specified for displaying element and nodal results (RSYS) must
        be solution (RSYS,SOLU); otherwise, ANSYS resets NUM to 1.
        """
        command = "NAXIS,%s,%s" % (str(action), str(val))
        return self.run(command, **kwargs)

    def cyclic(self, nsector="", angle="", kcn="", name="", usrcomp="",
               usrnmap="", **kwargs):
        """APDL Command: CYCLIC

        Specifies a cyclic symmetry analysis.

        Parameters
        ----------
        nsector
            The number of sectors in the full 360 degrees, or one of the
            following options:

            STATUS - Indicates the current cyclic status.

            OFF - Resets model to normal (non-cyclic) status and removes the duplicate sector if
                  it exists. This option also deletes automatically detected
                  edge components (generated when USRCOMP = 0).

            UNDOUBLE - Removes the duplicate sector if it exists. The duplicate sector is created
                       during the solution (SOLVE) stage of a modal cyclic
                       symmetry analysis.

        angle
            The sector angle in degrees.

        kcn
            An arbitrary reference number assigned to the cyclic coordinate
            system.  The default value of 0 specifies automatic detection.

        name
            The root name of sector low- and high-edge components (line, area,
            or node components). The default root name (when USRCOMP = 0) is
            "CYCLIC". A root name that you specify can contain up to 11
            characters.

        usrcomp
            The number of pairs of user-defined low- and high-edge components
            on the cyclic sector (if any). The default value of 0 specifies
            automatic detection of sector edges; however, the automatic setting
            is not valid in all cases. (For more information, see the Notes
            section below.) If the value is greater than 0, no verification of
            user-defined components occurs.

        usrnmap
            The name of a user-defined array specifying the matching node pairs
            between the sector low and high edges. Valid only when USRCOMP = 0.
            Skips the automatic detection of sector edges. Node pairs may be
            input in any order, but the low edge node must be the first entry
            in each pair.

        Notes
        -----
        You can input your own value for NSECTOR, ANGLE or KCN; if you do so,
        the command verifies argument values before executing.

        When USRCOMP = 0 and USRNMAP = blank (default), the CYCLIC command
        automatically detects low- and high-edge components for models
        comprised of any combination of line, area, or volume elements. If a
        solid model exists, however, the  command uses only the lines, areas,
        and/or volumes to determine the  low- and high-edge components; the
        elements, if any, are ignored.

        Nodes will be automatically rotated unless CYCOPT,USERROT,YES has been
        specified.

        If you issue a CYCOPT,TOLER command to set a tolerance for edge-
        component pairing before issuing the CYCLIC command, the CYCLIC command
        uses the specified tolerance when performing automatic edge-component
        detection.

        For 2-D models, autodetection does not consider the CSYS,5 or CSYS,6
        coordinate system specification.  Autodetection for 180 degree (two-
        sector) models is not possible unless a central hole exists.

        The CYCLIC command sets values and keys so that, if possible, the area-
        mesh (AMESH) or volume-mesh (VMESH) command meshes the sector with
        matching node and element face patterns on the low and high edges. (The
        command has no effect on any other element-creation command.)

        Issue the CYCLIC command prior to the meshing command to, if possible,
        produce a mesh with identical node and element patterns on the low and
        high sector edges. Only the AMESH or VMESH commands can perform
        automated matching. (Other meshing operation commands such as VSWEEP
        cannot.) If you employ a meshing operation other than AMESH or VMESH,
        you should ensure that node and element face patterns match, if
        desired. The CYCLIC command output indicates whether each edge-
        component pair has or can produce a matching node pair.

        A cyclic solution (via the SOLVE command) allows dissimilar mesh
        patterns on the extreme boundaries of a cyclically symmetric model. The
        allowance for dissimilar patterns is useful when you have only finite-
        element meshes for your model but not the geometry data necessary to
        remesh it to obtain identical node patterns. In such cases, it is
        possible to obtain solution results, although perhaps at the expense of
        accuracy. A warning message appears because results may be degraded
        near the sector edges.

        The constraint equations (CEs) that tie together the low and high edges
        of your model are generated at the solution stage of the analysis from
        the low- and high-edge components (and nowhere else). You should verify
        that automatically detected components are in the correct  locations
        and that you can account for all components; to do so, you can list
        (CMLIST) or plot (CMPLOT) the components.

        If you issue the CYCLIC command after meshing and have defined element
        types with rotational degrees of freedom (DOFs), ANSYS generates cyclic
        CEs for rotational DOFs that may not exist on the sector boundaries.
        Issue the CYCOPT,DOF command to prevent unused rotational terms from
        being generated.

        Modal cyclic symmetry analysis is supported by the following
        eigensolvers:

        Block Lanczos (MODOPT,LANB)

        PCG Lanczos (MODOPT,LANPCG)

        Super Node (MODOPT,SNODE)

        Subspace (MODOPT,SUBSP)

        To learn more about analyzing a cyclically symmetric structure, see the
        Cyclic Symmetry Analysis Guide.

        When using the: CYCLIC: command to automatically detect the sector, if
        an area is defined with the: AL: command, the lines need to be oriented
        to form the closed curve.
        """
        command = "CYCLIC,%s,%s,%s,%s,%s,%s" % (str(nsector), str(angle), str(kcn), str(name), str(usrcomp), str(usrnmap))
        return self.run(command, **kwargs)

    def esys(self, kcn="", **kwargs):
        """APDL Command: ESYS

        Sets the element coordinate system attribute pointer.

        Parameters
        ----------
        kcn
            Coordinate system number:

            0 - Use element coordinate system orientation as defined (either by default or by
                KEYOPT setting) for the element (default).

            N - Use element coordinate system orientation based on local coordinate system N
                (where N must be greater than 10). For global system 0, 1, or
                2, define a local system N parallel to appropriate system with
                the LOCAL or CS command (for example: LOCAL,11,1).

        Notes
        -----
        Identifies the local coordinate system to be used to define the element
        coordinate system of subsequently defined elements. Used only with area
        and volume elements. For non-layered volume elements, the local
        coordinate system N is simply assigned to be the element coordinate
        system. For shell and layered volume elements, the x and y axes of the
        local coordinate system N are projected onto the shell or layer plane
        to determine the element coordinate system. See Understanding the
        Element Coordinate System for more details. N refers to the coordinate
        system reference number (KCN) defined using the LOCAL (or similar)
        command. Element coordinate system numbers may be displayed [/PNUM].
        """
        command = "ESYS,%s" % (str(kcn))
        return self.run(command, **kwargs)

    def ssum(self, **kwargs):
        """APDL Command: SSUM

        Calculates and prints the sum of element table items.

        Notes
        -----
        Calculates and prints the tabular sum of each existing labeled result
        item [ETABLE] for the selected elements.  If absolute values are
        requested [SABS,1], absolute values are used.
        """
        command = "SSUM," % ()
        return self.run(command, **kwargs)

    def inres(self, item1="", item2="", item3="", item4="", item5="", item6="",
              item7="", item8="", **kwargs):
        """APDL Command: INRES

        Identifies the data to be retrieved from the results file.

        Parameters
        ----------
        item1, item2, item3, . . . , item8
            Data to be read into the database from the results file.  May
            consist of any of the following labels:

            ALL - All solution items (default).

            BASIC - NSOL, RSOL, NLOAD, STRS, FGRAD, and FFLUX items.

            NSOL - Nodal DOF solution.

            RSOL - Nodal reaction loads.

            ESOL - Element solution items (includes all of the following):

            NLOAD - Element nodal loads.

            STRS - Element nodal stresses.

            EPEL - Element elastic strains.

            EPTH - Element thermal, initial, and swelling strains.

            EPPL - Element plastic strains.

            EPCR - Element creep strains.

            FGRAD - Element nodal gradients.

            FFLUX - Element nodal fluxes.

            MISC - Element miscellaneous data (SMISC and NMISC).

        Notes
        -----
        Identifies the type of data to be retrieved from the results file for
        placement into the database through commands such as SET, SUBSET, and
        APPEND.  INRES is a companion command to the OUTRES command controlling
        data written to the database and the results file.  Since the INRES
        command can only flag data that has already been written to the results
        file, care should be taken when using the OUTRES command to include all
        data you wish to retrieve for postprocessing later on.
        """
        command = "INRES,%s,%s,%s,%s,%s,%s,%s,%s" % (str(item1), str(item2), str(item3), str(item4), str(item5), str(item6), str(item7), str(item8))
        return self.run(command, **kwargs)

    def setran(self, sename="", kcnto="", inc="", file="", ext="", dx="",
               dy="", dz="", norot="", **kwargs):
        """APDL Command: SETRAN

        Creates a superelement from an existing superelement.

        Parameters
        ----------
        sename
            The name (case-sensitive) of the file containing the original
            superelement matrix created by the generation pass (Sename.SUB).
            The default is the current Jobname.  If Sename is a number, it is
            the element number of a previously defined superelement in the
            current use pass.

        kcnto
            The reference number of the coordinate system to where the
            superelement is to be transferred. The default is the global
            Cartesian system.  Transfer occurs from the active coordinate
            system.

        inc
            The node offset.  The default is zero.  All new element node
            numbers are offset from those on the original by INC.

        file
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        dx, dy, dz
            Node location increments in the global Cartesian coordinate system.
            Defaults to zero.

        norot
            Node rotation key:

            0 - The nodal coordinate systems of the transferred superelement rotate into the
                KCNTO system. (That is, the nodal coordinate systems rotate
                with the superelement.) The superelement matrices remain
                unchanged. This value is the default.

            1 - The nodal coordinate systems do not rotate. (That is, they remain fixed in
                their original global orientation.)  The superelement matrices
                and load vectors are modified if any rotations occur.

        Notes
        -----
        The SETRAN command creates a superelement from an existing superelement
        and writes the new element to a file.  You can then issue an SE command
        to read the new element (during the use pass).

        You can create a superelement from an original by:

        Transferring the original's geometry from the active coordinate system
        into another coordinate system (KCNTO)

        Offsetting its geometry in the global Cartesian coordinate system (DX,
        DY, and DZ )

        Offsetting its node numbers (INC).

        A combination of methods is valid. If you specify both the geometry
        transfer and the geometry offset, the transfer occurs first.

        If you specify rotation of the transferred superelement's nodal
        coordinate systems into the KCNTO system (NOROT = 0), the rotated nodes
        cannot be coupled via the CP command; in this case, issue the CE
        command instead. If you specify no rotation of the nodal coordinate
        systems (NOROT = 1) for models with displacement degrees of freedom,
        and KCNTO is not the active system, the superelement Sename must have
        six MDOF at each node that has MDOF; therefore, only elements with all
        six structural DOFs are valid in such cases.

        There is no limit to the number of copies that can be made of a
        superelement, provided the copies are all generated from the same
        original superelement. However, nested copies are limited to five. In
        other words, the total number of different Sename usages on the SETRAN
        and SESYMM commands is limited to five.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "SETRAN,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(sename), str(kcnto), str(inc), str(file), str(ext), str(dx), str(dy), str(dz), str(norot))
        return self.run(command, **kwargs)

    def fc(self, mat="", lab1="", lab2="", data1="", data2="", data3="",
           data4="", data5="", data6="", **kwargs):
        """APDL Command: FC

        Provides failure criteria information and activates a data table to
        input temperature-dependent stress and strain limits.

        Parameters
        ----------
        mat
             Material reference number. You can define failure criteria for up
            to 250 different materials.

        lab1
            Type of data.

            TEMP - Temperatures. Each of the materials you define can have a different set of
                   temperatures to define the failure criteria.

            EPEL - Strains.

            S - Stresses.

        lab2
            Specific criteria. Not used if Lab1 = TEMP.

            XTEN - Allowable tensile stress or strain in the x-direction. (Must be positive.)

            XCMP - Allowable compressive stress or strain in the x-direction. (Defaults to
                   negative of XTEN.)

            YTEN - Allowable tensile stress or strain in the y-direction. (Must be positive.)

            YCMP - Allowable compressive stress or strain in the y-direction. (Defaults to
                   negative of YTEN.)

            ZTEN - Allowable tensile stress or strain in the z-direction. (Must be positive.)

            ZCMP - Allowable compressive stress or strain in the z-direction. (Defaults to
                   negative of ZTEN.)

            XY - Allowable XY stress or shear strain. (Must be positive.)

            YZ - Allowable YZ stress or shear strain. (Must be positive.)

            XZ - Allowable XZ stress or shear strain. (Must be positive.)

            XYCP - XY coupling coefficient (Used only if Lab1 = S). Defaults to -1.0. [1]

            YZCP - YZ coupling coefficient (Used only if Lab1 = S). Defaults to -1.0. [1]

            XZCP - XZ coupling coefficient (Used only if Lab1 = S). Defaults to -1.0. [1]

        data1, data2, data3, . . . , data6
            Description of DATA1 through DATA6.

            T1, T2, T3, T4, T5, T6 - Temperature at which limit data is input. Used only when Lab1 = TEMP.

            V1, V2, V3, V4, V5, V6 - Value of limit stress or strain at temperature T1 through T6. Used only when
                              Lab1 = S or EPEL.

        Notes
        -----
        The data table can be input in either PREP7 or POST1. This table is
        used only in POST1. When you postprocess failure criteria results
        defined via the FC command (PLESOL, PRESOL, PLNSOL, PRNSOL, PRRSOL,
        etc.), the active coordinate system must be the coordinate system of
        the material being analyzed. You do this using RSYS, SOLU. For layered
        applications, you also use the LAYER command. See the specific element
        documentation in the Element Reference for information on defining your
        coordinate system for layers.

        Some plotting and printing functions will not support Failure Criteria
        for your PowerGraphics displays. This could result in minor changes to
        other data when Failure Criteria are applied. See the appropriate plot
        or print command documentation for more information .
        """
        command = "FC,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(mat), str(lab1), str(lab2), str(data1), str(data2), str(data3), str(data4), str(data5), str(data6))
        return self.run(command, **kwargs)

    def bcsoption(self, memory_option="", memory_size="", solve_info="",
                  **kwargs):
        """APDL Command: BCSOPTION

         Sets memory option for the sparse solver.

        Parameters
        ----------
        --
            Unused field

        memory_option
            Memory allocation option:

            DEFAULT - Use the default memory allocation strategy for the sparse solver. The default
                      strategy attempts to run in the INCORE memory mode. If
                      there is not enough available physical memory when the
                      solver starts to run in the INCORE memory mode, the
                      solver will then attempt to run in the OUTOFCORE memory
                      mode.

            INCORE -  Use a memory allocation strategy in the sparse solver that will attempt to
                     obtain enough memory to run with the entire factorized
                     matrix in memory. This option uses the most amount of
                     memory and should avoid doing any I/O. By avoiding I/O,
                     this option achieves optimal solver performance. However,
                     a significant amount of memory is required to run in this
                     mode, and it is only recommended on machines with a large
                     amount of memory. If the allocation for in-core memory
                     fails, the solver will automatically revert to out-of-core
                     memory mode.

            OUTOFCORE - Use a memory allocation strategy in the sparse solver that will attempt to
                        allocate only enough work space to factor each
                        individual frontal matrix in memory, but will store the
                        entire factorized matrix on disk. Typically, this
                        memory mode results in poor performance due to the
                        potential bottleneck caused by the I/O to the various
                        files written by the solver.

            FORCE - This option, when used in conjunction with the Memory_Size option, allows you
                    to force the sparse solver to run with a specific amount of
                    memory. This option is only recommended for the advanced
                    user who understands sparse solver memory requirements for
                    the problem being solved, understands the physical memory
                    on the system, and wants to control the sparse solver
                    memory usage.

        memory_size
            Initial memory size allocation for the sparse solver in MB. This
            argument allows you to tune the sparse solver memory and is not
            generally required. Although there is no upper limit for
            Memory_Size, the Memory_Size setting should always be well within
            the physical memory available, but not so small as to cause the
            sparse solver to run out of memory. Warnings and/or errors from the
            sparse solver will appear if this value is set too low. If the
            FORCE memory option is used, this value is the amount of memory
            allocated for the entire duration of the sparse solver solution.

        --, --
            Unused fields

        solve_info
            Solver output option:

            OFF - Turns off additional output printing from the sparse solver (default).

            PERFORMANCE - Turns on additional output printing from the sparse solver, including a
                          performance summary and a summary of file I/O for the
                          sparse solver. Information on memory usage during
                          assembly of the global matrix (that is, creation of
                          the Jobname.FULL file) is also printed with this
                          option.

        Notes
        -----
        This command controls options related to the sparse solver in all
        analysis types where the sparse solver can be used. It also controls
        the Block Lanczos eigensolver in a modal or buckling analysis.

        The sparse solver runs from one large work space (that is, one large
        memory allocation). The amount of memory required for the sparse solver
        is unknown until the matrix structure is preprocessed, including
        equation reordering. The amount of memory allocated for the sparse
        solver is then dynamically adjusted to supply the solver what it needs
        to compute the solution.

        If you have a very large memory system, you may want to try selecting
        the INCORE memory mode for larger jobs to improve performance. When
        running the sparse solver on a machine with very slow I/O performance
        (for example, slow hard drive speed), you may want to try using the
        INCORE memory mode to achieve better performance. However, doing so may
        require much more memory compared to running in the OUTOFCORE memory
        mode.

        Running with the INCORE memory mode is best for jobs which comfortably
        fit within the limits of the physical memory on a given system. If the
        sparse solver work space exceeds physical memory size, the system will
        be forced to use virtual memory (or the system page/swap file). In this
        case, it is typically more efficient to run with the OUTOFCORE memory
        mode. Assuming the job fits comfortably within the limits of the
        machine, running with the INCORE memory mode is often ideal for jobs
        where repeated solves are performed for a single matrix factorization.
        This occurs in a modal or buckling analysis or when doing multiple load
        steps in a linear, static analysis.

        For repeated runs with the sparse solver, you may set the initial
        sparse solver memory allocation to the amount required for
        factorization. This strategy reduces the frequency of allocation and
        reallocation in the run to make the INCORE option fully effective. If
        you have a very large memory system, you may use the Memory_Size
        argument to increase the maximum size attempted for in-core runs.
        """
        command = "BCSOPTION,%s,%s,%s" % (str(memory_option), str(memory_size), str(solve_info))
        return self.run(command, **kwargs)

    def prjsol(self, item="", comp="", **kwargs):
        """APDL Command: PRJSOL

        Prints joint element output.

        Parameters
        ----------
        item
            Label identifying the item. Some items also require a component
            label.

            DISP - Relative displacements.

            ROT - Relative rotations.

            VEL - Relative linear velocities.

            OMG - Relative angular velocities.

            ACC - Relative linear accelerations.

            DMG - Relative angular accelerations.

            SMISC - Summable miscellaneous quantities.

        comp
            Component of the item (if required). For Item = DISP, ROT, VEL,
            OMG, ACC, and DMG, enter the direction label, X, Y, or Z. For Item
            = SMISC, enter a valid number.

        Notes
        -----
        Prints element output for the MPC184 joint element. The joint element
        quantities printed are the values for the free or unconstrained
        relative degrees of freedom.

        This command is valid in POST1 only.
        """
        command = "PRJSOL,%s,%s" % (str(item), str(comp))
        return self.run(command, **kwargs)

    def avprin(self, key="", effnu="", **kwargs):
        """APDL Command: AVPRIN

        Specifies how principal and vector sums are to be calculated.

        Parameters
        ----------
        key
            Averaging key:

            0 - Average the component values from the elements at a common node, then calculate
                the principal or vector sum from the averaged components
                (default).

            1 - Calculate the principal or vector sum values on a per element basis, then
                average these values from the elements at a common node.

        effnu
            Effective Poisson's ratio used for computing the von Mises
            equivalent strain (EQV). This command option is intended for use
            with line elements or in load case operations (LCOPER) only; ANSYS
            automatically selects the most appropriate effective Poisson's
            ratio, as discussed below.

        Notes
        -----
        Selects the method of combining components for certain derived nodal
        results when two or more elements connect to a common node.  The
        methods apply to the calculations of derived nodal principal stresses,
        principal strains, and vector sums for selects, sorts, and output
        [NSEL, NSORT, PRNSOL, PLNSOL, etc.].

        This command also defines the effective Poisson's ratio (EFFNU) used
        for equivalent strain calculations.  If you use EFFNU, the default
        effective Poisson's ratios shown below will be overridden for all
        elements by the EFFNU value. To return to the default settings, issue
        the RESET command. The default value for EFFNU is:

        Poisson's ratio as defined on the MP commands for EPEL and EPTH

        0.5 for EPPL and EPCR

        0.5 if the referenced material is hyperelastic

        0.0 for line elements (includes beam, link, and pipe elements, as well
        as discrete elements), cyclic symmetry analysis, mode superposition
        analyses (with MSUPkey = YES on the MXPAND command), and load case
        operations (LCOPER).

        For the von Mises equivalent strain (EQV), it is always computed using
        the average of the equivalent strains from the elements at a common
        node irrespective of the value of the averaging KEY. If EFFNU is input,
        though, the calculation will be performed according to the KEY setting.

        For a random vibration (PSD) analysis, issuing either AVPRIN,0 or
        AVPRIN,1 calculates the principal stresses using the appropriate
        averaging method. They are then used to determine SEQV.  The output
        will have non-zero values for the principal stresses.

        If AVPRIN is not issued, the Segalman-Fulcher method is used to
        calculate SEQV. This method does not calculate principal stresses, but
        directly calculates SEQV from the component stresses; therefore, the
        output will have zero values for the principal stresses. Beam and pipe
        elements are excluded

        This command is also valid in POST26, where applicable.

        See Combined Stresses and Strains in the Mechanical APDL Theory
        Reference for more information.
        """
        command = "AVPRIN,%s,%s" % (str(key), str(effnu))
        return self.run(command, **kwargs)

    def edrun(self, option="", cons="", ncpu="", **kwargs):
        """APDL Command: EDRUN

        Specify LS-DYNA serial or parallel processing.

        Parameters
        ----------
        option
             LS-DYNA processing option

            SERIAL - Use serial processing (default)

            SMP - Use Shared Memory Parallel processing

        cons
            Consistency setting (only applicable when Option = SMP)

            0 - Result consistency is not required (default)

            1 - Result consistency is required

        ncpu
            Number of processors to use (applicable only with Option = SMP)

        Notes
        -----
        The EDRUN command specifies either serial (one CPU) processing or
        shared (multiple CPU) memory parallel processing (SMP). When using SMP,
        the calculations may be executed in a different order, depending on CPU
        availability and the load on each CPU. You may therefore see slight
        differences in the results when running the same job multiple times,
        either with the same number or a different number of processors.
        Comparing nodal accelerations often shows wider discrepancies. To avoid
        such differences, you can specify that consistency be maintained by
        setting CONS = 1. Maintaining consistency can result in an increase of
        up to 15 percent in CPU time.

        The parallel processing setting is only effective when you have
        multiple CPUs and licenses for the appropriate number of ANSYS LS-DYNA
        SMP tasks. If your site does not meet both requirements, the EDRUN
        command sets serial processing, regardless of command settings.

        For more information on using SMP, see Solution Features in the ANSYS
        LS-DYNA User's Guide.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDRUN,%s,%s,%s" % (str(option), str(cons), str(ncpu))
        return self.run(command, **kwargs)

    def e(self, i="", j="", k="", l="", m="", n="", o="", p="", **kwargs):
        """APDL Command: E

        Defines an element by node connectivity.

        Parameters
        ----------
        i
            Number of node assigned to first nodal position (node I). If I = P,
            graphical picking is enabled and all remaining command fields are
            ignored (valid only in the GUI).

        j, k, l, m, n, o, p
            Number assigned to second (node J) through eighth (node P) nodal
            position, if any.

        Notes
        -----
        Defines an element by its nodes and attribute values. Up to 8 nodes may
        be specified with the E command.  If more nodes are needed for the
        element, use the EMORE command. The number of nodes required and the
        order in which they should be specified are described in Chapter 4 of
        the Element Reference for each element type.  Elements are
        automatically assigned a number [NUMSTR] as generated. The current (or
        default) MAT, TYPE, REAL, SECNUM and ESYS attribute values are also
        assigned to the element.

        When creating elements with more than 8 nodes using this command and
        the EMORE command, it may be necessary to turn off shape checking using
        the SHPP command before issuing this command. If a valid element type
        can be created without using the additional nodes on the EMORE command,
        this command will create that element. The EMORE command will then
        modify the element to include the additional nodes. If shape checking
        is active, it will be performed before the EMORE command is issued.
        Therefore, if the shape checking limits are exceeded, element creation
        may fail before the EMORE command modifies the element into an
        acceptable shape.
        """
        command = "E,%s,%s,%s,%s,%s,%s,%s,%s" % (str(i), str(j), str(k), str(l), str(m), str(n), str(o), str(p))
        return self.run(command, **kwargs)

    def sv(self, damp="", sv1="", sv2="", sv3="", sv4="", sv5="", sv6="",
           sv7="", sv8="", sv9="", **kwargs):
        """APDL Command: SV

        Defines spectrum values to be associated with frequency points.

        Parameters
        ----------
        damp
            Damping ratio for this response spectrum curve.  If the same as a
            previously defined curve, the SV values are added to the previous
            curve.  Up to four different curves may be defined, each with a
            different damping ratio.  Damping values must be input in ascending
            order.

        sv1, sv2, sv3, . . . , sv9
            Spectrum values corresponding to the frequency points [FREQ].
            Values are interpreted as defined with the SVTYP command.   SV
            values should not be zero.  Values required outside the frequency
            range use the extreme input values.

        Notes
        -----
        Defines the spectrum values to be associated with the previously
        defined frequency points [FREQ].  Applies only to the single-point
        response spectrum.  Damping has no effect on the frequency solution.
        Damping values are used only to identify SV curves for the mode
        combinations calculation.  Only the curve with the lowest damping value
        is used in the initial mode coefficient calculation.  Use STAT command
        to list current spectrum curve values.

        Repeat SV command for additional SV points (100 maximum per DAMP
        curve).  SV values are added to the DAMP curve after the last nonzero
        SV value.

        The interpolation method between response spectrum points and curves is
        specified using KeyInterp in the SVTYP command. It is logarithmic by
        default.

        This command is also valid in PREP7.
        """
        command = "SV,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(damp), str(sv1), str(sv2), str(sv3), str(sv4), str(sv5), str(sv6), str(sv7), str(sv8), str(sv9))
        return self.run(command, **kwargs)

    def kmodif(self, npt="", x="", y="", z="", **kwargs):
        """APDL Command: KMODIF

        Modifies an existing keypoint.

        Parameters
        ----------
        npt
            Modify coordinates of this keypoint.  If NPT = ALL, modify
            coordinates of all selected keypoints [KSEL].  If NPT = P,
            graphical picking is enabled and all remaining command fields are
            ignored (valid only in the GUI).  A component name may also be
            substituted for NPT.

        x, y, z
            Replace the previous coordinate values assigned to this keypoint
            with these corresponding coordinate values.  Values are interpreted
            according to the active coordinate system (R, θ, Z for cylindrical,
            R, θ,Φ for spherical).  If X = P, graphical picking is used to
            locate keypoint and Y and Z are ignored.  A blank retains the
            previous value.  You cannot specify Y = P.

        Notes
        -----
        Lines, areas, and volumes attached to the modified keypoint (if any)
        must all be selected and will be redefined using the active coordinate
        system.  However, solid modeling in a toroidal coordinate system is not
        recommended.

        Caution:: : Redefined entities may be removed from any defined
        components and assemblies. Nodes and elements will be automatically
        cleared from any redefined keypoints, lines, areas, or volumes.

        The KMODIF command moves keypoints for geometry modification without
        validating underlying entities. To merge keypoints and update higher
        order entities, issue the NUMMRG command instead.
        """
        command = "KMODIF,%s,%s,%s,%s" % (str(npt), str(x), str(y), str(z))
        return self.run(command, **kwargs)

    def ceintf(self, toler="", dof1="", dof2="", dof3="", dof4="", dof5="",
               dof6="", movetol="", **kwargs):
        """APDL Command: CEINTF

        Generates constraint equations at an interface.

        Parameters
        ----------
        toler
            Tolerance about selected elements, based on a fraction of the
            element dimension (defaults to 0.25 (25%)).  Nodes outside the
            element by more than the tolerance are not accepted as being on the
            interface.

        dof1, dof2, dof3, . . . , dof6
            Degrees of freedom for which constraint equations are written.
            Defaults to all applicable DOFs.  DOF1 accepts ALL as a valid
            label, in which case the rest are ignored (all DOFs are applied).

        movetol
            The allowed "motion" of a node (see Note below).  This distance is
            in terms of the element coordinates (-1.0 to 1.0).  A typical value
            is 0.05.  Defaults to 0 (do not move).  MoveTol must be less than
            or equal to TOLER.

        Notes
        -----
        This command can be used to "tie" together two regions with dissimilar
        mesh patterns by generating constraint equations that connect the
        selected nodes of one region to the selected elements of the other
        region.  At the interface between regions, nodes should be selected
        from the more dense mesh region, A, and the elements selected from the
        less dense mesh region, B.  The degrees of freedom of region A nodes
        are interpolated with the corresponding degrees of freedom of the nodes
        on the region B elements, using the shape functions of the region B
        elements.  Constraint equations are then written that relate region A
        and B nodes at the interface.

        The MoveTol field lets the nodes in the previously mentioned region A
        change coordinates when slightly inside or outside the elements of
        region B.  The change in coordinates causes the nodes of region A to
        assume the same surface as the nodes associated with the elements of
        region B.   The constraint equations that relate the nodes at both
        regions of the interface are then written.

        Solid elements with six degrees of freedom should only be interfaced
        with other six degree-of-freedom elements.  The region A nodes should
        be near the region B elements.   A location tolerance based on the
        smallest region B element length may be input.  Stresses across the
        interface are not necessarily continuous.  Nodes in the interface
        region should not have specified constraints.

        Use the CPINTF command to connect nodes by coupling instead of
        constraint equations.  Use the EINTF command to connect nodes by line
        elements.  See also the NSEL and ESEL commands for selecting nodes and
        elements.  See the Mechanical APDL Theory Reference for a description
        of 3-D space used to determine if a node will be considered by this
        command.

        As an alternative to the CEINTF command, you can use contact elements
        and the internal multipoint constraint (MPC) algorithm to tie together
        two regions having dissimilar meshes. See Solid-Solid and Shell-Shell
        Assemblies for more information.
        """
        command = "CEINTF,%s,%s,%s,%s,%s,%s,%s,%s" % (str(toler), str(dof1), str(dof2), str(dof3), str(dof4), str(dof5), str(dof6), str(movetol))
        return self.run(command, **kwargs)

    def spfreq(self, tblno="", freq1="", freq2="", freq3="", freq4="",
               freq5="", freq6="", freq7="", **kwargs):
        """APDL Command: SPFREQ

        Defines the frequency points for the input spectrum tables SPVAL vs.
        SPFREQ for multi-point spectrum analysis.

        Parameters
        ----------
        tblno
            Input table number. Up to 200 tables may be defined.

        freq1, freq2, freq3,..., freq7
            Frequency points (Hz) for spectrum vs. frequency tables. FREQ1
            should be greater than zero, and values must be in ascending order.

        Notes
        -----
        The spectrum values are input with the SPVAL command. A separate SPFREQ
        command must be used for each table defined. Frequencies must be in
        ascending order.

        Repeat SPFREQ command for additional frequency points. Values are added
        after the last nonzero frequency.

        If all fields after SPFREQ are blank, all input vs. frequency tables
        are erased. If TBLNO is the only non-blank field, all corresponding
        SPVAL curves are erased.

        Use the SPTOPT and STAT commands to list current frequency points.

        This command is also valid in PREP7.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "SPFREQ,%s,%s,%s,%s,%s,%s,%s,%s" % (str(tblno), str(freq1), str(freq2), str(freq3), str(freq4), str(freq5), str(freq6), str(freq7))
        return self.run(command, **kwargs)

    def itengine(self, type="", enginename="", precondname="", matrix="",
                 rhsvector="", solvector="", maxiter="", toler="", **kwargs):
        """APDL Command: *ITENGINE

        Performs a solution using an iterative solver.

        Parameters
        ----------
        type
            Specifies the algorithm to be used:

        enginename
            Name used to identify this iterative solver engine. Must be
            specified.

        precondname
            Linear solver engine name (*LSENGINE) identifying the factored
            matrix to be used as the preconditioner.

        matrix
            Name of the matrix to solve.

        rhsvector
            Matrix (load vector) name.

        solvector
            Solution vector name. If non-zero, it will be taken as the initial
            vector for the iterative process.

        maxiter
            Maximum number of iterations allowed. Default is 2 times the number
            of rows in the matrix.

        toler
            Convergence tolerance. Default is 1.0E-8.

        Notes
        -----
        This command solves Ax = b using a preconditioned conjugate gradient
        algorithm. It uses an existing factored system as the preconditioner.
        This solution method is useful if an existing matrix has been solved
        and minor changes have been made to the matrix.
        """
        command = "*ITENGINE,%s,%s,%s,%s,%s,%s,%s,%s" % (str(type), str(enginename), str(precondname), str(matrix), str(rhsvector), str(solvector), str(maxiter), str(toler))
        return self.run(command, **kwargs)

    def wpcsys(self, wn="", kcn="", **kwargs):
        """APDL Command: WPCSYS

        Defines the working plane location based on a coordinate system.

        Parameters
        ----------
        wn
            Window number whose viewing direction will be modified to be normal
            to the working plane (defaults to 1).  If WN is a negative value,
            the viewing direction will not be modified.

        kcn
            Coordinate system number.  KCN may be 0,1,2 or any previously
            defined local coordinate system number (defaults to the active
            system).

        Notes
        -----
        Defines a working plane location and orientation based on an existing
        coordinate system.  If a Cartesian system is used as the basis (KCN)
        for the working plane, the working plane will also be Cartesian, in the
        X-Y plane of the base system.  If a cylindrical, spherical, or toroidal
        base system is used, the working plane will be a polar system in the
        R-θ plane of the base system.

        If working plane tracking has been activated (CSYS,WP or CSYS,4), the
        updated active coordinate system will be of a similar type, except that
        a toroidal system will be updated to a cylindrical system.  See the
        Modeling and Meshing Guide for more information on working plane
        tracking.

        This command is valid in any processor.

        Some primitive generation commands will not honor R-theta
        transformations for non-cartesian coordinate systems. Refer to the
        primitive commands table for more information.
        """
        command = "WPCSYS,%s,%s" % (str(wn), str(kcn))
        return self.run(command, **kwargs)

    def vwrite(self, par1="", par2="", par3="", par4="", par5="", par6="",
               par7="", par8="", par9="", par10="", par11="", par12="",
               par13="", par14="", par15="", par16="", par17="", par18="",
               par19="", **kwargs):
        """APDL Command: *VWRITE

        Writes data to a file in a formatted sequence.

        Parameters
        ----------
        par1, par2, par3, . . . , par19
            You can write up to 19 parameters (or constants) at a time. Any Par
            values after a blank  Par value are ignored.  If you leave them all
            blank, one line will be written (to write a title or a blank line).
            If you input the keyword SEQU, a sequence of numbers (starting from
            1) will be written for that item.

        Notes
        -----
        You use *VWRITE to write data to a file in a formatted sequence. Data
        items (Par1, Par2, etc.) may be array parameters, scalar parameters,
        character parameters (scalar or array), or constants.  You must
        evaluate expressions and functions in the data item fields before using
        the *VWRITE command, since initially they will be evaluated to a
        constant and remain constant throughout the operation.  Unless a file
        is defined with the *CFOPEN  command, data is written to the standard
        output file. Data written to the standard output file may be diverted
        to a different file by first switching the current output file with the
        /OUTPUT command. You can also use the *MWRITE command to write data to
        a specified file. Both commands contain format descriptors on the line
        immediately following the command. The format descriptors can be in
        either Fortran or C format.

        You must enclose Fortran format descriptors in parentheses. They must
        immediately follow the *VWRITE command on a separate line of the same
        input file.  Do not include the word FORMAT. The format must specify
        the number of fields to be written per line, the field width, the
        placement of the decimal point, etc.  You should use one field
        descriptor for each data item written.  The write operation uses your
        system's available FORTRAN FORMAT conventions (see your system FORTRAN
        manual).  You can use any standard FORTRAN real format (such as
        (4F6.0), (E10.3,2X,D8.2), etc.) and alphanumeric format (A).
        Alphanumeric strings are limited to a maximum of 8 characters for any
        field (A8) using the Fortran format. Use the “C” format for string
        arrays larger than 8 characters. Integer (I) and list-directed (*)
        descriptors may not be used.  You can include text in the format as a
        quoted string.  The parentheses must be included in the format and the
        format must not exceed 80 characters (including parentheses).  The
        output line length is limited to 128 characters.

        The “C” format descriptors are used if the first character of the
        format descriptor line is not a left parenthesis. “C” format
        descriptors are up to 80 characters long, consisting of text strings
        and predefined "data descriptors" between the strings where numeric or
        alphanumeric character data will be inserted.  The normal descriptors
        are %I for integer data, %G for double precision data, %C for
        alphanumeric character data, and %/ for a line break. There must be one
        data descriptor for each specified value (8 maximum) in the order of
        the specified values. The enhanced formats described in *MSG may also
        be used.

        For array parameter items, you must define the starting array element
        number. Looping continues (incrementing the vector index number of each
        array parameter by one) each time you output a line, until the maximum
        array vector element is written.  For example, *VWRITE,A(1) followed by
        (F6.0) will write one value per output line, i.e., A(1), A(2), A(3),
        A(4), etc.  You write constants and scalar parameters with the same
        values for each loop.  You can also control the number of loops and
        loop skipping with the *VLEN and *VMASK commands.  The vector
        specifications *VABS,  *VFACT, and *VCUM  do not apply to this command.
        If looping continues beyond the supplied data array's length, zeros
        will be output for numeric array parameters and blanks for character
        array parameters.  For multi-dimensioned array parameters, only the
        first (row) subscript is incremented.  See the *VOPER command for
        details.  If you are in the GUI, the *VWRITE command must be contained
        in an externally prepared file and read into ANSYS (i.e., *USE, /INPUT,
        etc.).

        This command is valid in any processor.
        """
        command = "*VWRITE,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(par1), str(par2), str(par3), str(par4), str(par5), str(par6), str(par7), str(par8), str(par9), str(par10), str(par11), str(par12), str(par13), str(par14), str(par15), str(par16), str(par17), str(par18), str(par19))
        return self.run(command, **kwargs)

    def pdclr(self, type="", **kwargs):
        """APDL Command: PDCLR

        Clears the probabilistic design database.

        Parameters
        ----------
        type
            Specifies the part of the probabilistic database to be cleared.

            ALL - Clear the entire probabilistic database. Both the preprocessing and
                  postprocessing parts are cleared.

            POST - Clear only the postprocessing part of the probabilistic database. This is
                   necessary if you want to modify the deterministic model (the
                   analysis file) or probabilistic model (random variables,
                   correlations between random variables, or the random output
                   parameter) after a probabilistic analysis has already been
                   performed.

        Notes
        -----
        Clears the probabilistic design system (PDS) database. The settings are
        reset to their default values and the memory is cleared. Remember that
        the result files containing the results of the probabilistic loops are
        never deleted unless you intentionally delete them. We recommend that
        you use this command before switching to a new probabilistic analysis
        using a different probabilistic model (a different analysis loop file
        or deterministic model), or changing random input variables, their
        correlations, or random output parameters. Clearing the probabilistic
        database is not necessary if the probabilistic model remains the same
        and will be analyzed with a different probabilistic method or different
        method options. See the PDEXE command for restrictions. Before issuing
        the PDCLR command, you should save the probabilistic database using the
        PDSAVE command.
        """
        command = "PDCLR,%s" % (str(type))
        return self.run(command, **kwargs)

    def mftime(self, time="", **kwargs):
        """APDL Command: MFTIME

        Sets end time for an ANSYS Multi-field solver analysis.

        Parameters
        ----------
        time
            End time of an ANSYS Multi-field solver analysis. Defaults to 1.

        Notes
        -----
        A MFTIME setting overrides any other end time setting (TIME).

        This command is also valid in PREP7.

        See Multi-field Commands in the Coupled-Field Analysis Guide for a list
        of all ANSYS Multi-field solver commands and their availability for MFS
        and MFX analyses.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "MFTIME,%s" % (str(time))
        return self.run(command, **kwargs)

    def trnopt(self, method="", maxmode="", minmode="", mcout="", tintopt="",
               vaout="", **kwargs):
        """APDL Command: TRNOPT

        Specifies transient analysis options.

        Parameters
        ----------
        method
            Solution method for the transient analysis:

            FULL - Full method (default).

            MSUP - Mode-superposition method.

            VT - Variational Technology method.

        maxmode
            Largest mode number to be used to calculate the response (for
            Method = MSUP).  Defaults to the highest mode calculated in the
            preceding modal analysis.

        --
            Unused field.

        minmode
            Smallest mode number to be used (for Method = MSUP).  Defaults to
            1.

        mcout
            Modal coordinates output key (valid only for the mode-superposition
            method):

            NO - No output of modal coordinates (default).

            YES - Output modal coordinates to the text file Jobname.MCF.

        tintopt
            Time integration method for the transient analysis:

            NMK or 0 - Newmark algorithm (default).

            HHT or 1 - HHT algorithm (valid only for the full transient method).

        vaout
            Velocities and accelerations output key (valid only for mode-
            superposition transient analysis):

            NO - No output of velocities and accelerations (default).

            YES - Write velocities and accelerations on the reduced displacement file
                  Jobname.RDSP.

        Notes
        -----
        Specifies transient analysis (ANTYPE,TRANS) options. If used in
        SOLUTION, this command is valid only within the first load step. Use
        the TINTP command to set transient integration parameters.

        Method = VT is valid for either thermal or structural analysis, where
        it attempts to reduce the total number of iterations. Both linear and
        nonlinear structural transient analyses are supported. The VT method is
        a full transient solution.

        To include residual vectors in your mode-superposition transient
        analysis (Method = MSUP), specify RESVEC,ON.

        Method = MSUP is not available for ocean loading.

        This command is also valid in PREP7.

        Distributed ANSYS Restriction: The VT transient solution method is not
        supported in Distributed ANSYS.

        Additional product restrictions for the TRNOPT command are shown in the
        table below.

        The ANSYS Professional - Nonlinear Thermal (PR) product supports the
        Method = FULL option only when thermal degrees of freedom are present
        in the model.
        """
        command = "TRNOPT,%s,%s,%s,%s,%s,%s" % (str(method), str(maxmode), str(minmode), str(mcout), str(tintopt), str(vaout))
        return self.run(command, **kwargs)

    def rprism(self, z1="", z2="", nsides="", lside="", majrad="", minrad="",
               **kwargs):
        """APDL Command: RPRISM

        Creates a regular prism volume centered about the working plane origin.

        Parameters
        ----------
        z1, z2
            Working plane Z coordinates of the prism.

        nsides
            Number of sides in the polygon defining the top and bottom faces of
            the prism.  Must be greater than 2.

        lside
            Length of each side of the polygon defining the top and bottom
            faces of the prism.

        majrad
            Radius of the major (or circumscribed) circle of the polygon
            defining the top and bottom faces of the prism.  Not used if LSIDE
            is input.

        minrad
            Radius of the minor (or inscribed circle) of the polygon defining
            the top and bottom faces of the prism.  Not used if LSIDE or MAJRAD
            is input.

        Notes
        -----
        Defines a regular prism volume centered about the working plane origin.
        The prism must have a spatial volume greater than zero. (i.e., this
        volume primitive command cannot be used to create a degenerate volume
        as a means of creating an area.)  The top and bottom faces are
        polygonal areas that are parallel to the working plane but neither face
        need be coplanar with (i.e., "on") the working plane. The first
        keypoint defined for each face is at : θ = 0°.  See the RPR4 and PRISM
        commands for other ways to create prisms.
        """
        command = "RPRISM,%s,%s,%s,%s,%s,%s" % (str(z1), str(z2), str(nsides), str(lside), str(majrad), str(minrad))
        return self.run(command, **kwargs)

    def prcamp(self, option="", slope="", unit="", freqb="", cname="",
               stabval="", keyallfreq="", keynegfreq="", **kwargs):
        """APDL Command: PRCAMP

        Prints Campbell diagram data for applications involving rotating
        structure dynamics.

        Parameters
        ----------
        option
            Flag to activate or deactivate sorting of forward or backward whirl
            frequencies:

            0 (OFF or NO) - No sorting.

            1 (ON or YES) - Sort. This value is the default.

        slope
            The slope of the line to be printed. This value must be positive.

            SLOPE > 0  - The line represents the number of excitations per revolution of the rotor. For
                         example, SLOPE = 1 represents one excitation per
                         revolution, usually resulting from unbalance.

            SLOPE = 0  - The line represents the stability threshold for stability values or logarithmic
                         decrements printout (STABVAL = 1 or 2)

        unit
            Specifies the unit of measurement for rotational angular
            velocities:

            RDS - Rotational angular velocities in radians per second (rad/s). This value is the
                  default.

            RPM - Rotational angular velocities in revolutions per minute (RPMs).

        freqb
            The beginning, or lower end, of the frequency range of interest.
            The default is zero.

        cname
            The rotating component name.

        stabval
            Flag to print the stability values:

            0 (OFF or NO) - Print the frequencies (the imaginary parts of the eigenvalues in Hz). This
                            value is the default.

            1 (ON or YES) - Print the stability values (the real parts of the eigenvalues in Hz).

            2 - Print the logarithmic decrements.

        keyallfreq
            Key to specify if all frequencies above FREQB are printed out:

            0 (OFF or NO) - A maximum of 10 frequencies are printed out. They correspond to the frequencies
                            displayed via the PLCAMP command. This value is the
                            default.

            1 (ON or YES) - All frequencies are printed out.

        keynegfreq
            Key to specify if the negative frequencies are printed out. It only
            applies to solutions obtained with the damped eigensolver
            (Method=DAMP on the MODOPT command):

            0 (OFF or NO) - Only positive frequencies are printed out. This value is the default.

            1 (ON or YES) - Negative and positive frequencies are printed out.

        Notes
        -----
        The following items are required when generating a Campbell diagram:

        Take the gyroscopic effect into account by issuing the CORIOLIS command
        in the SOLUTION module.

        Run a modal analysis using the QR damped (MODOPT,QRDAMP) or damped
        (MODOPT,DAMP) method. Complex eigenmodes are necessary
        (MODOPT,QRDAMP,,,,Cpxmod  = ON), and you must specify the number of
        modes to expand (MXPAND).

        Define two or more load step results with an ascending order of
        rotational velocity (OMEGA or CMOMEGA).

        In some cases where modes are not in the same order from one load step
        to the other, sorting the frequencies (Option = 1) can help to obtain a
        correct printout. Sorting is based on the comparison between complex
        mode shapes calculated at two successive load steps.

        At each load step, the application compares the mode shape to the loads
        to determine the whirl direction. If applicable, a label appears (on
        the rows of output data) representing the whirl mode (BW for backward
        whirl and FW for forward whirl).

        If you specify a non-zero slope (SLOPE > 0), the command prints the
        critical speeds corresponding to the intersection points of the
        frequency curves and the added line. In the case of a named component
        (Cname), critical speeds relate to the rotational velocity of the
        component. Critical speeds are available only if the frequencies are
        printed (STABVAL = OFF).

        If you specify a zero slope (SLOPE = 0), the command prints the
        stability threshold corresponding to the sign change of the stability
        values (or logarithmic decrements). In the case of a named component
        (Cname), stability thresholds relate to the rotational velocity of the
        component. Stability thresholds are available only if the stability
        values or logarithmic decrements are printed (STABVAL = 1 or 2).

        At each load step, the program checks for instability (based on the
        sign of the real part of the eigenvalue). The label “U” appears on the
        printout for each unstable frequency.

        If specified, the rotational velocities of the named component (Cname)
        are printed out along with the natural frequencies.

        In general, printing a Campbell diagram is recommended only when your
        analysis is performed in a stationary reference frame
        (CORIOLIS,,,,RefFrame = ON).

        For information on printing a Campbell diagram for a prestressed
        structure, see Solving for a Subsequent Campbell Analysis of a
        Prestressed Structure Using the Linear Perturbation Procedure in the
        Rotordynamic Analysis Guide.

        For a usage example of the companion command PLCAMP (used for plotting
        a Campbell diagram), see Example Campbell Diagram Analysis.

        For more information on Campbell diagram generation, see Campbell
        Diagram in the Rotordynamic Analysis Guide.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "PRCAMP,%s,%s,%s,%s,%s,%s,%s,%s" % (str(option), str(slope), str(unit), str(freqb), str(cname), str(stabval), str(keyallfreq), str(keynegfreq))
        return self.run(command, **kwargs)

    def outopt(self, **kwargs):
        """APDL Command: OUTOPT

        Specifies "Output options" as the subsequent status topic.

        Notes
        -----
        This is a status [STAT] topic command.  Status topic commands are
        generated by the GUI and will appear in the log file (Jobname.LOG) if
        status is requested for some items under Utility Menu> List> Status.
        This command will be immediately followed by a STAT command, which will
        report the status for the specified topic.

        If entered directly into the program, the STAT command should
        immediately follow this command.
        """
        command = "OUTOPT," % ()
        return self.run(command, **kwargs)

    def nlhist(self, key="", name="", item="", comp="", node="", elem="",
               shell="", layer="", stop_value="", stop_cond="", **kwargs):
        """APDL Command: NLHIST

        Specify result items to track during solution.

        Parameters
        ----------
        key
            Specifies the command operation:

            NSOL - Nodal solution data.

            ESOL - Element nodal data.

            PAIR  - Contact data (for pair-based contact).

            GCN - Contact data (for general contact).

            STAT - Displays a list of items to track.

            OFF or 0 - Deactivates tracking of all variables. This value is the default.

            ON or 1 - Activates tracking of all variables.  Tracking also activates whenever any
                      specification changes.

            DEL - Removes the specified variable from the set of result items to track. If Name =
                  ALL (default), all specifications are removed.

        name
            The 32-character user-specified name.

        item, comp
            Predetermined output item and component label for valid elements.
            See the Element Reference for more information.

        node
            Number identifying one of the following:

        elem
            Valid element number for element results. Used for ESOL items. If
            ELEM is specified, then a node number that belongs to the element
            must also be specified in the NODE field.

        shell
            Valid labels are TOP, MID or BOT. This field can specify the
            location on shell elements for which to retrieve data. Used only
            for element nodal data (ESOL).

        layer
            Layer number (for layered elements only). Used only for element
            nodal data (ESOL).

        stop_value
            Critical value of the tracked variable. This value is used to
            determine if the analysis should be terminated. This field is only
            valid for contact data (Key = PAIR or GCN).

        stop_cond
            Specifies the conditional relationship between the variable being
            tracked and the STOP_VALUE upon which the analysis will be
            terminated:

            -1 - Terminate the analysis when the tracked variable is less than or equal to
                 STOP_VALUE.

            0 - Terminate the analysis when the tracked variable equals STOP_VALUE.

            1 - Terminate the analysis when the tracked variable is greater than or equal to
                STOP_VALUE.

        Notes
        -----
        The NLHIST command is a nonlinear diagnostics tool that enables you to
        monitor diagnostics results of interest in real time during a solution.

        You can track a maximum of 50 variables during solution. The specified
        result quantities are written to the file Jobname.nlh. Nodal results
        and contact results are written for every converged substep
        (irrespective of the OUTRES command setting) while element results are
        written only at time points specified via the OUTRES command. For time
        points where element results data is not available, a very small number
        is written instead. If the conditions for contact to be established are
        not satisfied, 0.0 will be written for contact results.

        Results tracking is available only for a nonlinear structural analysis
        (static or transient), a nonlinear steady-state thermal analysis, or a
        transient thermal analysis (linear or nonlinear). All results are
        tracked in the Solution Coordinate System (that is, nodal results are
        in the nodal coordinate system and element results are in the element
        coordinate system).

        Contact results can be tracked for elements CONTA171 through CONTA177;
        they cannot be tracked for CONTA178.

        When contact results are tracked (Key = PAIR or GCN), the user-
        specified name (Name argument) is used to create a user-defined
        parameter. This enables you to monitor the parameter during solution.
        As an example, you can use a named parameter to easily convert the
        contact stiffness units from FORCE/LENGTH3 to FORCE/LENGTH based on the
        initial contact area CAREA. Be sure to specify Name using the APDL
        parameter naming convention.

        The STOP_VALUE and STOP_COND arguments enable you to automatically
        terminate the analysis when a desired value for a tracked contact
        result has been reached. This capability is only available for contact
        variables (Key = PAIR or GCN).

        The Jobname.nlh file is an ASCII file that lists each time point at
        which a converged solution occurs along with the values of the relevant
        result quantities.

        The GUI option Solution> Results tracking provides an interface to
        define the result items to be tracked. The GUI also allows you to graph
        one or more variables against time or against other variables during
        solution. You can use the interface to graph or list variables from any
        .nlh file generated by the ANSYS program.

        You can also track results during batch runs. Either access the ANSYS
        Launcher and select File Tracking from the Tools menu, or type
        nlhist162 at the command line. Use the supplied file browser to
        navigate to your Jobname.nlh file, and click on it to invoke the
        tracking utility. You can use this utility to read the file at any
        time, even after the solution is complete (the data in the file must be
        formatted correctly).

        Table: 205:: : NLHIST - Valid NSOL Item and Component Labels

        For SHELL131 and SHELL132 elements with KEYOPT(3) = 0 or 1, use the
        labels TBOT, TE2, TE3, . . ., TTOP instead of TEMP.

        For SHELL131 and SHELL132 elements with KEYOPT(3) = 0 or 1, use the
        labels HBOT, HE2, HE3, . . ., HTOP instead of HEAT.

        Table: 206:: : NLHIST - Valid ESOL Item and Component Labels
        """
        command = "NLHIST,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(key), str(name), str(item), str(comp), str(node), str(elem), str(shell), str(layer), str(stop_value), str(stop_cond))
        return self.run(command, **kwargs)

    def supl(self, surfname="", rsetname="", kwire="", **kwargs):
        """APDL Command: SUPL

        Plot result data on all selected surfaces or on a specified surface.

        Parameters
        ----------
        surfname
            Eight character surface name. ALL will plot all selected surfaces.

        rsetname
            Eight character result name.

        kwire
            Plot in context of model.

            0 - Plot results without the outline of selected elements.

            1 - Plot results with the outline of selected elements.

        Notes
        -----
        If RSetName is left blank, then the surface geometry will be plotted.
        If the Setname portion of the argument is a vector prefix (i.e. if
        result sets of name SetNameX, SetNameY and SetNameZ exist), ANSYS will
        plot these vectors on the surface as arrows. For example, SUPL, ALL,
        NORM will plot the surface normals as vectors on all selected surfaces,
        since NORMX NORMY and NORMZ are pre-defined geometry items.
        """
        command = "SUPL,%s,%s,%s" % (str(surfname), str(rsetname), str(kwire))
        return self.run(command, **kwargs)

    def staopt(self, method="", **kwargs):
        """APDL Command: STAOPT

        Specifies static analysis options.

        Parameters
        ----------
        method
            Solution method for the static analysis:

            DEFA - Standard ANSYS solve (default).

            VT - Solve with Variational Technology.

        Notes
        -----
        Specifies the method of solution for a static analysis (ANTYPE,STATIC).
        If used in SOLUTION, this command is valid only within the first load
        step.

        The VT option is valid for either thermal or structural nonlinear
        analyses, where it attempts to reduce the total number of iterations.

        This command is also valid in PREP7.

        Distributed ANSYS Restriction: The VT static solution method is not
        supported in Distributed ANSYS.
        """
        command = "STAOPT,%s" % (str(method))
        return self.run(command, **kwargs)

    def msave(self, key="", **kwargs):
        """APDL Command: MSAVE

        Sets the solver memory saving option. This option only applies to the
        PCG solver (including PCG Lanczos).

        Parameters
        ----------
        key
            Activation key:

            0 or OFF - Use global assembly for the stiffness matrix (and mass matrix, when using PCG
                       Lanczos) of the entire model.

            1 or ON - Use an element-by-element approach when possible to save memory during the
                      solution. In this case, the global stiffness (and mass)
                      matrix is not assembled; element stiffness (and mass) is
                      regenerated during PCG or PCG Lanczos iterations.

        Notes
        -----
        MSAVE,ON only applies to and is the default for parts of the model
        using the following element types with linear material properties that
        meet the conditions listed below.

        SOLID186 (Structural Solid only)

        SOLID187

        The following conditions must also be true:

        The PCG solver has been specified.

        Small strains are assumed (NLGEOM,OFF).

        No prestress effects (PSTRES) are included.

        All nodes on the supported element types must be defined (i.e., the
        midside nodes cannot be removed using the EMID command).

        For elements with thermally dependent material properties, MSAVE,ON
        applies only to elements with uniform temperatures prescribed.

        The default element coordinate system must be used.

        If you manually force MSAVE,ON by including it in the input file, the
        model can include the following additional conditions:

        The analysis can be a modal analysis using the PCG Lanczos method
        (MODOPT,LANPCG).

        Large deflection effects (NLGEOM,ON) are included.

        SOLID185 (brick shapes and KEYOPT(2) = 3 only) elements can be
        included.

        All other element types or other parts of the model that don't meet the
        above criteria will be solved using global assembly (MSAVE,OFF). This
        command can result in memory savings of up to 70 percent over the
        global assembly approach for the part of the model that meets the
        criteria. Depending on the hardware (e.g., processor speed, memory
        bandwidth, etc.), the solution time may increase or decrease when this
        feature is used.

        This memory-saving feature runs in parallel when multiple processors
        are used with the /CONFIG command or with Distributed ANSYS. The gain
        in performance with using multiple processors with this feature turned
        on should be similar to the default case when this feature is turned
        off. Performance also improves when using the uniform reduced
        integration option for SOLID186 elements.

        This command does not support the layered option of the SOLID185 and
        SOLID186 elements.

        When using MSAVE,ON with the PCGOPT command, note the following
        restrictions:

        For static and modal analyses, MSAVE,ON is not valid when using a
        Lev_Diff value of 5 on the PCGOPT command; Lev_Diff will automatically
        be reset to 2.

        For modal analyses, MSAVE,ON is not valid with the StrmCk option of the
        PCGOPT command; Strmck will be set to OFF.

        For all analysis types, MSAVE,ON is not valid when the Lagrange
        multiplier option (LM_Key) of the PCGOPT command is set to ON; the
        MSAVE activation key will be set to OFF.

        For linear perturbation static and modal analyses, MSAVE,ON is not
        valid; the MSAVE activation key will be set to OFF.

        When using MSAVE,ON for modal analyses, no .FULL file will be created.
        The .FULL file may be necessary for subsequent analyses (e.g.,
        harmonic, transient mode-superposition, or spectrum analyses). To
        generate the .FULL file, rerun the modal analysis using the WRFULL
        command.
        """
        command = "MSAVE,%s" % (str(key))
        return self.run(command, **kwargs)

    def ic(self, node="", lab="", value="", value2="", nend="", ninc="",
           **kwargs):
        """APDL Command: IC

        Specifies initial conditions at nodes.

        Parameters
        ----------
        node
            Node at which initial condition is to be specified.  If ALL, apply
            to all selected nodes (NSEL).  If NODE = P, graphical picking is
            enabled and all remaining command fields are ignored (valid only in
            the GUI). A component name may be substituted for NODE.

        lab
            Degree-of-freedom label for which the initial condition is to be
            specified.  If ALL, use all appropriate labels.

        value
            Initial value of the degree of freedom (first-order value).
            Defaults to the program default for that degree of freedom (0.0 for
            structural analysis, TUNIF for thermal analysis, etc.). Values are
            in the nodal coordinate system and in radians for rotational
            degrees of freedom.

        value2
            Second-order degree of freedom value, mainly used to specify
            initial structural velocity.  Defaults to the program default for
            that degree of freedom (0.0 for structural analysis).  Values are
            in the nodal coordinate system and in radians/time for rotational
            degrees of freedom.

        nend, ninc
            Specifies the same initial condition values at the range of nodes
            from NODE to NEND (defaults to NODE), in steps of NINC (defaults to
            1).

        Notes
        -----
        The IC command specifies initial conditions, which are the initial
        values of the specified degrees of freedom. It is valid only for a
        static analysis and full method transient analysis (TIMINT,ON and
        TRNOPT,FULL). For the transient, the initial value is specified at the
        beginning of the first load step, that is, at time = 0.0.

        Initial conditions should always be step applied (KBC,1) and not
        ramped.

        If constraints (D, DSYM, etc.) and initial conditions are applied at
        the same node, the constraint specification overrides. Exercise caution
        when specifying constraints. The degree-of-freedom values start from
        zero, or the first value given in the table when table name is
        specified. To match the nonzero initial condition value with the
        initial value for degree-of-freedom constraint, use a table for the
        degree-of-freedom constraint.

        For thermal analyses, any TUNIF specification should be applied before
        the IC command; otherwise, the TUNIF specification is ignored.  If the
        IC command is input before any TUNIF specification, use the ICDELE
        command and then reissue any TUNIF specification and then follow with
        the IC command.

        When issuing the IC command for elements SOLID278 Layered Thermal Solid
        and SOLID279 Layered Thermal Solid with through-the-thickness degrees
        of freedom (KEYOPT(3) = 2), layers are always interpolated linearly
        based on the location of the degrees of freedom.

        Define consistent initial conditions. For example, if you define an
        initial velocity at a single degree of freedom, the initial velocity at
        every other degree of freedom will be 0.0, potentially leading to
        conflicting initial conditions. In most cases, you should define
        initial conditions at every unconstrained degree of freedom in your
        model. If you define an initial condition for any degree of freedom at
        the pilot node of a rigid body (see Modeling Rigid Bodies in the
        Contact Technology Guide for the definition of rigid body), then the
        same initial condition must also be defined for the same degree of
        freedom on all other nodes of the rigid body.

        After a solution has been performed, the specified initial conditions
        are overwritten by the actual solution and are no longer available. You
        must respecify them if you want to perform a subsequent analysis. You
        may want to keep a database file saved prior to the first solution for
        subsequent reuse.

        If you use the CDWRITE command to archive your model, first-order
        values (initial displacements, temperatures, etc.) specified via the IC
        command are not written to the archive file; however, second-order
        (structural velocity) terms are written.

        This command is also valid in PREP7.
        """
        command = "IC,%s,%s,%s,%s,%s,%s" % (str(node), str(lab), str(value), str(value2), str(nend), str(ninc))
        return self.run(command, **kwargs)

    def rmalist(self, **kwargs):
        """APDL Command: RMALIST

        Lists all defined master nodes for a ROM method.

        Notes
        -----
        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "RMALIST," % ()
        return self.run(command, **kwargs)

    def pdmeth(self, method="", samp="", **kwargs):
        """APDL Command: PDMETH

        Specifies the probabilistic analysis method.

        Parameters
        ----------
        method
            Label for the probabilistic analysis method.

            MCS - Monte Carlo Simulation

            RSM - Response Surface Method

        samp
            Label for the sampling techniques. The sampling technique
            determines the values of the random input variables during the
            simulation loops.

            DIR - Direct or Crude Monte Carlo Sampling. This technique randomly samples the
                  random input variables according to their distribution
                  functions without "memory" of previous simulations.

            The parameters for a Monte Carlo Simulation using direct sampling are specified with the PDDMCS command. - LHS

            Latin Hypercube Sampling (default). Valid only for Method = MCS. For this sampling technique the random input variables are sampled randomly according to their distribution functions, efficiently stratifying the samples into layers and avoiding the re-use of those layers. The sampling process has a "memory" of previous simulations, which prevents accumulation of clusters of samples. In addition, this sampling strategy forces the extreme ends of a distribution function to participate in the sampling. This generally leads to smoother distribution functions of the sampled set. - The parameters for a Monte Carlo Simulation using Latin-Hypercube sampling are
                              specified with the PDLHS command.

            USER - User specified sampling. Valid only for Method = MCS. In this case you provide
                   a file containing the sampling "points" (values) of all
                   random input variables for all simulation loops. These
                   samples are simply executed and it is your responsibility to
                   specify the samples correctly. The probabilistic design
                   system can perform only limited checks on the samples you
                   provide. ANSYS allows Monte Carlo specific postprocessing
                   operations on the results generated with user-specified
                   samples. The parameters for the user-supplied sampling
                   technique are specified with the PDUSER command.

            CCD - Central Composite Design. Valid only for Method = RSM. A central composite
                  design is composed of a center point, axis points, and corner
                  points, called factorial points. Using large numbers of
                  random input variables produces prohibitively large numbers
                  of factorial points; therefore, ANSYS automatically reduces
                  the number of factorial points by switching to a fractional
                  plan for the factorial part of the design. See the PDDOEL
                  command for more information.

            Note:This option is only valid for 2 to 20 random input variables. You will receive an error if you have specified fewer than 2 or more than 20 random input variables. - BBM

            Box-Behnken Matrix Design. Valid only for Method = RSM. A Box-Behnken Matrix design is composed of a center point plus the points at the middle of the edges of the hypercube in the space of random input variables. A Box-Behnken design might be advantageous if the corner points of the hypercube represent very extreme conditions that are undesirable and therefore should not be used for the sampling.  See the PDDOEL command for more information. - Note:  This option is only valid for 3 to 12 random input variables. You will
                              receive an error if you have specified fewer than
                              3 or more than 12 random input variables.

            USER - User specified sampling. In this case you provide a file containing the
                   sampling "points" (values) of all random input variables for
                   all simulation loops. These samples are simply executed and
                   it is your responsibility to specify the samples correctly.
                   The PDS can perform only limited checks on the samples you
                   provide, if user-supplied sampling technique are specified
                   with the PDUSER command.

        Notes
        -----
        Specifies the probabilistic analysis method and the sampling technique
        used for the individual probabilistic analysis method.
        """
        command = "PDMETH,%s,%s" % (str(method), str(samp))
        return self.run(command, **kwargs)

    def bfvlist(self, volu="", lab="", **kwargs):
        """APDL Command: BFVLIST

        Lists the body force loads on a volume.

        Parameters
        ----------
        volu
            Volume at which body load is to be listed.  If ALL (or blank), list
            for all selected volumes [VSEL].  If VOLU = P, graphical picking is
            enabled and all remaining command fields are ignored (valid only in
            the GUI).  A component name may also be substituted for VOLU.

        lab
            Valid body load label. If ALL, use all appropriate labels. Load
            labels are listed under "Body Loads" in the input table for each
            element type in the Element Reference. See the BFV command for
            labels.

        Notes
        -----
        Lists the body force loads for the specified volume and label.  Body
        loads may be defined on a volume with the BFV command.

        This command is valid in any processor.
        """
        command = "BFVLIST,%s,%s" % (str(volu), str(lab))
        return self.run(command, **kwargs)

    def lsfactor(self, enginename="", option="", **kwargs):
        """APDL Command: *LSFACTOR

        Performs the numerical factorization of a linear solver system.

        Parameters
        ----------
        enginename
            Name used to identify this engine. Must have been previously
            created using *LSENGINE.

        option
            Option to invert the matrix, used only with an LAPACK engine
            (*LSENGINE,LAPACK):

        Notes
        -----
        Performs the computationally intensive, memory intensive factorization
        of a matrix specified by *LSENGINE, using the solver engine also
        specified by *LSENGINE.
        """
        command = "*LSFACTOR,%s,%s" % (str(enginename), str(option))
        return self.run(command, **kwargs)

    def linl(self, nl1="", nl2="", nl3="", nl4="", nl5="", nl6="", nl7="",
             nl8="", nl9="", **kwargs):
        """APDL Command: LINL

        Finds the common intersection of lines.

        Parameters
        ----------
        nl1, nl2, nl3, . . . , nl9
            Numbers of lines to be intersected.  If NL1 = ALL, find the
            intersection of all selected lines and NL2 to NL9 are ignored.  If
            NL1 = P, graphical picking is enabled and all remaining command
            fields are ignored (valid only in the GUI).  A component name may
            also be substituted for NL1.

        Notes
        -----
        Finds the common (not pairwise) intersection of lines.  The common
        intersection is defined as the regions shared (in common) by all lines
        listed on this command.  New lines will be generated where the original
        lines intersect.  If the regions of intersection are only points, new
        keypoints will be generated instead.  See the Modeling and Meshing
        Guide for an illustration.  See the BOPTN command for the options
        available to Boolean operations.  Element attributes and solid model
        boundary conditions assigned to the original entities will not be
        transferred to the new entities generated.
        """
        command = "LINL,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(nl1), str(nl2), str(nl3), str(nl4), str(nl5), str(nl6), str(nl7), str(nl8), str(nl9))
        return self.run(command, **kwargs)

    def vdot(self, labr="", labx1="", laby1="", labz1="", labx2="", laby2="",
             labz2="", **kwargs):
        """APDL Command: VDOT

        Forms an element table item from the dot product of two vectors.

        Parameters
        ----------
        labr
            Label assigned to dot product result.

        labx1, laby1, labz1
            X, Y, and Z-component of first vector label.

        labx2, laby2, labz2
            X, Y, and Z-component of second vector label.

        Notes
        -----
        Forms labeled result items for the selected element from the dot
        product of two vectors:

        LabR = {LabX1, LabY1, LabZ1} : :  {LabX2, LabY2, LabZ2}

        Data must be in a consistent coordinate system.  Labels are those
        associated with the ETABLE command.
        """
        command = "VDOT,%s,%s,%s,%s,%s,%s,%s" % (str(labr), str(labx1), str(laby1), str(labz1), str(labx2), str(laby2), str(labz2))
        return self.run(command, **kwargs)

    def vfsm(self, action="", encl="", opt="", maxiter="", conv="", **kwargs):
        """APDL Command: VFSM

        Adjusts view factor matrix to satisfy reciprocity and/or row sum
        properties.

        Parameters
        ----------
        action
            Action to be performed:

            Define - Define a view factor summation (default)

            Clear - Resets the scaling method to 0 for all enclosures. All subsequent arguments are
                    ignored.

            Status - Outputs the OPT value for each enclosure in the model.

        encl
            Previously defined enclosure number for the view factor adjustment.

        opt
            Option key:

            0 - The view factor matrix values are not adjusted (default).

            1 - The view factor matrix values are adjusted so that the row sum equals 1.0.

            2 - The view factor matrix values are adjusted so that the row sum equals 1.0 and
                the reciprocity relationship is satisfied.

            3 - The view factor matrix values are adjusted so that the original row sum is
                maintained.

            4 - The view factor matrix values are adjusted so that the original row sum is
                maintained and the reciprocity relationship is satisfied.

        maxiter
            Maximum number of iterations to achieve convergence. Valid only
            when OPT = 2 or 4. Default is 100.

        conv
            Convergence value for row sum. Iterations will continue (up to
            MAXITER) until the maximum residual over all the rows is less than
            this value. Valid only when OPT = 2 or 4. Default is 1E-3.

        Notes
        -----
        To have a good energy balance, it is important to satisfy both the row
        sum and reciprocity relationships. For more information, see View
        Factors in the Mechanical APDL Theory Reference.

        OPT = 1 and 2 are suitable for perfect enclosures. OPT = 1 is less
        expensive than OPT = 2 because no iterations are involved. However,
        with OPT = 1, the reciprocity relationship is not satisfied.

        OPT = 3 and 4 are suitable for leaky enclosures. OPT = 3 is less
        expensive than OPT = 4 because no iterations are involved. However,
        with OPT = 3, the reciprocity relationship is not satisfied.

        The VFSM command must be used before VFOPT is issued, or Solve is
        initiated.
        """
        command = "VFSM,%s,%s,%s,%s,%s" % (str(action), str(encl), str(opt), str(maxiter), str(conv))
        return self.run(command, **kwargs)

    def cvar(self, ir="", ia="", ib="", itype="", datum="", name="", **kwargs):
        """APDL Command: CVAR

        Computes covariance between two quantities.

        Parameters
        ----------
        ir
            Arbitrary reference number assigned to the resulting variable (2 to
            NV [NUMVAR]).  If this number is the same as for a previous
            variable, the previous variable will be overwritten with this
            result.

        ia, ib
            Reference numbers of the two variables to be operated on.  If only
            one, leave IB blank.

        itype
            Defines the type of response PSD to be calculated:

            0,1 - Displacement (default).

            2 - Velocity.

            3 - Acceleration.

        datum
            Defines the reference with respect to which covariance is to be
            calculated:

            1 - Absolute value.

            2 - Relative to base (default).

        name
            Thirty-two character name for identifying the variable on listings
            and displays.  Embedded blanks are compressed upon output.

        Notes
        -----
        This command computes the covariance value for the variables referenced
        by the reference numbers IA and IB.  If DATUM = 2, the variable
        referenced by IR will contain the individual modal contributions (i.e.,
        the dynamic or relative values).  If DATUM = 1, the variable referenced
        by IR will contain the modal contributions followed by the
        contributions of pseudo-static and covariance between dynamic and
        pseudo-static responses. File.PSD must be available for the
        calculations to occur.
        """
        command = "CVAR,%s,%s,%s,%s,%s,%s" % (str(ir), str(ia), str(ib), str(itype), str(datum), str(name))
        return self.run(command, **kwargs)

    def r(self, nset="", r1="", r2="", r3="", r4="", r5="", r6="", **kwargs):
        """APDL Command: R

        Defines the element real constants.

        Parameters
        ----------
        nset
            Real constant set identification number (arbitrary).  If same as a
            previous set number, set is redefined. Set number relates to that
            defined with the element [REAL]. Note that the GUI automatically
            assigns this value.

        r1, r2, r3, . . . , r6
            Real constant values (interpreted as area, moment of inertia,
            thickness, etc., as required for the particular element type using
            this set), or table names for tabular input of boundary conditions.
            Use RMORE command if more than six real constants per set are to be
            input.

        Notes
        -----
        Defines the element real constants.  The real constants required for an
        element are shown in the Input Summary of each element description in
        the Element Reference.  Constants must be input in the same order as
        shown in that table.  If more than the required number of element real
        constants are specified in a set, only those required are used.  If
        fewer than the required number are specified, zero values are assumed
        for the unspecified constants.

        If using table inputs (SURF151, SURF152, FLUID116, CONTA171, CONTA172,
        CONTA173, CONTA174, and CONTA175 only), enclose the table name in %
        signs (e.g., %tabname%).

        Specify NSET = GCN to define real constants for real constant sets that
        were previously assigned by the GCDEF command (that is, real constants
        used in general contact interactions).

        When copying real constants to new sets, ANSYS, Inc. recommends that
        you use the command input. If you do use the GUI, restrict the real
        constant copy to only the first six real constants (real constants
        seven and greater will be incorrect for both the master and copy set).

        This command is also valid in SOLUTION.
        """
        command = "R,%s,%s,%s,%s,%s,%s,%s" % (str(nset), str(r1), str(r2), str(r3), str(r4), str(r5), str(r6))
        return self.run(command, **kwargs)

    def ancyc(self, numframes="", kcycl="", delay="", **kwargs):
        """APDL Command: ANCYC

        Applies a traveling wave animation to graphics data in a modal cyclic
        symmetry analysis.

        Parameters
        ----------
        numframes
            The number of plot frames for the animation. Valid values range
            from 5 through 36. The default is 18. A low value (because it
            specifies fewer graphical frames) produces a rougher animation but
            loads faster. A high value produces a smoother animation but
            requires more time to load.

        kcycl
            The animation mode:

            0 - Continuous animation cycle (forward-reverse-forward).

            1 - Discontinuous animation cycle (forward-reset-forward). This option is the
                default.

        delay
            The time delay (in seconds) between animation frames. Valid values
            range from 0.1 through 1.0. The default is 0.1 seconds, which
            produces a seemingly real-time animation. A higher value produces a
            slower animation.

        Notes
        -----
        The ANCYC command is valid in a modal cyclic symmetry analysis only.

        The command animates the cyclic symmetry mode shape plot in the General
        Post Processor (/POST1). When you issue a nodal- or element-results
        plot command (for example, PLNSOL, PLESOL, or PLDISP) and then issue
        the ANCYC command, ANSYS applies a traveling wave animation to the mode
        shape plot.

        Each frame of the animation is created by expanding the cyclic symmetry
        mode shape at increasing phase angles (via the /CYCEXPAND command)
        starting at zero in equal increments over 360°. The phase-angle
        increment is 360 / NUMFRAMES.

        The animation display shows the traveling wave of the result quantity
        being plotted. The traveling wave animation is applicable only to nodal
        diameters (harmonic indices) greater than 0 and less than N / 2 (where
        N is the number of cyclic sectors in the model).

        For more information, see Applying a Traveling Wave Animation to the
        Cyclic Model in the Cyclic Symmetry Analysis Guide.
        """
        command = "ANCYC,%s,%s,%s" % (str(numframes), str(kcycl), str(delay))
        return self.run(command, **kwargs)

    def ocdata(self, val1="", val2="", val3="", val14="", **kwargs):
        """APDL Command: OCDATA

        Defines an ocean load using non-table data.

        Parameters
        ----------
        val1, val2, val3, . . . , val14
            Values describing the basic ocean load or a wave condition.

        Notes
        -----
        The OCDATA command specifies non-table data that defines the ocean
        load, such as the depth of the ocean to the mud line, the ratio of
        added mass over added mass for a circular cross section, or the wave
        type to apply. The terms VAL1, VAL2, etc. are specialized according to
        the input set required for the given ocean load.

        The program interprets the data input via the OCDATA command within the
        context of the most recently issued OCTYPE command.

        Input values in the order indicated.

        This command is also valid in PREP7.

        You can define the following ocean data types:

        For a better understanding of how to set up a basic ocean type, see
        Figure: 5:: Basic Ocean Data Type Components .

        DEPTH -- The depth of the ocean (that is, the distance between the mean
        sea level and the mud line). The water surface is assumed to be level
        in the XY plane, with Z being positive upwards. This value is required
        and must be positive.

        MATOC -- The material number of the ocean. This value is required and
        is used to input the required density. It is also used to input the
        viscosity if the Reynolds number is used (OCTABLE).

        KFLOOD -- The inside-outside fluid-interaction key:

        For beam subtype CTUBE and HREC used with BEAM188 or BEAM189 and ocean
        loading, KFLOOD is always set to 1.

        Cay -- The ratio of added mass of the external fluid over the mass of
        the fluid displaced by the element cross section in the y direction
        (normal). The added mass represents the mass of the external fluid
        (ocean water) that moves with the pipe, beam, or link element when the
        element moves in the element y direction during a dynamic analysis.

        If no value is specified, and the coefficient of inertia CMy is not
        specified (OCTABLE), both values default to 0.0.

        If no value is specified, but CMy is specified, this value defaults to
        Cay = CMy - 1.0.

        If this value should be 0.0, enter 0.0.

        Caz -- The ratio of added mass of the external fluid over the mass of a
        cross section in the element z direction (normal). The added mass
        represents the mass of the external fluid (ocean water) that moves with
        the pipe, beam, or link element when the element moves in the element z
        direction during a dynamic analysis.

        If no value is specified, and Cay is specified, this value defaults to
        Cay.

        If no value is specified, and the coefficient of inertia CMz is not
        specified (OCTABLE), both values default to 0.0.

        If no value is specified, but CMz is specified, this value defaults to
        Cay = CMz - 1.0.

        If this value should be 0.0, enter 0.0.

        Cb -- The ratio of buoyancy force used over buoyancy force based on the
        outside diameter and water density. Accept the default value in most
        cases. Adjust this option only when you must account for additional
        hardware (such as a control valve) attached to the pipe exterior. A
        non-default value may lead to small non-physical inconsistencies;
        testing is therefore recommended for non-default values.

        If no value is specified, this value defaults to 1.0.

        If this value should be 0.0 (useful when troubleshooting your input),
        enter 0.0.

        Zmsl -- A vertical offset from the global origin to the mean sea level.
        The default value is zero (meaning that the origin is located at the
        mean sea level).

        Two example cases for Zmsl are:

        A structure with its origin on the sea floor (Zmsl = DEPTH).

        A tidal change (tc) above the mean sea level (Zmsl = tc, and DEPTH
        becomes DEPTH + tc)

        Ktable -- The dependency of VAL1 on the OCTABLE command:

        Figure: 5:: : Basic Ocean Data Type Components

         KWAVE -- The incident wave type:

        THETA -- Angle of the wave direction θ from the global Cartesian X axis
        toward the global Cartesian Y axis (in degrees).

        WAVELOC (valid when KWAVE = 0 through 3, and 101+) -- The wave location
        type:

        SPECTRUM (valid when KWAVE = 5 through 7) -- The wave spectrum type:

        KCRC -- The wave-current interaction key.

        Adjustments to the current profile are available via the KCRC constant
        of the water motion table. Typically, these options are used only when
        the wave amplitude is large relative to the water depth, such that
        significant wave-current interaction exists.
        """
        command = "OCDATA,%s,%s,%s,%s" % (str(val1), str(val2), str(val3), str(val14))
        return self.run(command, **kwargs)

    def plcamp(self, option="", slope="", unit="", freqb="", cname="",
               stabval="", keyallfreq="", keynegfreq="", **kwargs):
        """APDL Command: PLCAMP

        Plots Campbell diagram data for applications involving rotating
        structure dynamics.

        Parameters
        ----------
        option
            Flag to activate or deactivate sorting of forward or backward whirl
            frequencies:

            0 (OFF or NO) - No sorting.

            1 (ON or YES) - Sort. This value is the default.

        slope
            The slope of the line to be printed. This value must be positive.

            SLOPE > 0  - The line represents the number of excitations per revolution of the rotor. For
                         example, SLOPE = 1 represents one excitation per
                         revolution, usually resulting from unbalance.

            SLOPE = 0  - The line represents the stability threshold for stability values or logarithmic
                         decrements printout (STABVAL = 1 or 2)

        unit
            Specifies the unit of measurement for rotational angular
            velocities:

            RDS - Rotational angular velocities in radians per second (rad/s). This value is the
                  default.

            RPM - Rotational angular velocities in revolutions per minute (RPMs).

        freqb
            The beginning, or lower end, of the frequency range of interest.
            The default is zero.

        cname
            The rotating component name.

        stabval
            Flag to plot the stability values:

            0 (OFF or NO) - Plot the frequencies (the imaginary parts of the eigenvalues in Hz). This value
                            is the default.

            1 (ON or YES) - Plot the stability values (the real parts of the eigenvalues in Hz).

            2 - Plot the logarithmic decrements.

        keyallfreq
            Key to specify if all frequencies above FREQB are plotted:

            0 (OFF or NO) - A maximum of 10 frequencies are plotted. This value is the default.

            1 (ON or YES) - All frequencies are plotted.

        keynegfreq
            Key to specify if the negative frequencies are plotted. It only
            applies to solutions obtained with the damped eigensolver (Method =
            DAMP on the MODOPT command):

            0 (OFF or NO) - Only positive frequencies are plotted. This value is the default.

            1 (ON or YES) - Negative and positive frequencies are plotted.

        Notes
        -----
        The following items are required when generating a Campbell diagram:

        Take the gyroscopic effect into account by issuing the CORIOLIS command
        in the SOLUTION module.

        Run a modal analysis using the QR damped (MODOPT,QRDAMP) or damped
        (MODOPT,DAMP) method. Complex eigenmodes are necessary
        (MODOPT,QRDAMP,,,,Cpxmod  = ON), and you must specify the number of
        modes to expand (MXPAND).

        Define two or more load step results with an ascending order of
        rotational velocity (OMEGA or CMOMEGA).

        In some cases where modes are not in the same order from one load step
        to the other, sorting the frequencies (Option = 1) can help to obtain a
        correct plot. Sorting is based on the comparison between complex mode
        shapes calculated at two successive load steps.

        At each load step, the application compares the mode shape to the loads
        at other load steps to determine whirl direction at the load step. If
        applicable, a label appears (in the plot legend) representing each
        whirl mode (BW for backward whirl and FW for forward whirl).

        At each load step, the program checks for instability (based on the
        sign of the real part of the eigenvalue). The labels “stable” or
        “unstable” appear in the plot legend for each frequency curve.

        The rotational velocities of a named component (Cname) are displayed on
        the X-axis.

        For information on plotting a Campbell diagram for a prestressed
        structure, see Solving for a Subsequent Campbell Analysis of a
        Prestressed Structure Using the Linear Perturbation Procedure in the
        Rotordynamic Analysis Guide.

        In general, plotting a Campbell diagram is recommended only when your
        analysis is performed in a stationary reference frame
        (CORIOLIS,,,,RefFrame = ON).

        For a usage example of the PLCAMP command, see Campbell Diagram in the
        Rotordynamic Analysis Guide.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "PLCAMP,%s,%s,%s,%s,%s,%s,%s,%s" % (str(option), str(slope), str(unit), str(freqb), str(cname), str(stabval), str(keyallfreq), str(keynegfreq))
        return self.run(command, **kwargs)

    def eslv(self, type="", **kwargs):
        """APDL Command: ESLV

        Selects elements associated with the selected volumes.

        Parameters
        ----------
        type
            Label identifying the type of element selected:

            S - Select a new set (default).

            R - Reselect a set from the current set.

            A - Additionally select a set and extend the current set.

            U - Unselect a set from the current set.

        Notes
        -----
        Selects volume elements belonging to meshed [VMESH], selected [VSEL]
        volumes.

        This command is valid in any processor.
        """
        command = "ESLV,%s" % (str(type))
        return self.run(command, **kwargs)

    def edweld(self, option="", nweld="", n1="", n2="", sn="", ss="", expn="",
               exps="", epsf="", tfail="", nsw="", cid="", **kwargs):
        """APDL Command: EDWELD

        Defines a massless spotweld or generalized weld for use in an explicit
        dynamic analysis.

        Parameters
        ----------
        option
            Label identifying the option to be performed:

            ADD - Define a weld (default). This weld may be a spotweld between two nodes or a
                  generalized weld. A massless spotweld will be defined if
                  valid node numbers are specified in fields N1 and N2. A
                  generalized weld will be defined if a node component is
                  specified in field N1.

            DELE - Delete specified weld. If NWELD is blank, all welds are deleted.

            LIST - List specified weld. If NWELD is blank, all welds are listed.

        nweld
            Reference number identifying the spotweld or generalized weld.

        n1, n2
            For a spotweld, N1 and N2 are the nodes which are connected by the
            spotweld. For a generalized weld, input a nodal component name in
            N1 and leave N2 blank. The nodal component should contain all nodes
            that are to be included in the generalized weld.

        sn
            Normal force at spotweld failure.

        ss
            Shear force at spotweld failure.

        expn
            Exponent for normal spotweld force.

        exps
            Exponent for shear spotweld force.

        epsf
            Effective plastic strain at ductile failure (used only for a
            generalized weld).

        tfail
            Failure time for constraint set (used only for a generalized weld);
            default = 1.0e20.

        nsw
            Number of spot welds for the generalized weld.

        cid
            Coordinate system ID number (CID) to be used for output data (used
            only for a generalized weld). The coordinate system must be
            previously defined with the EDLCS command.

        Notes
        -----
        This command can be used to define a massless spotweld between two
        nodes or a generalized weld for a group of nodes.  For a spotweld, the
        nodes specified by N1 and N2 must not be coincident. For a generalized
        weld, coincident nodes are permitted, but CID must be specified when
        using coincident nodes. EDWELD is not updated after a node merge
        operation; therefore, node merging [NUMMRG,NODE] should be done before
        any EDWELD definitions. Nodes connected by a spotweld or generalized
        weld cannot be constrained in any other way.

        Failure of the weld occurs when:

        where fn and fs are normal and shear interface forces. Normal interface
        force fn is nonzero for tensile values only.

        You can graphically display spotwelds by issuing the command
        /PBC,WELD,,1.

        This command is also valid in SOLUTION.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDWELD,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(option), str(nweld), str(n1), str(n2), str(sn), str(ss), str(expn), str(exps), str(epsf), str(tfail), str(nsw), str(cid))
        return self.run(command, **kwargs)

    def sumap(self, rsetname="", item="", comp="", **kwargs):
        """APDL Command: SUMAP

        Map results onto selected surface(s).

        Parameters
        ----------
        rsetname
            Eight-character name for the result being mapped.

        item
            Label identifying the item.

        comp
            Component label of item (if required).

        Notes
        -----
        The SUMAP command maps results in the current coordinate system (RSYS)
        using the selected set of elements.

        The command interpolates and stores the results data on to each of the
        selected surfaces.

        SUMAP,ALL,CLEAR deletes all results sets from all selected surfaces.
        """
        command = "SUMAP,%s,%s,%s" % (str(rsetname), str(item), str(comp))
        return self.run(command, **kwargs)

    def edcts(self, dtms="", tssfac="", **kwargs):
        """APDL Command: EDCTS

        Specifies mass scaling and scale factor of computed time step for an
        explicit dynamics analysis.

        Parameters
        ----------
        dtms
            Time step size for mass scaled solutions (defaults to 0).

        tssfac
            Scale factor for computed time step. Defaults to 0.9; if high
            explosives are used, the default is lowered to 0.67.

        Notes
        -----
        If DTMS is positive, the same time step size will be used for all
        elements and mass scaling will be done for all elements.  Therefore,
        positive values should only be used if inertial effects are
        insignificant.

        If DTMS is negative, mass scaling is applied only to elements whose
        calculated time step size is smaller than DTMS.  Negative values should
        only be used in transient analyses if the mass increases are
        insignificant.

        In order to use mass scaling in an explicit dynamic small restart
        analysis (EDSTART,2) or full restart analysis (EDSTART,3), mass scaling
        must have been active in the original analysis. The time step and scale
        factor used in the original analysis will be used by default in the
        restart. You can issue EDCTS in the restart analysis to change these
        settings.

        This command is also valid in PREP7.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDCTS,%s,%s" % (str(dtms), str(tssfac))
        return self.run(command, **kwargs)

    def nsmooth(self, np_ass="", **kwargs):
        """APDL Command: NSMOOTH

        Smooths selected nodes among selected elements.

        Parameters
        ----------
        npass
            Number of smoothing passes. Defaults to 3.

        Notes
        -----
        Repositions each selected node at the average position of its immediate
        neighbors on the selected elements. The node positions converge after
        some number of smoothing passes. For some initial conditions, NPASS may
        need to be much larger than 3. If the boundary of a mesh is to be
        undisturbed (usually desirable), the boundary nodes should be
        unselected before issuing NSMOOTH.
        """
        command = "NSMOOTH,%s" % (str(np_ass))
        return self.run(command, **kwargs)

    def linv(self, nl="", nv="", **kwargs):
        """APDL Command: LINV

        Finds the intersection of a line with a volume.

        Parameters
        ----------
        nl
            Number of line to be intersected.  If NL = P, graphical picking is
            enabled and all remaining command fields are ignored (valid only in
            the GUI).

        nv
            Number of volume to be intersected.

        Notes
        -----
        Finds the intersection of a line with a volume.  New lines will be
        generated where the lines intersect the volumes.  If the regions of
        intersection are only points, new keypoints will be generated instead.
        See the Modeling and Meshing Guide for an illustration.  See the BOPTN
        command for the options available to Boolean operations.  Element
        attributes and solid model boundary conditions assigned to the original
        entities will not be transferred to the new entities generated.
        """
        command = "LINV,%s,%s" % (str(nl), str(nv))
        return self.run(command, **kwargs)

    def axpy(self, vr="", vi="", m1="", wr="", wi="", m2="", **kwargs):
        """APDL Command: *AXPY

        Performs the matrix operation M2= v*M1 + w*M2.

        Parameters
        ----------
        vr, vi
            The real and imaginary parts of the scalar v. Default value is 0.

        m1
            Name of matrix M1. If not specified, the operation M2 = w*M2 will
            be performed.

        wr, wi
            The real and imaginary parts of the scalar w. Default value is 0.

        m2
            Name of matrix M2. Must be specified.

        Notes
        -----
        The matrices M1 and M2 must have the same dimensions and same type
        (dense or sparse). If M2 is real, vi and wi are ignored.
        """
        command = "*AXPY,%s,%s,%s,%s,%s,%s" % (str(vr), str(vi), str(m1), str(wr), str(wi), str(m2))
        return self.run(command, **kwargs)

    def deriv(self, ir="", iy="", ix="", name="", facta="", **kwargs):
        """APDL Command: DERIV

        Differentiates a variable.

        Parameters
        ----------
        ir
            Arbitrary reference number assigned to the resulting variable (2 to
            NV [NUMVAR]).  If this number is the same as for a previously
            defined variable, the previously defined variable will be
            overwritten with this result.

        iy, ix
            Reference numbers of variables to be operated on.  IY is
            differentiated with respect to IX.

        --
            Unused field.

        name
            Thirty-two character name for identifying the variable on printouts
            and displays. Embedded blanks are compressed for output.

        --, --
            Unused fields.

        facta
            Scaling factor (positive or negative) applied as shown below
            (defaults to 1.0).

        Notes
        -----
        Differentiates variables according to the operation:

        IR = FACTA x d(IY)/d(IX)
        """
        command = "DERIV,%s,%s,%s,%s,%s" % (str(ir), str(iy), str(ix), str(name), str(facta))
        return self.run(command, **kwargs)

    def edndtsd(self, vect1="", vect2="", datap="", fitpt="", vect3="",
                vect4="", disp="", **kwargs):
        """APDL Command: EDNDTSD

        Allows smoothing of noisy data for explicit dynamics analyses and
        provides a graphical representation of the data.

        Parameters
        ----------
        vect1
            Name of the first vector that contains the noisy data set (i.e.,
            independent variable). You must create and fill this vector before
            issuing EDNDTSD.

        vect2
            Name of the second vector that contains the dependent set of data.
            Must be the same length as the first vector. You must create and
            fill this vector before issuing EDNDTSD.

        datap
            Number of data points to be fitted, starting from the beginning of
            the vector. If left blank, the entire vector will be fitted. The
            maximum number of data points is 100,000 (or greater, depending on
            the memory of the computer).

        fitpt
            Curve fitting order to be used as a smooth representation of the
            data. This number should be less than or equal to the number of
            data points. However, because high order polynomial curve fitting
            can cause numerical difficulties, a polynomial order less than 7 is
            suggested. The default (blank) is one-half the number of data
            points or 7, which ever is less. The following values are
            available:

            1 - Curve is the absolute average of all of the data points.

            2 - Curve is the least square average of all of the data points.

            3 or more - Curve is a polynomial of the order (n-1), where n is the number of data fitting
                        order points.

        vect3
            Name of the vector that contains the smoothed data of the
            independent variable. This vector should have a length equal to or
            greater than the number of smoothed data points. In batch (command)
            mode, you must create this vector before issuing the EDNDTSD
            command. In interactive mode, the GUI automatically creates this
            vector (if it does not exist). If you do not specify a vector name,
            the GUI will name the vector smth_ind.

        vect4
            Name of the vector that contains the smoothed data of the dependent
            variable.  This vector must be the same length as Vect3.  In batch
            (command) mode, you must create this vector before issuing the
            EDNDTSD command. In interactive mode, the GUI automatically creates
            this vector (if it does not exist). If you do not specify a vector
            name, the GUI will name the vector smth_dep.

        disp
            Specifies how you want to display data. No default; you must
            specify an option.

            1 - Unsmoothed data only

            2 - Smoothed data only

            3 - Both smoothed and unsmoothed data

        Notes
        -----
        You can control the attributes of the graph using standard ANSYS
        controls (/GRID, /GTHK, /COLOR, etc.). If working interactively, these
        controls appear in this dialog box for convenience, as well as in their
        standard dialog boxes. You must always create Vect1 and Vect2 (using
        *DIM) and fill these vectors before smoothing the data. If you're
        working interactively, ANSYS automatically creates Vect3 and Vect4, but
        if you're working in batch (command) mode, you must create Vect3 and
        Vect4 (using *DIM) before issuing EDNDTSD.  Vect3 and Vect4 are then
        filled automatically by ANSYS.  In addition, ANSYS creates an
        additional TABLE type array that contains the smoothed array and the
        unsmoothed data to allow for plotting later with *VPLOT.  Column 1 in
        this table corresponds to Vect1, column 2 to Vect2, and column 3 to
        Vect4.  This array is named Vect3_SMOOTH, up to a limit of 32
        characters. For example, if the array name is X1, the table name is
        X1_SMOOTH.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDNDTSD,%s,%s,%s,%s,%s,%s,%s" % (str(vect1), str(vect2), str(datap), str(fitpt), str(vect3), str(vect4), str(disp))
        return self.run(command, **kwargs)

    def sffun(self, lab="", par="", par2="", **kwargs):
        """APDL Command: SFFUN

        Specifies a varying surface load.

        Parameters
        ----------
        lab
            Valid surface load label.  Load labels are listed under "Surface
            Loads" in the input table for each element type in the Element
            Reference.  Issue SFFUN,STATUS to list current command settings.

        par
            Parameter containing list of surface load values.  If Lab = CONV,
            values are typically the film coefficients and Par2 values (below)
            are typically the bulk temperatures.

        par2
            Parameter containing list of second surface load values (if any).
            If Lab = CONV, the Par2 values are typically the bulk temperatures.
            Par2 is not used for other surface load labels.

        Notes
        -----
        Specifies a surface load "function" to be used when the SF or SFE
        command is issued.  The function is supplied through an array parameter
        vector which contains nodal surface load values.  Node numbers are
        implied from the sequential location in the array parameter.  For
        example, a value in location 11 applies to node 11.  The element faces
        are determined from the implied list of nodes when the SF or SFE
        command is issued.  Zero values should be supplied for nodes that have
        no load.  A tapered load value may be applied over the element face.
        These loads are in addition to any loads that are also specified with
        the SF or SFE commands.  Issue SFFUN (with blank remaining fields) to
        remove this specification.  Issue SFFUN,STATUS to list current
        settings.

        Starting array element numbers must be defined for each array parameter
        vector.  For example, SFFUN,CONV,A(1,1),A(1,2) reads the first and
        second columns of array A (starting with the first array element of
        each column) and associates the values with the nodes.  Operations
        continue on successive column array elements until the end of the
        column. Another example to show the order of the commands:

        SFFUN does not work for tabular boundary conditions.

        This command is also valid in PREP7.
        """
        command = "SFFUN,%s,%s,%s" % (str(lab), str(par), str(par2))
        return self.run(command, **kwargs)

    def bfecum(self, lab="", oper="", fact="", tb_ase="", **kwargs):
        """APDL Command: BFECUM

        Specifies whether to ignore subsequent element body force loads.

        Parameters
        ----------
        lab
            Valid body load label.  If ALL, use all appropriate labels.

        oper
            Replace or ignore key:

            REPL - Subsequent values replace the previous values (default).

            IGNO - Subsequent values are ignored.

        fact
            Scale factor for the element body load values.  Zero (or blank)
            defaults to 1.0.  Use a small number for a zero scale factor.  The
            scale factor is not applied to body load phase angles.

        tbase
            Used (only with  Lab = TEMP) to calculate the temperature used in
            the add or replace operation (see Oper) as:

        Notes
        -----
        Allows repeated element body force loads to be replaced or ignored.
        Element body loads are applied with the BFE command.  Issue the BFELIST
        command to list the element body loads.  The operations occur when the
        next body loads are defined.  For example, issuing the BFE command with
        a temperature value of 25 after a previous BFE command with a
        temperature value of 20 causes the new value of that temperature to be
        25 with the replace operation, or 20 with the ignore operation.  A
        scale factor is also available to multiply the next value before the
        replace operation.  A scale factor of 2.0 with the previous "replace"
        example results in a temperature of 50.  The scale factor is applied
        even if no previous values exist.  Issue BFECUM,STAT to show the
        current label, operation, and scale factors.

        BFECUM does not work for tabular boundary conditions.

        This command is also valid in PREP7.
        """
        command = "BFECUM,%s,%s,%s,%s" % (str(lab), str(oper), str(fact), str(tb_ase))
        return self.run(command, **kwargs)

    def config(self, lab="", value="", **kwargs):
        """APDL Command: /CONFIG

        Assigns values to ANSYS configuration parameters.

        Parameters
        ----------
        lab
            Configuration parameter to be changed:

            NORSTGM - Option to write or not write geometry data to the results file. VALUE is either
                      0 (write geometry data) or 1 (do not write geometry
                      data). Useful when complex analyses will create
                      abnormally large files. Default is 0.

            NBUF - VALUE is the number of buffers (1 to 32) per file in the solver.  Defaults to
                   4.

            LOCFL - File open and close actions.  For VALUE use: 0 for global (default); 1 for
                    local.  Applicable to File.EROT, File.ESAV, and File.EMAT.
                    Typically  used for large problems where locally closed
                    files may be deleted  earlier in the run with the /FDELE
                    command.

            SZBIO - VALUE is the record size (1024 to 4194304) of binary files (in integer words).
                    Defaults to 16384 (system dependent).

            ORDER - Automatic reordering scheme.  For VALUE use: 0 for WSORT,ALL; 1 for WAVES; 2
                    for both WSORT,ALL and WAVES (default).

            FSPLIT - Defines split points for binary files.  VALUE is the file split point in
                     megawords and defaults to the maximum file size for the
                     system.

            MXND - Maximum number of nodes. If not specified, defaults to 100 at first encounter.
                   Dynamically expanded by doubling, even at first encounter,
                   when maximum is exceeded.

            MXEL - Maximum number of elements.  Default and expansion as for MXND.

            MXKP - Maximum number of keypoints.  Default and expansion as for MXND.

            MXLS - Maximum number of lines.  Default and expansion as for MXND.

            MXAR - Maximum number of areas.  Default and expansion as for MXND.

            MXVL - Maximum number of volumes.  Default and expansion as for MXND.

            MXRL - Maximum number of sets of real constants (element attributes).  Default and
                   expansion as for MXND.

            MXCP - Maximum number of sets of coupled degrees of freedom.  Default and expansion as
                   for MXND.

            MXCE - Maximum number of constraint equations.  Default and expansion as for MXND.

            NOELDB - Option to write or not write results into the database after a solution.  When
                     VALUE = 0 (default), write results into the database.
                     When VALUE = 1, do not write results into the database.

            DYNA_DBL - Option to invoke the double precision version of the explicit dynamics solver
                       LS-DYNA. When VALUE = 0 (default), the single precision
                       version is used. When VALUE = 1, the double precision
                       version is used.

            STAT - Displays current values set by the /CONFIG command.

        value
            Value (an integer number) assigned to the configuration parameter.

        Notes
        -----
        All configuration parameters have initial defaults, which in most cases
        do not need to be changed.  Where a specially configured version of the
        ANSYS program is desired, the parameters may be changed with this
        command.  Issue /CONFIG,STAT to display current values.  Changes must
        be defined before the parameter is required.  These changes (and
        others) may also be incorporated into the config162.ans file which is
        read upon execution of the program (see The Configuration File in the
        Basic Analysis Guide).  If the same configuration parameter appears in
        both the  configuration file and this command, this command overrides.

        Distributed ANSYS uses the default FSPLIT value, and forces NOELDB = 1
        and NORSTGM = 0 for all results files. The FSPLIT, NOELDB, and NORSTGM
        options cannot be changed when using Distributed ANSYS.

        The /CONFIG command is not valid for the ANSYS Multiphysics 1, 2, or 3
        products.

        The ANSYS Multi-field solver (MFS and MFX) does not support
        /CONFIG,NOELDB,1. The ANSYS Multi-field solver needs the updated ANSYS
        database.
        """
        command = "/CONFIG,%s,%s" % (str(lab), str(value))
        return self.run(command, **kwargs)

    def wtbcreate(self, iel="", node="", damp="", **kwargs):
        """APDL Command: WTBCREATE

        Creates a USER300 element to model the turbine for full aeroelastic
        coupling analysis and specifies relevant settings for the analysis.

        Parameters
        ----------
        iel
            Element number (next available number by default).

        node
            Node number connecting support structure and turbine.

        damp
            Damping option for the turbine:

            0 - Damping matrix obtained from the aeroelastic code plus Rayleigh damping
                (default).

            1 - Rayleigh damping only.

            2 - Damping from the aeroelastic code only.

        Notes
        -----
        WTBCREATE invokes a predefined ANSYS macro that will automatically
        generate a turbine element and issue relevant data commands that are
        necessary to run a full aeroelastic coupling analysis. For detailed
        information on how to perform a fully coupled aeroelastic analysis, see
        Fully Coupled Wind Turbine Example in Mechanical APDL in the Mechanical
        APDL Programmer's Reference.

        The generated USER300 turbine element will have 9 nodes with node
        numbers NODE, NMAX+1, NMAX+2, ..., NMAX+8, where NMAX is the maximum
        node number currently in the model.

        There are 6 freedoms on the first node of the element: UX, UY, UZ,
        ROTX, ROTY, ROTZ, and these are true structural freedoms. For all the
        other nodes (i.e., nodes 2 to 9), only the translational freedoms (UX,
        UY, UZ) are used. These are generalized freedoms that are internal to
        the turbine element and are used by the aeroelastic code only.

        The element type integer of the USER300 element is the current maximum
        element type integer plus one.

        The command will also set up the analysis settings appropriate for a
        full aeroelastic coupling analysis. These include full Newton-Raphson
        solution (NROPT,FULL) and a USRCAL command to activate the relevant
        user routines.
        """
        command = "WTBCREATE,%s,%s,%s" % (str(iel), str(node), str(damp))
        return self.run(command, **kwargs)

    def read(self, fname="", nskip="", format="", xfield="", yfield="",
             zfield="", prfield="", pifield="", **kwargs):
        """APDL Command: READ

        Reads coordinate and pressure data from a file.

        Parameters
        ----------
        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        nskip
            Number of lines at the beginning of the file that will be skipped
            while it is read. Default = 0. NSKIP is ignored for FileType =
            CFXTBR or CFDPOST on the FTYPE command.

        format
            For FileType = FORMATTED on the FTYPE command, Format is the read
            format in the FORTRAN FORMAT convention enclosed in parentheses;
            for example: (3e10.0,10x,e10.0,70x,e10.0)

        xfield, yfield, zfield, prfield, pifield
            For FileType = CSV on the FTYPE command, these are field numbers
            locating the coordinates and real and imaginary (if present)
            pressures. The field value may not exceed 20.

        Notes
        -----
        Reads coordinate and pressure data from the specified file. The file
        type must have been previously specified on the FTYPE command.

        Upon reading the file, nodes are created for the source points. For
        FileType = CFXTBR or CFDPOST on the FTYPE command, if face data is
        available, SURF154 elements are also created. A nodal component named
        SOURCENODES and an element component named SOURCEELEMS are created
        automatically.
        """
        command = "READ,%s,%s,%s,%s,%s,%s,%s,%s" % (str(fname), str(nskip), str(format), str(xfield), str(yfield), str(zfield), str(prfield), str(pifield))
        return self.run(command, **kwargs)

    def fatigue(self, **kwargs):
        """APDL Command: FATIGUE

        Specifies "Fatigue data status" as the subsequent status topic.

        Notes
        -----
        This is a status [STAT] topic command.  Status topic commands are
        generated by the GUI and will appear in the log file (Jobname.LOG) if
        status is requested for some items under Utility Menu> List> Status.
        This command will be immediately followed by a STAT command, which will
        report the status for the specified topic.

        If entered directly into the program, the STAT command should
        immediately follow this command.
        """
        command = "FATIGUE," % ()
        return self.run(command, **kwargs)

    def vlscale(self, nv1="", nv2="", ninc="", rx="", ry="", rz="", kinc="",
                noelem="", imove="", **kwargs):
        """APDL Command: VLSCALE

        Generates a scaled set of volumes from a pattern of volumes.

        Parameters
        ----------
        nv1, nv2, ninc
            Set of volumes (NV1 to NV2 in steps of NINC) that defines the
            pattern to be scaled.  NV2 defaults to NV1, NINC defaults to 1.  If
            NV1 = ALL, NV2 and NINC are ignored and the pattern is defined by
            all selected volumes.  If NV1 = P, graphical picking is enabled and
            all remaining command fields are ignored (valid only in the GUI).
            A component name may also be substituted for NV1 (NV2 and NINC are
            ignored).

        rx, ry, rz
            Scale factors to be applied to the X, Y, and Z keypoint coordinates
            in active coordinate system (RR, Rθ, RZ for cylindrical; RR, Rθ, RΦ
            for spherical).  Note that the Rθ and RΦ scale factors are
            interpreted as angular offsets.  For example, if CSYS = 1, RX, RY,
            RZ input of (1.5,10,3) would scale the specified keypoints 1.5
            times in the radial and 3 times in the Z direction, while adding an
            offset of 10 degrees to the keypoints.  Zero, blank, or negative
            scale factor values are assumed to be 1.0.  Zero or blank angular
            offsets have no effect.

        kinc
            Increment to be applied to keypoint numbers for generated set.  If
            zero, the lowest available keypoint numbers will be assigned
            [NUMSTR].

        noelem
            Specifies whether nodes and elements are also to be generated:

            0 - Nodes and elements associated with the original volumes will be generated
                (scaled) if they exist.

            1 - Nodes and elements will not be generated.

        imove
            Specifies whether volumes will be moved or newly defined:

            0 - Additional volumes will be generated.

            1 - Original volumes will be moved to new position (KINC and NOELEM are ignored).
                Use only if the old volumes are no longer needed at their
                original positions.  Corresponding meshed items are also moved
                if not needed at their original position.

        Notes
        -----
        Generates a scaled set of volumes (and their corresponding keypoints,
        lines, areas,  and mesh) from a pattern of volumes.  The MAT, TYPE,
        REAL, and ESYS attributes are based on the volumes in the pattern and
        not the current settings.  Scaling is done in the active coordinate
        system.  Volumes in the pattern could have been generated in any
        coordinate system.  However, solid modeling in a toroidal coordinate
        system is not recommended.
        """
        command = "VLSCALE,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(nv1), str(nv2), str(ninc), str(rx), str(ry), str(rz), str(kinc), str(noelem), str(imove))
        return self.run(command, **kwargs)

    def sspb(self, b11="", b21="", b31="", b22="", b32="", b33="", t="",
             b12="", b13="", b23="", **kwargs):
        """APDL Command: SSPB

        Specifies a preintegrated coupling stiffness for shell sections.

        Parameters
        ----------
        b11, b21, b31, b22, b32, b33
            Coupling stiffness component (symmetric lower part of submatrix
            [B]).

        t
            Temperature.

        b12, b13, b23
            Upper part of submatrix [B]

        Notes
        -----
        The behavior of shell elements is governed by the generalized-
        stress/generalized-strain relationship of the form:

        If the coefficients B12, B13, B23 are undefined, ANSYS uses a symmetric
        form of submatrix [B].  If any one of the coefficients B12, B13, B23 is
        nonzero, ANSYS considers submatrix [B] to be unsymmetric.

        The SSPB command, one of several preintegrated shell section commands,
        specifies the coupling stiffness quantity (submatrix [B] data) for a
        preintegrated shell section. The section data defined is associated
        with the section most recently defined (via the SECTYPE command).

        Unspecified values default to zero.

        Related commands are SSPA, SSPD, SSPE, SSMT, SSBT, and SSPM.

        If you are using the SHELL181 or SHELL281 element's Membrane option
        (KEYOPT(1) = 1), it is not necessary to issue this command.

        For complete information, see Using Preintegrated General Shell
        Sections.
        """
        command = "SSPB,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(b11), str(b21), str(b31), str(b22), str(b32), str(b33), str(t), str(b12), str(b13), str(b23))
        return self.run(command, **kwargs)

    def edwrite(self, option="", fname="", ext="", **kwargs):
        """APDL Command: EDWRITE

        Writes explicit dynamics input to an LS-DYNA input file.

        Parameters
        ----------
        option
            Sets a flag in the LS-DYNA input file (Fname.Ext) to produce
            desired output.

            ANSYS - Set a flag to write results files for the ANSYS postprocessors (default).  The
                    files that will be written are Jobname.RST and Jobname.HIS
                    (see Notes below).

            LSDYNA - Set a flag to write results files for the LS-DYNA postprocessor (LS-POST).  The
                     files that will be written are D3PLOT, and files specified
                     by EDOUT and EDHIST (see Notes below).

            BOTH - Set a flag to write results files for both ANSYS and LS-DYNA postprocessors.

        fname
            File name and directory path (80 characters maximum, including
            directory; this limit is due to an LS-DYNA program limitation). If
            you do not specify a directory path, it will default to your
            working directory. The file name defaults to Jobname. Previous data
            on this file, if any, are overwritten.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        Notes
        -----
        This command writes an LS-DYNA input file for the LS-DYNA solver.
        EDWRITE is only valid if explicit dynamic elements have been specified.
        This command is not necessary if the LS-DYNA solver is invoked from
        within ANSYS, in which case Jobname.K (or Jobname.R) is written
        automatically when the solution is initiated. (If LS-DYNA is invoked
        from within ANSYS, use EDOPT to specify desired output.)

        If the analysis is a small restart (EDSTART,2), the file that is
        written will have the name Jobname.R (by default) and will only contain
        changes from the original analysis.

        If the analysis is a full restart (EDSTART,3), the file that is written
        will have the name Jobname_nn.K (by default) and will contain all the
        information from the database. In a full restart, the jobname is
        changed to Jobname_nn (nn = 01 initially, and is incremented for each
        subsequent full restart.)

        A command is included in the LS-DYNA input file to instruct the LS-DYNA
        solver to write the results files indicated by Option.  By default, LS-
        DYNA will write the ANSYS results file Jobname.RST (see the EDRST
        command).  If Jobname.HIS is desired, you must also issue EDHIST.

        Option = LSDYNA or BOTH will cause LS-DYNA to write results files for
        the LS-POST postprocessor. The D3PLOT file is always written for these
        two options. If other LS-POST files are desired, you must issue the
        appropriate EDHIST and EDOUT commands.

        This command is also valid in PREP7.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "EDWRITE,%s,%s,%s" % (str(option), str(fname), str(ext))
        return self.run(command, **kwargs)

    def post26(self, **kwargs):
        """APDL Command: /POST26

        Enters the time-history results postprocessor.

        Notes
        -----
        Enters the time-history results postprocessor (POST26).

        This command is valid only at the Begin Level.
        """
        command = "/POST26," % ()
        return self.run(command, **kwargs)

    def mwrite(self, parr="", fname="", ext="", label="", n1="", n2="", n3="",
               **kwargs):
        """APDL Command: *MWRITE

        Writes a matrix to a file in a formatted sequence.

        Parameters
        ----------
        parr
            The name of the array parameter. See *SET for name restrictions.

        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        label
            Can use a value of IJK, IKJ, JIK, JKI, KIJ, KJI, or blank (JIK).

        n1, n2, n3
            Write as (((ParR(i,j,k), k = 1,n1), i = 1, n2), j = 1, n3) for
            Label = KIJ. n1, n2, and n3 default to the corresponding dimensions
            of the array parameter ParR.

        Notes
        -----
        Writes a matrix or vector to a specified file in a formatted sequence.
        You can also use the *VWRITE command to write data to a specified file.
        Both commands contain format descriptors on the line immediately
        following the command. The format descriptors can be in either Fortran
        or C format.

        Fortran format descriptors are enclosed in parentheses. They must
        immediately follow the *MWRITE command on a separate line of the same
        input file. The word FORMAT should not be included. The format must
        specify the number of fields to be written per line, the field width,
        the placement of the decimal point, etc. There should be one field
        descriptor for each data item written. The write operation uses the
        available system FORTRAN FORMAT conventions (see your system FORTRAN
        manual). Any standard FORTRAN real format (such as (4F6.0),
        (E10.3,2X,D8.2), etc.) and character format (A) may be used.  Integer
        (I) and list-directed (*) descriptors may not be used. Text may be
        included in the format as a quoted string. The FORTRAN descriptor must
        be enclosed in parentheses and the format must not exceed 80 characters
        (including parentheses).

        The “C” format descriptors are used if the first character of the
        format descriptor line is not a left parenthesis. “C” format
        descriptors may be up to 80 characters long, consisting of text strings
        and predefined "data descriptors" between the strings where numeric or
        alphanumeric character data are to be inserted. The normal descriptors
        are %I for integer data, %G for double precision data, %C for
        alphanumeric character data, and %/ for a line break. There must be one
        data descriptor for each specified value in the order of the specified
        values. The enhanced formats described in *MSG may also be used.

        The starting array element number must be defined. Looping continues in
        the directions indicated by the Label argument. The number of loops and
        loop skipping may also be controlled with the *VLEN and *VMASK
        commands, which work in the n2 direction (by row on the output file),
        and by  the *VCOL command, which works in the n1 direction (by column
        in the output file).  The vector specifications *VABS and *VFACT apply
        to this command, while *VCUM does not apply to this command. See the
        *VOPER command for details. If you are in the GUI, the *MWRITE command
        must be contained in an externally prepared file and read into ANSYS
        (i.e., *USE, /INPUT, etc.).

        This command is valid in any processor.
        """
        command = "*MWRITE,%s,%s,%s,%s,%s,%s,%s" % (str(parr), str(fname), str(ext), str(label), str(n1), str(n2), str(n3))
        return self.run(command, **kwargs)

    def kwpave(self, p1="", p2="", p3="", p4="", p5="", p6="", p7="", p8="",
               p9="", **kwargs):
        """APDL Command: KWPAVE

        Moves the working plane origin to the average location of keypoints.

        Parameters
        ----------
        p1, p2, p3, . . . , p9
            Keypoints used in calculation of the average.  At least one must be
            defined.  If P1 = P, graphical picking is enabled and all remaining
            command fields are ignored (valid only in the GUI).

        Notes
        -----
        Moves the origin of the working plane to the average of the specified
        keypoints.  Averaging is based on the active coordinate system.

        This command is valid in any processor.
        """
        command = "KWPAVE,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(p1), str(p2), str(p3), str(p4), str(p5), str(p6), str(p7), str(p8), str(p9))
        return self.run(command, **kwargs)

    def gmatrix(self, symfac="", condname="", numcond="", matrixname="",
                **kwargs):
        """APDL Command: GMATRIX

        Performs electric field solutions and calculates the self and mutual
        conductance between multiple conductors.

        Parameters
        ----------
        symfac
            Geometric symmetry factor.  Conductance values are scaled by this
            factor which represents the fraction of the total device modeled.
            Defaults to 1.

        condname
            Alphanumeric prefix identifier used in defining named conductor
            components.

        numcond
            Total number of components.  If a ground is modeled, it is to be
            included as a component.

        --
            Unused field.

        matrixname
            Array name for computed conductance matrix.  Defaults to GMATRIX.

        Notes
        -----
        To invoke the GMATRIX macro, the exterior nodes of each conductor must
        be grouped into individual components using the CM command.  Each set
        of  independent components is assigned a component name with a common
        prefix followed by the conductor number.  A conductor system with a
        ground must also include the ground nodes as a component.  The ground
        component is numbered last in the component name sequence.

        A ground conductance matrix relates current to a voltage vector.  A
        ground matrix cannot be applied to a circuit modeler.  The lumped
        conductance matrix is a combination of  lumped "arrangements" of
        voltage differences between conductors.  Use the lumped conductance
        terms in a circuit modeler to represent conductances between
        conductors.

        Enclose all name-strings in single quotes in the GMATRIX command line.

        GMATRIX works with the following elements:

        SOLID5 (KEYOPT(1) = 9)

        SOLID98 (KEYOPT(1) = 9)

        LINK68

        PLANE230

        SOLID231

        SOLID232

        This command is available from the menu path shown below only if
        existing results are available.

        This command does not support multiframe restarts

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "GMATRIX,%s,%s,%s,%s" % (str(symfac), str(condname), str(numcond), str(matrixname))
        return self.run(command, **kwargs)

    def deltim(self, dtime="", dtmin="", dtmax="", carry="", **kwargs):
        """APDL Command: DELTIM

        Specifies the time step sizes to be used for the current load step.

        Parameters
        ----------
        dtime
            Time step size for this step. If automatic time stepping is used
            (AUTOTS), DTIME is the starting time substep.

        dtmin
            Minimum time step (if automatic time stepping is used). The program
            automatically determines the default based on the physics of the
            model.

        dtmax
            Maximum time step (if automatic time stepping is used). The program
            automatically determines the default based on the physics of the
            model.

        carry
            Time step carry over key:

            OFF - Use DTIME as time step at start of each load step.

            ON - Use final time step from previous load step as the starting time step (if
                 automatic time stepping is used).

        Notes
        -----
        See NSUBST for an alternative input.

        Use consistent values for DTIME and TIME (TIME). For example, using 0.9
        for DTIME and 1.0 for TIME results in one time step because 1.0 (TIME)
        is divisible by .9 (DTIME) at most once. If you intend to load in 10
        increments over a time span of 1.0, use 0.1 for DTIME and 1.0 for TIME.

        The program calculates the initial incremental time so that (EndingTime
        - StartingTime)/DTIME is an integer, which may affect the initial
        incremental time that you specify. For example, if the starting time is
        0, the ending time is 1, and the initial incremental time is 0.4, the
        program rounds to the nearest integer and adjusts the time to 0.33333.

        For solution efficiency, specify values for all fields of this command.

        This command is also valid in PREP7.
        """
        command = "DELTIM,%s,%s,%s,%s" % (str(dtime), str(dtmin), str(dtmax), str(carry))
        return self.run(command, **kwargs)

    def usrcal(self, rnam1="", rnam2="", rnam3="", rnam4="", rnam5="",
               rnam6="", rnam7="", rnam8="", rnam9="", **kwargs):
        """APDL Command: USRCAL

        Allows user-solution subroutines to be activated or deactivated.

        Parameters
        ----------
        rnam1, rnam2, rnam3, . . . , rnam9
            User-defined solution subroutine names to be activated.  Up to nine
            may be defined on one command or multiple commands may be used.  If
            Rnam1 = ALL, activate all valid user subroutines.   If Rnam1 =
            NONE, deactivate all valid user subroutines.  All characters are
            required:

            USREFL - Allows user defined scalar field (body force) loads.

            USERCV - Allows user defined convection (surface) loads.

            USERPR - Allows user defined pressure (surface) loads.

            USERFX - Allows user-defined heat flux (surface) loads.

            USERCH - Allows user-defined charge density (surface) loads.

            USERFD - Computes the complex load vector for the frequency domain logic.

            USEROU - Allows user supplied element output.

            USERMC - Allows user control of the hygrothermal growth).

            USOLBEG - Allows user access before each solution.

            ULDBEG - Allows user access before each load step.

            USSBEG - Allows user access before each substep.

            UITBEG - Allows user access before each equilibrium iteration.

            UITFIN - Allows user access after each equilibrium iteration.

            USSFIN - Allows user access after each substep.

            ULDFIN - Allows user access after each load step.

            USOLFIN - Allows user access after each solution.

            UANBEG - Allows user access at start of run.

            UANFIN - Allows user access at end of run.

            UELMATX - Allows user access to element matrices and load vectors.

            UTIMEINC - Allows a user-defined time step, overriding the program-determined time step.

            UCNVRG - Allows user-defined convergence checking, overriding the program-determined
                     convergence.

        Notes
        -----
        Allows certain user-solution subroutines to be activated or deactivated
        (system-dependent).  This command only affects the subroutines named.
        Other user subroutines (such as user elements, user creep, etc.) have
        their own activation controls described with the feature.

        The routines are commented and should be listed after performing a
        custom installation from the distribution media for more details.  See
        also the Advanced Analysis Guide for a general description of user-
        programmable features.

        Users must have system permission, system access, and knowledge to
        write, compile, and link the appropriate subroutines into the program
        at the site where it is to be run.  All routines should be written in
        FORTRAN. (For more information on FORTRAN compilers please refer to
        either the ANSYS, Inc. Windows Installation Guide or the ANSYS, Inc.
        Linux Installation Guide for details specific to your platform or
        operating system.) Issue USRCAL,STAT to list the status of these user
        subroutines.  Since a user-programmed subroutine is a nonstandard use
        of the program, the verification of any ANSYS run incorporating these
        commands is entirely up to the user.  In any contact with ANSYS
        customer support regarding the performance of a custom version of the
        ANSYS program, you should explicitly state that a user programmable
        feature has been used.

        This command is also valid in PREP7.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "USRCAL,%s,%s,%s,%s,%s,%s,%s,%s,%s" % (str(rnam1), str(rnam2), str(rnam3), str(rnam4), str(rnam5), str(rnam6), str(rnam7), str(rnam8), str(rnam9))
        return self.run(command, **kwargs)

    def gsgdata(self, lfiber="", xref="", yref="", rotx0="", roty0="",
                **kwargs):
        """APDL Command: GSGDATA

        Specifies the reference point and defines the geometry in the fiber
        direction for the generalized plane strain element option.

        Parameters
        ----------
        lfiber
            Fiber length from the reference point. Defaults to 1.

        xref
            X coordinate of the reference point. Defaults to zero.

        yref
            Y coordinate of the reference point. Defaults to zero.

        rotx0
            Rotation of the ending plane about X in radians Defaults to zero.

        roty0
            Rotation of the ending plane about Y in radians Defaults to zero.

        Notes
        -----
        The ending point is automatically determined from the starting
        (reference) point and the geometry inputs. All inputs are in the global
        Cartesian coordinate system. For more information about the generalized
        plane strain feature, see Generalized Plane Strain Option of Current-
        Technology Solid Elements in the  Element Reference.
        """
        command = "GSGDATA,%s,%s,%s,%s,%s" % (str(lfiber), str(xref), str(yref), str(rotx0), str(roty0))
        return self.run(command, **kwargs)

    def mfcalc(self, fnumb="", freq="", **kwargs):
        """APDL Command: MFCALC

        Specifies a calculation frequency for a field in an ANSYS Multi-field
        solver analysis.

        Parameters
        ----------
        fnumb
            Field number set by the MFELEM command.

        freq
            Perform calculation every Nth ANSYS Multi-field solver time step.
            Defaults to 1 for every time step.

        Notes
        -----
        This command only applies to a harmonic analysis of the specified
        field. It is useful when a field contributes negligible field
        interaction within a single ANSYS Multi-field solver time step.

        This command is also valid in PREP7.

        See Multi-field Commands in the Coupled-Field Analysis Guide for a list
        of all ANSYS Multi-field solver commands and their availability for MFS
        and MFX analyses.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "MFCALC,%s,%s" % (str(fnumb), str(freq))
        return self.run(command, **kwargs)

    def blc4(self, xcorner="", ycorner="", width="", height="", depth="",
             **kwargs):
        """APDL Command: BLC4

        Creates a rectangular area or block volume by corner points.

        Parameters
        ----------
        xcorner, ycorner
            Working plane X and Y coordinates of one corner of the rectangle or
            block face.

        width
            The distance from XCORNER on or parallel to the working plane
            X-axis that, together with YCORNER, defines a second corner of the
            rectangle or block face.

        height
            The distance from YCORNER on or parallel to the working plane
            Y-axis that, together with XCORNER, defines a third corner of the
            rectangle or block face.

        depth
            The perpendicular distance (either positive or negative based on
            the working plane Z direction) from the working plane representing
            the depth of the block.  If DEPTH = 0 (default), a rectangular area
            is created on the working plane.

        Notes
        -----
        Defines a rectangular area anywhere on the working plane or a
        hexahedral volume with one face anywhere on the working plane.  A
        rectangle will be defined with four keypoints and four lines.  A volume
        will be defined with eight keypoints, twelve lines, and six areas, with
        the top and bottom faces parallel to the working plane.  See the BLC5,
        RECTNG, and BLOCK commands for alternate ways to create rectangles and
        blocks.
        """
        command = "BLC4,%s,%s,%s,%s,%s" % (str(xcorner), str(ycorner), str(width), str(height), str(depth))
        return self.run(command, **kwargs)

    def nplot(self, knum="", **kwargs):
        """APDL Command: NPLOT

        Displays nodes.

        Parameters
        ----------
        knum
            Node number key:

            0 - No node numbers on display.

            1 - Include node numbers on display.  See also /PNUM command.

        Notes
        -----
        Produces a node display.  Only selected nodes [NSEL] are displayed.
        Elements need not be defined.  See the DSYS command for display
        coordinate system.

        This command is valid in any processor.
        """
        command = "NPLOT,%s" % (str(knum))
        return self.run(command, **kwargs)

    def kbc(self, key="", **kwargs):
        """APDL Command: KBC

        Specifies ramped or stepped loading within a load step.

        Parameters
        ----------
        key
            Ramping key:

            0 - Loads are linearly interpolated (ramped) for each substep from the values of
                the previous load step to the values of this load step. This is
                the default value.

            1 - Loads are step changed (stepped) at the first substep of this load step to the
                values of this load step (i.e., the same values are used for
                all substeps).  Useful for rate-dependent behavior (e.g.,
                creep, viscoplasticity, etc.) or transient load steps only.

        Notes
        -----
        Specifies whether loads applied to intermediate substeps within the
        load step are to be stepped or ramped. Used only if DTIME on the DELTIM
        command is less than the time span or, conversely, if NSBSTP on the
        NSUBST command is greater than one. Flags (FSI, MXWF, MVDI, etc.) are
        always stepped.

        Changing the ramping KEY (i.e., switching between ramped and stepped
        boundary conditions) between load steps is not recommended.

        For ramped loading (KBC,0), when a load is applied for the first time,
        it is interpolated from zero to the value of the current load step, and
        not from the initial condition or value of the degree of freedom from
        the previous load step.

        Spatially varying tabular loads or boundary conditions do not support
        direct ramping or stepping options and, instead, apply their full
        values according to the supplied tabular functions regardless of the
        KBC setting.

        For a static or harmonic cyclic symmetry analysis, any load that varies
        by sector (CYCOPT,LDSECT) is tabular and is applied as a step change,
        regardless of the KBC setting; however, any non-tabular loads in the
        same analysis are ramped or stepped according to the KBC setting.

        Irrespective of the KBC setting, loads are usually step-removed. See
        Stepping or Ramping Loads in the Basic Analysis Guide for more
        information.

        It is sometimes difficult to obtain successful convergence with stepped
        loading in a nonlinear transient problem. If divergence is encountered,
        determine if stepped loading was used by default, then determine if it
        is appropriate for the analysis.

        This command is also valid in PREP7.
        """
        command = "KBC,%s" % (str(key))
        return self.run(command, **kwargs)

    def gst(self, lab="", lab2="", **kwargs):
        """APDL Command: /GST

        Turns Graphical Solution Tracking (GST) on or off.

        Parameters
        ----------
        lab
            Determines whether the Graphical Solution Tracking feature is
            active.  Specify ON to activate GST, or OFF to deactivate the
            feature.

        lab2
            Activates generation of interface and field convergence files
            (ANSYS MFX analyses only).

        Notes
        -----
        For interactive runs using GUI [/MENU,ON] or graphics [/MENU,GRPH]
        mode, ANSYS directs GST graphics to the screen.  For interactive
        sessions not using GUI or graphics mode, or for batch sessions, GST
        graphics are saved in the ANSYS graphics file Jobname.GST when Lab2 is
        unspecified. The file Jobname.GST can be viewed with the DISPLAY
        program in this case. You must select All File Types to access it. For
        more information on the DISPLAY program see Getting Started with the
        DISPLAY Program in the Basic Analysis Guide. For MFX runs (when
        Lab2=ON), the Jobname.GST file is in XML format, and it can be viewed
        with the Results Tracker Utility, accessed from within the Tools menu
        of the Mechanical APDL Product Launcher.

        The GST feature is available only for nonlinear structural, thermal,
        electric, magnetic, fluid, or CFD simulations. For more information
        about this feature and illustrations of the GST graphics for each
        analysis type, see the ANSYS Analysis Guide for the appropriate
        discipline.  See also the CNVTOL command description.

        When running an ANSYS MFX analysis, specify /GST,ON,ON to generate both
        the interface (Jobname.NLH) and field convergence (Fieldname.GST) files
        for monitoring the analysis. This field is not available on the GUI.
        """
        command = "/GST,%s,%s" % (str(lab), str(lab2))
        return self.run(command, **kwargs)

    def parsav(self, lab="", fname="", ext="", **kwargs):
        """APDL Command: PARSAV

        Writes parameters to a file.

        Parameters
        ----------
        lab
            Write operation:

            Write only scalar parameters (default). - Write scalar and array parameters.  Parameters may be numeric or alphanumeric.

        fname
            File name and directory path (248 characters maximum, including the
            characters needed for the directory path).  An unspecified
            directory path defaults to the working directory; in this case, you
            can use all 248 characters for the file name.

        ext
            Filename extension (eight-character maximum).

        --
            Unused field.

        Notes
        -----
        Writes the current parameters to a coded file.  Previous parameters on
        this file, if any, will be overwritten.  The parameter file may be read
        with the PARRES command.

        PARSAV/PARRES operations truncate some long decimal strings, and can
        cause differing values in your solution data when other operations are
        performed. A good practice is to limit the number of decimal places you
        will use before and after these operations.

        This command is valid in any processor.
        """
        command = "PARSAV,%s,%s,%s" % (str(lab), str(fname), str(ext))
        return self.run(command, **kwargs)

    def grp(self, signif="", label="", forcetype="", **kwargs):
        """APDL Command: GRP

        Specifies the grouping mode combination method.

        Parameters
        ----------
        signif
            Combine only those modes whose significance level exceeds the
            SIGNIF  threshold.  For single point, multipoint, or DDAM response
            (SPOPT,SPRS, MPRS or DDAM), the significance level of a mode is
            defined as the mode coefficient of the mode, divided by the maximum
            mode coefficient of all modes.  Any mode whose significance level
            is less than SIGNIF is considered insignificant and is not
            contributed to the mode combinations.  The higher the SIGNIF
            threshold, the fewer the number of modes combined.  SIGNIF defaults
            to 0.001.  If SIGNIF is specified as 0.0, it is taken as 0.0.
            (This mode combination method is not valid for SPOPT,PSD.)

        label
            Label identifying the combined mode solution output.

            DISP - Displacement solution (default).  Displacements, stresses, forces, etc., are
                   available.

            VELO - Velocity solution.  Velocities, "stress velocities," "force velocities," etc.,
                   are available.

            ACEL - Acceleration solution.  Accelerations, "stress accelerations," "force
                   accelerations," etc., are available.

        forcetype
            Label identifying the forces to be combined:

            STATIC - Combine the modal static forces (default).

            TOTAL - Combine the modal static plus inertial forces.

        Notes
        -----
        The SIGNIF value set with this command (including the default value of
        0.001) overrides the SIGNIF value set with the MXPAND command.

        This command is also valid for PREP7.
        """
        command = "GRP,%s,%s,%s" % (str(signif), str(label), str(forcetype))
        return self.run(command, **kwargs)

    def nummrg(self, label="", toler="", gtoler="", action="", switch="",
               **kwargs):
        """APDL Command: NUMMRG

        Merges coincident or equivalently defined items.

        Parameters
        ----------
        label
            Items to be merged:

            NODE - Nodes

            ELEM - Elements

            KP - Keypoints (will also merge lines, areas, and volumes)

            MAT - Materials

            TYPE - Element types

            REAL - Real constants

            CP - Coupled sets

            CE - Constraint equations

            ALL - All items

        toler
            Range of coincidence.  For Label = NODE and KP, defaults to 1.0E-4
            (based on maximum Cartesian coordinate difference between nodes or
            keypoints).  For Label = MAT, REAL, and CE, defaults to 1.0E-7
            (based on difference of the values normalized by the values).  Only
            items within range are merged.  (For keypoints attached to lines,
            further restrictions apply.  See the GTOLER field and Merging Solid
            Model Entities below.)

        gtoler
            Global solid model tolerance -- used only when merging keypoints
            attached to lines.  If specified, GTOLER will override the internal
            relative solid model tolerance.  See Merging Solid Model Entities
            below.

        action
            Specifies whether to merge or select coincident items.

            SELE - Select coincident items but do not merge. Action = SELE is only valid for Label
                   = NODE.

            (Blank) - Merge the coincident items (default).

        switch
            Specifies whether the lowest or highest numbered coincident item is
            retained after the merging operation.  This option does not apply
            to keypoints; i.e., for Label = KP, the lowest numbered keypoint is
            retained regardless of the Switch setting.

            LOW - Retain the lowest numbered coincident item after the merging operation
                  (default).

            HIGH - Retain the highest numbered coincident item after the merging operation.

        Notes
        -----
        After issuing the command, the area and volume sizes (ASUM and VSUM)
        may give slightly different results. In order to obtain the same
        results as before, use /FACET, /NORMAL, and ASUM / VSUM.

        The merge operation is useful for tying separate, but coincident, parts
        of a model together. If not all items are to be checked for merging,
        use the select commands (NSEL, ESEL, etc.) to select items.  Only
        selected items are included in the merge operation for nodes,
        keypoints, and elements.

        By default, the merge operation retains the lowest numbered coincident
        item.  Higher numbered coincident items are deleted.  Set Switch to
        HIGH to retain the highest numbered coincident item after the merging
        operation.  Applicable related items are also checked for deleted item
        numbers and if found, are replaced with the retained item number.  For
        example, if nodes are merged, element connectivities (except
        superelements), mesh item range associativity, coupled degrees of
        freedom, constraint equations, master degrees of freedom, gap
        conditions, degree of freedom constraints, nodal force loads, nodal
        surface loads, and nodal body force loads are checked.  Merging
        material numbers [NUMMRG,ALL or NUMMRG,MAT] does not update the
        material number referenced:

        By temperature-dependent film coefficients as part of convection load
        or a temperature-dependent emissivity as part of a surface-to-surface
        radiation load [SF, SFE, SFL, SFA]

        By real constants for multi-material elements (such as SOLID65)

        If a unique load is defined among merged nodes, the value is kept and
        applied to the retained node.  If loads are not unique (not
        recommended), only the value on the lowest node (or highest if Switch =
        HIGH) will be kept, except for "force" loads for which the values will
        be summed if they are not defined using tabular boundary conditions.

        Note:: : The unused nodes (not recommended) in elements, couplings,
        constraint equations, etc. may become active after the merge operation.

        The Action field provides the option of visualizing the coincident
        items before the merging operation.

        Caution:: : When merging entities in a model that has already been
        meshed, the order in which you issue multiple NUMMRG commands is
        significant.  If you want to merge two adjacent meshed regions that
        have coincident nodes and keypoints, always merge nodes [NUMMRG,NODE]
        before merging keypoints [NUMMRG,KP].  Merging keypoints before nodes
        can result in some of the nodes becoming "orphaned"; that is, the nodes
        lose their association with the solid model.  Orphaned nodes can cause
        certain operations (such as boundary condition transfers, surface load
        transfers, and so on) to fail. However, using NUMMRG should be avoided
        if at all possible, as the procedure outlined above may even cause
        meshing failure, especially after multiple merging and meshing
        operations.

        After a NUMMRG,NODE, is issued, some nodes may be attached to more than
        one solid entity. As a result, subsequent attempts to transfer solid
        model loads to the elements may not be successful. Issue NUMMRG,KP to
        correct this problem. Do NOT issue VCLEAR before issuing NUMMRG,KP.

        For NUMMRG,ELEM, elements must be identical in all aspects, including
        the direction of the element coordinate system.

        For certain solid and shell elements (181, 185, 190, etc) ANSYS will
        interpret coincident faces as internal and eliminate them. To prevent
        this from occurring, shrink the entities by a very small factor to
        delineate coincident items (/SHRINK, 0.0001) and no internal nodes,
        lines, areas or elements will be eliminated.

        When working with solid models, you may have better success with the
        gluing operations (AGLUE, LGLUE, VGLUE). Please read the following
        information when attempting to merge solid model entities.

        Gluing Operations vs. Merging Operations

        Adjacent, touching regions can be joined by gluing them (AGLUE, LGLUE,
        VGLUE) or by merging coincident keypoints (NUMMRG,KP, which also causes
        merging of identical lines, areas, and volumes).  In many situations,
        either approach will work just fine. Some factors, however, may lead to
        a preference for one method over the other.

        Geometric Configuration

        Gluing is possible regardless of the initial alignment or offset of the
        input entities. Keypoint merging is  possible only if each keypoint on
        one side of the face to be joined is matched by a coincident keypoint
        on the other side. This is commonly the case after a symmetry
        reflection (ARSYM or VSYMM) or a copy (AGEN or VGEN),  especially for a
        model built entirely in ANSYS rather than imported from a CAD system.
        When the geometry is  extremely precise, and the configuration is
        correct for  keypoint merging, NUMMRG is more efficient and robust than
        AGLUE or VGLUE.
        """
        command = "NUMMRG,%s,%s,%s,%s,%s" % (str(label), str(toler), str(gtoler), str(action), str(switch))
        return self.run(command, **kwargs)

    def nkpt(self, node="", npt="", **kwargs):
        """APDL Command: NKPT

        Defines a node at an existing keypoint location.

        Parameters
        ----------
        node
            Arbitrary reference number for node.  If zero or blank, defaults to
            the highest node number +1 [NUMSTR].

        npt
            Keypoint number defining global X, Y, Z  location.  If NPT = All,
            then a node will be placed at each selected keypoint.  If NPT = P,
            graphical picking is enabled and all remaining command fields are
            ignored (valid only in the GUI).  A component name may also be
            substituted for NPT.
        """
        command = "NKPT,%s,%s" % (str(node), str(npt))
        return self.run(command, **kwargs)

    def lccalc(self, **kwargs):
        """APDL Command: LCCALC

        Specifies "Load case settings" as the subsequent status topic.

        Notes
        -----
        This is a status [STAT] topic command.  Status topic commands are
        generated by the GUI and will appear in the log file (Jobname.LOG) if
        status is requested for some items under Utility Menu> List> Status.
        This command will be immediately followed by a STAT command, which will
        report the status for the specified topic.

        If entered directly into the program, the STAT command should
        immediately follow this command.

        This command is also valid for rezoning.
        """
        command = "LCCALC," % ()
        return self.run(command, **kwargs)

    def sbctran(self, **kwargs):
        """APDL Command: SBCTRAN

        Transfers solid model loads and boundary conditions to the FE model.

        Notes
        -----
        Causes a manual transfer of solid model loads and boundary conditions
        to the finite element model.  Loads and boundary conditions on
        unselected keypoints, lines, areas, and volumes are not transferred.
        Boundary conditions and loads will not be transferred to unselected
        nodes or elements.  The SBCTRAN operation is also automatically done
        upon initiation of the solution calculations [SOLVE].

        This command is also valid in PREP7.
        """
        command = "SBCTRAN," % ()
        return self.run(command, **kwargs)

    def mfsurface(self, inumb="", fnumb1="", label="", fnumb2="", **kwargs):
        """APDL Command: MFSURFACE

        Defines a surface load transfer for an ANSYS Multi-field solver
        analysis.

        Parameters
        ----------
        inumb
            Interface number for load transfer. The interface number
            corresponds to the interface number specified by the surface flag
            FSIN (SFxxcommands).

        fnumb1
            Field number of sending field.

        label
            Valid surface load labels:

        fnumb2
            Field number for receiving field.

        Notes
        -----
        This command is also valid in PREP7.

        The ANSYS Multi-field solver solver does not allow you to switch the
        load transfer direction for the same load quantity across the same
        interfaces for a restart run. For example, if Field1 sends temperature
        to and receives heat flow from Field2 across Interface 1 in a previous
        solution, then you cannot make Field1 send heat flow to and receive
        temperatures from Field2 across the same interface in a restart run,
        even if you cleared the corresponding load transfer command.

        See Multi-field Commands in the Coupled-Field Analysis Guide for a list
        of all ANSYS Multi-field solver commands and their availability for MFS
        and MFX analyses.

        Distributed ANSYS Restriction: This command is not supported in
        Distributed ANSYS.
        """
        command = "MFSURFACE,%s,%s,%s,%s" % (str(inumb), str(fnumb1), str(label), str(fnumb2))
        return self.run(command, **kwargs)

    def asbw(self, na="", sepo="", keep="", **kwargs):
        """APDL Command: ASBW

        Subtracts the intersection of the working plane from areas (divides
        areas).

        Parameters
        ----------
        na
            Area (or areas, if picking is used) to be subtracted from.  If NA =
            ALL, use all selected areas.  If NA = P, graphical picking is
            enabled (valid only in the GUI).  A component name may also be
            input for NA.

        sepo
            Behavior of the created boundary.

            (blank) - The resulting areas will share line(s) where they touch.

            SEPO - The resulting areas will have separate, but coincident line(s).

        keep
            Specifies whether NA areas are to be deleted.

            (blank) - Use the setting of KEEP on the BOPTN command.

            DELETE - Delete NA areas after ASBW operation (override BOPTN command settings).

            KEEP - Keep NA areas after ASBW operation (override BOPTN command settings).

        Notes
        -----
        Generates new areas by subtracting the intersection of the working
        plane from the NA areas.  The intersection will be a line(s).  The
        working plane must not be in the same plane as the NA areas(s).  If
        SEPO is blank, the NA area is divided at the line and the resulting
        areas will be connected, sharing a common line where they touch.  If
        SEPO is set to SEPO, NA is divided into two unconnected areas with
        separate lines.  The SEPO option may cause unintended consequences if
        any keypoints exist along the cut plane. See Solid Modeling in the
        Modeling and Meshing Guide for an illustration.  See the BOPTN command
        for an explanation of the options available to Boolean operations.
        Element attributes and solid model boundary conditions assigned to the
        original entities will not be transferred to the new entities
        generated.

        Issuing the ASBW command under certain conditions may generate a
        topological degeneracy error. Do not issue the command if:

        A sphere or cylinder has been scaled. (A cylinder must be scaled
        unevenly in the XY plane.)

        A sphere or cylinder has not been scaled but the work plane has been
        rotated.
        """
        command = "ASBW,%s,%s,%s" % (str(na), str(sepo), str(keep))
        return self.run(command, **kwargs)

    def tble(self, **kwargs):
        """APDL Command: TBLE

        Specifies "Data table properties" as the subsequent status topic.

        Notes
        -----
        This is a status (STAT) topic command.  Status topic commands are
        generated by the GUI and will appear in the log file (Jobname.LOG) if
        status is requested for some items under Utility Menu> List> Status.
        This command will be immediately followed by a STAT command, which will
        report the status for the specified topic.

        If entered directly into the program, the STAT command should
        immediately follow this command.
        """
        command = "TBLE," % ()
        return self.run(command, **kwargs)

    def seg(self, label="", aviname="", delay="", **kwargs):
        """APDL Command: /SEG

        Allows graphics data to be stored in the local terminal memory.

        Parameters
        ----------
        label
            Storage key:

            SINGL - Store subsequent display in a single segment (overwrites last storage).

            MULTI - Store subsequent displays in unique segments [ANIM].

            DELET - Delete all currently stored segments.

            OFF - Stop storing display data in segments.

            STAT - Display segment status.

            PC - This option only applies to PC versions of ANSYS and only when animating via
                 the AVI movie player (i.e., /DEVICE,ANIM,2).  This command
                 appends frames to the File.AVI, so that the animation goes in
                 both directions (i.e., forward--backward--forward).  You must
                 have a current animation file to use this option.

        aviname
            Name of the animation file that will be created when each frame is
            saved. The .AVI extension is applied automatically. Defaults to
            Jobname.AVI if no filename is specified.

        delay
            Delay factor between each frame, in seconds. Defaults to 0.015
            seconds if no value is specified.

        Notes
        -----
        Allows graphics data to be stored in the terminal local memory (device-
        dependent).  Storage occurs concurrently with the display.

        Although the information from your graphics window is stored as an
        individual segment, you cannot plot directly (GPLOT) from the segment
        memory.

        For the DISPLAY program, the Aviname and DELAY fields are ignored.

        This command is valid in any processor.
        """
        command = "/SEG,%s,%s,%s" % (str(label), str(aviname), str(delay))
        return self.run(command, **kwargs)

    def source(self, x="", y="", z="", **kwargs):
        """APDL Command: SOURCE

        Defines a default location for undefined nodes or keypoints.

        Parameters
        ----------
        x, y, z
            Global Cartesian coordinates for source nodes or keypoints
            (defaults to the origin).

        Notes
        -----
        Defines a global Cartesian location for undefined nodes or keypoints
        moved during intersection calculations [MOVE or KMOVE].
        """
        command = "SOURCE,%s,%s,%s" % (str(x), str(y), str(z))
        return self.run(command, **kwargs)

    def cwd(self, dirpath="", **kwargs):
        """APDL Command: /CWD

        Changes the current working directory.

        Parameters
        ----------
        dirpath
            The full path name of the new working directory.

        Notes
        -----
         After issuing the /CWD command, all new files opened with no default
        directory specified (via the FILE, /COPY, or RESUME commands, for
        example) default to the new DIRPATH directory.
        """
        command = "/CWD,%s" % (str(dirpath))
        return self.run(command, **kwargs)

    def prnld(self, lab="", tol="", item="", **kwargs):
        """APDL Command: PRNLD

        Prints the summed element nodal loads.

        Parameters
        ----------
        lab
            Nodal reaction load type.  If blank, use the first ten of all
            available labels.  Valid labels are:

        tol
            Tolerance value about zero within which loads are not printed, as
            follows:

            > 0  - Relative tolerance about zero within which loads are not printed. In this case,
                   the tolerance is TOL * Load, where Load is the absolute
                   value of the maximum load on the selected nodes.

             0  -  Print all nodal loads.

            > 0  - Absolute tolerance about zero within which loads are not printed.

        item
            Selected set of nodes.

            (blank) - Prints the summed element nodal loads for all selected nodes (default),
                      excluding contact elements.

            CONT - Prints the summed element nodal loads for contact nodes only.

            BOTH - Prints the summed element nodal loads for all selected nodes, including contact
                   nodes.

        Notes
        -----
        Prints the summed element nodal loads (forces, moments, heat flows,
        flux, etc.) for the selected nodes in the sorted sequence.  Results are
        in the global Cartesian coordinate directions unless transformed
        [RSYS].  Zero values (within a tolerance range) are not printed.  Loads
        applied to a constrained degree of freedom are not included.  The FORCE
        command can be used to define which component of the nodal load is to
        be used (static, damping, inertia, or total).

        By default, PRNLD excludes elements TARGE169 - CONTA177. Setting ITEM =
        CONT will only account for nodal forces on selected contact elements
        (CONTA171 - CONTA177). Setting ITEM = BOTH will account for nodal
        forces on all selected nodes, including contact nodes.
        """
        command = "PRNLD,%s,%s,%s" % (str(lab), str(tol), str(item))
        return self.run(command, **kwargs)

    def bftran(self, **kwargs):
        """APDL Command: BFTRAN

        Transfers solid model body force loads to the finite element model.

        Notes
        -----
        Body loads are transferred from selected keypoints and lines to
        selected nodes and from selected areas and volumes to selected
        elements.  The BFTRAN operation is also done if the SBCTRAN command is
        either explicitly issued or automatically issued upon initiation of the
        solution calculations [SOLVE].

        This command is also valid in PREP7.
        """
        command = "BFTRAN," % ()
        return self.run(command, **kwargs)

    def mapvar(self, option="", matid="", istrtstress="", ntenstress="",
               istrtstrain="", ntenstrain="", istrtvect="", nvect="",
               **kwargs):
        """APDL Command: MAPVAR

        Defines tensors and vectors in user-defined state variables for
        rezoning and in 2-D to 3-D analyses.

        Parameters
        ----------
        option
            DEFINE

            DEFINE - Define variables for the specified MatId material ID (default).

            LIST - List the defined variables for the specified MatId material ID.

        matid
            The material ID for the state variables which you are defining
            (Option = DEFINE) or listing (Option = LIST).

        istrtstress
            The start position of stress-like tensors in the state variables.
            This value must be either a positive integer or 0 (meaning no
            stress-like tensors).

        ntenstress
            The number of stress-like tensors in the state variables. This
            value must be either a positive integer (or 0), and all stress-like
            tensors must be contiguous.

        istrtstrain
            The start position of strain-like tensors in the state variables.
            This value must be either a positive integer or 0 (meaning no
            strain-like tensors).

        ntenstrain
            The number of strain-li