# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ActionNode(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'clone_node_settings': 'ActionNodeCloneNodeSettings',
        'enslave_node': 'ActionNodeEnslaveNode',
        'maintenance_off': 'ActionNodeMaintenanceOff',
        'maintenance_on': 'ActionNodeMaintenanceOn',
        'remove': 'Node'
    }

    attribute_map = {
        'clone_node_settings': 'clone_node_settings',
        'enslave_node': 'enslave_node',
        'maintenance_off': 'maintenance_off',
        'maintenance_on': 'maintenance_on',
        'remove': 'remove'
    }

    def __init__(self, clone_node_settings=None, enslave_node=None, maintenance_off=None, maintenance_on=None, remove=None):  # noqa: E501
        """ActionNode - a model defined in Swagger"""  # noqa: E501
        self._clone_node_settings = None
        self._enslave_node = None
        self._maintenance_off = None
        self._maintenance_on = None
        self._remove = None
        self.discriminator = None
        if clone_node_settings is not None:
            self.clone_node_settings = clone_node_settings
        if enslave_node is not None:
            self.enslave_node = enslave_node
        if maintenance_off is not None:
            self.maintenance_off = maintenance_off
        if maintenance_on is not None:
            self.maintenance_on = maintenance_on
        if remove is not None:
            self.remove = remove

    @property
    def clone_node_settings(self):
        """Gets the clone_node_settings of this ActionNode.  # noqa: E501


        :return: The clone_node_settings of this ActionNode.  # noqa: E501
        :rtype: ActionNodeCloneNodeSettings
        """
        return self._clone_node_settings

    @clone_node_settings.setter
    def clone_node_settings(self, clone_node_settings):
        """Sets the clone_node_settings of this ActionNode.


        :param clone_node_settings: The clone_node_settings of this ActionNode.  # noqa: E501
        :type: ActionNodeCloneNodeSettings
        """

        self._clone_node_settings = clone_node_settings

    @property
    def enslave_node(self):
        """Gets the enslave_node of this ActionNode.  # noqa: E501


        :return: The enslave_node of this ActionNode.  # noqa: E501
        :rtype: ActionNodeEnslaveNode
        """
        return self._enslave_node

    @enslave_node.setter
    def enslave_node(self, enslave_node):
        """Sets the enslave_node of this ActionNode.


        :param enslave_node: The enslave_node of this ActionNode.  # noqa: E501
        :type: ActionNodeEnslaveNode
        """

        self._enslave_node = enslave_node

    @property
    def maintenance_off(self):
        """Gets the maintenance_off of this ActionNode.  # noqa: E501


        :return: The maintenance_off of this ActionNode.  # noqa: E501
        :rtype: ActionNodeMaintenanceOff
        """
        return self._maintenance_off

    @maintenance_off.setter
    def maintenance_off(self, maintenance_off):
        """Sets the maintenance_off of this ActionNode.


        :param maintenance_off: The maintenance_off of this ActionNode.  # noqa: E501
        :type: ActionNodeMaintenanceOff
        """

        self._maintenance_off = maintenance_off

    @property
    def maintenance_on(self):
        """Gets the maintenance_on of this ActionNode.  # noqa: E501


        :return: The maintenance_on of this ActionNode.  # noqa: E501
        :rtype: ActionNodeMaintenanceOn
        """
        return self._maintenance_on

    @maintenance_on.setter
    def maintenance_on(self, maintenance_on):
        """Sets the maintenance_on of this ActionNode.


        :param maintenance_on: The maintenance_on of this ActionNode.  # noqa: E501
        :type: ActionNodeMaintenanceOn
        """

        self._maintenance_on = maintenance_on

    @property
    def remove(self):
        """Gets the remove of this ActionNode.  # noqa: E501


        :return: The remove of this ActionNode.  # noqa: E501
        :rtype: Node
        """
        return self._remove

    @remove.setter
    def remove(self, remove):
        """Sets the remove of this ActionNode.


        :param remove: The remove of this ActionNode.  # noqa: E501
        :type: Node
        """

        self._remove = remove

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ActionNode, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ActionNode):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
