# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class BootstrapDnsSuffixes(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cluster_default': 'bool',
        'name': 'str',
        'slaves': 'list[AnyOfbootstrapDnsSuffixesSlavesItems]',
        'use_aaaa_ns': 'bool',
        'use_internal_addr': 'bool'
    }

    attribute_map = {
        'cluster_default': 'cluster_default',
        'name': 'name',
        'slaves': 'slaves',
        'use_aaaa_ns': 'use_aaaa_ns',
        'use_internal_addr': 'use_internal_addr'
    }

    def __init__(self, cluster_default=False, name=None, slaves=None, use_aaaa_ns=False, use_internal_addr=False):  # noqa: E501
        """BootstrapDnsSuffixes - a model defined in Swagger"""  # noqa: E501
        self._cluster_default = None
        self._name = None
        self._slaves = None
        self._use_aaaa_ns = None
        self._use_internal_addr = None
        self.discriminator = None
        if cluster_default is not None:
            self.cluster_default = cluster_default
        if name is not None:
            self.name = name
        if slaves is not None:
            self.slaves = slaves
        if use_aaaa_ns is not None:
            self.use_aaaa_ns = use_aaaa_ns
        if use_internal_addr is not None:
            self.use_internal_addr = use_internal_addr

    @property
    def cluster_default(self):
        """Gets the cluster_default of this BootstrapDnsSuffixes.  # noqa: E501

        Should this suffix be the default cluster suffix  # noqa: E501

        :return: The cluster_default of this BootstrapDnsSuffixes.  # noqa: E501
        :rtype: bool
        """
        return self._cluster_default

    @cluster_default.setter
    def cluster_default(self, cluster_default):
        """Sets the cluster_default of this BootstrapDnsSuffixes.

        Should this suffix be the default cluster suffix  # noqa: E501

        :param cluster_default: The cluster_default of this BootstrapDnsSuffixes.  # noqa: E501
        :type: bool
        """

        self._cluster_default = cluster_default

    @property
    def name(self):
        """Gets the name of this BootstrapDnsSuffixes.  # noqa: E501

        DNS suffix name  # noqa: E501

        :return: The name of this BootstrapDnsSuffixes.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this BootstrapDnsSuffixes.

        DNS suffix name  # noqa: E501

        :param name: The name of this BootstrapDnsSuffixes.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def slaves(self):
        """Gets the slaves of this BootstrapDnsSuffixes.  # noqa: E501

        List of slave servers that should be published as NS and notified  # noqa: E501

        :return: The slaves of this BootstrapDnsSuffixes.  # noqa: E501
        :rtype: list[AnyOfbootstrapDnsSuffixesSlavesItems]
        """
        return self._slaves

    @slaves.setter
    def slaves(self, slaves):
        """Sets the slaves of this BootstrapDnsSuffixes.

        List of slave servers that should be published as NS and notified  # noqa: E501

        :param slaves: The slaves of this BootstrapDnsSuffixes.  # noqa: E501
        :type: list[AnyOfbootstrapDnsSuffixesSlavesItems]
        """

        self._slaves = slaves

    @property
    def use_aaaa_ns(self):
        """Gets the use_aaaa_ns of this BootstrapDnsSuffixes.  # noqa: E501

        Should AAAA records be published for NS records  # noqa: E501

        :return: The use_aaaa_ns of this BootstrapDnsSuffixes.  # noqa: E501
        :rtype: bool
        """
        return self._use_aaaa_ns

    @use_aaaa_ns.setter
    def use_aaaa_ns(self, use_aaaa_ns):
        """Sets the use_aaaa_ns of this BootstrapDnsSuffixes.

        Should AAAA records be published for NS records  # noqa: E501

        :param use_aaaa_ns: The use_aaaa_ns of this BootstrapDnsSuffixes.  # noqa: E501
        :type: bool
        """

        self._use_aaaa_ns = use_aaaa_ns

    @property
    def use_internal_addr(self):
        """Gets the use_internal_addr of this BootstrapDnsSuffixes.  # noqa: E501

        Should internal cluster IPs be published for databases  # noqa: E501

        :return: The use_internal_addr of this BootstrapDnsSuffixes.  # noqa: E501
        :rtype: bool
        """
        return self._use_internal_addr

    @use_internal_addr.setter
    def use_internal_addr(self, use_internal_addr):
        """Sets the use_internal_addr of this BootstrapDnsSuffixes.

        Should internal cluster IPs be published for databases  # noqa: E501

        :param use_internal_addr: The use_internal_addr of this BootstrapDnsSuffixes.  # noqa: E501
        :type: bool
        """

        self._use_internal_addr = use_internal_addr

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(BootstrapDnsSuffixes, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BootstrapDnsSuffixes):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
