"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShardingInstance = exports.ShardingInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const mongodb_generated_1 = require("./mongodb.generated");
Object.defineProperty(exports, "ShardingInstanceProperty", { enumerable: true, get: function () { return mongodb_generated_1.RosShardingInstance; } });
/**
 * A ROS resource type:  `ALIYUN::MONGODB::ShardingInstance`
 */
class ShardingInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::MONGODB::ShardingInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosShardingInstance = new mongodb_generated_1.RosShardingInstance(this, id, {
            engineVersion: props.engineVersion ? props.engineVersion : '3.4',
            zoneId: props.zoneId,
            autoRenew: props.autoRenew,
            vSwitchId: props.vSwitchId,
            period: props.period ? props.period : 1,
            securityIpArray: props.securityIpArray,
            mongos: props.mongos,
            storageEngine: props.storageEngine ? props.storageEngine : 'WiredTiger',
            restoreTime: props.restoreTime,
            accountPassword: props.accountPassword,
            vpcId: props.vpcId,
            protocolType: props.protocolType,
            chargeType: props.chargeType ? props.chargeType : 'PostPaid',
            networkType: props.networkType,
            configServer: props.configServer,
            srcDbInstanceId: props.srcDbInstanceId,
            replicaSet: props.replicaSet,
            dbInstanceDescription: props.dbInstanceDescription,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosShardingInstance;
        this.attrDbInstanceId = rosShardingInstance.attrDbInstanceId;
        this.attrDbInstanceStatus = rosShardingInstance.attrDbInstanceStatus;
        this.attrOrderId = rosShardingInstance.attrOrderId;
    }
}
exports.ShardingInstance = ShardingInstance;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2hhcmRpbmdpbnN0YW5jZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNoYXJkaW5naW5zdGFuY2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsOENBQThDO0FBQzlDLDJEQUEwRDtBQUUxQix5R0FGdkIsdUNBQW1CLE9BRTRCO0FBa0d4RDs7R0FFRztBQUNILE1BQWEsZ0JBQWlCLFNBQVEsR0FBRyxDQUFDLFFBQVE7SUFzQjlDOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBNEIsRUFBRSxtQ0FBMkMsSUFBSTtRQUN2SCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sbUJBQW1CLEdBQUcsSUFBSSx1Q0FBbUIsQ0FBQyxJQUFJLEVBQUUsRUFBRSxFQUFHO1lBQzNELGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxLQUFLO1lBQ2hFLE1BQU0sRUFBRSxLQUFLLENBQUMsTUFBTTtZQUNwQixTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7WUFDMUIsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO1lBQzFCLE1BQU0sRUFBRSxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ3ZDLGVBQWUsRUFBRSxLQUFLLENBQUMsZUFBZTtZQUN0QyxNQUFNLEVBQUUsS0FBSyxDQUFDLE1BQU07WUFDcEIsYUFBYSxFQUFFLEtBQUssQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLFlBQVk7WUFDdkUsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLGVBQWUsRUFBRSxLQUFLLENBQUMsZUFBZTtZQUN0QyxLQUFLLEVBQUUsS0FBSyxDQUFDLEtBQUs7WUFDbEIsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO1lBQ2hDLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxVQUFVO1lBQzVELFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztZQUM5QixZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7WUFDaEMsZUFBZSxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ3RDLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtZQUM1QixxQkFBcUIsRUFBRSxLQUFLLENBQUMscUJBQXFCO1NBQ3JELEVBQUUsZ0NBQWdDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQ3BGLElBQUksQ0FBQyxRQUFRLEdBQUcsbUJBQW1CLENBQUM7UUFDcEMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLG1CQUFtQixDQUFDLGdCQUFnQixDQUFDO1FBQzdELElBQUksQ0FBQyxvQkFBb0IsR0FBRyxtQkFBbUIsQ0FBQyxvQkFBb0IsQ0FBQztRQUNyRSxJQUFJLENBQUMsV0FBVyxHQUFHLG1CQUFtQixDQUFDLFdBQVcsQ0FBQztJQUN2RCxDQUFDO0NBQ0o7QUF6REQsNENBeURDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcm9zIGZyb20gJ0BhbGljbG91ZC9yb3MtY2RrLWNvcmUnO1xyXG5pbXBvcnQgeyBSb3NTaGFyZGluZ0luc3RhbmNlIH0gZnJvbSAnLi9tb25nb2RiLmdlbmVyYXRlZCc7XHJcbi8vIEdlbmVyYXRlZCBmcm9tIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgU3BlY2lmaWNhdGlvblxyXG5leHBvcnQgeyBSb3NTaGFyZGluZ0luc3RhbmNlIGFzIFNoYXJkaW5nSW5zdGFuY2VQcm9wZXJ0eSB9O1xyXG5cclxuLyoqXHJcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYEFMSVlVTjo6TU9OR09EQjo6U2hhcmRpbmdJbnN0YW5jZWBcclxuICovXHJcbmV4cG9ydCBpbnRlcmZhY2UgU2hhcmRpbmdJbnN0YW5jZVByb3BzIHtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBjb25maWdTZXJ2ZXI6XHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGNvbmZpZ1NlcnZlcjogQXJyYXk8Um9zU2hhcmRpbmdJbnN0YW5jZS5Db25maWdTZXJ2ZXJQcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGU7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgbW9uZ29zOlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBtb25nb3M6IEFycmF5PFJvc1NoYXJkaW5nSW5zdGFuY2UuTW9uZ29zUHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHJlcGxpY2FTZXQ6XHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHJlcGxpY2FTZXQ6IEFycmF5PFJvc1NoYXJkaW5nSW5zdGFuY2UuUmVwbGljYVNldFByb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlPiB8IHJvcy5JUmVzb2x2YWJsZTtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBhY2NvdW50UGFzc3dvcmQ6IFJvb3QgYWNjb3VudCBwYXNzd29yZCwgY2FuIGNvbnRhaW4gdGhlIGxldHRlcnMsIG51bWJlcnMgb3IgdW5kZXJzY29yZXMgdGhlIGNvbXBvc2l0aW9uLCBsZW5ndGggb2YgNn4zMiBiaXQuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGFjY291bnRQYXNzd29yZD86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBhdXRvUmVuZXc6IEluZGljYXRlcyB3aGV0aGVyIGF1dG9tYXRpYyByZW5ld2FsIGlzIGVuYWJsZWQgZm9yIHRoZSBpbnN0YW5jZS4gVmFsaWQgdmFsdWVzOnRydWU6IEF1dG9tYXRpYyByZW5ld2FsIGlzIGVuYWJsZWQuZmFsc2U6IEF1dG9tYXRpYyByZW5ld2FsIGlzIG5vdCBlbmFibGVkLiBZb3UgbXVzdCByZW5ldyB0aGUgaW5zdGFuY2UgbWFudWFsbHkuRGVmYXVsdCB2YWx1ZTogZmFsc2UuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGF1dG9SZW5ldz86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgY2hhcmdlVHlwZTogVGhlIGJpbGxpbmcgbWV0aG9kIG9mIHRoZSBpbnN0YW5jZS52YWx1ZXM6UG9zdFBhaWQ6IFBheS1Bcy1Zb3UtR28uUHJlUGFpZDogU3Vic2NyaXB0aW9uLkRlZmF1bHQgdmFsdWU6IFBvc3RQYWlkXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGNoYXJnZVR5cGU/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgZGJJbnN0YW5jZURlc2NyaXB0aW9uOiBEZXNjcmlwdGlvbiBvZiBjcmVhdGVkIGRhdGFiYXNlIGluc3RhbmNlLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBkYkluc3RhbmNlRGVzY3JpcHRpb24/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgZW5naW5lVmVyc2lvbjogRGF0YWJhc2UgaW5zdGFuY2UgdmVyc2lvbi5TdXBwb3J0IDMuNCwgNC4wLCA0LjJcclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgZW5naW5lVmVyc2lvbj86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBuZXR3b3JrVHlwZTogVGhlIGluc3RhbmNlIG5ldHdvcmsgdHlwZS4gU3VwcG9ydCAnQ0xBU1NJQycgYW5kICdWUEMnIG9ubHksIGRlZmF1bHQgaXMgJ0NMQVNTSUMnLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBuZXR3b3JrVHlwZT86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBwZXJpb2Q6IFRoZSBzdWJzY3JpcHRpb24gcGVyaW9kIG9mIHRoZSBpbnN0YW5jZS5EZWZhdWx0IFVuaXQ6IE1vbnRoLlZhbGlkIHZhbHVlczogWzF+OV0sIDEyLCAyNCwgMzYuIERlZmF1bHQgdG8gMS5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgcGVyaW9kPzogbnVtYmVyO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHByb3RvY29sVHlwZTogUHJvdG9jb2wgdHlwZS4gVmFsaWQgdmFsdWU6IG1vbmdvZGIgb3IgZHluYW1vZGIuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHByb3RvY29sVHlwZT86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSByZXN0b3JlVGltZTogVGhlIHRpbWUgdG8gcmVzdG9yZSB0aGUgY2xvbmVkIGluc3RhbmNlIHRvLiBUaGUgZm9ybWF0IGlzIHl5eXktTU0tZGRUSEg6bW06c3NaLlRoaXMgcGFyYW1ldGVyIGNhbiBvbmx5IGJlIHNwZWNpZmllZCB3aGVuIHRoaXMgb3BlcmF0aW9uIGlzIGNhbGxlZCB0byBjbG9uZSBpbnN0YW5jZXMuWW91IG11c3QgYWxzbyBzcGVjaWZ5IHRoZVNyY0RCSW5zdGFuY2VJZHBhcmFtZXRlciBhbmQgdGhlQmFja3VwSWRwYXJhbWV0ZXIuWW91IGNhbiBjbG9uZSBpbnN0YW5jZXMgdG8gYW55IHJlc3RvcmUgdGltZSBpbiB0aGUgcGFzdCBzZXZlbiBkYXlzLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSByZXN0b3JlVGltZT86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBzZWN1cml0eUlwQXJyYXk6IFNlY3VyaXR5IGlwcyB0byBhZGQgb3IgcmVtb3ZlLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBzZWN1cml0eUlwQXJyYXk/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgc3JjRGJJbnN0YW5jZUlkOiBDcmVhdGUgYW4gaW5zdGFuY2Ugb2YgdGhlIGJhY2t1cCBzZXQgYmFzZWQgb24gYW4gaW5zdGFuY2UuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHNyY0RiSW5zdGFuY2VJZD86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBzdG9yYWdlRW5naW5lOiBEYXRhYmFzZSBzdG9yYWdlIGVuZ2luZS5TdXBwb3J0IFdpcmVkVGlnZXIsIFJvY2tzREIsIFRlcmFya0RCXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHN0b3JhZ2VFbmdpbmU/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgdnBjSWQ6IFRoZSBWUEMgaWQgdG8gY3JlYXRlIG1vbmdvZGIgaW5zdGFuY2UuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHZwY0lkPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHZTd2l0Y2hJZDogVGhlIHZTd2l0Y2ggSWQgdG8gY3JlYXRlIG1vbmdvZGIgaW5zdGFuY2UuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHZTd2l0Y2hJZD86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSB6b25lSWQ6IE9uIHdoaWNoIHpvbmUgdG8gY3JlYXRlIHRoZSBpbnN0YW5jZS4gSWYgVnBjSWQgYW5kIFZTd2l0Y2hJZCBpcyBzcGVjaWZpZWQsIFpvbmVJZCBpcyByZXF1aXJlZCBhbmQgVlN3aXRjaCBzaG91bGQgYmUgaW4gc2FtZSB6b25lLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSB6b25lSWQ/OiBzdHJpbmc7XHJcbn1cclxuXHJcbi8qKlxyXG4gKiBBIFJPUyByZXNvdXJjZSB0eXBlOiAgYEFMSVlVTjo6TU9OR09EQjo6U2hhcmRpbmdJbnN0YW5jZWBcclxuICovXHJcbmV4cG9ydCBjbGFzcyBTaGFyZGluZ0luc3RhbmNlIGV4dGVuZHMgcm9zLlJlc291cmNlIHtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcclxuICAgICAqIGNvbnRhaW5pbmcgdGhlIHByb3BlcnRpZXMgb2YgdGhpcyBST1MgcmVzb3VyY2UsIHdoaWNoIHdpbGwgYmUgYXNzaWduZWQgdG8gUk9TIHJlc291cmNlLlxyXG4gICAgICovXHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAQXR0cmlidXRlIERCSW5zdGFuY2VJZDogVGhlIGluc3RhbmNlIGlkIG9mIGNyZWF0ZWQgbW9uZ29kYiBpbnN0YW5jZS5cclxuICAgICAqL1xyXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJEYkluc3RhbmNlSWQ6IGFueTtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBBdHRyaWJ1dGUgREJJbnN0YW5jZVN0YXR1czogU3RhdHVzIG9mIG1vbmdvZGIgaW5zdGFuY2UuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyByZWFkb25seSBhdHRyRGJJbnN0YW5jZVN0YXR1czogYW55O1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQEF0dHJpYnV0ZSBPcmRlcklkOiBPcmRlciBJZCBvZiBjcmVhdGVkIGluc3RhbmNlLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ck9yZGVySWQ6IGFueTtcclxuXHJcbiAgICAvKipcclxuICAgICAqIENyZWF0ZSBhIG5ldyBgQUxJWVVOOjpNT05HT0RCOjpTaGFyZGluZ0luc3RhbmNlYC5cclxuICAgICAqXHJcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcclxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcclxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcclxuICAgICAqL1xyXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBTaGFyZGluZ0luc3RhbmNlUHJvcHMsIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OmJvb2xlYW4gPSB0cnVlKSB7XHJcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcclxuXHJcbiAgICAgICAgY29uc3Qgcm9zU2hhcmRpbmdJbnN0YW5jZSA9IG5ldyBSb3NTaGFyZGluZ0luc3RhbmNlKHRoaXMsIGlkLCAge1xyXG4gICAgICAgICAgICBlbmdpbmVWZXJzaW9uOiBwcm9wcy5lbmdpbmVWZXJzaW9uID8gcHJvcHMuZW5naW5lVmVyc2lvbiA6ICczLjQnLFxyXG4gICAgICAgICAgICB6b25lSWQ6IHByb3BzLnpvbmVJZCxcclxuICAgICAgICAgICAgYXV0b1JlbmV3OiBwcm9wcy5hdXRvUmVuZXcsXHJcbiAgICAgICAgICAgIHZTd2l0Y2hJZDogcHJvcHMudlN3aXRjaElkLFxyXG4gICAgICAgICAgICBwZXJpb2Q6IHByb3BzLnBlcmlvZCA/IHByb3BzLnBlcmlvZCA6IDEsXHJcbiAgICAgICAgICAgIHNlY3VyaXR5SXBBcnJheTogcHJvcHMuc2VjdXJpdHlJcEFycmF5LFxyXG4gICAgICAgICAgICBtb25nb3M6IHByb3BzLm1vbmdvcyxcclxuICAgICAgICAgICAgc3RvcmFnZUVuZ2luZTogcHJvcHMuc3RvcmFnZUVuZ2luZSA/IHByb3BzLnN0b3JhZ2VFbmdpbmUgOiAnV2lyZWRUaWdlcicsXHJcbiAgICAgICAgICAgIHJlc3RvcmVUaW1lOiBwcm9wcy5yZXN0b3JlVGltZSxcclxuICAgICAgICAgICAgYWNjb3VudFBhc3N3b3JkOiBwcm9wcy5hY2NvdW50UGFzc3dvcmQsXHJcbiAgICAgICAgICAgIHZwY0lkOiBwcm9wcy52cGNJZCxcclxuICAgICAgICAgICAgcHJvdG9jb2xUeXBlOiBwcm9wcy5wcm90b2NvbFR5cGUsXHJcbiAgICAgICAgICAgIGNoYXJnZVR5cGU6IHByb3BzLmNoYXJnZVR5cGUgPyBwcm9wcy5jaGFyZ2VUeXBlIDogJ1Bvc3RQYWlkJyxcclxuICAgICAgICAgICAgbmV0d29ya1R5cGU6IHByb3BzLm5ldHdvcmtUeXBlLFxyXG4gICAgICAgICAgICBjb25maWdTZXJ2ZXI6IHByb3BzLmNvbmZpZ1NlcnZlcixcclxuICAgICAgICAgICAgc3JjRGJJbnN0YW5jZUlkOiBwcm9wcy5zcmNEYkluc3RhbmNlSWQsXHJcbiAgICAgICAgICAgIHJlcGxpY2FTZXQ6IHByb3BzLnJlcGxpY2FTZXQsXHJcbiAgICAgICAgICAgIGRiSW5zdGFuY2VEZXNjcmlwdGlvbjogcHJvcHMuZGJJbnN0YW5jZURlc2NyaXB0aW9uLFxyXG4gICAgICAgIH0sIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50ICYmIHRoaXMuc3RhY2suZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpO1xyXG4gICAgICAgIHRoaXMucmVzb3VyY2UgPSByb3NTaGFyZGluZ0luc3RhbmNlO1xyXG4gICAgICAgIHRoaXMuYXR0ckRiSW5zdGFuY2VJZCA9IHJvc1NoYXJkaW5nSW5zdGFuY2UuYXR0ckRiSW5zdGFuY2VJZDtcclxuICAgICAgICB0aGlzLmF0dHJEYkluc3RhbmNlU3RhdHVzID0gcm9zU2hhcmRpbmdJbnN0YW5jZS5hdHRyRGJJbnN0YW5jZVN0YXR1cztcclxuICAgICAgICB0aGlzLmF0dHJPcmRlcklkID0gcm9zU2hhcmRpbmdJbnN0YW5jZS5hdHRyT3JkZXJJZDtcclxuICAgIH1cclxufVxyXG4iXX0=