# Generated by Django 4.1 on 2022-09-01 10:47

import functools

import django.db.models.deletion
import picklefield.fields
from django.conf import settings
from django.db import migrations, models

import import_export_extensions.models.core
import import_export_extensions.models.tools


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="ImportJob",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    import_export_extensions.models.core.CreationDateTimeField(
                        auto_now=True, verbose_name="Created",
                    ),
                ),
                (
                    "modified",
                    import_export_extensions.models.core.ModificationDateTimeField(
                        auto_now=True, verbose_name="Modified",
                    ),
                ),
                (
                    "import_status",
                    models.CharField(
                        choices=[
                            ("CREATED", "Created"),
                            ("PARSING", "Parsing"),
                            ("PARSED", "Parsed"),
                            ("INPUT_ERROR", "Input data error"),
                            ("PARSE_ERROR", "Parse error"),
                            ("CONFIRMED", "Import confirmed"),
                            ("IMPORTING", "Importing"),
                            ("IMPORTED", "Imported"),
                            ("IMPORT_ERROR", "Import error"),
                            ("CANCELLED", "Cancelled"),
                        ],
                        default="CREATED",
                        max_length=20,
                        verbose_name="Job status",
                    ),
                ),
                (
                    "resource_path",
                    models.CharField(
                        help_text="Dotted path to subclass of `import_export.Resource` that should be used for import",
                        max_length=128,
                        verbose_name="Resource class path",
                    ),
                ),
                (
                    "data_file",
                    models.FileField(
                        help_text="File that contain data to be imported",
                        max_length=512,
                        upload_to=functools.partial(
                            import_export_extensions.models.tools.upload_file_to,
                            *(),
                            **{"main_folder_name": "import"}
                        ),
                        verbose_name="Data file",
                    ),
                ),
                (
                    "resource_kwargs",
                    models.JSONField(
                        default=dict,
                        help_text="Keyword parameters required for resource initialization",
                        verbose_name="Resource kwargs",
                    ),
                ),
                (
                    "traceback",
                    models.TextField(
                        blank=True,
                        default=str,
                        help_text="Python traceback in case of parse/import error",
                        verbose_name="Traceback",
                    ),
                ),
                (
                    "error_message",
                    models.CharField(
                        blank=True,
                        default=str,
                        help_text="Python error message in case of parse/import error",
                        max_length=128,
                        verbose_name="Error message",
                    ),
                ),
                (
                    "result",
                    picklefield.fields.PickledObjectField(
                        default=str,
                        editable=False,
                        help_text="Internal import result object that contain info about import statistics. Pickled Python object",
                        verbose_name="Import result",
                    ),
                ),
                (
                    "parse_task_id",
                    models.CharField(
                        default=str,
                        help_text="Celery task ID that start `parse_data`",
                        max_length=36,
                        verbose_name="Parsing task ID",
                    ),
                ),
                (
                    "import_task_id",
                    models.CharField(
                        default=str,
                        help_text="Celery task ID that start `import_data`",
                        max_length=36,
                        verbose_name="Import task ID",
                    ),
                ),
                (
                    "parse_finished",
                    models.DateTimeField(
                        editable=False, null=True, verbose_name="Parse finished",
                    ),
                ),
                (
                    "import_started",
                    models.DateTimeField(
                        editable=False, null=True, verbose_name="Import started",
                    ),
                ),
                (
                    "import_finished",
                    models.DateTimeField(
                        editable=False,
                        null=True,
                        verbose_name="Import finished",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        editable=False,
                        help_text="User which started import",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Created by",
                    ),
                ),
            ],
            options={
                "verbose_name": "Import job",
                "verbose_name_plural": "Import jobs",
            },
        ),
        migrations.CreateModel(
            name="ExportJob",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    import_export_extensions.models.core.CreationDateTimeField(
                        auto_now=True, verbose_name="Created",
                    ),
                ),
                (
                    "modified",
                    import_export_extensions.models.core.ModificationDateTimeField(
                        auto_now=True, verbose_name="Modified",
                    ),
                ),
                (
                    "export_status",
                    models.CharField(
                        choices=[
                            ("CREATED", "Created"),
                            ("EXPORTING", "Exporting"),
                            ("EXPORT_ERROR", "Export Error"),
                            ("EXPORTED", "Exported"),
                        ],
                        default="CREATED",
                        max_length=20,
                        verbose_name="Job status",
                    ),
                ),
                (
                    "resource_path",
                    models.CharField(
                        help_text="Dotted path to subclass of `import_export.Resource` that should be used for export",
                        max_length=128,
                        verbose_name="Resource class path",
                    ),
                ),
                (
                    "file_format_path",
                    models.CharField(
                        help_text="Export file format as path to base_formats class",
                        max_length=128,
                        verbose_name="Export path to class",
                    ),
                ),
                (
                    "data_file",
                    models.FileField(
                        help_text="File that contain exported data",
                        max_length=512,
                        upload_to=functools.partial(
                            import_export_extensions.models.tools.upload_file_to,
                            *(),
                            **{"main_folder_name": "export"}
                        ),
                        verbose_name="Data file",
                    ),
                ),
                (
                    "resource_kwargs",
                    models.JSONField(
                        default=dict,
                        help_text="Keyword parameters required for resource initialization",
                        verbose_name="Resource kwargs",
                    ),
                ),
                (
                    "traceback",
                    models.TextField(
                        blank=True,
                        default=str,
                        help_text="Python traceback in case of export error",
                        verbose_name="Traceback",
                    ),
                ),
                (
                    "error_message",
                    models.CharField(
                        blank=True,
                        default=str,
                        help_text="Python error message in case of export error",
                        max_length=128,
                        verbose_name="Error message",
                    ),
                ),
                (
                    "result",
                    picklefield.fields.PickledObjectField(
                        default=str,
                        editable=False,
                        help_text="Internal export result object that contain info about export statistics. Pickled Python object",
                        verbose_name="Export result",
                    ),
                ),
                (
                    "export_task_id",
                    models.CharField(
                        blank=True,
                        help_text="Celery task ID that start `export_data`",
                        max_length=36,
                        null=True,
                        verbose_name="Export task ID",
                    ),
                ),
                (
                    "export_started",
                    models.DateTimeField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Export started",
                    ),
                ),
                (
                    "export_finished",
                    models.DateTimeField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="Export finished",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        editable=False,
                        help_text="User which started export",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Created by",
                    ),
                ),
            ],
            options={
                "verbose_name": "Export job",
                "verbose_name_plural": "Export jobs",
            },
        ),
    ]
