# xrd_xy_parser

_xrd_xy_parser_ is parser of xy file from X-ray diffraction.<br>
Python ver >= 3.10


## installation

```sh
pip install xrd_xy_parser
```
or
```sh
pip3 install xrd_xy_parser
```
 
## how to use
```python
from xrd_xy_parser import xy

if __name__ == "__main__":

    try:
        header, body, footer = xy.readstr("examples/example.xy")
        print("header:{}\n" "body:{}\n" "footer:{}\n".format(header, body, footer))

    except xy.ParseError as e:
        print(e)
```

## xy file structure

xy file is not explicitly specified.<br>
xy file consists from `header`,`body`,`footer` parts.<br>
`header` includes some infomation,
`body` is float list.
`footer` is empty or consists from `\s` ,`\t` ,`\r\n`,`\n`.

```xy
<301.15K> \\header
Wavelength = 1.54059 \\header
26.78	11598.00 \\body
26.8	10786.00
26.82	5768.00
26.84	1149.00
26.86	255.00
26.88	74.00
26.9	52.00
26.92	30.00
26.94	19.00 \\body
\\ footer
```