"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineAnchoreInlineScanAction = void 0;
const aws_codebuild_1 = require("@aws-cdk/aws-codebuild");
const aws_codepipeline_1 = require("@aws-cdk/aws-codepipeline");
const aws_codepipeline_actions_1 = require("@aws-cdk/aws-codepipeline-actions");
const aws_iam_1 = require("@aws-cdk/aws-iam");
class CodePipelineAnchoreInlineScanAction extends aws_codepipeline_actions_1.Action {
    constructor(props) {
        super({
            ...props,
            category: aws_codepipeline_1.ActionCategory.TEST,
            provider: 'CodeBuild',
            artifactBounds: {
                minInputs: 1,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [props.input],
        });
        this.props = props;
    }
    bound(scope, _stage, options) {
        var _a, _b, _c;
        const buildImage = aws_codebuild_1.LinuxBuildImage.STANDARD_4_0;
        const version = (_a = this.props.version) !== null && _a !== void 0 ? _a : 'v0.7.2';
        const timeout = (_b = this.props.timeout) !== null && _b !== void 0 ? _b : 300;
        const policyBundlePath = (_c = this.props.policyBundlePath) !== null && _c !== void 0 ? _c : './policy_bundle.json';
        const url = `https://ci-tools.anchore.io/inline_scan-${version}`;
        const project = new aws_codebuild_1.PipelineProject(scope, 'VulnScanProject', {
            cache: aws_codebuild_1.Cache.local(aws_codebuild_1.LocalCacheMode.DOCKER_LAYER),
            environment: {
                buildImage,
                computeType: this.props.computeType || buildImage.defaultComputeType,
                privileged: true,
            },
            buildSpec: aws_codebuild_1.BuildSpec.fromObject({
                version: '0.2',
                phases: {
                    pre_build: {
                        commands: [
                            'echo Build started on `date`',
                            'docker build -t image2scan:ci .',
                            'echo Build completed on `date`',
                        ],
                    },
                    build: {
                        commands: [
                            'echo Scan started on `date`',
                            `curl -s ${url} | if [ -f "${policyBundlePath}" ]; then bash -s -- -f -t ${timeout} -b ${policyBundlePath} image2scan:ci; else bash -s -- -f -t ${timeout} image2scan:ci; fi`,
                            'echo Scan completed on `date`',
                        ],
                    },
                },
            }),
        });
        // grant the Pipeline role the required permissions to this Project
        options.role.addToPolicy(new aws_iam_1.PolicyStatement({
            resources: [project.projectArn],
            actions: [
                'codebuild:BatchGetBuilds',
                'codebuild:StartBuild',
                'codebuild:StopBuild',
            ],
        }));
        // allow the Project access to the Pipeline's artifact Bucket
        // but only if the project is not imported
        // (ie., has a role) - otherwise, the IAM library throws an error
        if (project.role) {
            options.bucket.grantRead(project);
        }
        return {
            configuration: {
                ProjectName: project.projectName,
            },
        };
    }
}
exports.CodePipelineAnchoreInlineScanAction = CodePipelineAnchoreInlineScanAction;
//# sourceMappingURL=data:application/json;base64,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