/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.auth;

import com.datapps.linkoopdb.jdbc.lib.FrameworkLogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

public class AuthUtils {
    private static FrameworkLogger logger = FrameworkLogger.getLog(AuthUtils.class);

    private AuthUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getInitialSchema(Connection c) throws SQLException {
        Statement st = c.createStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery("SELECT initial_schema FROM information_schema.system_users\nWHERE user_name = current_user");
            if (!rs.next()) {
                throw new IllegalStateException("Failed to retrieve initial_schema for current user");
            }
            String string = rs.getString(1);
            return string;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {
                    logger.error("Failed to close ResultSet for retrieving initial schema");
                }
            }
            rs = null;
            try {
                st.close();
            }
            catch (SQLException se) {
                logger.error("Failed to close Statement for retrieving db name");
            }
            st = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set getEnabledRoles(Connection c) throws SQLException {
        HashSet<String> roles = new HashSet<String>();
        Statement st = c.createStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery("SELECT * FROM information_schema.enabled_roles");
            while (rs.next()) {
                roles.add(rs.getString(1));
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {
                    logger.error("Failed to close ResultSet for retrieving db name");
                }
            }
            rs = null;
            try {
                st.close();
            }
            catch (SQLException se) {
                logger.error("Failed to close Statement for retrieving db name");
            }
            st = null;
        }
        return roles;
    }
}

