#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['pyprocessors_pseudonimizer']

package_data = \
{'': ['*']}

install_requires = \
['pymultirole_plugins>=0.5.0,<0.6.0',
 'collections_extended',
 'unidecode',
 'presidio_anonymizer>=2.2.29']

extras_require = \
{'dev': ['flit', 'pre-commit', 'bump2version'],
 'docs': ['sphinx',
          'sphinx-rtd-theme',
          'm2r2',
          'sphinxcontrib.apidoc',
          'jupyter_sphinx'],
 'test': ['pytest',
          'pytest-cov',
          'pytest-flake8',
          'pytest-black',
          'flake8==3.9.2',
          'tox',
          'dirty-equals']}

entry_points = \
{'pyprocessors.plugins': ['pseudonimizer = '
                          'pyprocessors_pseudonimizer.pseudonimizer:PseudonimizerProcessor']}

setup(name='pyprocessors-pseudonimizer',
      version='0.5.0',
      description='Sherpa git initpseudonimizer',
      author='Olivier Terrier',
      author_email='olivier.terrier@kairntech.com',
      url='https://kairntech.com/',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.8',
     )
