# AUTOGENERATED! DO NOT EDIT! File to edit: 02_video2picture.ipynb (unless otherwise specified).

__all__ = ['gdown_unzip', 'get_images_from_video']

# Cell
import gdown
from zipfile import ZipFile
from PIL import Image
import sys
import os
import cv2

def gdown_unzip(id, filename):
    """download a zipfile and unzip it under data directory
    """
    dataset_url = 'https://drive.google.com/u/1/uc?id=' + id
    dataset_name = filename

    if not os.path.isdir(dataset_name):
        gdown.download(dataset_url, output = dataset_name + '.zip', quiet=False)
        zip_file = ZipFile( dataset_name + '.zip')
        #zip_file.extractall()
        zip_file.extractall() # depends on how to zip it
        zip_file.close()

# Cell
def get_images_from_video(video_name, time_F):
    video_images = []
    vc = cv2.VideoCapture(video_name)
    c = 1

    if vc.isOpened():
        rval, video_frame = vc.read()
    else:
        rval = False

    while rval:
        rval, video_frame = vc.read()

        if(c % time_F == 0):
            video_images.append(video_frame)
        c = c + 1
    vc.release()

    return video_images