/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.asn1.der;

import com.teradata.tdgss.asn1.der.DERASN1Type;
import com.teradata.tdgss.asn1.der.DERException;
import com.teradata.tdgss.asn1.der.DERLength;
import com.teradata.tdgss.asn1.der.DERTag;
import com.teradata.tdgss.asn1.der.DERUniversalTagOctets;
import com.teradata.tdgss.logging.TdgssLogger;
import com.teradata.tdgss.logging.TdgssLoggingManager;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

class DERObjectIdentifier
extends DERASN1Type {
    private static final TdgssLogger logger = TdgssLoggingManager.getInstance().getLogger();
    private Oid oidval;

    DERObjectIdentifier(Oid oid) {
        this.oidval = oid;
        this.octets = DERObjectIdentifier.calcOctets(this.oidval);
    }

    DERObjectIdentifier(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    DERObjectIdentifier(byte[] byArray, boolean bl) {
        this(byArray, 0, byArray.length, bl);
    }

    DERObjectIdentifier(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, true);
    }

    DERObjectIdentifier(byte[] byArray, int n, int n2, boolean bl) {
        this.parse(byArray, n, n2, bl);
    }

    protected void parse(byte[] byArray, int n, int n2, boolean bl) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new DERException("Illegal values are passed.");
        }
        if (bl) {
            this.octets = new byte[n2];
            System.arraycopy(byArray, n, this.octets, 0, n2);
        } else {
            this.parseExplicitOctets(byArray, n);
        }
        this.oidval = this.getValueOf(this.octets);
    }

    byte[] getUniveralTagOctets() {
        return DERUniversalTagOctets.OBJECT_IDENTIFIER;
    }

    private static byte[] calcOctets(Oid oid) {
        byte[] byArray = null;
        try {
            byArray = oid.getDER();
        }
        catch (GSSException gSSException) {
            logger.error(gSSException.getMessage());
            throw new IllegalArgumentException();
        }
        DERTag dERTag = new DERTag(byArray);
        DERLength dERLength = new DERLength(byArray, dERTag.size());
        int n = byArray.length - dERTag.size() - dERLength.size();
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, dERTag.size() + dERLength.size(), byArray2, 0, n);
        return byArray2;
    }

    private Oid getValueOf(byte[] byArray) {
        try {
            int n = 0;
            byte[] byArray2 = this.getUniveralTagOctets();
            DERLength dERLength = new DERLength(byArray.length);
            byte[] byArray3 = dERLength.getLengthOctets();
            byte[] byArray4 = new byte[byArray2.length + byArray3.length + byArray.length];
            System.arraycopy(byArray2, n, byArray4, n, byArray2.length);
            System.arraycopy(byArray3, n, byArray4, byArray2.length, byArray3.length);
            System.arraycopy(byArray, n, byArray4, byArray2.length + byArray3.length, byArray.length);
            return new Oid(byArray4);
        }
        catch (GSSException gSSException) {
            logger.error(gSSException.getMessage());
            throw new IllegalArgumentException();
        }
    }

    protected final boolean isConstructed() {
        return false;
    }

    Oid getValue() {
        return this.oidval;
    }
}

