/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CryptoMetadata;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SQLServerResultSetMetaData
implements ResultSetMetaData {
    private SQLServerConnection con;
    private final SQLServerResultSet rs;
    public int nBeforeExecuteCols;
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerResultSetMetaData");
    private static int baseID = 0;
    private final String traceID = " SQLServerResultSetMetaData:" + SQLServerResultSetMetaData.nextInstanceID();

    private static synchronized int nextInstanceID() {
        return ++baseID;
    }

    public final String toString() {
        return this.traceID;
    }

    SQLServerResultSetMetaData(SQLServerConnection sQLServerConnection, SQLServerResultSet sQLServerResultSet) {
        this.con = sQLServerConnection;
        this.rs = sQLServerResultSet;
        assert (sQLServerResultSet != null);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString() + " created by (" + sQLServerResultSet.toString() + ")");
        }
    }

    private void checkClosed() throws SQLServerException {
        this.rs.checkClosed();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public String getCatalogName(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getTableName().getDatabaseName();
    }

    @Override
    public int getColumnCount() throws SQLServerException {
        this.checkClosed();
        if (this.rs == null) {
            return 0;
        }
        return this.rs.getColumnCount();
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLServerException {
        this.checkClosed();
        CryptoMetadata cryptoMetadata = this.rs.getColumn(n).getCryptoMetadata();
        if (null != cryptoMetadata) {
            return cryptoMetadata.getBaseTypeInfo().getDisplaySize();
        }
        return this.rs.getColumn(n).getTypeInfo().getDisplaySize();
    }

    @Override
    public String getColumnLabel(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getColumnName();
    }

    @Override
    public String getColumnName(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getColumnName();
    }

    @Override
    public int getColumnType(int n) throws SQLServerException {
        this.checkClosed();
        TypeInfo typeInfo = this.rs.getColumn(n).getTypeInfo();
        CryptoMetadata cryptoMetadata = this.rs.getColumn(n).getCryptoMetadata();
        if (null != cryptoMetadata) {
            typeInfo = cryptoMetadata.getBaseTypeInfo();
        }
        JDBCType jDBCType = typeInfo.getSSType().getJDBCType();
        int n2 = jDBCType.asJavaSqlType();
        if (this.con.isKatmaiOrLater()) {
            SSType sSType = typeInfo.getSSType();
            switch (sSType) {
                case VARCHARMAX: {
                    n2 = SSType.VARCHAR.getJDBCType().asJavaSqlType();
                    break;
                }
                case NVARCHARMAX: {
                    n2 = SSType.NVARCHAR.getJDBCType().asJavaSqlType();
                    break;
                }
                case VARBINARYMAX: {
                    n2 = SSType.VARBINARY.getJDBCType().asJavaSqlType();
                    break;
                }
                case DATETIME: 
                case SMALLDATETIME: {
                    n2 = SSType.DATETIME2.getJDBCType().asJavaSqlType();
                    break;
                }
                case MONEY: 
                case SMALLMONEY: {
                    n2 = SSType.DECIMAL.getJDBCType().asJavaSqlType();
                    break;
                }
                case GUID: {
                    n2 = SSType.CHAR.getJDBCType().asJavaSqlType();
                    break;
                }
            }
        }
        return n2;
    }

    @Override
    public String getColumnTypeName(int n) throws SQLServerException {
        this.checkClosed();
        CryptoMetadata cryptoMetadata = this.rs.getColumn(n).getCryptoMetadata();
        if (null != cryptoMetadata) {
            return cryptoMetadata.getBaseTypeInfo().getSSTypeName();
        }
        return this.rs.getColumn(n).getTypeInfo().getSSTypeName();
    }

    @Override
    public int getPrecision(int n) throws SQLServerException {
        this.checkClosed();
        CryptoMetadata cryptoMetadata = this.rs.getColumn(n).getCryptoMetadata();
        if (null != cryptoMetadata) {
            return cryptoMetadata.getBaseTypeInfo().getPrecision();
        }
        return this.rs.getColumn(n).getTypeInfo().getPrecision();
    }

    @Override
    public int getScale(int n) throws SQLServerException {
        this.checkClosed();
        CryptoMetadata cryptoMetadata = this.rs.getColumn(n).getCryptoMetadata();
        if (null != cryptoMetadata) {
            return cryptoMetadata.getBaseTypeInfo().getScale();
        }
        return this.rs.getColumn(n).getTypeInfo().getScale();
    }

    @Override
    public String getSchemaName(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getTableName().getSchemaName();
    }

    @Override
    public String getTableName(int n) throws SQLServerException {
        this.checkClosed();
        return this.rs.getColumn(n).getTableName().getObjectName();
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLServerException {
        this.checkClosed();
        CryptoMetadata cryptoMetadata = this.rs.getColumn(n).getCryptoMetadata();
        if (null != cryptoMetadata) {
            return cryptoMetadata.getBaseTypeInfo().isIdentity();
        }
        return this.rs.getColumn(n).getTypeInfo().isIdentity();
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLServerException {
        this.checkClosed();
        CryptoMetadata cryptoMetadata = this.rs.getColumn(n).getCryptoMetadata();
        if (null != cryptoMetadata) {
            return cryptoMetadata.getBaseTypeInfo().isCaseSensitive();
        }
        return this.rs.getColumn(n).getTypeInfo().isCaseSensitive();
    }

    @Override
    public boolean isCurrency(int n) throws SQLServerException {
        this.checkClosed();
        SSType sSType = this.rs.getColumn(n).getTypeInfo().getSSType();
        CryptoMetadata cryptoMetadata = this.rs.getColumn(n).getCryptoMetadata();
        if (null != cryptoMetadata) {
            sSType = cryptoMetadata.getBaseTypeInfo().getSSType();
        }
        return SSType.MONEY == sSType || SSType.SMALLMONEY == sSType;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLServerException {
        this.checkClosed();
        CryptoMetadata cryptoMetadata = this.rs.getColumn(n).getCryptoMetadata();
        if (null != cryptoMetadata) {
            return TypeInfo.UPDATABLE_READ_WRITE == cryptoMetadata.getBaseTypeInfo().getUpdatability();
        }
        return TypeInfo.UPDATABLE_READ_WRITE == this.rs.getColumn(n).getTypeInfo().getUpdatability();
    }

    @Override
    public int isNullable(int n) throws SQLServerException {
        this.checkClosed();
        CryptoMetadata cryptoMetadata = this.rs.getColumn(n).getCryptoMetadata();
        if (null != cryptoMetadata) {
            return cryptoMetadata.getBaseTypeInfo().isNullable() ? 1 : 0;
        }
        return this.rs.getColumn(n).getTypeInfo().isNullable() ? 1 : 0;
    }

    @Override
    public boolean isReadOnly(int n) throws SQLServerException {
        this.checkClosed();
        CryptoMetadata cryptoMetadata = this.rs.getColumn(n).getCryptoMetadata();
        if (null != cryptoMetadata) {
            return TypeInfo.UPDATABLE_READ_ONLY == cryptoMetadata.getBaseTypeInfo().getUpdatability();
        }
        return TypeInfo.UPDATABLE_READ_ONLY == this.rs.getColumn(n).getTypeInfo().getUpdatability();
    }

    @Override
    public boolean isSearchable(int n) throws SQLServerException {
        this.checkClosed();
        SSType sSType = null;
        CryptoMetadata cryptoMetadata = this.rs.getColumn(n).getCryptoMetadata();
        sSType = null != cryptoMetadata ? cryptoMetadata.getBaseTypeInfo().getSSType() : this.rs.getColumn(n).getTypeInfo().getSSType();
        switch (sSType) {
            case IMAGE: 
            case TEXT: 
            case NTEXT: 
            case UDT: 
            case XML: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSigned(int n) throws SQLServerException {
        this.checkClosed();
        CryptoMetadata cryptoMetadata = this.rs.getColumn(n).getCryptoMetadata();
        if (null != cryptoMetadata) {
            return cryptoMetadata.getBaseTypeInfo().getSSType().getJDBCType().isSigned();
        }
        return this.rs.getColumn(n).getTypeInfo().getSSType().getJDBCType().isSigned();
    }

    public boolean isSparseColumnSet(int n) throws SQLServerException {
        this.checkClosed();
        CryptoMetadata cryptoMetadata = this.rs.getColumn(n).getCryptoMetadata();
        if (null != cryptoMetadata) {
            return cryptoMetadata.getBaseTypeInfo().isSparseColumnSet();
        }
        return this.rs.getColumn(n).getTypeInfo().isSparseColumnSet();
    }

    @Override
    public boolean isWritable(int n) throws SQLServerException {
        this.checkClosed();
        int n2 = -1;
        CryptoMetadata cryptoMetadata = this.rs.getColumn(n).getCryptoMetadata();
        n2 = null != cryptoMetadata ? cryptoMetadata.getBaseTypeInfo().getUpdatability() : this.rs.getColumn(n).getTypeInfo().getUpdatability();
        return TypeInfo.UPDATABLE_READ_WRITE == n2 || TypeInfo.UPDATABLE_UNKNOWN == n2;
    }

    @Override
    public String getColumnClassName(int n) throws SQLServerException {
        this.checkClosed();
        CryptoMetadata cryptoMetadata = this.rs.getColumn(n).getCryptoMetadata();
        if (null != cryptoMetadata) {
            return cryptoMetadata.getBaseTypeInfo().getSSType().getJDBCType().className();
        }
        return this.rs.getColumn(n).getTypeInfo().getSSType().getJDBCType().className();
    }
}

