/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.lib;

import java.io.IOException;
import java.io.InputStream;

public final class CountdownInputStream
extends InputStream {
    private long m_count;
    private InputStream m_input;

    public CountdownInputStream(InputStream is) {
        this.m_input = is;
    }

    @Override
    public int read() throws IOException {
        if (this.m_count <= 0L) {
            return -1;
        }
        int b = this.m_input.read();
        if (b >= 0) {
            --this.m_count;
        }
        return b;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        int r;
        if (buf == null) {
            throw new NullPointerException();
        }
        if (this.m_count <= 0L) {
            return -1;
        }
        int len = buf.length;
        if ((long)len > this.m_count) {
            len = (int)this.m_count;
        }
        if ((r = this.m_input.read(buf, 0, len)) > 0) {
            this.m_count -= (long)r;
        }
        return r;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int r;
        if (buf == null) {
            throw new NullPointerException();
        }
        if (this.m_count <= 0L) {
            return -1;
        }
        if ((long)len > this.m_count) {
            len = (int)this.m_count;
        }
        if ((r = this.m_input.read(buf, off, len)) > 0) {
            this.m_count -= (long)r;
        }
        return r;
    }

    @Override
    public void close() throws IOException {
        this.m_input.close();
    }

    @Override
    public int available() throws IOException {
        return Math.min(this.m_input.available(), (int)Math.min(Integer.MAX_VALUE, this.m_count));
    }

    @Override
    public long skip(long count) throws IOException {
        return count <= 0L ? 0L : this.m_input.skip(Math.min(this.m_count, count));
    }

    public long getCount() {
        return this.m_count;
    }

    public void setCount(long count) {
        this.m_count = count;
    }
}

